package storsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// CloudAppliancesClient is the client for the CloudAppliances methods of the Storsimple service.
type CloudAppliancesClient struct {
	BaseClient
}

// NewCloudAppliancesClient creates an instance of the CloudAppliancesClient client.
func NewCloudAppliancesClient(subscriptionID string) CloudAppliancesClient {
	return NewCloudAppliancesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCloudAppliancesClientWithBaseURI creates an instance of the CloudAppliancesClient client.
func NewCloudAppliancesClientWithBaseURI(baseURI string, subscriptionID string) CloudAppliancesClient {
	return CloudAppliancesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListSupportedConfigurations lists supported cloud appliance models and supported configurations.
// Parameters:
// resourceGroupName - the resource group name
// managerName - the manager name
func (client CloudAppliancesClient) ListSupportedConfigurations(ctx context.Context, resourceGroupName string, managerName string) (result CloudApplianceConfigurationList, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewError("storsimple.CloudAppliancesClient", "ListSupportedConfigurations", err.Error())
	}

	req, err := client.ListSupportedConfigurationsPreparer(ctx, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListSupportedConfigurationsPreparer prepares the ListSupportedConfigurations request.
func (client CloudAppliancesClient) ListSupportedConfigurationsPreparer(ctx context.Context, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/cloudApplianceConfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedConfigurationsSender sends the ListSupportedConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ListSupportedConfigurationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedConfigurationsResponder handles the response to the ListSupportedConfigurations request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ListSupportedConfigurationsResponder(resp *http.Response) (result CloudApplianceConfigurationList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Provision provisions cloud appliance.
// Parameters:
// parameters - the cloud appliance
// resourceGroupName - the resource group name
// managerName - the manager name
func (client CloudAppliancesClient) Provision(ctx context.Context, parameters CloudAppliance, resourceGroupName string, managerName string) (result CloudAppliancesProvisionFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.VnetRegion", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewError("storsimple.CloudAppliancesClient", "Provision", err.Error())
	}

	req, err := client.ProvisionPreparer(ctx, parameters, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "Provision", nil, "Failure preparing request")
		return
	}

	result, err = client.ProvisionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "Provision", result.Response(), "Failure sending request")
		return
	}

	return
}

// ProvisionPreparer prepares the Provision request.
func (client CloudAppliancesClient) ProvisionPreparer(ctx context.Context, parameters CloudAppliance, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/provisionCloudAppliance", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ProvisionSender sends the Provision request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ProvisionSender(req *http.Request) (future CloudAppliancesProvisionFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	return
}

// ProvisionResponder handles the response to the Provision request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ProvisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
