package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// AssessmentSizingCriterion enumerates the values for assessment sizing criterion.
type AssessmentSizingCriterion string

const (
	// AsOnPremises ...
	AsOnPremises AssessmentSizingCriterion = "AsOnPremises"
	// PerformanceBased ...
	PerformanceBased AssessmentSizingCriterion = "PerformanceBased"
)

// PossibleAssessmentSizingCriterionValues returns an array of possible values for the AssessmentSizingCriterion const type.
func PossibleAssessmentSizingCriterionValues() []AssessmentSizingCriterion {
	return []AssessmentSizingCriterion{AsOnPremises, PerformanceBased}
}

// AssessmentStage enumerates the values for assessment stage.
type AssessmentStage string

const (
	// Approved ...
	Approved AssessmentStage = "Approved"
	// InProgress ...
	InProgress AssessmentStage = "InProgress"
	// UnderReview ...
	UnderReview AssessmentStage = "UnderReview"
)

// PossibleAssessmentStageValues returns an array of possible values for the AssessmentStage const type.
func PossibleAssessmentStageValues() []AssessmentStage {
	return []AssessmentStage{Approved, InProgress, UnderReview}
}

// AssessmentStatus enumerates the values for assessment status.
type AssessmentStatus string

const (
	// Completed ...
	Completed AssessmentStatus = "Completed"
	// Created ...
	Created AssessmentStatus = "Created"
	// Invalid ...
	Invalid AssessmentStatus = "Invalid"
	// Running ...
	Running AssessmentStatus = "Running"
	// Updated ...
	Updated AssessmentStatus = "Updated"
)

// PossibleAssessmentStatusValues returns an array of possible values for the AssessmentStatus const type.
func PossibleAssessmentStatusValues() []AssessmentStatus {
	return []AssessmentStatus{Completed, Created, Invalid, Running, Updated}
}

// AzureDiskSize enumerates the values for azure disk size.
type AzureDiskSize string

const (
	// PremiumP10 ...
	PremiumP10 AzureDiskSize = "Premium_P10"
	// PremiumP20 ...
	PremiumP20 AzureDiskSize = "Premium_P20"
	// PremiumP30 ...
	PremiumP30 AzureDiskSize = "Premium_P30"
	// PremiumP4 ...
	PremiumP4 AzureDiskSize = "Premium_P4"
	// PremiumP40 ...
	PremiumP40 AzureDiskSize = "Premium_P40"
	// PremiumP50 ...
	PremiumP50 AzureDiskSize = "Premium_P50"
	// PremiumP6 ...
	PremiumP6 AzureDiskSize = "Premium_P6"
	// StandardS10 ...
	StandardS10 AzureDiskSize = "Standard_S10"
	// StandardS20 ...
	StandardS20 AzureDiskSize = "Standard_S20"
	// StandardS30 ...
	StandardS30 AzureDiskSize = "Standard_S30"
	// StandardS4 ...
	StandardS4 AzureDiskSize = "Standard_S4"
	// StandardS40 ...
	StandardS40 AzureDiskSize = "Standard_S40"
	// StandardS50 ...
	StandardS50 AzureDiskSize = "Standard_S50"
	// StandardS6 ...
	StandardS6 AzureDiskSize = "Standard_S6"
	// Unknown ...
	Unknown AzureDiskSize = "Unknown"
)

// PossibleAzureDiskSizeValues returns an array of possible values for the AzureDiskSize const type.
func PossibleAzureDiskSizeValues() []AzureDiskSize {
	return []AzureDiskSize{PremiumP10, PremiumP20, PremiumP30, PremiumP4, PremiumP40, PremiumP50, PremiumP6, StandardS10, StandardS20, StandardS30, StandardS4, StandardS40, StandardS50, StandardS6, Unknown}
}

// AzureDiskSuitabilityExplanation enumerates the values for azure disk suitability explanation.
type AzureDiskSuitabilityExplanation string

const (
	// AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported ...
	AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported AzureDiskSuitabilityExplanation = "DiskSizeGreaterThanSupported"
	// AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation ...
	AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation AzureDiskSuitabilityExplanation = "InternalErrorOccurredForDiskEvaluation"
	// AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy ...
	AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy AzureDiskSuitabilityExplanation = "NoDiskSizeFoundForSelectedRedundancy"
	// AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation ...
	AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation AzureDiskSuitabilityExplanation = "NoDiskSizeFoundInSelectedLocation"
	// AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops ...
	AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops AzureDiskSuitabilityExplanation = "NoSuitableDiskSizeForIops"
	// AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput ...
	AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput AzureDiskSuitabilityExplanation = "NoSuitableDiskSizeForThroughput"
	// AzureDiskSuitabilityExplanationNotApplicable ...
	AzureDiskSuitabilityExplanationNotApplicable AzureDiskSuitabilityExplanation = "NotApplicable"
	// AzureDiskSuitabilityExplanationUnknown ...
	AzureDiskSuitabilityExplanationUnknown AzureDiskSuitabilityExplanation = "Unknown"
)

// PossibleAzureDiskSuitabilityExplanationValues returns an array of possible values for the AzureDiskSuitabilityExplanation const type.
func PossibleAzureDiskSuitabilityExplanationValues() []AzureDiskSuitabilityExplanation {
	return []AzureDiskSuitabilityExplanation{AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported, AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation, AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy, AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation, AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops, AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput, AzureDiskSuitabilityExplanationNotApplicable, AzureDiskSuitabilityExplanationUnknown}
}

// AzureDiskType enumerates the values for azure disk type.
type AzureDiskType string

const (
	// AzureDiskTypePremium ...
	AzureDiskTypePremium AzureDiskType = "Premium"
	// AzureDiskTypeStandard ...
	AzureDiskTypeStandard AzureDiskType = "Standard"
	// AzureDiskTypeUnknown ...
	AzureDiskTypeUnknown AzureDiskType = "Unknown"
)

// PossibleAzureDiskTypeValues returns an array of possible values for the AzureDiskType const type.
func PossibleAzureDiskTypeValues() []AzureDiskType {
	return []AzureDiskType{AzureDiskTypePremium, AzureDiskTypeStandard, AzureDiskTypeUnknown}
}

// AzureHybridUseBenefit enumerates the values for azure hybrid use benefit.
type AzureHybridUseBenefit string

const (
	// AzureHybridUseBenefitNo ...
	AzureHybridUseBenefitNo AzureHybridUseBenefit = "No"
	// AzureHybridUseBenefitUnknown ...
	AzureHybridUseBenefitUnknown AzureHybridUseBenefit = "Unknown"
	// AzureHybridUseBenefitYes ...
	AzureHybridUseBenefitYes AzureHybridUseBenefit = "Yes"
)

// PossibleAzureHybridUseBenefitValues returns an array of possible values for the AzureHybridUseBenefit const type.
func PossibleAzureHybridUseBenefitValues() []AzureHybridUseBenefit {
	return []AzureHybridUseBenefit{AzureHybridUseBenefitNo, AzureHybridUseBenefitUnknown, AzureHybridUseBenefitYes}
}

// AzureLocation enumerates the values for azure location.
type AzureLocation string

const (
	// AzureLocationAustraliaEast ...
	AzureLocationAustraliaEast AzureLocation = "AustraliaEast"
	// AzureLocationAustraliaSoutheast ...
	AzureLocationAustraliaSoutheast AzureLocation = "AustraliaSoutheast"
	// AzureLocationBrazilSouth ...
	AzureLocationBrazilSouth AzureLocation = "BrazilSouth"
	// AzureLocationCanadaCentral ...
	AzureLocationCanadaCentral AzureLocation = "CanadaCentral"
	// AzureLocationCanadaEast ...
	AzureLocationCanadaEast AzureLocation = "CanadaEast"
	// AzureLocationCentralIndia ...
	AzureLocationCentralIndia AzureLocation = "CentralIndia"
	// AzureLocationCentralUs ...
	AzureLocationCentralUs AzureLocation = "CentralUs"
	// AzureLocationChinaEast ...
	AzureLocationChinaEast AzureLocation = "ChinaEast"
	// AzureLocationChinaNorth ...
	AzureLocationChinaNorth AzureLocation = "ChinaNorth"
	// AzureLocationEastAsia ...
	AzureLocationEastAsia AzureLocation = "EastAsia"
	// AzureLocationEastUs ...
	AzureLocationEastUs AzureLocation = "EastUs"
	// AzureLocationEastUs2 ...
	AzureLocationEastUs2 AzureLocation = "EastUs2"
	// AzureLocationGermanyCentral ...
	AzureLocationGermanyCentral AzureLocation = "GermanyCentral"
	// AzureLocationGermanyNortheast ...
	AzureLocationGermanyNortheast AzureLocation = "GermanyNortheast"
	// AzureLocationJapanEast ...
	AzureLocationJapanEast AzureLocation = "JapanEast"
	// AzureLocationJapanWest ...
	AzureLocationJapanWest AzureLocation = "JapanWest"
	// AzureLocationKoreaCentral ...
	AzureLocationKoreaCentral AzureLocation = "KoreaCentral"
	// AzureLocationKoreaSouth ...
	AzureLocationKoreaSouth AzureLocation = "KoreaSouth"
	// AzureLocationNorthCentralUs ...
	AzureLocationNorthCentralUs AzureLocation = "NorthCentralUs"
	// AzureLocationNorthEurope ...
	AzureLocationNorthEurope AzureLocation = "NorthEurope"
	// AzureLocationSouthCentralUs ...
	AzureLocationSouthCentralUs AzureLocation = "SouthCentralUs"
	// AzureLocationSoutheastAsia ...
	AzureLocationSoutheastAsia AzureLocation = "SoutheastAsia"
	// AzureLocationSouthIndia ...
	AzureLocationSouthIndia AzureLocation = "SouthIndia"
	// AzureLocationUkSouth ...
	AzureLocationUkSouth AzureLocation = "UkSouth"
	// AzureLocationUkWest ...
	AzureLocationUkWest AzureLocation = "UkWest"
	// AzureLocationUnknown ...
	AzureLocationUnknown AzureLocation = "Unknown"
	// AzureLocationWestCentralUs ...
	AzureLocationWestCentralUs AzureLocation = "WestCentralUs"
	// AzureLocationWestEurope ...
	AzureLocationWestEurope AzureLocation = "WestEurope"
	// AzureLocationWestIndia ...
	AzureLocationWestIndia AzureLocation = "WestIndia"
	// AzureLocationWestUs ...
	AzureLocationWestUs AzureLocation = "WestUs"
	// AzureLocationWestUs2 ...
	AzureLocationWestUs2 AzureLocation = "WestUs2"
)

// PossibleAzureLocationValues returns an array of possible values for the AzureLocation const type.
func PossibleAzureLocationValues() []AzureLocation {
	return []AzureLocation{AzureLocationAustraliaEast, AzureLocationAustraliaSoutheast, AzureLocationBrazilSouth, AzureLocationCanadaCentral, AzureLocationCanadaEast, AzureLocationCentralIndia, AzureLocationCentralUs, AzureLocationChinaEast, AzureLocationChinaNorth, AzureLocationEastAsia, AzureLocationEastUs, AzureLocationEastUs2, AzureLocationGermanyCentral, AzureLocationGermanyNortheast, AzureLocationJapanEast, AzureLocationJapanWest, AzureLocationKoreaCentral, AzureLocationKoreaSouth, AzureLocationNorthCentralUs, AzureLocationNorthEurope, AzureLocationSouthCentralUs, AzureLocationSoutheastAsia, AzureLocationSouthIndia, AzureLocationUkSouth, AzureLocationUkWest, AzureLocationUnknown, AzureLocationWestCentralUs, AzureLocationWestEurope, AzureLocationWestIndia, AzureLocationWestUs, AzureLocationWestUs2}
}

// AzureNetworkAdapterSuitabilityExplanation enumerates the values for azure network adapter suitability
// explanation.
type AzureNetworkAdapterSuitabilityExplanation string

const (
	// AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured ...
	AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured AzureNetworkAdapterSuitabilityExplanation = "InternalErrorOccured"
	// AzureNetworkAdapterSuitabilityExplanationNotApplicable ...
	AzureNetworkAdapterSuitabilityExplanationNotApplicable AzureNetworkAdapterSuitabilityExplanation = "NotApplicable"
	// AzureNetworkAdapterSuitabilityExplanationUnknown ...
	AzureNetworkAdapterSuitabilityExplanationUnknown AzureNetworkAdapterSuitabilityExplanation = "Unknown"
)

// PossibleAzureNetworkAdapterSuitabilityExplanationValues returns an array of possible values for the AzureNetworkAdapterSuitabilityExplanation const type.
func PossibleAzureNetworkAdapterSuitabilityExplanationValues() []AzureNetworkAdapterSuitabilityExplanation {
	return []AzureNetworkAdapterSuitabilityExplanation{AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured, AzureNetworkAdapterSuitabilityExplanationNotApplicable, AzureNetworkAdapterSuitabilityExplanationUnknown}
}

// AzureOfferCode enumerates the values for azure offer code.
type AzureOfferCode string

const (
	// AzureOfferCodeMSAZR0003P ...
	AzureOfferCodeMSAZR0003P AzureOfferCode = "MSAZR0003P"
	// AzureOfferCodeMSAZR0022P ...
	AzureOfferCodeMSAZR0022P AzureOfferCode = "MSAZR0022P"
	// AzureOfferCodeMSAZR0023P ...
	AzureOfferCodeMSAZR0023P AzureOfferCode = "MSAZR0023P"
	// AzureOfferCodeMSAZR0025P ...
	AzureOfferCodeMSAZR0025P AzureOfferCode = "MSAZR0025P"
	// AzureOfferCodeMSAZR0029P ...
	AzureOfferCodeMSAZR0029P AzureOfferCode = "MSAZR0029P"
	// AzureOfferCodeMSAZR0036P ...
	AzureOfferCodeMSAZR0036P AzureOfferCode = "MSAZR0036P"
	// AzureOfferCodeMSAZR0044P ...
	AzureOfferCodeMSAZR0044P AzureOfferCode = "MSAZR0044P"
	// AzureOfferCodeMSAZR0059P ...
	AzureOfferCodeMSAZR0059P AzureOfferCode = "MSAZR0059P"
	// AzureOfferCodeMSAZR0060P ...
	AzureOfferCodeMSAZR0060P AzureOfferCode = "MSAZR0060P"
	// AzureOfferCodeMSAZR0062P ...
	AzureOfferCodeMSAZR0062P AzureOfferCode = "MSAZR0062P"
	// AzureOfferCodeMSAZR0063P ...
	AzureOfferCodeMSAZR0063P AzureOfferCode = "MSAZR0063P"
	// AzureOfferCodeMSAZR0064P ...
	AzureOfferCodeMSAZR0064P AzureOfferCode = "MSAZR0064P"
	// AzureOfferCodeMSAZR0111P ...
	AzureOfferCodeMSAZR0111P AzureOfferCode = "MSAZR0111P"
	// AzureOfferCodeMSAZR0120P ...
	AzureOfferCodeMSAZR0120P AzureOfferCode = "MSAZR0120P"
	// AzureOfferCodeMSAZR0121P ...
	AzureOfferCodeMSAZR0121P AzureOfferCode = "MSAZR0121P"
	// AzureOfferCodeMSAZR0122P ...
	AzureOfferCodeMSAZR0122P AzureOfferCode = "MSAZR0122P"
	// AzureOfferCodeMSAZR0123P ...
	AzureOfferCodeMSAZR0123P AzureOfferCode = "MSAZR0123P"
	// AzureOfferCodeMSAZR0124P ...
	AzureOfferCodeMSAZR0124P AzureOfferCode = "MSAZR0124P"
	// AzureOfferCodeMSAZR0125P ...
	AzureOfferCodeMSAZR0125P AzureOfferCode = "MSAZR0125P"
	// AzureOfferCodeMSAZR0126P ...
	AzureOfferCodeMSAZR0126P AzureOfferCode = "MSAZR0126P"
	// AzureOfferCodeMSAZR0127P ...
	AzureOfferCodeMSAZR0127P AzureOfferCode = "MSAZR0127P"
	// AzureOfferCodeMSAZR0128P ...
	AzureOfferCodeMSAZR0128P AzureOfferCode = "MSAZR0128P"
	// AzureOfferCodeMSAZR0129P ...
	AzureOfferCodeMSAZR0129P AzureOfferCode = "MSAZR0129P"
	// AzureOfferCodeMSAZR0130P ...
	AzureOfferCodeMSAZR0130P AzureOfferCode = "MSAZR0130P"
	// AzureOfferCodeMSAZR0144P ...
	AzureOfferCodeMSAZR0144P AzureOfferCode = "MSAZR0144P"
	// AzureOfferCodeMSAZR0148P ...
	AzureOfferCodeMSAZR0148P AzureOfferCode = "MSAZR0148P"
	// AzureOfferCodeMSAZR0149P ...
	AzureOfferCodeMSAZR0149P AzureOfferCode = "MSAZR0149P"
	// AzureOfferCodeMSAZRDE0003P ...
	AzureOfferCodeMSAZRDE0003P AzureOfferCode = "MSAZRDE0003P"
	// AzureOfferCodeMSAZRDE0044P ...
	AzureOfferCodeMSAZRDE0044P AzureOfferCode = "MSAZRDE0044P"
	// AzureOfferCodeMSMCAZR0044P ...
	AzureOfferCodeMSMCAZR0044P AzureOfferCode = "MSMCAZR0044P"
	// AzureOfferCodeMSMCAZR0059P ...
	AzureOfferCodeMSMCAZR0059P AzureOfferCode = "MSMCAZR0059P"
	// AzureOfferCodeMSMCAZR0060P ...
	AzureOfferCodeMSMCAZR0060P AzureOfferCode = "MSMCAZR0060P"
	// AzureOfferCodeMSMCAZR0063P ...
	AzureOfferCodeMSMCAZR0063P AzureOfferCode = "MSMCAZR0063P"
	// AzureOfferCodeMSMCAZR0120P ...
	AzureOfferCodeMSMCAZR0120P AzureOfferCode = "MSMCAZR0120P"
	// AzureOfferCodeMSMCAZR0121P ...
	AzureOfferCodeMSMCAZR0121P AzureOfferCode = "MSMCAZR0121P"
	// AzureOfferCodeMSMCAZR0125P ...
	AzureOfferCodeMSMCAZR0125P AzureOfferCode = "MSMCAZR0125P"
	// AzureOfferCodeMSMCAZR0128P ...
	AzureOfferCodeMSMCAZR0128P AzureOfferCode = "MSMCAZR0128P"
	// AzureOfferCodeUnknown ...
	AzureOfferCodeUnknown AzureOfferCode = "Unknown"
)

// PossibleAzureOfferCodeValues returns an array of possible values for the AzureOfferCode const type.
func PossibleAzureOfferCodeValues() []AzureOfferCode {
	return []AzureOfferCode{AzureOfferCodeMSAZR0003P, AzureOfferCodeMSAZR0022P, AzureOfferCodeMSAZR0023P, AzureOfferCodeMSAZR0025P, AzureOfferCodeMSAZR0029P, AzureOfferCodeMSAZR0036P, AzureOfferCodeMSAZR0044P, AzureOfferCodeMSAZR0059P, AzureOfferCodeMSAZR0060P, AzureOfferCodeMSAZR0062P, AzureOfferCodeMSAZR0063P, AzureOfferCodeMSAZR0064P, AzureOfferCodeMSAZR0111P, AzureOfferCodeMSAZR0120P, AzureOfferCodeMSAZR0121P, AzureOfferCodeMSAZR0122P, AzureOfferCodeMSAZR0123P, AzureOfferCodeMSAZR0124P, AzureOfferCodeMSAZR0125P, AzureOfferCodeMSAZR0126P, AzureOfferCodeMSAZR0127P, AzureOfferCodeMSAZR0128P, AzureOfferCodeMSAZR0129P, AzureOfferCodeMSAZR0130P, AzureOfferCodeMSAZR0144P, AzureOfferCodeMSAZR0148P, AzureOfferCodeMSAZR0149P, AzureOfferCodeMSAZRDE0003P, AzureOfferCodeMSAZRDE0044P, AzureOfferCodeMSMCAZR0044P, AzureOfferCodeMSMCAZR0059P, AzureOfferCodeMSMCAZR0060P, AzureOfferCodeMSMCAZR0063P, AzureOfferCodeMSMCAZR0120P, AzureOfferCodeMSMCAZR0121P, AzureOfferCodeMSMCAZR0125P, AzureOfferCodeMSMCAZR0128P, AzureOfferCodeUnknown}
}

// AzurePricingTier enumerates the values for azure pricing tier.
type AzurePricingTier string

const (
	// Basic ...
	Basic AzurePricingTier = "Basic"
	// Standard ...
	Standard AzurePricingTier = "Standard"
)

// PossibleAzurePricingTierValues returns an array of possible values for the AzurePricingTier const type.
func PossibleAzurePricingTierValues() []AzurePricingTier {
	return []AzurePricingTier{Basic, Standard}
}

// AzureStorageRedundancy enumerates the values for azure storage redundancy.
type AzureStorageRedundancy string

const (
	// AzureStorageRedundancyGeoRedundant ...
	AzureStorageRedundancyGeoRedundant AzureStorageRedundancy = "GeoRedundant"
	// AzureStorageRedundancyLocallyRedundant ...
	AzureStorageRedundancyLocallyRedundant AzureStorageRedundancy = "LocallyRedundant"
	// AzureStorageRedundancyReadAccessGeoRedundant ...
	AzureStorageRedundancyReadAccessGeoRedundant AzureStorageRedundancy = "ReadAccessGeoRedundant"
	// AzureStorageRedundancyUnknown ...
	AzureStorageRedundancyUnknown AzureStorageRedundancy = "Unknown"
	// AzureStorageRedundancyZoneRedundant ...
	AzureStorageRedundancyZoneRedundant AzureStorageRedundancy = "ZoneRedundant"
)

// PossibleAzureStorageRedundancyValues returns an array of possible values for the AzureStorageRedundancy const type.
func PossibleAzureStorageRedundancyValues() []AzureStorageRedundancy {
	return []AzureStorageRedundancy{AzureStorageRedundancyGeoRedundant, AzureStorageRedundancyLocallyRedundant, AzureStorageRedundancyReadAccessGeoRedundant, AzureStorageRedundancyUnknown, AzureStorageRedundancyZoneRedundant}
}

// AzureVMSize enumerates the values for azure vm size.
type AzureVMSize string

const (
	// AzureVMSizeBasicA0 ...
	AzureVMSizeBasicA0 AzureVMSize = "Basic_A0"
	// AzureVMSizeBasicA1 ...
	AzureVMSizeBasicA1 AzureVMSize = "Basic_A1"
	// AzureVMSizeBasicA2 ...
	AzureVMSizeBasicA2 AzureVMSize = "Basic_A2"
	// AzureVMSizeBasicA3 ...
	AzureVMSizeBasicA3 AzureVMSize = "Basic_A3"
	// AzureVMSizeBasicA4 ...
	AzureVMSizeBasicA4 AzureVMSize = "Basic_A4"
	// AzureVMSizeStandardA0 ...
	AzureVMSizeStandardA0 AzureVMSize = "Standard_A0"
	// AzureVMSizeStandardA1 ...
	AzureVMSizeStandardA1 AzureVMSize = "Standard_A1"
	// AzureVMSizeStandardA10 ...
	AzureVMSizeStandardA10 AzureVMSize = "Standard_A10"
	// AzureVMSizeStandardA11 ...
	AzureVMSizeStandardA11 AzureVMSize = "Standard_A11"
	// AzureVMSizeStandardA1V2 ...
	AzureVMSizeStandardA1V2 AzureVMSize = "Standard_A1_v2"
	// AzureVMSizeStandardA2 ...
	AzureVMSizeStandardA2 AzureVMSize = "Standard_A2"
	// AzureVMSizeStandardA2mV2 ...
	AzureVMSizeStandardA2mV2 AzureVMSize = "Standard_A2m_v2"
	// AzureVMSizeStandardA2V2 ...
	AzureVMSizeStandardA2V2 AzureVMSize = "Standard_A2_v2"
	// AzureVMSizeStandardA3 ...
	AzureVMSizeStandardA3 AzureVMSize = "Standard_A3"
	// AzureVMSizeStandardA4 ...
	AzureVMSizeStandardA4 AzureVMSize = "Standard_A4"
	// AzureVMSizeStandardA4mV2 ...
	AzureVMSizeStandardA4mV2 AzureVMSize = "Standard_A4m_v2"
	// AzureVMSizeStandardA4V2 ...
	AzureVMSizeStandardA4V2 AzureVMSize = "Standard_A4_v2"
	// AzureVMSizeStandardA5 ...
	AzureVMSizeStandardA5 AzureVMSize = "Standard_A5"
	// AzureVMSizeStandardA6 ...
	AzureVMSizeStandardA6 AzureVMSize = "Standard_A6"
	// AzureVMSizeStandardA7 ...
	AzureVMSizeStandardA7 AzureVMSize = "Standard_A7"
	// AzureVMSizeStandardA8 ...
	AzureVMSizeStandardA8 AzureVMSize = "Standard_A8"
	// AzureVMSizeStandardA8mV2 ...
	AzureVMSizeStandardA8mV2 AzureVMSize = "Standard_A8m_v2"
	// AzureVMSizeStandardA8V2 ...
	AzureVMSizeStandardA8V2 AzureVMSize = "Standard_A8_v2"
	// AzureVMSizeStandardA9 ...
	AzureVMSizeStandardA9 AzureVMSize = "Standard_A9"
	// AzureVMSizeStandardD1 ...
	AzureVMSizeStandardD1 AzureVMSize = "Standard_D1"
	// AzureVMSizeStandardD11 ...
	AzureVMSizeStandardD11 AzureVMSize = "Standard_D11"
	// AzureVMSizeStandardD11V2 ...
	AzureVMSizeStandardD11V2 AzureVMSize = "Standard_D11_v2"
	// AzureVMSizeStandardD12 ...
	AzureVMSizeStandardD12 AzureVMSize = "Standard_D12"
	// AzureVMSizeStandardD12V2 ...
	AzureVMSizeStandardD12V2 AzureVMSize = "Standard_D12_v2"
	// AzureVMSizeStandardD13 ...
	AzureVMSizeStandardD13 AzureVMSize = "Standard_D13"
	// AzureVMSizeStandardD13V2 ...
	AzureVMSizeStandardD13V2 AzureVMSize = "Standard_D13_v2"
	// AzureVMSizeStandardD14 ...
	AzureVMSizeStandardD14 AzureVMSize = "Standard_D14"
	// AzureVMSizeStandardD14V2 ...
	AzureVMSizeStandardD14V2 AzureVMSize = "Standard_D14_v2"
	// AzureVMSizeStandardD15V2 ...
	AzureVMSizeStandardD15V2 AzureVMSize = "Standard_D15_v2"
	// AzureVMSizeStandardD1V2 ...
	AzureVMSizeStandardD1V2 AzureVMSize = "Standard_D1_v2"
	// AzureVMSizeStandardD2 ...
	AzureVMSizeStandardD2 AzureVMSize = "Standard_D2"
	// AzureVMSizeStandardD2V2 ...
	AzureVMSizeStandardD2V2 AzureVMSize = "Standard_D2_v2"
	// AzureVMSizeStandardD3 ...
	AzureVMSizeStandardD3 AzureVMSize = "Standard_D3"
	// AzureVMSizeStandardD3V2 ...
	AzureVMSizeStandardD3V2 AzureVMSize = "Standard_D3_v2"
	// AzureVMSizeStandardD4 ...
	AzureVMSizeStandardD4 AzureVMSize = "Standard_D4"
	// AzureVMSizeStandardD4V2 ...
	AzureVMSizeStandardD4V2 AzureVMSize = "Standard_D4_v2"
	// AzureVMSizeStandardD5V2 ...
	AzureVMSizeStandardD5V2 AzureVMSize = "Standard_D5_v2"
	// AzureVMSizeStandardDS1 ...
	AzureVMSizeStandardDS1 AzureVMSize = "Standard_DS1"
	// AzureVMSizeStandardDS11 ...
	AzureVMSizeStandardDS11 AzureVMSize = "Standard_DS11"
	// AzureVMSizeStandardDS11V2 ...
	AzureVMSizeStandardDS11V2 AzureVMSize = "Standard_DS11_v2"
	// AzureVMSizeStandardDS12 ...
	AzureVMSizeStandardDS12 AzureVMSize = "Standard_DS12"
	// AzureVMSizeStandardDS12V2 ...
	AzureVMSizeStandardDS12V2 AzureVMSize = "Standard_DS12_v2"
	// AzureVMSizeStandardDS13 ...
	AzureVMSizeStandardDS13 AzureVMSize = "Standard_DS13"
	// AzureVMSizeStandardDS13V2 ...
	AzureVMSizeStandardDS13V2 AzureVMSize = "Standard_DS13_v2"
	// AzureVMSizeStandardDS14 ...
	AzureVMSizeStandardDS14 AzureVMSize = "Standard_DS14"
	// AzureVMSizeStandardDS14V2 ...
	AzureVMSizeStandardDS14V2 AzureVMSize = "Standard_DS14_v2"
	// AzureVMSizeStandardDS15V2 ...
	AzureVMSizeStandardDS15V2 AzureVMSize = "Standard_DS15_v2"
	// AzureVMSizeStandardDS1V2 ...
	AzureVMSizeStandardDS1V2 AzureVMSize = "Standard_DS1_v2"
	// AzureVMSizeStandardDS2 ...
	AzureVMSizeStandardDS2 AzureVMSize = "Standard_DS2"
	// AzureVMSizeStandardDS2V2 ...
	AzureVMSizeStandardDS2V2 AzureVMSize = "Standard_DS2_v2"
	// AzureVMSizeStandardDS3 ...
	AzureVMSizeStandardDS3 AzureVMSize = "Standard_DS3"
	// AzureVMSizeStandardDS3V2 ...
	AzureVMSizeStandardDS3V2 AzureVMSize = "Standard_DS3_v2"
	// AzureVMSizeStandardDS4 ...
	AzureVMSizeStandardDS4 AzureVMSize = "Standard_DS4"
	// AzureVMSizeStandardDS4V2 ...
	AzureVMSizeStandardDS4V2 AzureVMSize = "Standard_DS4_v2"
	// AzureVMSizeStandardDS5V2 ...
	AzureVMSizeStandardDS5V2 AzureVMSize = "Standard_DS5_v2"
	// AzureVMSizeStandardF1 ...
	AzureVMSizeStandardF1 AzureVMSize = "Standard_F1"
	// AzureVMSizeStandardF16 ...
	AzureVMSizeStandardF16 AzureVMSize = "Standard_F16"
	// AzureVMSizeStandardF16s ...
	AzureVMSizeStandardF16s AzureVMSize = "Standard_F16s"
	// AzureVMSizeStandardF1s ...
	AzureVMSizeStandardF1s AzureVMSize = "Standard_F1s"
	// AzureVMSizeStandardF2 ...
	AzureVMSizeStandardF2 AzureVMSize = "Standard_F2"
	// AzureVMSizeStandardF2s ...
	AzureVMSizeStandardF2s AzureVMSize = "Standard_F2s"
	// AzureVMSizeStandardF4 ...
	AzureVMSizeStandardF4 AzureVMSize = "Standard_F4"
	// AzureVMSizeStandardF4s ...
	AzureVMSizeStandardF4s AzureVMSize = "Standard_F4s"
	// AzureVMSizeStandardF8 ...
	AzureVMSizeStandardF8 AzureVMSize = "Standard_F8"
	// AzureVMSizeStandardF8s ...
	AzureVMSizeStandardF8s AzureVMSize = "Standard_F8s"
	// AzureVMSizeStandardG1 ...
	AzureVMSizeStandardG1 AzureVMSize = "Standard_G1"
	// AzureVMSizeStandardG2 ...
	AzureVMSizeStandardG2 AzureVMSize = "Standard_G2"
	// AzureVMSizeStandardG3 ...
	AzureVMSizeStandardG3 AzureVMSize = "Standard_G3"
	// AzureVMSizeStandardG4 ...
	AzureVMSizeStandardG4 AzureVMSize = "Standard_G4"
	// AzureVMSizeStandardG5 ...
	AzureVMSizeStandardG5 AzureVMSize = "Standard_G5"
	// AzureVMSizeStandardGS1 ...
	AzureVMSizeStandardGS1 AzureVMSize = "Standard_GS1"
	// AzureVMSizeStandardGS2 ...
	AzureVMSizeStandardGS2 AzureVMSize = "Standard_GS2"
	// AzureVMSizeStandardGS3 ...
	AzureVMSizeStandardGS3 AzureVMSize = "Standard_GS3"
	// AzureVMSizeStandardGS4 ...
	AzureVMSizeStandardGS4 AzureVMSize = "Standard_GS4"
	// AzureVMSizeStandardGS5 ...
	AzureVMSizeStandardGS5 AzureVMSize = "Standard_GS5"
	// AzureVMSizeStandardH16 ...
	AzureVMSizeStandardH16 AzureVMSize = "Standard_H16"
	// AzureVMSizeStandardH16m ...
	AzureVMSizeStandardH16m AzureVMSize = "Standard_H16m"
	// AzureVMSizeStandardH16mr ...
	AzureVMSizeStandardH16mr AzureVMSize = "Standard_H16mr"
	// AzureVMSizeStandardH16r ...
	AzureVMSizeStandardH16r AzureVMSize = "Standard_H16r"
	// AzureVMSizeStandardH8 ...
	AzureVMSizeStandardH8 AzureVMSize = "Standard_H8"
	// AzureVMSizeStandardH8m ...
	AzureVMSizeStandardH8m AzureVMSize = "Standard_H8m"
	// AzureVMSizeStandardL16s ...
	AzureVMSizeStandardL16s AzureVMSize = "Standard_L16s"
	// AzureVMSizeStandardL32s ...
	AzureVMSizeStandardL32s AzureVMSize = "Standard_L32s"
	// AzureVMSizeStandardL4s ...
	AzureVMSizeStandardL4s AzureVMSize = "Standard_L4s"
	// AzureVMSizeStandardL8s ...
	AzureVMSizeStandardL8s AzureVMSize = "Standard_L8s"
	// AzureVMSizeUnknown ...
	AzureVMSizeUnknown AzureVMSize = "Unknown"
)

// PossibleAzureVMSizeValues returns an array of possible values for the AzureVMSize const type.
func PossibleAzureVMSizeValues() []AzureVMSize {
	return []AzureVMSize{AzureVMSizeBasicA0, AzureVMSizeBasicA1, AzureVMSizeBasicA2, AzureVMSizeBasicA3, AzureVMSizeBasicA4, AzureVMSizeStandardA0, AzureVMSizeStandardA1, AzureVMSizeStandardA10, AzureVMSizeStandardA11, AzureVMSizeStandardA1V2, AzureVMSizeStandardA2, AzureVMSizeStandardA2mV2, AzureVMSizeStandardA2V2, AzureVMSizeStandardA3, AzureVMSizeStandardA4, AzureVMSizeStandardA4mV2, AzureVMSizeStandardA4V2, AzureVMSizeStandardA5, AzureVMSizeStandardA6, AzureVMSizeStandardA7, AzureVMSizeStandardA8, AzureVMSizeStandardA8mV2, AzureVMSizeStandardA8V2, AzureVMSizeStandardA9, AzureVMSizeStandardD1, AzureVMSizeStandardD11, AzureVMSizeStandardD11V2, AzureVMSizeStandardD12, AzureVMSizeStandardD12V2, AzureVMSizeStandardD13, AzureVMSizeStandardD13V2, AzureVMSizeStandardD14, AzureVMSizeStandardD14V2, AzureVMSizeStandardD15V2, AzureVMSizeStandardD1V2, AzureVMSizeStandardD2, AzureVMSizeStandardD2V2, AzureVMSizeStandardD3, AzureVMSizeStandardD3V2, AzureVMSizeStandardD4, AzureVMSizeStandardD4V2, AzureVMSizeStandardD5V2, AzureVMSizeStandardDS1, AzureVMSizeStandardDS11, AzureVMSizeStandardDS11V2, AzureVMSizeStandardDS12, AzureVMSizeStandardDS12V2, AzureVMSizeStandardDS13, AzureVMSizeStandardDS13V2, AzureVMSizeStandardDS14, AzureVMSizeStandardDS14V2, AzureVMSizeStandardDS15V2, AzureVMSizeStandardDS1V2, AzureVMSizeStandardDS2, AzureVMSizeStandardDS2V2, AzureVMSizeStandardDS3, AzureVMSizeStandardDS3V2, AzureVMSizeStandardDS4, AzureVMSizeStandardDS4V2, AzureVMSizeStandardDS5V2, AzureVMSizeStandardF1, AzureVMSizeStandardF16, AzureVMSizeStandardF16s, AzureVMSizeStandardF1s, AzureVMSizeStandardF2, AzureVMSizeStandardF2s, AzureVMSizeStandardF4, AzureVMSizeStandardF4s, AzureVMSizeStandardF8, AzureVMSizeStandardF8s, AzureVMSizeStandardG1, AzureVMSizeStandardG2, AzureVMSizeStandardG3, AzureVMSizeStandardG4, AzureVMSizeStandardG5, AzureVMSizeStandardGS1, AzureVMSizeStandardGS2, AzureVMSizeStandardGS3, AzureVMSizeStandardGS4, AzureVMSizeStandardGS5, AzureVMSizeStandardH16, AzureVMSizeStandardH16m, AzureVMSizeStandardH16mr, AzureVMSizeStandardH16r, AzureVMSizeStandardH8, AzureVMSizeStandardH8m, AzureVMSizeStandardL16s, AzureVMSizeStandardL32s, AzureVMSizeStandardL4s, AzureVMSizeStandardL8s, AzureVMSizeUnknown}
}

// AzureVMSuitabilityExplanation enumerates the values for azure vm suitability explanation.
type AzureVMSuitabilityExplanation string

const (
	// AzureVMSuitabilityExplanationBootTypeNotSupported ...
	AzureVMSuitabilityExplanationBootTypeNotSupported AzureVMSuitabilityExplanation = "BootTypeNotSupported"
	// AzureVMSuitabilityExplanationBootTypeUnknown ...
	AzureVMSuitabilityExplanationBootTypeUnknown AzureVMSuitabilityExplanation = "BootTypeUnknown"
	// AzureVMSuitabilityExplanationCheckCentOsVersion ...
	AzureVMSuitabilityExplanationCheckCentOsVersion AzureVMSuitabilityExplanation = "CheckCentOsVersion"
	// AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion ...
	AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion AzureVMSuitabilityExplanation = "CheckCoreOsLinuxVersion"
	// AzureVMSuitabilityExplanationCheckDebianLinuxVersion ...
	AzureVMSuitabilityExplanationCheckDebianLinuxVersion AzureVMSuitabilityExplanation = "CheckDebianLinuxVersion"
	// AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion ...
	AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion AzureVMSuitabilityExplanation = "CheckOpenSuseLinuxVersion"
	// AzureVMSuitabilityExplanationCheckOracleLinuxVersion ...
	AzureVMSuitabilityExplanationCheckOracleLinuxVersion AzureVMSuitabilityExplanation = "CheckOracleLinuxVersion"
	// AzureVMSuitabilityExplanationCheckRedHatLinuxVersion ...
	AzureVMSuitabilityExplanationCheckRedHatLinuxVersion AzureVMSuitabilityExplanation = "CheckRedHatLinuxVersion"
	// AzureVMSuitabilityExplanationCheckSuseLinuxVersion ...
	AzureVMSuitabilityExplanationCheckSuseLinuxVersion AzureVMSuitabilityExplanation = "CheckSuseLinuxVersion"
	// AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion ...
	AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion AzureVMSuitabilityExplanation = "CheckUbuntuLinuxVersion"
	// AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version ...
	AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version AzureVMSuitabilityExplanation = "CheckWindowsServer2008R2Version"
	// AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions ...
	AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions AzureVMSuitabilityExplanation = "EndorsedWithConditionsLinuxDistributions"
	// AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported ...
	AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported AzureVMSuitabilityExplanation = "GuestOperatingSystemArchitectureNotSupported"
	// AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported ...
	AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported AzureVMSuitabilityExplanation = "GuestOperatingSystemNotSupported"
	// AzureVMSuitabilityExplanationGuestOperatingSystemUnknown ...
	AzureVMSuitabilityExplanationGuestOperatingSystemUnknown AzureVMSuitabilityExplanation = "GuestOperatingSystemUnknown"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringComputeEvaluation"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringNetworkEvaluation"
	// AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation ...
	AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation AzureVMSuitabilityExplanation = "InternalErrorOccuredDuringStorageEvaluation"
	// AzureVMSuitabilityExplanationMoreDisksThanSupported ...
	AzureVMSuitabilityExplanationMoreDisksThanSupported AzureVMSuitabilityExplanation = "MoreDisksThanSupported"
	// AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported ...
	AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported AzureVMSuitabilityExplanation = "NoGuestOperatingSystemConditionallySupported"
	// AzureVMSuitabilityExplanationNoSuitableVMSizeFound ...
	AzureVMSuitabilityExplanationNoSuitableVMSizeFound AzureVMSuitabilityExplanation = "NoSuitableVmSizeFound"
	// AzureVMSuitabilityExplanationNotApplicable ...
	AzureVMSuitabilityExplanationNotApplicable AzureVMSuitabilityExplanation = "NotApplicable"
	// AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForBasicPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation ...
	AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation AzureVMSuitabilityExplanation = "NoVmSizeForSelectedAzureLocation"
	// AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForSelectedPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier ...
	AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier AzureVMSuitabilityExplanation = "NoVmSizeForStandardPricingTier"
	// AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance ...
	AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance AzureVMSuitabilityExplanation = "NoVmSizeSupportsNetworkPerformance"
	// AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance ...
	AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance AzureVMSuitabilityExplanation = "NoVmSizeSupportsStoragePerformance"
	// AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable ...
	AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable AzureVMSuitabilityExplanation = "OneOrMoreAdaptersNotSuitable"
	// AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable ...
	AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable AzureVMSuitabilityExplanation = "OneOrMoreDisksNotSuitable"
	// AzureVMSuitabilityExplanationUnendorsedLinuxDistributions ...
	AzureVMSuitabilityExplanationUnendorsedLinuxDistributions AzureVMSuitabilityExplanation = "UnendorsedLinuxDistributions"
	// AzureVMSuitabilityExplanationUnknown ...
	AzureVMSuitabilityExplanationUnknown AzureVMSuitabilityExplanation = "Unknown"
	// AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported ...
	AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported AzureVMSuitabilityExplanation = "WindowsClientVersionsConditionallySupported"
	// AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport ...
	AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport AzureVMSuitabilityExplanation = "WindowsOSNoLongerUnderMSSupport"
	// AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported ...
	AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported AzureVMSuitabilityExplanation = "WindowsServerVersionConditionallySupported"
	// AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat ...
	AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat AzureVMSuitabilityExplanation = "WindowsServerVersionsSupportedWithCaveat"
)

// PossibleAzureVMSuitabilityExplanationValues returns an array of possible values for the AzureVMSuitabilityExplanation const type.
func PossibleAzureVMSuitabilityExplanationValues() []AzureVMSuitabilityExplanation {
	return []AzureVMSuitabilityExplanation{AzureVMSuitabilityExplanationBootTypeNotSupported, AzureVMSuitabilityExplanationBootTypeUnknown, AzureVMSuitabilityExplanationCheckCentOsVersion, AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion, AzureVMSuitabilityExplanationCheckDebianLinuxVersion, AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion, AzureVMSuitabilityExplanationCheckOracleLinuxVersion, AzureVMSuitabilityExplanationCheckRedHatLinuxVersion, AzureVMSuitabilityExplanationCheckSuseLinuxVersion, AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion, AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version, AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions, AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported, AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported, AzureVMSuitabilityExplanationGuestOperatingSystemUnknown, AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation, AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation, AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation, AzureVMSuitabilityExplanationMoreDisksThanSupported, AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported, AzureVMSuitabilityExplanationNoSuitableVMSizeFound, AzureVMSuitabilityExplanationNotApplicable, AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier, AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation, AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier, AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier, AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance, AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance, AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable, AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable, AzureVMSuitabilityExplanationUnendorsedLinuxDistributions, AzureVMSuitabilityExplanationUnknown, AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported, AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport, AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported, AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat}
}

// CloudSuitability enumerates the values for cloud suitability.
type CloudSuitability string

const (
	// CloudSuitabilityConditionallySuitable ...
	CloudSuitabilityConditionallySuitable CloudSuitability = "ConditionallySuitable"
	// CloudSuitabilityNotSuitable ...
	CloudSuitabilityNotSuitable CloudSuitability = "NotSuitable"
	// CloudSuitabilityReadinessUnknown ...
	CloudSuitabilityReadinessUnknown CloudSuitability = "ReadinessUnknown"
	// CloudSuitabilitySuitable ...
	CloudSuitabilitySuitable CloudSuitability = "Suitable"
	// CloudSuitabilityUnknown ...
	CloudSuitabilityUnknown CloudSuitability = "Unknown"
)

// PossibleCloudSuitabilityValues returns an array of possible values for the CloudSuitability const type.
func PossibleCloudSuitabilityValues() []CloudSuitability {
	return []CloudSuitability{CloudSuitabilityConditionallySuitable, CloudSuitabilityNotSuitable, CloudSuitabilityReadinessUnknown, CloudSuitabilitySuitable, CloudSuitabilityUnknown}
}

// Currency enumerates the values for currency.
type Currency string

const (
	// CurrencyARS ...
	CurrencyARS Currency = "ARS"
	// CurrencyAUD ...
	CurrencyAUD Currency = "AUD"
	// CurrencyBRL ...
	CurrencyBRL Currency = "BRL"
	// CurrencyCAD ...
	CurrencyCAD Currency = "CAD"
	// CurrencyCHF ...
	CurrencyCHF Currency = "CHF"
	// CurrencyCNY ...
	CurrencyCNY Currency = "CNY"
	// CurrencyDKK ...
	CurrencyDKK Currency = "DKK"
	// CurrencyEUR ...
	CurrencyEUR Currency = "EUR"
	// CurrencyGBP ...
	CurrencyGBP Currency = "GBP"
	// CurrencyHKD ...
	CurrencyHKD Currency = "HKD"
	// CurrencyIDR ...
	CurrencyIDR Currency = "IDR"
	// CurrencyINR ...
	CurrencyINR Currency = "INR"
	// CurrencyJPY ...
	CurrencyJPY Currency = "JPY"
	// CurrencyKRW ...
	CurrencyKRW Currency = "KRW"
	// CurrencyMXN ...
	CurrencyMXN Currency = "MXN"
	// CurrencyMYR ...
	CurrencyMYR Currency = "MYR"
	// CurrencyNOK ...
	CurrencyNOK Currency = "NOK"
	// CurrencyNZD ...
	CurrencyNZD Currency = "NZD"
	// CurrencyRUB ...
	CurrencyRUB Currency = "RUB"
	// CurrencySAR ...
	CurrencySAR Currency = "SAR"
	// CurrencySEK ...
	CurrencySEK Currency = "SEK"
	// CurrencyTRY ...
	CurrencyTRY Currency = "TRY"
	// CurrencyTWD ...
	CurrencyTWD Currency = "TWD"
	// CurrencyUnknown ...
	CurrencyUnknown Currency = "Unknown"
	// CurrencyUSD ...
	CurrencyUSD Currency = "USD"
	// CurrencyZAR ...
	CurrencyZAR Currency = "ZAR"
)

// PossibleCurrencyValues returns an array of possible values for the Currency const type.
func PossibleCurrencyValues() []Currency {
	return []Currency{CurrencyARS, CurrencyAUD, CurrencyBRL, CurrencyCAD, CurrencyCHF, CurrencyCNY, CurrencyDKK, CurrencyEUR, CurrencyGBP, CurrencyHKD, CurrencyIDR, CurrencyINR, CurrencyJPY, CurrencyKRW, CurrencyMXN, CurrencyMYR, CurrencyNOK, CurrencyNZD, CurrencyRUB, CurrencySAR, CurrencySEK, CurrencyTRY, CurrencyTWD, CurrencyUnknown, CurrencyUSD, CurrencyZAR}
}

// DiscoveryStatus enumerates the values for discovery status.
type DiscoveryStatus string

const (
	// DiscoveryStatusCompleted ...
	DiscoveryStatusCompleted DiscoveryStatus = "Completed"
	// DiscoveryStatusInProgress ...
	DiscoveryStatusInProgress DiscoveryStatus = "InProgress"
	// DiscoveryStatusNotStarted ...
	DiscoveryStatusNotStarted DiscoveryStatus = "NotStarted"
	// DiscoveryStatusUnknown ...
	DiscoveryStatusUnknown DiscoveryStatus = "Unknown"
)

// PossibleDiscoveryStatusValues returns an array of possible values for the DiscoveryStatus const type.
func PossibleDiscoveryStatusValues() []DiscoveryStatus {
	return []DiscoveryStatus{DiscoveryStatusCompleted, DiscoveryStatusInProgress, DiscoveryStatusNotStarted, DiscoveryStatusUnknown}
}

// MachineBootType enumerates the values for machine boot type.
type MachineBootType string

const (
	// MachineBootTypeBIOS ...
	MachineBootTypeBIOS MachineBootType = "BIOS"
	// MachineBootTypeEFI ...
	MachineBootTypeEFI MachineBootType = "EFI"
	// MachineBootTypeUnknown ...
	MachineBootTypeUnknown MachineBootType = "Unknown"
)

// PossibleMachineBootTypeValues returns an array of possible values for the MachineBootType const type.
func PossibleMachineBootTypeValues() []MachineBootType {
	return []MachineBootType{MachineBootTypeBIOS, MachineBootTypeEFI, MachineBootTypeUnknown}
}

// Percentile enumerates the values for percentile.
type Percentile string

const (
	// Percentile50 ...
	Percentile50 Percentile = "Percentile50"
	// Percentile90 ...
	Percentile90 Percentile = "Percentile90"
	// Percentile95 ...
	Percentile95 Percentile = "Percentile95"
	// Percentile99 ...
	Percentile99 Percentile = "Percentile99"
)

// PossiblePercentileValues returns an array of possible values for the Percentile const type.
func PossiblePercentileValues() []Percentile {
	return []Percentile{Percentile50, Percentile90, Percentile95, Percentile99}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Accepted ...
	Accepted ProvisioningState = "Accepted"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Moving ...
	Moving ProvisioningState = "Moving"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Accepted, Creating, Deleting, Failed, Moving, Succeeded}
}

// TimeRange enumerates the values for time range.
type TimeRange string

const (
	// Day ...
	Day TimeRange = "Day"
	// Month ...
	Month TimeRange = "Month"
	// Week ...
	Week TimeRange = "Week"
)

// PossibleTimeRangeValues returns an array of possible values for the TimeRange const type.
func PossibleTimeRangeValues() []TimeRange {
	return []TimeRange{Day, Month, Week}
}

// AssessedDisk a disk assessed for an assessment.
type AssessedDisk struct {
	// Name - Name of the assessed disk.
	Name *string `json:"name,omitempty"`
	// GigabytesProvisioned - Gigabytes of storage provisioned for this disk.
	GigabytesProvisioned *float64 `json:"gigabytesProvisioned,omitempty"`
	// GigabytesConsumed - Gigabytes of storage consumed by this disk.
	GigabytesConsumed *float64 `json:"gigabytesConsumed,omitempty"`
	// MegabytesPerSecondOfRead - Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfRead *float64 `json:"megabytesPerSecondOfRead,omitempty"`
	// MegabytesPerSecondOfReadDataPointsExpected - Expected data points for MegaBytes per second of read.
	MegabytesPerSecondOfReadDataPointsExpected *int32 `json:"megabytesPerSecondOfReadDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfReadDataPointsReceived - Received data points for MegaBytes per second of read.
	MegabytesPerSecondOfReadDataPointsReceived *int32 `json:"megabytesPerSecondOfReadDataPointsReceived,omitempty"`
	// MegabytesPerSecondOfWrite - Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfWrite *float64 `json:"megabytesPerSecondOfWrite,omitempty"`
	// MegabytesPerSecondOfWriteDataPointsExpected - Expected data points for MegaBytes per second of write.
	MegabytesPerSecondOfWriteDataPointsExpected *int32 `json:"megabytesPerSecondOfWriteDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfWriteDataPointsReceived - Received data points for MegaBytes per second of write.
	MegabytesPerSecondOfWriteDataPointsReceived *int32 `json:"megabytesPerSecondOfWriteDataPointsReceived,omitempty"`
	// NumberOfReadOperationsPerSecond - Number of read operations per second for the disk.
	NumberOfReadOperationsPerSecond *float64 `json:"numberOfReadOperationsPerSecond,omitempty"`
	// NumberOfReadOperationsPerSecondDataPointsExpected - Expected number of data points for read operations per second.
	NumberOfReadOperationsPerSecondDataPointsExpected *int32 `json:"numberOfReadOperationsPerSecondDataPointsExpected,omitempty"`
	// NumberOfReadOperationsPerSecondDataPointsReceived - Received number of data points for read operations per second.
	NumberOfReadOperationsPerSecondDataPointsReceived *int32 `json:"numberOfReadOperationsPerSecondDataPointsReceived,omitempty"`
	// NumberOfWriteOperationsPerSecond - Number of read and write operations per second for the disk.
	NumberOfWriteOperationsPerSecond *float64 `json:"numberOfWriteOperationsPerSecond,omitempty"`
	// NumberOfWriteOperationsPerSecondDataPointsExpected - Expected number of data points for write operations per second.
	NumberOfWriteOperationsPerSecondDataPointsExpected *int32 `json:"numberOfWriteOperationsPerSecondDataPointsExpected,omitempty"`
	// NumberOfWriteOperationsPerSecondDataPointsReceived - Received number of data points for write operations per second.
	NumberOfWriteOperationsPerSecondDataPointsReceived *int32 `json:"numberOfWriteOperationsPerSecondDataPointsReceived,omitempty"`
	// MonthlyStorageCost - Estimated aggregate storage cost for a 31-day month for this disk.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// RecommendedDiskType - Storage type selected for this disk. Possible values include: 'AzureDiskTypeUnknown', 'AzureDiskTypeStandard', 'AzureDiskTypePremium'
	RecommendedDiskType AzureDiskType `json:"recommendedDiskType,omitempty"`
	// RecommendedDiskSize - Recommended Azure size for the disk, given utilization data and preferences set on Assessment. Possible values include: 'Unknown', 'StandardS4', 'StandardS6', 'StandardS10', 'StandardS20', 'StandardS30', 'StandardS40', 'StandardS50', 'PremiumP4', 'PremiumP6', 'PremiumP10', 'PremiumP20', 'PremiumP30', 'PremiumP40', 'PremiumP50'
	RecommendedDiskSize AzureDiskSize `json:"recommendedDiskSize,omitempty"`
	// GigabytesForRecommendedDiskSize - Gigabytes of storage provided by the recommended Azure disk size.
	GigabytesForRecommendedDiskSize *int32 `json:"gigabytesForRecommendedDiskSize,omitempty"`
	// Suitability - Whether this disk is suitable for Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - If disk is suitable, this explains the reasons and mitigation steps. Possible values include: 'AzureDiskSuitabilityExplanationUnknown', 'AzureDiskSuitabilityExplanationNotApplicable', 'AzureDiskSuitabilityExplanationDiskSizeGreaterThanSupported', 'AzureDiskSuitabilityExplanationNoSuitableDiskSizeForIops', 'AzureDiskSuitabilityExplanationNoSuitableDiskSizeForThroughput', 'AzureDiskSuitabilityExplanationNoDiskSizeFoundInSelectedLocation', 'AzureDiskSuitabilityExplanationNoDiskSizeFoundForSelectedRedundancy', 'AzureDiskSuitabilityExplanationInternalErrorOccurredForDiskEvaluation'
	SuitabilityExplanation AzureDiskSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
}

// AssessedMachine a machine evaluated as part of an assessment.
type AssessedMachine struct {
	autorest.Response `json:"-"`
	// ID - Path reference to this assessed machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}
	ID *string `json:"id,omitempty"`
	// Name - Name of the machine.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - Type of the object = [Microsoft.Migrate/projects/groups/assessments/assessedMachines].
	Type *string `json:"type,omitempty"`
	// AssessedMachineProperties - Properties of an assessed machine.
	*AssessedMachineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessedMachine.
func (am AssessedMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if am.ID != nil {
		objectMap["id"] = am.ID
	}
	if am.Name != nil {
		objectMap["name"] = am.Name
	}
	if am.ETag != nil {
		objectMap["eTag"] = am.ETag
	}
	if am.Type != nil {
		objectMap["type"] = am.Type
	}
	if am.AssessedMachineProperties != nil {
		objectMap["properties"] = am.AssessedMachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessedMachine struct.
func (am *AssessedMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				am.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				am.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				am.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				am.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var assessedMachineProperties AssessedMachineProperties
				err = json.Unmarshal(*v, &assessedMachineProperties)
				if err != nil {
					return err
				}
				am.AssessedMachineProperties = &assessedMachineProperties
			}
		}
	}

	return nil
}

// AssessedMachineProperties properties of an assessed machine.
type AssessedMachineProperties struct {
	// Groups - List of references to the groups that the machine is member of.
	Groups *[]string `json:"groups,omitempty"`
	// DiscoveredTimestamp - Time when this machine was discovered by Azure Migrate agent. Date-Time represented in ISO-8601 format.
	DiscoveredTimestamp *date.Time `json:"discoveredTimestamp,omitempty"`
	// BootType - Boot type of the machine. Possible values include: 'MachineBootTypeUnknown', 'MachineBootTypeEFI', 'MachineBootTypeBIOS'
	BootType MachineBootType `json:"bootType,omitempty"`
	// DatacenterContainer - Container defined in the management solution that this machine is part of in the datacenter.
	DatacenterContainer *string `json:"datacenterContainer,omitempty"`
	// DatacenterManagementServer - Name of the server hosting the datacenter management solution.
	DatacenterManagementServer *string `json:"datacenterManagementServer,omitempty"`
	// DatacenterMachineID - ID of the machine as tracked by the datacenter management solution.
	DatacenterMachineID *string `json:"datacenterMachineId,omitempty"`
	// DatacenterManagementServerID - ID of the server hosting the datacenter management solution.
	DatacenterManagementServerID *string `json:"datacenterManagementServerId,omitempty"`
	// Description - Description of the machine
	Description *string `json:"description,omitempty"`
	// DisplayName - User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty"`
	// MegabytesOfMemory - Memory in Megabytes.
	MegabytesOfMemory *float64 `json:"megabytesOfMemory,omitempty"`
	// NumberOfCores - Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// OperatingSystem - Operating System of the machine.
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// MonthlyBandwidthCost - Monthly network cost estimate for the network adapters that are attached to this machine as a group, for a 31-day month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty"`
	// MonthlyStorageCost - Monthly storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// Disks - Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object.
	Disks map[string]*AssessedDisk `json:"disks"`
	// NetworkAdapters - Dictionary of network adapters attached to the machine. Key is name of the adapter. Value is a network adapter object.
	NetworkAdapters map[string]*AssessedNetworkAdapter `json:"networkAdapters"`
	// RecommendedSize - Recommended Azure size for this machine. Possible values include: 'AzureVMSizeUnknown', 'AzureVMSizeBasicA0', 'AzureVMSizeBasicA1', 'AzureVMSizeBasicA2', 'AzureVMSizeBasicA3', 'AzureVMSizeBasicA4', 'AzureVMSizeStandardA0', 'AzureVMSizeStandardA1', 'AzureVMSizeStandardA2', 'AzureVMSizeStandardA3', 'AzureVMSizeStandardA4', 'AzureVMSizeStandardA5', 'AzureVMSizeStandardA6', 'AzureVMSizeStandardA7', 'AzureVMSizeStandardA8', 'AzureVMSizeStandardA9', 'AzureVMSizeStandardA10', 'AzureVMSizeStandardA11', 'AzureVMSizeStandardA1V2', 'AzureVMSizeStandardA2V2', 'AzureVMSizeStandardA4V2', 'AzureVMSizeStandardA8V2', 'AzureVMSizeStandardA2mV2', 'AzureVMSizeStandardA4mV2', 'AzureVMSizeStandardA8mV2', 'AzureVMSizeStandardD1', 'AzureVMSizeStandardD2', 'AzureVMSizeStandardD3', 'AzureVMSizeStandardD4', 'AzureVMSizeStandardD11', 'AzureVMSizeStandardD12', 'AzureVMSizeStandardD13', 'AzureVMSizeStandardD14', 'AzureVMSizeStandardD1V2', 'AzureVMSizeStandardD2V2', 'AzureVMSizeStandardD3V2', 'AzureVMSizeStandardD4V2', 'AzureVMSizeStandardD5V2', 'AzureVMSizeStandardD11V2', 'AzureVMSizeStandardD12V2', 'AzureVMSizeStandardD13V2', 'AzureVMSizeStandardD14V2', 'AzureVMSizeStandardD15V2', 'AzureVMSizeStandardDS1', 'AzureVMSizeStandardDS2', 'AzureVMSizeStandardDS3', 'AzureVMSizeStandardDS4', 'AzureVMSizeStandardDS11', 'AzureVMSizeStandardDS12', 'AzureVMSizeStandardDS13', 'AzureVMSizeStandardDS14', 'AzureVMSizeStandardDS1V2', 'AzureVMSizeStandardDS2V2', 'AzureVMSizeStandardDS3V2', 'AzureVMSizeStandardDS4V2', 'AzureVMSizeStandardDS5V2', 'AzureVMSizeStandardDS11V2', 'AzureVMSizeStandardDS12V2', 'AzureVMSizeStandardDS13V2', 'AzureVMSizeStandardDS14V2', 'AzureVMSizeStandardDS15V2', 'AzureVMSizeStandardF1', 'AzureVMSizeStandardF2', 'AzureVMSizeStandardF4', 'AzureVMSizeStandardF8', 'AzureVMSizeStandardF16', 'AzureVMSizeStandardF1s', 'AzureVMSizeStandardF2s', 'AzureVMSizeStandardF4s', 'AzureVMSizeStandardF8s', 'AzureVMSizeStandardF16s', 'AzureVMSizeStandardG1', 'AzureVMSizeStandardG2', 'AzureVMSizeStandardG3', 'AzureVMSizeStandardG4', 'AzureVMSizeStandardG5', 'AzureVMSizeStandardGS1', 'AzureVMSizeStandardGS2', 'AzureVMSizeStandardGS3', 'AzureVMSizeStandardGS4', 'AzureVMSizeStandardGS5', 'AzureVMSizeStandardH8', 'AzureVMSizeStandardH16', 'AzureVMSizeStandardH8m', 'AzureVMSizeStandardH16m', 'AzureVMSizeStandardH16r', 'AzureVMSizeStandardH16mr', 'AzureVMSizeStandardL4s', 'AzureVMSizeStandardL8s', 'AzureVMSizeStandardL16s', 'AzureVMSizeStandardL32s'
	RecommendedSize AzureVMSize `json:"recommendedSize,omitempty"`
	// NumberOfCoresForRecommendedSize - Number of CPU cores in the Recommended Azure VM Size.
	NumberOfCoresForRecommendedSize *int32 `json:"numberOfCoresForRecommendedSize,omitempty"`
	// MegabytesOfMemoryForRecommendedSize - Megabytes of memory in the Recommended Azure VM Size.
	MegabytesOfMemoryForRecommendedSize *float64 `json:"megabytesOfMemoryForRecommendedSize,omitempty"`
	// MonthlyComputeCostForRecommendedSize - Compute Cost for a 31-day month, if the machine is migrated to Azure with the Recommended Size.
	MonthlyComputeCostForRecommendedSize *float64 `json:"monthlyComputeCostForRecommendedSize,omitempty"`
	// PercentageCoresUtilization - Utilization percentage of the processor core as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment.
	PercentageCoresUtilization *float64 `json:"percentageCoresUtilization,omitempty"`
	// PercentageMemoryUtilization - Utilization percentage of the memory as observed in the private data center, in the Time Range selected on Assessment, reported as the Percentile value based on the percentile number selected in assessment.
	PercentageMemoryUtilization *float64 `json:"percentageMemoryUtilization,omitempty"`
	// PercentageCoresUtilizationDataPointsExpected - Expected data points for percentage of cores utilization.
	PercentageCoresUtilizationDataPointsExpected *int32 `json:"percentageCoresUtilizationDataPointsExpected,omitempty"`
	// PercentageCoresUtilizationDataPointsReceived - Received data points for percentage of cores utilization.
	PercentageCoresUtilizationDataPointsReceived *int32 `json:"percentageCoresUtilizationDataPointsReceived,omitempty"`
	// PercentageMemoryUtilizationDataPointsExpected - Expected data points for percentage of memory utilization.
	PercentageMemoryUtilizationDataPointsExpected *int32 `json:"percentageMemoryUtilizationDataPointsExpected,omitempty"`
	// PercentageMemoryUtilizationDataPointsReceived - Received data points for percentage of memory utilization.
	PercentageMemoryUtilizationDataPointsReceived *int32 `json:"percentageMemoryUtilizationDataPointsReceived,omitempty"`
	// Suitability - Whether machine is suitable for migration to Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - If machine is not ready to be migrated, this explains the reasons and mitigation steps. Possible values include: 'AzureVMSuitabilityExplanationUnknown', 'AzureVMSuitabilityExplanationNotApplicable', 'AzureVMSuitabilityExplanationGuestOperatingSystemArchitectureNotSupported', 'AzureVMSuitabilityExplanationGuestOperatingSystemNotSupported', 'AzureVMSuitabilityExplanationBootTypeNotSupported', 'AzureVMSuitabilityExplanationMoreDisksThanSupported', 'AzureVMSuitabilityExplanationNoSuitableVMSizeFound', 'AzureVMSuitabilityExplanationOneOrMoreDisksNotSuitable', 'AzureVMSuitabilityExplanationOneOrMoreAdaptersNotSuitable', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringComputeEvaluation', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringStorageEvaluation', 'AzureVMSuitabilityExplanationInternalErrorOccuredDuringNetworkEvaluation', 'AzureVMSuitabilityExplanationNoVMSizeSupportsStoragePerformance', 'AzureVMSuitabilityExplanationNoVMSizeSupportsNetworkPerformance', 'AzureVMSuitabilityExplanationNoVMSizeForSelectedPricingTier', 'AzureVMSuitabilityExplanationNoVMSizeForSelectedAzureLocation', 'AzureVMSuitabilityExplanationCheckRedHatLinuxVersion', 'AzureVMSuitabilityExplanationCheckOpenSuseLinuxVersion', 'AzureVMSuitabilityExplanationCheckWindowsServer2008R2Version', 'AzureVMSuitabilityExplanationCheckCentOsVersion', 'AzureVMSuitabilityExplanationCheckDebianLinuxVersion', 'AzureVMSuitabilityExplanationCheckSuseLinuxVersion', 'AzureVMSuitabilityExplanationCheckOracleLinuxVersion', 'AzureVMSuitabilityExplanationCheckUbuntuLinuxVersion', 'AzureVMSuitabilityExplanationCheckCoreOsLinuxVersion', 'AzureVMSuitabilityExplanationWindowsServerVersionConditionallySupported', 'AzureVMSuitabilityExplanationNoGuestOperatingSystemConditionallySupported', 'AzureVMSuitabilityExplanationWindowsClientVersionsConditionallySupported', 'AzureVMSuitabilityExplanationBootTypeUnknown', 'AzureVMSuitabilityExplanationGuestOperatingSystemUnknown', 'AzureVMSuitabilityExplanationWindowsServerVersionsSupportedWithCaveat', 'AzureVMSuitabilityExplanationWindowsOSNoLongerUnderMSSupport', 'AzureVMSuitabilityExplanationEndorsedWithConditionsLinuxDistributions', 'AzureVMSuitabilityExplanationUnendorsedLinuxDistributions', 'AzureVMSuitabilityExplanationNoVMSizeForStandardPricingTier', 'AzureVMSuitabilityExplanationNoVMSizeForBasicPricingTier'
	SuitabilityExplanation AzureVMSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
	// CreatedTimestamp - Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessedMachineProperties.
func (amp AssessedMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if amp.Groups != nil {
		objectMap["groups"] = amp.Groups
	}
	if amp.DiscoveredTimestamp != nil {
		objectMap["discoveredTimestamp"] = amp.DiscoveredTimestamp
	}
	if amp.BootType != "" {
		objectMap["bootType"] = amp.BootType
	}
	if amp.DatacenterContainer != nil {
		objectMap["datacenterContainer"] = amp.DatacenterContainer
	}
	if amp.DatacenterManagementServer != nil {
		objectMap["datacenterManagementServer"] = amp.DatacenterManagementServer
	}
	if amp.DatacenterMachineID != nil {
		objectMap["datacenterMachineId"] = amp.DatacenterMachineID
	}
	if amp.DatacenterManagementServerID != nil {
		objectMap["datacenterManagementServerId"] = amp.DatacenterManagementServerID
	}
	if amp.Description != nil {
		objectMap["description"] = amp.Description
	}
	if amp.DisplayName != nil {
		objectMap["displayName"] = amp.DisplayName
	}
	if amp.MegabytesOfMemory != nil {
		objectMap["megabytesOfMemory"] = amp.MegabytesOfMemory
	}
	if amp.NumberOfCores != nil {
		objectMap["numberOfCores"] = amp.NumberOfCores
	}
	if amp.OperatingSystem != nil {
		objectMap["operatingSystem"] = amp.OperatingSystem
	}
	if amp.MonthlyBandwidthCost != nil {
		objectMap["monthlyBandwidthCost"] = amp.MonthlyBandwidthCost
	}
	if amp.MonthlyStorageCost != nil {
		objectMap["monthlyStorageCost"] = amp.MonthlyStorageCost
	}
	if amp.Disks != nil {
		objectMap["disks"] = amp.Disks
	}
	if amp.NetworkAdapters != nil {
		objectMap["networkAdapters"] = amp.NetworkAdapters
	}
	if amp.RecommendedSize != "" {
		objectMap["recommendedSize"] = amp.RecommendedSize
	}
	if amp.NumberOfCoresForRecommendedSize != nil {
		objectMap["numberOfCoresForRecommendedSize"] = amp.NumberOfCoresForRecommendedSize
	}
	if amp.MegabytesOfMemoryForRecommendedSize != nil {
		objectMap["megabytesOfMemoryForRecommendedSize"] = amp.MegabytesOfMemoryForRecommendedSize
	}
	if amp.MonthlyComputeCostForRecommendedSize != nil {
		objectMap["monthlyComputeCostForRecommendedSize"] = amp.MonthlyComputeCostForRecommendedSize
	}
	if amp.PercentageCoresUtilization != nil {
		objectMap["percentageCoresUtilization"] = amp.PercentageCoresUtilization
	}
	if amp.PercentageMemoryUtilization != nil {
		objectMap["percentageMemoryUtilization"] = amp.PercentageMemoryUtilization
	}
	if amp.PercentageCoresUtilizationDataPointsExpected != nil {
		objectMap["percentageCoresUtilizationDataPointsExpected"] = amp.PercentageCoresUtilizationDataPointsExpected
	}
	if amp.PercentageCoresUtilizationDataPointsReceived != nil {
		objectMap["percentageCoresUtilizationDataPointsReceived"] = amp.PercentageCoresUtilizationDataPointsReceived
	}
	if amp.PercentageMemoryUtilizationDataPointsExpected != nil {
		objectMap["percentageMemoryUtilizationDataPointsExpected"] = amp.PercentageMemoryUtilizationDataPointsExpected
	}
	if amp.PercentageMemoryUtilizationDataPointsReceived != nil {
		objectMap["percentageMemoryUtilizationDataPointsReceived"] = amp.PercentageMemoryUtilizationDataPointsReceived
	}
	if amp.Suitability != "" {
		objectMap["suitability"] = amp.Suitability
	}
	if amp.SuitabilityExplanation != "" {
		objectMap["suitabilityExplanation"] = amp.SuitabilityExplanation
	}
	if amp.CreatedTimestamp != nil {
		objectMap["createdTimestamp"] = amp.CreatedTimestamp
	}
	if amp.UpdatedTimestamp != nil {
		objectMap["updatedTimestamp"] = amp.UpdatedTimestamp
	}
	return json.Marshal(objectMap)
}

// AssessedMachineResultList list of assessed machines.
type AssessedMachineResultList struct {
	autorest.Response `json:"-"`
	// Value - List of assessed machines.
	Value *[]AssessedMachine `json:"value,omitempty"`
}

// AssessedNetworkAdapter a network adapter assessed for an assessment.
type AssessedNetworkAdapter struct {
	// MacAddress - MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddresses - List of IP Addresses on the network adapter.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// MonthlyBandwidthCosts - Monthly cost estimate for network bandwidth used by this network adapter.
	MonthlyBandwidthCosts *float64 `json:"monthlyBandwidthCosts,omitempty"`
	// MegabytesPerSecondReceived - Adapter throughput for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceived *float64 `json:"megabytesPerSecondReceived,omitempty"`
	// MegabytesPerSecondReceivedDataPointsExpected - Expected data points for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceivedDataPointsExpected *int32 `json:"megabytesPerSecondReceivedDataPointsExpected,omitempty"`
	// MegabytesPerSecondOfReadDataPointsReceived - Received data points for incoming traffic in MegaBytes per second.
	MegabytesPerSecondOfReadDataPointsReceived *int32 `json:"megabytesPerSecondOfReadDataPointsReceived,omitempty"`
	// MegabytesPerSecondTransmitted - Adapter throughput for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmitted *float64 `json:"megabytesPerSecondTransmitted,omitempty"`
	// MegabytesPerSecondTransmittedDataPointsExpected - Expected data points for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmittedDataPointsExpected *int32 `json:"megabytesPerSecondTransmittedDataPointsExpected,omitempty"`
	// MegabytesPerSecondTransmittedDataPointsReceived - Received data points for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmittedDataPointsReceived *int32 `json:"megabytesPerSecondTransmittedDataPointsReceived,omitempty"`
	// NetGigabytesTransmittedPerMonth - Gigabytes transmitted through this adapter each month.
	NetGigabytesTransmittedPerMonth *float64 `json:"netGigabytesTransmittedPerMonth,omitempty"`
	// Suitability - Whether this adapter is suitable for Azure. Possible values include: 'CloudSuitabilityUnknown', 'CloudSuitabilityNotSuitable', 'CloudSuitabilitySuitable', 'CloudSuitabilityConditionallySuitable', 'CloudSuitabilityReadinessUnknown'
	Suitability CloudSuitability `json:"suitability,omitempty"`
	// SuitabilityExplanation - If network adapter is suitable, this explains the reasons and mitigation steps. Possible values include: 'AzureNetworkAdapterSuitabilityExplanationUnknown', 'AzureNetworkAdapterSuitabilityExplanationNotApplicable', 'AzureNetworkAdapterSuitabilityExplanationInternalErrorOccured'
	SuitabilityExplanation AzureNetworkAdapterSuitabilityExplanation `json:"suitabilityExplanation,omitempty"`
}

// Assessment an assessment created for a group in the Migration project.
type Assessment struct {
	autorest.Response `json:"-"`
	// ID - Path reference to this assessment. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}/assessment/{assessmentName}
	ID *string `json:"id,omitempty"`
	// Name - Unique name of an assessment.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - Type of the object = [Microsoft.Migrate/projects/groups/assessments].
	Type *string `json:"type,omitempty"`
	// AssessmentProperties - Properties of the assessment.
	*AssessmentProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.ETag != nil {
		objectMap["eTag"] = a.ETag
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.AssessmentProperties != nil {
		objectMap["properties"] = a.AssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assessment struct.
func (a *Assessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				a.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var assessmentProperties AssessmentProperties
				err = json.Unmarshal(*v, &assessmentProperties)
				if err != nil {
					return err
				}
				a.AssessmentProperties = &assessmentProperties
			}
		}
	}

	return nil
}

// AssessmentProperties properties of an assessment.
type AssessmentProperties struct {
	// AzureLocation - Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API. Possible values include: 'AzureLocationUnknown', 'AzureLocationEastAsia', 'AzureLocationSoutheastAsia', 'AzureLocationAustraliaEast', 'AzureLocationAustraliaSoutheast', 'AzureLocationBrazilSouth', 'AzureLocationCanadaCentral', 'AzureLocationCanadaEast', 'AzureLocationWestEurope', 'AzureLocationNorthEurope', 'AzureLocationCentralIndia', 'AzureLocationSouthIndia', 'AzureLocationWestIndia', 'AzureLocationJapanEast', 'AzureLocationJapanWest', 'AzureLocationKoreaCentral', 'AzureLocationKoreaSouth', 'AzureLocationUkWest', 'AzureLocationUkSouth', 'AzureLocationNorthCentralUs', 'AzureLocationEastUs', 'AzureLocationWestUs2', 'AzureLocationSouthCentralUs', 'AzureLocationCentralUs', 'AzureLocationEastUs2', 'AzureLocationWestUs', 'AzureLocationWestCentralUs', 'AzureLocationGermanyCentral', 'AzureLocationGermanyNortheast', 'AzureLocationChinaNorth', 'AzureLocationChinaEast'
	AzureLocation AzureLocation `json:"azureLocation,omitempty"`
	// AzureOfferCode - Offer code according to which cost estimation is done. Possible values include: 'AzureOfferCodeUnknown', 'AzureOfferCodeMSAZR0003P', 'AzureOfferCodeMSAZR0044P', 'AzureOfferCodeMSAZR0059P', 'AzureOfferCodeMSAZR0060P', 'AzureOfferCodeMSAZR0062P', 'AzureOfferCodeMSAZR0063P', 'AzureOfferCodeMSAZR0064P', 'AzureOfferCodeMSAZR0029P', 'AzureOfferCodeMSAZR0022P', 'AzureOfferCodeMSAZR0023P', 'AzureOfferCodeMSAZR0148P', 'AzureOfferCodeMSAZR0025P', 'AzureOfferCodeMSAZR0036P', 'AzureOfferCodeMSAZR0120P', 'AzureOfferCodeMSAZR0121P', 'AzureOfferCodeMSAZR0122P', 'AzureOfferCodeMSAZR0123P', 'AzureOfferCodeMSAZR0124P', 'AzureOfferCodeMSAZR0125P', 'AzureOfferCodeMSAZR0126P', 'AzureOfferCodeMSAZR0127P', 'AzureOfferCodeMSAZR0128P', 'AzureOfferCodeMSAZR0129P', 'AzureOfferCodeMSAZR0130P', 'AzureOfferCodeMSAZR0111P', 'AzureOfferCodeMSAZR0144P', 'AzureOfferCodeMSAZR0149P', 'AzureOfferCodeMSMCAZR0044P', 'AzureOfferCodeMSMCAZR0059P', 'AzureOfferCodeMSMCAZR0060P', 'AzureOfferCodeMSMCAZR0063P', 'AzureOfferCodeMSMCAZR0120P', 'AzureOfferCodeMSMCAZR0121P', 'AzureOfferCodeMSMCAZR0125P', 'AzureOfferCodeMSMCAZR0128P', 'AzureOfferCodeMSAZRDE0003P', 'AzureOfferCodeMSAZRDE0044P'
	AzureOfferCode AzureOfferCode `json:"azureOfferCode,omitempty"`
	// AzurePricingTier - Pricing tier for Size evaluation. Possible values include: 'Standard', 'Basic'
	AzurePricingTier AzurePricingTier `json:"azurePricingTier,omitempty"`
	// AzureStorageRedundancy - Storage Redundancy type offered by Azure. Possible values include: 'AzureStorageRedundancyUnknown', 'AzureStorageRedundancyLocallyRedundant', 'AzureStorageRedundancyZoneRedundant', 'AzureStorageRedundancyGeoRedundant', 'AzureStorageRedundancyReadAccessGeoRedundant'
	AzureStorageRedundancy AzureStorageRedundancy `json:"azureStorageRedundancy,omitempty"`
	// ScalingFactor - Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
	ScalingFactor *float64 `json:"scalingFactor,omitempty"`
	// Percentile - Percentile of performance data used to recommend Azure size. Possible values include: 'Percentile50', 'Percentile90', 'Percentile95', 'Percentile99'
	Percentile Percentile `json:"percentile,omitempty"`
	// TimeRange - Time range of performance data used to recommend a size. Possible values include: 'Day', 'Week', 'Month'
	TimeRange TimeRange `json:"timeRange,omitempty"`
	// Stage - User configurable setting that describes the status of the assessment. Possible values include: 'InProgress', 'UnderReview', 'Approved'
	Stage AssessmentStage `json:"stage,omitempty"`
	// Currency - Currency to report prices in. Possible values include: 'CurrencyUnknown', 'CurrencyUSD', 'CurrencyDKK', 'CurrencyCAD', 'CurrencyIDR', 'CurrencyJPY', 'CurrencyKRW', 'CurrencyNZD', 'CurrencyNOK', 'CurrencyRUB', 'CurrencySAR', 'CurrencyZAR', 'CurrencySEK', 'CurrencyTRY', 'CurrencyGBP', 'CurrencyMXN', 'CurrencyMYR', 'CurrencyINR', 'CurrencyHKD', 'CurrencyBRL', 'CurrencyTWD', 'CurrencyEUR', 'CurrencyCHF', 'CurrencyARS', 'CurrencyAUD', 'CurrencyCNY'
	Currency Currency `json:"currency,omitempty"`
	// AzureHybridUseBenefit - AHUB discount on windows virtual machines. Possible values include: 'AzureHybridUseBenefitUnknown', 'AzureHybridUseBenefitYes', 'AzureHybridUseBenefitNo'
	AzureHybridUseBenefit AzureHybridUseBenefit `json:"azureHybridUseBenefit,omitempty"`
	// DiscountPercentage - Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
	DiscountPercentage *float64 `json:"discountPercentage,omitempty"`
	// ConfidenceRatingInPercentage - Confidence rating percentage for assessment. Can be in the range [0, 100].
	ConfidenceRatingInPercentage *float64 `json:"confidenceRatingInPercentage,omitempty"`
	// SizingCriterion - Assessment sizing criterion. Possible values include: 'PerformanceBased', 'AsOnPremises'
	SizingCriterion AssessmentSizingCriterion `json:"sizingCriterion,omitempty"`
	// PricesTimestamp - Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
	PricesTimestamp *date.Time `json:"pricesTimestamp,omitempty"`
	// CreatedTimestamp - Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// MonthlyComputeCost - Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyComputeCost *float64 `json:"monthlyComputeCost,omitempty"`
	// MonthlyBandwidthCost - Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyBandwidthCost *float64 `json:"monthlyBandwidthCost,omitempty"`
	// MonthlyStorageCost - Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyStorageCost *float64 `json:"monthlyStorageCost,omitempty"`
	// Status - Wheter the assessment has been created and is valid. Possible values include: 'Created', 'Updated', 'Running', 'Completed', 'Invalid'
	Status AssessmentStatus `json:"status,omitempty"`
	// NumberOfMachines - Number of assessed machines part of this assessment.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty"`
}

// AssessmentResultList list of assessments.
type AssessmentResultList struct {
	autorest.Response `json:"-"`
	// Value - List of assessments.
	Value *[]Assessment `json:"value,omitempty"`
}

// Disk a disk discovered on a machine.
type Disk struct {
	// GigabytesAllocated - Gigabytes of storage provisioned for this disk.
	GigabytesAllocated *float64 `json:"gigabytesAllocated,omitempty"`
	// GigabytesConsumed - Gigabytes of storage consumed by this disk.
	GigabytesConsumed *float64 `json:"gigabytesConsumed,omitempty"`
}

// DownloadURL download URL for assessment report.
type DownloadURL struct {
	autorest.Response `json:"-"`
	// AssessmentReportURL - Hyperlink to download report.
	AssessmentReportURL *string `json:"assessmentReportUrl,omitempty"`
	// ExpirationTime - Expiry date of download url.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// Group a group created in a Migration project.
type Group struct {
	autorest.Response `json:"-"`
	// ID - Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/groups/{groupName}
	ID *string `json:"id,omitempty"`
	// Name - Name of the group.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - Type of the object = [Microsoft.Migrate/projects/groups].
	Type *string `json:"type,omitempty"`
	// GroupProperties - Properties of the group.
	*GroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.ID != nil {
		objectMap["id"] = g.ID
	}
	if g.Name != nil {
		objectMap["name"] = g.Name
	}
	if g.ETag != nil {
		objectMap["eTag"] = g.ETag
	}
	if g.Type != nil {
		objectMap["type"] = g.Type
	}
	if g.GroupProperties != nil {
		objectMap["properties"] = g.GroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				g.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		}
	}

	return nil
}

// GroupProperties properties of group resource.
type GroupProperties struct {
	// Machines - List of machine names that are part of this group.
	Machines *[]string `json:"machines,omitempty"`
	// Assessments - List of References to Assessments created on this group.
	Assessments *[]string `json:"assessments,omitempty"`
	// CreatedTimestamp - Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
}

// GroupResultList list of groups.
type GroupResultList struct {
	autorest.Response `json:"-"`
	// Value - List of groups.
	Value *[]Group `json:"value,omitempty"`
}

// Machine a machine in a migration project.
type Machine struct {
	autorest.Response `json:"-"`
	// ID - Path reference to this machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}/machines/{machineName}
	ID *string `json:"id,omitempty"`
	// Name - Name of the machine. It is a GUID which is unique identifier of machine in private data center. For user-readable name, we have a displayName property on this machine.
	Name *string `json:"name,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Type - Type of the object = [Microsoft.Migrate/projects/machines].
	Type *string `json:"type,omitempty"`
	// MachineProperties - Properties of the machine.
	*MachineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Machine.
func (mVar Machine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	if mVar.ETag != nil {
		objectMap["eTag"] = mVar.ETag
	}
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	if mVar.MachineProperties != nil {
		objectMap["properties"] = mVar.MachineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Machine struct.
func (mVar *Machine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				mVar.ETag = &eTag
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var machineProperties MachineProperties
				err = json.Unmarshal(*v, &machineProperties)
				if err != nil {
					return err
				}
				mVar.MachineProperties = &machineProperties
			}
		}
	}

	return nil
}

// MachineProperties properties of a machine.
type MachineProperties struct {
	// BootType - Boot type of the machine. Possible values include: 'MachineBootTypeUnknown', 'MachineBootTypeEFI', 'MachineBootTypeBIOS'
	BootType MachineBootType `json:"bootType,omitempty"`
	// DatacenterContainer - Container defined in the management solution that this machine is part of in the datacenter.
	DatacenterContainer *string `json:"datacenterContainer,omitempty"`
	// DatacenterManagementServer - Name of the server hosting the datacenter management solution.
	DatacenterManagementServer *string `json:"datacenterManagementServer,omitempty"`
	// DatacenterMachineID - ID of the machine as tracked by the datacenter management solution.
	DatacenterMachineID *string `json:"datacenterMachineId,omitempty"`
	// DatacenterManagementServerID - ID of the server hosting the datacenter management solution.
	DatacenterManagementServerID *string `json:"datacenterManagementServerId,omitempty"`
	// Description - Description of the machine
	Description *string `json:"description,omitempty"`
	// DisplayName - User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string `json:"displayName,omitempty"`
	// MegabytesOfMemory - Memory in Megabytes.
	MegabytesOfMemory *float64 `json:"megabytesOfMemory,omitempty"`
	// NumberOfCores - Processor count.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// OperatingSystem - Operating System of the machine.
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// Groups - List of references to the groups that the machine is member of.
	Groups *[]string `json:"groups,omitempty"`
	// CreatedTimestamp - Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// DiscoveredTimestamp - Time when this machine was discovered by Azure Migrate agent. Date-Time represented in ISO-8601 format.
	DiscoveredTimestamp *date.Time `json:"discoveredTimestamp,omitempty"`
	// Disks - Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object
	Disks map[string]*Disk `json:"disks"`
	// NetworkAdapters - Dictionary of network adapters attached to the machine. Key is ID of network adapter. Value is a network adapter object
	NetworkAdapters map[string]*NetworkAdapter `json:"networkAdapters"`
}

// MarshalJSON is the custom marshaler for MachineProperties.
func (mp MachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.BootType != "" {
		objectMap["bootType"] = mp.BootType
	}
	if mp.DatacenterContainer != nil {
		objectMap["datacenterContainer"] = mp.DatacenterContainer
	}
	if mp.DatacenterManagementServer != nil {
		objectMap["datacenterManagementServer"] = mp.DatacenterManagementServer
	}
	if mp.DatacenterMachineID != nil {
		objectMap["datacenterMachineId"] = mp.DatacenterMachineID
	}
	if mp.DatacenterManagementServerID != nil {
		objectMap["datacenterManagementServerId"] = mp.DatacenterManagementServerID
	}
	if mp.Description != nil {
		objectMap["description"] = mp.Description
	}
	if mp.DisplayName != nil {
		objectMap["displayName"] = mp.DisplayName
	}
	if mp.MegabytesOfMemory != nil {
		objectMap["megabytesOfMemory"] = mp.MegabytesOfMemory
	}
	if mp.NumberOfCores != nil {
		objectMap["numberOfCores"] = mp.NumberOfCores
	}
	if mp.OperatingSystem != nil {
		objectMap["operatingSystem"] = mp.OperatingSystem
	}
	if mp.Groups != nil {
		objectMap["groups"] = mp.Groups
	}
	if mp.CreatedTimestamp != nil {
		objectMap["createdTimestamp"] = mp.CreatedTimestamp
	}
	if mp.UpdatedTimestamp != nil {
		objectMap["updatedTimestamp"] = mp.UpdatedTimestamp
	}
	if mp.DiscoveredTimestamp != nil {
		objectMap["discoveredTimestamp"] = mp.DiscoveredTimestamp
	}
	if mp.Disks != nil {
		objectMap["disks"] = mp.Disks
	}
	if mp.NetworkAdapters != nil {
		objectMap["networkAdapters"] = mp.NetworkAdapters
	}
	return json.Marshal(objectMap)
}

// MachineResultList list of machines.
type MachineResultList struct {
	autorest.Response `json:"-"`
	// Value - List of machines.
	Value *[]Machine `json:"value,omitempty"`
}

// NetworkAdapter a network adapter discovered on a machine.
type NetworkAdapter struct {
	// MacAddress - MAC Address of the network adapter.
	MacAddress *string `json:"macAddress,omitempty"`
	// IPAddresses - List of IP Addresses on the network adapter.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
}

// Operation a REST API operation supported by the provider.
type Operation struct {
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Displayable properties of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay displayable properties of the operation.
type OperationDisplay struct {
	// Provider - Provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource operated on by the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation Type.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationResultList list of API operations.
type OperationResultList struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
}

// Project azure Migrate Project.
type Project struct {
	autorest.Response `json:"-"`
	// ID - Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/projects/{projectName}
	ID *string `json:"id,omitempty"`
	// Name - Name of the project.
	Name *string `json:"name,omitempty"`
	// Type - Type of the object = [Microsoft.Migrate/projects].
	Type *string `json:"type,omitempty"`
	// ETag - For optimistic concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Location - Azure location in which project is created.
	Location *string `json:"location,omitempty"`
	// Tags - Tags provided by Azure Tagging service.
	Tags interface{} `json:"tags,omitempty"`
	// ProjectProperties - Properties of the project.
	*ProjectProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	if p.ETag != nil {
		objectMap["eTag"] = p.ETag
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	objectMap["tags"] = p.Tags
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				p.ETag = &eTag
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		}
	}

	return nil
}

// ProjectKey ID and Key for Migration Project.
type ProjectKey struct {
	autorest.Response `json:"-"`
	// WorkspaceID - ID of Migration Project.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceKey - Key of Migration Project.
	WorkspaceKey *string `json:"workspaceKey,omitempty"`
}

// ProjectProperties properties of a project.
type ProjectProperties struct {
	// CreatedTimestamp - Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *date.Time `json:"createdTimestamp,omitempty"`
	// UpdatedTimestamp - Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *date.Time `json:"updatedTimestamp,omitempty"`
	// DiscoveryStatus - Reports whether project is under discovery. Possible values include: 'DiscoveryStatusUnknown', 'DiscoveryStatusNotStarted', 'DiscoveryStatusInProgress', 'DiscoveryStatusCompleted'
	DiscoveryStatus DiscoveryStatus `json:"discoveryStatus,omitempty"`
	// CustomerWorkspaceID - ARM ID of the Service Map workspace created by user.
	CustomerWorkspaceID *string `json:"customerWorkspaceId,omitempty"`
	// CustomerWorkspaceLocation - Location of the Service Map workspace created by user.
	CustomerWorkspaceLocation *string `json:"customerWorkspaceLocation,omitempty"`
	// LastDiscoveryTimestamp - Time when this project was created. Date-Time represented in ISO-8601 format. This value will be null until discovery is complete.
	LastDiscoveryTimestamp *date.Time `json:"lastDiscoveryTimestamp,omitempty"`
	// LastDiscoverySessionID - Session id of the last discovery.
	LastDiscoverySessionID *string `json:"lastDiscoverySessionId,omitempty"`
	// NumberOfGroups - Number of groups created in the project.
	NumberOfGroups *int32 `json:"numberOfGroups,omitempty"`
	// NumberOfMachines - Number of machines in the project.
	NumberOfMachines *int32 `json:"numberOfMachines,omitempty"`
	// NumberOfAssessments - Number of assessments created in the project.
	NumberOfAssessments *int32 `json:"numberOfAssessments,omitempty"`
	// LastAssessmentTimestamp - Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created.
	LastAssessmentTimestamp *date.Time `json:"lastAssessmentTimestamp,omitempty"`
	// ProvisioningState - Provisioning state of the project. Possible values include: 'Accepted', 'Creating', 'Deleting', 'Failed', 'Moving', 'Succeeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ProjectResultList list of projects.
type ProjectResultList struct {
	autorest.Response `json:"-"`
	// Value - List of projects.
	Value *[]Project `json:"value,omitempty"`
}
