// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ec2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To allocate an Elastic IP address for EC2-VPC
//
// This example allocates an Elastic IP address to use with an instance in a VPC.
func ExampleEC2_AllocateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AllocateAddressInput{
		Domain: aws.String("vpc"),
	}

	result, err := svc.AllocateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To allocate an Elastic IP address for EC2-Classic
//
// This example allocates an Elastic IP address to use with an instance in EC2-Classic.
func ExampleEC2_AllocateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AllocateAddressInput{}

	result, err := svc.AllocateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign a specific secondary private IP address to an interface
//
// This example assigns the specified secondary private IP address to the specified
// network interface.
func ExampleEC2_AssignPrivateIpAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []*string{
			aws.String("10.0.0.82"),
		},
	}

	result, err := svc.AssignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign secondary private IP addresses that Amazon EC2 selects to an interface
//
// This example assigns two secondary private IP addresses to the specified network
// interface. Amazon EC2 automatically assigns these IP addresses from the available
// IP addresses in the CIDR block range of the subnet the network interface is associated
// with.
func ExampleEC2_AssignPrivateIpAddresses_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId:             aws.String("eni-e5aa89a3"),
		SecondaryPrivateIpAddressCount: aws.Int64(2),
	}

	result, err := svc.AssignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-VPC
//
// This example associates the specified Elastic IP address with the specified instance
// in a VPC.
func ExampleEC2_AssociateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
		InstanceId:   aws.String("i-0b263919b6498b123"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address with a network interface
//
// This example associates the specified Elastic IP address with the specified network
// interface.
func ExampleEC2_AssociateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		AllocationId:       aws.String("eipalloc-64d5890a"),
		NetworkInterfaceId: aws.String("eni-1a2b3c4d"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-Classic
//
// This example associates an Elastic IP address with an instance in EC2-Classic.
func ExampleEC2_AssociateAddress_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		InstanceId: aws.String("i-07ffe74c7330ebf53"),
		PublicIp:   aws.String("198.51.100.0"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a DHCP options set with a VPC
//
// This example associates the specified DHCP options set with the specified VPC.
func ExampleEC2_AssociateDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	result, err := svc.AssociateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate the default DHCP options set with a VPC
//
// This example associates the default DHCP options set with the specified VPC.
func ExampleEC2_AssociateDhcpOptions_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("default"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	result, err := svc.AssociateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an IAM instance profile with an instance
//
// This example associates an IAM instance profile named admin-role with the specified
// instance.
func ExampleEC2_AssociateIamInstanceProfile_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateIamInstanceProfileInput{
		IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
			Name: aws.String("admin-role"),
		},
		InstanceId: aws.String("i-123456789abcde123"),
	}

	result, err := svc.AssociateIamInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a route table with a subnet
//
// This example associates the specified route table with the specified subnet.
func ExampleEC2_AssociateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
		SubnetId:     aws.String("subnet-9d4a7b6"),
	}

	result, err := svc.AssociateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach an Internet gateway to a VPC
//
// This example attaches the specified Internet gateway to the specified VPC.
func ExampleEC2_AttachInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	result, err := svc.AttachInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a network interface to an instance
//
// This example attaches the specified network interface to the specified instance.
func ExampleEC2_AttachNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachNetworkInterfaceInput{
		DeviceIndex:        aws.Int64(1),
		InstanceId:         aws.String("i-1234567890abcdef0"),
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	result, err := svc.AttachNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a volume to an instance
//
// This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``)
// as ``/dev/sdf``.
func ExampleEC2_AttachVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachVolumeInput{
		Device:     aws.String("/dev/sdf"),
		InstanceId: aws.String("i-01474ef662b89480"),
		VolumeId:   aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.AttachVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows outbound traffic to a specific address range
//
// This example adds a rule that grants access to the specified address ranges on TCP
// port 80.
func ExampleEC2_AuthorizeSecurityGroupEgress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AuthorizeSecurityGroupEgressInput{
		GroupId: aws.String("sg-1a2b3c4d"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				IpRanges: []*ec2.IpRange{
					{
						CidrIp: aws.String("10.0.0.0/16"),
					},
				},
				ToPort: aws.Int64(80),
			},
		},
	}

	result, err := svc.AuthorizeSecurityGroupEgress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows outbound traffic to a specific security group
//
// This example adds a rule that grants access to the specified security group on TCP
// port 80.
func ExampleEC2_AuthorizeSecurityGroupEgress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AuthorizeSecurityGroupEgressInput{
		GroupId: aws.String("sg-1a2b3c4d"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				ToPort:     aws.Int64(80),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{
						GroupId: aws.String("sg-4b51a32f"),
					},
				},
			},
		},
	}

	result, err := svc.AuthorizeSecurityGroupEgress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound SSH traffic from an IPv4 address range
//
// This example enables inbound traffic on TCP port 22 (SSH). The rule includes a description
// to help you identify it later.
func ExampleEC2_AuthorizeSecurityGroupIngress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-903004f8"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(22),
				IpProtocol: aws.String("tcp"),
				IpRanges: []*ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/24"),
						Description: aws.String("SSH access from the LA office"),
					},
				},
				ToPort: aws.Int64(22),
			},
		},
	}

	result, err := svc.AuthorizeSecurityGroupIngress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound HTTP traffic from another security group
//
// This example enables inbound traffic on TCP port 80 from the specified security group.
// The group must be in the same VPC or a peer VPC. Incoming traffic is allowed based
// on the private IP addresses of instances that are associated with the specified security
// group.
func ExampleEC2_AuthorizeSecurityGroupIngress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-111aaa22"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				ToPort:     aws.Int64(80),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{
						Description: aws.String("HTTP access from other instances"),
						GroupId:     aws.String("sg-1a2b3c4d"),
					},
				},
			},
		},
	}

	result, err := svc.AuthorizeSecurityGroupIngress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a rule that allows inbound RDP traffic from an IPv6 address range
//
// This example adds an inbound rule that allows RDP traffic from the specified IPv6
// address range. The rule includes a description to help you identify it later.
func ExampleEC2_AuthorizeSecurityGroupIngress_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.AuthorizeSecurityGroupIngressInput{
		GroupId: aws.String("sg-123abc12 "),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(3389),
				IpProtocol: aws.String("tcp"),
				Ipv6Ranges: []*ec2.Ipv6Range{
					{
						CidrIpv6:    aws.String("2001:db8:1234:1a00::/64"),
						Description: aws.String("RDP access from the NY office"),
					},
				},
				ToPort: aws.Int64(3389),
			},
		},
	}

	result, err := svc.AuthorizeSecurityGroupIngress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request
//
// This example cancels the specified Spot fleet request and terminates its associated
// Spot Instances.
func ExampleEC2_CancelSpotFleetRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
		TerminateInstances: aws.Bool(true),
	}

	result, err := svc.CancelSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request without terminating its Spot Instances
//
// This example cancels the specified Spot fleet request without terminating its associated
// Spot Instances.
func ExampleEC2_CancelSpotFleetRequests_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
		TerminateInstances: aws.Bool(false),
	}

	result, err := svc.CancelSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel Spot Instance requests
//
// This example cancels a Spot Instance request.
func ExampleEC2_CancelSpotInstanceRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []*string{
			aws.String("sir-08b93456"),
		},
	}

	result, err := svc.CancelSpotInstanceRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To confirm the product instance
//
// This example determines whether the specified product code is associated with the
// specified instance.
func ExampleEC2_ConfirmProductInstance_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ConfirmProductInstanceInput{
		InstanceId:  aws.String("i-1234567890abcdef0"),
		ProductCode: aws.String("774F4FF8"),
	}

	result, err := svc.ConfirmProductInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy an AMI to another region
//
// This example copies the specified AMI from the us-east-1 region to the current region.
func ExampleEC2_CopyImage_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CopyImageInput{
		Description:   aws.String(""),
		Name:          aws.String("My server"),
		SourceImageId: aws.String("ami-5731123e"),
		SourceRegion:  aws.String("us-east-1"),
	}

	result, err := svc.CopyImage(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a snapshot
//
// This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b``
// from the ``us-west-2`` region to the ``us-east-1`` region and adds a short description
// to identify the snapshot.
func ExampleEC2_CopySnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CopySnapshotInput{
		Description:       aws.String("This is my copied snapshot."),
		DestinationRegion: aws.String("us-east-1"),
		SourceRegion:      aws.String("us-west-2"),
		SourceSnapshotId:  aws.String("snap-066877671789bd71b"),
	}

	result, err := svc.CopySnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a customer gateway
//
// This example creates a customer gateway with the specified IP address for its outside
// interface.
func ExampleEC2_CreateCustomerGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateCustomerGatewayInput{
		BgpAsn:   aws.Int64(65534),
		PublicIp: aws.String("12.1.2.3"),
		Type:     aws.String("ipsec.1"),
	}

	result, err := svc.CreateCustomerGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DHCP options set
//
// This example creates a DHCP options set.
func ExampleEC2_CreateDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateDhcpOptionsInput{
		DhcpConfigurations: []*ec2.NewDhcpConfiguration{
			{
				Key: aws.String("domain-name-servers"),
				Values: []*string{
					aws.String("10.2.5.1"),
					aws.String("10.2.5.2"),
				},
			},
		},
	}

	result, err := svc.CreateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an AMI from an Amazon EBS-backed instance
//
// This example creates an AMI from the specified instance and adds an EBS volume with
// the device name /dev/sdh and an instance store volume with the device name /dev/sdc.
func ExampleEC2_CreateImage_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateImageInput{
		BlockDeviceMappings: []*ec2.BlockDeviceMapping{
			{
				DeviceName: aws.String("/dev/sdh"),
				Ebs: &ec2.EbsBlockDevice{
					VolumeSize: aws.Int64(100),
				},
			},
			{
				DeviceName:  aws.String("/dev/sdc"),
				VirtualName: aws.String("ephemeral1"),
			},
		},
		Description: aws.String("An AMI for my server"),
		InstanceId:  aws.String("i-1234567890abcdef0"),
		Name:        aws.String("My server"),
		NoReboot:    aws.Bool(true),
	}

	result, err := svc.CreateImage(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Internet gateway
//
// This example creates an Internet gateway.
func ExampleEC2_CreateInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateInternetGatewayInput{}

	result, err := svc.CreateInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a key pair
//
// This example creates a key pair named my-key-pair.
func ExampleEC2_CreateKeyPair_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	result, err := svc.CreateKeyPair(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch template
//
// This example creates a launch template that specifies the subnet in which to launch
// the instance, assigns a public IP address and an IPv6 address to the instance, and
// creates a tag for the instance.
func ExampleEC2_CreateLaunchTemplate_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateLaunchTemplateInput{
		LaunchTemplateData: &ec2.RequestLaunchTemplateData{
			ImageId:      aws.String("ami-8c1be5f6"),
			InstanceType: aws.String("t2.small"),
			NetworkInterfaces: []*ec2.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest{
				{
					AssociatePublicIpAddress: aws.Bool(true),
					DeviceIndex:              aws.Int64(0),
					Ipv6AddressCount:         aws.Int64(1),
					SubnetId:                 aws.String("subnet-7b16de0c"),
				},
			},
			TagSpecifications: []*ec2.LaunchTemplateTagSpecificationRequest{
				{
					ResourceType: aws.String("instance"),
					Tags: []*ec2.Tag{
						{
							Key:   aws.String("Name"),
							Value: aws.String("webserver"),
						},
					},
				},
			},
		},
		LaunchTemplateName: aws.String("my-template"),
		VersionDescription: aws.String("WebVersion1"),
	}

	result, err := svc.CreateLaunchTemplate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch template version
//
// This example creates a new launch template version based on version 1 of the specified
// launch template and specifies a different AMI ID.
func ExampleEC2_CreateLaunchTemplateVersion_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateLaunchTemplateVersionInput{
		LaunchTemplateData: &ec2.RequestLaunchTemplateData{
			ImageId: aws.String("ami-c998b6b2"),
		},
		LaunchTemplateId:   aws.String("lt-0abcd290751193123"),
		SourceVersion:      aws.String("1"),
		VersionDescription: aws.String("WebVersion2"),
	}

	result, err := svc.CreateLaunchTemplateVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a NAT gateway
//
// This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic
// IP address with the allocation ID eipalloc-37fc1a52 with the NAT gateway.
func ExampleEC2_CreateNatGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNatGatewayInput{
		AllocationId: aws.String("eipalloc-37fc1a52"),
		SubnetId:     aws.String("subnet-1a2b3c4d"),
	}

	result, err := svc.CreateNatGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL
//
// This example creates a network ACL for the specified VPC.
func ExampleEC2_CreateNetworkAcl_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkAclInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateNetworkAcl(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL entry
//
// This example creates an entry for the specified network ACL. The rule allows ingress
// traffic from anywhere (0.0.0.0/0) on UDP port 53 (DNS) into any associated subnet.
func ExampleEC2_CreateNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkAclEntryInput{
		CidrBlock:    aws.String("0.0.0.0/0"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("udp"),
		RuleAction: aws.String("allow"),
		RuleNumber: aws.Int64(100),
	}

	result, err := svc.CreateNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network interface
//
// This example creates a network interface for the specified subnet.
func ExampleEC2_CreateNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkInterfaceInput{
		Description: aws.String("my network interface"),
		Groups: []*string{
			aws.String("sg-903004f8"),
		},
		PrivateIpAddress: aws.String("10.0.2.17"),
		SubnetId:         aws.String("subnet-9d4a7b6c"),
	}

	result, err := svc.CreateNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a placement group
//
// This example creates a placement group with the specified name.
func ExampleEC2_CreatePlacementGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreatePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
		Strategy:  aws.String("cluster"),
	}

	result, err := svc.CreatePlacementGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route
//
// This example creates a route for the specified route table. The route matches all
// traffic (0.0.0.0/0) and routes it to the specified Internet gateway.
func ExampleEC2_CreateRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		GatewayId:            aws.String("igw-c0a643a9"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.CreateRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route table
//
// This example creates a route table for the specified VPC.
func ExampleEC2_CreateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateRouteTableInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a security group for a VPC
//
// This example creates a security group for the specified VPC.
func ExampleEC2_CreateSecurityGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSecurityGroupInput{
		Description: aws.String("My security group"),
		GroupName:   aws.String("my-security-group"),
		VpcId:       aws.String("vpc-1a2b3c4d"),
	}

	result, err := svc.CreateSecurityGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a snapshot
//
// This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0``
// and a short description to identify the snapshot.
func ExampleEC2_CreateSnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSnapshotInput{
		Description: aws.String("This is my root volume snapshot."),
		VolumeId:    aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.CreateSnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a Spot Instance datafeed
//
// This example creates a Spot Instance data feed for your AWS account.
func ExampleEC2_CreateSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSpotDatafeedSubscriptionInput{
		Bucket: aws.String("my-s3-bucket"),
		Prefix: aws.String("spotdata"),
	}

	result, err := svc.CreateSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a subnet
//
// This example creates a subnet in the specified VPC with the specified CIDR block.
// We recommend that you let us select an Availability Zone for you.
func ExampleEC2_CreateSubnet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSubnetInput{
		CidrBlock: aws.String("10.0.1.0/24"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateSubnet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a tag to a resource
//
// This example adds the tag Stack=production to the specified image, or overwrites
// an existing tag for the AMI where the tag key is Stack.
func ExampleEC2_CreateTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateTagsInput{
		Resources: []*string{
			aws.String("ami-78a54011"),
		},
		Tags: []*ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("production"),
			},
		},
	}

	result, err := svc.CreateTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new volume
//
// This example creates an 80 GiB General Purpose (SSD) volume in the Availability Zone
// ``us-east-1a``.
func ExampleEC2_CreateVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Size:             aws.Int64(80),
		VolumeType:       aws.String("gp2"),
	}

	result, err := svc.CreateVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new Provisioned IOPS (SSD) volume from a snapshot
//
// This example creates a new Provisioned IOPS (SSD) volume with 1000 provisioned IOPS
// from a snapshot in the Availability Zone ``us-east-1a``.
func ExampleEC2_CreateVolume_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Iops:             aws.Int64(1000),
		SnapshotId:       aws.String("snap-066877671789bd71b"),
		VolumeType:       aws.String("io1"),
	}

	result, err := svc.CreateVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a VPC
//
// This example creates a VPC with the specified CIDR block.
func ExampleEC2_CreateVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVpcInput{
		CidrBlock: aws.String("10.0.0.0/16"),
	}

	result, err := svc.CreateVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a customer gateway
//
// This example deletes the specified customer gateway.
func ExampleEC2_DeleteCustomerGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteCustomerGatewayInput{
		CustomerGatewayId: aws.String("cgw-0e11f167"),
	}

	result, err := svc.DeleteCustomerGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DHCP options set
//
// This example deletes the specified DHCP options set.
func ExampleEC2_DeleteDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
	}

	result, err := svc.DeleteDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Internet gateway
//
// This example deletes the specified Internet gateway.
func ExampleEC2_DeleteInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
	}

	result, err := svc.DeleteInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a key pair
//
// This example deletes the specified key pair.
func ExampleEC2_DeleteKeyPair_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	result, err := svc.DeleteKeyPair(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch template
//
// This example deletes the specified launch template.
func ExampleEC2_DeleteLaunchTemplate_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteLaunchTemplateInput{
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
	}

	result, err := svc.DeleteLaunchTemplate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch template version
//
// This example deletes the specified launch template version.
func ExampleEC2_DeleteLaunchTemplateVersions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteLaunchTemplateVersionsInput{
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
		Versions: []*string{
			aws.String("1"),
		},
	}

	result, err := svc.DeleteLaunchTemplateVersions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a NAT gateway
//
// This example deletes the specified NAT gateway.
func ExampleEC2_DeleteNatGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNatGatewayInput{
		NatGatewayId: aws.String("nat-04ae55e711cec5680"),
	}

	result, err := svc.DeleteNatGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL
//
// This example deletes the specified network ACL.
func ExampleEC2_DeleteNetworkAcl_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkAclInput{
		NetworkAclId: aws.String("acl-5fb85d36"),
	}

	result, err := svc.DeleteNetworkAcl(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL entry
//
// This example deletes ingress rule number 100 from the specified network ACL.
func ExampleEC2_DeleteNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkAclEntryInput{
		Egress:       aws.Bool(true),
		NetworkAclId: aws.String("acl-5fb85d36"),
		RuleNumber:   aws.Int64(100),
	}

	result, err := svc.DeleteNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network interface
//
// This example deletes the specified network interface.
func ExampleEC2_DeleteNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkInterfaceInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	result, err := svc.DeleteNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a placement group
//
// This example deletes the specified placement group.
//
func ExampleEC2_DeletePlacementGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeletePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
	}

	result, err := svc.DeletePlacementGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route
//
// This example deletes the specified route from the specified route table.
func ExampleEC2_DeleteRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.DeleteRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route table
//
// This example deletes the specified route table.
func ExampleEC2_DeleteRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.DeleteRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a security group
//
// This example deletes the specified security group.
func ExampleEC2_DeleteSecurityGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSecurityGroupInput{
		GroupId: aws.String("sg-903004f8"),
	}

	result, err := svc.DeleteSecurityGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a snapshot
//
// This example deletes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleEC2_DeleteSnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSnapshotInput{
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.DeleteSnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot Instance data feed subscription
//
// This example deletes a Spot data feed subscription for the account.
func ExampleEC2_DeleteSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSpotDatafeedSubscriptionInput{}

	result, err := svc.DeleteSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a subnet
//
// This example deletes the specified subnet.
func ExampleEC2_DeleteSubnet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSubnetInput{
		SubnetId: aws.String("subnet-9d4a7b6c"),
	}

	result, err := svc.DeleteSubnet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a tag from a resource
//
// This example deletes the tag Stack=test from the specified image.
func ExampleEC2_DeleteTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteTagsInput{
		Resources: []*string{
			aws.String("ami-78a54011"),
		},
		Tags: []*ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("test"),
			},
		},
	}

	result, err := svc.DeleteTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a volume
//
// This example deletes an available volume with the volume ID of ``vol-049df61146c4d7901``.
// If the command succeeds, no output is returned.
func ExampleEC2_DeleteVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteVolumeInput{
		VolumeId: aws.String("vol-049df61146c4d7901"),
	}

	result, err := svc.DeleteVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a VPC
//
// This example deletes the specified VPC.
func ExampleEC2_DeleteVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteVpcInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.DeleteVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a single attribute for your AWS account
//
// This example describes the supported-platforms attribute for your AWS account.
func ExampleEC2_DescribeAccountAttributes_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAccountAttributesInput{
		AttributeNames: []*string{
			aws.String("supported-platforms"),
		},
	}

	result, err := svc.DescribeAccountAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all attributes for your AWS account
//
// This example describes the attributes for your AWS account.
func ExampleEC2_DescribeAccountAttributes_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAccountAttributesInput{}

	result, err := svc.DescribeAccountAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses
//
// This example describes your Elastic IP addresses.
func ExampleEC2_DescribeAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-VPC
//
// This example describes your Elastic IP addresses for use with instances in a VPC.
func ExampleEC2_DescribeAddresses_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []*string{
					aws.String("vpc"),
				},
			},
		},
	}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-Classic
//
// This example describes your Elastic IP addresses for use with instances in EC2-Classic.
func ExampleEC2_DescribeAddresses_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []*string{
					aws.String("standard"),
				},
			},
		},
	}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Availability Zones
//
// This example describes the Availability Zones that are available to you. The response
// includes Availability Zones only for the current region.
func ExampleEC2_DescribeAvailabilityZones_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAvailabilityZonesInput{}

	result, err := svc.DescribeAvailabilityZones(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a customer gateway
//
// This example describes the specified customer gateway.
func ExampleEC2_DescribeCustomerGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeCustomerGatewaysInput{
		CustomerGatewayIds: []*string{
			aws.String("cgw-0e11f167"),
		},
	}

	result, err := svc.DescribeCustomerGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a DHCP options set
//
// This example describes the specified DHCP options set.
func ExampleEC2_DescribeDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeDhcpOptionsInput{
		DhcpOptionsIds: []*string{
			aws.String("dopt-d9070ebb"),
		},
	}

	result, err := svc.DescribeDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an IAM instance profile association
//
// This example describes the specified IAM instance profile association.
func ExampleEC2_DescribeIamInstanceProfileAssociations_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeIamInstanceProfileAssociationsInput{
		AssociationIds: []*string{
			aws.String("iip-assoc-0db249b1f25fa24b8"),
		},
	}

	result, err := svc.DescribeIamInstanceProfileAssociations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the launch permissions for an AMI
//
// This example describes the launch permissions for the specified AMI.
func ExampleEC2_DescribeImageAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeImageAttributeInput{
		Attribute: aws.String("launchPermission"),
		ImageId:   aws.String("ami-5731123e"),
	}

	result, err := svc.DescribeImageAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an AMI
//
// This example describes the specified AMI.
func ExampleEC2_DescribeImages_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeImagesInput{
		ImageIds: []*string{
			aws.String("ami-5731123e"),
		},
	}

	result, err := svc.DescribeImages(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instance type
//
// This example describes the instance type of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("instanceType"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the disableApiTermination attribute
//
// This example describes the ``disableApiTermination`` attribute of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("disableApiTermination"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the block device mapping for an instance
//
// This example describes the ``blockDeviceMapping`` attribute of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("blockDeviceMapping"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of an instance
//
// This example describes the current status of the specified instance.
func ExampleEC2_DescribeInstanceStatus_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceStatusInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeInstanceStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an Amazon EC2 instance
//
// This example describes the specified instance.
func ExampleEC2_DescribeInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstancesInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instances with a specific instance type
//
// This example describes the instances with the t2.micro instance type.
func ExampleEC2_DescribeInstances_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstancesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("instance-type"),
				Values: []*string{
					aws.String("t2.micro"),
				},
			},
		},
	}

	result, err := svc.DescribeInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instances with a specific tag
//
// This example describes the instances with the Purpose=test tag.
func ExampleEC2_DescribeInstances_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstancesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("tag:Purpose"),
				Values: []*string{
					aws.String("test"),
				},
			},
		},
	}

	result, err := svc.DescribeInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Internet gateway for a VPC
//
// This example describes the Internet gateway for the specified VPC.
func ExampleEC2_DescribeInternetGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInternetGatewaysInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("attachment.vpc-id"),
				Values: []*string{
					aws.String("vpc-a01106c2"),
				},
			},
		},
	}

	result, err := svc.DescribeInternetGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To display a key pair
//
// This example displays the fingerprint for the specified key.
func ExampleEC2_DescribeKeyPairs_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeKeyPairsInput{
		KeyNames: []*string{
			aws.String("my-key-pair"),
		},
	}

	result, err := svc.DescribeKeyPairs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the versions for a launch template
//
// This example describes the versions for the specified launch template.
func ExampleEC2_DescribeLaunchTemplateVersions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeLaunchTemplateVersionsInput{
		LaunchTemplateId: aws.String("068f72b72934aff71"),
	}

	result, err := svc.DescribeLaunchTemplateVersions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a launch template
//
// This example describes the specified launch template.
func ExampleEC2_DescribeLaunchTemplates_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeLaunchTemplatesInput{
		LaunchTemplateIds: []*string{
			aws.String("lt-01238c059e3466abc"),
		},
	}

	result, err := svc.DescribeLaunchTemplates(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your moving addresses
//
// This example describes all of your moving Elastic IP addresses.
func ExampleEC2_DescribeMovingAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeMovingAddressesInput{}

	result, err := svc.DescribeMovingAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a NAT gateway
//
// This example describes the NAT gateway for the specified VPC.
func ExampleEC2_DescribeNatGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNatGatewaysInput{
		Filter: []*ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []*string{
					aws.String("vpc-1a2b3c4d"),
				},
			},
		},
	}

	result, err := svc.DescribeNatGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network ACL
//
// This example describes the specified network ACL.
func ExampleEC2_DescribeNetworkAcls_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkAclsInput{
		NetworkAclIds: []*string{
			aws.String("acl-5fb85d36"),
		},
	}

	result, err := svc.DescribeNetworkAcls(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the attachment attribute of a network interface
//
// This example describes the attachment attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("attachment"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the description attribute of a network interface
//
// This example describes the description attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("description"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the groupSet attribute of a network interface
//
// This example describes the groupSet attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("groupSet"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the sourceDestCheck attribute of a network interface
//
// This example describes the sourceDestCheck attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("sourceDestCheck"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network interface
//

func ExampleEC2_DescribeNetworkInterfaces_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfacesInput{
		NetworkInterfaceIds: []*string{
			aws.String("eni-e5aa89a3"),
		},
	}

	result, err := svc.DescribeNetworkInterfaces(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your regions
//
// This example describes all the regions that are available to you.
func ExampleEC2_DescribeRegions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeRegionsInput{}

	result, err := svc.DescribeRegions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a route table
//
// This example describes the specified route table.
func ExampleEC2_DescribeRouteTables_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeRouteTablesInput{
		RouteTableIds: []*string{
			aws.String("rtb-1f382e7d"),
		},
	}

	result, err := svc.DescribeRouteTables(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an available schedule
//
// This example describes a schedule that occurs every week on Sunday, starting on the
// specified date. Note that the output contains a single schedule as an example.
func ExampleEC2_DescribeScheduledInstanceAvailability_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeScheduledInstanceAvailabilityInput{
		FirstSlotStartTimeRange: &ec2.SlotDateTimeRangeRequest{
			EarliestTime: parseTime("2006-01-02T15:04:05Z", "2016-01-31T00:00:00Z"),
			LatestTime:   parseTime("2006-01-02T15:04:05Z", "2016-01-31T04:00:00Z"),
		},
		Recurrence: &ec2.ScheduledInstanceRecurrenceRequest{
			Frequency: aws.String("Weekly"),
			Interval:  aws.Int64(1),
			OccurrenceDays: []*int64{
				aws.Int64(1),
			},
		},
	}

	result, err := svc.DescribeScheduledInstanceAvailability(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Scheduled Instances
//
// This example describes the specified Scheduled Instance.
func ExampleEC2_DescribeScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeScheduledInstancesInput{
		ScheduledInstanceIds: []*string{
			aws.String("sci-1234-1234-1234-1234-123456789012"),
		},
	}

	result, err := svc.DescribeScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe security group references
//
// This example describes the security group references for the specified security group.
func ExampleEC2_DescribeSecurityGroupReferences_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSecurityGroupReferencesInput{
		GroupId: []*string{
			aws.String("sg-903004f8"),
		},
	}

	result, err := svc.DescribeSecurityGroupReferences(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a security group
//
// This example describes the specified security group.
func ExampleEC2_DescribeSecurityGroups_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSecurityGroupsInput{
		GroupIds: []*string{
			aws.String("sg-903004f8"),
		},
	}

	result, err := svc.DescribeSecurityGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a tagged security group
//
// This example describes the security groups that include the specified tag (Purpose=test).
func ExampleEC2_DescribeSecurityGroups_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSecurityGroupsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("tag:Purpose"),
				Values: []*string{
					aws.String("test"),
				},
			},
		},
	}

	result, err := svc.DescribeSecurityGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshot attributes
//
// This example describes the ``createVolumePermission`` attribute on a snapshot with
// the snapshot ID of ``snap-066877671789bd71b``.
func ExampleEC2_DescribeSnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotAttributeInput{
		Attribute:  aws.String("createVolumePermission"),
		SnapshotId: aws.String("snap-066877671789bd71b"),
	}

	result, err := svc.DescribeSnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a snapshot
//
// This example describes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
func ExampleEC2_DescribeSnapshots_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotsInput{
		SnapshotIds: []*string{
			aws.String("snap-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeSnapshots(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshots using filters
//
// This example describes all snapshots owned by the ID 012345678910 that are in the
// ``pending`` status.
func ExampleEC2_DescribeSnapshots_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("status"),
				Values: []*string{
					aws.String("pending"),
				},
			},
		},
		OwnerIds: []*string{
			aws.String("012345678910"),
		},
	}

	result, err := svc.DescribeSnapshots(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the datafeed for your AWS account
//
// This example describes the Spot Instance datafeed subscription for your AWS account.
func ExampleEC2_DescribeSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotDatafeedSubscriptionInput{}

	result, err := svc.DescribeSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Spot Instances associated with a Spot fleet
//
// This example lists the Spot Instances associated with the specified Spot fleet.
func ExampleEC2_DescribeSpotFleetInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetInstancesInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
	}

	result, err := svc.DescribeSpotFleetInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot fleet history
//
// This example returns the history for the specified Spot fleet starting at the specified
// time.
func ExampleEC2_DescribeSpotFleetRequestHistory_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetRequestHistoryInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		StartTime:          parseTime("2006-01-02T15:04:05Z", "2015-05-26T00:00:00Z"),
	}

	result, err := svc.DescribeSpotFleetRequestHistory(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot fleet request
//
// This example describes the specified Spot fleet request.
func ExampleEC2_DescribeSpotFleetRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
	}

	result, err := svc.DescribeSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot Instance request
//
// This example describes the specified Spot Instance request.
func ExampleEC2_DescribeSpotInstanceRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []*string{
			aws.String("sir-08b93456"),
		},
	}

	result, err := svc.DescribeSpotInstanceRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot price history for Linux/UNIX (Amazon VPC)
//
// This example returns the Spot Price history for m1.xlarge, Linux/UNIX (Amazon VPC)
// instances for a particular day in January.
func ExampleEC2_DescribeSpotPriceHistory_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotPriceHistoryInput{
		EndTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T08:09:10"),
		InstanceTypes: []*string{
			aws.String("m1.xlarge"),
		},
		ProductDescriptions: []*string{
			aws.String("Linux/UNIX (Amazon VPC)"),
		},
		StartTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T07:08:09"),
	}

	result, err := svc.DescribeSpotPriceHistory(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the subnets for a VPC
//
// This example describes the subnets for the specified VPC.
func ExampleEC2_DescribeSubnets_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSubnetsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []*string{
					aws.String("vpc-a01106c2"),
				},
			},
		},
	}

	result, err := svc.DescribeSubnets(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a single resource
//
// This example describes the tags for the specified instance.
func ExampleEC2_DescribeTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeTagsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("resource-id"),
				Values: []*string{
					aws.String("i-1234567890abcdef8"),
				},
			},
		},
	}

	result, err := svc.DescribeTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a volume attribute
//
// This example describes the ``autoEnableIo`` attribute of the volume with the ID ``vol-049df61146c4d7901``.
func ExampleEC2_DescribeVolumeAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeAttributeInput{
		Attribute: aws.String("autoEnableIO"),
		VolumeId:  aws.String("vol-049df61146c4d7901"),
	}

	result, err := svc.DescribeVolumeAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of a single volume
//
// This example describes the status for the volume ``vol-1234567890abcdef0``.
func ExampleEC2_DescribeVolumeStatus_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeStatusInput{
		VolumeIds: []*string{
			aws.String("vol-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeVolumeStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of impaired volumes
//
// This example describes the status for all volumes that are impaired. In this example
// output, there are no impaired volumes.
func ExampleEC2_DescribeVolumeStatus_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeStatusInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("volume-status.status"),
				Values: []*string{
					aws.String("impaired"),
				},
			},
		},
	}

	result, err := svc.DescribeVolumeStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all volumes
//
// This example describes all of your volumes in the default region.
func ExampleEC2_DescribeVolumes_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumesInput{}

	result, err := svc.DescribeVolumes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe volumes that are attached to a specific instance
//
// This example describes all volumes that are both attached to the instance with the
// ID i-1234567890abcdef0 and set to delete when the instance terminates.
func ExampleEC2_DescribeVolumes_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("attachment.instance-id"),
				Values: []*string{
					aws.String("i-1234567890abcdef0"),
				},
			},
			{
				Name: aws.String("attachment.delete-on-termination"),
				Values: []*string{
					aws.String("true"),
				},
			},
		},
	}

	result, err := svc.DescribeVolumes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsSupport attribute
//
// This example describes the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for your instances to their corresponding IP addresses;
// otherwise, it does not.
func ExampleEC2_DescribeVpcAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: aws.String("enableDnsSupport"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.DescribeVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsHostnames attribute
//
// This example describes the enableDnsHostnames attribute. This attribute indicates
// whether the instances launched in the VPC get DNS hostnames. If this attribute is
// true, instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleEC2_DescribeVpcAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: aws.String("enableDnsHostnames"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.DescribeVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a VPC
//
// This example describes the specified VPC.
func ExampleEC2_DescribeVpcs_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcsInput{
		VpcIds: []*string{
			aws.String("vpc-a01106c2"),
		},
	}

	result, err := svc.DescribeVpcs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach an Internet gateway from a VPC
//
// This example detaches the specified Internet gateway from the specified VPC.
func ExampleEC2_DetachInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	result, err := svc.DetachInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a network interface from an instance
//
// This example detaches the specified network interface from its attached instance.
func ExampleEC2_DetachNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachNetworkInterfaceInput{
		AttachmentId: aws.String("eni-attach-66c4350a"),
	}

	result, err := svc.DetachNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a volume from an instance
//
// This example detaches the volume (``vol-049df61146c4d7901``) from the instance it
// is attached to.
func ExampleEC2_DetachVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachVolumeInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.DetachVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable route propagation
//
// This example disables the specified virtual private gateway from propagating static
// routes to the specified route table.
func ExampleEC2_DisableVgwRoutePropagation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.DisableVgwRoutePropagation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP address in EC2-VPC
//
// This example disassociates an Elastic IP address from an instance in a VPC.
func ExampleEC2_DisassociateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateAddressInput{
		AssociationId: aws.String("eipassoc-2bebb745"),
	}

	result, err := svc.DisassociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP addresses in EC2-Classic
//
// This example disassociates an Elastic IP address from an instance in EC2-Classic.
func ExampleEC2_DisassociateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.DisassociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an IAM instance profile
//
// This example disassociates the specified IAM instance profile from an instance.
func ExampleEC2_DisassociateIamInstanceProfile_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateIamInstanceProfileInput{
		AssociationId: aws.String("iip-assoc-05020b59952902f5f"),
	}

	result, err := svc.DisassociateIamInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate a route table
//
// This example disassociates the specified route table from its associated subnet.
func ExampleEC2_DisassociateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateRouteTableInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
	}

	result, err := svc.DisassociateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable route propagation
//
// This example enables the specified virtual private gateway to propagate static routes
// to the specified route table.
func ExampleEC2_EnableVgwRoutePropagation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.EnableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.EnableVgwRoutePropagation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable I/O for a volume
//
// This example enables I/O on volume ``vol-1234567890abcdef0``.
func ExampleEC2_EnableVolumeIO_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.EnableVolumeIOInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.EnableVolumeIO(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the console output
//
// This example gets the console output for the specified instance.
func ExampleEC2_GetConsoleOutput_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.GetConsoleOutputInput{
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.GetConsoleOutput(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the launch template data for an instance
//
// This example gets the launch template data for the specified instance.
func ExampleEC2_GetLaunchTemplateData_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.GetLaunchTemplateDataInput{
		InstanceId: aws.String("0123d646e8048babc"),
	}

	result, err := svc.GetLaunchTemplateData(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To make an AMI public
//
// This example makes the specified AMI public.
func ExampleEC2_ModifyImageAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyImageAttributeInput{
		ImageId: aws.String("ami-5731123e"),
		LaunchPermission: &ec2.LaunchPermissionModifications{
			Add: []*ec2.LaunchPermission{
				{
					Group: aws.String("all"),
				},
			},
		},
	}

	result, err := svc.ModifyImageAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To grant launch permissions
//
// This example grants launch permissions for the specified AMI to the specified AWS
// account.
func ExampleEC2_ModifyImageAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyImageAttributeInput{
		ImageId: aws.String("ami-5731123e"),
		LaunchPermission: &ec2.LaunchPermissionModifications{
			Add: []*ec2.LaunchPermission{
				{
					UserId: aws.String("123456789012"),
				},
			},
		},
	}

	result, err := svc.ModifyImageAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the instance type
//
// This example modifies the instance type of the specified stopped instance.
func ExampleEC2_ModifyInstanceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyInstanceAttributeInput{
		InstanceId: aws.String("i-1234567890abcdef0"),
		InstanceType: &ec2.AttributeValue{
			Value: aws.String("m5.large"),
		},
	}

	result, err := svc.ModifyInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable enhanced networking
//
// This example enables enhanced networking for the specified stopped instance.
func ExampleEC2_ModifyInstanceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyInstanceAttributeInput{
		EnaSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.ModifyInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the default version of a launch template
//
// This example specifies version 2 as the default version of the specified launch template.
func ExampleEC2_ModifyLaunchTemplate_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyLaunchTemplateInput{
		DefaultVersion:   aws.String("2"),
		LaunchTemplateId: aws.String("lt-0abcd290751193123"),
	}

	result, err := svc.ModifyLaunchTemplate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the attachment attribute of a network interface
//
// This example modifies the attachment attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Attachment: &ec2.NetworkInterfaceAttachmentChanges{
			AttachmentId:        aws.String("eni-attach-43348162"),
			DeleteOnTermination: aws.Bool(false),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the description attribute of a network interface
//
// This example modifies the description attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Description: &ec2.AttributeValue{
			Value: aws.String("My description"),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the groupSet attribute of a network interface
//
// This example command modifies the groupSet attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Groups: []*string{
			aws.String("sg-903004f8"),
			aws.String("sg-1a2b3c4d"),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the sourceDestCheck attribute of a network interface
//
// This example command modifies the sourceDestCheck attribute of the specified network
// interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("eni-686ea200"),
		SourceDestCheck: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a snapshot attribute
//
// This example modifies snapshot ``snap-1234567890abcdef0`` to remove the create volume
// permission for a user with the account ID ``123456789012``. If the command succeeds,
// no output is returned.
func ExampleEC2_ModifySnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute:     aws.String("createVolumePermission"),
		OperationType: aws.String("remove"),
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
		UserIds: []*string{
			aws.String("123456789012"),
		},
	}

	result, err := svc.ModifySnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To make a snapshot public
//
// This example makes the snapshot ``snap-1234567890abcdef0`` public.
func ExampleEC2_ModifySnapshotAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute: aws.String("createVolumePermission"),
		GroupNames: []*string{
			aws.String("all"),
		},
		OperationType: aws.String("add"),
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.ModifySnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To increase the target capacity of a Spot fleet request
//
// This example increases the target capacity of the specified Spot fleet request.
func ExampleEC2_ModifySpotFleetRequest_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySpotFleetRequestInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:     aws.Int64(20),
	}

	result, err := svc.ModifySpotFleetRequest(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To decrease the target capacity of a Spot fleet request
//
// This example decreases the target capacity of the specified Spot fleet request without
// terminating any Spot Instances as a result.
func ExampleEC2_ModifySpotFleetRequest_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySpotFleetRequestInput{
		ExcessCapacityTerminationPolicy: aws.String("NoTermination "),
		SpotFleetRequestId:              aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:                  aws.Int64(10),
	}

	result, err := svc.ModifySpotFleetRequest(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change a subnet's public IP addressing behavior
//
// This example modifies the specified subnet so that all instances launched into this
// subnet are assigned a public IP address.
func ExampleEC2_ModifySubnetAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySubnetAttributeInput{
		MapPublicIpOnLaunch: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		SubnetId: aws.String("subnet-1a2b3c4d"),
	}

	result, err := svc.ModifySubnetAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a volume attribute
//
// This example sets the ``autoEnableIo`` attribute of the volume with the ID ``vol-1234567890abcdef0``
// to ``true``. If the command succeeds, no output is returned.
func ExampleEC2_ModifyVolumeAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVolumeAttributeInput{
		AutoEnableIO: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		DryRun:   aws.Bool(true),
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.ModifyVolumeAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsSupport attribute
//
// This example modifies the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for instances in the VPC to their corresponding IP
// addresses; otherwise, it does not.
func ExampleEC2_ModifyVpcAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.ModifyVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsHostnames attribute
//
// This example modifies the enableDnsHostnames attribute. This attribute indicates
// whether instances launched in the VPC get DNS hostnames. If this attribute is true,
// instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleEC2_ModifyVpcAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsHostnames: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.ModifyVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move an address to EC2-VPC
//
// This example moves the specified Elastic IP address to the EC2-VPC platform.
func ExampleEC2_MoveAddressToVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.MoveAddressToVpcInput{
		PublicIp: aws.String("54.123.4.56"),
	}

	result, err := svc.MoveAddressToVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a Scheduled Instance
//
// This example purchases a Scheduled Instance.
func ExampleEC2_PurchaseScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.PurchaseScheduledInstancesInput{
		PurchaseRequests: []*ec2.PurchaseRequest{
			{
				InstanceCount: aws.Int64(1),
				PurchaseToken: aws.String("eyJ2IjoiMSIsInMiOjEsImMiOi..."),
			},
		},
	}

	result, err := svc.PurchaseScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reboot an EC2 instance
//
// This example reboots the specified EC2 instance.
func ExampleEC2_RebootInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RebootInstancesInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef5"),
		},
	}

	result, err := svc.RebootInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP address for EC2-VPC
//
// This example releases an Elastic IP address for use with instances in a VPC.
func ExampleEC2_ReleaseAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReleaseAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
	}

	result, err := svc.ReleaseAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP addresses for EC2-Classic
//
// This example releases an Elastic IP address for use with instances in EC2-Classic.
func ExampleEC2_ReleaseAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ReleaseAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.ReleaseAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the network ACL associated with a subnet
//
// This example associates the specified network ACL with the subnet for the specified
// network ACL association.
func ExampleEC2_ReplaceNetworkAclAssociation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceNetworkAclAssociationInput{
		AssociationId: aws.String("aclassoc-e5b95c8c"),
		NetworkAclId:  aws.String("acl-5fb85d36"),
	}

	result, err := svc.ReplaceNetworkAclAssociation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a network ACL entry
//
// This example replaces an entry for the specified network ACL. The new rule 100 allows
// ingress traffic from 203.0.113.12/24 on UDP port 53 (DNS) into any associated subnet.
func ExampleEC2_ReplaceNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceNetworkAclEntryInput{
		CidrBlock:    aws.String("203.0.113.12/24"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("udp"),
		RuleAction: aws.String("allow"),
		RuleNumber: aws.Int64(100),
	}

	result, err := svc.ReplaceNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a route
//
// This example replaces the specified route in the specified table table. The new route
// matches the specified CIDR and sends the traffic to the specified virtual private
// gateway.
func ExampleEC2_ReplaceRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceRouteInput{
		DestinationCidrBlock: aws.String("10.0.0.0/16"),
		GatewayId:            aws.String("vgw-9a4cacf3"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.ReplaceRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the route table associated with a subnet
//
// This example associates the specified route table with the subnet for the specified
// route table association.
func ExampleEC2_ReplaceRouteTableAssociation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceRouteTableAssociationInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
		RouteTableId:  aws.String("rtb-22574640"),
	}

	result, err := svc.ReplaceRouteTableAssociation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the subnet with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by subnet. The Spot fleet launches the instances in the specified subnet with
// the lowest price. If the instances are launched in a default VPC, they receive a
// public IP address by default. If the instances are launched in a nondefault VPC,
// they do not receive a public IP address by default. Note that you can't specify different
// subnets from the same Availability Zone in a Spot fleet request.
func ExampleEC2_RequestSpotFleet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
						Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
					},
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					SecurityGroups: []*ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
					SubnetId: aws.String("subnet-1a2b3c4d, subnet-3c4d5e6f"),
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the Availability Zone with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by Availability Zone. The Spot fleet launches the instances in the specified
// Availability Zone with the lowest price. If your account supports EC2-VPC only, Amazon
// EC2 launches the Spot instances in the default subnet of the Availability Zone. If
// your account supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic
// in the Availability Zone.
func ExampleEC2_RequestSpotFleet_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
						Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
					},
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					Placement: &ec2.SpotPlacement{
						AvailabilityZone: aws.String("us-west-2a, us-west-2b"),
					},
					SecurityGroups: []*ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch Spot instances in a subnet and assign them public IP addresses
//
// This example assigns public addresses to instances launched in a nondefault VPC.
// Note that when you specify a network interface, you must include the subnet ID and
// security group ID using the network interface.
func ExampleEC2_RequestSpotFleet_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
						Arn: aws.String("arn:aws:iam::880185128111:instance-profile/my-iam-role"),
					},
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					NetworkInterfaces: []*ec2.InstanceNetworkInterfaceSpecification{
						{
							AssociatePublicIpAddress: aws.Bool(true),
							DeviceIndex:              aws.Int64(0),
							Groups: []*string{
								aws.String("sg-1a2b3c4d"),
							},
							SubnetId: aws.String("subnet-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet using the diversified allocation strategy
//
// This example creates a Spot fleet request that launches 30 instances using the diversified
// allocation strategy. The launch specifications differ by instance type. The Spot
// fleet distributes the instances across the launch specifications such that there
// are 10 instances of each type.
func ExampleEC2_RequestSpotFleet_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			AllocationStrategy: aws.String("diversified"),
			IamFleetRole:       aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("c4.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("r3.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
			},
			SpotPrice:      aws.String("0.70"),
			TargetCapacity: aws.Int64(30),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example creates a one-time Spot Instance request for five instances in the specified
// Availability Zone. If your account supports EC2-VPC only, Amazon EC2 launches the
// instances in the default subnet of the specified Availability Zone. If your account
// supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic in the specified
// Availability Zone.
func ExampleEC2_RequestSpotInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: aws.String("m3.medium"),
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.SpotPlacement{
				AvailabilityZone: aws.String("us-west-2a"),
			},
			SecurityGroupIds: []*string{
				aws.String("sg-1a2b3c4d"),
			},
		},
		SpotPrice: aws.String("0.03"),
		Type:      aws.String("one-time"),
	}

	result, err := svc.RequestSpotInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example command creates a one-time Spot Instance request for five instances
// in the specified subnet. Amazon EC2 launches the instances in the specified subnet.
// If the VPC is a nondefault VPC, the instances do not receive a public IP address
// by default.
func ExampleEC2_RequestSpotInstances_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: aws.String("m3.medium"),
			SecurityGroupIds: []*string{
				aws.String("sg-1a2b3c4d"),
			},
			SubnetId: aws.String("subnet-1a2b3c4d"),
		},
		SpotPrice: aws.String("0.050"),
		Type:      aws.String("one-time"),
	}

	result, err := svc.RequestSpotInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the launchPermission attribute
//
// This example resets the launchPermission attribute for the specified AMI. By default,
// AMIs are private.
func ExampleEC2_ResetImageAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ResetImageAttributeInput{
		Attribute: aws.String("launchPermission"),
		ImageId:   aws.String("ami-5731123e"),
	}

	result, err := svc.ResetImageAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset the sourceDestCheck attribute
//
// This example resets the sourceDestCheck attribute for the specified instance.
func ExampleEC2_ResetInstanceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ResetInstanceAttributeInput{
		Attribute:  aws.String("sourceDestCheck"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.ResetInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset a snapshot attribute
//
// This example resets the create volume permissions for snapshot ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleEC2_ResetSnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ResetSnapshotAttributeInput{
		Attribute:  aws.String("createVolumePermission"),
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.ResetSnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore an address to EC2-Classic
//
// This example restores the specified Elastic IP address to the EC2-Classic platform.
func ExampleEC2_RestoreAddressToClassic_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RestoreAddressToClassicInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.RestoreAddressToClassic(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch an instance
//
// This example launches an instance using the specified AMI, instance type, security
// group, subnet, block device mapping, and tags.
func ExampleEC2_RunInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RunInstancesInput{
		BlockDeviceMappings: []*ec2.BlockDeviceMapping{
			{
				DeviceName: aws.String("/dev/sdh"),
				Ebs: &ec2.EbsBlockDevice{
					VolumeSize: aws.Int64(100),
				},
			},
		},
		ImageId:      aws.String("ami-abc12345"),
		InstanceType: aws.String("t2.micro"),
		KeyName:      aws.String("my-key-pair"),
		MaxCount:     aws.Int64(1),
		MinCount:     aws.Int64(1),
		SecurityGroupIds: []*string{
			aws.String("sg-1a2b3c4d"),
		},
		SubnetId: aws.String("subnet-6e7f829e"),
		TagSpecifications: []*ec2.TagSpecification{
			{
				ResourceType: aws.String("instance"),
				Tags: []*ec2.Tag{
					{
						Key:   aws.String("Purpose"),
						Value: aws.String("test"),
					},
				},
			},
		},
	}

	result, err := svc.RunInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in a VPC
//
// This example launches the specified Scheduled Instance in a VPC.
func ExampleEC2_RunScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			NetworkInterfaces: []*ec2.ScheduledInstancesNetworkInterface{
				{
					AssociatePublicIpAddress: aws.Bool(true),
					DeviceIndex:              aws.Int64(0),
					Groups: []*string{
						aws.String("sg-12345678"),
					},
					SubnetId: aws.String("subnet-12345678"),
				},
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	result, err := svc.RunScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in EC2-Classic
//
// This example launches the specified Scheduled Instance in EC2-Classic.
func ExampleEC2_RunScheduledInstances_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.ScheduledInstancesPlacement{
				AvailabilityZone: aws.String("us-west-2b"),
			},
			SecurityGroupIds: []*string{
				aws.String("sg-12345678"),
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	result, err := svc.RunScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To start a stopped EC2 instance
//
// This example starts the specified EC2 instance.
func ExampleEC2_StartInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.StartInstancesInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef0"),
		},
	}

	result, err := svc.StartInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop a running EC2 instance
//
// This example stops the specified EC2 instance.
func ExampleEC2_StopInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.StopInstancesInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef0"),
		},
	}

	result, err := svc.StopInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To terminate an EC2 instance
//
// This example terminates the specified EC2 instance.
func ExampleEC2_TerminateInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.TerminateInstancesInput{
		InstanceIds: []*string{
			aws.String("i-1234567890abcdef0"),
		},
	}

	result, err := svc.TerminateInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To unassign a secondary private IP address from a network interface
//
// This example unassigns the specified private IP address from the specified network
// interface.
func ExampleEC2_UnassignPrivateIpAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.UnassignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []*string{
			aws.String("10.0.0.82"),
		},
	}

	result, err := svc.UnassignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an outbound security group rule description
//
// This example updates the description for the specified security group rule.
func ExampleEC2_UpdateSecurityGroupRuleDescriptionsEgress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.UpdateSecurityGroupRuleDescriptionsEgressInput{
		GroupId: aws.String("sg-123abc12"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(80),
				IpProtocol: aws.String("tcp"),
				IpRanges: []*ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/24"),
						Description: aws.String("Outbound HTTP access to server 2"),
					},
				},
				ToPort: aws.Int64(80),
			},
		},
	}

	result, err := svc.UpdateSecurityGroupRuleDescriptionsEgress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an inbound security group rule description
//
// This example updates the description for the specified security group rule.
func ExampleEC2_UpdateSecurityGroupRuleDescriptionsIngress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.UpdateSecurityGroupRuleDescriptionsIngressInput{
		GroupId: aws.String("sg-123abc12"),
		IpPermissions: []*ec2.IpPermission{
			{
				FromPort:   aws.Int64(22),
				IpProtocol: aws.String("tcp"),
				IpRanges: []*ec2.IpRange{
					{
						CidrIp:      aws.String("203.0.113.0/16"),
						Description: aws.String("SSH access from the LA office"),
					},
				},
				ToPort: aws.Int64(22),
			},
		},
	}

	result, err := svc.UpdateSecurityGroupRuleDescriptionsIngress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
