package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"io"
	"net/http"
)

// APIProtocolContract enumerates the values for api protocol contract.
type APIProtocolContract string

const (
	// HTTP ...
	HTTP APIProtocolContract = "Http"
	// HTTPS ...
	HTTPS APIProtocolContract = "Https"
)

// PossibleAPIProtocolContractValues returns an array of possible values for the APIProtocolContract const type.
func PossibleAPIProtocolContractValues() []APIProtocolContract {
	return []APIProtocolContract{HTTP, HTTPS}
}

// APITypeContract enumerates the values for api type contract.
type APITypeContract string

const (
	// APITypeContractHTTP ...
	APITypeContractHTTP APITypeContract = "Http"
	// APITypeContractSoap ...
	APITypeContractSoap APITypeContract = "Soap"
)

// PossibleAPITypeContractValues returns an array of possible values for the APITypeContract const type.
func PossibleAPITypeContractValues() []APITypeContract {
	return []APITypeContract{APITypeContractHTTP, APITypeContractSoap}
}

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// Failed ...
	Failed AsyncOperationState = "Failed"
	// InProgress ...
	InProgress AsyncOperationState = "InProgress"
	// Started ...
	Started AsyncOperationState = "Started"
	// Succeeded ...
	Succeeded AsyncOperationState = "Succeeded"
)

// PossibleAsyncOperationStateValues returns an array of possible values for the AsyncOperationState const type.
func PossibleAsyncOperationStateValues() []AsyncOperationState {
	return []AsyncOperationState{Failed, InProgress, Started, Succeeded}
}

// BackendProtocol enumerates the values for backend protocol.
type BackendProtocol string

const (
	// BackendProtocolHTTP ...
	BackendProtocolHTTP BackendProtocol = "http"
	// BackendProtocolSoap ...
	BackendProtocolSoap BackendProtocol = "soap"
)

// PossibleBackendProtocolValues returns an array of possible values for the BackendProtocol const type.
func PossibleBackendProtocolValues() []BackendProtocol {
	return []BackendProtocol{BackendProtocolHTTP, BackendProtocolSoap}
}

// BearerTokenSendingMethodsContract enumerates the values for bearer token sending methods contract.
type BearerTokenSendingMethodsContract string

const (
	// AuthorizationHeader ...
	AuthorizationHeader BearerTokenSendingMethodsContract = "authorizationHeader"
	// Query ...
	Query BearerTokenSendingMethodsContract = "query"
)

// PossibleBearerTokenSendingMethodsContractValues returns an array of possible values for the BearerTokenSendingMethodsContract const type.
func PossibleBearerTokenSendingMethodsContractValues() []BearerTokenSendingMethodsContract {
	return []BearerTokenSendingMethodsContract{AuthorizationHeader, Query}
}

// ClientAuthenticationMethodContract enumerates the values for client authentication method contract.
type ClientAuthenticationMethodContract string

const (
	// Basic ...
	Basic ClientAuthenticationMethodContract = "Basic"
	// Body ...
	Body ClientAuthenticationMethodContract = "Body"
)

// PossibleClientAuthenticationMethodContractValues returns an array of possible values for the ClientAuthenticationMethodContract const type.
func PossibleClientAuthenticationMethodContractValues() []ClientAuthenticationMethodContract {
	return []ClientAuthenticationMethodContract{Basic, Body}
}

// ConnectivityStatusType enumerates the values for connectivity status type.
type ConnectivityStatusType string

const (
	// Failure ...
	Failure ConnectivityStatusType = "failure"
	// Initializing ...
	Initializing ConnectivityStatusType = "initializing"
	// Success ...
	Success ConnectivityStatusType = "success"
)

// PossibleConnectivityStatusTypeValues returns an array of possible values for the ConnectivityStatusType const type.
func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return []ConnectivityStatusType{Failure, Initializing, Success}
}

// GrantTypesContract enumerates the values for grant types contract.
type GrantTypesContract string

const (
	// AuthorizationCode ...
	AuthorizationCode GrantTypesContract = "authorizationCode"
	// ClientCredentials ...
	ClientCredentials GrantTypesContract = "clientCredentials"
	// Implicit ...
	Implicit GrantTypesContract = "implicit"
	// ResourceOwnerPassword ...
	ResourceOwnerPassword GrantTypesContract = "resourceOwnerPassword"
)

// PossibleGrantTypesContractValues returns an array of possible values for the GrantTypesContract const type.
func PossibleGrantTypesContractValues() []GrantTypesContract {
	return []GrantTypesContract{AuthorizationCode, ClientCredentials, Implicit, ResourceOwnerPassword}
}

// GroupTypeContract enumerates the values for group type contract.
type GroupTypeContract string

const (
	// Custom ...
	Custom GroupTypeContract = "Custom"
	// External ...
	External GroupTypeContract = "External"
	// System ...
	System GroupTypeContract = "System"
)

// PossibleGroupTypeContractValues returns an array of possible values for the GroupTypeContract const type.
func PossibleGroupTypeContractValues() []GroupTypeContract {
	return []GroupTypeContract{Custom, External, System}
}

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// Management ...
	Management HostnameType = "Management"
	// Portal ...
	Portal HostnameType = "Portal"
	// Proxy ...
	Proxy HostnameType = "Proxy"
	// Scm ...
	Scm HostnameType = "Scm"
)

// PossibleHostnameTypeValues returns an array of possible values for the HostnameType const type.
func PossibleHostnameTypeValues() []HostnameType {
	return []HostnameType{Management, Portal, Proxy, Scm}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// OK ...
	OK HTTPStatusCode = "OK"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, Conflict, Continue, Created, NotFound, OK}
}

// IdentityProviderNameType enumerates the values for identity provider name type.
type IdentityProviderNameType string

const (
	// Aad ...
	Aad IdentityProviderNameType = "aad"
	// AadB2C ...
	AadB2C IdentityProviderNameType = "aadB2C"
	// Facebook ...
	Facebook IdentityProviderNameType = "facebook"
	// Google ...
	Google IdentityProviderNameType = "google"
	// Microsoft ...
	Microsoft IdentityProviderNameType = "microsoft"
	// Twitter ...
	Twitter IdentityProviderNameType = "twitter"
)

// PossibleIdentityProviderNameTypeValues returns an array of possible values for the IdentityProviderNameType const type.
func PossibleIdentityProviderNameTypeValues() []IdentityProviderNameType {
	return []IdentityProviderNameType{Aad, AadB2C, Facebook, Google, Microsoft, Twitter}
}

// KeyTypeContract enumerates the values for key type contract.
type KeyTypeContract string

const (
	// Primary ...
	Primary KeyTypeContract = "primary"
	// Secondary ...
	Secondary KeyTypeContract = "secondary"
)

// PossibleKeyTypeContractValues returns an array of possible values for the KeyTypeContract const type.
func PossibleKeyTypeContractValues() []KeyTypeContract {
	return []KeyTypeContract{Primary, Secondary}
}

// MethodContract enumerates the values for method contract.
type MethodContract string

const (
	// DELETE ...
	DELETE MethodContract = "DELETE"
	// GET ...
	GET MethodContract = "GET"
	// HEAD ...
	HEAD MethodContract = "HEAD"
	// OPTIONS ...
	OPTIONS MethodContract = "OPTIONS"
	// PATCH ...
	PATCH MethodContract = "PATCH"
	// POST ...
	POST MethodContract = "POST"
	// PUT ...
	PUT MethodContract = "PUT"
	// TRACE ...
	TRACE MethodContract = "TRACE"
)

// PossibleMethodContractValues returns an array of possible values for the MethodContract const type.
func PossibleMethodContractValues() []MethodContract {
	return []MethodContract{DELETE, GET, HEAD, OPTIONS, PATCH, POST, PUT, TRACE}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameAvailabilityReason = "Invalid"
	// Valid ...
	Valid NameAvailabilityReason = "Valid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{AlreadyExists, Invalid, Valid}
}

// PolicyScopeContract enumerates the values for policy scope contract.
type PolicyScopeContract string

const (
	// PolicyScopeContractAll ...
	PolicyScopeContractAll PolicyScopeContract = "All"
	// PolicyScopeContractAPI ...
	PolicyScopeContractAPI PolicyScopeContract = "Api"
	// PolicyScopeContractOperation ...
	PolicyScopeContractOperation PolicyScopeContract = "Operation"
	// PolicyScopeContractProduct ...
	PolicyScopeContractProduct PolicyScopeContract = "Product"
	// PolicyScopeContractTenant ...
	PolicyScopeContractTenant PolicyScopeContract = "Tenant"
)

// PossiblePolicyScopeContractValues returns an array of possible values for the PolicyScopeContract const type.
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return []PolicyScopeContract{PolicyScopeContractAll, PolicyScopeContractAPI, PolicyScopeContractOperation, PolicyScopeContractProduct, PolicyScopeContractTenant}
}

// ProductStateContract enumerates the values for product state contract.
type ProductStateContract string

const (
	// NotPublished ...
	NotPublished ProductStateContract = "NotPublished"
	// Published ...
	Published ProductStateContract = "Published"
)

// PossibleProductStateContractValues returns an array of possible values for the ProductStateContract const type.
func PossibleProductStateContractValues() []ProductStateContract {
	return []ProductStateContract{NotPublished, Published}
}

// ReportsAggregation enumerates the values for reports aggregation.
type ReportsAggregation string

const (
	// ByAPI ...
	ByAPI ReportsAggregation = "byApi"
	// ByGeo ...
	ByGeo ReportsAggregation = "byGeo"
	// ByOperation ...
	ByOperation ReportsAggregation = "byOperation"
	// ByProduct ...
	ByProduct ReportsAggregation = "byProduct"
	// BySubscription ...
	BySubscription ReportsAggregation = "bySubscription"
	// ByTime ...
	ByTime ReportsAggregation = "byTime"
	// ByUser ...
	ByUser ReportsAggregation = "byUser"
)

// PossibleReportsAggregationValues returns an array of possible values for the ReportsAggregation const type.
func PossibleReportsAggregationValues() []ReportsAggregation {
	return []ReportsAggregation{ByAPI, ByGeo, ByOperation, ByProduct, BySubscription, ByTime, ByUser}
}

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// Developer ...
	Developer SkuType = "Developer"
	// Premium ...
	Premium SkuType = "Premium"
	// Standard ...
	Standard SkuType = "Standard"
)

// PossibleSkuTypeValues returns an array of possible values for the SkuType const type.
func PossibleSkuTypeValues() []SkuType {
	return []SkuType{Developer, Premium, Standard}
}

// SubscriptionStateContract enumerates the values for subscription state contract.
type SubscriptionStateContract string

const (
	// Active ...
	Active SubscriptionStateContract = "Active"
	// Cancelled ...
	Cancelled SubscriptionStateContract = "Cancelled"
	// Expired ...
	Expired SubscriptionStateContract = "Expired"
	// Rejected ...
	Rejected SubscriptionStateContract = "Rejected"
	// Submitted ...
	Submitted SubscriptionStateContract = "Submitted"
	// Suspended ...
	Suspended SubscriptionStateContract = "Suspended"
)

// PossibleSubscriptionStateContractValues returns an array of possible values for the SubscriptionStateContract const type.
func PossibleSubscriptionStateContractValues() []SubscriptionStateContract {
	return []SubscriptionStateContract{Active, Cancelled, Expired, Rejected, Submitted, Suspended}
}

// UserStateContract enumerates the values for user state contract.
type UserStateContract string

const (
	// UserStateContractActive ...
	UserStateContractActive UserStateContract = "Active"
	// UserStateContractBlocked ...
	UserStateContractBlocked UserStateContract = "Blocked"
)

// PossibleUserStateContractValues returns an array of possible values for the UserStateContract const type.
func PossibleUserStateContractValues() []UserStateContract {
	return []UserStateContract{UserStateContractActive, UserStateContractBlocked}
}

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal ...
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal ...
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone ...
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// PossibleVirtualNetworkTypeValues returns an array of possible values for the VirtualNetworkType const type.
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return []VirtualNetworkType{VirtualNetworkTypeExternal, VirtualNetworkTypeInternal, VirtualNetworkTypeNone}
}

// AccessInformationContract tenant access information contract of the API Management service.
type AccessInformationContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier.
	ID *string `json:"id,omitempty"`
	// PrimaryKey - Primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters tenant access information update parameters of the API Management service.
type AccessInformationUpdateParameters struct {
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AdditionalRegion description of an additional API Management resource location.
type AdditionalRegion struct {
	// Location - The location name of the additional region among Azure Data center regions.
	Location *string `json:"location,omitempty"`
	// SkuType - The SKU type in the location. Possible values include: 'Developer', 'Standard', 'Premium'
	SkuType SkuType `json:"skuType,omitempty"`
	// SkuUnitCount - The SKU Unit count at the location. The maximum SKU Unit count depends on the SkuType. Maximum allowed for Developer SKU is 1, for Standard SKU is 4, and for Premium SKU is 10, at a location.
	SkuUnitCount *int32 `json:"skuUnitCount,omitempty"`
	// StaticIPs - Static IP addresses of the location's virtual machines.
	StaticIPs *[]string `json:"staticIPs,omitempty"`
	// Vpnconfiguration - Virtual network configuration for the location.
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
}

// APICollection paged Api list representation.
type APICollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APICollectionIterator provides access to a complete listing of APIContract values.
type APICollectionIterator struct {
	i    int
	page APICollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APICollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APICollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APICollectionIterator) Response() APICollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APICollectionIterator) Value() APIContract {
	if !iter.page.NotDone() {
		return APIContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ac APICollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// aPICollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac APICollection) aPICollectionPreparer() (*http.Request, error) {
	if ac.NextLink == nil || len(to.String(ac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// APICollectionPage contains a page of APIContract values.
type APICollectionPage struct {
	fn func(APICollection) (APICollection, error)
	ac APICollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APICollectionPage) Next() error {
	next, err := page.fn(page.ac)
	if err != nil {
		return err
	}
	page.ac = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APICollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APICollectionPage) Response() APICollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APICollectionPage) Values() []APIContract {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// APIContract API details.
type APIContract struct {
	autorest.Response `json:"-"`
	// ID - API identifier path: /apis/{apiId}
	ID *string `json:"id,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]APIProtocolContract `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// Type - Type of API. Possible values include: 'APITypeContractHTTP', 'APITypeContractSoap'
	Type APITypeContract `json:"type,omitempty"`
}

// APIEntityBaseContract API base contract details.
type APIEntityBaseContract struct {
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// Type - Type of API. Possible values include: 'APITypeContractHTTP', 'APITypeContractSoap'
	Type APITypeContract `json:"type,omitempty"`
}

// APIExportResult the response model for the export API output operation.
type APIExportResult struct {
	autorest.Response `json:"-"`
	// Content - Response content bytes.
	Content *[]byte `json:"content,omitempty"`
	// StatusCode - Possible values include: 'Continue', 'OK', 'Created', 'Accepted', 'NotFound', 'Conflict'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID  *string        `json:"requestId,omitempty"`
}

// APIUpdateContract API Update Contract details.
type APIUpdateContract struct {
	// ID - API identifier path: /apis/{apiId}
	ID *string `json:"id,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]APIProtocolContract `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// Type - Type of API. Possible values include: 'APITypeContractHTTP', 'APITypeContractSoap'
	Type APITypeContract `json:"type,omitempty"`
}

// AuthenticationSettingsContract API Authentication Settings.
type AuthenticationSettingsContract struct {
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`
}

// AuthorizationServerCollection paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OAuth2AuthorizationServerContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationServerCollectionIterator provides access to a complete listing of OAuth2AuthorizationServerContract
// values.
type AuthorizationServerCollectionIterator struct {
	i    int
	page AuthorizationServerCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationServerCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationServerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationServerCollectionIterator) Response() AuthorizationServerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationServerCollectionIterator) Value() OAuth2AuthorizationServerContract {
	if !iter.page.NotDone() {
		return OAuth2AuthorizationServerContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (asc AuthorizationServerCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// authorizationServerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc AuthorizationServerCollection) authorizationServerCollectionPreparer() (*http.Request, error) {
	if asc.NextLink == nil || len(to.String(asc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// AuthorizationServerCollectionPage contains a page of OAuth2AuthorizationServerContract values.
type AuthorizationServerCollectionPage struct {
	fn  func(AuthorizationServerCollection) (AuthorizationServerCollection, error)
	asc AuthorizationServerCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationServerCollectionPage) Next() error {
	next, err := page.fn(page.asc)
	if err != nil {
		return err
	}
	page.asc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationServerCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationServerCollectionPage) Response() AuthorizationServerCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationServerCollectionPage) Values() []OAuth2AuthorizationServerContract {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// BackendAuthorizationHeaderCredentials authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	// Scheme - Authentication Scheme name.
	Scheme *string `json:"scheme,omitempty"`
	// Parameter - Authentication Parameter value.
	Parameter *string `json:"parameter,omitempty"`
}

// BackendBaseParameters backend entity base Parameter set.
type BackendBaseParameters struct {
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID         *string `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendBaseParameters.
func (bbp BackendBaseParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bbp.Certificate != nil {
		objectMap["certificate"] = bbp.Certificate
	}
	if bbp.Query != nil {
		objectMap["query"] = bbp.Query
	}
	if bbp.Header != nil {
		objectMap["header"] = bbp.Header
	}
	if bbp.URL != nil {
		objectMap["url"] = bbp.URL
	}
	if bbp.Username != nil {
		objectMap["username"] = bbp.Username
	}
	if bbp.Password != nil {
		objectMap["password"] = bbp.Password
	}
	if bbp.Title != nil {
		objectMap["title"] = bbp.Title
	}
	if bbp.Description != nil {
		objectMap["description"] = bbp.Description
	}
	if bbp.ResourceID != nil {
		objectMap["resourceId"] = bbp.ResourceID
	}
	if bbp.BackendProperties != nil {
		objectMap["properties"] = bbp.BackendProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendBaseParameters struct.
func (bbp *BackendBaseParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "certificate":
			if v != nil {
				var certificate []string
				err = json.Unmarshal(*v, &certificate)
				if err != nil {
					return err
				}
				bbp.Certificate = &certificate
			}
		case "query":
			if v != nil {
				var query map[string][]string
				err = json.Unmarshal(*v, &query)
				if err != nil {
					return err
				}
				bbp.Query = query
			}
		case "header":
			if v != nil {
				var header map[string][]string
				err = json.Unmarshal(*v, &header)
				if err != nil {
					return err
				}
				bbp.Header = header
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				bbp.URL = &URL
			}
		case "username":
			if v != nil {
				var username string
				err = json.Unmarshal(*v, &username)
				if err != nil {
					return err
				}
				bbp.Username = &username
			}
		case "password":
			if v != nil {
				var password string
				err = json.Unmarshal(*v, &password)
				if err != nil {
					return err
				}
				bbp.Password = &password
			}
		case "title":
			if v != nil {
				var title string
				err = json.Unmarshal(*v, &title)
				if err != nil {
					return err
				}
				bbp.Title = &title
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				bbp.Description = &description
			}
		case "resourceId":
			if v != nil {
				var resourceID string
				err = json.Unmarshal(*v, &resourceID)
				if err != nil {
					return err
				}
				bbp.ResourceID = &resourceID
			}
		case "properties":
			if v != nil {
				var backendProperties BackendProperties
				err = json.Unmarshal(*v, &backendProperties)
				if err != nil {
					return err
				}
				bbp.BackendProperties = &backendProperties
			}
		}
	}

	return nil
}

// BackendCollection paged Backend list representation.
type BackendCollection struct {
	autorest.Response `json:"-"`
	// Value - Backend values.
	Value *[]BackendResponse `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackendCollectionIterator provides access to a complete listing of BackendResponse values.
type BackendCollectionIterator struct {
	i    int
	page BackendCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackendCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackendCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackendCollectionIterator) Response() BackendCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackendCollectionIterator) Value() BackendResponse {
	if !iter.page.NotDone() {
		return BackendResponse{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (bc BackendCollection) IsEmpty() bool {
	return bc.Value == nil || len(*bc.Value) == 0
}

// backendCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bc BackendCollection) backendCollectionPreparer() (*http.Request, error) {
	if bc.NextLink == nil || len(to.String(bc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bc.NextLink)))
}

// BackendCollectionPage contains a page of BackendResponse values.
type BackendCollectionPage struct {
	fn func(BackendCollection) (BackendCollection, error)
	bc BackendCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackendCollectionPage) Next() error {
	next, err := page.fn(page.bc)
	if err != nil {
		return err
	}
	page.bc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackendCollectionPage) NotDone() bool {
	return !page.bc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackendCollectionPage) Response() BackendCollection {
	return page.bc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackendCollectionPage) Values() []BackendResponse {
	if page.bc.IsEmpty() {
		return nil
	}
	return *page.bc.Value
}

// BackendContract parameters supplied to the Create Backend operation.
type BackendContract struct {
	// ID - Uniquely identifies the backend within the current API Management service instance. The value is a valid relative URL in the format of /backends/{backendId} where {backendId} is a backend identifier.
	ID *string `json:"id,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID         *string `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendContract.
func (bc BackendContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.ID != nil {
		objectMap["id"] = bc.ID
	}
	if bc.Protocol != "" {
		objectMap["protocol"] = bc.Protocol
	}
	if bc.Certificate != nil {
		objectMap["certificate"] = bc.Certificate
	}
	if bc.Query != nil {
		objectMap["query"] = bc.Query
	}
	if bc.Header != nil {
		objectMap["header"] = bc.Header
	}
	if bc.URL != nil {
		objectMap["url"] = bc.URL
	}
	if bc.Username != nil {
		objectMap["username"] = bc.Username
	}
	if bc.Password != nil {
		objectMap["password"] = bc.Password
	}
	if bc.Title != nil {
		objectMap["title"] = bc.Title
	}
	if bc.Description != nil {
		objectMap["description"] = bc.Description
	}
	if bc.ResourceID != nil {
		objectMap["resourceId"] = bc.ResourceID
	}
	if bc.BackendProperties != nil {
		objectMap["properties"] = bc.BackendProperties
	}
	return json.Marshal(objectMap)
}

// BackendCredentialsContract details of the Credentials used to connect to Backend.
type BackendCredentialsContract struct {
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// Scheme - Authentication Scheme name.
	Scheme *string `json:"scheme,omitempty"`
	// Parameter - Authentication Parameter value.
	Parameter *string `json:"parameter,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendCredentialsContract.
func (bcc BackendCredentialsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bcc.Certificate != nil {
		objectMap["certificate"] = bcc.Certificate
	}
	if bcc.Query != nil {
		objectMap["query"] = bcc.Query
	}
	if bcc.Header != nil {
		objectMap["header"] = bcc.Header
	}
	if bcc.Scheme != nil {
		objectMap["scheme"] = bcc.Scheme
	}
	if bcc.Parameter != nil {
		objectMap["parameter"] = bcc.Parameter
	}
	return json.Marshal(objectMap)
}

// BackendProperties properties specific to a Backend.
type BackendProperties struct {
	// SkipCertificateChainValidation - Flag indicating whether SSL certificate chain validation should be skipped when using self-signed certificates for this backend host.
	SkipCertificateChainValidation *bool `json:"skipCertificateChainValidation,omitempty"`
	// SkipCertificateNameValidation - Flag indicating whether SSL certificate name validation should be skipped when using self-signed certificates for this backend host.
	SkipCertificateNameValidation *bool `json:"skipCertificateNameValidation,omitempty"`
}

// BackendProxyContract details of the Backend WebProxy Server to use in the Request to Backend.
type BackendProxyContract struct {
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
}

// BackendResponse the Backend entity in API Management represents a backend service that is configured to skip
// certification chain validation when using a self-signed certificate to test mutual certificate authentication.
type BackendResponse struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the backend within the current API Management service instance. The value is a valid relative URL in the format of /backends/{backendId} where {backendId} is a backend identifier.
	ID *string `json:"id,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID         *string `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendResponse.
func (br BackendResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.ID != nil {
		objectMap["id"] = br.ID
	}
	if br.Protocol != "" {
		objectMap["protocol"] = br.Protocol
	}
	if br.Certificate != nil {
		objectMap["certificate"] = br.Certificate
	}
	if br.Query != nil {
		objectMap["query"] = br.Query
	}
	if br.Header != nil {
		objectMap["header"] = br.Header
	}
	if br.URL != nil {
		objectMap["url"] = br.URL
	}
	if br.Username != nil {
		objectMap["username"] = br.Username
	}
	if br.Password != nil {
		objectMap["password"] = br.Password
	}
	if br.Title != nil {
		objectMap["title"] = br.Title
	}
	if br.Description != nil {
		objectMap["description"] = br.Description
	}
	if br.ResourceID != nil {
		objectMap["resourceId"] = br.ResourceID
	}
	if br.BackendProperties != nil {
		objectMap["properties"] = br.BackendProperties
	}
	return json.Marshal(objectMap)
}

// BackendUpdateParameters parameters supplied to the Update Backend operation.
type BackendUpdateParameters struct {
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID         *string `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendUpdateParameters.
func (bup BackendUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bup.Protocol != "" {
		objectMap["protocol"] = bup.Protocol
	}
	if bup.Certificate != nil {
		objectMap["certificate"] = bup.Certificate
	}
	if bup.Query != nil {
		objectMap["query"] = bup.Query
	}
	if bup.Header != nil {
		objectMap["header"] = bup.Header
	}
	if bup.URL != nil {
		objectMap["url"] = bup.URL
	}
	if bup.Username != nil {
		objectMap["username"] = bup.Username
	}
	if bup.Password != nil {
		objectMap["password"] = bup.Password
	}
	if bup.Title != nil {
		objectMap["title"] = bup.Title
	}
	if bup.Description != nil {
		objectMap["description"] = bup.Description
	}
	if bup.ResourceID != nil {
		objectMap["resourceId"] = bup.ResourceID
	}
	if bup.BackendProperties != nil {
		objectMap["properties"] = bup.BackendProperties
	}
	return json.Marshal(objectMap)
}

// CertificateCollection paged Certificates list representation.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]CertificateContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of CertificateContract values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() CertificateContract {
	if !iter.page.NotDone() {
		return CertificateContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer() (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of CertificateContract values.
type CertificateCollectionPage struct {
	fn func(CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) Next() error {
	next, err := page.fn(page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []CertificateContract {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// CertificateContract certificate details.
type CertificateContract struct {
	autorest.Response `json:"-"`
	// ID - Certificate identifier path: /certificates/{certificateId}
	ID *string `json:"id,omitempty"`
	// Subject - Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpirationDate - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// CertificateCreateOrUpdateParameters parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// Data - Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string `json:"data,omitempty"`
	// Password - Password for the Certificate
	Password *string `json:"password,omitempty"`
}

// CertificateInformation SSL certificate information.
type CertificateInformation struct {
	autorest.Response `json:"-"`
	// Expiry - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - Subject of the certificate.
	Subject *string `json:"subject,omitempty"`
}

// ConnectivityStatusContract details about connectivity to a resource.
type ConnectivityStatusContract struct {
	// Name - The hostname of the resource which the service depends on. This can be the database, storage or any other azure resource on which the service depends upon.
	Name *string `json:"name,omitempty"`
	// Status - Resource Connectivity Status Type identifier. Possible values include: 'Initializing', 'Success', 'Failure'
	Status ConnectivityStatusType `json:"status,omitempty"`
	// Error - Error details of the connectivity to the resource.
	Error *string `json:"error,omitempty"`
	// LastUpdated - The date when the resource connectivity status was last updated. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// LastStatusChange - The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	LastStatusChange *date.Time `json:"lastStatusChange,omitempty"`
}

// DeployConfigurationParameters parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameters struct {
	// Branch - The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string `json:"branch,omitempty"`
	// Force - The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool `json:"force,omitempty"`
}

// ErrorBodyContract error Body contract.
type ErrorBodyContract struct {
	autorest.Response `json:"-"`
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]ErrorFieldContract `json:"details,omitempty"`
}

// ErrorFieldContract error Field contract.
type ErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GenerateSsoURLResult generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	autorest.Response `json:"-"`
	// Value - Redirect Url containing the SSO URL value.
	Value *string `json:"value,omitempty"`
}

// GroupCollection paged Group list representation.
type GroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]GroupContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupCollectionIterator provides access to a complete listing of GroupContract values.
type GroupCollectionIterator struct {
	i    int
	page GroupCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupCollectionIterator) Response() GroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupCollectionIterator) Value() GroupContract {
	if !iter.page.NotDone() {
		return GroupContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (gc GroupCollection) IsEmpty() bool {
	return gc.Value == nil || len(*gc.Value) == 0
}

// groupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gc GroupCollection) groupCollectionPreparer() (*http.Request, error) {
	if gc.NextLink == nil || len(to.String(gc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gc.NextLink)))
}

// GroupCollectionPage contains a page of GroupContract values.
type GroupCollectionPage struct {
	fn func(GroupCollection) (GroupCollection, error)
	gc GroupCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupCollectionPage) Next() error {
	next, err := page.fn(page.gc)
	if err != nil {
		return err
	}
	page.gc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupCollectionPage) NotDone() bool {
	return !page.gc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupCollectionPage) Response() GroupCollection {
	return page.gc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupCollectionPage) Values() []GroupContract {
	if page.gc.IsEmpty() {
		return nil
	}
	return *page.gc.Value
}

// GroupContract developer group.
type GroupContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the group within the current API Management service instance. The value is a valid relative URL in the format of /groups/{groupid} where {groupid} is a group identifier.
	ID *string `json:"id,omitempty"`
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// BuiltIn - true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupCreateParameters parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupUpdateParameters parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// Name - Group name.
	Name *string `json:"name,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupTypeContract `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// HostnameConfiguration custom hostname configuration.
type HostnameConfiguration struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Hostname - Hostname.
	Hostname *string `json:"hostname,omitempty"`
	// Certificate - Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// IdentityProviderContract the external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure
// Active Directory which can be used to enable access to the API Management service developer portal for all
// users.
type IdentityProviderContract struct {
	autorest.Response `json:"-"`
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderNameType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
}

// IdentityProviderList list of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	autorest.Response `json:"-"`
	// Value - Identity Provider configuration values.
	Value *[]IdentityProviderContract `json:"value,omitempty"`
}

// IdentityProviderUpdateParameters parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateParameters struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
}

// LoggerCollection paged Logger list representation.
type LoggerCollection struct {
	autorest.Response `json:"-"`
	// Value - Logger values.
	Value *[]LoggerResponse `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoggerCollectionIterator provides access to a complete listing of LoggerResponse values.
type LoggerCollectionIterator struct {
	i    int
	page LoggerCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoggerCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoggerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoggerCollectionIterator) Response() LoggerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoggerCollectionIterator) Value() LoggerResponse {
	if !iter.page.NotDone() {
		return LoggerResponse{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lc LoggerCollection) IsEmpty() bool {
	return lc.Value == nil || len(*lc.Value) == 0
}

// loggerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lc LoggerCollection) loggerCollectionPreparer() (*http.Request, error) {
	if lc.NextLink == nil || len(to.String(lc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lc.NextLink)))
}

// LoggerCollectionPage contains a page of LoggerResponse values.
type LoggerCollectionPage struct {
	fn func(LoggerCollection) (LoggerCollection, error)
	lc LoggerCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoggerCollectionPage) Next() error {
	next, err := page.fn(page.lc)
	if err != nil {
		return err
	}
	page.lc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoggerCollectionPage) NotDone() bool {
	return !page.lc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoggerCollectionPage) Response() LoggerCollection {
	return page.lc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoggerCollectionPage) Values() []LoggerResponse {
	if page.lc.IsEmpty() {
		return nil
	}
	return *page.lc.Value
}

// LoggerCreateParameters parameters supplied to the Create Logger operation.
type LoggerCreateParameters struct {
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerCreateParameters.
func (lcp LoggerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcp.Type != nil {
		objectMap["type"] = lcp.Type
	}
	if lcp.Description != nil {
		objectMap["description"] = lcp.Description
	}
	if lcp.Credentials != nil {
		objectMap["credentials"] = lcp.Credentials
	}
	if lcp.IsBuffered != nil {
		objectMap["isBuffered"] = lcp.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerResponse the Logger entity in API Management represents an event sink that you can use to log API
// Management events. Currently the Logger entity supports logging API Management events to Azure Event Hubs.
type LoggerResponse struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the logger within the current API Management service instance. The value is a valid relative URL in the format of /loggers/{loggerId} where {loggerId} is a logger identifier.
	ID *string `json:"id,omitempty"`
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerResponse.
func (lr LoggerResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.ID != nil {
		objectMap["id"] = lr.ID
	}
	if lr.Type != nil {
		objectMap["type"] = lr.Type
	}
	if lr.Description != nil {
		objectMap["description"] = lr.Description
	}
	if lr.Credentials != nil {
		objectMap["credentials"] = lr.Credentials
	}
	if lr.IsBuffered != nil {
		objectMap["isBuffered"] = lr.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerUpdateParameters parameters supplied to the Update Logger operation.
type LoggerUpdateParameters struct {
	// Type - Logger type.
	Type *string `json:"type,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - Logger credentials.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerUpdateParameters.
func (lup LoggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lup.Type != nil {
		objectMap["type"] = lup.Type
	}
	if lup.Description != nil {
		objectMap["description"] = lup.Description
	}
	if lup.Credentials != nil {
		objectMap["credentials"] = lup.Credentials
	}
	if lup.IsBuffered != nil {
		objectMap["isBuffered"] = lup.IsBuffered
	}
	return json.Marshal(objectMap)
}

// NetworkStatusContract network Status details.
type NetworkStatusContract struct {
	autorest.Response `json:"-"`
	// DNSServers - Gets the list of DNS servers IPV4 addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// ConnectivityStatus - Gets the list of Connectivity Status to the Resources.
	ConnectivityStatus *[]ConnectivityStatusContract `json:"connectivityStatus,omitempty"`
}

// OAuth2AuthenticationSettingsContract API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// AuthorizationServerID - OAuth authorization server identifier.
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`
	// Scope - operations scope.
	Scope *string `json:"scope,omitempty"`
}

// OAuth2AuthorizationServerContract external OAuth authorization server settings.
type OAuth2AuthorizationServerContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the authorization server within the current API Management service instance. The value is a valid relative URL in the format of /authorizationServers/{authsid} where {authsid} is an authorization server identifier.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]MethodContract `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantTypesContract `json:"grantTypes,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethodsContract `json:"bearerTokenSendingMethods,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// OAuth2AuthorizationServerUpdateContract external OAuth authorization server Update settings contract.
type OAuth2AuthorizationServerUpdateContract struct {
	// Name - User-friendly authorization server name.
	Name *string `json:"name,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]MethodContract `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantTypesContract `json:"grantTypes,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethodsContract `json:"bearerTokenSendingMethods,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// OpenIDConnectProviderCollection paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OpenidConnectProviderContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OpenIDConnectProviderCollectionIterator provides access to a complete listing of OpenidConnectProviderContract
// values.
type OpenIDConnectProviderCollectionIterator struct {
	i    int
	page OpenIDConnectProviderCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OpenIDConnectProviderCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OpenIDConnectProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OpenIDConnectProviderCollectionIterator) Response() OpenIDConnectProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OpenIDConnectProviderCollectionIterator) Value() OpenidConnectProviderContract {
	if !iter.page.NotDone() {
		return OpenidConnectProviderContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (oicpc OpenIDConnectProviderCollection) IsEmpty() bool {
	return oicpc.Value == nil || len(*oicpc.Value) == 0
}

// openIDConnectProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oicpc OpenIDConnectProviderCollection) openIDConnectProviderCollectionPreparer() (*http.Request, error) {
	if oicpc.NextLink == nil || len(to.String(oicpc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oicpc.NextLink)))
}

// OpenIDConnectProviderCollectionPage contains a page of OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionPage struct {
	fn    func(OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)
	oicpc OpenIDConnectProviderCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OpenIDConnectProviderCollectionPage) Next() error {
	next, err := page.fn(page.oicpc)
	if err != nil {
		return err
	}
	page.oicpc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OpenIDConnectProviderCollectionPage) NotDone() bool {
	return !page.oicpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OpenIDConnectProviderCollectionPage) Response() OpenIDConnectProviderCollection {
	return page.oicpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OpenIDConnectProviderCollectionPage) Values() []OpenidConnectProviderContract {
	if page.oicpc.IsEmpty() {
		return nil
	}
	return *page.oicpc.Value
}

// OpenidConnectProviderContract openID Connect Providers Contract.
type OpenidConnectProviderContract struct {
	autorest.Response `json:"-"`
	// ID - OpenID Connect Provider identifier.
	ID *string `json:"id,omitempty"`
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderCreateContract parameters supplied to the Create OpenID Connect Provider operation.
type OpenidConnectProviderCreateContract struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderUpdateContract parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// Name - User-friendly OpenID Connect Provider name.
	Name *string `json:"name,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationCollection paged Operation list representation.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OperationContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationCollectionIterator provides access to a complete listing of OperationContract values.
type OperationCollectionIterator struct {
	i    int
	page OperationCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationCollectionIterator) Response() OperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationCollectionIterator) Value() OperationContract {
	if !iter.page.NotDone() {
		return OperationContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (oc OperationCollection) IsEmpty() bool {
	return oc.Value == nil || len(*oc.Value) == 0
}

// operationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oc OperationCollection) operationCollectionPreparer() (*http.Request, error) {
	if oc.NextLink == nil || len(to.String(oc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oc.NextLink)))
}

// OperationCollectionPage contains a page of OperationContract values.
type OperationCollectionPage struct {
	fn func(OperationCollection) (OperationCollection, error)
	oc OperationCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationCollectionPage) Next() error {
	next, err := page.fn(page.oc)
	if err != nil {
		return err
	}
	page.oc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationCollectionPage) NotDone() bool {
	return !page.oc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationCollectionPage) Response() OperationCollection {
	return page.oc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationCollectionPage) Values() []OperationContract {
	if page.oc.IsEmpty() {
		return nil
	}
	return *page.oc.Value
}

// OperationContract api Operation details.
type OperationContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the operation within the current API Management service instance. The value is a valid relative URL in the format of /apis/{aid}/operations/{id} where {aid} is an API identifier and {id} is an operation identifier.
	ID *string `json:"id,omitempty"`
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResultContract `json:"responses,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationEntityBaseContract api Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResultContract `json:"responses,omitempty"`
}

// OperationListResult result of the request to list REST API operations. It contains a list of operations and a
// URL nextLink to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OperationResultContract operation Result.
type OperationResultContract struct {
	autorest.Response `json:"-"`
	// ID - Operation result identifier.
	ID *string `json:"id,omitempty"`
	// Status - Status of an async operation. Possible values include: 'Started', 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationState `json:"status,omitempty"`
	// Started - Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Started *date.Time `json:"started,omitempty"`
	// Updated - Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Updated *date.Time `json:"updated,omitempty"`
	// ResultInfo - Optional result info.
	ResultInfo *string            `json:"resultInfo,omitempty"`
	Error      *ErrorBodyContract `json:"error,omitempty"`
}

// OperationUpdateContract api Operation Update Contract details.
type OperationUpdateContract struct {
	// ID - Uniquely identifies the operation within the current API Management service instance. The value is a valid relative URL in the format of /apis/{aid}/operations/{id} where {aid} is an API identifier and {id} is an operation identifier.
	ID *string `json:"id,omitempty"`
	// Name - Operation Name.
	Name *string `json:"name,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResultContract `json:"responses,omitempty"`
}

// ParameterContract operation parameters details.
type ParameterContract struct {
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// Description - Parameter description.
	Description *string `json:"description,omitempty"`
	// Type - Parameter type.
	Type *string `json:"type,omitempty"`
	// DefaultValue - Default parameter value.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// Required - whether parameter is required or not.
	Required *bool `json:"required,omitempty"`
	// Values - Parameter values.
	Values *[]string `json:"values,omitempty"`
}

// PolicySnippetContract policy snippet.
type PolicySnippetContract struct {
	// Name - Snippet name.
	Name *string `json:"name,omitempty"`
	// Content - Snippet content.
	Content *string `json:"content,omitempty"`
	// ToolTip - Snippet toolTip.
	ToolTip *string `json:"toolTip,omitempty"`
	// Scope - Snippet scope. Possible values include: 'PolicyScopeContractTenant', 'PolicyScopeContractProduct', 'PolicyScopeContractAPI', 'PolicyScopeContractOperation', 'PolicyScopeContractAll'
	Scope PolicyScopeContract `json:"scope,omitempty"`
}

// PolicySnippetsCollection the response of the list policy snippets operation.
type PolicySnippetsCollection struct {
	autorest.Response `json:"-"`
	// Value - Policy snippet value.
	Value *[]PolicySnippetContract `json:"value,omitempty"`
}

// ProductCollection paged Products list representation.
type ProductCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ProductContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductCollectionIterator provides access to a complete listing of ProductContract values.
type ProductCollectionIterator struct {
	i    int
	page ProductCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductCollectionIterator) Response() ProductCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductCollectionIterator) Value() ProductContract {
	if !iter.page.NotDone() {
		return ProductContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProductCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// productCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProductCollection) productCollectionPreparer() (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProductCollectionPage contains a page of ProductContract values.
type ProductCollectionPage struct {
	fn func(ProductCollection) (ProductCollection, error)
	pc ProductCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductCollectionPage) Next() error {
	next, err := page.fn(page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductCollectionPage) Response() ProductCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductCollectionPage) Values() []ProductContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// ProductContract product profile.
type ProductContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the product within the current API Management service instance. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ID *string `json:"id,omitempty"`
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is NotPublished. Possible values include: 'NotPublished', 'Published'
	State ProductStateContract `json:"state,omitempty"`
}

// ProductUpdateParameters parameters supplied to the CreateOrUpdate Product operation.
type ProductUpdateParameters struct {
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms and conditions. Developer will have to accept these terms before he's allowed to call product API.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Possible values include: 'NotPublished', 'Published'
	State ProductStateContract `json:"state,omitempty"`
}

// PropertyCollection paged Property list representation.
type PropertyCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]PropertyContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PropertyCollectionIterator provides access to a complete listing of PropertyContract values.
type PropertyCollectionIterator struct {
	i    int
	page PropertyCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PropertyCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PropertyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PropertyCollectionIterator) Response() PropertyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PropertyCollectionIterator) Value() PropertyContract {
	if !iter.page.NotDone() {
		return PropertyContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PropertyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// propertyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PropertyCollection) propertyCollectionPreparer() (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PropertyCollectionPage contains a page of PropertyContract values.
type PropertyCollectionPage struct {
	fn func(PropertyCollection) (PropertyCollection, error)
	pc PropertyCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PropertyCollectionPage) Next() error {
	next, err := page.fn(page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PropertyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PropertyCollectionPage) Response() PropertyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PropertyCollectionPage) Values() []PropertyContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// PropertyContract property details.
type PropertyContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the property within the current API Management service instance. The value is a valid relative URL in the format of /properties/{propId} where {propId} is a property identifier.
	ID *string `json:"id,omitempty"`
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyCreateParameters parameters supplied to the Create Property operation.
type PropertyCreateParameters struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyUpdateParameters parameters supplied to the Update Property operation.
type PropertyUpdateParameters struct {
	// Name - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	Name *string `json:"name,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// QuotaCounterCollection paged Quota Counter list representation.
type QuotaCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Quota counter values.
	Value *[]QuotaCounterContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaCounterContract quota counter details.
type QuotaCounterContract struct {
	autorest.Response `json:"-"`
	// CounterKey - The Key value of the Counter. Must not be empty.
	CounterKey *string `json:"counterKey,omitempty"`
	// PeriodKey - Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string `json:"periodKey,omitempty"`
	// PeriodStartTime - The date of the start of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodStartTime *date.Time `json:"periodStartTime,omitempty"`
	// PeriodEndTime - The date of the end of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodEndTime *date.Time `json:"periodEndTime,omitempty"`
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// QuotaCounterValueContract quota counter value details.
type QuotaCounterValueContract struct {
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RegionContract region profile.
type RegionContract struct {
	// Name - Region name.
	Name *string `json:"name,omitempty"`
	// IsMasterRegion - whether Region is the master region.
	IsMasterRegion *bool `json:"isMasterRegion,omitempty"`
}

// RegionListResult lists Regions operation response details.
type RegionListResult struct {
	autorest.Response `json:"-"`
	// Value - Lists of Regions.
	Value *[]RegionContract `json:"value,omitempty"`
}

// ReportCollection paged Report records list representation.
type ReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ReportRecordContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReportCollectionIterator provides access to a complete listing of ReportRecordContract values.
type ReportCollectionIterator struct {
	i    int
	page ReportCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReportCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReportCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReportCollectionIterator) Response() ReportCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReportCollectionIterator) Value() ReportRecordContract {
	if !iter.page.NotDone() {
		return ReportRecordContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ReportCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// reportCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ReportCollection) reportCollectionPreparer() (*http.Request, error) {
	if rc.NextLink == nil || len(to.String(rc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ReportCollectionPage contains a page of ReportRecordContract values.
type ReportCollectionPage struct {
	fn func(ReportCollection) (ReportCollection, error)
	rc ReportCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReportCollectionPage) Next() error {
	next, err := page.fn(page.rc)
	if err != nil {
		return err
	}
	page.rc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReportCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReportCollectionPage) Response() ReportCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReportCollectionPage) Values() []ReportRecordContract {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// ReportRecordContract report data.
type ReportRecordContract struct {
	// Name - Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string `json:"name,omitempty"`
	// Timestamp - Start of aggregation period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Interval - Length of agregation period.
	Interval *int64 `json:"interval,omitempty"`
	// Country - Country to which this record data is related.
	Country *string `json:"country,omitempty"`
	// Region - Country region to which this record data is related.
	Region *string `json:"region,omitempty"`
	// Zip - Zip code to which this record data is related.
	Zip *string `json:"zip,omitempty"`
	// UserID - User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// APIRegion - API region identifier.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// CallCountSuccess - Number of succesful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect
	CallCountSuccess *int32 `json:"callCountSuccess,omitempty"`
	// CallCountBlocked - Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorize and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests
	CallCountBlocked *int32 `json:"callCountBlocked,omitempty"`
	// CallCountFailed - Number of calls failed due to proxy or backend errors. This includes calls returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600
	CallCountFailed *int32 `json:"callCountFailed,omitempty"`
	// CallCountOther - Number of other calls.
	CallCountOther *int32 `json:"callCountOther,omitempty"`
	// CallCountTotal - Total number of calls.
	CallCountTotal *int32 `json:"callCountTotal,omitempty"`
	// Bandwidth - Bandwidth consumed.
	Bandwidth *int64 `json:"bandwidth,omitempty"`
	// CacheHitCount - Number of times when content was served from cache policy.
	CacheHitCount *int32 `json:"cacheHitCount,omitempty"`
	// CacheMissCount - Number of times content was fetched from backend.
	CacheMissCount *int32 `json:"cacheMissCount,omitempty"`
	// APITimeAvg - Average time it took to process request.
	APITimeAvg *float64 `json:"apiTimeAvg,omitempty"`
	// APITimeMin - Minimum time it took to process request.
	APITimeMin *float64 `json:"apiTimeMin,omitempty"`
	// APITimeMax - Maximum time it took to process request.
	APITimeMax *float64 `json:"apiTimeMax,omitempty"`
	// ServiceTimeAvg - Average time it took to process request on backend.
	ServiceTimeAvg *float64 `json:"serviceTimeAvg,omitempty"`
	// ServiceTimeMin - Minimum time it took to process request on backend.
	ServiceTimeMin *float64 `json:"serviceTimeMin,omitempty"`
	// ServiceTimeMax - Maximum time it took to process request on backend.
	ServiceTimeMax *float64 `json:"serviceTimeMax,omitempty"`
}

// RepresentationContract operation request/response representation details.
type RepresentationContract struct {
	// ContentType - Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string `json:"contentType,omitempty"`
	// Sample - An example of the representation.
	Sample *string `json:"sample,omitempty"`
}

// RequestContract operation request details.
type RequestContract struct {
	// Description - Operation request description.
	Description *string `json:"description,omitempty"`
	// QueryParameters - Collection of operation request query parameters.
	QueryParameters *[]ParameterContract `json:"queryParameters,omitempty"`
	// Headers - Collection of operation request headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
	// Representations - Collection of operation request representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResultContract operation response details.
type ResultContract struct {
	// StatusCode - Operation response HTTP status code.
	StatusCode *int32 `json:"statusCode,omitempty"`
	// Description - Operation response description.
	Description *string `json:"description,omitempty"`
	// Representations - Collection of operation response representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// SaveConfigurationParameter parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameter struct {
	// Branch - The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string `json:"branch,omitempty"`
	// Force - The value if true, the current configuration database is committed to the Git repository, even if the Git repository has newer changes that would be overwritten.
	Force *bool `json:"force,omitempty"`
}

// ServiceBackupRestoreParameters parameters supplied to the Backup/Restore of an API Management service operation.
type ServiceBackupRestoreParameters struct {
	// StorageAccount - Azure Cloud Storage account (used to place/retrieve the backup) name.
	StorageAccount *string `json:"storageAccount,omitempty"`
	// AccessKey - Azure Cloud Storage account (used to place/retrieve the backup) access key.
	AccessKey *string `json:"accessKey,omitempty"`
	// ContainerName - Azure Cloud Storage blob container name used to place/retrieve the backup.
	ContainerName *string `json:"containerName,omitempty"`
	// BackupName - The name of the backup file to create.
	BackupName *string `json:"backupName,omitempty"`
}

// ServiceCheckNameAvailabilityParameters parameters supplied to the CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	// Name - The name to check for availability.
	Name *string `json:"name,omitempty"`
}

// ServiceGetSsoTokenResult the response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	autorest.Response `json:"-"`
	// RedirectURI - Redirect URL containing the SSO token.
	RedirectURI *string `json:"redirect_uri,omitempty"`
}

// ServiceListResult the response of the List API Management services operation.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List API Management services operation.
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListResultIterator provides access to a complete listing of ServiceResource values.
type ServiceListResultIterator struct {
	i    int
	page ServiceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListResultIterator) Response() ServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListResultIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServiceListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// serviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServiceListResult) serviceListResultPreparer() (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServiceListResultPage contains a page of ServiceResource values.
type ServiceListResultPage struct {
	fn  func(ServiceListResult) (ServiceListResult, error)
	slr ServiceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListResultPage) Next() error {
	next, err := page.fn(page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListResultPage) Response() ServiceListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListResultPage) Values() []ServiceResource {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// ServiceManageDeploymentsParameters parameters supplied to the ManageDeployments operation.
type ServiceManageDeploymentsParameters struct {
	// Location - Location of the API Management service Azure data center.
	Location *string `json:"location,omitempty"`
	// SkuType - SKU type of the API Management service. Possible values include: 'Developer', 'Standard', 'Premium'
	SkuType SkuType `json:"skuType,omitempty"`
	// SkuUnitCount - SKU Unit count of the API Management service. Default value is 1.
	SkuUnitCount *int32 `json:"skuUnitCount,omitempty"`
	// AdditionalLocations - Additional data center locations for the API Management service.
	AdditionalLocations *[]AdditionalRegion `json:"additionalLocations,omitempty"`
	// VpnConfiguration - Virtual network configuration.
	VpnConfiguration *VirtualNetworkConfiguration `json:"vpnConfiguration,omitempty"`
	// VpnType - The type of VPN in which API Managemet service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that the API Management service deployment is set up inside a Virtual Network having an Intranet Facing Endpoint only. When vpnConfiguration is specified, vpnType must be specified. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VpnType VirtualNetworkType `json:"vpnType,omitempty"`
}

// ServiceNameAvailabilityResult response of the CheckNameAvailability operation.
type ServiceNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - True if the name is available and can be used to create a new API Management service; otherwise false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that <resourceName> is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
	// Reason - Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is already in use and is therefore unavailable. Possible values include: 'Valid', 'Invalid', 'AlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
}

// ServiceProperties properties of an API Management service resource description.
type ServiceProperties struct {
	// PublisherEmail - Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`
	// PublisherName - Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`
	// ProvisioningState - The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TargetProvisioningState - The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty"`
	// CreatedAtUtc - Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedAtUtc *date.Time `json:"createdAtUtc,omitempty"`
	// RuntimeURL - Proxy endpoint URL of the API Management service.
	RuntimeURL *string `json:"runtimeUrl,omitempty"`
	// PortalURL - Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty"`
	// ManagementAPIURL - Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty"`
	// ScmURL - SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty"`
	// AddresserEmail - Addresser email.
	AddresserEmail *string `json:"addresserEmail,omitempty"`
	// HostnameConfigurations - Custom hostname configuration of the API Management service.
	HostnameConfigurations *[]HostnameConfiguration `json:"hostnameConfigurations,omitempty"`
	// StaticIPs - Static IP addresses of the API Management service virtual machines. Available only for Standard and Premium SKU.
	StaticIPs *[]string `json:"staticIPs,omitempty"`
	// Vpnconfiguration - Virtual network configuration of the API Management service.
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
	// AdditionalLocations - Additional datacenter locations of the API Management service.
	AdditionalLocations *[]AdditionalRegion `json:"additionalLocations,omitempty"`
	// CustomProperties - Custom properties of the API Management service, like disabling TLS 1.0.
	CustomProperties map[string]*string `json:"customProperties"`
	// VpnType - The type of VPN in which API Managemet service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VpnType VirtualNetworkType `json:"vpnType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.PublisherEmail != nil {
		objectMap["publisherEmail"] = sp.PublisherEmail
	}
	if sp.PublisherName != nil {
		objectMap["publisherName"] = sp.PublisherName
	}
	if sp.ProvisioningState != nil {
		objectMap["provisioningState"] = sp.ProvisioningState
	}
	if sp.TargetProvisioningState != nil {
		objectMap["targetProvisioningState"] = sp.TargetProvisioningState
	}
	if sp.CreatedAtUtc != nil {
		objectMap["createdAtUtc"] = sp.CreatedAtUtc
	}
	if sp.RuntimeURL != nil {
		objectMap["runtimeUrl"] = sp.RuntimeURL
	}
	if sp.PortalURL != nil {
		objectMap["portalUrl"] = sp.PortalURL
	}
	if sp.ManagementAPIURL != nil {
		objectMap["managementApiUrl"] = sp.ManagementAPIURL
	}
	if sp.ScmURL != nil {
		objectMap["scmUrl"] = sp.ScmURL
	}
	if sp.AddresserEmail != nil {
		objectMap["addresserEmail"] = sp.AddresserEmail
	}
	if sp.HostnameConfigurations != nil {
		objectMap["hostnameConfigurations"] = sp.HostnameConfigurations
	}
	if sp.StaticIPs != nil {
		objectMap["staticIPs"] = sp.StaticIPs
	}
	if sp.Vpnconfiguration != nil {
		objectMap["vpnconfiguration"] = sp.Vpnconfiguration
	}
	if sp.AdditionalLocations != nil {
		objectMap["additionalLocations"] = sp.AdditionalLocations
	}
	if sp.CustomProperties != nil {
		objectMap["customProperties"] = sp.CustomProperties
	}
	if sp.VpnType != "" {
		objectMap["vpnType"] = sp.VpnType
	}
	return json.Marshal(objectMap)
}

// ServiceResource a single API Management service resource in List or Get response.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// ServiceProperties - Properties of the API Management service.
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
	// Etag - ETag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.ServiceProperties != nil {
		objectMap["properties"] = sr.ServiceProperties
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Type != nil {
		objectMap["type"] = sr.Type
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				sr.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSkuProperties
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sr.Sku = &sku
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		}
	}

	return nil
}

// ServicesApplyNetworkConfigurationUpdatesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServicesApplyNetworkConfigurationUpdatesFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesApplyNetworkConfigurationUpdatesFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesApplyNetworkConfigurationUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesApplyNetworkConfigurationUpdatesFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.ApplyNetworkConfigurationUpdatesResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesApplyNetworkConfigurationUpdatesFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesApplyNetworkConfigurationUpdatesFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.ApplyNetworkConfigurationUpdatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesApplyNetworkConfigurationUpdatesFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServicesBackupFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesBackupFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesBackupFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesBackupFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.BackupResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesBackupFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesBackupFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.BackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesBackupFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServiceSkuProperties API Management service resource SKU properties.
type ServiceSkuProperties struct {
	// Name - Name of the Sku. Possible values include: 'Developer', 'Standard', 'Premium'
	Name SkuType `json:"name,omitempty"`
	// Capacity - Capacity of the SKU (number of deployed units of the SKU). The default value is 1.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServicesManageDeploymentsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesManageDeploymentsFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesManageDeploymentsFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesManageDeploymentsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesManageDeploymentsFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.ManageDeploymentsResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesManageDeploymentsFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesManageDeploymentsFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.ManageDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesManageDeploymentsFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServicesRestoreFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesRestoreFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesRestoreFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesRestoreFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.RestoreResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesRestoreFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesRestoreFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.RestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesRestoreFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesUpdateFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesUpdateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.UpdateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServicesUpdateHostnameFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateHostnameFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ServicesUpdateHostnameFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateHostnameFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return sr, azure.NewAsyncOpIncompleteError("apimanagement.ServicesUpdateHostnameFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		sr, err = client.UpdateHostnameResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateHostnameFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateHostnameFuture", "Result", resp, "Failure sending request")
		return
	}
	sr, err = client.UpdateHostnameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServicesUpdateHostnameFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ServiceUpdateHostnameParameters parameters supplied to the UpdateHostname operation.
type ServiceUpdateHostnameParameters struct {
	// Update - Hostnames to create or update.
	Update *[]HostnameConfiguration `json:"update,omitempty"`
	// Delete - Hostnames types to delete.
	Delete *[]HostnameType `json:"delete,omitempty"`
}

// ServiceUpdateParameters parameters supplied to the Update API Management service operation.
type ServiceUpdateParameters struct {
	// ServiceProperties - Properties of the API Management service.
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceUpdateParameters.
func (sup ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.ServiceProperties != nil {
		objectMap["properties"] = sup.ServiceProperties
	}
	if sup.Sku != nil {
		objectMap["sku"] = sup.Sku
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceUpdateParameters struct.
func (sup *ServiceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				sup.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSkuProperties
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sup.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sup.Tags = tags
			}
		}
	}

	return nil
}

// ServiceUploadCertificateParameters parameters supplied to the Upload SSL certificate for an API Management
// service operation.
type ServiceUploadCertificateParameters struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Certificate - Base64 Encoded certificate.
	Certificate *string `json:"certificate,omitempty"`
	// CertificatePassword - Certificate password.
	CertificatePassword *string `json:"certificate_password,omitempty"`
}

// SubscriptionCollection paged Subscriptions list representation.
type SubscriptionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]SubscriptionContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionCollectionIterator provides access to a complete listing of SubscriptionContract values.
type SubscriptionCollectionIterator struct {
	i    int
	page SubscriptionCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionCollectionIterator) Response() SubscriptionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionCollectionIterator) Value() SubscriptionContract {
	if !iter.page.NotDone() {
		return SubscriptionContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SubscriptionCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// subscriptionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SubscriptionCollection) subscriptionCollectionPreparer() (*http.Request, error) {
	if sc.NextLink == nil || len(to.String(sc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SubscriptionCollectionPage contains a page of SubscriptionContract values.
type SubscriptionCollectionPage struct {
	fn func(SubscriptionCollection) (SubscriptionCollection, error)
	sc SubscriptionCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionCollectionPage) Next() error {
	next, err := page.fn(page.sc)
	if err != nil {
		return err
	}
	page.sc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionCollectionPage) Response() SubscriptionCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionCollectionPage) Values() []SubscriptionContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// SubscriptionContract subscription details.
type SubscriptionContract struct {
	autorest.Response `json:"-"`
	// ID - Uniquely identifies the subscription within the current API Management service instance. The value is a valid relative URL in the format of /subscriptions/{sid} where {sid} is a subscription identifier.
	ID *string `json:"id,omitempty"`
	// UserID - The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{uid} where {uid} is a user identifier.
	UserID *string `json:"userId,omitempty"`
	// ProductID - The product resource identifier of the subscribed product. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ProductID *string `json:"productId,omitempty"`
	// Name - The name of the subscription, or null if the subscription has no name.
	Name *string `json:"name,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
	// CreatedDate - Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// StartDate - Subscription activation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - Subscription expiration date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// EndDate - Date when subscription was cancelled or expired. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	EndDate *date.Time `json:"endDate,omitempty"`
	// NotificationDate - Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	NotificationDate *date.Time `json:"notificationDate,omitempty"`
	// PrimaryKey - Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// StateComment - Optional subscription comment added by an administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// SubscriptionCreateParameters parameters supplied to the Create subscription operation.
type SubscriptionCreateParameters struct {
	// UserID - User (user id path) for whom subscription is being created in form /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product (product id path) for which subscription is being created in form /products/{productid}
	ProductID *string `json:"productId,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
}

// SubscriptionKeyParameterNamesContract subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Header - Subscription key header name.
	Header *string `json:"header,omitempty"`
	// Query - Subscription key query string parameter name.
	Query *string `json:"query,omitempty"`
}

// SubscriptionUpdateParameters parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameters struct {
	// UserID - User identifier path: /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path: /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// ExpirationDate - New subscription expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Name - Subscription name.
	Name *string `json:"name,omitempty"`
	// PrimaryKey - Primary subscription key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionStateContract `json:"state,omitempty"`
	// StateComment - Comments describing subscription state change by the administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// TenantConfigurationDeployFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationDeployFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future TenantConfigurationDeployFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return orc, azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationDeployFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		orc, err = client.DeployResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", resp, "Failure sending request")
		return
	}
	orc, err = client.DeployResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// TenantConfigurationSaveFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationSaveFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future TenantConfigurationSaveFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return orc, azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationSaveFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		orc, err = client.SaveResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", resp, "Failure sending request")
		return
	}
	orc, err = client.SaveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// TenantConfigurationSyncStateContract tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContract struct {
	autorest.Response `json:"-"`
	// Branch - The name of Git branch.
	Branch *string `json:"branch,omitempty"`
	// CommitID - The latest commit Id.
	CommitID *string `json:"commitId,omitempty"`
	// IsExport - value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool `json:"isExport,omitempty"`
	// IsSynced - value indicating if last synchronization was later than the configuration change.
	IsSynced *bool `json:"isSynced,omitempty"`
	// IsGitEnabled - value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool `json:"isGitEnabled,omitempty"`
	// SyncDate - The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	SyncDate *date.Time `json:"syncDate,omitempty"`
	// ConfigurationChangeDate - The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ConfigurationChangeDate *date.Time `json:"configurationChangeDate,omitempty"`
}

// TenantConfigurationValidateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationValidateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future TenantConfigurationValidateFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return orc, azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationValidateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		orc, err = client.ValidateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", resp, "Failure sending request")
		return
	}
	orc, err = client.ValidateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// TokenBodyParameterContract oAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// Name - body parameter name.
	Name *string `json:"name,omitempty"`
	// Value - body parameter value.
	Value *string `json:"value,omitempty"`
}

// UserCollection paged Users list representation.
type UserCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]UserContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserCollectionIterator provides access to a complete listing of UserContract values.
type UserCollectionIterator struct {
	i    int
	page UserCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserCollectionIterator) Response() UserCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserCollectionIterator) Value() UserContract {
	if !iter.page.NotDone() {
		return UserContract{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UserCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// userCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UserCollection) userCollectionPreparer() (*http.Request, error) {
	if uc.NextLink == nil || len(to.String(uc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UserCollectionPage contains a page of UserContract values.
type UserCollectionPage struct {
	fn func(UserCollection) (UserCollection, error)
	uc UserCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserCollectionPage) Next() error {
	next, err := page.fn(page.uc)
	if err != nil {
		return err
	}
	page.uc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserCollectionPage) Response() UserCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserCollectionPage) Values() []UserContract {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// UserContract user profile.
type UserContract struct {
	autorest.Response `json:"-"`
	// ID - User identifier path.
	ID *string `json:"id,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// State - User state. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// RegistrationDate - Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// Note - Administrator's note about given user.
	Note *string `json:"note,omitempty"`
	// Identities - Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// UserCreateParameters parameters supplied to the Create User operation.
type UserCreateParameters struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// Password - User Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
}

// UserIdentityCollection list of Users Identity list representation.
type UserIdentityCollection struct {
	autorest.Response `json:"-"`
	// Value - User Identity values.
	Value *[]UserIdentityContract `json:"value,omitempty"`
}

// UserIdentityContract user identity details.
type UserIdentityContract struct {
	// Provider - Identity provider name.
	Provider *string `json:"provider,omitempty"`
	// ID - Identifier value within provider.
	ID *string `json:"id,omitempty"`
}

// UserTokenParameters parameters supplied to the Get User Token operation.
type UserTokenParameters struct {
	// KeyType - The Key to be used to generate token for user. Possible values include: 'Primary', 'Secondary'
	KeyType KeyTypeContract `json:"keyType,omitempty"`
	// Expiry - The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
}

// UserTokenResult get User Token response details.
type UserTokenResult struct {
	autorest.Response `json:"-"`
	// Value - Shared Access Authorization token for the User.
	Value *string `json:"value,omitempty"`
}

// UserUpdateParameters parameters supplied to the Update User operation.
type UserUpdateParameters struct {
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// Password - Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Possible values include: 'UserStateContractActive', 'UserStateContractBlocked'
	State UserStateContract `json:"state,omitempty"`
	// Note - Note about user.
	Note *string `json:"note,omitempty"`
}

// VirtualNetworkConfiguration configuration of a virtual network to which API Management service is deployed.
type VirtualNetworkConfiguration struct {
	// Vnetid - The virtual network ID. This is typically a GUID. Expect a null GUID by default.
	Vnetid *string `json:"vnetid,omitempty"`
	// Subnetname - The name of the subnet.
	Subnetname *string `json:"subnetname,omitempty"`
	// SubnetResourceID - The full resource ID of a subnet in a virtual network to deploy the API Management service in.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
	// Location - The location of the virtual network.
	Location *string `json:"location,omitempty"`
}
