// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to send a custom verification email to a specified recipient.
type SendCustomVerificationEmailInput struct {
	_ struct{} `type:"structure"`

	// Name of a configuration set to use when sending the verification email.
	ConfigurationSetName *string `type:"string"`

	// The email address to verify.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The name of the custom verification email template to use when sending the
	// verification email.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendCustomVerificationEmailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCustomVerificationEmailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendCustomVerificationEmailInput"}

	if s.EmailAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailAddress"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response received when attempting to send the custom verification email.
type SendCustomVerificationEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendCustomVerificationEmail
	// operation.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendCustomVerificationEmailOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendCustomVerificationEmail = "SendCustomVerificationEmail"

// SendCustomVerificationEmailRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Adds an email address to the list of identities for your Amazon SES account
// in the current AWS Region and attempts to verify it. As a result of executing
// this operation, a customized verification email is sent to the specified
// address.
//
// To use this operation, you must first create a custom verification email
// template. For more information about creating and using custom verification
// email templates, see Using Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using SendCustomVerificationEmailRequest.
//    req := client.SendCustomVerificationEmailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendCustomVerificationEmail
func (c *Client) SendCustomVerificationEmailRequest(input *SendCustomVerificationEmailInput) SendCustomVerificationEmailRequest {
	op := &aws.Operation{
		Name:       opSendCustomVerificationEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCustomVerificationEmailInput{}
	}

	req := c.newRequest(op, input, &SendCustomVerificationEmailOutput{})
	return SendCustomVerificationEmailRequest{Request: req, Input: input, Copy: c.SendCustomVerificationEmailRequest}
}

// SendCustomVerificationEmailRequest is the request type for the
// SendCustomVerificationEmail API operation.
type SendCustomVerificationEmailRequest struct {
	*aws.Request
	Input *SendCustomVerificationEmailInput
	Copy  func(*SendCustomVerificationEmailInput) SendCustomVerificationEmailRequest
}

// Send marshals and sends the SendCustomVerificationEmail API request.
func (r SendCustomVerificationEmailRequest) Send(ctx context.Context) (*SendCustomVerificationEmailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendCustomVerificationEmailResponse{
		SendCustomVerificationEmailOutput: r.Request.Data.(*SendCustomVerificationEmailOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendCustomVerificationEmailResponse is the response type for the
// SendCustomVerificationEmail API operation.
type SendCustomVerificationEmailResponse struct {
	*SendCustomVerificationEmailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendCustomVerificationEmail request.
func (r *SendCustomVerificationEmailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
