BEGIN {
    print "// Code generated by all_keywords.awk."
    print ""
    print "package parser"
    print ""
    print "var keywords = map[string]int{"

    # This variable will be associated with a pipe for intermediate output.
    sort = "env LC_ALL=C sort"
}

/^.*_keyword:/ {
  keyword = 1
  next
}

/^$/ {
  keyword = 0
}

{
  if (keyword && $NF != "") {
    printf("\"%s\": %s,\n", $NF, $NF) | sort
  }
}

END {
    # Flush the intermediate output by closing the pipe.
    close(sort)
    print "}"
}
