// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/sql/distsqlrun/data.proto
// DO NOT EDIT!

package distsqlrun

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb3 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb2 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_pgerror "github.com/cockroachdb/cockroach/pkg/sql/pgwire/pgerror"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_sql_sqlbase2 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The direction of the desired ordering for a column.
type Ordering_Column_Direction int32

const (
	Ordering_Column_ASC  Ordering_Column_Direction = 0
	Ordering_Column_DESC Ordering_Column_Direction = 1
)

var Ordering_Column_Direction_name = map[int32]string{
	0: "ASC",
	1: "DESC",
}
var Ordering_Column_Direction_value = map[string]int32{
	"ASC":  0,
	"DESC": 1,
}

func (x Ordering_Column_Direction) Enum() *Ordering_Column_Direction {
	p := new(Ordering_Column_Direction)
	*p = x
	return p
}
func (x Ordering_Column_Direction) String() string {
	return proto.EnumName(Ordering_Column_Direction_name, int32(x))
}
func (x *Ordering_Column_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Ordering_Column_Direction_value, data, "Ordering_Column_Direction")
	if err != nil {
		return err
	}
	*x = Ordering_Column_Direction(value)
	return nil
}
func (Ordering_Column_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorData, []int{2, 0, 0}
}

type StreamEndpointSpec_Type int32

const (
	// Stream that is part of the local flow.
	StreamEndpointSpec_LOCAL StreamEndpointSpec_Type = 0
	// Stream that has the other endpoint on a different node.
	StreamEndpointSpec_REMOTE StreamEndpointSpec_Type = 1
	// Special stream used when in "sync flow" mode. In this mode, we return
	// results directly as part of the RPC call that set up the flow. This saves
	// overhead (extra RPCs) compared to the normal mode where the RPC just sets
	// up the flow. This type can only be used with outbound endpoints.
	StreamEndpointSpec_SYNC_RESPONSE StreamEndpointSpec_Type = 2
)

var StreamEndpointSpec_Type_name = map[int32]string{
	0: "LOCAL",
	1: "REMOTE",
	2: "SYNC_RESPONSE",
}
var StreamEndpointSpec_Type_value = map[string]int32{
	"LOCAL":         0,
	"REMOTE":        1,
	"SYNC_RESPONSE": 2,
}

func (x StreamEndpointSpec_Type) Enum() *StreamEndpointSpec_Type {
	p := new(StreamEndpointSpec_Type)
	*p = x
	return p
}
func (x StreamEndpointSpec_Type) String() string {
	return proto.EnumName(StreamEndpointSpec_Type_name, int32(x))
}
func (x *StreamEndpointSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(StreamEndpointSpec_Type_value, data, "StreamEndpointSpec_Type")
	if err != nil {
		return err
	}
	*x = StreamEndpointSpec_Type(value)
	return nil
}
func (StreamEndpointSpec_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorData, []int{3, 0}
}

type InputSyncSpec_Type int32

const (
	// Rows from the input streams are interleaved arbitrarily.
	InputSyncSpec_UNORDERED InputSyncSpec_Type = 0
	// The input streams are guaranteed to be ordered according to the column
	// ordering field; rows from the streams are interleaved to preserve that
	// ordering.
	InputSyncSpec_ORDERED InputSyncSpec_Type = 1
)

var InputSyncSpec_Type_name = map[int32]string{
	0: "UNORDERED",
	1: "ORDERED",
}
var InputSyncSpec_Type_value = map[string]int32{
	"UNORDERED": 0,
	"ORDERED":   1,
}

func (x InputSyncSpec_Type) Enum() *InputSyncSpec_Type {
	p := new(InputSyncSpec_Type)
	*p = x
	return p
}
func (x InputSyncSpec_Type) String() string {
	return proto.EnumName(InputSyncSpec_Type_name, int32(x))
}
func (x *InputSyncSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(InputSyncSpec_Type_value, data, "InputSyncSpec_Type")
	if err != nil {
		return err
	}
	*x = InputSyncSpec_Type(value)
	return nil
}
func (InputSyncSpec_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{4, 0} }

type OutputRouterSpec_Type int32

const (
	// Single output stream.
	OutputRouterSpec_PASS_THROUGH OutputRouterSpec_Type = 0
	// Each row is sent to all output streams.
	OutputRouterSpec_MIRROR OutputRouterSpec_Type = 1
	// Each row is sent to one stream, chosen by hashing certain columns of
	// the row (specified by the hash_columns field).
	OutputRouterSpec_BY_HASH OutputRouterSpec_Type = 2
	// Each row is sent to one stream, chosen according to preset boundaries
	// for the values of certain columns of the row. TODO(radu): an extra
	// optional structure below for the range details.
	OutputRouterSpec_BY_RANGE OutputRouterSpec_Type = 3
)

var OutputRouterSpec_Type_name = map[int32]string{
	0: "PASS_THROUGH",
	1: "MIRROR",
	2: "BY_HASH",
	3: "BY_RANGE",
}
var OutputRouterSpec_Type_value = map[string]int32{
	"PASS_THROUGH": 0,
	"MIRROR":       1,
	"BY_HASH":      2,
	"BY_RANGE":     3,
}

func (x OutputRouterSpec_Type) Enum() *OutputRouterSpec_Type {
	p := new(OutputRouterSpec_Type)
	*p = x
	return p
}
func (x OutputRouterSpec_Type) String() string {
	return proto.EnumName(OutputRouterSpec_Type_name, int32(x))
}
func (x *OutputRouterSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(OutputRouterSpec_Type_value, data, "OutputRouterSpec_Type")
	if err != nil {
		return err
	}
	*x = OutputRouterSpec_Type(value)
	return nil
}
func (OutputRouterSpec_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{5, 0} }

// Error is a generic representation including a string message.
type Error struct {
	// Types that are valid to be assigned to Detail:
	//	*Error_PGError
	//	*Error_RetryableTxnError
	Detail isError_Detail `protobuf_oneof:"detail"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{0} }

type isError_Detail interface {
	isError_Detail()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Error_PGError struct {
	PGError *cockroach_pgerror.Error `protobuf:"bytes,1,opt,name=pg_error,json=pgError,oneof"`
}
type Error_RetryableTxnError struct {
	RetryableTxnError *cockroach_roachpb2.UnhandledRetryableError `protobuf:"bytes,2,opt,name=retryableTxnError,oneof"`
}

func (*Error_PGError) isError_Detail()           {}
func (*Error_RetryableTxnError) isError_Detail() {}

func (m *Error) GetDetail() isError_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (m *Error) GetPGError() *cockroach_pgerror.Error {
	if x, ok := m.GetDetail().(*Error_PGError); ok {
		return x.PGError
	}
	return nil
}

func (m *Error) GetRetryableTxnError() *cockroach_roachpb2.UnhandledRetryableError {
	if x, ok := m.GetDetail().(*Error_RetryableTxnError); ok {
		return x.RetryableTxnError
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Error) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Error_OneofMarshaler, _Error_OneofUnmarshaler, _Error_OneofSizer, []interface{}{
		(*Error_PGError)(nil),
		(*Error_RetryableTxnError)(nil),
	}
}

func _Error_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_PGError:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PGError); err != nil {
			return err
		}
	case *Error_RetryableTxnError:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RetryableTxnError); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Error.Detail has unexpected type %T", x)
	}
	return nil
}

func _Error_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Error)
	switch tag {
	case 1: // detail.pg_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(cockroach_pgerror.Error)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_PGError{msg}
		return true, err
	case 2: // detail.retryableTxnError
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(cockroach_roachpb2.UnhandledRetryableError)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_RetryableTxnError{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Error_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_PGError:
		s := proto.Size(x.PGError)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Error_RetryableTxnError:
		s := proto.Size(x.RetryableTxnError)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Expression struct {
	// TODO(radu): TBD how this will be used
	Version string `protobuf:"bytes,1,opt,name=version" json:"version"`
	// SQL expressions are passed as a string, with ordinal references
	// (@1, @2, @3 ..) used for "input" variables.
	Expr string `protobuf:"bytes,2,opt,name=expr" json:"expr"`
}

func (m *Expression) Reset()                    { *m = Expression{} }
func (m *Expression) String() string            { return proto.CompactTextString(m) }
func (*Expression) ProtoMessage()               {}
func (*Expression) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{1} }

// Ordering defines an order - specifically a list of column indices and
// directions. See sqlbase.ColumnOrdering.
type Ordering struct {
	Columns []Ordering_Column `protobuf:"bytes,1,rep,name=columns" json:"columns"`
}

func (m *Ordering) Reset()                    { *m = Ordering{} }
func (m *Ordering) String() string            { return proto.CompactTextString(m) }
func (*Ordering) ProtoMessage()               {}
func (*Ordering) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{2} }

type Ordering_Column struct {
	ColIdx    uint32                    `protobuf:"varint,1,opt,name=col_idx,json=colIdx" json:"col_idx"`
	Direction Ordering_Column_Direction `protobuf:"varint,2,opt,name=direction,enum=cockroach.sql.distsqlrun.Ordering_Column_Direction" json:"direction"`
}

func (m *Ordering_Column) Reset()                    { *m = Ordering_Column{} }
func (m *Ordering_Column) String() string            { return proto.CompactTextString(m) }
func (*Ordering_Column) ProtoMessage()               {}
func (*Ordering_Column) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{2, 0} }

// StreamEndpointSpec describes one of the endpoints (input or output) of a physical
// stream.
type StreamEndpointSpec struct {
	Type StreamEndpointSpec_Type `protobuf:"varint,1,opt,name=type,enum=cockroach.sql.distsqlrun.StreamEndpointSpec_Type" json:"type"`
	// The ID of this stream.
	//
	// For LOCAL streams, both ends of the stream are part of the flow on this
	// machine (and there must be a corresponding endpoint with the same ID).
	//
	// For REMOTE streams, this ID is used in the ProducerHeader when connecting to
	// the other host.
	//
	// For SYNC_RESPONSE streams, the ID is unused.
	StreamID StreamID `protobuf:"varint,2,opt,name=stream_id,json=streamId,casttype=StreamID" json:"stream_id"`
	// Serving address for the target host, only used for outgoing REMOTE streams.
	TargetAddr string `protobuf:"bytes,3,opt,name=target_addr,json=targetAddr" json:"target_addr"`
}

func (m *StreamEndpointSpec) Reset()                    { *m = StreamEndpointSpec{} }
func (m *StreamEndpointSpec) String() string            { return proto.CompactTextString(m) }
func (*StreamEndpointSpec) ProtoMessage()               {}
func (*StreamEndpointSpec) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{3} }

// InputSyncSpec is the specification for an input synchronizer; it decides how
// to interleave rows from multiple input streams.
type InputSyncSpec struct {
	Type     InputSyncSpec_Type   `protobuf:"varint,1,opt,name=type,enum=cockroach.sql.distsqlrun.InputSyncSpec_Type" json:"type"`
	Ordering Ordering             `protobuf:"bytes,2,opt,name=ordering" json:"ordering"`
	Streams  []StreamEndpointSpec `protobuf:"bytes,3,rep,name=streams" json:"streams"`
	// Schema for the streams entering this synchronizer.
	ColumnTypes []cockroach_sql_sqlbase1.ColumnType `protobuf:"bytes,4,rep,name=column_types,json=columnTypes" json:"column_types"`
}

func (m *InputSyncSpec) Reset()                    { *m = InputSyncSpec{} }
func (m *InputSyncSpec) String() string            { return proto.CompactTextString(m) }
func (*InputSyncSpec) ProtoMessage()               {}
func (*InputSyncSpec) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{4} }

// OutputRouterSpec is the specification for the output router of a processor;
// it decides how to send results to multiple output streams.
type OutputRouterSpec struct {
	Type    OutputRouterSpec_Type `protobuf:"varint,1,opt,name=type,enum=cockroach.sql.distsqlrun.OutputRouterSpec_Type" json:"type"`
	Streams []StreamEndpointSpec  `protobuf:"bytes,2,rep,name=streams" json:"streams"`
	// Only used for the BY_HASH type; these are the indexes of the columns we are
	// hashing.
	HashColumns []uint32 `protobuf:"varint,3,rep,name=hash_columns,json=hashColumns" json:"hash_columns,omitempty"`
}

func (m *OutputRouterSpec) Reset()                    { *m = OutputRouterSpec{} }
func (m *OutputRouterSpec) String() string            { return proto.CompactTextString(m) }
func (*OutputRouterSpec) ProtoMessage()               {}
func (*OutputRouterSpec) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{5} }

type DatumInfo struct {
	Encoding cockroach_sql_sqlbase2.DatumEncoding `protobuf:"varint,1,opt,name=encoding,enum=cockroach.sql.sqlbase.DatumEncoding" json:"encoding"`
	Type     cockroach_sql_sqlbase1.ColumnType    `protobuf:"bytes,2,opt,name=type" json:"type"`
}

func (m *DatumInfo) Reset()                    { *m = DatumInfo{} }
func (m *DatumInfo) String() string            { return proto.CompactTextString(m) }
func (*DatumInfo) ProtoMessage()               {}
func (*DatumInfo) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{6} }

// ProducerHeader is a message that is sent once at the beginning of a stream.
type ProducerHeader struct {
	FlowID   FlowID   `protobuf:"bytes,1,opt,name=flow_id,json=flowId,customtype=FlowID" json:"flow_id"`
	StreamID StreamID `protobuf:"varint,2,opt,name=stream_id,json=streamId,casttype=StreamID" json:"stream_id"`
}

func (m *ProducerHeader) Reset()                    { *m = ProducerHeader{} }
func (m *ProducerHeader) String() string            { return proto.CompactTextString(m) }
func (*ProducerHeader) ProtoMessage()               {}
func (*ProducerHeader) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{7} }

// ProducerData is a message that can be sent multiple times as part of a stream
// from a producer to a consumer. It contains 0 or more rows and/or 0 or more
// metadata messages.
type ProducerData struct {
	// A bunch of rows, encoded. Each datum is encoded according to the
	// corresponding DatumInfo.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
	// In the special case when the stream contains empty rows, the count is
	// passed instead.
	NumEmptyRows int32 `protobuf:"varint,3,opt,name=num_empty_rows,json=numEmptyRows" json:"num_empty_rows"`
	// A bunch of metadata messages.
	Metadata []RemoteProducerMetadata `protobuf:"bytes,2,rep,name=metadata" json:"metadata"`
}

func (m *ProducerData) Reset()                    { *m = ProducerData{} }
func (m *ProducerData) String() string            { return proto.CompactTextString(m) }
func (*ProducerData) ProtoMessage()               {}
func (*ProducerData) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{8} }

type ProducerMessage struct {
	Header *ProducerHeader `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	// Typing information. There will be one DatumInfo for each element in a row.
	// This field has to be populated on, or before, a ProducerMessage with data
	// in it, and can only be populated once.
	// TODO(andrei): It'd be nice if the typing information for streams would be
	// configured statically at plan creation time, instead of being discovered
	// dynamically through the first rows that flow.
	Typing []DatumInfo  `protobuf:"bytes,2,rep,name=typing" json:"typing"`
	Data   ProducerData `protobuf:"bytes,3,opt,name=data" json:"data"`
}

func (m *ProducerMessage) Reset()                    { *m = ProducerMessage{} }
func (m *ProducerMessage) String() string            { return proto.CompactTextString(m) }
func (*ProducerMessage) ProtoMessage()               {}
func (*ProducerMessage) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{9} }

// RemoteProducerMetadata represents records that a producer wants to pass to
// a consumer, other than data rows. It's named RemoteProducerMetadata to not
// clash with ProducerMetadata, which is used internally within a node and has
// a different go error instead of a proto error inside.
type RemoteProducerMetadata struct {
	// Types that are valid to be assigned to Value:
	//	*RemoteProducerMetadata_RangeInfo
	//	*RemoteProducerMetadata_Error
	Value isRemoteProducerMetadata_Value `protobuf_oneof:"value"`
}

func (m *RemoteProducerMetadata) Reset()                    { *m = RemoteProducerMetadata{} }
func (m *RemoteProducerMetadata) String() string            { return proto.CompactTextString(m) }
func (*RemoteProducerMetadata) ProtoMessage()               {}
func (*RemoteProducerMetadata) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{10} }

type isRemoteProducerMetadata_Value interface {
	isRemoteProducerMetadata_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type RemoteProducerMetadata_RangeInfo struct {
	RangeInfo *RemoteProducerMetadata_RangeInfos `protobuf:"bytes,1,opt,name=range_info,json=rangeInfo,oneof"`
}
type RemoteProducerMetadata_Error struct {
	Error *Error `protobuf:"bytes,2,opt,name=error,oneof"`
}

func (*RemoteProducerMetadata_RangeInfo) isRemoteProducerMetadata_Value() {}
func (*RemoteProducerMetadata_Error) isRemoteProducerMetadata_Value()     {}

func (m *RemoteProducerMetadata) GetValue() isRemoteProducerMetadata_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RemoteProducerMetadata) GetRangeInfo() *RemoteProducerMetadata_RangeInfos {
	if x, ok := m.GetValue().(*RemoteProducerMetadata_RangeInfo); ok {
		return x.RangeInfo
	}
	return nil
}

func (m *RemoteProducerMetadata) GetError() *Error {
	if x, ok := m.GetValue().(*RemoteProducerMetadata_Error); ok {
		return x.Error
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RemoteProducerMetadata) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RemoteProducerMetadata_OneofMarshaler, _RemoteProducerMetadata_OneofUnmarshaler, _RemoteProducerMetadata_OneofSizer, []interface{}{
		(*RemoteProducerMetadata_RangeInfo)(nil),
		(*RemoteProducerMetadata_Error)(nil),
	}
}

func _RemoteProducerMetadata_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RemoteProducerMetadata)
	// value
	switch x := m.Value.(type) {
	case *RemoteProducerMetadata_RangeInfo:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeInfo); err != nil {
			return err
		}
	case *RemoteProducerMetadata_Error:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RemoteProducerMetadata.Value has unexpected type %T", x)
	}
	return nil
}

func _RemoteProducerMetadata_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RemoteProducerMetadata)
	switch tag {
	case 1: // value.range_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RemoteProducerMetadata_RangeInfos)
		err := b.DecodeMessage(msg)
		m.Value = &RemoteProducerMetadata_RangeInfo{msg}
		return true, err
	case 2: // value.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Error)
		err := b.DecodeMessage(msg)
		m.Value = &RemoteProducerMetadata_Error{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RemoteProducerMetadata_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RemoteProducerMetadata)
	// value
	switch x := m.Value.(type) {
	case *RemoteProducerMetadata_RangeInfo:
		s := proto.Size(x.RangeInfo)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RemoteProducerMetadata_Error:
		s := proto.Size(x.Error)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RemoteProducerMetadata_RangeInfos struct {
	RangeInfo []cockroach_roachpb3.RangeInfo `protobuf:"bytes,1,rep,name=range_info,json=rangeInfo" json:"range_info"`
}

func (m *RemoteProducerMetadata_RangeInfos) Reset()         { *m = RemoteProducerMetadata_RangeInfos{} }
func (m *RemoteProducerMetadata_RangeInfos) String() string { return proto.CompactTextString(m) }
func (*RemoteProducerMetadata_RangeInfos) ProtoMessage()    {}
func (*RemoteProducerMetadata_RangeInfos) Descriptor() ([]byte, []int) {
	return fileDescriptorData, []int{10, 0}
}

func init() {
	proto.RegisterType((*Error)(nil), "cockroach.sql.distsqlrun.Error")
	proto.RegisterType((*Expression)(nil), "cockroach.sql.distsqlrun.Expression")
	proto.RegisterType((*Ordering)(nil), "cockroach.sql.distsqlrun.Ordering")
	proto.RegisterType((*Ordering_Column)(nil), "cockroach.sql.distsqlrun.Ordering.Column")
	proto.RegisterType((*StreamEndpointSpec)(nil), "cockroach.sql.distsqlrun.StreamEndpointSpec")
	proto.RegisterType((*InputSyncSpec)(nil), "cockroach.sql.distsqlrun.InputSyncSpec")
	proto.RegisterType((*OutputRouterSpec)(nil), "cockroach.sql.distsqlrun.OutputRouterSpec")
	proto.RegisterType((*DatumInfo)(nil), "cockroach.sql.distsqlrun.DatumInfo")
	proto.RegisterType((*ProducerHeader)(nil), "cockroach.sql.distsqlrun.ProducerHeader")
	proto.RegisterType((*ProducerData)(nil), "cockroach.sql.distsqlrun.ProducerData")
	proto.RegisterType((*ProducerMessage)(nil), "cockroach.sql.distsqlrun.ProducerMessage")
	proto.RegisterType((*RemoteProducerMetadata)(nil), "cockroach.sql.distsqlrun.RemoteProducerMetadata")
	proto.RegisterType((*RemoteProducerMetadata_RangeInfos)(nil), "cockroach.sql.distsqlrun.RemoteProducerMetadata.RangeInfos")
	proto.RegisterEnum("cockroach.sql.distsqlrun.Ordering_Column_Direction", Ordering_Column_Direction_name, Ordering_Column_Direction_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.StreamEndpointSpec_Type", StreamEndpointSpec_Type_name, StreamEndpointSpec_Type_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.InputSyncSpec_Type", InputSyncSpec_Type_name, InputSyncSpec_Type_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.OutputRouterSpec_Type", OutputRouterSpec_Type_name, OutputRouterSpec_Type_value)
}
func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Detail != nil {
		nn1, err := m.Detail.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *Error_PGError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.PGError != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.PGError.Size()))
		n2, err := m.PGError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Error_RetryableTxnError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RetryableTxnError != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.RetryableTxnError.Size()))
		n3, err := m.RetryableTxnError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Expression) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Expression) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
	i += copy(dAtA[i:], m.Version)
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(len(m.Expr)))
	i += copy(dAtA[i:], m.Expr)
	return i, nil
}

func (m *Ordering) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Ordering) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0xa
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Ordering_Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Ordering_Column) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.ColIdx))
	dAtA[i] = 0x10
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Direction))
	return i, nil
}

func (m *StreamEndpointSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamEndpointSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x10
	i++
	i = encodeVarintData(dAtA, i, uint64(m.StreamID))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintData(dAtA, i, uint64(len(m.TargetAddr)))
	i += copy(dAtA[i:], m.TargetAddr)
	return i, nil
}

func (m *InputSyncSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InputSyncSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Ordering.Size()))
	n4, err := m.Ordering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.Streams) > 0 {
		for _, msg := range m.Streams {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ColumnTypes) > 0 {
		for _, msg := range m.ColumnTypes {
			dAtA[i] = 0x22
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *OutputRouterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutputRouterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Type))
	if len(m.Streams) > 0 {
		for _, msg := range m.Streams {
			dAtA[i] = 0x12
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HashColumns) > 0 {
		for _, num := range m.HashColumns {
			dAtA[i] = 0x18
			i++
			i = encodeVarintData(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *DatumInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatumInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Encoding))
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Type.Size()))
	n5, err := m.Type.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *ProducerHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProducerHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.FlowID.Size()))
	n6, err := m.FlowID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x10
	i++
	i = encodeVarintData(dAtA, i, uint64(m.StreamID))
	return i, nil
}

func (m *ProducerData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProducerData) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RawBytes != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	if len(m.Metadata) > 0 {
		for _, msg := range m.Metadata {
			dAtA[i] = 0x12
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintData(dAtA, i, uint64(m.NumEmptyRows))
	return i, nil
}

func (m *ProducerMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProducerMessage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Header.Size()))
		n7, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.Typing) > 0 {
		for _, msg := range m.Typing {
			dAtA[i] = 0x12
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Data.Size()))
	n8, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *RemoteProducerMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteProducerMetadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn9, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn9
	}
	return i, nil
}

func (m *RemoteProducerMetadata_RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeInfo != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.RangeInfo.Size()))
		n10, err := m.RangeInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *RemoteProducerMetadata_Error) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Error != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Error.Size()))
		n11, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *RemoteProducerMetadata_RangeInfos) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteProducerMetadata_RangeInfos) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RangeInfo) > 0 {
		for _, msg := range m.RangeInfo {
			dAtA[i] = 0xa
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Data(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Data(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Error) Size() (n int) {
	var l int
	_ = l
	if m.Detail != nil {
		n += m.Detail.Size()
	}
	return n
}

func (m *Error_PGError) Size() (n int) {
	var l int
	_ = l
	if m.PGError != nil {
		l = m.PGError.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}
func (m *Error_RetryableTxnError) Size() (n int) {
	var l int
	_ = l
	if m.RetryableTxnError != nil {
		l = m.RetryableTxnError.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}
func (m *Expression) Size() (n int) {
	var l int
	_ = l
	l = len(m.Version)
	n += 1 + l + sovData(uint64(l))
	l = len(m.Expr)
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *Ordering) Size() (n int) {
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func (m *Ordering_Column) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.ColIdx))
	n += 1 + sovData(uint64(m.Direction))
	return n
}

func (m *StreamEndpointSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.Type))
	n += 1 + sovData(uint64(m.StreamID))
	l = len(m.TargetAddr)
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *InputSyncSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.Type))
	l = m.Ordering.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.Streams) > 0 {
		for _, e := range m.Streams {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.ColumnTypes) > 0 {
		for _, e := range m.ColumnTypes {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func (m *OutputRouterSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.Type))
	if len(m.Streams) > 0 {
		for _, e := range m.Streams {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.HashColumns) > 0 {
		for _, e := range m.HashColumns {
			n += 1 + sovData(uint64(e))
		}
	}
	return n
}

func (m *DatumInfo) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovData(uint64(m.Encoding))
	l = m.Type.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *ProducerHeader) Size() (n int) {
	var l int
	_ = l
	l = m.FlowID.Size()
	n += 1 + l + sovData(uint64(l))
	n += 1 + sovData(uint64(m.StreamID))
	return n
}

func (m *ProducerData) Size() (n int) {
	var l int
	_ = l
	if m.RawBytes != nil {
		l = len(m.RawBytes)
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.Metadata) > 0 {
		for _, e := range m.Metadata {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	n += 1 + sovData(uint64(m.NumEmptyRows))
	return n
}

func (m *ProducerMessage) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.Typing) > 0 {
		for _, e := range m.Typing {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	l = m.Data.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *RemoteProducerMetadata) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *RemoteProducerMetadata_RangeInfo) Size() (n int) {
	var l int
	_ = l
	if m.RangeInfo != nil {
		l = m.RangeInfo.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}
func (m *RemoteProducerMetadata_Error) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}
func (m *RemoteProducerMetadata_RangeInfos) Size() (n int) {
	var l int
	_ = l
	if len(m.RangeInfo) > 0 {
		for _, e := range m.RangeInfo {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func sovData(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PGError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &cockroach_pgerror.Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_PGError{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryableTxnError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &cockroach_roachpb2.UnhandledRetryableError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_RetryableTxnError{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Expression) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Expression: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Expression: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ordering) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ordering: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ordering: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, Ordering_Column{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ordering_Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColIdx", wireType)
			}
			m.ColIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			m.Direction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Direction |= (Ordering_Column_Direction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamEndpointSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamEndpointSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamEndpointSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (StreamEndpointSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamID", wireType)
			}
			m.StreamID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StreamID |= (StreamID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InputSyncSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InputSyncSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InputSyncSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (InputSyncSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ordering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Ordering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Streams = append(m.Streams, StreamEndpointSpec{})
			if err := m.Streams[len(m.Streams)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnTypes = append(m.ColumnTypes, cockroach_sql_sqlbase1.ColumnType{})
			if err := m.ColumnTypes[len(m.ColumnTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutputRouterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutputRouterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutputRouterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (OutputRouterSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Streams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Streams = append(m.Streams, StreamEndpointSpec{})
			if err := m.Streams[len(m.Streams)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.HashColumns = append(m.HashColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthData
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowData
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.HashColumns = append(m.HashColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field HashColumns", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatumInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatumInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatumInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Encoding", wireType)
			}
			m.Encoding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Encoding |= (cockroach_sql_sqlbase2.DatumEncoding(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProducerHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProducerHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProducerHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlowID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FlowID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamID", wireType)
			}
			m.StreamID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StreamID |= (StreamID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProducerData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProducerData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProducerData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata, RemoteProducerMetadata{})
			if err := m.Metadata[len(m.Metadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumEmptyRows", wireType)
			}
			m.NumEmptyRows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumEmptyRows |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProducerMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProducerMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProducerMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &ProducerHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Typing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Typing = append(m.Typing, DatumInfo{})
			if err := m.Typing[len(m.Typing)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteProducerMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteProducerMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteProducerMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RemoteProducerMetadata_RangeInfos{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RemoteProducerMetadata_RangeInfo{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &RemoteProducerMetadata_Error{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteProducerMetadata_RangeInfos) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfos: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfos: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RangeInfo = append(m.RangeInfo, cockroach_roachpb3.RangeInfo{})
			if err := m.RangeInfo[len(m.RangeInfo)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/sql/distsqlrun/data.proto", fileDescriptorData) }

var fileDescriptorData = []byte{
	// 1145 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x4f, 0x6f, 0x1b, 0xc5,
	0x1b, 0xf6, 0xfa, 0xbf, 0x5f, 0x3b, 0xf9, 0xb9, 0xa3, 0x9f, 0x90, 0x15, 0x8a, 0xdd, 0x2e, 0x05,
	0x4a, 0x55, 0xd6, 0x6d, 0x38, 0x20, 0xe8, 0x81, 0xda, 0xf1, 0xa6, 0x36, 0x34, 0x71, 0xb4, 0x4e,
	0x84, 0x52, 0x21, 0xad, 0x36, 0xbb, 0x13, 0xc7, 0xea, 0x7a, 0x77, 0x33, 0x33, 0x5b, 0xc7, 0x17,
	0xee, 0x9c, 0xe8, 0x91, 0x63, 0xef, 0x7c, 0x00, 0xbe, 0x42, 0x8e, 0x1c, 0x2b, 0x90, 0x22, 0x30,
	0x9f, 0x01, 0x09, 0x71, 0x42, 0x33, 0x3b, 0xeb, 0x3f, 0x71, 0x4c, 0x5b, 0xf5, 0x36, 0x3b, 0xf3,
	0x3c, 0xcf, 0x3e, 0xef, 0x33, 0xef, 0xce, 0x2c, 0x7c, 0x64, 0xfb, 0xf6, 0x53, 0xe2, 0x5b, 0xf6,
	0x49, 0x3d, 0x78, 0xda, 0xaf, 0xd3, 0x53, 0xb7, 0xee, 0x0c, 0x28, 0xa3, 0xa7, 0x2e, 0x09, 0xbd,
	0xba, 0x63, 0x31, 0x4b, 0x0b, 0x88, 0xcf, 0x7c, 0x54, 0x99, 0x02, 0x35, 0x7a, 0xea, 0x6a, 0x33,
	0xd0, 0x46, 0x6d, 0x51, 0x42, 0x8c, 0x82, 0xa3, 0xba, 0x15, 0x0c, 0x22, 0xea, 0xc6, 0x8d, 0xab,
	0x01, 0x33, 0xf1, 0x0d, 0xf5, 0x6a, 0x04, 0x26, 0xc4, 0x27, 0x54, 0x62, 0x3e, 0x59, 0x76, 0x1a,
	0xf4, 0x47, 0x03, 0x82, 0xeb, 0x41, 0x5f, 0x00, 0x17, 0xe1, 0x77, 0x96, 0xe1, 0xf4, 0xd4, 0x3d,
	0xb2, 0x28, 0xae, 0x53, 0x46, 0x42, 0x9b, 0x85, 0x04, 0x3b, 0xab, 0xa5, 0x63, 0x2c, 0xf6, 0x6c,
	0xdf, 0xc1, 0x8e, 0xe9, 0x58, 0x2c, 0x1c, 0x4a, 0xf8, 0xff, 0xfb, 0x7e, 0xdf, 0x17, 0xc3, 0x3a,
	0x1f, 0x45, 0xb3, 0xea, 0xcf, 0x0a, 0x64, 0x74, 0xee, 0x00, 0x35, 0x21, 0x1f, 0xf4, 0x4d, 0xe1,
	0xa6, 0xa2, 0xdc, 0x50, 0x6e, 0x17, 0x37, 0x2b, 0xda, 0x2c, 0x3d, 0xe9, 0x56, 0x13, 0xd8, 0x66,
	0x71, 0x72, 0x51, 0xcb, 0xed, 0x3d, 0x12, 0x0f, 0xed, 0x84, 0x91, 0x0b, 0xfa, 0x91, 0xc6, 0x13,
	0xb8, 0x46, 0x30, 0x23, 0x63, 0xeb, 0xc8, 0xc5, 0xfb, 0x67, 0x9e, 0x98, 0xac, 0x24, 0x85, 0xd8,
	0x9d, 0x39, 0x31, 0x99, 0x94, 0x76, 0xe0, 0x9d, 0x58, 0x9e, 0xe3, 0x62, 0xc7, 0x88, 0x49, 0xb1,
	0xe2, 0xb2, 0xcc, 0x17, 0xe9, 0x1f, 0x5f, 0xd4, 0x12, 0xcd, 0x3c, 0x64, 0x1d, 0xcc, 0xac, 0x81,
	0xab, 0x6e, 0x03, 0xe8, 0x67, 0x01, 0xc1, 0x94, 0x0e, 0x7c, 0x0f, 0x55, 0x21, 0xf7, 0x0c, 0x13,
	0x3e, 0x14, 0xe6, 0x0b, 0xcd, 0xf4, 0xf9, 0x45, 0x2d, 0x61, 0xc4, 0x93, 0xa8, 0x02, 0x69, 0x7c,
	0x16, 0x44, 0x66, 0xe2, 0x45, 0x31, 0xa3, 0xfe, 0xad, 0x40, 0xbe, 0x4b, 0x1c, 0x4c, 0x06, 0x5e,
	0x1f, 0x75, 0x20, 0x67, 0xfb, 0x6e, 0x38, 0xf4, 0x68, 0x45, 0xb9, 0x91, 0xba, 0x5d, 0xdc, 0xfc,
	0x58, 0x5b, 0xd5, 0x41, 0x5a, 0x4c, 0xd2, 0xb6, 0x04, 0x23, 0x7e, 0xa3, 0xe4, 0x6f, 0xbc, 0x50,
	0x20, 0x1b, 0xad, 0xa0, 0xf7, 0x84, 0xaa, 0x39, 0x70, 0xce, 0x84, 0xb9, 0x35, 0x09, 0xcd, 0xda,
	0xbe, 0xdb, 0x71, 0xce, 0xd0, 0x37, 0x50, 0x70, 0x06, 0x04, 0xdb, 0x8c, 0xbb, 0xe7, 0x06, 0xd7,
	0x37, 0x3f, 0x7d, 0xed, 0xd7, 0x6a, 0xad, 0x98, 0x2a, 0x55, 0x67, 0x5a, 0x6a, 0x15, 0x0a, 0xd3,
	0x55, 0x94, 0x83, 0x54, 0xa3, 0xb7, 0x55, 0x4e, 0xa0, 0x3c, 0xa4, 0x5b, 0x7a, 0x6f, 0xab, 0xac,
	0xa8, 0x7f, 0x29, 0x80, 0x7a, 0x8c, 0x60, 0x6b, 0xa8, 0x7b, 0x4e, 0xe0, 0x0f, 0x3c, 0xd6, 0x0b,
	0xb0, 0x8d, 0xbe, 0x86, 0x34, 0x1b, 0x07, 0x58, 0x78, 0x5d, 0xdf, 0xbc, 0xbf, 0xda, 0xca, 0x32,
	0x57, 0xdb, 0x1f, 0x07, 0x38, 0x8e, 0x97, 0x8b, 0xa0, 0xcf, 0xa1, 0x40, 0x05, 0xcc, 0x1c, 0x38,
	0xa2, 0xb8, 0x4c, 0xf3, 0x3a, 0x5f, 0x9e, 0x5c, 0xd4, 0xf2, 0x11, 0xbf, 0xd3, 0xfa, 0x67, 0x6e,
	0x6c, 0xe4, 0x23, 0x78, 0xc7, 0x41, 0x1f, 0x40, 0x91, 0x59, 0xa4, 0x8f, 0x99, 0x69, 0x39, 0x0e,
	0xa9, 0xa4, 0xe6, 0xb6, 0x0e, 0xa2, 0x85, 0x86, 0xe3, 0x10, 0xf5, 0x1e, 0xa4, 0xf9, 0x5b, 0x51,
	0x01, 0x32, 0x8f, 0xbb, 0x5b, 0x8d, 0xc7, 0xe5, 0x04, 0x02, 0xc8, 0x1a, 0xfa, 0x4e, 0x77, 0x5f,
	0x2f, 0x2b, 0xe8, 0x1a, 0xac, 0xf5, 0x0e, 0x77, 0xb7, 0x4c, 0x43, 0xef, 0xed, 0x75, 0x77, 0x7b,
	0x7a, 0x39, 0xa9, 0xfe, 0x96, 0x84, 0xb5, 0x8e, 0x17, 0x84, 0xac, 0x37, 0xf6, 0x6c, 0x51, 0xf2,
	0xf6, 0x42, 0xc9, 0x77, 0x57, 0x97, 0xbc, 0x40, 0x5b, 0xae, 0xb6, 0x05, 0x79, 0x5f, 0xee, 0x8f,
	0xec, 0x7b, 0xf5, 0xd5, 0x3b, 0x29, 0x15, 0xa6, 0x4c, 0xf4, 0x18, 0x72, 0x51, 0x08, 0xb4, 0x92,
	0x12, 0x5d, 0x78, 0xf7, 0x4d, 0xf6, 0x20, 0x6e, 0x44, 0x29, 0x81, 0xbe, 0x82, 0x52, 0xd4, 0x93,
	0x26, 0xb7, 0x48, 0x2b, 0x69, 0x21, 0x79, 0xf3, 0x92, 0xa4, 0x3c, 0x3a, 0x64, 0x57, 0xcd, 0x15,
	0x56, 0xb4, 0xa7, 0x33, 0x54, 0x55, 0x65, 0xd6, 0x6b, 0x50, 0x38, 0xd8, 0xed, 0x1a, 0x2d, 0xdd,
	0xd0, 0x5b, 0xe5, 0x04, 0x2a, 0x42, 0x2e, 0x7e, 0x50, 0xd4, 0x1f, 0x92, 0x50, 0xee, 0x86, 0x2c,
	0x08, 0x99, 0xe1, 0x87, 0x0c, 0x13, 0x11, 0x70, 0x67, 0x21, 0xe0, 0xfa, 0x7f, 0x84, 0x72, 0x89,
	0xb9, 0x9c, 0xf1, 0x5c, 0x3a, 0xc9, 0xb7, 0x4f, 0xe7, 0x26, 0x94, 0x4e, 0x2c, 0x7a, 0x62, 0xc6,
	0x9f, 0x3d, 0x0f, 0x7c, 0xcd, 0x28, 0xf2, 0xb9, 0x28, 0x0a, 0xaa, 0x7e, 0x29, 0x8b, 0x2e, 0x43,
	0x69, 0xaf, 0xd1, 0xeb, 0x99, 0xfb, 0x6d, 0xa3, 0x7b, 0xf0, 0xa8, 0x1d, 0xf5, 0xd9, 0x4e, 0xc7,
	0x30, 0xba, 0x46, 0x59, 0xe1, 0x19, 0x34, 0x0f, 0xcd, 0x76, 0xa3, 0xd7, 0x2e, 0x27, 0x51, 0x09,
	0xf2, 0xcd, 0x43, 0xd3, 0x68, 0xec, 0x3e, 0xd2, 0xcb, 0x29, 0xf5, 0xb9, 0x02, 0x85, 0x16, 0x3f,
	0x8a, 0x3b, 0xde, 0xb1, 0x8f, 0xb6, 0x21, 0x2f, 0xce, 0x67, 0xde, 0x23, 0x51, 0x1c, 0xb7, 0x56,
	0xec, 0x85, 0xe0, 0xe8, 0x12, 0x1b, 0x77, 0x49, 0xcc, 0x45, 0x0f, 0x64, 0xa4, 0x51, 0x9f, 0xbd,
	0xf6, 0x7e, 0x0a, 0x92, 0xfa, 0x1d, 0xac, 0xef, 0x11, 0xdf, 0x09, 0x6d, 0x4c, 0xda, 0xd8, 0x72,
	0x30, 0x41, 0xf7, 0x21, 0x77, 0xec, 0xfa, 0x23, 0xfe, 0x99, 0x72, 0x57, 0xa5, 0x66, 0x85, 0xc3,
	0x7f, 0xbd, 0xa8, 0x65, 0xb7, 0x5d, 0x7f, 0xd4, 0x69, 0x4d, 0xa6, 0x23, 0x23, 0xcb, 0x81, 0x1d,
	0xe7, 0x2d, 0xbe, 0x6d, 0xf5, 0x27, 0x05, 0x4a, 0xb1, 0x81, 0x96, 0xc5, 0x2c, 0xf4, 0x2e, 0x14,
	0x88, 0x35, 0x32, 0x8f, 0xc6, 0x0c, 0xd3, 0xc8, 0x80, 0x91, 0x27, 0xd6, 0xa8, 0xc9, 0x9f, 0x91,
	0x01, 0xf9, 0x21, 0x66, 0x16, 0xbf, 0x7b, 0xe5, 0x9e, 0xdf, 0x5b, 0xbd, 0xe7, 0x06, 0x1e, 0xfa,
	0x0c, 0xc7, 0xe2, 0x3b, 0x92, 0x17, 0xc7, 0x17, 0xeb, 0xa0, 0x3b, 0xb0, 0xee, 0x85, 0x43, 0x13,
	0x0f, 0x03, 0x36, 0x36, 0x89, 0x3f, 0xa2, 0xe2, 0x80, 0xc9, 0x48, 0x5c, 0xc9, 0x0b, 0x87, 0x3a,
	0x5f, 0x32, 0xfc, 0x11, 0x55, 0x5f, 0x2a, 0xf0, 0xbf, 0x99, 0x20, 0xa5, 0x56, 0x1f, 0xa3, 0x87,
	0x90, 0x3d, 0x11, 0xc9, 0xc9, 0xdb, 0xf2, 0xf6, 0x6a, 0x47, 0x8b, 0x49, 0x1b, 0x92, 0x87, 0x1a,
	0x90, 0x65, 0xe3, 0x20, 0x3a, 0x2a, 0x78, 0x4d, 0xef, 0xaf, 0x56, 0x98, 0x76, 0x4f, 0x7c, 0x75,
	0x44, 0x44, 0xf4, 0x10, 0xd2, 0x22, 0x94, 0x94, 0xb0, 0xf0, 0xe1, 0xab, 0x2d, 0xb4, 0x66, 0x51,
	0x08, 0xa6, 0xfa, 0x7d, 0x12, 0xde, 0xb9, 0x3a, 0x31, 0xf4, 0x2d, 0x00, 0xb1, 0xbc, 0x3e, 0x36,
	0x07, 0xde, 0xb1, 0x2f, 0xab, 0x7c, 0xf0, 0xa6, 0xb9, 0x6b, 0x06, 0x97, 0xe0, 0xd6, 0x69, 0x3b,
	0x61, 0x14, 0x48, 0xfc, 0x84, 0x3e, 0x83, 0x0c, 0x9e, 0xfb, 0x3f, 0xa8, 0xad, 0x16, 0x8e, 0x7f,
	0x0a, 0x22, 0xfc, 0x46, 0x17, 0x60, 0xa6, 0x89, 0x1a, 0x97, 0x4c, 0xf2, 0x20, 0xaf, 0x5f, 0xf1,
	0xaf, 0x31, 0xa5, 0xc4, 0xd7, 0xe4, 0xd4, 0x49, 0x33, 0x07, 0x99, 0x67, 0x96, 0x1b, 0xe2, 0xe6,
	0xad, 0xf3, 0x3f, 0xaa, 0x89, 0xf3, 0x49, 0x55, 0xf9, 0x65, 0x52, 0x55, 0x5e, 0x4e, 0xaa, 0xca,
	0xef, 0x93, 0xaa, 0xf2, 0xfc, 0xcf, 0x6a, 0xe2, 0x09, 0xcc, 0xec, 0xfc, 0x1b, 0x00, 0x00, 0xff,
	0xff, 0x07, 0x51, 0xff, 0x3e, 0x7d, 0x0a, 0x00, 0x00,
}
