// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/server/serverpb/admin.proto
// DO NOT EDIT!

/*
	Package serverpb is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/server/serverpb/admin.proto
		cockroach/pkg/server/serverpb/status.proto

	It has these top-level messages:
		DatabasesRequest
		DatabasesResponse
		DatabaseDetailsRequest
		DatabaseDetailsResponse
		TableDetailsRequest
		TableDetailsResponse
		TableStatsRequest
		TableStatsResponse
		UsersRequest
		UsersResponse
		EventsRequest
		EventsResponse
		SetUIDataRequest
		SetUIDataResponse
		GetUIDataRequest
		GetUIDataResponse
		ClusterRequest
		ClusterResponse
		DrainRequest
		DrainResponse
		SettingsRequest
		SettingsResponse
		HealthRequest
		HealthResponse
		LivenessRequest
		LivenessResponse
		RangeLogRequest
		RangeLogResponse
		QueryPlanRequest
		QueryPlanResponse
		CertificatesRequest
		CertificateDetails
		CertificatesResponse
		DetailsRequest
		DetailsResponse
		NodesRequest
		NodesResponse
		NodeRequest
		RaftState
		RangeProblems
		RangeInfo
		RangesRequest
		RangesResponse
		GossipRequest
		JSONResponse
		LogsRequest
		LogEntriesResponse
		LogFilesListRequest
		LogFilesListResponse
		LogFileRequest
		StacksRequest
		MetricsRequest
		RaftRangeNode
		RaftRangeError
		RaftRangeStatus
		RaftDebugRequest
		RaftDebugResponse
		ActiveQuery
		ListSessionsRequest
		Session
		ListSessionsError
		ListSessionsResponse
		SpanStatsRequest
		SpanStatsResponse
		PrettySpan
*/
package serverpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_config "github.com/cockroachdb/cockroach/pkg/config"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage "github.com/cockroachdb/cockroach/pkg/storage"
import cockroach_storage1 "github.com/cockroachdb/cockroach/pkg/storage"

import time "time"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ZoneConfigurationLevel indicates, for objects with a Zone Configuration,
// the object level at which the configuration is defined. This is needed
// because objects without a specifically indicated Zone Configuration will
// inherit the configuration of their "parent".
type ZoneConfigurationLevel int32

const (
	ZoneConfigurationLevel_UNKNOWN ZoneConfigurationLevel = 0
	// CLUSTER indicates that this object uses the cluster default Zone Configuration.
	ZoneConfigurationLevel_CLUSTER ZoneConfigurationLevel = 1
	// DATABASE indicates that this object uses a database-level Zone Configuration.
	ZoneConfigurationLevel_DATABASE ZoneConfigurationLevel = 2
	// TABLE indicates that this object uses a table-level Zone Configuration.
	ZoneConfigurationLevel_TABLE ZoneConfigurationLevel = 3
)

var ZoneConfigurationLevel_name = map[int32]string{
	0: "UNKNOWN",
	1: "CLUSTER",
	2: "DATABASE",
	3: "TABLE",
}
var ZoneConfigurationLevel_value = map[string]int32{
	"UNKNOWN":  0,
	"CLUSTER":  1,
	"DATABASE": 2,
	"TABLE":    3,
}

func (x ZoneConfigurationLevel) String() string {
	return proto.EnumName(ZoneConfigurationLevel_name, int32(x))
}
func (ZoneConfigurationLevel) EnumDescriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{0} }

type DrainMode int32

const (
	// CLIENT instructs the server to refuse new SQL clients.
	// TODO(tschottdorf): also terminate existing clients in a graceful manner.
	DrainMode_CLIENT DrainMode = 0
	// LEADERSHIP instructs the server to gracefully let all its Replicas'
	// range leases expire.
	DrainMode_LEASES DrainMode = 1
)

var DrainMode_name = map[int32]string{
	0: "CLIENT",
	1: "LEASES",
}
var DrainMode_value = map[string]int32{
	"CLIENT": 0,
	"LEASES": 1,
}

func (x DrainMode) String() string {
	return proto.EnumName(DrainMode_name, int32(x))
}
func (DrainMode) EnumDescriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{1} }

// DatabasesRequest requests a list of databases.
type DatabasesRequest struct {
}

func (m *DatabasesRequest) Reset()                    { *m = DatabasesRequest{} }
func (m *DatabasesRequest) String() string            { return proto.CompactTextString(m) }
func (*DatabasesRequest) ProtoMessage()               {}
func (*DatabasesRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{0} }

// DatabasesResponse contains a list of databases.
type DatabasesResponse struct {
	Databases []string `protobuf:"bytes,1,rep,name=databases" json:"databases,omitempty"`
}

func (m *DatabasesResponse) Reset()                    { *m = DatabasesResponse{} }
func (m *DatabasesResponse) String() string            { return proto.CompactTextString(m) }
func (*DatabasesResponse) ProtoMessage()               {}
func (*DatabasesResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{1} }

// DatabaseDetailsRequest requests detailed information about the specified
// database
type DatabaseDetailsRequest struct {
	// database is the name of the database we are querying.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
}

func (m *DatabaseDetailsRequest) Reset()                    { *m = DatabaseDetailsRequest{} }
func (m *DatabaseDetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*DatabaseDetailsRequest) ProtoMessage()               {}
func (*DatabaseDetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{2} }

// DatabaseDetailsResponse contains grant information and table names for a
// database.
type DatabaseDetailsResponse struct {
	// grants are the results of SHOW GRANTS for this database.
	Grants []DatabaseDetailsResponse_Grant `protobuf:"bytes,1,rep,name=grants" json:"grants"`
	// table_names contains the names of all tables (SHOW TABLES) in this
	// database.
	TableNames []string `protobuf:"bytes,2,rep,name=table_names,json=tableNames" json:"table_names,omitempty"`
	// descriptor_id is an identifier used to uniquely identify this database.
	// It can be used to find events pertaining to this database by filtering on
	// the 'target_id' field of events.
	DescriptorID int64 `protobuf:"varint,3,opt,name=descriptor_id,json=descriptorId,proto3" json:"descriptor_id,omitempty"`
	// The zone configuration in effect for this database.
	ZoneConfig cockroach_config.ZoneConfig `protobuf:"bytes,4,opt,name=zone_config,json=zoneConfig" json:"zone_config"`
	// The level at which this object's zone configuration is set.
	ZoneConfigLevel ZoneConfigurationLevel `protobuf:"varint,5,opt,name=zone_config_level,json=zoneConfigLevel,proto3,enum=cockroach.server.serverpb.ZoneConfigurationLevel" json:"zone_config_level,omitempty"`
}

func (m *DatabaseDetailsResponse) Reset()                    { *m = DatabaseDetailsResponse{} }
func (m *DatabaseDetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*DatabaseDetailsResponse) ProtoMessage()               {}
func (*DatabaseDetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{3} }

type DatabaseDetailsResponse_Grant struct {
	// user is the user that this grant applies to.
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// privileges are the abilities this grant gives to the user.
	Privileges []string `protobuf:"bytes,2,rep,name=privileges" json:"privileges,omitempty"`
}

func (m *DatabaseDetailsResponse_Grant) Reset()         { *m = DatabaseDetailsResponse_Grant{} }
func (m *DatabaseDetailsResponse_Grant) String() string { return proto.CompactTextString(m) }
func (*DatabaseDetailsResponse_Grant) ProtoMessage()    {}
func (*DatabaseDetailsResponse_Grant) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{3, 0}
}

// TableDetailsRequest is a request for detailed information about a table.
type TableDetailsRequest struct {
	// database is the database that contains the table we're interested in.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// table is the name of the table that we're querying.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (m *TableDetailsRequest) Reset()                    { *m = TableDetailsRequest{} }
func (m *TableDetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*TableDetailsRequest) ProtoMessage()               {}
func (*TableDetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{4} }

// TableDetailsResponse contains grants, column names, and indexes for
// a table.
type TableDetailsResponse struct {
	Grants  []TableDetailsResponse_Grant  `protobuf:"bytes,1,rep,name=grants" json:"grants"`
	Columns []TableDetailsResponse_Column `protobuf:"bytes,2,rep,name=columns" json:"columns"`
	Indexes []TableDetailsResponse_Index  `protobuf:"bytes,3,rep,name=indexes" json:"indexes"`
	// range_count is the size of the table in ranges. This provides a rough
	// estimate of the storage requirements for the table.
	// TODO(mrtracy): The TableStats method also returns a range_count field which
	// is more accurate than this one; TableDetails calculates this number using
	// a potentially faster method that is subject to cache staleness. We should
	// consider removing or renaming this field to reflect that difference. See
	// Github issue #5435 for more information.
	RangeCount int64 `protobuf:"varint,4,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	// create_table_statement is the output of "SHOW CREATE TABLE" for this table;
	// it is a SQL statement that would re-create the table's current schema if
	// executed.
	CreateTableStatement string `protobuf:"bytes,5,opt,name=create_table_statement,json=createTableStatement,proto3" json:"create_table_statement,omitempty"`
	// The zone configuration in effect for this table.
	ZoneConfig cockroach_config.ZoneConfig `protobuf:"bytes,6,opt,name=zone_config,json=zoneConfig" json:"zone_config"`
	// The level at which this object's zone configuration is set.
	ZoneConfigLevel ZoneConfigurationLevel `protobuf:"varint,7,opt,name=zone_config_level,json=zoneConfigLevel,proto3,enum=cockroach.server.serverpb.ZoneConfigurationLevel" json:"zone_config_level,omitempty"`
	// descriptor_id is an identifier used to uniquely identify this table.
	// It can be used to find events pertaining to this table by filtering on
	// the 'target_id' field of events.
	DescriptorID int64 `protobuf:"varint,8,opt,name=descriptor_id,json=descriptorId,proto3" json:"descriptor_id,omitempty"`
}

func (m *TableDetailsResponse) Reset()                    { *m = TableDetailsResponse{} }
func (m *TableDetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*TableDetailsResponse) ProtoMessage()               {}
func (*TableDetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{5} }

// Grant is an entry from SHOW GRANTS.
type TableDetailsResponse_Grant struct {
	// user is the user that this grant applies to.
	User string `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// privileges are the abilities this grant gives to the user.
	Privileges []string `protobuf:"bytes,2,rep,name=privileges" json:"privileges,omitempty"`
}

func (m *TableDetailsResponse_Grant) Reset()         { *m = TableDetailsResponse_Grant{} }
func (m *TableDetailsResponse_Grant) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Grant) ProtoMessage()    {}
func (*TableDetailsResponse_Grant) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 0}
}

type TableDetailsResponse_Column struct {
	// name is the name of the column.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the SQL type (INT, STRING, etc.) of this column.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// nullable is whether this column can contain NULL.
	Nullable bool `protobuf:"varint,3,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// default_value is the default value of this column.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (m *TableDetailsResponse_Column) Reset()         { *m = TableDetailsResponse_Column{} }
func (m *TableDetailsResponse_Column) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Column) ProtoMessage()    {}
func (*TableDetailsResponse_Column) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 1}
}

type TableDetailsResponse_Index struct {
	// name is the name of this index.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// unique is whether this a unique index (i.e. CREATE UNIQUE INDEX).
	Unique bool `protobuf:"varint,2,opt,name=unique,proto3" json:"unique,omitempty"`
	// seq is an internal variable that's passed along.
	Seq int64 `protobuf:"varint,3,opt,name=seq,proto3" json:"seq,omitempty"`
	// column is the column that this index indexes.
	Column string `protobuf:"bytes,4,opt,name=column,proto3" json:"column,omitempty"`
	// direction is either "ASC" (ascending) or "DESC" (descending).
	Direction string `protobuf:"bytes,5,opt,name=direction,proto3" json:"direction,omitempty"`
	// storing is an internal variable that's passed along.
	Storing bool `protobuf:"varint,6,opt,name=storing,proto3" json:"storing,omitempty"`
	// implicit is an internal variable that's passed along.
	Implicit bool `protobuf:"varint,7,opt,name=implicit,proto3" json:"implicit,omitempty"`
}

func (m *TableDetailsResponse_Index) Reset()         { *m = TableDetailsResponse_Index{} }
func (m *TableDetailsResponse_Index) String() string { return proto.CompactTextString(m) }
func (*TableDetailsResponse_Index) ProtoMessage()    {}
func (*TableDetailsResponse_Index) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{5, 2}
}

// TableStatsRequest is a request for detailed, computationally expensive
// information about a table.
type TableStatsRequest struct {
	// database is the database that contains the table we're interested in.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// table is the name of the table that we're querying.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
}

func (m *TableStatsRequest) Reset()                    { *m = TableStatsRequest{} }
func (m *TableStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*TableStatsRequest) ProtoMessage()               {}
func (*TableStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{6} }

// TableStatsResponse contains detailed, computationally expensive information
// about a table.
type TableStatsResponse struct {
	// range_count is the number of ranges, as determined from a query of range
	// meta keys.
	RangeCount int64 `protobuf:"varint,1,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	// replica_count is the number of replicas of any range of this table, as
	// found by querying nodes which are known to have replicas. When compared
	// with range_count, this can be used to estimate the current replication
	// factor of the table.
	ReplicaCount int64 `protobuf:"varint,2,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// node_count is the number of nodes which contain data for this table,
	// according to a query of range meta keys.
	NodeCount int64 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// stats is the summation of MVCCStats for all replicas of this table
	// across the cluster.
	Stats cockroach_storage_engine_enginepb.MVCCStats `protobuf:"bytes,4,opt,name=stats" json:"stats"`
	// A list of nodes which should contain data for this table (according to
	// cluster metadata), but could not be contacted during this request.
	MissingNodes []TableStatsResponse_MissingNode `protobuf:"bytes,5,rep,name=missing_nodes,json=missingNodes" json:"missing_nodes"`
}

func (m *TableStatsResponse) Reset()                    { *m = TableStatsResponse{} }
func (m *TableStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*TableStatsResponse) ProtoMessage()               {}
func (*TableStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{7} }

// MissingNode represents information on a node which should contain data
// for this table, but could not be contacted during this request.
type TableStatsResponse_MissingNode struct {
	// The ID of the missing node.
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// The error message that resulted when the query sent to this node failed.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (m *TableStatsResponse_MissingNode) Reset()         { *m = TableStatsResponse_MissingNode{} }
func (m *TableStatsResponse_MissingNode) String() string { return proto.CompactTextString(m) }
func (*TableStatsResponse_MissingNode) ProtoMessage()    {}
func (*TableStatsResponse_MissingNode) Descriptor() ([]byte, []int) {
	return fileDescriptorAdmin, []int{7, 0}
}

// UsersRequest requests a list of users.
type UsersRequest struct {
}

func (m *UsersRequest) Reset()                    { *m = UsersRequest{} }
func (m *UsersRequest) String() string            { return proto.CompactTextString(m) }
func (*UsersRequest) ProtoMessage()               {}
func (*UsersRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{8} }

// UsersResponse returns a list of users.
type UsersResponse struct {
	// usernames is a list of users for the CockroachDB cluster.
	Users []UsersResponse_User `protobuf:"bytes,1,rep,name=users" json:"users"`
}

func (m *UsersResponse) Reset()                    { *m = UsersResponse{} }
func (m *UsersResponse) String() string            { return proto.CompactTextString(m) }
func (*UsersResponse) ProtoMessage()               {}
func (*UsersResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{9} }

// User is a CockroachDB user.
type UsersResponse_User struct {
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *UsersResponse_User) Reset()                    { *m = UsersResponse_User{} }
func (m *UsersResponse_User) String() string            { return proto.CompactTextString(m) }
func (*UsersResponse_User) ProtoMessage()               {}
func (*UsersResponse_User) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{9, 0} }

// EventsRequest is a request for event log entries, optionally filtered
// by the specified event type and/or target_id.
type EventsRequest struct {
	Type     string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	TargetId int64  `protobuf:"varint,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// limit is the total number of results that are retreived by the query. If
	// this is obmited or set to 0, the default maximum number of results are
	// returned. When set to > 0, at most only that number of results are
	// returned. When set to < 0, an unlimited number of results are returned.
	Limit int32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{10} }

// EventsResponse contains a set of event log entries. This is always limited
// to the latest N entries (N is enforced in the associated endpoint).
type EventsResponse struct {
	Events []EventsResponse_Event `protobuf:"bytes,1,rep,name=events" json:"events"`
}

func (m *EventsResponse) Reset()                    { *m = EventsResponse{} }
func (m *EventsResponse) String() string            { return proto.CompactTextString(m) }
func (*EventsResponse) ProtoMessage()               {}
func (*EventsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{11} }

type EventsResponse_Event struct {
	// timestamp is the time at which the event occurred.
	Timestamp time.Time `protobuf:"bytes,1,opt,name=timestamp,stdtime" json:"timestamp"`
	// event_type is the type of the event (e.g. "create_table", "drop_table".
	EventType string `protobuf:"bytes,2,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// target_id is the target for this event.
	TargetID int64 `protobuf:"varint,3,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// reporting_id is the reporting ID for this event.
	ReportingID int64 `protobuf:"varint,4,opt,name=reporting_id,json=reportingId,proto3" json:"reporting_id,omitempty"`
	// info has more detailed information for the event. The contents vary
	// depending on the event.
	Info string `protobuf:"bytes,5,opt,name=info,proto3" json:"info,omitempty"`
	// unique_id is a unique identifier for this event.
	UniqueID []byte `protobuf:"bytes,6,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
}

func (m *EventsResponse_Event) Reset()                    { *m = EventsResponse_Event{} }
func (m *EventsResponse_Event) String() string            { return proto.CompactTextString(m) }
func (*EventsResponse_Event) ProtoMessage()               {}
func (*EventsResponse_Event) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{11, 0} }

// SetUIDataRequest stores the given key/value pairs in the system.ui table.
type SetUIDataRequest struct {
	// key_values is a map of keys to bytes values. Each key will be stored
	// with its corresponding value as a separate row in system.ui.
	KeyValues map[string][]byte `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *SetUIDataRequest) Reset()                    { *m = SetUIDataRequest{} }
func (m *SetUIDataRequest) String() string            { return proto.CompactTextString(m) }
func (*SetUIDataRequest) ProtoMessage()               {}
func (*SetUIDataRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{12} }

// SetUIDataResponse is currently an empty response.
type SetUIDataResponse struct {
}

func (m *SetUIDataResponse) Reset()                    { *m = SetUIDataResponse{} }
func (m *SetUIDataResponse) String() string            { return proto.CompactTextString(m) }
func (*SetUIDataResponse) ProtoMessage()               {}
func (*SetUIDataResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{13} }

// GETUIDataRequest requests the values for the given keys from the system.ui
// table.
type GetUIDataRequest struct {
	Keys []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *GetUIDataRequest) Reset()                    { *m = GetUIDataRequest{} }
func (m *GetUIDataRequest) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataRequest) ProtoMessage()               {}
func (*GetUIDataRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{14} }

// GetUIDataResponse contains the requested values and the times at which
// the values were last updated.
type GetUIDataResponse struct {
	// key_values maps keys to their retrieved values. If this doesn't contain a
	// a requested key, that key was not found.
	KeyValues map[string]GetUIDataResponse_Value `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetUIDataResponse) Reset()                    { *m = GetUIDataResponse{} }
func (m *GetUIDataResponse) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataResponse) ProtoMessage()               {}
func (*GetUIDataResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{15} }

type GetUIDataResponse_Value struct {
	// value is the value of the requested key.
	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// last_updated is the time at which the value was last updated.
	LastUpdated time.Time `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated,stdtime" json:"last_updated"`
}

func (m *GetUIDataResponse_Value) Reset()                    { *m = GetUIDataResponse_Value{} }
func (m *GetUIDataResponse_Value) String() string            { return proto.CompactTextString(m) }
func (*GetUIDataResponse_Value) ProtoMessage()               {}
func (*GetUIDataResponse_Value) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{15, 0} }

// ClusterRequest requests metadata for the cluster.
type ClusterRequest struct {
}

func (m *ClusterRequest) Reset()                    { *m = ClusterRequest{} }
func (m *ClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*ClusterRequest) ProtoMessage()               {}
func (*ClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{16} }

// ClusterResponse contains metadata for the cluster.
type ClusterResponse struct {
	ClusterID string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
}

func (m *ClusterResponse) Reset()                    { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string            { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()               {}
func (*ClusterResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{17} }

// DrainRequest requests the server to enter the specified draining mode. The
// server first deactivates all the modes specified in 'off' and then activates
// all those in 'on'.
type DrainRequest struct {
	// These are actually of type DrainMode, but grpc-gateway does not support
	// proxying enum fields (yet:
	// https://github.com/grpc-ecosystem/grpc-gateway/issues/5) and it fails in
	// pretty dramatic ways (panics the server).
	On  []int32 `protobuf:"varint,1,rep,packed,name=on" json:"on,omitempty"`
	Off []int32 `protobuf:"varint,2,rep,packed,name=off" json:"off,omitempty"`
	// When true, terminates the process after the given drain modes have been
	// activated.
	Shutdown bool `protobuf:"varint,3,opt,name=shutdown,proto3" json:"shutdown,omitempty"`
}

func (m *DrainRequest) Reset()                    { *m = DrainRequest{} }
func (m *DrainRequest) String() string            { return proto.CompactTextString(m) }
func (*DrainRequest) ProtoMessage()               {}
func (*DrainRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{18} }

// DrainResponse is the response to a successful DrainRequest and lists the
// modes which are activated after having processing the request.
type DrainResponse struct {
	On []int32 `protobuf:"varint,1,rep,packed,name=on" json:"on,omitempty"`
}

func (m *DrainResponse) Reset()                    { *m = DrainResponse{} }
func (m *DrainResponse) String() string            { return proto.CompactTextString(m) }
func (*DrainResponse) ProtoMessage()               {}
func (*DrainResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{19} }

// SettingsRequest inquires what are the current settings in the cluster.
type SettingsRequest struct {
	// The array of setting names to retrieve.
	// An empty keys array means "all".
	Keys []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *SettingsRequest) Reset()                    { *m = SettingsRequest{} }
func (m *SettingsRequest) String() string            { return proto.CompactTextString(m) }
func (*SettingsRequest) ProtoMessage()               {}
func (*SettingsRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{20} }

// SettingsResponse is the response to SettingsRequest.
type SettingsResponse struct {
	KeyValues map[string]SettingsResponse_Value `protobuf:"bytes,1,rep,name=key_values,json=keyValues" json:"key_values" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SettingsResponse) Reset()                    { *m = SettingsResponse{} }
func (m *SettingsResponse) String() string            { return proto.CompactTextString(m) }
func (*SettingsResponse) ProtoMessage()               {}
func (*SettingsResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{21} }

type SettingsResponse_Value struct {
	Value       string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type        string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (m *SettingsResponse_Value) Reset()                    { *m = SettingsResponse_Value{} }
func (m *SettingsResponse_Value) String() string            { return proto.CompactTextString(m) }
func (*SettingsResponse_Value) ProtoMessage()               {}
func (*SettingsResponse_Value) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{21, 0} }

// HealthRequest inquires whether the addressed node is healthy.
type HealthRequest struct {
}

func (m *HealthRequest) Reset()                    { *m = HealthRequest{} }
func (m *HealthRequest) String() string            { return proto.CompactTextString(m) }
func (*HealthRequest) ProtoMessage()               {}
func (*HealthRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{22} }

// HealthResponse is the response to HealthRequest. It currently does not
// contain any information. The request fails however if the node is not live.
// TODO(tschottdorf): Should it contain information, and if so, what?
type HealthResponse struct {
}

func (m *HealthResponse) Reset()                    { *m = HealthResponse{} }
func (m *HealthResponse) String() string            { return proto.CompactTextString(m) }
func (*HealthResponse) ProtoMessage()               {}
func (*HealthResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{23} }

// LivenessRequest requests liveness data for all nodes on the cluster.
type LivenessRequest struct {
}

func (m *LivenessRequest) Reset()                    { *m = LivenessRequest{} }
func (m *LivenessRequest) String() string            { return proto.CompactTextString(m) }
func (*LivenessRequest) ProtoMessage()               {}
func (*LivenessRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{24} }

// LivenessResponse contains the liveness status of each node on the cluster.
type LivenessResponse struct {
	Livenesses []cockroach_storage.Liveness `protobuf:"bytes,1,rep,name=livenesses" json:"livenesses"`
}

func (m *LivenessResponse) Reset()                    { *m = LivenessResponse{} }
func (m *LivenessResponse) String() string            { return proto.CompactTextString(m) }
func (*LivenessResponse) ProtoMessage()               {}
func (*LivenessResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{25} }

// RangeLogRequest request the history of a range from the range log.
type RangeLogRequest struct {
	// figure out how to teach grpc-gateway about custom names.
	RangeId int64 `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
	// limit is the total number of results that are retreived by the query. If
	// this is obmited or set to 0, the default maximum number of results are
	// returned. When set to > 0, at most only that number of results are
	// returned. When set to < 0, an unlimited number of results are returned.
	Limit int32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *RangeLogRequest) Reset()                    { *m = RangeLogRequest{} }
func (m *RangeLogRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeLogRequest) ProtoMessage()               {}
func (*RangeLogRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{26} }

// RangeLogResponse contains a list of entries from the range log table.
type RangeLogResponse struct {
	Events []cockroach_storage1.RangeLogEvent `protobuf:"bytes,1,rep,name=events" json:"events"`
}

func (m *RangeLogResponse) Reset()                    { *m = RangeLogResponse{} }
func (m *RangeLogResponse) String() string            { return proto.CompactTextString(m) }
func (*RangeLogResponse) ProtoMessage()               {}
func (*RangeLogResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{27} }

// QueryPlanRequest requests the query plans for a SQL string.
type QueryPlanRequest struct {
	// query is the SQL query string.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (m *QueryPlanRequest) Reset()                    { *m = QueryPlanRequest{} }
func (m *QueryPlanRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryPlanRequest) ProtoMessage()               {}
func (*QueryPlanRequest) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{28} }

// QueryPlanResponse contains the query plans for a SQL string (currently only
// the distsql physical query plan).
type QueryPlanResponse struct {
	DistSQLPhysicalQueryPlan string `protobuf:"bytes,1,opt,name=distsql_physical_query_plan,json=distsqlPhysicalQueryPlan,proto3" json:"distsql_physical_query_plan,omitempty"`
}

func (m *QueryPlanResponse) Reset()                    { *m = QueryPlanResponse{} }
func (m *QueryPlanResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryPlanResponse) ProtoMessage()               {}
func (*QueryPlanResponse) Descriptor() ([]byte, []int) { return fileDescriptorAdmin, []int{29} }

func init() {
	proto.RegisterType((*DatabasesRequest)(nil), "cockroach.server.serverpb.DatabasesRequest")
	proto.RegisterType((*DatabasesResponse)(nil), "cockroach.server.serverpb.DatabasesResponse")
	proto.RegisterType((*DatabaseDetailsRequest)(nil), "cockroach.server.serverpb.DatabaseDetailsRequest")
	proto.RegisterType((*DatabaseDetailsResponse)(nil), "cockroach.server.serverpb.DatabaseDetailsResponse")
	proto.RegisterType((*DatabaseDetailsResponse_Grant)(nil), "cockroach.server.serverpb.DatabaseDetailsResponse.Grant")
	proto.RegisterType((*TableDetailsRequest)(nil), "cockroach.server.serverpb.TableDetailsRequest")
	proto.RegisterType((*TableDetailsResponse)(nil), "cockroach.server.serverpb.TableDetailsResponse")
	proto.RegisterType((*TableDetailsResponse_Grant)(nil), "cockroach.server.serverpb.TableDetailsResponse.Grant")
	proto.RegisterType((*TableDetailsResponse_Column)(nil), "cockroach.server.serverpb.TableDetailsResponse.Column")
	proto.RegisterType((*TableDetailsResponse_Index)(nil), "cockroach.server.serverpb.TableDetailsResponse.Index")
	proto.RegisterType((*TableStatsRequest)(nil), "cockroach.server.serverpb.TableStatsRequest")
	proto.RegisterType((*TableStatsResponse)(nil), "cockroach.server.serverpb.TableStatsResponse")
	proto.RegisterType((*TableStatsResponse_MissingNode)(nil), "cockroach.server.serverpb.TableStatsResponse.MissingNode")
	proto.RegisterType((*UsersRequest)(nil), "cockroach.server.serverpb.UsersRequest")
	proto.RegisterType((*UsersResponse)(nil), "cockroach.server.serverpb.UsersResponse")
	proto.RegisterType((*UsersResponse_User)(nil), "cockroach.server.serverpb.UsersResponse.User")
	proto.RegisterType((*EventsRequest)(nil), "cockroach.server.serverpb.EventsRequest")
	proto.RegisterType((*EventsResponse)(nil), "cockroach.server.serverpb.EventsResponse")
	proto.RegisterType((*EventsResponse_Event)(nil), "cockroach.server.serverpb.EventsResponse.Event")
	proto.RegisterType((*SetUIDataRequest)(nil), "cockroach.server.serverpb.SetUIDataRequest")
	proto.RegisterType((*SetUIDataResponse)(nil), "cockroach.server.serverpb.SetUIDataResponse")
	proto.RegisterType((*GetUIDataRequest)(nil), "cockroach.server.serverpb.GetUIDataRequest")
	proto.RegisterType((*GetUIDataResponse)(nil), "cockroach.server.serverpb.GetUIDataResponse")
	proto.RegisterType((*GetUIDataResponse_Value)(nil), "cockroach.server.serverpb.GetUIDataResponse.Value")
	proto.RegisterType((*ClusterRequest)(nil), "cockroach.server.serverpb.ClusterRequest")
	proto.RegisterType((*ClusterResponse)(nil), "cockroach.server.serverpb.ClusterResponse")
	proto.RegisterType((*DrainRequest)(nil), "cockroach.server.serverpb.DrainRequest")
	proto.RegisterType((*DrainResponse)(nil), "cockroach.server.serverpb.DrainResponse")
	proto.RegisterType((*SettingsRequest)(nil), "cockroach.server.serverpb.SettingsRequest")
	proto.RegisterType((*SettingsResponse)(nil), "cockroach.server.serverpb.SettingsResponse")
	proto.RegisterType((*SettingsResponse_Value)(nil), "cockroach.server.serverpb.SettingsResponse.Value")
	proto.RegisterType((*HealthRequest)(nil), "cockroach.server.serverpb.HealthRequest")
	proto.RegisterType((*HealthResponse)(nil), "cockroach.server.serverpb.HealthResponse")
	proto.RegisterType((*LivenessRequest)(nil), "cockroach.server.serverpb.LivenessRequest")
	proto.RegisterType((*LivenessResponse)(nil), "cockroach.server.serverpb.LivenessResponse")
	proto.RegisterType((*RangeLogRequest)(nil), "cockroach.server.serverpb.RangeLogRequest")
	proto.RegisterType((*RangeLogResponse)(nil), "cockroach.server.serverpb.RangeLogResponse")
	proto.RegisterType((*QueryPlanRequest)(nil), "cockroach.server.serverpb.QueryPlanRequest")
	proto.RegisterType((*QueryPlanResponse)(nil), "cockroach.server.serverpb.QueryPlanResponse")
	proto.RegisterEnum("cockroach.server.serverpb.ZoneConfigurationLevel", ZoneConfigurationLevel_name, ZoneConfigurationLevel_value)
	proto.RegisterEnum("cockroach.server.serverpb.DrainMode", DrainMode_name, DrainMode_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Admin service

type AdminClient interface {
	// URL: /_admin/v1/users
	Users(ctx context.Context, in *UsersRequest, opts ...grpc.CallOption) (*UsersResponse, error)
	// URL: /_admin/v1/databases
	Databases(ctx context.Context, in *DatabasesRequest, opts ...grpc.CallOption) (*DatabasesResponse, error)
	// Example URL: /_admin/v1/databases/system
	DatabaseDetails(ctx context.Context, in *DatabaseDetailsRequest, opts ...grpc.CallOption) (*DatabaseDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui
	TableDetails(ctx context.Context, in *TableDetailsRequest, opts ...grpc.CallOption) (*TableDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui/stats
	TableStats(ctx context.Context, in *TableStatsRequest, opts ...grpc.CallOption) (*TableStatsResponse, error)
	// Example URLs:
	// Example URLs:
	// - /_admin/v1/events
	// - /_admin/v1/events?limit=100
	// - /_admin/v1/events?type=create_table
	// - /_admin/v1/events?type=create_table&limit=100
	// - /_admin/v1/events?type=drop_table&target_id=4
	// - /_admin/v1/events?type=drop_table&target_id=4&limit=100
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (*EventsResponse, error)
	// This requires a POST. Because of the libraries we're using, the POST body
	// must be in the following format:
	//
	// {"key_values":
	//   { "key1": "base64_encoded_value1"},
	//   ...
	//   { "keyN": "base64_encoded_valueN"},
	// }
	//
	// Note that all keys are quoted strings and that all values are base64-
	// encoded.
	//
	// Together, SetUIData and GetUIData provide access to a "cookie jar" for the
	// admin UI. The structure of the underlying data is meant to be opaque to the
	// server.
	SetUIData(ctx context.Context, in *SetUIDataRequest, opts ...grpc.CallOption) (*SetUIDataResponse, error)
	// Example URLs:
	// - /_admin/v1/uidata?keys=MYKEY
	// - /_admin/v1/uidata?keys=MYKEY1&keys=MYKEY2
	//
	// Yes, it's a little odd that the query parameter is named "keys" instead of
	// "key". I would've preferred that the URL parameter be named "key". However,
	// it's clearer for the protobuf field to be named "keys," which makes the URL
	// parameter "keys" as well.
	GetUIData(ctx context.Context, in *GetUIDataRequest, opts ...grpc.CallOption) (*GetUIDataResponse, error)
	// Cluster returns metadata for the cluster.
	Cluster(ctx context.Context, in *ClusterRequest, opts ...grpc.CallOption) (*ClusterResponse, error)
	// Settings returns the cluster-wide settings for the cluster.
	Settings(ctx context.Context, in *SettingsRequest, opts ...grpc.CallOption) (*SettingsResponse, error)
	// Health returns liveness for the node target of the request.
	Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error)
	// Liveness returns the liveness state of all nodes on the cluster.
	Liveness(ctx context.Context, in *LivenessRequest, opts ...grpc.CallOption) (*LivenessResponse, error)
	// QueryPlan returns the query plans for a SQL string.
	QueryPlan(ctx context.Context, in *QueryPlanRequest, opts ...grpc.CallOption) (*QueryPlanResponse, error)
	// Drain puts the node into the specified drain mode(s) and optionally
	// instructs the process to terminate.
	Drain(ctx context.Context, in *DrainRequest, opts ...grpc.CallOption) (Admin_DrainClient, error)
	// URL: /_admin/v1/rangelog/1
	// URL: /_admin/v1/rangelog/1?limit=100
	RangeLog(ctx context.Context, in *RangeLogRequest, opts ...grpc.CallOption) (*RangeLogResponse, error)
}

type adminClient struct {
	cc *grpc.ClientConn
}

func NewAdminClient(cc *grpc.ClientConn) AdminClient {
	return &adminClient{cc}
}

func (c *adminClient) Users(ctx context.Context, in *UsersRequest, opts ...grpc.CallOption) (*UsersResponse, error) {
	out := new(UsersResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Users", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Databases(ctx context.Context, in *DatabasesRequest, opts ...grpc.CallOption) (*DatabasesResponse, error) {
	out := new(DatabasesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Databases", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) DatabaseDetails(ctx context.Context, in *DatabaseDetailsRequest, opts ...grpc.CallOption) (*DatabaseDetailsResponse, error) {
	out := new(DatabaseDetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/DatabaseDetails", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) TableDetails(ctx context.Context, in *TableDetailsRequest, opts ...grpc.CallOption) (*TableDetailsResponse, error) {
	out := new(TableDetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/TableDetails", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) TableStats(ctx context.Context, in *TableStatsRequest, opts ...grpc.CallOption) (*TableStatsResponse, error) {
	out := new(TableStatsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/TableStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (*EventsResponse, error) {
	out := new(EventsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Events", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) SetUIData(ctx context.Context, in *SetUIDataRequest, opts ...grpc.CallOption) (*SetUIDataResponse, error) {
	out := new(SetUIDataResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/SetUIData", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) GetUIData(ctx context.Context, in *GetUIDataRequest, opts ...grpc.CallOption) (*GetUIDataResponse, error) {
	out := new(GetUIDataResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/GetUIData", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Cluster(ctx context.Context, in *ClusterRequest, opts ...grpc.CallOption) (*ClusterResponse, error) {
	out := new(ClusterResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Cluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Settings(ctx context.Context, in *SettingsRequest, opts ...grpc.CallOption) (*SettingsResponse, error) {
	out := new(SettingsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Settings", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error) {
	out := new(HealthResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Health", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Liveness(ctx context.Context, in *LivenessRequest, opts ...grpc.CallOption) (*LivenessResponse, error) {
	out := new(LivenessResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/Liveness", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) QueryPlan(ctx context.Context, in *QueryPlanRequest, opts ...grpc.CallOption) (*QueryPlanResponse, error) {
	out := new(QueryPlanResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/QueryPlan", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adminClient) Drain(ctx context.Context, in *DrainRequest, opts ...grpc.CallOption) (Admin_DrainClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Admin_serviceDesc.Streams[0], c.cc, "/cockroach.server.serverpb.Admin/Drain", opts...)
	if err != nil {
		return nil, err
	}
	x := &adminDrainClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Admin_DrainClient interface {
	Recv() (*DrainResponse, error)
	grpc.ClientStream
}

type adminDrainClient struct {
	grpc.ClientStream
}

func (x *adminDrainClient) Recv() (*DrainResponse, error) {
	m := new(DrainResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *adminClient) RangeLog(ctx context.Context, in *RangeLogRequest, opts ...grpc.CallOption) (*RangeLogResponse, error) {
	out := new(RangeLogResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Admin/RangeLog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Admin service

type AdminServer interface {
	// URL: /_admin/v1/users
	Users(context.Context, *UsersRequest) (*UsersResponse, error)
	// URL: /_admin/v1/databases
	Databases(context.Context, *DatabasesRequest) (*DatabasesResponse, error)
	// Example URL: /_admin/v1/databases/system
	DatabaseDetails(context.Context, *DatabaseDetailsRequest) (*DatabaseDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui
	TableDetails(context.Context, *TableDetailsRequest) (*TableDetailsResponse, error)
	// Example URL: /_admin/v1/databases/system/tables/ui/stats
	TableStats(context.Context, *TableStatsRequest) (*TableStatsResponse, error)
	// Example URLs:
	// Example URLs:
	// - /_admin/v1/events
	// - /_admin/v1/events?limit=100
	// - /_admin/v1/events?type=create_table
	// - /_admin/v1/events?type=create_table&limit=100
	// - /_admin/v1/events?type=drop_table&target_id=4
	// - /_admin/v1/events?type=drop_table&target_id=4&limit=100
	Events(context.Context, *EventsRequest) (*EventsResponse, error)
	// This requires a POST. Because of the libraries we're using, the POST body
	// must be in the following format:
	//
	// {"key_values":
	//   { "key1": "base64_encoded_value1"},
	//   ...
	//   { "keyN": "base64_encoded_valueN"},
	// }
	//
	// Note that all keys are quoted strings and that all values are base64-
	// encoded.
	//
	// Together, SetUIData and GetUIData provide access to a "cookie jar" for the
	// admin UI. The structure of the underlying data is meant to be opaque to the
	// server.
	SetUIData(context.Context, *SetUIDataRequest) (*SetUIDataResponse, error)
	// Example URLs:
	// - /_admin/v1/uidata?keys=MYKEY
	// - /_admin/v1/uidata?keys=MYKEY1&keys=MYKEY2
	//
	// Yes, it's a little odd that the query parameter is named "keys" instead of
	// "key". I would've preferred that the URL parameter be named "key". However,
	// it's clearer for the protobuf field to be named "keys," which makes the URL
	// parameter "keys" as well.
	GetUIData(context.Context, *GetUIDataRequest) (*GetUIDataResponse, error)
	// Cluster returns metadata for the cluster.
	Cluster(context.Context, *ClusterRequest) (*ClusterResponse, error)
	// Settings returns the cluster-wide settings for the cluster.
	Settings(context.Context, *SettingsRequest) (*SettingsResponse, error)
	// Health returns liveness for the node target of the request.
	Health(context.Context, *HealthRequest) (*HealthResponse, error)
	// Liveness returns the liveness state of all nodes on the cluster.
	Liveness(context.Context, *LivenessRequest) (*LivenessResponse, error)
	// QueryPlan returns the query plans for a SQL string.
	QueryPlan(context.Context, *QueryPlanRequest) (*QueryPlanResponse, error)
	// Drain puts the node into the specified drain mode(s) and optionally
	// instructs the process to terminate.
	Drain(*DrainRequest, Admin_DrainServer) error
	// URL: /_admin/v1/rangelog/1
	// URL: /_admin/v1/rangelog/1?limit=100
	RangeLog(context.Context, *RangeLogRequest) (*RangeLogResponse, error)
}

func RegisterAdminServer(s *grpc.Server, srv AdminServer) {
	s.RegisterService(&_Admin_serviceDesc, srv)
}

func _Admin_Users_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Users(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Users",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Users(ctx, req.(*UsersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Databases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Databases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Databases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Databases(ctx, req.(*DatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_DatabaseDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabaseDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).DatabaseDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/DatabaseDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).DatabaseDetails(ctx, req.(*DatabaseDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_TableDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TableDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).TableDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/TableDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).TableDetails(ctx, req.(*TableDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_TableStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TableStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).TableStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/TableStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).TableStats(ctx, req.(*TableStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Events_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Events(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Events",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Events(ctx, req.(*EventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_SetUIData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetUIDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).SetUIData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/SetUIData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).SetUIData(ctx, req.(*SetUIDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_GetUIData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUIDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).GetUIData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/GetUIData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).GetUIData(ctx, req.(*GetUIDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Cluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Cluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Cluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Cluster(ctx, req.(*ClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Settings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Settings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Settings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Settings(ctx, req.(*SettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Health_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HealthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Health(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Health",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Health(ctx, req.(*HealthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Liveness_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LivenessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).Liveness(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/Liveness",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).Liveness(ctx, req.(*LivenessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_QueryPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).QueryPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/QueryPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).QueryPlan(ctx, req.(*QueryPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Admin_Drain_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(DrainRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdminServer).Drain(m, &adminDrainServer{stream})
}

type Admin_DrainServer interface {
	Send(*DrainResponse) error
	grpc.ServerStream
}

type adminDrainServer struct {
	grpc.ServerStream
}

func (x *adminDrainServer) Send(m *DrainResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Admin_RangeLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RangeLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdminServer).RangeLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Admin/RangeLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdminServer).RangeLog(ctx, req.(*RangeLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Admin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.server.serverpb.Admin",
	HandlerType: (*AdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Users",
			Handler:    _Admin_Users_Handler,
		},
		{
			MethodName: "Databases",
			Handler:    _Admin_Databases_Handler,
		},
		{
			MethodName: "DatabaseDetails",
			Handler:    _Admin_DatabaseDetails_Handler,
		},
		{
			MethodName: "TableDetails",
			Handler:    _Admin_TableDetails_Handler,
		},
		{
			MethodName: "TableStats",
			Handler:    _Admin_TableStats_Handler,
		},
		{
			MethodName: "Events",
			Handler:    _Admin_Events_Handler,
		},
		{
			MethodName: "SetUIData",
			Handler:    _Admin_SetUIData_Handler,
		},
		{
			MethodName: "GetUIData",
			Handler:    _Admin_GetUIData_Handler,
		},
		{
			MethodName: "Cluster",
			Handler:    _Admin_Cluster_Handler,
		},
		{
			MethodName: "Settings",
			Handler:    _Admin_Settings_Handler,
		},
		{
			MethodName: "Health",
			Handler:    _Admin_Health_Handler,
		},
		{
			MethodName: "Liveness",
			Handler:    _Admin_Liveness_Handler,
		},
		{
			MethodName: "QueryPlan",
			Handler:    _Admin_QueryPlan_Handler,
		},
		{
			MethodName: "RangeLog",
			Handler:    _Admin_RangeLog_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Drain",
			Handler:       _Admin_Drain_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "cockroach/pkg/server/serverpb/admin.proto",
}

func (m *DatabasesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabasesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *DatabasesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabasesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for _, s := range m.Databases {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *DatabaseDetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	return i, nil
}

func (m *DatabaseDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, msg := range m.Grants {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.TableNames) > 0 {
		for _, s := range m.TableNames {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.DescriptorID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.DescriptorID))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfig.Size()))
	n1, err := m.ZoneConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.ZoneConfigLevel != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfigLevel))
	}
	return i, nil
}

func (m *DatabaseDetailsResponse_Grant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDetailsResponse_Grant) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *TableDetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	return i, nil
}

func (m *TableDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, msg := range m.Grants {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Indexes) > 0 {
		for _, msg := range m.Indexes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RangeCount != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeCount))
	}
	if len(m.CreateTableStatement) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.CreateTableStatement)))
		i += copy(dAtA[i:], m.CreateTableStatement)
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfig.Size()))
	n2, err := m.ZoneConfig.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.ZoneConfigLevel != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ZoneConfigLevel))
	}
	if m.DescriptorID != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.DescriptorID))
	}
	return i, nil
}

func (m *TableDetailsResponse_Grant) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Grant) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *TableDetailsResponse_Column) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Column) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.Nullable {
		dAtA[i] = 0x18
		i++
		if m.Nullable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.DefaultValue) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.DefaultValue)))
		i += copy(dAtA[i:], m.DefaultValue)
	}
	return i, nil
}

func (m *TableDetailsResponse_Index) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDetailsResponse_Index) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Unique {
		dAtA[i] = 0x10
		i++
		if m.Unique {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Seq != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Seq))
	}
	if len(m.Column) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Column)))
		i += copy(dAtA[i:], m.Column)
	}
	if len(m.Direction) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Direction)))
		i += copy(dAtA[i:], m.Direction)
	}
	if m.Storing {
		dAtA[i] = 0x30
		i++
		if m.Storing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Implicit {
		dAtA[i] = 0x38
		i++
		if m.Implicit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *TableStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Database) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Database)))
		i += copy(dAtA[i:], m.Database)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	return i, nil
}

func (m *TableStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeCount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeCount))
	}
	if m.ReplicaCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ReplicaCount))
	}
	if m.NodeCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.NodeCount))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(m.Stats.Size()))
	n3, err := m.Stats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.MissingNodes) > 0 {
		for _, msg := range m.MissingNodes {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TableStatsResponse_MissingNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableStatsResponse_MissingNode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	return i, nil
}

func (m *UsersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *UsersResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Users) > 0 {
		for _, msg := range m.Users {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UsersResponse_User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsersResponse_User) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Username) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *EventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.TargetId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.TargetId))
	}
	if m.Limit != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Limit))
	}
	return i, nil
}

func (m *EventsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *EventsResponse_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventsResponse_Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)))
	n4, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Timestamp, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.EventType) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.EventType)))
		i += copy(dAtA[i:], m.EventType)
	}
	if m.TargetID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.TargetID))
	}
	if m.ReportingID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.ReportingID))
	}
	if len(m.Info) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Info)))
		i += copy(dAtA[i:], m.Info)
	}
	if len(m.UniqueID) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.UniqueID)))
		i += copy(dAtA[i:], m.UniqueID)
	}
	return i, nil
}

func (m *SetUIDataRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetUIDataRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			byteSize := 0
			if len(v) > 0 {
				byteSize = 1 + len(v) + sovAdmin(uint64(len(v)))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + byteSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if len(v) > 0 {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAdmin(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	return i, nil
}

func (m *SetUIDataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetUIDataResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *GetUIDataRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *GetUIDataResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n5, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n5
		}
	}
	return i, nil
}

func (m *GetUIDataResponse_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUIDataResponse_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintAdmin(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.LastUpdated)))
	n6, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastUpdated, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *ClusterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ClusterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.ClusterID)))
		i += copy(dAtA[i:], m.ClusterID)
	}
	return i, nil
}

func (m *DrainRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DrainRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.On) > 0 {
		dAtA8 := make([]byte, len(m.On)*10)
		var j7 int
		for _, num1 := range m.On {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA8[j7] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j7++
			}
			dAtA8[j7] = uint8(num)
			j7++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j7))
		i += copy(dAtA[i:], dAtA8[:j7])
	}
	if len(m.Off) > 0 {
		dAtA10 := make([]byte, len(m.Off)*10)
		var j9 int
		for _, num1 := range m.Off {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA10[j9] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j9++
			}
			dAtA10[j9] = uint8(num)
			j9++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j9))
		i += copy(dAtA[i:], dAtA10[:j9])
	}
	if m.Shutdown {
		dAtA[i] = 0x18
		i++
		if m.Shutdown {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DrainResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DrainResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.On) > 0 {
		dAtA12 := make([]byte, len(m.On)*10)
		var j11 int
		for _, num1 := range m.On {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA12[j11] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j11++
			}
			dAtA12[j11] = uint8(num)
			j11++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(j11))
		i += copy(dAtA[i:], dAtA12[:j11])
	}
	return i, nil
}

func (m *SettingsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *SettingsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		keysForKeyValues := make([]string, 0, len(m.KeyValues))
		for k := range m.KeyValues {
			keysForKeyValues = append(keysForKeyValues, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForKeyValues)
		for _, k := range keysForKeyValues {
			dAtA[i] = 0xa
			i++
			v := m.KeyValues[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAdmin(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAdmin(uint64(len(k))) + msgSize
			i = encodeVarintAdmin(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAdmin(dAtA, i, uint64((&v).Size()))
			n13, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n13
		}
	}
	return i, nil
}

func (m *SettingsResponse_Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsResponse_Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	return i, nil
}

func (m *HealthRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *HealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LivenessRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LivenessRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *LivenessResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LivenessResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Livenesses) > 0 {
		for _, msg := range m.Livenesses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RangeLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.RangeId))
	}
	if m.Limit != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(m.Limit))
	}
	return i, nil
}

func (m *RangeLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLogResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAdmin(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryPlanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPlanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	return i, nil
}

func (m *QueryPlanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPlanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DistSQLPhysicalQueryPlan) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAdmin(dAtA, i, uint64(len(m.DistSQLPhysicalQueryPlan)))
		i += copy(dAtA[i:], m.DistSQLPhysicalQueryPlan)
	}
	return i, nil
}

func encodeFixed64Admin(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Admin(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintAdmin(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DatabasesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *DatabasesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for _, s := range m.Databases {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *DatabaseDetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DatabaseDetailsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, e := range m.Grants {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.TableNames) > 0 {
		for _, s := range m.TableNames {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if m.DescriptorID != 0 {
		n += 1 + sovAdmin(uint64(m.DescriptorID))
	}
	l = m.ZoneConfig.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if m.ZoneConfigLevel != 0 {
		n += 1 + sovAdmin(uint64(m.ZoneConfigLevel))
	}
	return n
}

func (m *DatabaseDetailsResponse_Grant) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *TableDetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *TableDetailsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Grants) > 0 {
		for _, e := range m.Grants {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if len(m.Indexes) > 0 {
		for _, e := range m.Indexes {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	if m.RangeCount != 0 {
		n += 1 + sovAdmin(uint64(m.RangeCount))
	}
	l = len(m.CreateTableStatement)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = m.ZoneConfig.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if m.ZoneConfigLevel != 0 {
		n += 1 + sovAdmin(uint64(m.ZoneConfigLevel))
	}
	if m.DescriptorID != 0 {
		n += 1 + sovAdmin(uint64(m.DescriptorID))
	}
	return n
}

func (m *TableDetailsResponse_Grant) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if len(m.Privileges) > 0 {
		for _, s := range m.Privileges {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *TableDetailsResponse_Column) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Nullable {
		n += 2
	}
	l = len(m.DefaultValue)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *TableDetailsResponse_Index) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Unique {
		n += 2
	}
	if m.Seq != 0 {
		n += 1 + sovAdmin(uint64(m.Seq))
	}
	l = len(m.Column)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Direction)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.Storing {
		n += 2
	}
	if m.Implicit {
		n += 2
	}
	return n
}

func (m *TableStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *TableStatsResponse) Size() (n int) {
	var l int
	_ = l
	if m.RangeCount != 0 {
		n += 1 + sovAdmin(uint64(m.RangeCount))
	}
	if m.ReplicaCount != 0 {
		n += 1 + sovAdmin(uint64(m.ReplicaCount))
	}
	if m.NodeCount != 0 {
		n += 1 + sovAdmin(uint64(m.NodeCount))
	}
	l = m.Stats.Size()
	n += 1 + l + sovAdmin(uint64(l))
	if len(m.MissingNodes) > 0 {
		for _, e := range m.MissingNodes {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *TableStatsResponse_MissingNode) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *UsersRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *UsersResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Users) > 0 {
		for _, e := range m.Users {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *UsersResponse_User) Size() (n int) {
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *EventsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.TargetId != 0 {
		n += 1 + sovAdmin(uint64(m.TargetId))
	}
	if m.Limit != 0 {
		n += 1 + sovAdmin(uint64(m.Limit))
	}
	return n
}

func (m *EventsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *EventsResponse_Event) Size() (n int) {
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Timestamp)
	n += 1 + l + sovAdmin(uint64(l))
	l = len(m.EventType)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	if m.TargetID != 0 {
		n += 1 + sovAdmin(uint64(m.TargetID))
	}
	if m.ReportingID != 0 {
		n += 1 + sovAdmin(uint64(m.ReportingID))
	}
	l = len(m.Info)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.UniqueID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *SetUIDataRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovAdmin(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *SetUIDataResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *GetUIDataRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *GetUIDataResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *GetUIDataResponse_Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastUpdated)
	n += 1 + l + sovAdmin(uint64(l))
	return n
}

func (m *ClusterRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ClusterResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterID)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *DrainRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.On) > 0 {
		l = 0
		for _, e := range m.On {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	if len(m.Off) > 0 {
		l = 0
		for _, e := range m.Off {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	if m.Shutdown {
		n += 2
	}
	return n
}

func (m *DrainResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.On) > 0 {
		l = 0
		for _, e := range m.On {
			l += sovAdmin(uint64(e))
		}
		n += 1 + sovAdmin(uint64(l)) + l
	}
	return n
}

func (m *SettingsRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *SettingsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.KeyValues) > 0 {
		for k, v := range m.KeyValues {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovAdmin(uint64(len(k))) + 1 + l + sovAdmin(uint64(l))
			n += mapEntrySize + 1 + sovAdmin(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *SettingsResponse_Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *HealthRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *HealthResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LivenessRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *LivenessResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Livenesses) > 0 {
		for _, e := range m.Livenesses {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *RangeLogRequest) Size() (n int) {
	var l int
	_ = l
	if m.RangeId != 0 {
		n += 1 + sovAdmin(uint64(m.RangeId))
	}
	if m.Limit != 0 {
		n += 1 + sovAdmin(uint64(m.Limit))
	}
	return n
}

func (m *RangeLogResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovAdmin(uint64(l))
		}
	}
	return n
}

func (m *QueryPlanRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func (m *QueryPlanResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.DistSQLPhysicalQueryPlan)
	if l > 0 {
		n += 1 + l + sovAdmin(uint64(l))
	}
	return n
}

func sovAdmin(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAdmin(x uint64) (n int) {
	return sovAdmin(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DatabasesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabasesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabasesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabasesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabasesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabasesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Databases", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Databases = append(m.Databases, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseDetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseDetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Grants = append(m.Grants, DatabaseDetailsResponse_Grant{})
			if err := m.Grants[len(m.Grants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableNames = append(m.TableNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorID", wireType)
			}
			m.DescriptorID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DescriptorID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ZoneConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigLevel", wireType)
			}
			m.ZoneConfigLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ZoneConfigLevel |= (ZoneConfigurationLevel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDetailsResponse_Grant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Grant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Grant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Privileges = append(m.Privileges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableDetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableDetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Grants", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Grants = append(m.Grants, TableDetailsResponse_Grant{})
			if err := m.Grants[len(m.Grants)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, TableDetailsResponse_Column{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Indexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Indexes = append(m.Indexes, TableDetailsResponse_Index{})
			if err := m.Indexes[len(m.Indexes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreateTableStatement", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreateTableStatement = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ZoneConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigLevel", wireType)
			}
			m.ZoneConfigLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ZoneConfigLevel |= (ZoneConfigurationLevel(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorID", wireType)
			}
			m.DescriptorID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DescriptorID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Grant) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Grant: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Grant: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Privileges = append(m.Privileges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Column) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Column: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Column: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nullable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Nullable = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDetailsResponse_Index) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Index: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Index: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unique", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unique = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Column = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Direction = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Storing = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Implicit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Implicit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCount", wireType)
			}
			m.ReplicaCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MissingNodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MissingNodes = append(m.MissingNodes, TableStatsResponse_MissingNode{})
			if err := m.MissingNodes[len(m.MissingNodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableStatsResponse_MissingNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MissingNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MissingNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsersResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsersResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Users", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Users = append(m.Users, UsersResponse_User{})
			if err := m.Users[len(m.Users)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsersResponse_User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetId", wireType)
			}
			m.TargetId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, EventsResponse_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventsResponse_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Timestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetID", wireType)
			}
			m.TargetID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingID", wireType)
			}
			m.ReportingID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReportingID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Info = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UniqueID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UniqueID = append(m.UniqueID[:0], dAtA[iNdEx:postIndex]...)
			if m.UniqueID == nil {
				m.UniqueID = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetUIDataRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetUIDataRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetUIDataRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthAdmin
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.KeyValues == nil {
				m.KeyValues = make(map[string][]byte)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapbyteLen uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapbyteLen |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				intMapbyteLen := int(mapbyteLen)
				if intMapbyteLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postbytesIndex := iNdEx + intMapbyteLen
				if postbytesIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := make([]byte, mapbyteLen)
				copy(mapvalue, dAtA[iNdEx:postbytesIndex])
				iNdEx = postbytesIndex
				m.KeyValues[mapkey] = mapvalue
			} else {
				var mapvalue []byte
				m.KeyValues[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetUIDataResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetUIDataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetUIDataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUIDataRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUIDataRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUIDataResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUIDataResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthAdmin
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.KeyValues == nil {
				m.KeyValues = make(map[string]GetUIDataResponse_Value)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthAdmin
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthAdmin
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &GetUIDataResponse_Value{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.KeyValues[mapkey] = *mapvalue
			} else {
				var mapvalue GetUIDataResponse_Value
				m.KeyValues[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUIDataResponse_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastUpdated, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DrainRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DrainRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DrainRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.On = append(m.On, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.On = append(m.On, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field On", wireType)
			}
		case 2:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Off = append(m.Off, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Off = append(m.Off, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Off", wireType)
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shutdown", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Shutdown = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DrainResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DrainResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DrainResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.On = append(m.On, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAdmin
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAdmin
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.On = append(m.On, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field On", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SettingsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SettingsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SettingsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SettingsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthAdmin
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.KeyValues == nil {
				m.KeyValues = make(map[string]SettingsResponse_Value)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthAdmin
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthAdmin
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &SettingsResponse_Value{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.KeyValues[mapkey] = *mapvalue
			} else {
				var mapvalue SettingsResponse_Value
				m.KeyValues[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SettingsResponse_Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LivenessRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LivenessRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LivenessRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LivenessResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LivenessResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LivenessResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Livenesses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Livenesses = append(m.Livenesses, cockroach_storage.Liveness{})
			if err := m.Livenesses[len(m.Livenesses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, cockroach_storage1.RangeLogEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPlanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPlanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPlanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPlanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPlanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPlanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistSQLPhysicalQueryPlan", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAdmin
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DistSQLPhysicalQueryPlan = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAdmin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAdmin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAdmin(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAdmin
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAdmin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAdmin
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAdmin
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAdmin(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAdmin = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAdmin   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/server/serverpb/admin.proto", fileDescriptorAdmin) }

var fileDescriptorAdmin = []byte{
	// 2178 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0x4f, 0xdb, 0xb1, 0x63, 0x3f, 0x3b, 0x49, 0xa7, 0x26, 0x04, 0x8f, 0x27, 0xc4, 0xd9, 0x1e,
	0xd8, 0xcd, 0x64, 0x67, 0xdd, 0x13, 0x33, 0x3b, 0x5a, 0x66, 0x57, 0xa0, 0x38, 0x8e, 0x32, 0xd6,
	0x24, 0x61, 0xb7, 0x9d, 0x64, 0xc5, 0x22, 0x64, 0x3a, 0xee, 0x8a, 0xd3, 0x4a, 0xbb, 0xdb, 0xe9,
	0x6e, 0x87, 0xc9, 0x0e, 0x8b, 0x60, 0xc5, 0x01, 0x89, 0x03, 0x2b, 0xf1, 0x09, 0x38, 0x21, 0xc1,
	0x05, 0x8e, 0x7c, 0x83, 0xb9, 0x81, 0xc4, 0x85, 0x53, 0x00, 0xc3, 0x89, 0x4f, 0x81, 0xea, 0x5f,
	0xbb, 0xdd, 0xf6, 0xf4, 0xd8, 0xbb, 0x73, 0x72, 0xd5, 0xab, 0x57, 0xaf, 0xde, 0x9f, 0x5f, 0xd5,
	0xfb, 0xb5, 0xe1, 0x5e, 0xcb, 0x69, 0x5d, 0xb8, 0x8e, 0xde, 0x3a, 0x57, 0xbb, 0x17, 0x6d, 0xd5,
	0xc3, 0xee, 0x15, 0x76, 0xf9, 0x4f, 0xf7, 0x54, 0xd5, 0x8d, 0x8e, 0x69, 0x97, 0xbb, 0xae, 0xe3,
	0x3b, 0xe8, 0x76, 0xa0, 0x5a, 0x66, 0xeb, 0x65, 0xa1, 0x56, 0x7c, 0x63, 0xd8, 0x4a, 0xcb, 0xb1,
	0xcf, 0x4c, 0xf1, 0xc3, 0x76, 0x17, 0x1f, 0x44, 0x0e, 0xf2, 0x1d, 0x57, 0x6f, 0x63, 0x15, 0xdb,
	0x6d, 0xd3, 0x16, 0x3f, 0xdd, 0x53, 0xb5, 0x73, 0xd5, 0x6a, 0xf1, 0x1d, 0xdf, 0x1c, 0xbf, 0xc3,
	0x32, 0xaf, 0xb0, 0x8d, 0x3d, 0x8f, 0x6b, 0x95, 0x5e, 0xa2, 0xe5, 0x88, 0x83, 0x97, 0xdb, 0x4e,
	0xdb, 0xa1, 0x43, 0x95, 0x8c, 0xb8, 0x74, 0xb5, 0xed, 0x38, 0x6d, 0x0b, 0xab, 0x7a, 0xd7, 0x54,
	0x75, 0xdb, 0x76, 0x7c, 0xdd, 0x37, 0x1d, 0x3b, 0x30, 0xca, 0x57, 0xe9, 0xec, 0xb4, 0x77, 0xa6,
	0xfa, 0x66, 0x07, 0x7b, 0xbe, 0xde, 0xe9, 0x32, 0x05, 0x05, 0x81, 0x5c, 0xd3, 0x7d, 0xfd, 0x54,
	0xf7, 0xb0, 0xa7, 0xe1, 0xcb, 0x1e, 0xf6, 0x7c, 0x65, 0x0b, 0x96, 0x42, 0x32, 0xaf, 0xeb, 0xd8,
	0x1e, 0x46, 0xab, 0x90, 0x35, 0x84, 0xb0, 0x20, 0xad, 0x27, 0x37, 0xb2, 0xda, 0x40, 0xa0, 0x3c,
	0x84, 0x15, 0xb1, 0xa5, 0x86, 0x7d, 0xdd, 0xb4, 0x84, 0x31, 0x54, 0x84, 0x8c, 0x50, 0x2b, 0x48,
	0xeb, 0xd2, 0x46, 0x56, 0x0b, 0xe6, 0xca, 0x1f, 0x92, 0xf0, 0xf5, 0x91, 0x6d, 0xfc, 0xbc, 0x13,
	0x48, 0xb7, 0x5d, 0xdd, 0xf6, 0xd9, 0x61, 0xb9, 0xca, 0x7b, 0xe5, 0x97, 0x56, 0xad, 0xfc, 0x12,
	0x1b, 0xe5, 0x3d, 0x62, 0xa0, 0x3a, 0xfb, 0xe2, 0xa6, 0x34, 0xa3, 0x71, 0x6b, 0xa8, 0x04, 0x39,
	0x5f, 0x3f, 0xb5, 0x70, 0xd3, 0xd6, 0x3b, 0xd8, 0x2b, 0x24, 0x68, 0x24, 0x40, 0x45, 0x87, 0x44,
	0x82, 0xde, 0x85, 0x79, 0x03, 0x7b, 0x2d, 0xd7, 0xec, 0xfa, 0x8e, 0xdb, 0x34, 0x8d, 0x42, 0x72,
	0x5d, 0xda, 0x48, 0x56, 0xe5, 0xfe, 0x4d, 0x29, 0x5f, 0x0b, 0x16, 0xea, 0x35, 0x2d, 0x3f, 0x50,
	0xab, 0x1b, 0x68, 0x07, 0x72, 0x9f, 0x3a, 0x36, 0x6e, 0x32, 0xac, 0x14, 0x66, 0xd7, 0xa5, 0x8d,
	0x5c, 0x65, 0x35, 0xe4, 0x34, 0x07, 0xd1, 0x27, 0x8e, 0x8d, 0x77, 0xe8, 0x90, 0x3b, 0x06, 0x9f,
	0x06, 0x12, 0xf4, 0x23, 0x58, 0x0a, 0x19, 0x69, 0x5a, 0xf8, 0x0a, 0x5b, 0x85, 0xd4, 0xba, 0xb4,
	0xb1, 0x50, 0xd9, 0x8a, 0x89, 0x7f, 0x60, 0xb3, 0xe7, 0xd2, 0xf2, 0xef, 0x93, 0x8d, 0xda, 0xe2,
	0xc0, 0x32, 0x15, 0x14, 0xdf, 0x87, 0x14, 0x4d, 0x09, 0x42, 0x30, 0xdb, 0xf3, 0xb0, 0xcb, 0x0b,
	0x42, 0xc7, 0x68, 0x0d, 0xa0, 0xeb, 0x9a, 0x57, 0xa6, 0x85, 0xdb, 0x83, 0xbc, 0x0c, 0x24, 0xca,
	0x1e, 0xdc, 0x3a, 0x22, 0x59, 0x9a, 0xbc, 0xbe, 0x68, 0x19, 0x52, 0x34, 0xb1, 0x85, 0x04, 0x5d,
	0x60, 0x13, 0xe5, 0x4f, 0x73, 0xb0, 0x3c, 0x6c, 0x89, 0x97, 0xbc, 0x11, 0x29, 0xf9, 0xbb, 0x31,
	0x21, 0x8f, 0x33, 0x30, 0xb6, 0xde, 0x27, 0x30, 0xd7, 0x72, 0xac, 0x5e, 0xc7, 0x66, 0x31, 0xe5,
	0x2a, 0x8f, 0xa6, 0xb5, 0xba, 0x43, 0xb7, 0x73, 0xb3, 0xc2, 0x18, 0x3a, 0x86, 0x39, 0xd3, 0x36,
	0xf0, 0x33, 0xec, 0x15, 0x92, 0x5f, 0xce, 0xdb, 0x3a, 0xd9, 0x2e, 0xcc, 0x72, 0x5b, 0x04, 0x9e,
	0xae, 0x6e, 0xb7, 0x09, 0x04, 0x7a, 0xb6, 0x4f, 0x61, 0x94, 0xd4, 0x80, 0x8a, 0x76, 0x88, 0x04,
	0x3d, 0x84, 0x95, 0x96, 0x8b, 0x75, 0x1f, 0x37, 0x19, 0x8c, 0x3d, 0x5f, 0xf7, 0x71, 0x07, 0xdb,
	0x3e, 0xc5, 0x49, 0x56, 0x5b, 0x66, 0xab, 0xf4, 0xc4, 0x86, 0x58, 0x8b, 0xa2, 0x33, 0xfd, 0xfa,
	0xd0, 0x39, 0xf7, 0xba, 0xd0, 0x39, 0x7a, 0xf1, 0x32, 0x93, 0x5c, 0xbc, 0xaf, 0x04, 0xea, 0xe2,
	0x25, 0xa4, 0x59, 0x79, 0xc9, 0x6e, 0xf2, 0x22, 0x88, 0xdd, 0x64, 0x4c, 0x64, 0xfe, 0x75, 0x57,
	0xc0, 0x97, 0x8e, 0x09, 0xde, 0xed, 0x9e, 0x65, 0x51, 0x58, 0x93, 0x97, 0x21, 0xa3, 0x05, 0x73,
	0x74, 0x97, 0x44, 0x70, 0xa6, 0xf7, 0x2c, 0xbf, 0x79, 0xa5, 0x5b, 0x3d, 0x4c, 0xcb, 0x97, 0x25,
	0xfe, 0x52, 0xe1, 0x09, 0x91, 0x15, 0xff, 0x2c, 0x41, 0x8a, 0x96, 0x7e, 0xec, 0x91, 0x2b, 0x90,
	0xee, 0xd9, 0xe6, 0x65, 0x8f, 0x1d, 0x9a, 0xd1, 0xf8, 0x0c, 0xc9, 0x90, 0xf4, 0xf0, 0x25, 0x7b,
	0x8b, 0x34, 0x32, 0x24, 0x9a, 0x0c, 0x8b, 0xfc, 0x14, 0x3e, 0xa3, 0x0f, 0xb5, 0xe9, 0xe2, 0x16,
	0xc9, 0x34, 0xc7, 0xc4, 0x40, 0x80, 0x0a, 0x30, 0x47, 0x3a, 0x8b, 0x69, 0x33, 0x10, 0x64, 0x34,
	0x31, 0x25, 0x81, 0x99, 0x9d, 0xae, 0x65, 0xb6, 0x4c, 0x9f, 0x16, 0x35, 0xa3, 0x05, 0x73, 0x65,
	0x17, 0x96, 0x02, 0x40, 0x7d, 0x85, 0x9b, 0xff, 0x79, 0x12, 0x50, 0xd8, 0x0e, 0xbf, 0xf7, 0x11,
	0xcc, 0x4b, 0x23, 0x98, 0xbf, 0x0b, 0xf3, 0x2e, 0x26, 0xae, 0xe8, 0x5c, 0x25, 0x41, 0x55, 0xf2,
	0x5c, 0xc8, 0x94, 0xbe, 0x01, 0x60, 0x3b, 0x86, 0x30, 0xc2, 0x12, 0x95, 0x25, 0x12, 0xb6, 0xfc,
	0x04, 0x52, 0xe4, 0xaa, 0x78, 0xfc, 0x65, 0xbe, 0x1f, 0x06, 0x2c, 0x6b, 0xb5, 0x65, 0xd6, 0xbb,
	0xcb, 0xa2, 0x85, 0x97, 0x0f, 0x4e, 0x76, 0x76, 0xa8, 0xa7, 0xfc, 0x2e, 0x30, 0x03, 0xc8, 0x80,
	0xf9, 0x8e, 0xe9, 0x79, 0xa6, 0xdd, 0x6e, 0x12, 0xf3, 0x5e, 0x21, 0x45, 0xef, 0xff, 0x77, 0x5e,
	0x75, 0xff, 0x87, 0x82, 0x2e, 0x1f, 0x30, 0x13, 0x87, 0x8e, 0x81, 0xb9, 0xf9, 0x7c, 0x67, 0x20,
	0xf2, 0x8a, 0x1f, 0x43, 0x2e, 0xa4, 0x82, 0xee, 0xc2, 0x1c, 0x8d, 0xce, 0x34, 0x58, 0xae, 0xab,
	0xd0, 0xbf, 0x29, 0xa5, 0xc9, 0x52, 0xbd, 0xa6, 0xa5, 0xc9, 0x52, 0xdd, 0x20, 0x79, 0xc2, 0xae,
	0xeb, 0xb8, 0xcd, 0x0e, 0xf6, 0x3c, 0xbd, 0x2d, 0xb2, 0x9f, 0xa7, 0xc2, 0x03, 0x26, 0x53, 0x16,
	0x20, 0x7f, 0xec, 0x61, 0x37, 0xe8, 0xf6, 0x3f, 0x83, 0x79, 0x3e, 0xe7, 0xe5, 0xa8, 0x43, 0x8a,
	0xdc, 0x1d, 0xf1, 0x0a, 0xbf, 0x13, 0x13, 0xd7, 0xd0, 0x46, 0x3a, 0x13, 0xa9, 0xa2, 0x16, 0x8a,
	0x0a, 0xcc, 0x12, 0x21, 0x81, 0x0a, 0x11, 0x84, 0xd0, 0x1e, 0xcc, 0x95, 0x13, 0x98, 0xdf, 0xbd,
	0xc2, 0xf6, 0x00, 0x57, 0xe2, 0xd6, 0x49, 0xa1, 0x5b, 0x77, 0x07, 0xb2, 0xbe, 0xee, 0xb6, 0xb1,
	0x4f, 0x12, 0xc0, 0xaa, 0x9f, 0x61, 0x82, 0xba, 0x41, 0xc0, 0x66, 0x99, 0x1d, 0x93, 0x15, 0x3d,
	0xa5, 0xb1, 0x89, 0xf2, 0xbf, 0x04, 0x2c, 0x08, 0xc3, 0x3c, 0xb2, 0x03, 0x48, 0x63, 0x2a, 0xe1,
	0xa1, 0xa9, 0x31, 0xa1, 0x0d, 0x6f, 0x65, 0x53, 0xd1, 0x5a, 0x98, 0x91, 0xe2, 0xaf, 0x12, 0x90,
	0xa2, 0x72, 0x54, 0x85, 0x6c, 0x40, 0xac, 0xa8, 0xdf, 0xb9, 0x4a, 0xb1, 0xcc, 0xa8, 0x57, 0x59,
	0x50, 0xaf, 0xf2, 0x91, 0xd0, 0xa8, 0x66, 0x88, 0x99, 0x2f, 0xfe, 0x59, 0x92, 0xb4, 0xc1, 0x36,
	0x82, 0x5f, 0x6a, 0xb7, 0x19, 0x7a, 0x72, 0xb2, 0x54, 0x72, 0x44, 0x32, 0x70, 0x2f, 0x9c, 0x01,
	0x46, 0x49, 0xf2, 0xfd, 0x9b, 0x52, 0xe6, 0x88, 0x65, 0xa1, 0x16, 0xca, 0x47, 0x05, 0xc8, 0xcd,
	0x70, 0x5c, 0x9f, 0x40, 0xd4, 0x34, 0x58, 0x13, 0xa9, 0x2e, 0xf6, 0x6f, 0x4a, 0x39, 0x4d, 0xc8,
	0xeb, 0x35, 0x2d, 0x17, 0x28, 0xd5, 0x0d, 0x92, 0x74, 0xd3, 0x3e, 0x73, 0xf8, 0x83, 0x41, 0xc7,
	0xe4, 0x48, 0xf6, 0xfa, 0x10, 0x23, 0xe4, 0xb5, 0xc8, 0xb3, 0x23, 0x8f, 0xa9, 0x90, 0x1c, 0xc9,
	0x96, 0xeb, 0x86, 0xf2, 0x47, 0x09, 0xe4, 0x06, 0xf6, 0x8f, 0xeb, 0x84, 0x8a, 0x89, 0x42, 0xfe,
	0x00, 0xe0, 0x02, 0x5f, 0xb3, 0xa7, 0x50, 0xa4, 0xfc, 0x71, 0x4c, 0xca, 0xa3, 0x06, 0xca, 0x4f,
	0xf1, 0x35, 0x7d, 0x33, 0xbd, 0x5d, 0xdb, 0x77, 0xaf, 0xb5, 0xec, 0x85, 0x98, 0x17, 0x3f, 0x80,
	0x85, 0xe1, 0x45, 0xf2, 0x40, 0x5e, 0xe0, 0x6b, 0x0e, 0x1a, 0x32, 0x24, 0xb0, 0x60, 0xaf, 0x30,
	0xc9, 0x65, 0x5e, 0x63, 0x93, 0xc7, 0x89, 0xf7, 0x24, 0xe5, 0x16, 0x2c, 0x85, 0xce, 0x62, 0x15,
	0x56, 0xde, 0x04, 0x79, 0x2f, 0x1a, 0x01, 0x82, 0xd9, 0x0b, 0x7c, 0x2d, 0xf8, 0x2e, 0x1d, 0x2b,
	0x7f, 0x4d, 0xc0, 0xd2, 0x5e, 0x74, 0x37, 0xfa, 0xf1, 0x98, 0x58, 0xdf, 0x8f, 0x89, 0x75, 0xc4,
	0x42, 0x24, 0x58, 0x0e, 0xb5, 0x50, 0xc8, 0x67, 0x90, 0xa2, 0xa3, 0x41, 0x5c, 0x52, 0x28, 0x2e,
	0xb4, 0x07, 0x79, 0x4b, 0xf7, 0xfc, 0x66, 0xaf, 0x6b, 0xe8, 0x3e, 0x66, 0x97, 0x64, 0x52, 0x14,
	0xe6, 0xc8, 0xce, 0x63, 0xb6, 0xb1, 0xd8, 0x9d, 0x20, 0xb5, 0x4f, 0xc2, 0xa9, 0xcd, 0x55, 0x2a,
	0x53, 0x05, 0x4a, 0x4d, 0x87, 0xcb, 0x21, 0xc3, 0xc2, 0x8e, 0xd5, 0xf3, 0x7c, 0xec, 0x8a, 0x37,
	0xe9, 0x7b, 0xb0, 0x18, 0x48, 0x78, 0x82, 0xef, 0x03, 0xb4, 0x98, 0x68, 0xf0, 0x06, 0xce, 0xf7,
	0x6f, 0x4a, 0x59, 0xae, 0x58, 0xaf, 0x69, 0x59, 0xae, 0x50, 0x37, 0x94, 0x7d, 0xc8, 0xd7, 0x5c,
	0xdd, 0xb4, 0x45, 0x21, 0x17, 0x20, 0xe1, 0xd8, 0xb4, 0x2c, 0x29, 0x2d, 0xe1, 0xd8, 0x24, 0x24,
	0xe7, 0xec, 0x8c, 0x12, 0x82, 0x94, 0x46, 0x86, 0xe4, 0x89, 0xf2, 0xce, 0x7b, 0xbe, 0xe1, 0xfc,
	0xc4, 0x16, 0x7d, 0x5d, 0xcc, 0x95, 0x12, 0xcc, 0x73, 0x6b, 0xdc, 0x99, 0x88, 0x39, 0xe5, 0x5b,
	0xb0, 0xd8, 0xc0, 0x3e, 0xb9, 0x4a, 0x5e, 0x1c, 0x74, 0xfe, 0x92, 0xa0, 0xb7, 0x84, 0xeb, 0x71,
	0x5b, 0xcd, 0xe9, 0x6f, 0xc9, 0x90, 0x81, 0x57, 0x02, 0xa7, 0x31, 0x16, 0x38, 0x59, 0x01, 0x9c,
	0x71, 0x24, 0x67, 0x1d, 0x72, 0x82, 0x63, 0x11, 0x16, 0x91, 0xa4, 0x4b, 0x61, 0x51, 0xd1, 0x99,
	0x00, 0x25, 0x7b, 0xc3, 0x28, 0xd9, 0x9a, 0x26, 0xa8, 0x11, 0x90, 0x2c, 0xc2, 0xfc, 0x13, 0xac,
	0x5b, 0xfe, 0xb9, 0xc0, 0x88, 0x0c, 0x0b, 0x42, 0xc0, 0x6f, 0xf0, 0x12, 0x2c, 0xee, 0xf3, 0x6f,
	0x6a, 0xa1, 0x74, 0x0c, 0xf2, 0x40, 0xc4, 0x13, 0xbe, 0x0d, 0x20, 0x3e, 0xbd, 0x83, 0x84, 0xdf,
	0x19, 0x43, 0x07, 0xc4, 0x46, 0xc1, 0x84, 0x07, 0x9b, 0x94, 0x2a, 0x2c, 0x6a, 0x84, 0x9e, 0xec,
	0x3b, 0x6d, 0x51, 0xef, 0xdb, 0x90, 0x61, 0x24, 0x86, 0xa3, 0x33, 0xa9, 0xcd, 0xd1, 0x79, 0xb8,
	0x3f, 0x25, 0xc2, 0xfd, 0x49, 0x03, 0x79, 0x60, 0x83, 0xbb, 0xf6, 0xdd, 0x48, 0x83, 0x5a, 0x1f,
	0xe3, 0x96, 0xd8, 0x34, 0xa6, 0x23, 0x29, 0x1b, 0x20, 0x7f, 0xd4, 0xc3, 0xee, 0xf5, 0x87, 0x96,
	0x1e, 0x40, 0x7f, 0x19, 0x52, 0x97, 0x44, 0x26, 0xaa, 0x4e, 0x27, 0x4a, 0x17, 0x96, 0x42, 0x9a,
	0xfc, 0xf8, 0x1f, 0xc2, 0x1d, 0xc3, 0xf4, 0x7c, 0xef, 0xd2, 0x6a, 0x76, 0xcf, 0xaf, 0x3d, 0xb3,
	0xa5, 0x5b, 0x4d, 0xaa, 0xde, 0xec, 0x5a, 0xba, 0xcd, 0x2f, 0xdd, 0x6a, 0xff, 0xa6, 0x54, 0xa8,
	0x99, 0x9e, 0xdf, 0xf8, 0x68, 0xff, 0x43, 0xae, 0x35, 0x30, 0x55, 0xe0, 0x06, 0x46, 0x56, 0x36,
	0x9f, 0xc2, 0xca, 0xf8, 0x2f, 0x01, 0x94, 0x83, 0xb9, 0xe3, 0xc3, 0xa7, 0x87, 0xdf, 0xff, 0xf8,
	0x50, 0x9e, 0x21, 0x93, 0x9d, 0xfd, 0xe3, 0xc6, 0xd1, 0xae, 0x26, 0x4b, 0x28, 0x0f, 0x99, 0xda,
	0xf6, 0xd1, 0x76, 0x75, 0xbb, 0xb1, 0x2b, 0x27, 0x50, 0x16, 0x52, 0x47, 0xdb, 0xd5, 0xfd, 0x5d,
	0x39, 0xb9, 0x79, 0x17, 0xb2, 0xf4, 0x46, 0x1e, 0x10, 0x6e, 0x04, 0x90, 0xde, 0xd9, 0xaf, 0xef,
	0x1e, 0x1e, 0xc9, 0x33, 0x64, 0xbc, 0xbf, 0xbb, 0xdd, 0xd8, 0x6d, 0xc8, 0x52, 0xe5, 0x37, 0x32,
	0xa4, 0xb6, 0x8d, 0x8e, 0x69, 0x23, 0x1f, 0x52, 0x94, 0xaa, 0xa0, 0xb7, 0x5e, 0x4d, 0x66, 0x68,
	0xd6, 0x8a, 0x1b, 0x93, 0xb2, 0x1e, 0xa5, 0xf0, 0xf9, 0xdf, 0xff, 0xfb, 0xdb, 0x04, 0x42, 0xb2,
	0xda, 0xa4, 0x7f, 0x32, 0xa9, 0x57, 0x5b, 0x2a, 0x65, 0x3f, 0xe8, 0x97, 0x12, 0x64, 0x83, 0x3f,
	0x52, 0xd0, 0xdb, 0x13, 0xfc, 0x81, 0x11, 0x1c, 0x7f, 0x7f, 0x32, 0x65, 0xee, 0xc2, 0x2a, 0x75,
	0x61, 0x05, 0x2d, 0x87, 0x5c, 0x08, 0xfe, 0x9b, 0x41, 0xbf, 0x93, 0x60, 0x31, 0xf2, 0x0f, 0x09,
	0xda, 0x9a, 0xe6, 0xdf, 0x14, 0xe6, 0x52, 0x65, 0xfa, 0x3f, 0x60, 0x94, 0xb7, 0xa8, 0x63, 0x6f,
	0xa0, 0xd2, 0x38, 0xc7, 0xd4, 0xe7, 0x62, 0xf8, 0x19, 0xfa, 0xbd, 0x04, 0xf9, 0xf0, 0x47, 0x32,
	0x2a, 0x4f, 0xfc, 0x35, 0xcd, 0xbc, 0x53, 0xa7, 0xfc, 0xfa, 0x56, 0x1e, 0x51, 0xd7, 0x1e, 0xa0,
	0xf2, 0x2b, 0x5c, 0x53, 0xe9, 0xa7, 0x8b, 0xa7, 0x3e, 0xa7, 0xbf, 0xd4, 0x53, 0x18, 0xd0, 0x79,
	0x74, 0x7f, 0x42, 0xd6, 0xcf, 0xbc, 0x7c, 0x67, 0xaa, 0x6f, 0x04, 0xe5, 0x03, 0xea, 0xe3, 0x23,
	0xf4, 0x70, 0x3a, 0x1f, 0x55, 0xf6, 0x9d, 0xf2, 0x0c, 0xd2, 0x8c, 0xc4, 0xa2, 0x8d, 0x09, 0x78,
	0x2e, 0x73, 0xf0, 0xde, 0xc4, 0x8c, 0x58, 0xb9, 0x4d, 0x9d, 0xbb, 0x85, 0x96, 0x42, 0xce, 0xb1,
	0x67, 0x88, 0x02, 0x3f, 0x20, 0x58, 0xb1, 0xc0, 0x8f, 0x52, 0xbe, 0x58, 0xe0, 0x8f, 0x72, 0x36,
	0x0e, 0x7c, 0x25, 0xec, 0x43, 0xcf, 0x24, 0x79, 0x79, 0x2c, 0x6d, 0xa2, 0x5f, 0x48, 0x90, 0xdd,
	0x9b, 0xc8, 0x8d, 0xbd, 0x69, 0xdc, 0x18, 0x61, 0x34, 0x63, 0x53, 0xc1, 0xdc, 0x40, 0x3f, 0x85,
	0x39, 0x4e, 0x50, 0x50, 0x5c, 0x6e, 0x87, 0xf9, 0x4f, 0x71, 0x73, 0x12, 0x55, 0x7e, 0x78, 0x91,
	0x1e, 0xbe, 0x8c, 0x50, 0xe8, 0x70, 0x4e, 0x84, 0xd0, 0xcf, 0x25, 0xc8, 0x88, 0xd6, 0x8a, 0x36,
	0x27, 0xea, 0xbf, 0xcc, 0x81, 0xb7, 0xa7, 0xe8, 0xd5, 0xca, 0x1d, 0xea, 0xc1, 0xd7, 0xd0, 0xad,
	0x90, 0x07, 0x9e, 0x38, 0xf5, 0x19, 0xa4, 0x59, 0x9b, 0x8e, 0x45, 0xe1, 0x50, 0x6b, 0x8f, 0x45,
	0x61, 0xa4, 0xe7, 0x8f, 0x4b, 0xfd, 0x39, 0x3b, 0x8f, 0x04, 0x2f, 0x7a, 0x78, 0x6c, 0xf0, 0x11,
	0xd2, 0x10, 0x1b, 0x7c, 0x94, 0x4d, 0x8c, 0x0d, 0x5e, 0x30, 0x05, 0x7a, 0x11, 0x82, 0x0e, 0x18,
	0x8b, 0xc0, 0x68, 0xdb, 0x8e, 0x45, 0xe0, 0x48, 0xe7, 0x1e, 0xdb, 0x01, 0x68, 0xe7, 0x26, 0x8d,
	0x1b, 0x5d, 0x43, 0x8a, 0x76, 0xcb, 0xd8, 0xf6, 0x17, 0xe6, 0xcb, 0xb1, 0xed, 0x6f, 0x88, 0x0a,
	0x8b, 0xf8, 0x95, 0x70, 0xfb, 0x33, 0x88, 0xc6, 0x63, 0x69, 0xf3, 0x81, 0x84, 0x7e, 0x2d, 0x41,
	0x46, 0x30, 0x96, 0xd8, 0x22, 0x44, 0xf8, 0x54, 0x6c, 0x11, 0xa2, 0xbc, 0x49, 0x79, 0x93, 0x3a,
	0xb1, 0x8e, 0xd6, 0x42, 0x4e, 0x50, 0xf6, 0x65, 0x39, 0x6d, 0xf5, 0xb9, 0xe0, 0x65, 0x9f, 0x55,
	0x95, 0x17, 0xff, 0x5e, 0x9b, 0x79, 0xd1, 0x5f, 0x93, 0xfe, 0xd6, 0x5f, 0x93, 0xfe, 0xd1, 0x5f,
	0x93, 0xfe, 0xd5, 0x5f, 0x93, 0xbe, 0xf8, 0xcf, 0xda, 0xcc, 0x27, 0x19, 0x61, 0xfc, 0x34, 0x4d,
	0x3f, 0x95, 0xbe, 0xfd, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2f, 0x25, 0xeb, 0x78, 0x51, 0x1a,
	0x00, 0x00,
}
