// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/storage/storagebase/proposer_kv.proto
// DO NOT EDIT!

/*
	Package storagebase is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/storage/storagebase/proposer_kv.proto
		cockroach/pkg/storage/storagebase/state.proto

	It has these top-level messages:
		Split
		Merge
		ChangeReplicas
		ReplicatedEvalResult
		WriteBatch
		RaftCommand
		ReplicaState
		RangeInfo
*/
package storagebase

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb3 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Split is emitted when a Replica commits a split trigger. It signals that the
// Replica has prepared the on-disk state for both the left and right hand
// sides of the split, and that the left hand side Replica should be updated as
// well as the right hand side created.
type Split struct {
	cockroach_roachpb1.SplitTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
	// RHSDelta holds the statistics for what was written to what is now the
	// right-hand side of the split during the batch which executed it.
	// The on-disk state of the right-hand side is already correct, but the
	// Store must learn about this delta to update its counters appropriately.
	RHSDelta cockroach_storage_engine_enginepb.MVCCStats `protobuf:"bytes,2,opt,name=rhs_delta,json=rhsDelta" json:"rhs_delta"`
}

func (m *Split) Reset()                    { *m = Split{} }
func (m *Split) String() string            { return proto.CompactTextString(m) }
func (*Split) ProtoMessage()               {}
func (*Split) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{0} }

// Merge is emitted by a Replica which commits a transaction with
// a MergeTrigger (i.e. absorbs its right neighbor).
type Merge struct {
	cockroach_roachpb1.MergeTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
}

func (m *Merge) Reset()                    { *m = Merge{} }
func (m *Merge) String() string            { return proto.CompactTextString(m) }
func (*Merge) ProtoMessage()               {}
func (*Merge) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{1} }

// ChangeReplicas is emitted by a Replica which commits a transaction with
// a ChangeReplicasTrigger.
type ChangeReplicas struct {
	cockroach_roachpb1.ChangeReplicasTrigger `protobuf:"bytes,1,opt,name=trigger,embedded=trigger" json:"trigger"`
}

func (m *ChangeReplicas) Reset()                    { *m = ChangeReplicas{} }
func (m *ChangeReplicas) String() string            { return proto.CompactTextString(m) }
func (*ChangeReplicas) ProtoMessage()               {}
func (*ChangeReplicas) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{2} }

// ReplicatedEvalResult is the structured information which together with
// a RocksDB WriteBatch constitutes the proposal payload in proposer-evaluated
// KV. For the majority of proposals, we expect ReplicatedEvalResult to be
// trivial; only changes to the metadata state (splits, merges, rebalances,
// leases, log truncation, ...) of the Replica or certain special commands must
// sideline information here based on which all Replicas must take action.
type ReplicatedEvalResult struct {
	StartKey github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,14,opt,name=start_key,json=startKey,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"start_key,omitempty"`
	EndKey   github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,15,opt,name=end_key,json=endKey,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"end_key,omitempty"`
	// Whether to block concurrent readers while processing the proposal data.
	BlockReads bool `protobuf:"varint,1,opt,name=block_reads,json=blockReads" json:"block_reads"`
	// Updates to the Replica's ReplicaState. By convention and as outlined on
	// the comment on the ReplicaState message, this field is sparsely populated
	// and any field set overwrites the corresponding field in the state, perhaps
	// which additional side effects (for instance on a descriptor update).
	State           ReplicaState                               `protobuf:"bytes,2,opt,name=state" json:"state"`
	Split           *Split                                     `protobuf:"bytes,3,opt,name=split" json:"split,omitempty"`
	Merge           *Merge                                     `protobuf:"bytes,4,opt,name=merge" json:"merge,omitempty"`
	ComputeChecksum *cockroach_roachpb3.ComputeChecksumRequest `protobuf:"bytes,5,opt,name=compute_checksum,json=computeChecksum" json:"compute_checksum,omitempty"`
	IsLeaseRequest  bool                                       `protobuf:"varint,6,opt,name=is_lease_request,json=isLeaseRequest" json:"is_lease_request"`
	IsFreeze        bool                                       `protobuf:"varint,7,opt,name=is_freeze,json=isFreeze" json:"is_freeze"`
	// Duplicates BatchRequest.Timestamp for proposer-evaluated KV. Used
	// to verify the validity of the command (for lease coverage and GC
	// threshold).
	Timestamp            cockroach_util_hlc.Timestamp `protobuf:"bytes,8,opt,name=timestamp" json:"timestamp"`
	IsConsistencyRelated bool                         `protobuf:"varint,9,opt,name=is_consistency_related,json=isConsistencyRelated" json:"is_consistency_related"`
	// The stats delta corresponding to the data in this WriteBatch. On
	// a split, contains only the contributions to the left-hand side.
	Delta          cockroach_storage_engine_enginepb.MVCCStats `protobuf:"bytes,10,opt,name=delta" json:"delta"`
	ChangeReplicas *ChangeReplicas                             `protobuf:"bytes,12,opt,name=change_replicas,json=changeReplicas" json:"change_replicas,omitempty"`
	RaftLogDelta   *int64                                      `protobuf:"varint,13,opt,name=raft_log_delta,json=raftLogDelta" json:"raft_log_delta,omitempty"`
	AddSSTable     ReplicatedEvalResult_AddSSTable             `protobuf:"bytes,16,opt,name=add_sstable,json=addSstable" json:"add_sstable"`
}

func (m *ReplicatedEvalResult) Reset()                    { *m = ReplicatedEvalResult{} }
func (m *ReplicatedEvalResult) String() string            { return proto.CompactTextString(m) }
func (*ReplicatedEvalResult) ProtoMessage()               {}
func (*ReplicatedEvalResult) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{3} }

type ReplicatedEvalResult_AddSSTable struct {
	Data []byte `protobuf:"bytes,1,opt,name=data" json:"data,omitempty"`
}

func (m *ReplicatedEvalResult_AddSSTable) Reset()         { *m = ReplicatedEvalResult_AddSSTable{} }
func (m *ReplicatedEvalResult_AddSSTable) String() string { return proto.CompactTextString(m) }
func (*ReplicatedEvalResult_AddSSTable) ProtoMessage()    {}
func (*ReplicatedEvalResult_AddSSTable) Descriptor() ([]byte, []int) {
	return fileDescriptorProposerKv, []int{3, 0}
}

// WriteBatch is the serialized representation of a RocksDB write
// batch. A wrapper message is used so that the absence of the field
// can be distinguished from a zero-length batch, and so structs
// containing pointers to it can be compared with the == operator (we
// rely on this in storage.EvalResult)
type WriteBatch struct {
	Data []byte `protobuf:"bytes,1,opt,name=data" json:"data,omitempty"`
}

func (m *WriteBatch) Reset()                    { *m = WriteBatch{} }
func (m *WriteBatch) String() string            { return proto.CompactTextString(m) }
func (*WriteBatch) ProtoMessage()               {}
func (*WriteBatch) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{4} }

// RaftCommand is the message written to the raft log. It contains
// some metadata about the proposal itself, then either a BatchRequest
// (legacy mode) or a ReplicatedEvalResult + WriteBatch
// (proposer-evaluated KV mode).
type RaftCommand struct {
	// proposer_replica is the replica which proposed this command, to be
	// used for lease validation.
	ProposerReplica cockroach_roachpb.ReplicaDescriptor `protobuf:"bytes,2,opt,name=proposer_replica,json=proposerReplica" json:"proposer_replica"`
	// proposer_lease is provided to verify at raft command apply-time that
	// the lease under which the command was proposed remains in effect.
	//
	// To see why lease verification downstream of Raft is required, consider the
	// following example:
	// - replica 1 receives a client request for a write
	// - replica 1 checks the lease; the write is permitted
	// - replica 1 proposes the command
	// - time passes, replica 2 commits a new lease
	// - the command applies on replica 1
	// - replica 2 serves anomalous reads which don't see the write
	// - the command applies on replica 2
	ProposerLease cockroach_roachpb1.Lease `protobuf:"bytes,5,opt,name=proposer_lease,json=proposerLease" json:"proposer_lease"`
	// When the command is applied, its result is an error if the lease log
	// counter has already reached (or exceeded) max_lease_index.
	//
	// The lease index is a reorder protection mechanism - we don't want Raft
	// commands (proposed by a single node, the one with proposer_lease) executing
	// in a different order than the one in which the corresponding KV requests
	// were evaluated and the commands were proposed. This is important because
	// the CommandQueue does not fully serialize commands - mostly when it comes
	// to updates to the internal state of the range (this should be re-evaluated
	// once proposer-evaluated KV is completed - see #10413).
	// Similar to the Raft applied index, it is strictly increasing, but may have
	// gaps. A command will only apply successfully if its max_lease_index has not
	// been surpassed by the Range's applied lease index (in which case the
	// command may need to be retried, that is, regenerated with a higher
	// max_lease_index). When the command applies, the new lease index will
	// increase to max_lease_index (so a potential later replay will fail).
	//
	// This mechanism was introduced as a simpler alternative to using the Raft
	// applied index, which is fraught with complexity due to the need to predict
	// exactly the log position at which a command will apply, even when the Raft
	// leader is not colocated with the lease holder (which usually proposes all
	// commands).
	//
	// Pinning the lease-index to the assigned slot (as opposed to allowing gaps
	// as we do now) is an interesting venue to explore from the standpoint of
	// parallelization: One could hope to enforce command ordering in that way
	// (without recourse to a higher-level locking primitive such as the command
	// queue). This is a hard problem: First of all, managing the pending
	// commands gets more involved; a command must not be removed if others have
	// been added after it, and on removal, the assignment counters must be
	// updated accordingly. Managing retry of proposals becomes trickier as
	// well as that uproots whatever ordering was originally envisioned.
	MaxLeaseIndex uint64 `protobuf:"varint,4,opt,name=max_lease_index,json=maxLeaseIndex" json:"max_lease_index"`
	// testing_batch_request is the KV request that generated this Raft command.
	//
	// TODO(bdarnell): This used to be a pre-proposer-evaluated-kv field; we're
	// now exclusively proposer-evaluated, but it is still needed by certain tests
	// that use TestingEvalFilter. See #10493.
	TestingBatchRequest  *cockroach_roachpb3.BatchRequest `protobuf:"bytes,3,opt,name=testing_batch_request,json=testingBatchRequest" json:"testing_batch_request,omitempty"`
	ReplicatedEvalResult ReplicatedEvalResult             `protobuf:"bytes,13,opt,name=replicated_eval_result,json=replicatedEvalResult" json:"replicated_eval_result"`
	WriteBatch           *WriteBatch                      `protobuf:"bytes,14,opt,name=write_batch,json=writeBatch" json:"write_batch,omitempty"`
}

func (m *RaftCommand) Reset()                    { *m = RaftCommand{} }
func (m *RaftCommand) String() string            { return proto.CompactTextString(m) }
func (*RaftCommand) ProtoMessage()               {}
func (*RaftCommand) Descriptor() ([]byte, []int) { return fileDescriptorProposerKv, []int{5} }

func init() {
	proto.RegisterType((*Split)(nil), "cockroach.storage.storagebase.Split")
	proto.RegisterType((*Merge)(nil), "cockroach.storage.storagebase.Merge")
	proto.RegisterType((*ChangeReplicas)(nil), "cockroach.storage.storagebase.ChangeReplicas")
	proto.RegisterType((*ReplicatedEvalResult)(nil), "cockroach.storage.storagebase.ReplicatedEvalResult")
	proto.RegisterType((*ReplicatedEvalResult_AddSSTable)(nil), "cockroach.storage.storagebase.ReplicatedEvalResult.AddSSTable")
	proto.RegisterType((*WriteBatch)(nil), "cockroach.storage.storagebase.WriteBatch")
	proto.RegisterType((*RaftCommand)(nil), "cockroach.storage.storagebase.RaftCommand")
}
func (m *Split) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Split) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.SplitTrigger.Size()))
	n1, err := m.SplitTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.RHSDelta.Size()))
	n2, err := m.RHSDelta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *Merge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Merge) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.MergeTrigger.Size()))
	n3, err := m.MergeTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *ChangeReplicas) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeReplicas) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ChangeReplicasTrigger.Size()))
	n4, err := m.ChangeReplicasTrigger.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *ReplicatedEvalResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedEvalResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	if m.BlockReads {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x12
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.State.Size()))
	n5, err := m.State.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.Split != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.Split.Size()))
		n6, err := m.Split.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Merge != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.Merge.Size()))
		n7, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.ComputeChecksum != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n8, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	dAtA[i] = 0x30
	i++
	if m.IsLeaseRequest {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x38
	i++
	if m.IsFreeze {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x42
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.Timestamp.Size()))
	n9, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x48
	i++
	if m.IsConsistencyRelated {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x52
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.Delta.Size()))
	n10, err := m.Delta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.ChangeReplicas != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.ChangeReplicas.Size()))
		n11, err := m.ChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.RaftLogDelta != nil {
		dAtA[i] = 0x68
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(*m.RaftLogDelta))
	}
	if m.StartKey != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	dAtA[i] = 0x82
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.AddSSTable.Size()))
	n12, err := m.AddSSTable.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	return i, nil
}

func (m *ReplicatedEvalResult_AddSSTable) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicatedEvalResult_AddSSTable) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *WriteBatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *RaftCommand) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftCommand) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ProposerReplica.Size()))
	n13, err := m.ProposerReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	if m.TestingBatchRequest != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.TestingBatchRequest.Size()))
		n14, err := m.TestingBatchRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.MaxLeaseIndex))
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ProposerLease.Size()))
	n15, err := m.ProposerLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	dAtA[i] = 0x6a
	i++
	i = encodeVarintProposerKv(dAtA, i, uint64(m.ReplicatedEvalResult.Size()))
	n16, err := m.ReplicatedEvalResult.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	if m.WriteBatch != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintProposerKv(dAtA, i, uint64(m.WriteBatch.Size()))
		n17, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func encodeFixed64ProposerKv(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32ProposerKv(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintProposerKv(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Split) Size() (n int) {
	var l int
	_ = l
	l = m.SplitTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	l = m.RHSDelta.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *Merge) Size() (n int) {
	var l int
	_ = l
	l = m.MergeTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ChangeReplicas) Size() (n int) {
	var l int
	_ = l
	l = m.ChangeReplicasTrigger.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ReplicatedEvalResult) Size() (n int) {
	var l int
	_ = l
	n += 2
	l = m.State.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.Split != nil {
		l = m.Split.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	n += 2
	n += 2
	l = m.Timestamp.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	n += 2
	l = m.Delta.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.ChangeReplicas != nil {
		l = m.ChangeReplicas.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.RaftLogDelta != nil {
		n += 1 + sovProposerKv(uint64(*m.RaftLogDelta))
	}
	if m.StartKey != nil {
		l = len(m.StartKey)
		n += 1 + l + sovProposerKv(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovProposerKv(uint64(l))
	}
	l = m.AddSSTable.Size()
	n += 2 + l + sovProposerKv(uint64(l))
	return n
}

func (m *ReplicatedEvalResult_AddSSTable) Size() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovProposerKv(uint64(l))
	}
	return n
}

func (m *WriteBatch) Size() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovProposerKv(uint64(l))
	}
	return n
}

func (m *RaftCommand) Size() (n int) {
	var l int
	_ = l
	l = m.ProposerReplica.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.TestingBatchRequest != nil {
		l = m.TestingBatchRequest.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	n += 1 + sovProposerKv(uint64(m.MaxLeaseIndex))
	l = m.ProposerLease.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	l = m.ReplicatedEvalResult.Size()
	n += 1 + l + sovProposerKv(uint64(l))
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 1 + l + sovProposerKv(uint64(l))
	}
	return n
}

func sovProposerKv(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozProposerKv(x uint64) (n int) {
	return sovProposerKv(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Split) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Split: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Split: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SplitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RHSDelta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RHSDelta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Merge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Merge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Merge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MergeTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeReplicas) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeReplicas: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeReplicas: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicasTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChangeReplicasTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedEvalResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicatedEvalResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicatedEvalResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockReads", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BlockReads = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Split", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Split == nil {
				m.Split = &Split{}
			}
			if err := m.Split.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Merge == nil {
				m.Merge = &Merge{}
			}
			if err := m.Merge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ComputeChecksum == nil {
				m.ComputeChecksum = &cockroach_roachpb3.ComputeChecksumRequest{}
			}
			if err := m.ComputeChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLeaseRequest", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLeaseRequest = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFreeze", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFreeze = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsConsistencyRelated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsConsistencyRelated = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Delta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeReplicas == nil {
				m.ChangeReplicas = &ChangeReplicas{}
			}
			if err := m.ChangeReplicas.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogDelta", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RaftLogDelta = &v
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSSTable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AddSSTable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicatedEvalResult_AddSSTable) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftCommand) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftCommand: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftCommand: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposerReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TestingBatchRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TestingBatchRequest == nil {
				m.TestingBatchRequest = &cockroach_roachpb3.BatchRequest{}
			}
			if err := m.TestingBatchRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxLeaseIndex", wireType)
			}
			m.MaxLeaseIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxLeaseIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposerLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ProposerLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicatedEvalResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReplicatedEvalResult.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProposerKv
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteBatch == nil {
				m.WriteBatch = &WriteBatch{}
			}
			if err := m.WriteBatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProposerKv(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProposerKv
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProposerKv(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProposerKv
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProposerKv
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthProposerKv
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProposerKv
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProposerKv(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProposerKv = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProposerKv   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("cockroach/pkg/storage/storagebase/proposer_kv.proto", fileDescriptorProposerKv)
}

var fileDescriptorProposerKv = []byte{
	// 969 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xcf, 0x36, 0x71, 0xb2, 0x1e, 0xa7, 0xb6, 0x35, 0x84, 0x6a, 0x15, 0xa9, 0xb6, 0xb1, 0x52,
	0x14, 0x44, 0xbb, 0x86, 0x56, 0x5c, 0x7a, 0x40, 0xaa, 0xdd, 0x42, 0x49, 0xd3, 0x1c, 0xc6, 0xa1,
	0x48, 0x20, 0xb1, 0x1a, 0xcf, 0xbe, 0xac, 0x57, 0xde, 0x7f, 0xcc, 0x8c, 0xd3, 0x84, 0x4f, 0x01,
	0x5f, 0x00, 0xce, 0x1c, 0xf9, 0x16, 0x39, 0xf6, 0xc8, 0x29, 0x02, 0xf3, 0x29, 0xe0, 0x84, 0x66,
	0x76, 0xd6, 0x7f, 0x60, 0xdb, 0x44, 0xe5, 0xb4, 0xa3, 0x37, 0xbf, 0xdf, 0x6f, 0xde, 0xbc, 0x37,
	0xbf, 0xb7, 0xe8, 0x01, 0x4b, 0xd9, 0x84, 0xa7, 0x94, 0x8d, 0x7b, 0xd9, 0x24, 0xe8, 0x09, 0x99,
	0x72, 0x1a, 0x40, 0xf1, 0x1d, 0x51, 0x01, 0xbd, 0x8c, 0xa7, 0x59, 0x2a, 0x80, 0x7b, 0x93, 0x53,
	0x37, 0xe3, 0xa9, 0x4c, 0xf1, 0xed, 0x39, 0xc9, 0x35, 0x40, 0x77, 0x89, 0xb0, 0xdb, 0x5e, 0xd5,
	0xd4, 0xab, 0x6c, 0xd4, 0xa3, 0x59, 0x98, 0xf3, 0x77, 0x3b, 0xe5, 0x00, 0x9f, 0x4a, 0x6a, 0x10,
	0x7b, 0xe5, 0x88, 0x18, 0x24, 0x5d, 0x42, 0x7d, 0x54, 0x9e, 0x3c, 0x24, 0x41, 0x98, 0x14, 0x1f,
	0xc5, 0x3a, 0x65, 0xcc, 0x30, 0xee, 0x5d, 0x7d, 0x5d, 0x21, 0xa9, 0x04, 0x03, 0x7f, 0x7f, 0x15,
	0x3e, 0x95, 0x61, 0xd4, 0x1b, 0x47, 0xac, 0x27, 0xc3, 0x18, 0x84, 0xa4, 0x71, 0x66, 0x70, 0x3b,
	0x41, 0x1a, 0xa4, 0x7a, 0xd9, 0x53, 0xab, 0x3c, 0xda, 0xfd, 0xc5, 0x42, 0x95, 0x61, 0x16, 0x85,
	0x12, 0x0f, 0xd0, 0x96, 0xe4, 0x61, 0x10, 0x00, 0x77, 0xac, 0x8e, 0xb5, 0x5f, 0xbb, 0xdf, 0x76,
	0x17, 0x25, 0x34, 0x97, 0x73, 0x35, 0xf4, 0x38, 0x87, 0xf5, 0xed, 0x8b, 0xcb, 0xf6, 0xda, 0xab,
	0xcb, 0xb6, 0x45, 0x0a, 0x26, 0xfe, 0x06, 0x55, 0xf9, 0x58, 0x78, 0x3e, 0x44, 0x92, 0x3a, 0x37,
	0xb4, 0xcc, 0x5d, 0xf7, 0xbf, 0x9d, 0xc8, 0xaf, 0xed, 0x16, 0xb7, 0x77, 0x9f, 0xbf, 0x18, 0x0c,
	0x86, 0x92, 0x4a, 0xd1, 0x6f, 0x2a, 0xcd, 0xd9, 0x65, 0xdb, 0x26, 0x4f, 0x87, 0x8f, 0x95, 0x0a,
	0xb1, 0xf9, 0x58, 0xe8, 0x55, 0xf7, 0x10, 0x55, 0x9e, 0x03, 0x0f, 0xe0, 0x7a, 0xa9, 0x6a, 0xe8,
	0xeb, 0x53, 0xed, 0x7e, 0x8b, 0xea, 0x83, 0x31, 0x4d, 0x02, 0x20, 0x90, 0x45, 0x21, 0xa3, 0x02,
	0x1f, 0xfe, 0x5b, 0x76, 0xbf, 0x44, 0x76, 0x95, 0xf3, 0x06, 0xfd, 0x5f, 0x6d, 0xb4, 0x63, 0x60,
	0x12, 0xfc, 0x27, 0xa7, 0x34, 0x22, 0x20, 0xa6, 0x91, 0xc4, 0x77, 0x50, 0x6d, 0x14, 0xa5, 0x6c,
	0xe2, 0x71, 0xa0, 0xbe, 0xd0, 0x47, 0xd9, 0xfd, 0x0d, 0x25, 0x40, 0x90, 0xde, 0x20, 0x2a, 0x8e,
	0x3f, 0x47, 0x15, 0xdd, 0x66, 0x53, 0xc6, 0x0f, 0xdd, 0x37, 0x3e, 0x68, 0xd7, 0x1c, 0xa5, 0xaa,
	0x08, 0x46, 0x2d, 0xe7, 0xe3, 0x87, 0xa8, 0x22, 0x54, 0xdb, 0x9c, 0x75, 0x2d, 0xb4, 0x77, 0x85,
	0x90, 0x6e, 0x31, 0xc9, 0x29, 0x8a, 0x1b, 0xab, 0x3a, 0x3a, 0x1b, 0xd7, 0xe2, 0xea, 0x9a, 0x93,
	0x9c, 0x82, 0x8f, 0x51, 0x93, 0xa5, 0x71, 0x36, 0x95, 0xe0, 0xb1, 0x31, 0xb0, 0x89, 0x98, 0xc6,
	0x4e, 0x45, 0xcb, 0x7c, 0x50, 0x56, 0xd7, 0x1c, 0x3a, 0x30, 0x48, 0x02, 0xdf, 0x4d, 0x41, 0x48,
	0xd2, 0x60, 0xab, 0x71, 0xec, 0xa2, 0x66, 0x28, 0xbc, 0x08, 0xa8, 0x00, 0x8f, 0xe7, 0x20, 0x67,
	0x73, 0xa9, 0x84, 0xf5, 0x50, 0x1c, 0xaa, 0x4d, 0x23, 0x80, 0xdf, 0x43, 0xd5, 0x50, 0x78, 0x27,
	0x1c, 0xe0, 0x7b, 0x70, 0xb6, 0x96, 0x80, 0x76, 0x28, 0x3e, 0xd3, 0x51, 0xfc, 0x08, 0x55, 0xe7,
	0x66, 0x71, 0x6c, 0x9d, 0xe1, 0xed, 0xa5, 0x0c, 0x95, 0xa3, 0xdc, 0x71, 0xc4, 0xdc, 0xe3, 0x02,
	0x64, 0x14, 0x16, 0x2c, 0xfc, 0x10, 0xdd, 0x0a, 0x85, 0xc7, 0xd2, 0x44, 0x84, 0x42, 0x42, 0xc2,
	0xce, 0x3d, 0x0e, 0x91, 0xea, 0xbb, 0x53, 0x5d, 0x3a, 0x72, 0x27, 0x14, 0x83, 0x05, 0x84, 0xe4,
	0x08, 0xfc, 0x14, 0x55, 0x72, 0xbf, 0xa0, 0xb7, 0xf0, 0x8b, 0xe9, 0xb4, 0x16, 0xc0, 0x2f, 0x50,
	0x83, 0xe9, 0xe7, 0xe9, 0x71, 0xf3, 0x3e, 0x9d, 0x6d, 0xad, 0x79, 0xef, 0x8a, 0xbe, 0xad, 0x3e,
	0x6a, 0x52, 0x67, 0xab, 0xc6, 0xd8, 0x43, 0x75, 0x4e, 0x4f, 0xa4, 0x17, 0xa5, 0x81, 0xb1, 0xf6,
	0xcd, 0x8e, 0xb5, 0xbf, 0x4e, 0xb6, 0x55, 0xf4, 0x30, 0x0d, 0xb4, 0x3d, 0x31, 0x41, 0x55, 0x21,
	0x29, 0x97, 0xde, 0x04, 0xce, 0x9d, 0x7a, 0xc7, 0xda, 0xdf, 0xee, 0x7f, 0xf2, 0xf7, 0x65, 0xfb,
	0xe3, 0x20, 0x94, 0xe3, 0xe9, 0xc8, 0x65, 0x69, 0xdc, 0x9b, 0x67, 0xe1, 0x8f, 0x7a, 0xa5, 0xd3,
	0xd3, 0x25, 0xcf, 0xe0, 0x9c, 0xd8, 0x5a, 0xe7, 0x19, 0x9c, 0xe3, 0x23, 0xb4, 0x05, 0x89, 0xaf,
	0x15, 0x1b, 0xff, 0x47, 0x71, 0x13, 0x12, 0x5f, 0xe9, 0x09, 0x54, 0xa3, 0xbe, 0xef, 0x09, 0x21,
	0xe9, 0x28, 0x02, 0xa7, 0xa9, 0xab, 0xf3, 0xe9, 0xf5, 0xac, 0xb5, 0xe2, 0x62, 0xf7, 0x91, 0xef,
	0x0f, 0x87, 0xc7, 0x4a, 0xa5, 0x8f, 0xcd, 0xcc, 0x42, 0x8b, 0x18, 0x41, 0xd4, 0xf7, 0x87, 0xf9,
	0x29, 0xbb, 0x1d, 0xb4, 0xb4, 0x83, 0x31, 0xda, 0x50, 0xbf, 0x07, 0xed, 0xfb, 0x6d, 0xa2, 0xd7,
	0x07, 0x9b, 0xf6, 0x8f, 0x47, 0xcd, 0x9f, 0x8e, 0xba, 0x1d, 0x84, 0xbe, 0xe2, 0xa1, 0x84, 0x3e,
	0x95, 0x6c, 0x5c, 0x86, 0xec, 0xfe, 0xb5, 0x8e, 0x6a, 0x84, 0x9e, 0xc8, 0x41, 0x1a, 0xc7, 0x34,
	0xf1, 0xf1, 0x97, 0xa8, 0x39, 0xff, 0xf7, 0x99, 0xa6, 0x9b, 0x81, 0xb1, 0x57, 0x62, 0x32, 0x73,
	0x93, 0xc7, 0x20, 0x18, 0x0f, 0x33, 0x99, 0x72, 0xf3, 0x7e, 0x1a, 0x85, 0x86, 0x01, 0xe0, 0x21,
	0x7a, 0x57, 0x82, 0x90, 0x61, 0x12, 0x78, 0x23, 0x95, 0xcb, 0xdc, 0x6a, 0xeb, 0xaf, 0x9d, 0xb7,
	0x3a, 0xe7, 0xc2, 0xb6, 0xef, 0x18, 0xf6, 0x72, 0x10, 0xdf, 0x45, 0x8d, 0x98, 0x9e, 0x19, 0xef,
	0x86, 0x89, 0x0f, 0x67, 0x7a, 0xac, 0x6c, 0x98, 0x24, 0x6e, 0xc6, 0xf4, 0x4c, 0x5b, 0xf7, 0x0b,
	0xb5, 0x85, 0x9f, 0xa0, 0xfa, 0xfc, 0x66, 0x9a, 0x62, 0x86, 0x87, 0x53, 0x72, 0xb6, 0xa6, 0x15,
	0x32, 0x05, 0x4b, 0x07, 0x71, 0x8a, 0x6e, 0xf1, 0x79, 0xff, 0x3c, 0x38, 0xa5, 0x91, 0xc7, 0x75,
	0x07, 0xf5, 0x1b, 0xae, 0xdd, 0x7f, 0xf0, 0x16, 0xcd, 0x2f, 0xec, 0xcc, 0xcb, 0xc6, 0xfb, 0x01,
	0xaa, 0xbd, 0x54, 0x3d, 0xcc, 0x0b, 0xa7, 0x8d, 0xb0, 0x3a, 0xf1, 0xca, 0x4e, 0x59, 0x74, 0x9d,
	0xa0, 0x97, 0xf3, 0xf5, 0xc1, 0x86, 0x6d, 0x35, 0x6f, 0xe4, 0xaf, 0xe3, 0xe7, 0xa3, 0xfe, 0x9d,
	0x8b, 0x3f, 0x5a, 0x6b, 0x17, 0xb3, 0x96, 0xf5, 0x6a, 0xd6, 0xb2, 0x7e, 0x9b, 0xb5, 0xac, 0xdf,
	0x67, 0x2d, 0xeb, 0x87, 0x3f, 0x5b, 0x6b, 0x5f, 0xd7, 0x96, 0xb4, 0xfe, 0x09, 0x00, 0x00, 0xff,
	0xff, 0xe0, 0xde, 0x36, 0xe0, 0x2f, 0x09, 0x00, 0x00,
}
