// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/gossip/gossip.proto
// DO NOT EDIT!

/*
	Package gossip is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/gossip/gossip.proto

	It has these top-level messages:
		BootstrapInfo
		Request
		Response
		InfoStatus
		Info
*/
package gossip

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// BootstrapInfo contains information necessary to bootstrap the
// gossip network from a cold start.
type BootstrapInfo struct {
	// Addresses of other nodes in the cluster.
	Addresses []cockroach_util.UnresolvedAddr `protobuf:"bytes,1,rep,name=addresses" json:"addresses"`
	// Timestamp at which the bootstrap info was written.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *BootstrapInfo) Reset()                    { *m = BootstrapInfo{} }
func (m *BootstrapInfo) String() string            { return proto.CompactTextString(m) }
func (*BootstrapInfo) ProtoMessage()               {}
func (*BootstrapInfo) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{0} }

// Request is the request struct passed with the Gossip RPC.
type Request struct {
	// Requesting node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Address of the requesting client.
	Addr cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=addr" json:"addr"`
	// Map of high water timestamps from infos originating at other
	// nodes, as seen by the requester.
	HighWaterStamps map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,3,rep,name=high_water_stamps,json=highWaterStamps,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"high_water_stamps" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Delta of Infos originating at sender.
	Delta map[string]*Info `protobuf:"bytes,4,rep,name=delta" json:"delta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Cluster ID to prevent illegal connections.
	ClusterID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,5,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{1} }

// Response is returned from the Gossip.Gossip RPC.
// Delta will be nil in the event that Alternate is set.
type Response struct {
	// Responding Node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Address of the responding client.
	Addr cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=addr" json:"addr"`
	// Non-nil means client should retry with this address.
	AlternateAddr *cockroach_util.UnresolvedAddr `protobuf:"bytes,3,opt,name=alternate_addr,json=alternateAddr" json:"alternate_addr,omitempty"`
	// Node ID of the alternate address, if alternate_addr is not nil.
	AlternateNodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,4,opt,name=alternate_node_id,json=alternateNodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"alternate_node_id,omitempty"`
	// Delta of Infos which are fresh according to the map of Node info messages
	// passed with the request.
	Delta map[string]*Info `protobuf:"bytes,5,rep,name=delta" json:"delta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Map of high water timestamps from infos originating at other
	// nodes, as seen by the responder.
	HighWaterStamps map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,6,rep,name=high_water_stamps,json=highWaterStamps,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"high_water_stamps" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{2} }

// InfoStatus contains information about the current status of the infoStore.
type InfoStatus struct {
	Infos map[string]Info `protobuf:"bytes,1,rep,name=infos" json:"infos" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *InfoStatus) Reset()                    { *m = InfoStatus{} }
func (m *InfoStatus) String() string            { return proto.CompactTextString(m) }
func (*InfoStatus) ProtoMessage()               {}
func (*InfoStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{3} }

// Info is the basic unit of information traded over the
// gossip network.
type Info struct {
	Value cockroach_roachpb1.Value `protobuf:"bytes,1,opt,name=value" json:"value"`
	// Wall time of info when generated by originating node (Unix-nanos).
	OrigStamp int64 `protobuf:"varint,2,opt,name=orig_stamp,json=origStamp,proto3" json:"orig_stamp,omitempty"`
	// Wall time when info is to be discarded (Unix-nanos).
	TTLStamp int64 `protobuf:"varint,3,opt,name=ttl_stamp,json=ttlStamp,proto3" json:"ttl_stamp,omitempty"`
	// Number of hops from originator.
	Hops uint32 `protobuf:"varint,4,opt,name=hops,proto3" json:"hops,omitempty"`
	// Originating node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,5,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Peer node ID which passed this info.
	PeerID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,6,opt,name=peer_id,json=peerId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"peer_id,omitempty"`
}

func (m *Info) Reset()                    { *m = Info{} }
func (m *Info) String() string            { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()               {}
func (*Info) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{4} }

func init() {
	proto.RegisterType((*BootstrapInfo)(nil), "cockroach.gossip.BootstrapInfo")
	proto.RegisterType((*Request)(nil), "cockroach.gossip.Request")
	proto.RegisterType((*Response)(nil), "cockroach.gossip.Response")
	proto.RegisterType((*InfoStatus)(nil), "cockroach.gossip.InfoStatus")
	proto.RegisterType((*Info)(nil), "cockroach.gossip.Info")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Gossip service

type GossipClient interface {
	Gossip(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipClient, error)
}

type gossipClient struct {
	cc *grpc.ClientConn
}

func NewGossipClient(cc *grpc.ClientConn) GossipClient {
	return &gossipClient{cc}
}

func (c *gossipClient) Gossip(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Gossip_serviceDesc.Streams[0], c.cc, "/cockroach.gossip.Gossip/Gossip", opts...)
	if err != nil {
		return nil, err
	}
	x := &gossipGossipClient{stream}
	return x, nil
}

type Gossip_GossipClient interface {
	Send(*Request) error
	Recv() (*Response, error)
	grpc.ClientStream
}

type gossipGossipClient struct {
	grpc.ClientStream
}

func (x *gossipGossipClient) Send(m *Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gossipGossipClient) Recv() (*Response, error) {
	m := new(Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Gossip service

type GossipServer interface {
	Gossip(Gossip_GossipServer) error
}

func RegisterGossipServer(s *grpc.Server, srv GossipServer) {
	s.RegisterService(&_Gossip_serviceDesc, srv)
}

func _Gossip_Gossip_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GossipServer).Gossip(&gossipGossipServer{stream})
}

type Gossip_GossipServer interface {
	Send(*Response) error
	Recv() (*Request, error)
	grpc.ServerStream
}

type gossipGossipServer struct {
	grpc.ServerStream
}

func (x *gossipGossipServer) Send(m *Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gossipGossipServer) Recv() (*Request, error) {
	m := new(Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Gossip_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.gossip.Gossip",
	HandlerType: (*GossipServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Gossip",
			Handler:       _Gossip_Gossip_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "cockroach/pkg/gossip/gossip.proto",
}

func (m *BootstrapInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BootstrapInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, msg := range m.Addresses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Timestamp.Size()))
	n1, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Addr.Size()))
	n2, err := m.Addr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.HighWaterStamps) > 0 {
		keysForHighWaterStamps := make([]int32, 0, len(m.HighWaterStamps))
		for k := range m.HighWaterStamps {
			keysForHighWaterStamps = append(keysForHighWaterStamps, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForHighWaterStamps)
		for _, k := range keysForHighWaterStamps {
			dAtA[i] = 0x1a
			i++
			v := m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintGossip(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintGossip(dAtA, i, uint64(v))
		}
	}
	if len(m.Delta) > 0 {
		keysForDelta := make([]string, 0, len(m.Delta))
		for k := range m.Delta {
			keysForDelta = append(keysForDelta, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDelta)
		for _, k := range keysForDelta {
			dAtA[i] = 0x22
			i++
			v := m.Delta[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGossip(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.ClusterID.Size()))
	n4, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Addr.Size()))
	n5, err := m.Addr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.AlternateAddr != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.AlternateAddr.Size()))
		n6, err := m.AlternateAddr.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.AlternateNodeID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.AlternateNodeID))
	}
	if len(m.Delta) > 0 {
		keysForDelta := make([]string, 0, len(m.Delta))
		for k := range m.Delta {
			keysForDelta = append(keysForDelta, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDelta)
		for _, k := range keysForDelta {
			dAtA[i] = 0x2a
			i++
			v := m.Delta[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGossip(dAtA, i, uint64(v.Size()))
				n7, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n7
			}
		}
	}
	if len(m.HighWaterStamps) > 0 {
		keysForHighWaterStamps := make([]int32, 0, len(m.HighWaterStamps))
		for k := range m.HighWaterStamps {
			keysForHighWaterStamps = append(keysForHighWaterStamps, int32(k))
		}
		github_com_gogo_protobuf_sortkeys.Int32s(keysForHighWaterStamps)
		for _, k := range keysForHighWaterStamps {
			dAtA[i] = 0x32
			i++
			v := m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintGossip(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintGossip(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InfoStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Infos) > 0 {
		keysForInfos := make([]string, 0, len(m.Infos))
		for k := range m.Infos {
			keysForInfos = append(keysForInfos, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForInfos)
		for _, k := range keysForInfos {
			dAtA[i] = 0xa
			i++
			v := m.Infos[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGossip(dAtA, i, uint64((&v).Size()))
			n8, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n8
		}
	}
	return i, nil
}

func (m *Info) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Info) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Value.Size()))
	n9, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if m.OrigStamp != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.OrigStamp))
	}
	if m.TTLStamp != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.TTLStamp))
	}
	if m.Hops != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.Hops))
	}
	if m.NodeID != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	if m.PeerID != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.PeerID))
	}
	return i, nil
}

func encodeFixed64Gossip(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Gossip(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintGossip(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BootstrapInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, e := range m.Addresses {
			l = e.Size()
			n += 1 + l + sovGossip(uint64(l))
		}
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Request) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	l = m.Addr.Size()
	n += 1 + l + sovGossip(uint64(l))
	if len(m.HighWaterStamps) > 0 {
		for k, v := range m.HighWaterStamps {
			_ = k
			_ = v
			mapEntrySize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	if len(m.Delta) > 0 {
		for k, v := range m.Delta {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGossip(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	l = m.ClusterID.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Response) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	l = m.Addr.Size()
	n += 1 + l + sovGossip(uint64(l))
	if m.AlternateAddr != nil {
		l = m.AlternateAddr.Size()
		n += 1 + l + sovGossip(uint64(l))
	}
	if m.AlternateNodeID != 0 {
		n += 1 + sovGossip(uint64(m.AlternateNodeID))
	}
	if len(m.Delta) > 0 {
		for k, v := range m.Delta {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGossip(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	if len(m.HighWaterStamps) > 0 {
		for k, v := range m.HighWaterStamps {
			_ = k
			_ = v
			mapEntrySize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InfoStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for k, v := range m.Infos {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + 1 + l + sovGossip(uint64(l))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Info) Size() (n int) {
	var l int
	_ = l
	l = m.Value.Size()
	n += 1 + l + sovGossip(uint64(l))
	if m.OrigStamp != 0 {
		n += 1 + sovGossip(uint64(m.OrigStamp))
	}
	if m.TTLStamp != 0 {
		n += 1 + sovGossip(uint64(m.TTLStamp))
	}
	if m.Hops != 0 {
		n += 1 + sovGossip(uint64(m.Hops))
	}
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	if m.PeerID != 0 {
		n += 1 + sovGossip(uint64(m.PeerID))
	}
	return n
}

func sovGossip(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGossip(x uint64) (n int) {
	return sovGossip(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BootstrapInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BootstrapInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BootstrapInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, cockroach_util.UnresolvedAddr{})
			if err := m.Addresses[len(m.Addresses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Addr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWaterStamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var mapkey int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				mapkey |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if m.HighWaterStamps == nil {
				m.HighWaterStamps = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapvalue int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapvalue |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			} else {
				var mapvalue int64
				m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthGossip
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Delta == nil {
				m.Delta = make(map[string]*Info)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &Info{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Delta[mapkey] = mapvalue
			} else {
				var mapvalue *Info
				m.Delta[mapkey] = mapvalue
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Addr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateAddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlternateAddr == nil {
				m.AlternateAddr = &cockroach_util.UnresolvedAddr{}
			}
			if err := m.AlternateAddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateNodeID", wireType)
			}
			m.AlternateNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AlternateNodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthGossip
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Delta == nil {
				m.Delta = make(map[string]*Info)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &Info{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Delta[mapkey] = mapvalue
			} else {
				var mapvalue *Info
				m.Delta[mapkey] = mapvalue
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWaterStamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var mapkey int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				mapkey |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if m.HighWaterStamps == nil {
				m.HighWaterStamps = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapvalue int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapvalue |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			} else {
				var mapvalue int64
				m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthGossip
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Infos == nil {
				m.Infos = make(map[string]Info)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthGossip
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &Info{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Infos[mapkey] = *mapvalue
			} else {
				var mapvalue Info
				m.Infos[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Info) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Info: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Info: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigStamp", wireType)
			}
			m.OrigStamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrigStamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTLStamp", wireType)
			}
			m.TTLStamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTLStamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hops", wireType)
			}
			m.Hops = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Hops |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerID", wireType)
			}
			m.PeerID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeerID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGossip(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGossip
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGossip(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGossip = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGossip   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/gossip/gossip.proto", fileDescriptorGossip) }

var fileDescriptorGossip = []byte{
	// 800 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcf, 0x4f, 0xe3, 0x46,
	0x14, 0xce, 0x90, 0x38, 0x90, 0x01, 0x0a, 0x8c, 0x50, 0xe5, 0x46, 0x22, 0x49, 0x23, 0xda, 0xa6,
	0x52, 0x65, 0x57, 0xa1, 0x07, 0x04, 0xa7, 0x98, 0xa0, 0x92, 0xaa, 0x6a, 0x91, 0x81, 0x56, 0xe2,
	0x12, 0x39, 0x99, 0xc1, 0xb6, 0x70, 0x32, 0xae, 0x3d, 0xa6, 0xe2, 0xda, 0xbf, 0xa0, 0xa7, 0xb6,
	0xf7, 0xfe, 0x33, 0x5c, 0x56, 0x5a, 0xed, 0x69, 0xb5, 0x87, 0xec, 0xae, 0xf7, 0x5f, 0xd8, 0xd3,
	0x9e, 0x56, 0x33, 0x63, 0xe7, 0x07, 0x6b, 0x56, 0x88, 0xcd, 0x4a, 0x7b, 0xca, 0xb3, 0xe7, 0xfb,
	0xbe, 0xf9, 0xde, 0xf3, 0x7b, 0x33, 0x81, 0x5f, 0xf6, 0x69, 0xff, 0x32, 0xa0, 0x56, 0xdf, 0xd1,
	0xfd, 0x4b, 0x5b, 0xb7, 0x69, 0x18, 0xba, 0x7e, 0xf2, 0xa3, 0xf9, 0x01, 0x65, 0x14, 0xad, 0x8f,
	0x21, 0x9a, 0x7c, 0x5f, 0xae, 0xcd, 0x92, 0x44, 0xe4, 0xf7, 0x74, 0x6c, 0x31, 0x4b, 0x72, 0xca,
	0xdb, 0xd9, 0x88, 0x01, 0x61, 0xd6, 0x14, 0xea, 0xeb, 0x59, 0x54, 0xc4, 0x5c, 0x4f, 0x77, 0xbc,
	0xbe, 0xce, 0xdc, 0x01, 0x09, 0x99, 0x35, 0x48, 0x1c, 0x94, 0x1b, 0x19, 0xb8, 0x68, 0x18, 0x90,
	0x90, 0x7a, 0x57, 0x04, 0x77, 0x2d, 0x8c, 0x83, 0x04, 0xb9, 0x69, 0x53, 0x9b, 0x8a, 0x50, 0xe7,
	0x91, 0x7c, 0x5b, 0xff, 0x07, 0xc0, 0x55, 0x83, 0x52, 0x16, 0xb2, 0xc0, 0xf2, 0x3b, 0xc3, 0x0b,
	0x8a, 0x0c, 0x58, 0xe2, 0x2c, 0x12, 0x86, 0x24, 0x54, 0x41, 0x2d, 0xdf, 0x58, 0x6e, 0x56, 0xb4,
	0x49, 0x9e, 0x7c, 0x07, 0xed, 0x6c, 0xbc, 0x43, 0x0b, 0xe3, 0xc0, 0x28, 0xdc, 0x8c, 0xaa, 0x39,
	0x73, 0x42, 0x43, 0x2d, 0x58, 0x1a, 0x1b, 0x55, 0x17, 0x6a, 0xa0, 0xb1, 0xdc, 0xdc, 0xba, 0xad,
	0xe1, 0x78, 0x7d, 0xed, 0x34, 0x05, 0xa5, 0x12, 0x63, 0x56, 0xfd, 0x75, 0x01, 0x2e, 0x9a, 0xe4,
	0x8f, 0x88, 0x84, 0x0c, 0x9d, 0xc3, 0xc5, 0x21, 0xc5, 0xa4, 0xeb, 0x62, 0x15, 0xd4, 0x40, 0x43,
	0x31, 0x5a, 0xf1, 0xa8, 0x5a, 0xfc, 0x85, 0x62, 0xd2, 0x69, 0xbf, 0x19, 0x55, 0x77, 0x6c, 0x97,
	0x39, 0x51, 0x4f, 0xeb, 0xd3, 0x81, 0x3e, 0xde, 0x04, 0xf7, 0xf4, 0xcc, 0x42, 0x6b, 0x92, 0x66,
	0x16, 0xb9, 0x62, 0x07, 0xa3, 0x5d, 0x58, 0xe0, 0xbe, 0x13, 0x97, 0xf7, 0xcb, 0x54, 0x30, 0xd0,
	0xbf, 0x00, 0x6e, 0x38, 0xae, 0xed, 0x74, 0xff, 0xb4, 0x18, 0x09, 0xba, 0xc2, 0x76, 0xa8, 0xe6,
	0x45, 0xc5, 0x34, 0xed, 0x76, 0x67, 0x68, 0x49, 0x32, 0xda, 0x91, 0x6b, 0x3b, 0xbf, 0x73, 0xc6,
	0x89, 0x20, 0x1c, 0x0e, 0x59, 0x70, 0x6d, 0xec, 0x73, 0xdd, 0xbf, 0x9e, 0x3f, 0x2c, 0x95, 0x35,
	0x67, 0x56, 0x12, 0xed, 0x41, 0x05, 0x13, 0x8f, 0x59, 0x6a, 0x41, 0x98, 0xd9, 0xbe, 0xdb, 0x4c,
	0x9b, 0xc3, 0x84, 0x05, 0x53, 0x52, 0x90, 0x0d, 0x61, 0xdf, 0x8b, 0x42, 0x9e, 0x91, 0x8b, 0x55,
	0xa5, 0x06, 0x1a, 0x2b, 0xc6, 0x11, 0x77, 0xf7, 0xec, 0xbe, 0x85, 0x96, 0x3d, 0x18, 0xb9, 0x58,
	0x3b, 0x3b, 0xeb, 0xb4, 0xe3, 0x51, 0xb5, 0x74, 0x20, 0x05, 0x3b, 0x6d, 0xb3, 0x94, 0x68, 0x77,
	0x70, 0xd9, 0x80, 0x9b, 0x59, 0xa5, 0x40, 0xeb, 0x30, 0x7f, 0x49, 0xae, 0xe5, 0x87, 0x36, 0x79,
	0x88, 0x36, 0xa1, 0x72, 0x65, 0x79, 0x11, 0x11, 0xdf, 0x28, 0x6f, 0xca, 0x87, 0xbd, 0x85, 0x5d,
	0x50, 0x3e, 0x86, 0x70, 0x92, 0xc1, 0x34, 0xb3, 0x24, 0x99, 0xdf, 0x4d, 0x33, 0x97, 0x9b, 0x9f,
	0xbf, 0x5b, 0x08, 0xde, 0xf2, 0x53, 0x8a, 0xf5, 0x47, 0x0a, 0x5c, 0x32, 0x49, 0xe8, 0xd3, 0x61,
	0x48, 0x3e, 0xd1, 0xbe, 0x3b, 0x84, 0x9f, 0x59, 0x1e, 0x23, 0xc1, 0xd0, 0x62, 0x44, 0x0c, 0xb8,
	0x9a, 0xbf, 0x8f, 0x86, 0xb9, 0x3a, 0x66, 0xf1, 0x47, 0x74, 0x05, 0x37, 0x26, 0x32, 0x69, 0x9a,
	0x05, 0x91, 0xe6, 0x4f, 0xf1, 0xa8, 0xba, 0xd6, 0x4a, 0x17, 0x3f, 0x2c, 0xdf, 0x35, 0x6b, 0x46,
	0x07, 0xa3, 0xfd, 0xb4, 0x39, 0x15, 0xd1, 0x9c, 0x5f, 0x65, 0x35, 0xa7, 0xac, 0x7f, 0x46, 0x77,
	0xfe, 0x97, 0x39, 0x73, 0x45, 0xa1, 0xa4, 0xbf, 0x47, 0xe9, 0xe3, 0x0f, 0xdd, 0xfc, 0x7b, 0x71,
	0x1e, 0x13, 0x52, 0xff, 0x1f, 0x40, 0xc8, 0x75, 0x4f, 0x98, 0xc5, 0xa2, 0x10, 0x1d, 0x40, 0xc5,
	0x1d, 0x5e, 0xd0, 0xf4, 0x60, 0xff, 0x26, 0xdb, 0x84, 0x04, 0x8b, 0x30, 0x29, 0x95, 0xec, 0x3f,
	0xc9, 0xe5, 0x99, 0x4e, 0x96, 0xe6, 0x32, 0x75, 0x4f, 0x16, 0x60, 0x41, 0x5c, 0x3e, 0x3f, 0xa4,
	0x54, 0x20, 0xa8, 0xea, 0x14, 0x35, 0xad, 0xff, 0x6f, 0x7c, 0x3d, 0x35, 0x24, 0xc0, 0x68, 0x0b,
	0x42, 0x1a, 0xb8, 0x76, 0x77, 0x72, 0xdf, 0xe4, 0xcd, 0x12, 0x7f, 0x23, 0xaa, 0x86, 0xbe, 0x85,
	0x25, 0xc6, 0xbc, 0x64, 0x95, 0xcf, 0x4a, 0xde, 0x58, 0x89, 0x47, 0xd5, 0xa5, 0xd3, 0xd3, 0x9f,
	0x05, 0xc0, 0x5c, 0x62, 0xcc, 0x93, 0x50, 0x04, 0x0b, 0x0e, 0xf5, 0x43, 0x31, 0x07, 0xab, 0xa6,
	0x88, 0xa7, 0x4f, 0x01, 0x65, 0xde, 0xa7, 0xc0, 0x39, 0x5c, 0xf4, 0x89, 0x3c, 0x6a, 0x8b, 0x13,
	0xed, 0x63, 0xc2, 0x0f, 0xcb, 0x07, 0x6b, 0x73, 0xc5, 0x0e, 0x6e, 0xfe, 0x0a, 0x8b, 0x3f, 0x8a,
	0x72, 0xa3, 0xc3, 0x71, 0xf4, 0xc5, 0x9d, 0x57, 0x41, 0xb9, 0x7c, 0xf7, 0xf8, 0xd4, 0x73, 0x0d,
	0xf0, 0x3d, 0x30, 0x6a, 0x37, 0x2f, 0x2b, 0xb9, 0x9b, 0xb8, 0x02, 0x1e, 0xc7, 0x15, 0xf0, 0x34,
	0xae, 0x80, 0x17, 0x71, 0x05, 0xfc, 0xfd, 0xaa, 0x92, 0x3b, 0x2f, 0x4a, 0x42, 0xaf, 0x28, 0xfe,
	0x54, 0xec, 0xbc, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x85, 0x3c, 0xb6, 0x3b, 0x09, 0x00, 0x00,
}
