package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/servicefabric/6.4/servicefabric"

// ApplicationDefinitionKind enumerates the values for application definition kind.
type ApplicationDefinitionKind string

const (
	// Compose Indicates the application is defined by compose file(s). The value is 1.
	Compose ApplicationDefinitionKind = "Compose"
	// Invalid Indicates the application definition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is 65535.
	Invalid ApplicationDefinitionKind = "Invalid"
	// ServiceFabricApplicationDescription Indicates the application is defined by a Service Fabric application
	// description. The value is 0.
	ServiceFabricApplicationDescription ApplicationDefinitionKind = "ServiceFabricApplicationDescription"
)

// PossibleApplicationDefinitionKindValues returns an array of possible values for the ApplicationDefinitionKind const type.
func PossibleApplicationDefinitionKindValues() []ApplicationDefinitionKind {
	return []ApplicationDefinitionKind{Compose, Invalid, ServiceFabricApplicationDescription}
}

// ApplicationPackageCleanupPolicy enumerates the values for application package cleanup policy.
type ApplicationPackageCleanupPolicy string

const (
	// ApplicationPackageCleanupPolicyAutomatic Indicates that the service fabric runtime determines when to do
	// the application package cleanup. By default, cleanup is done on successful provision. The value is 2.
	ApplicationPackageCleanupPolicyAutomatic ApplicationPackageCleanupPolicy = "Automatic"
	// ApplicationPackageCleanupPolicyDefault Indicates that the cleanup policy of application packages is
	// based on the cluster setting "CleanupApplicationPackageOnProvisionSuccess." The value is 1.
	ApplicationPackageCleanupPolicyDefault ApplicationPackageCleanupPolicy = "Default"
	// ApplicationPackageCleanupPolicyInvalid Indicates that the application package cleanup policy is invalid.
	// This value is default. The value is zero.
	ApplicationPackageCleanupPolicyInvalid ApplicationPackageCleanupPolicy = "Invalid"
	// ApplicationPackageCleanupPolicyManual Indicates that the user has to explicitly clean up the application
	// package. The value is 3.
	ApplicationPackageCleanupPolicyManual ApplicationPackageCleanupPolicy = "Manual"
)

// PossibleApplicationPackageCleanupPolicyValues returns an array of possible values for the ApplicationPackageCleanupPolicy const type.
func PossibleApplicationPackageCleanupPolicyValues() []ApplicationPackageCleanupPolicy {
	return []ApplicationPackageCleanupPolicy{ApplicationPackageCleanupPolicyAutomatic, ApplicationPackageCleanupPolicyDefault, ApplicationPackageCleanupPolicyInvalid, ApplicationPackageCleanupPolicyManual}
}

// ApplicationScopedVolumeKind enumerates the values for application scoped volume kind.
type ApplicationScopedVolumeKind string

const (
	// ServiceFabricVolumeDisk Provides Service Fabric High Availability Volume Disk
	ServiceFabricVolumeDisk ApplicationScopedVolumeKind = "ServiceFabricVolumeDisk"
)

// PossibleApplicationScopedVolumeKindValues returns an array of possible values for the ApplicationScopedVolumeKind const type.
func PossibleApplicationScopedVolumeKindValues() []ApplicationScopedVolumeKind {
	return []ApplicationScopedVolumeKind{ServiceFabricVolumeDisk}
}

// ApplicationStatus enumerates the values for application status.
type ApplicationStatus string

const (
	// ApplicationStatusCreating Indicates the application status is creating. The value is 3.
	ApplicationStatusCreating ApplicationStatus = "Creating"
	// ApplicationStatusDeleting Indicates the application status is deleting. The value is 4.
	ApplicationStatusDeleting ApplicationStatus = "Deleting"
	// ApplicationStatusFailed Indicates the creation or deletion of application was terminated due to
	// persistent failures. Another create/delete request can be accepted to resume a failed application. The
	// value is 5.
	ApplicationStatusFailed ApplicationStatus = "Failed"
	// ApplicationStatusInvalid Indicates the application status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ApplicationStatusInvalid ApplicationStatus = "Invalid"
	// ApplicationStatusReady Indicates the application status is ready. The value is 1.
	ApplicationStatusReady ApplicationStatus = "Ready"
	// ApplicationStatusUpgrading Indicates the application status is upgrading. The value is 2.
	ApplicationStatusUpgrading ApplicationStatus = "Upgrading"
)

// PossibleApplicationStatusValues returns an array of possible values for the ApplicationStatus const type.
func PossibleApplicationStatusValues() []ApplicationStatus {
	return []ApplicationStatus{ApplicationStatusCreating, ApplicationStatusDeleting, ApplicationStatusFailed, ApplicationStatusInvalid, ApplicationStatusReady, ApplicationStatusUpgrading}
}

// ApplicationTypeDefinitionKind enumerates the values for application type definition kind.
type ApplicationTypeDefinitionKind string

const (
	// ApplicationTypeDefinitionKindCompose Indicates the application type is defined and created implicitly as
	// part of a compose deployment. The value is 2.
	ApplicationTypeDefinitionKindCompose ApplicationTypeDefinitionKind = "Compose"
	// ApplicationTypeDefinitionKindInvalid Indicates the application type definition kind is invalid. All
	// Service Fabric enumerations have the invalid type. The value is 0.
	ApplicationTypeDefinitionKindInvalid ApplicationTypeDefinitionKind = "Invalid"
	// ApplicationTypeDefinitionKindServiceFabricApplicationPackage Indicates the application type is defined
	// and created by a Service Fabric application package provided by the user. The value is 1.
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = "ServiceFabricApplicationPackage"
)

// PossibleApplicationTypeDefinitionKindValues returns an array of possible values for the ApplicationTypeDefinitionKind const type.
func PossibleApplicationTypeDefinitionKindValues() []ApplicationTypeDefinitionKind {
	return []ApplicationTypeDefinitionKind{ApplicationTypeDefinitionKindCompose, ApplicationTypeDefinitionKindInvalid, ApplicationTypeDefinitionKindServiceFabricApplicationPackage}
}

// ApplicationTypeStatus enumerates the values for application type status.
type ApplicationTypeStatus string

const (
	// ApplicationTypeStatusAvailable Indicates that the application type is fully provisioned and is available
	// for use. An application of this type and version can be created. The value is 2.
	ApplicationTypeStatusAvailable ApplicationTypeStatus = "Available"
	// ApplicationTypeStatusFailed Indicates that the application type provisioning failed and it is
	// unavailable for use. The failure details can be obtained from the application type information query.
	// The failed application type information remains in the cluster until it is unprovisioned or
	// reprovisioned successfully. The value is 4.
	ApplicationTypeStatusFailed ApplicationTypeStatus = "Failed"
	// ApplicationTypeStatusInvalid Indicates the application type status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ApplicationTypeStatusInvalid ApplicationTypeStatus = "Invalid"
	// ApplicationTypeStatusProvisioning Indicates that the application type is being provisioned in the
	// cluster. The value is 1.
	ApplicationTypeStatusProvisioning ApplicationTypeStatus = "Provisioning"
	// ApplicationTypeStatusUnprovisioning Indicates that the application type is in process of being
	// unprovisioned from the cluster. The value is 3.
	ApplicationTypeStatusUnprovisioning ApplicationTypeStatus = "Unprovisioning"
)

// PossibleApplicationTypeStatusValues returns an array of possible values for the ApplicationTypeStatus const type.
func PossibleApplicationTypeStatusValues() []ApplicationTypeStatus {
	return []ApplicationTypeStatus{ApplicationTypeStatusAvailable, ApplicationTypeStatusFailed, ApplicationTypeStatusInvalid, ApplicationTypeStatusProvisioning, ApplicationTypeStatusUnprovisioning}
}

// AutoScalingMechanismKind enumerates the values for auto scaling mechanism kind.
type AutoScalingMechanismKind string

const (
	// AddRemoveReplica Indicates that scaling should be performed by adding or removing replicas.
	AddRemoveReplica AutoScalingMechanismKind = "AddRemoveReplica"
)

// PossibleAutoScalingMechanismKindValues returns an array of possible values for the AutoScalingMechanismKind const type.
func PossibleAutoScalingMechanismKindValues() []AutoScalingMechanismKind {
	return []AutoScalingMechanismKind{AddRemoveReplica}
}

// AutoScalingMetricKind enumerates the values for auto scaling metric kind.
type AutoScalingMetricKind string

const (
	// Resource Indicates that the metric is one of resources, like cpu or memory.
	Resource AutoScalingMetricKind = "Resource"
)

// PossibleAutoScalingMetricKindValues returns an array of possible values for the AutoScalingMetricKind const type.
func PossibleAutoScalingMetricKindValues() []AutoScalingMetricKind {
	return []AutoScalingMetricKind{Resource}
}

// AutoScalingResourceMetricName enumerates the values for auto scaling resource metric name.
type AutoScalingResourceMetricName string

const (
	// CPU Indicates that the resource is CPU cores.
	CPU AutoScalingResourceMetricName = "cpu"
	// MemoryInGB Indicates that the resource is memory in GB.
	MemoryInGB AutoScalingResourceMetricName = "memoryInGB"
)

// PossibleAutoScalingResourceMetricNameValues returns an array of possible values for the AutoScalingResourceMetricName const type.
func PossibleAutoScalingResourceMetricNameValues() []AutoScalingResourceMetricName {
	return []AutoScalingResourceMetricName{CPU, MemoryInGB}
}

// AutoScalingTriggerKind enumerates the values for auto scaling trigger kind.
type AutoScalingTriggerKind string

const (
	// AverageLoad Indicates that scaling should be performed based on average load of all replicas in the
	// service.
	AverageLoad AutoScalingTriggerKind = "AverageLoad"
)

// PossibleAutoScalingTriggerKindValues returns an array of possible values for the AutoScalingTriggerKind const type.
func PossibleAutoScalingTriggerKindValues() []AutoScalingTriggerKind {
	return []AutoScalingTriggerKind{AverageLoad}
}

// BackupEntityKind enumerates the values for backup entity kind.
type BackupEntityKind string

const (
	// BackupEntityKindApplication Indicates the entity is a Service Fabric application.
	BackupEntityKindApplication BackupEntityKind = "Application"
	// BackupEntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the
	// invalid type.
	BackupEntityKindInvalid BackupEntityKind = "Invalid"
	// BackupEntityKindPartition Indicates the entity is a Service Fabric partition.
	BackupEntityKindPartition BackupEntityKind = "Partition"
	// BackupEntityKindService Indicates the entity is a Service Fabric service.
	BackupEntityKindService BackupEntityKind = "Service"
)

// PossibleBackupEntityKindValues returns an array of possible values for the BackupEntityKind const type.
func PossibleBackupEntityKindValues() []BackupEntityKind {
	return []BackupEntityKind{BackupEntityKindApplication, BackupEntityKindInvalid, BackupEntityKindPartition, BackupEntityKindService}
}

// BackupPolicyScope enumerates the values for backup policy scope.
type BackupPolicyScope string

const (
	// BackupPolicyScopeApplication Indicates the backup policy is applied at application level. All services
	// and partitions of the application inherit this policy unless explicitly overridden at service or
	// partition level.
	BackupPolicyScopeApplication BackupPolicyScope = "Application"
	// BackupPolicyScopeInvalid Indicates an invalid backup policy scope type. All Service Fabric enumerations
	// have the invalid type.
	BackupPolicyScopeInvalid BackupPolicyScope = "Invalid"
	// BackupPolicyScopePartition Indicates the backup policy is applied at partition level. Hence overriding
	// any policy which may have applied at partition's service or application level.
	BackupPolicyScopePartition BackupPolicyScope = "Partition"
	// BackupPolicyScopeService Indicates the backup policy is applied at service level. All partitions of the
	// service inherit this policy unless explicitly overridden at partition level.
	BackupPolicyScopeService BackupPolicyScope = "Service"
)

// PossibleBackupPolicyScopeValues returns an array of possible values for the BackupPolicyScope const type.
func PossibleBackupPolicyScopeValues() []BackupPolicyScope {
	return []BackupPolicyScope{BackupPolicyScopeApplication, BackupPolicyScopeInvalid, BackupPolicyScopePartition, BackupPolicyScopeService}
}

// BackupScheduleFrequencyType enumerates the values for backup schedule frequency type.
type BackupScheduleFrequencyType string

const (
	// BackupScheduleFrequencyTypeDaily Indicates that the time based backup schedule is repeated at a daily
	// frequency.
	BackupScheduleFrequencyTypeDaily BackupScheduleFrequencyType = "Daily"
	// BackupScheduleFrequencyTypeInvalid Indicates an invalid backup schedule frequency type. All Service
	// Fabric enumerations have the invalid type.
	BackupScheduleFrequencyTypeInvalid BackupScheduleFrequencyType = "Invalid"
	// BackupScheduleFrequencyTypeWeekly Indicates that the time based backup schedule is repeated at a weekly
	// frequency.
	BackupScheduleFrequencyTypeWeekly BackupScheduleFrequencyType = "Weekly"
)

// PossibleBackupScheduleFrequencyTypeValues returns an array of possible values for the BackupScheduleFrequencyType const type.
func PossibleBackupScheduleFrequencyTypeValues() []BackupScheduleFrequencyType {
	return []BackupScheduleFrequencyType{BackupScheduleFrequencyTypeDaily, BackupScheduleFrequencyTypeInvalid, BackupScheduleFrequencyTypeWeekly}
}

// BackupScheduleKind enumerates the values for backup schedule kind.
type BackupScheduleKind string

const (
	// BackupScheduleKindFrequencyBased Indicates a frequency-based backup schedule.
	BackupScheduleKindFrequencyBased BackupScheduleKind = "FrequencyBased"
	// BackupScheduleKindInvalid Indicates an invalid backup schedule kind. All Service Fabric enumerations
	// have the invalid type.
	BackupScheduleKindInvalid BackupScheduleKind = "Invalid"
	// BackupScheduleKindTimeBased Indicates a time-based backup schedule.
	BackupScheduleKindTimeBased BackupScheduleKind = "TimeBased"
)

// PossibleBackupScheduleKindValues returns an array of possible values for the BackupScheduleKind const type.
func PossibleBackupScheduleKindValues() []BackupScheduleKind {
	return []BackupScheduleKind{BackupScheduleKindFrequencyBased, BackupScheduleKindInvalid, BackupScheduleKindTimeBased}
}

// BackupState enumerates the values for backup state.
type BackupState string

const (
	// BackupStateAccepted Operation has been validated and accepted. Backup is yet to be triggered.
	BackupStateAccepted BackupState = "Accepted"
	// BackupStateBackupInProgress Backup operation has been triggered and is under process.
	BackupStateBackupInProgress BackupState = "BackupInProgress"
	// BackupStateFailure Operation completed with failure.
	BackupStateFailure BackupState = "Failure"
	// BackupStateInvalid Indicates an invalid backup state. All Service Fabric enumerations have the invalid
	// type.
	BackupStateInvalid BackupState = "Invalid"
	// BackupStateSuccess Operation completed with success.
	BackupStateSuccess BackupState = "Success"
	// BackupStateTimeout Operation timed out.
	BackupStateTimeout BackupState = "Timeout"
)

// PossibleBackupStateValues returns an array of possible values for the BackupState const type.
func PossibleBackupStateValues() []BackupState {
	return []BackupState{BackupStateAccepted, BackupStateBackupInProgress, BackupStateFailure, BackupStateInvalid, BackupStateSuccess, BackupStateTimeout}
}

// BackupStorageKind enumerates the values for backup storage kind.
type BackupStorageKind string

const (
	// BackupStorageKindAzureBlobStore Indicates Azure blob store to be used as backup storage.
	BackupStorageKindAzureBlobStore BackupStorageKind = "AzureBlobStore"
	// BackupStorageKindFileShare Indicates file/ SMB share to be used as backup storage.
	BackupStorageKindFileShare BackupStorageKind = "FileShare"
	// BackupStorageKindInvalid Indicates an invalid backup storage kind. All Service Fabric enumerations have
	// the invalid type.
	BackupStorageKindInvalid BackupStorageKind = "Invalid"
)

// PossibleBackupStorageKindValues returns an array of possible values for the BackupStorageKind const type.
func PossibleBackupStorageKindValues() []BackupStorageKind {
	return []BackupStorageKind{BackupStorageKindAzureBlobStore, BackupStorageKindFileShare, BackupStorageKindInvalid}
}

// BackupSuspensionScope enumerates the values for backup suspension scope.
type BackupSuspensionScope string

const (
	// BackupSuspensionScopeApplication Indicates the backup suspension is applied at application level. All
	// services and partitions of the application are hence suspended for backup.
	BackupSuspensionScopeApplication BackupSuspensionScope = "Application"
	// BackupSuspensionScopeInvalid Indicates an invalid backup suspension scope type also indicating entity is
	// not suspended. All Service Fabric enumerations have the invalid type.
	BackupSuspensionScopeInvalid BackupSuspensionScope = "Invalid"
	// BackupSuspensionScopePartition Indicates the backup suspension is applied at partition level.
	BackupSuspensionScopePartition BackupSuspensionScope = "Partition"
	// BackupSuspensionScopeService Indicates the backup suspension is applied at service level. All partitions
	// of the service are hence suspended for backup.
	BackupSuspensionScopeService BackupSuspensionScope = "Service"
)

// PossibleBackupSuspensionScopeValues returns an array of possible values for the BackupSuspensionScope const type.
func PossibleBackupSuspensionScopeValues() []BackupSuspensionScope {
	return []BackupSuspensionScope{BackupSuspensionScopeApplication, BackupSuspensionScopeInvalid, BackupSuspensionScopePartition, BackupSuspensionScopeService}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeFull Indicates a full backup.
	BackupTypeFull BackupType = "Full"
	// BackupTypeIncremental Indicates an incremental backup. A backup chain is comprised of a full backup
	// followed by 0 or more incremental backups.
	BackupTypeIncremental BackupType = "Incremental"
	// BackupTypeInvalid Indicates an invalid backup type. All Service Fabric enumerations have the invalid
	// type.
	BackupTypeInvalid BackupType = "Invalid"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeFull, BackupTypeIncremental, BackupTypeInvalid}
}

// ChaosEventKind enumerates the values for chaos event kind.
type ChaosEventKind string

const (
	// ChaosEventKindExecutingFaults Indicates a Chaos event that gets generated when Chaos has decided on the
	// faults for an iteration. This Chaos event contains the details of the faults as a list of strings.
	ChaosEventKindExecutingFaults ChaosEventKind = "ExecutingFaults"
	// ChaosEventKindInvalid Indicates an invalid Chaos event kind. All Service Fabric enumerations have the
	// invalid type.
	ChaosEventKindInvalid ChaosEventKind = "Invalid"
	// ChaosEventKindStarted Indicates a Chaos event that gets generated when Chaos is started.
	ChaosEventKindStarted ChaosEventKind = "Started"
	// ChaosEventKindStopped Indicates a Chaos event that gets generated when Chaos stops because either the
	// user issued a stop or the time to run was up.
	ChaosEventKindStopped ChaosEventKind = "Stopped"
	// ChaosEventKindTestError Indicates a Chaos event that gets generated when an unexpected event has
	// occurred in the Chaos engine, for example, due to the cluster snapshot being inconsistent, while
	// faulting a faultable entity Chaos found that the entity was already faulted.
	ChaosEventKindTestError ChaosEventKind = "TestError"
	// ChaosEventKindValidationFailed Indicates a Chaos event that gets generated when the cluster entities do
	// not become stable and healthy within ChaosParameters.MaxClusterStabilizationTimeoutInSeconds.
	ChaosEventKindValidationFailed ChaosEventKind = "ValidationFailed"
	// ChaosEventKindWaiting Indicates a Chaos event that gets generated when Chaos is waiting for the cluster
	// to become ready for faulting, for example, Chaos may be waiting for the on-going upgrade to finish.
	ChaosEventKindWaiting ChaosEventKind = "Waiting"
)

// PossibleChaosEventKindValues returns an array of possible values for the ChaosEventKind const type.
func PossibleChaosEventKindValues() []ChaosEventKind {
	return []ChaosEventKind{ChaosEventKindExecutingFaults, ChaosEventKindInvalid, ChaosEventKindStarted, ChaosEventKindStopped, ChaosEventKindTestError, ChaosEventKindValidationFailed, ChaosEventKindWaiting}
}

// ChaosScheduleStatus enumerates the values for chaos schedule status.
type ChaosScheduleStatus string

const (
	// ChaosScheduleStatusActive Indicates that the schedule is active and is being used to schedule runs of
	// Chaos. The value is two.
	ChaosScheduleStatusActive ChaosScheduleStatus = "Active"
	// ChaosScheduleStatusExpired Indicates that the schedule is expired and will no longer be used to schedule
	// runs of Chaos. The value is three.
	ChaosScheduleStatusExpired ChaosScheduleStatus = "Expired"
	// ChaosScheduleStatusInvalid Indicates an invalid Chaos Schedule status. All Service Fabric enumerations
	// have the invalid type. The valus is zero.
	ChaosScheduleStatusInvalid ChaosScheduleStatus = "Invalid"
	// ChaosScheduleStatusPending Indicates that the schedule is pending and is not yet being used to schedule
	// runs of Chaos but will be used when the start time is passed. The value is four.
	ChaosScheduleStatusPending ChaosScheduleStatus = "Pending"
	// ChaosScheduleStatusStopped Indicates that the schedule is stopped and not being used to schedule runs of
	// chaos. The value is one.
	ChaosScheduleStatusStopped ChaosScheduleStatus = "Stopped"
)

// PossibleChaosScheduleStatusValues returns an array of possible values for the ChaosScheduleStatus const type.
func PossibleChaosScheduleStatusValues() []ChaosScheduleStatus {
	return []ChaosScheduleStatus{ChaosScheduleStatusActive, ChaosScheduleStatusExpired, ChaosScheduleStatusInvalid, ChaosScheduleStatusPending, ChaosScheduleStatusStopped}
}

// ChaosStatus enumerates the values for chaos status.
type ChaosStatus string

const (
	// ChaosStatusInvalid Indicates an invalid Chaos status. All Service Fabric enumerations have the invalid
	// type. The valus is zero.
	ChaosStatusInvalid ChaosStatus = "Invalid"
	// ChaosStatusRunning Indicates that Chaos is not stopped. The value is one.
	ChaosStatusRunning ChaosStatus = "Running"
	// ChaosStatusStopped Indicates that Chaos is not scheduling further faults. The value is two.
	ChaosStatusStopped ChaosStatus = "Stopped"
)

// PossibleChaosStatusValues returns an array of possible values for the ChaosStatus const type.
func PossibleChaosStatusValues() []ChaosStatus {
	return []ChaosStatus{ChaosStatusInvalid, ChaosStatusRunning, ChaosStatusStopped}
}

// ComposeDeploymentStatus enumerates the values for compose deployment status.
type ComposeDeploymentStatus string

const (
	// ComposeDeploymentStatusCreating Indicates that the compose deployment is being created in background.
	// The value is 2.
	ComposeDeploymentStatusCreating ComposeDeploymentStatus = "Creating"
	// ComposeDeploymentStatusDeleting Indicates that the compose deployment is being deleted in background.
	// The value is 5.
	ComposeDeploymentStatusDeleting ComposeDeploymentStatus = "Deleting"
	// ComposeDeploymentStatusFailed Indicates that the compose deployment was terminated due to persistent
	// failures. The value is 6.
	ComposeDeploymentStatusFailed ComposeDeploymentStatus = "Failed"
	// ComposeDeploymentStatusInvalid Indicates that the compose deployment status is invalid. The value is
	// zero.
	ComposeDeploymentStatusInvalid ComposeDeploymentStatus = "Invalid"
	// ComposeDeploymentStatusProvisioning Indicates that the compose deployment is being provisioned in
	// background. The value is 1.
	ComposeDeploymentStatusProvisioning ComposeDeploymentStatus = "Provisioning"
	// ComposeDeploymentStatusReady Indicates that the compose deployment has been successfully created or
	// upgraded. The value is 3.
	ComposeDeploymentStatusReady ComposeDeploymentStatus = "Ready"
	// ComposeDeploymentStatusUnprovisioning Indicates that the compose deployment is being unprovisioned in
	// background. The value is 4.
	ComposeDeploymentStatusUnprovisioning ComposeDeploymentStatus = "Unprovisioning"
	// ComposeDeploymentStatusUpgrading Indicates that the compose deployment is being upgraded in the
	// background. The value is 7.
	ComposeDeploymentStatusUpgrading ComposeDeploymentStatus = "Upgrading"
)

// PossibleComposeDeploymentStatusValues returns an array of possible values for the ComposeDeploymentStatus const type.
func PossibleComposeDeploymentStatusValues() []ComposeDeploymentStatus {
	return []ComposeDeploymentStatus{ComposeDeploymentStatusCreating, ComposeDeploymentStatusDeleting, ComposeDeploymentStatusFailed, ComposeDeploymentStatusInvalid, ComposeDeploymentStatusProvisioning, ComposeDeploymentStatusReady, ComposeDeploymentStatusUnprovisioning, ComposeDeploymentStatusUpgrading}
}

// ComposeDeploymentUpgradeState enumerates the values for compose deployment upgrade state.
type ComposeDeploymentUpgradeState string

const (
	// ComposeDeploymentUpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The
	// value is 9.
	ComposeDeploymentUpgradeStateFailed ComposeDeploymentUpgradeState = "Failed"
	// ComposeDeploymentUpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ComposeDeploymentUpgradeStateInvalid ComposeDeploymentUpgradeState = "Invalid"
	// ComposeDeploymentUpgradeStateProvisioningTarget The upgrade is in the progress of provisioning target
	// application type version. The value is 1.
	ComposeDeploymentUpgradeStateProvisioningTarget ComposeDeploymentUpgradeState = "ProvisioningTarget"
	// ComposeDeploymentUpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 8.
	ComposeDeploymentUpgradeStateRollingBackCompleted ComposeDeploymentUpgradeState = "RollingBackCompleted"
	// ComposeDeploymentUpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version
	// but is not complete yet. The value is 6.
	ComposeDeploymentUpgradeStateRollingBackInProgress ComposeDeploymentUpgradeState = "RollingBackInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value
	// is 5.
	ComposeDeploymentUpgradeStateRollingForwardCompleted ComposeDeploymentUpgradeState = "RollingForwardCompleted"
	// ComposeDeploymentUpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target
	// version but is not complete yet. The value is 2.
	ComposeDeploymentUpgradeStateRollingForwardInProgress ComposeDeploymentUpgradeState = "RollingForwardInProgress"
	// ComposeDeploymentUpgradeStateRollingForwardPending The current upgrade domain has finished upgrading.
	// The overall upgrade is waiting for an explicit move next request in UnmonitoredManual mode or performing
	// health checks in Monitored mode. The value is 3
	ComposeDeploymentUpgradeStateRollingForwardPending ComposeDeploymentUpgradeState = "RollingForwardPending"
	// ComposeDeploymentUpgradeStateUnprovisioningCurrent The upgrade is in the progress of unprovisioning
	// current application type version and rolling forward to the target version is completed. The value is 4.
	ComposeDeploymentUpgradeStateUnprovisioningCurrent ComposeDeploymentUpgradeState = "UnprovisioningCurrent"
	// ComposeDeploymentUpgradeStateUnprovisioningTarget The upgrade is in the progress of unprovisioning
	// target application type version and rolling back to the current version is completed. The value is 7.
	ComposeDeploymentUpgradeStateUnprovisioningTarget ComposeDeploymentUpgradeState = "UnprovisioningTarget"
)

// PossibleComposeDeploymentUpgradeStateValues returns an array of possible values for the ComposeDeploymentUpgradeState const type.
func PossibleComposeDeploymentUpgradeStateValues() []ComposeDeploymentUpgradeState {
	return []ComposeDeploymentUpgradeState{ComposeDeploymentUpgradeStateFailed, ComposeDeploymentUpgradeStateInvalid, ComposeDeploymentUpgradeStateProvisioningTarget, ComposeDeploymentUpgradeStateRollingBackCompleted, ComposeDeploymentUpgradeStateRollingBackInProgress, ComposeDeploymentUpgradeStateRollingForwardCompleted, ComposeDeploymentUpgradeStateRollingForwardInProgress, ComposeDeploymentUpgradeStateRollingForwardPending, ComposeDeploymentUpgradeStateUnprovisioningCurrent, ComposeDeploymentUpgradeStateUnprovisioningTarget}
}

// CreateFabricDump enumerates the values for create fabric dump.
type CreateFabricDump string

const (
	// False ...
	False CreateFabricDump = "False"
	// True ...
	True CreateFabricDump = "True"
)

// PossibleCreateFabricDumpValues returns an array of possible values for the CreateFabricDump const type.
func PossibleCreateFabricDumpValues() []CreateFabricDump {
	return []CreateFabricDump{False, True}
}

// DataLossMode enumerates the values for data loss mode.
type DataLossMode string

const (
	// DataLossModeFullDataLoss FullDataLoss option will drop all the replicas which means that all the data
	// will be lost.
	DataLossModeFullDataLoss DataLossMode = "FullDataLoss"
	// DataLossModeInvalid Reserved.  Do not pass into API.
	DataLossModeInvalid DataLossMode = "Invalid"
	// DataLossModePartialDataLoss PartialDataLoss option will cause a quorum of replicas to go down,
	// triggering an OnDataLoss event in the system for the given partition.
	DataLossModePartialDataLoss DataLossMode = "PartialDataLoss"
)

// PossibleDataLossModeValues returns an array of possible values for the DataLossMode const type.
func PossibleDataLossModeValues() []DataLossMode {
	return []DataLossMode{DataLossModeFullDataLoss, DataLossModeInvalid, DataLossModePartialDataLoss}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday Indicates the Day referred is Friday.
	Friday DayOfWeek = "Friday"
	// Monday Indicates the Day referred is Monday.
	Monday DayOfWeek = "Monday"
	// Saturday Indicates the Day referred is Saturday.
	Saturday DayOfWeek = "Saturday"
	// Sunday Indicates the Day referred is Sunday.
	Sunday DayOfWeek = "Sunday"
	// Thursday Indicates the Day referred is Thursday.
	Thursday DayOfWeek = "Thursday"
	// Tuesday Indicates the Day referred is Tuesday.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday Indicates the Day referred is Wednesday.
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DeactivationIntent enumerates the values for deactivation intent.
type DeactivationIntent string

const (
	// Pause Indicates that the node should be paused. The value is 1.
	Pause DeactivationIntent = "Pause"
	// RemoveData Indicates the intent is for the node to remove data. The value is 3.
	RemoveData DeactivationIntent = "RemoveData"
	// Restart Indicates that the intent is for the node to be restarted after a short period of time. The
	// value is 2.
	Restart DeactivationIntent = "Restart"
)

// PossibleDeactivationIntentValues returns an array of possible values for the DeactivationIntent const type.
func PossibleDeactivationIntentValues() []DeactivationIntent {
	return []DeactivationIntent{Pause, RemoveData, Restart}
}

// DeployedApplicationStatus enumerates the values for deployed application status.
type DeployedApplicationStatus string

const (
	// DeployedApplicationStatusActivating Indicates that the package is activating. The value is 2.
	DeployedApplicationStatusActivating DeployedApplicationStatus = "Activating"
	// DeployedApplicationStatusActive Indicates that the package is active. The value is 3.
	DeployedApplicationStatusActive DeployedApplicationStatus = "Active"
	// DeployedApplicationStatusDeactivating Indicates that the package is deactivating. The value is 5.
	DeployedApplicationStatusDeactivating DeployedApplicationStatus = "Deactivating"
	// DeployedApplicationStatusDownloading Indicates that the package is downloading from the ImageStore. The
	// value is 1.
	DeployedApplicationStatusDownloading DeployedApplicationStatus = "Downloading"
	// DeployedApplicationStatusInvalid Indicates that deployment status is not valid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	DeployedApplicationStatusInvalid DeployedApplicationStatus = "Invalid"
	// DeployedApplicationStatusUpgrading Indicates that the package is upgrading. The value is 4.
	DeployedApplicationStatusUpgrading DeployedApplicationStatus = "Upgrading"
)

// PossibleDeployedApplicationStatusValues returns an array of possible values for the DeployedApplicationStatus const type.
func PossibleDeployedApplicationStatusValues() []DeployedApplicationStatus {
	return []DeployedApplicationStatus{DeployedApplicationStatusActivating, DeployedApplicationStatusActive, DeployedApplicationStatusDeactivating, DeployedApplicationStatusDownloading, DeployedApplicationStatusInvalid, DeployedApplicationStatusUpgrading}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusActivating Indicates the application or service package is being activated. The value is
	// 2.
	DeploymentStatusActivating DeploymentStatus = "Activating"
	// DeploymentStatusActive Indicates the application or service package is active the node. The value is 3.
	DeploymentStatusActive DeploymentStatus = "Active"
	// DeploymentStatusDeactivating Indicates the application or service package is being deactivated. The
	// value is 5.
	DeploymentStatusDeactivating DeploymentStatus = "Deactivating"
	// DeploymentStatusDownloading Indicates the application or service package is being downloaded to the node
	// from the ImageStore. The value is 1.
	DeploymentStatusDownloading DeploymentStatus = "Downloading"
	// DeploymentStatusInvalid Indicates status of the application or service package is not known or invalid.
	// The value is 0.
	DeploymentStatusInvalid DeploymentStatus = "Invalid"
	// DeploymentStatusUpgrading Indicates the application or service package is being upgraded. The value is
	// 4.
	DeploymentStatusUpgrading DeploymentStatus = "Upgrading"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusActivating, DeploymentStatusActive, DeploymentStatusDeactivating, DeploymentStatusDownloading, DeploymentStatusInvalid, DeploymentStatusUpgrading}
}

// DiagnosticsSinkKind enumerates the values for diagnostics sink kind.
type DiagnosticsSinkKind string

const (
	// DiagnosticsSinkKindAzureInternalMonitoringPipeline Diagnostics settings for Geneva.
	DiagnosticsSinkKindAzureInternalMonitoringPipeline DiagnosticsSinkKind = "AzureInternalMonitoringPipeline"
	// DiagnosticsSinkKindInvalid Indicates an invalid sink kind. All Service Fabric enumerations have the
	// invalid type.
	DiagnosticsSinkKindInvalid DiagnosticsSinkKind = "Invalid"
)

// PossibleDiagnosticsSinkKindValues returns an array of possible values for the DiagnosticsSinkKind const type.
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return []DiagnosticsSinkKind{DiagnosticsSinkKindAzureInternalMonitoringPipeline, DiagnosticsSinkKindInvalid}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// EntityKindApplication Indicates the entity is a Service Fabric application. The value is 4.
	EntityKindApplication EntityKind = "Application"
	// EntityKindCluster Indicates the entity is a Service Fabric cluster. The value is 8.
	EntityKindCluster EntityKind = "Cluster"
	// EntityKindDeployedApplication Indicates the entity is a Service Fabric deployed application. The value
	// is 6.
	EntityKindDeployedApplication EntityKind = "DeployedApplication"
	// EntityKindDeployedServicePackage Indicates the entity is a Service Fabric deployed service package. The
	// value is 7.
	EntityKindDeployedServicePackage EntityKind = "DeployedServicePackage"
	// EntityKindInvalid Indicates an invalid entity kind. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	EntityKindInvalid EntityKind = "Invalid"
	// EntityKindNode Indicates the entity is a Service Fabric node. The value is 1.
	EntityKindNode EntityKind = "Node"
	// EntityKindPartition Indicates the entity is a Service Fabric partition. The value is 2.
	EntityKindPartition EntityKind = "Partition"
	// EntityKindReplica Indicates the entity is a Service Fabric replica. The value is 5.
	EntityKindReplica EntityKind = "Replica"
	// EntityKindService Indicates the entity is a Service Fabric service. The value is 3.
	EntityKindService EntityKind = "Service"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{EntityKindApplication, EntityKindCluster, EntityKindDeployedApplication, EntityKindDeployedServicePackage, EntityKindInvalid, EntityKindNode, EntityKindPartition, EntityKindReplica, EntityKindService}
}

// EntityKindBasicBackupEntity enumerates the values for entity kind basic backup entity.
type EntityKindBasicBackupEntity string

const (
	// EntityKindApplication1 ...
	EntityKindApplication1 EntityKindBasicBackupEntity = "Application"
	// EntityKindBackupEntity ...
	EntityKindBackupEntity EntityKindBasicBackupEntity = "BackupEntity"
	// EntityKindPartition1 ...
	EntityKindPartition1 EntityKindBasicBackupEntity = "Partition"
	// EntityKindService1 ...
	EntityKindService1 EntityKindBasicBackupEntity = "Service"
)

// PossibleEntityKindBasicBackupEntityValues returns an array of possible values for the EntityKindBasicBackupEntity const type.
func PossibleEntityKindBasicBackupEntityValues() []EntityKindBasicBackupEntity {
	return []EntityKindBasicBackupEntity{EntityKindApplication1, EntityKindBackupEntity, EntityKindPartition1, EntityKindService1}
}

// EntryPointStatus enumerates the values for entry point status.
type EntryPointStatus string

const (
	// EntryPointStatusInvalid Indicates status of entry point is not known or invalid. The value is 0.
	EntryPointStatusInvalid EntryPointStatus = "Invalid"
	// EntryPointStatusPending Indicates the entry point is scheduled to be started. The value is 1.
	EntryPointStatusPending EntryPointStatus = "Pending"
	// EntryPointStatusStarted Indicates the entry point was started successfully and is running. The value is
	// 3.
	EntryPointStatusStarted EntryPointStatus = "Started"
	// EntryPointStatusStarting Indicates the entry point is being started. The value is 2.
	EntryPointStatusStarting EntryPointStatus = "Starting"
	// EntryPointStatusStopped Indicates the entry point is not running. The value is 5.
	EntryPointStatusStopped EntryPointStatus = "Stopped"
	// EntryPointStatusStopping Indicates the entry point is being stopped. The value is 4.
	EntryPointStatusStopping EntryPointStatus = "Stopping"
)

// PossibleEntryPointStatusValues returns an array of possible values for the EntryPointStatus const type.
func PossibleEntryPointStatusValues() []EntryPointStatus {
	return []EntryPointStatus{EntryPointStatusInvalid, EntryPointStatusPending, EntryPointStatusStarted, EntryPointStatusStarting, EntryPointStatusStopped, EntryPointStatusStopping}
}

// FabricErrorCodes enumerates the values for fabric error codes.
type FabricErrorCodes string

const (
	// EABORT ...
	EABORT FabricErrorCodes = "E_ABORT"
	// EFAIL ...
	EFAIL FabricErrorCodes = "E_FAIL"
	// EINVALIDARG ...
	EINVALIDARG FabricErrorCodes = "E_INVALIDARG"
	// FABRICEAPPLICATIONALREADYEXISTS ...
	FABRICEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_EXISTS"
	// FABRICEAPPLICATIONALREADYINTARGETVERSION ...
	FABRICEAPPLICATIONALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_APPLICATION_ALREADY_IN_TARGET_VERSION"
	// FABRICEAPPLICATIONNOTFOUND ...
	FABRICEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_FOUND"
	// FABRICEAPPLICATIONNOTUPGRADING ...
	FABRICEAPPLICATIONNOTUPGRADING FabricErrorCodes = "FABRIC_E_APPLICATION_NOT_UPGRADING"
	// FABRICEAPPLICATIONTYPEALREADYEXISTS ...
	FABRICEAPPLICATIONTYPEALREADYEXISTS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_ALREADY_EXISTS"
	// FABRICEAPPLICATIONTYPEINUSE ...
	FABRICEAPPLICATIONTYPEINUSE FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_IN_USE"
	// FABRICEAPPLICATIONTYPENOTFOUND ...
	FABRICEAPPLICATIONTYPENOTFOUND FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_NOT_FOUND"
	// FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS ...
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_TYPE_PROVISION_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEINPROGRESS ...
	FABRICEAPPLICATIONUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_IN_PROGRESS"
	// FABRICEAPPLICATIONUPGRADEVALIDATIONERROR ...
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_APPLICATION_UPGRADE_VALIDATION_ERROR"
	// FABRICEBACKUPINPROGRESS ...
	FABRICEBACKUPINPROGRESS FabricErrorCodes = "FABRIC_E_BACKUP_IN_PROGRESS"
	// FABRICEBACKUPISENABLED ...
	FABRICEBACKUPISENABLED FabricErrorCodes = "FABRIC_E_BACKUP_IS_ENABLED"
	// FABRICEBACKUPNOTENABLED ...
	FABRICEBACKUPNOTENABLED FabricErrorCodes = "FABRIC_E_BACKUP_NOT_ENABLED"
	// FABRICEBACKUPPOLICYALREADYEXISTING ...
	FABRICEBACKUPPOLICYALREADYEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_ALREADY_EXISTING"
	// FABRICEBACKUPPOLICYNOTEXISTING ...
	FABRICEBACKUPPOLICYNOTEXISTING FabricErrorCodes = "FABRIC_E_BACKUP_POLICY_NOT_EXISTING"
	// FABRICECOMMUNICATIONERROR ...
	FABRICECOMMUNICATIONERROR FabricErrorCodes = "FABRIC_E_COMMUNICATION_ERROR"
	// FABRICECONFIGURATIONPARAMETERNOTFOUND ...
	FABRICECONFIGURATIONPARAMETERNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_PARAMETER_NOT_FOUND"
	// FABRICECONFIGURATIONSECTIONNOTFOUND ...
	FABRICECONFIGURATIONSECTIONNOTFOUND FabricErrorCodes = "FABRIC_E_CONFIGURATION_SECTION_NOT_FOUND"
	// FABRICEDIRECTORYNOTFOUND ...
	FABRICEDIRECTORYNOTFOUND FabricErrorCodes = "FABRIC_E_DIRECTORY_NOT_FOUND"
	// FABRICEENUMERATIONCOMPLETED ...
	FABRICEENUMERATIONCOMPLETED FabricErrorCodes = "FABRIC_E_ENUMERATION_COMPLETED"
	// FABRICEFABRICALREADYINTARGETVERSION ...
	FABRICEFABRICALREADYINTARGETVERSION FabricErrorCodes = "FABRIC_E_FABRIC_ALREADY_IN_TARGET_VERSION"
	// FABRICEFABRICNOTUPGRADING ...
	FABRICEFABRICNOTUPGRADING FabricErrorCodes = "FABRIC_E_FABRIC_NOT_UPGRADING"
	// FABRICEFABRICUPGRADEINPROGRESS ...
	FABRICEFABRICUPGRADEINPROGRESS FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_IN_PROGRESS"
	// FABRICEFABRICUPGRADEVALIDATIONERROR ...
	FABRICEFABRICUPGRADEVALIDATIONERROR FabricErrorCodes = "FABRIC_E_FABRIC_UPGRADE_VALIDATION_ERROR"
	// FABRICEFABRICVERSIONALREADYEXISTS ...
	FABRICEFABRICVERSIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_ALREADY_EXISTS"
	// FABRICEFABRICVERSIONINUSE ...
	FABRICEFABRICVERSIONINUSE FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_IN_USE"
	// FABRICEFABRICVERSIONNOTFOUND ...
	FABRICEFABRICVERSIONNOTFOUND FabricErrorCodes = "FABRIC_E_FABRIC_VERSION_NOT_FOUND"
	// FABRICEFAULTANALYSISSERVICENOTEXISTING ...
	FABRICEFAULTANALYSISSERVICENOTEXISTING FabricErrorCodes = "FABRIC_E_FAULT_ANALYSIS_SERVICE_NOT_EXISTING"
	// FABRICEFILENOTFOUND ...
	FABRICEFILENOTFOUND FabricErrorCodes = "FABRIC_E_FILE_NOT_FOUND"
	// FABRICEHEALTHENTITYNOTFOUND ...
	FABRICEHEALTHENTITYNOTFOUND FabricErrorCodes = "FABRIC_E_HEALTH_ENTITY_NOT_FOUND"
	// FABRICEHEALTHSTALEREPORT ...
	FABRICEHEALTHSTALEREPORT FabricErrorCodes = "FABRIC_E_HEALTH_STALE_REPORT"
	// FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR ...
	FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR FabricErrorCodes = "FABRIC_E_IMAGEBUILDER_RESERVED_DIRECTORY_ERROR"
	// FABRICEIMAGEBUILDERVALIDATIONERROR ...
	FABRICEIMAGEBUILDERVALIDATIONERROR FabricErrorCodes = "FABRIC_E_IMAGEBUILDER_VALIDATION_ERROR"
	// FABRICEINSTANCEIDMISMATCH ...
	FABRICEINSTANCEIDMISMATCH FabricErrorCodes = "FABRIC_E_INSTANCE_ID_MISMATCH"
	// FABRICEINVALIDADDRESS ...
	FABRICEINVALIDADDRESS FabricErrorCodes = "FABRIC_E_INVALID_ADDRESS"
	// FABRICEINVALIDATOMICGROUP ...
	FABRICEINVALIDATOMICGROUP FabricErrorCodes = "FABRIC_E_INVALID_ATOMIC_GROUP"
	// FABRICEINVALIDCONFIGURATION ...
	FABRICEINVALIDCONFIGURATION FabricErrorCodes = "FABRIC_E_INVALID_CONFIGURATION"
	// FABRICEINVALIDFORSTATELESSSERVICES ...
	FABRICEINVALIDFORSTATELESSSERVICES FabricErrorCodes = "FABRIC_E_INVALID_FOR_STATELESS_SERVICES"
	// FABRICEINVALIDNAMEURI ...
	FABRICEINVALIDNAMEURI FabricErrorCodes = "FABRIC_E_INVALID_NAME_URI"
	// FABRICEINVALIDPARTITIONKEY ...
	FABRICEINVALIDPARTITIONKEY FabricErrorCodes = "FABRIC_E_INVALID_PARTITION_KEY"
	// FABRICEINVALIDSERVICESCALINGPOLICY ...
	FABRICEINVALIDSERVICESCALINGPOLICY FabricErrorCodes = "FABRIC_E_INVALID_SERVICE_SCALING_POLICY"
	// FABRICEKEYNOTFOUND ...
	FABRICEKEYNOTFOUND FabricErrorCodes = "FABRIC_E_KEY_NOT_FOUND"
	// FABRICEKEYTOOLARGE ...
	FABRICEKEYTOOLARGE FabricErrorCodes = "FABRIC_E_KEY_TOO_LARGE"
	// FABRICENAMEALREADYEXISTS ...
	FABRICENAMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_NAME_ALREADY_EXISTS"
	// FABRICENAMEDOESNOTEXIST ...
	FABRICENAMEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_NAME_DOES_NOT_EXIST"
	// FABRICENAMENOTEMPTY ...
	FABRICENAMENOTEMPTY FabricErrorCodes = "FABRIC_E_NAME_NOT_EMPTY"
	// FABRICENODEHASNOTSTOPPEDYET ...
	FABRICENODEHASNOTSTOPPEDYET FabricErrorCodes = "FABRIC_E_NODE_HAS_NOT_STOPPED_YET"
	// FABRICENODEISUP ...
	FABRICENODEISUP FabricErrorCodes = "FABRIC_E_NODE_IS_UP"
	// FABRICENODENOTFOUND ...
	FABRICENODENOTFOUND FabricErrorCodes = "FABRIC_E_NODE_NOT_FOUND"
	// FABRICENOTPRIMARY ...
	FABRICENOTPRIMARY FabricErrorCodes = "FABRIC_E_NOT_PRIMARY"
	// FABRICENOTREADY ...
	FABRICENOTREADY FabricErrorCodes = "FABRIC_E_NOT_READY"
	// FABRICENOWRITEQUORUM ...
	FABRICENOWRITEQUORUM FabricErrorCodes = "FABRIC_E_NO_WRITE_QUORUM"
	// FABRICEOPERATIONNOTCOMPLETE ...
	FABRICEOPERATIONNOTCOMPLETE FabricErrorCodes = "FABRIC_E_OPERATION_NOT_COMPLETE"
	// FABRICEPARTITIONNOTFOUND ...
	FABRICEPARTITIONNOTFOUND FabricErrorCodes = "FABRIC_E_PARTITION_NOT_FOUND"
	// FABRICEPATHTOOLONG ...
	FABRICEPATHTOOLONG FabricErrorCodes = "FABRIC_E_PATH_TOO_LONG"
	// FABRICEPROPERTYCHECKFAILED ...
	FABRICEPROPERTYCHECKFAILED FabricErrorCodes = "FABRIC_E_PROPERTY_CHECK_FAILED"
	// FABRICEPROPERTYDOESNOTEXIST ...
	FABRICEPROPERTYDOESNOTEXIST FabricErrorCodes = "FABRIC_E_PROPERTY_DOES_NOT_EXIST"
	// FABRICERECONFIGURATIONPENDING ...
	FABRICERECONFIGURATIONPENDING FabricErrorCodes = "FABRIC_E_RECONFIGURATION_PENDING"
	// FABRICEREPLICADOESNOTEXIST ...
	FABRICEREPLICADOESNOTEXIST FabricErrorCodes = "FABRIC_E_REPLICA_DOES_NOT_EXIST"
	// FABRICERESTOREINPROGRESS ...
	FABRICERESTOREINPROGRESS FabricErrorCodes = "FABRIC_E_RESTORE_IN_PROGRESS"
	// FABRICERESTORESOURCETARGETPARTITIONMISMATCH ...
	FABRICERESTORESOURCETARGETPARTITIONMISMATCH FabricErrorCodes = "FABRIC_E_RESTORE_SOURCE_TARGET_PARTITION_MISMATCH"
	// FABRICESEQUENCENUMBERCHECKFAILED ...
	FABRICESEQUENCENUMBERCHECKFAILED FabricErrorCodes = "FABRIC_E_SEQUENCE_NUMBER_CHECK_FAILED"
	// FABRICESERVICEAFFINITYCHAINNOTSUPPORTED ...
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED FabricErrorCodes = "FABRIC_E_SERVICE_AFFINITY_CHAIN_NOT_SUPPORTED"
	// FABRICESERVICEALREADYEXISTS ...
	FABRICESERVICEALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_ALREADY_EXISTS"
	// FABRICESERVICEDOESNOTEXIST ...
	FABRICESERVICEDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_DOES_NOT_EXIST"
	// FABRICESERVICEGROUPALREADYEXISTS ...
	FABRICESERVICEGROUPALREADYEXISTS FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_ALREADY_EXISTS"
	// FABRICESERVICEGROUPDOESNOTEXIST ...
	FABRICESERVICEGROUPDOESNOTEXIST FabricErrorCodes = "FABRIC_E_SERVICE_GROUP_DOES_NOT_EXIST"
	// FABRICESERVICEMANIFESTNOTFOUND ...
	FABRICESERVICEMANIFESTNOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_MANIFEST_NOT_FOUND"
	// FABRICESERVICEMETADATAMISMATCH ...
	FABRICESERVICEMETADATAMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_METADATA_MISMATCH"
	// FABRICESERVICEOFFLINE ...
	FABRICESERVICEOFFLINE FabricErrorCodes = "FABRIC_E_SERVICE_OFFLINE"
	// FABRICESERVICETYPEMISMATCH ...
	FABRICESERVICETYPEMISMATCH FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_MISMATCH"
	// FABRICESERVICETYPENOTFOUND ...
	FABRICESERVICETYPENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_NOT_FOUND"
	// FABRICESERVICETYPETEMPLATENOTFOUND ...
	FABRICESERVICETYPETEMPLATENOTFOUND FabricErrorCodes = "FABRIC_E_SERVICE_TYPE_TEMPLATE_NOT_FOUND"
	// FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS ...
	FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_ALREADY_EXISTS"
	// FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND ...
	FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND FabricErrorCodes = "FABRIC_E_SINGLE_INSTANCE_APPLICATION_NOT_FOUND"
	// FABRICETIMEOUT ...
	FABRICETIMEOUT FabricErrorCodes = "FABRIC_E_TIMEOUT"
	// FABRICEVALUEEMPTY ...
	FABRICEVALUEEMPTY FabricErrorCodes = "FABRIC_E_VALUE_EMPTY"
	// FABRICEVALUETOOLARGE ...
	FABRICEVALUETOOLARGE FabricErrorCodes = "FABRIC_E_VALUE_TOO_LARGE"
	// FABRICEVOLUMEALREADYEXISTS ...
	FABRICEVOLUMEALREADYEXISTS FabricErrorCodes = "FABRIC_E_VOLUME_ALREADY_EXISTS"
	// FABRICEVOLUMENOTFOUND ...
	FABRICEVOLUMENOTFOUND FabricErrorCodes = "FABRIC_E_VOLUME_NOT_FOUND"
	// SerializationError ...
	SerializationError FabricErrorCodes = "SerializationError"
)

// PossibleFabricErrorCodesValues returns an array of possible values for the FabricErrorCodes const type.
func PossibleFabricErrorCodesValues() []FabricErrorCodes {
	return []FabricErrorCodes{EABORT, EFAIL, EINVALIDARG, FABRICEAPPLICATIONALREADYEXISTS, FABRICEAPPLICATIONALREADYINTARGETVERSION, FABRICEAPPLICATIONNOTFOUND, FABRICEAPPLICATIONNOTUPGRADING, FABRICEAPPLICATIONTYPEALREADYEXISTS, FABRICEAPPLICATIONTYPEINUSE, FABRICEAPPLICATIONTYPENOTFOUND, FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS, FABRICEAPPLICATIONUPGRADEINPROGRESS, FABRICEAPPLICATIONUPGRADEVALIDATIONERROR, FABRICEBACKUPINPROGRESS, FABRICEBACKUPISENABLED, FABRICEBACKUPNOTENABLED, FABRICEBACKUPPOLICYALREADYEXISTING, FABRICEBACKUPPOLICYNOTEXISTING, FABRICECOMMUNICATIONERROR, FABRICECONFIGURATIONPARAMETERNOTFOUND, FABRICECONFIGURATIONSECTIONNOTFOUND, FABRICEDIRECTORYNOTFOUND, FABRICEENUMERATIONCOMPLETED, FABRICEFABRICALREADYINTARGETVERSION, FABRICEFABRICNOTUPGRADING, FABRICEFABRICUPGRADEINPROGRESS, FABRICEFABRICUPGRADEVALIDATIONERROR, FABRICEFABRICVERSIONALREADYEXISTS, FABRICEFABRICVERSIONINUSE, FABRICEFABRICVERSIONNOTFOUND, FABRICEFAULTANALYSISSERVICENOTEXISTING, FABRICEFILENOTFOUND, FABRICEHEALTHENTITYNOTFOUND, FABRICEHEALTHSTALEREPORT, FABRICEIMAGEBUILDERRESERVEDDIRECTORYERROR, FABRICEIMAGEBUILDERVALIDATIONERROR, FABRICEINSTANCEIDMISMATCH, FABRICEINVALIDADDRESS, FABRICEINVALIDATOMICGROUP, FABRICEINVALIDCONFIGURATION, FABRICEINVALIDFORSTATELESSSERVICES, FABRICEINVALIDNAMEURI, FABRICEINVALIDPARTITIONKEY, FABRICEINVALIDSERVICESCALINGPOLICY, FABRICEKEYNOTFOUND, FABRICEKEYTOOLARGE, FABRICENAMEALREADYEXISTS, FABRICENAMEDOESNOTEXIST, FABRICENAMENOTEMPTY, FABRICENODEHASNOTSTOPPEDYET, FABRICENODEISUP, FABRICENODENOTFOUND, FABRICENOTPRIMARY, FABRICENOTREADY, FABRICENOWRITEQUORUM, FABRICEOPERATIONNOTCOMPLETE, FABRICEPARTITIONNOTFOUND, FABRICEPATHTOOLONG, FABRICEPROPERTYCHECKFAILED, FABRICEPROPERTYDOESNOTEXIST, FABRICERECONFIGURATIONPENDING, FABRICEREPLICADOESNOTEXIST, FABRICERESTOREINPROGRESS, FABRICERESTORESOURCETARGETPARTITIONMISMATCH, FABRICESEQUENCENUMBERCHECKFAILED, FABRICESERVICEAFFINITYCHAINNOTSUPPORTED, FABRICESERVICEALREADYEXISTS, FABRICESERVICEDOESNOTEXIST, FABRICESERVICEGROUPALREADYEXISTS, FABRICESERVICEGROUPDOESNOTEXIST, FABRICESERVICEMANIFESTNOTFOUND, FABRICESERVICEMETADATAMISMATCH, FABRICESERVICEOFFLINE, FABRICESERVICETYPEMISMATCH, FABRICESERVICETYPENOTFOUND, FABRICESERVICETYPETEMPLATENOTFOUND, FABRICESINGLEINSTANCEAPPLICATIONALREADYEXISTS, FABRICESINGLEINSTANCEAPPLICATIONNOTFOUND, FABRICETIMEOUT, FABRICEVALUEEMPTY, FABRICEVALUETOOLARGE, FABRICEVOLUMEALREADYEXISTS, FABRICEVOLUMENOTFOUND, SerializationError}
}

// FabricEventKind enumerates the values for fabric event kind.
type FabricEventKind string

const (
	// FabricEventKindApplicationContainerInstanceExited ...
	FabricEventKindApplicationContainerInstanceExited FabricEventKind = "ApplicationContainerInstanceExited"
	// FabricEventKindApplicationCreated ...
	FabricEventKindApplicationCreated FabricEventKind = "ApplicationCreated"
	// FabricEventKindApplicationDeleted ...
	FabricEventKindApplicationDeleted FabricEventKind = "ApplicationDeleted"
	// FabricEventKindApplicationEvent ...
	FabricEventKindApplicationEvent FabricEventKind = "ApplicationEvent"
	// FabricEventKindApplicationHealthReportExpired ...
	FabricEventKindApplicationHealthReportExpired FabricEventKind = "ApplicationHealthReportExpired"
	// FabricEventKindApplicationNewHealthReport ...
	FabricEventKindApplicationNewHealthReport FabricEventKind = "ApplicationNewHealthReport"
	// FabricEventKindApplicationProcessExited ...
	FabricEventKindApplicationProcessExited FabricEventKind = "ApplicationProcessExited"
	// FabricEventKindApplicationUpgradeCompleted ...
	FabricEventKindApplicationUpgradeCompleted FabricEventKind = "ApplicationUpgradeCompleted"
	// FabricEventKindApplicationUpgradeDomainCompleted ...
	FabricEventKindApplicationUpgradeDomainCompleted FabricEventKind = "ApplicationUpgradeDomainCompleted"
	// FabricEventKindApplicationUpgradeRollbackCompleted ...
	FabricEventKindApplicationUpgradeRollbackCompleted FabricEventKind = "ApplicationUpgradeRollbackCompleted"
	// FabricEventKindApplicationUpgradeRollbackStarted ...
	FabricEventKindApplicationUpgradeRollbackStarted FabricEventKind = "ApplicationUpgradeRollbackStarted"
	// FabricEventKindApplicationUpgradeStarted ...
	FabricEventKindApplicationUpgradeStarted FabricEventKind = "ApplicationUpgradeStarted"
	// FabricEventKindChaosCodePackageRestartScheduled ...
	FabricEventKindChaosCodePackageRestartScheduled FabricEventKind = "ChaosCodePackageRestartScheduled"
	// FabricEventKindChaosNodeRestartScheduled ...
	FabricEventKindChaosNodeRestartScheduled FabricEventKind = "ChaosNodeRestartScheduled"
	// FabricEventKindChaosPartitionPrimaryMoveScheduled ...
	FabricEventKindChaosPartitionPrimaryMoveScheduled FabricEventKind = "ChaosPartitionPrimaryMoveScheduled"
	// FabricEventKindChaosPartitionSecondaryMoveScheduled ...
	FabricEventKindChaosPartitionSecondaryMoveScheduled FabricEventKind = "ChaosPartitionSecondaryMoveScheduled"
	// FabricEventKindChaosReplicaRemovalScheduled ...
	FabricEventKindChaosReplicaRemovalScheduled FabricEventKind = "ChaosReplicaRemovalScheduled"
	// FabricEventKindChaosReplicaRestartScheduled ...
	FabricEventKindChaosReplicaRestartScheduled FabricEventKind = "ChaosReplicaRestartScheduled"
	// FabricEventKindChaosStarted ...
	FabricEventKindChaosStarted FabricEventKind = "ChaosStarted"
	// FabricEventKindChaosStopped ...
	FabricEventKindChaosStopped FabricEventKind = "ChaosStopped"
	// FabricEventKindClusterEvent ...
	FabricEventKindClusterEvent FabricEventKind = "ClusterEvent"
	// FabricEventKindClusterHealthReportExpired ...
	FabricEventKindClusterHealthReportExpired FabricEventKind = "ClusterHealthReportExpired"
	// FabricEventKindClusterNewHealthReport ...
	FabricEventKindClusterNewHealthReport FabricEventKind = "ClusterNewHealthReport"
	// FabricEventKindClusterUpgradeCompleted ...
	FabricEventKindClusterUpgradeCompleted FabricEventKind = "ClusterUpgradeCompleted"
	// FabricEventKindClusterUpgradeDomainCompleted ...
	FabricEventKindClusterUpgradeDomainCompleted FabricEventKind = "ClusterUpgradeDomainCompleted"
	// FabricEventKindClusterUpgradeRollbackCompleted ...
	FabricEventKindClusterUpgradeRollbackCompleted FabricEventKind = "ClusterUpgradeRollbackCompleted"
	// FabricEventKindClusterUpgradeRollbackStarted ...
	FabricEventKindClusterUpgradeRollbackStarted FabricEventKind = "ClusterUpgradeRollbackStarted"
	// FabricEventKindClusterUpgradeStarted ...
	FabricEventKindClusterUpgradeStarted FabricEventKind = "ClusterUpgradeStarted"
	// FabricEventKindContainerInstanceEvent ...
	FabricEventKindContainerInstanceEvent FabricEventKind = "ContainerInstanceEvent"
	// FabricEventKindDeployedApplicationHealthReportExpired ...
	FabricEventKindDeployedApplicationHealthReportExpired FabricEventKind = "DeployedApplicationHealthReportExpired"
	// FabricEventKindDeployedApplicationNewHealthReport ...
	FabricEventKindDeployedApplicationNewHealthReport FabricEventKind = "DeployedApplicationNewHealthReport"
	// FabricEventKindDeployedServicePackageHealthReportExpired ...
	FabricEventKindDeployedServicePackageHealthReportExpired FabricEventKind = "DeployedServicePackageHealthReportExpired"
	// FabricEventKindDeployedServicePackageNewHealthReport ...
	FabricEventKindDeployedServicePackageNewHealthReport FabricEventKind = "DeployedServicePackageNewHealthReport"
	// FabricEventKindNodeAborted ...
	FabricEventKindNodeAborted FabricEventKind = "NodeAborted"
	// FabricEventKindNodeAddedToCluster ...
	FabricEventKindNodeAddedToCluster FabricEventKind = "NodeAddedToCluster"
	// FabricEventKindNodeClosed ...
	FabricEventKindNodeClosed FabricEventKind = "NodeClosed"
	// FabricEventKindNodeDeactivateCompleted ...
	FabricEventKindNodeDeactivateCompleted FabricEventKind = "NodeDeactivateCompleted"
	// FabricEventKindNodeDeactivateStarted ...
	FabricEventKindNodeDeactivateStarted FabricEventKind = "NodeDeactivateStarted"
	// FabricEventKindNodeDown ...
	FabricEventKindNodeDown FabricEventKind = "NodeDown"
	// FabricEventKindNodeEvent ...
	FabricEventKindNodeEvent FabricEventKind = "NodeEvent"
	// FabricEventKindNodeHealthReportExpired ...
	FabricEventKindNodeHealthReportExpired FabricEventKind = "NodeHealthReportExpired"
	// FabricEventKindNodeNewHealthReport ...
	FabricEventKindNodeNewHealthReport FabricEventKind = "NodeNewHealthReport"
	// FabricEventKindNodeOpenFailed ...
	FabricEventKindNodeOpenFailed FabricEventKind = "NodeOpenFailed"
	// FabricEventKindNodeOpenSucceeded ...
	FabricEventKindNodeOpenSucceeded FabricEventKind = "NodeOpenSucceeded"
	// FabricEventKindNodeRemovedFromCluster ...
	FabricEventKindNodeRemovedFromCluster FabricEventKind = "NodeRemovedFromCluster"
	// FabricEventKindNodeUp ...
	FabricEventKindNodeUp FabricEventKind = "NodeUp"
	// FabricEventKindPartitionAnalysisEvent ...
	FabricEventKindPartitionAnalysisEvent FabricEventKind = "PartitionAnalysisEvent"
	// FabricEventKindPartitionEvent ...
	FabricEventKindPartitionEvent FabricEventKind = "PartitionEvent"
	// FabricEventKindPartitionHealthReportExpired ...
	FabricEventKindPartitionHealthReportExpired FabricEventKind = "PartitionHealthReportExpired"
	// FabricEventKindPartitionNewHealthReport ...
	FabricEventKindPartitionNewHealthReport FabricEventKind = "PartitionNewHealthReport"
	// FabricEventKindPartitionPrimaryMoveAnalysis ...
	FabricEventKindPartitionPrimaryMoveAnalysis FabricEventKind = "PartitionPrimaryMoveAnalysis"
	// FabricEventKindPartitionReconfigured ...
	FabricEventKindPartitionReconfigured FabricEventKind = "PartitionReconfigured"
	// FabricEventKindReplicaEvent ...
	FabricEventKindReplicaEvent FabricEventKind = "ReplicaEvent"
	// FabricEventKindServiceCreated ...
	FabricEventKindServiceCreated FabricEventKind = "ServiceCreated"
	// FabricEventKindServiceDeleted ...
	FabricEventKindServiceDeleted FabricEventKind = "ServiceDeleted"
	// FabricEventKindServiceEvent ...
	FabricEventKindServiceEvent FabricEventKind = "ServiceEvent"
	// FabricEventKindServiceHealthReportExpired ...
	FabricEventKindServiceHealthReportExpired FabricEventKind = "ServiceHealthReportExpired"
	// FabricEventKindServiceNewHealthReport ...
	FabricEventKindServiceNewHealthReport FabricEventKind = "ServiceNewHealthReport"
	// FabricEventKindStatefulReplicaHealthReportExpired ...
	FabricEventKindStatefulReplicaHealthReportExpired FabricEventKind = "StatefulReplicaHealthReportExpired"
	// FabricEventKindStatefulReplicaNewHealthReport ...
	FabricEventKindStatefulReplicaNewHealthReport FabricEventKind = "StatefulReplicaNewHealthReport"
	// FabricEventKindStatelessReplicaHealthReportExpired ...
	FabricEventKindStatelessReplicaHealthReportExpired FabricEventKind = "StatelessReplicaHealthReportExpired"
	// FabricEventKindStatelessReplicaNewHealthReport ...
	FabricEventKindStatelessReplicaNewHealthReport FabricEventKind = "StatelessReplicaNewHealthReport"
)

// PossibleFabricEventKindValues returns an array of possible values for the FabricEventKind const type.
func PossibleFabricEventKindValues() []FabricEventKind {
	return []FabricEventKind{FabricEventKindApplicationContainerInstanceExited, FabricEventKindApplicationCreated, FabricEventKindApplicationDeleted, FabricEventKindApplicationEvent, FabricEventKindApplicationHealthReportExpired, FabricEventKindApplicationNewHealthReport, FabricEventKindApplicationProcessExited, FabricEventKindApplicationUpgradeCompleted, FabricEventKindApplicationUpgradeDomainCompleted, FabricEventKindApplicationUpgradeRollbackCompleted, FabricEventKindApplicationUpgradeRollbackStarted, FabricEventKindApplicationUpgradeStarted, FabricEventKindChaosCodePackageRestartScheduled, FabricEventKindChaosNodeRestartScheduled, FabricEventKindChaosPartitionPrimaryMoveScheduled, FabricEventKindChaosPartitionSecondaryMoveScheduled, FabricEventKindChaosReplicaRemovalScheduled, FabricEventKindChaosReplicaRestartScheduled, FabricEventKindChaosStarted, FabricEventKindChaosStopped, FabricEventKindClusterEvent, FabricEventKindClusterHealthReportExpired, FabricEventKindClusterNewHealthReport, FabricEventKindClusterUpgradeCompleted, FabricEventKindClusterUpgradeDomainCompleted, FabricEventKindClusterUpgradeRollbackCompleted, FabricEventKindClusterUpgradeRollbackStarted, FabricEventKindClusterUpgradeStarted, FabricEventKindContainerInstanceEvent, FabricEventKindDeployedApplicationHealthReportExpired, FabricEventKindDeployedApplicationNewHealthReport, FabricEventKindDeployedServicePackageHealthReportExpired, FabricEventKindDeployedServicePackageNewHealthReport, FabricEventKindNodeAborted, FabricEventKindNodeAddedToCluster, FabricEventKindNodeClosed, FabricEventKindNodeDeactivateCompleted, FabricEventKindNodeDeactivateStarted, FabricEventKindNodeDown, FabricEventKindNodeEvent, FabricEventKindNodeHealthReportExpired, FabricEventKindNodeNewHealthReport, FabricEventKindNodeOpenFailed, FabricEventKindNodeOpenSucceeded, FabricEventKindNodeRemovedFromCluster, FabricEventKindNodeUp, FabricEventKindPartitionAnalysisEvent, FabricEventKindPartitionEvent, FabricEventKindPartitionHealthReportExpired, FabricEventKindPartitionNewHealthReport, FabricEventKindPartitionPrimaryMoveAnalysis, FabricEventKindPartitionReconfigured, FabricEventKindReplicaEvent, FabricEventKindServiceCreated, FabricEventKindServiceDeleted, FabricEventKindServiceEvent, FabricEventKindServiceHealthReportExpired, FabricEventKindServiceNewHealthReport, FabricEventKindStatefulReplicaHealthReportExpired, FabricEventKindStatefulReplicaNewHealthReport, FabricEventKindStatelessReplicaHealthReportExpired, FabricEventKindStatelessReplicaNewHealthReport}
}

// FabricReplicaStatus enumerates the values for fabric replica status.
type FabricReplicaStatus string

const (
	// FabricReplicaStatusDown Indicates that the replica is down.
	FabricReplicaStatusDown FabricReplicaStatus = "Down"
	// FabricReplicaStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	FabricReplicaStatusInvalid FabricReplicaStatus = "Invalid"
	// FabricReplicaStatusUp Indicates that the replica is up.
	FabricReplicaStatusUp FabricReplicaStatus = "Up"
)

// PossibleFabricReplicaStatusValues returns an array of possible values for the FabricReplicaStatus const type.
func PossibleFabricReplicaStatusValues() []FabricReplicaStatus {
	return []FabricReplicaStatus{FabricReplicaStatusDown, FabricReplicaStatusInvalid, FabricReplicaStatusUp}
}

// FailureAction enumerates the values for failure action.
type FailureAction string

const (
	// FailureActionInvalid Indicates the failure action is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	FailureActionInvalid FailureAction = "Invalid"
	// FailureActionManual The upgrade will switch to UnmonitoredManual upgrade mode. The value is 2
	FailureActionManual FailureAction = "Manual"
	// FailureActionRollback The upgrade will start rolling back automatically. The value is 1
	FailureActionRollback FailureAction = "Rollback"
)

// PossibleFailureActionValues returns an array of possible values for the FailureAction const type.
func PossibleFailureActionValues() []FailureAction {
	return []FailureAction{FailureActionInvalid, FailureActionManual, FailureActionRollback}
}

// FailureReason enumerates the values for failure reason.
type FailureReason string

const (
	// HealthCheck The upgrade failed due to health policy violations. The value is 2
	HealthCheck FailureReason = "HealthCheck"
	// Interrupted There was an external request to roll back the upgrade. The value is 1
	Interrupted FailureReason = "Interrupted"
	// None Indicates the reason is invalid or unknown. All Service Fabric enumerations have the invalid type.
	// The value is zero.
	None FailureReason = "None"
	// OverallUpgradeTimeout The overall upgrade took longer than the allowed upgrade timeout to process. The
	// value is 4
	OverallUpgradeTimeout FailureReason = "OverallUpgradeTimeout"
	// UpgradeDomainTimeout An upgrade domain took longer than the allowed upgrade domain timeout to process.
	// The value is 3
	UpgradeDomainTimeout FailureReason = "UpgradeDomainTimeout"
)

// PossibleFailureReasonValues returns an array of possible values for the FailureReason const type.
func PossibleFailureReasonValues() []FailureReason {
	return []FailureReason{HealthCheck, Interrupted, None, OverallUpgradeTimeout, UpgradeDomainTimeout}
}

// HeaderMatchType enumerates the values for header match type.
type HeaderMatchType string

const (
	// Exact ...
	Exact HeaderMatchType = "exact"
)

// PossibleHeaderMatchTypeValues returns an array of possible values for the HeaderMatchType const type.
func PossibleHeaderMatchTypeValues() []HeaderMatchType {
	return []HeaderMatchType{Exact}
}

// HealthEvaluationKind enumerates the values for health evaluation kind.
type HealthEvaluationKind string

const (
	// HealthEvaluationKindApplication Indicates that the health evaluation is for an application. The value is
	// 18.
	HealthEvaluationKindApplication HealthEvaluationKind = "Application"
	// HealthEvaluationKindApplications Indicates that the health evaluation is for the cluster applications.
	// The value is 8.
	HealthEvaluationKindApplications HealthEvaluationKind = "Applications"
	// HealthEvaluationKindApplicationTypeApplications – Indicates that the health evaluation is for
	// applications of an application type. The value is 21.
	HealthEvaluationKindApplicationTypeApplications HealthEvaluationKind = "ApplicationTypeApplications"
	// HealthEvaluationKindDeltaNodesCheck Indicates that the health evaluation is for the delta of unhealthy
	// cluster nodes. The value is 19.
	HealthEvaluationKindDeltaNodesCheck HealthEvaluationKind = "DeltaNodesCheck"
	// HealthEvaluationKindDeployedApplication Indicates that the health evaluation is for a deployed
	// application. The value is 17.
	HealthEvaluationKindDeployedApplication HealthEvaluationKind = "DeployedApplication"
	// HealthEvaluationKindDeployedApplications Indicates that the health evaluation is for the deployed
	// applications of an application. The value is 5.
	HealthEvaluationKindDeployedApplications HealthEvaluationKind = "DeployedApplications"
	// HealthEvaluationKindDeployedServicePackage Indicates that the health evaluation is for a deployed
	// service package. The value is 16.
	HealthEvaluationKindDeployedServicePackage HealthEvaluationKind = "DeployedServicePackage"
	// HealthEvaluationKindDeployedServicePackages Indicates that the health evaluation is for the deployed
	// service packages of a deployed application. The value is 4.
	HealthEvaluationKindDeployedServicePackages HealthEvaluationKind = "DeployedServicePackages"
	// HealthEvaluationKindEvent Indicates that the health evaluation is for a health event. The value is 1.
	HealthEvaluationKindEvent HealthEvaluationKind = "Event"
	// HealthEvaluationKindInvalid Indicates that the health evaluation is invalid. The value is zero.
	HealthEvaluationKindInvalid HealthEvaluationKind = "Invalid"
	// HealthEvaluationKindNode Indicates that the health evaluation is for a node. The value is 12.
	HealthEvaluationKindNode HealthEvaluationKind = "Node"
	// HealthEvaluationKindNodes Indicates that the health evaluation is for the cluster nodes. The value is 7.
	HealthEvaluationKindNodes HealthEvaluationKind = "Nodes"
	// HealthEvaluationKindPartition Indicates that the health evaluation is for a partition. The value is 14.
	HealthEvaluationKindPartition HealthEvaluationKind = "Partition"
	// HealthEvaluationKindPartitions Indicates that the health evaluation is for the partitions of a service.
	// The value is 3.
	HealthEvaluationKindPartitions HealthEvaluationKind = "Partitions"
	// HealthEvaluationKindReplica Indicates that the health evaluation is for a replica. The value is 13.
	HealthEvaluationKindReplica HealthEvaluationKind = "Replica"
	// HealthEvaluationKindReplicas Indicates that the health evaluation is for the replicas of a partition.
	// The value is 2.
	HealthEvaluationKindReplicas HealthEvaluationKind = "Replicas"
	// HealthEvaluationKindService Indicates that the health evaluation is for a service. The value is 15.
	HealthEvaluationKindService HealthEvaluationKind = "Service"
	// HealthEvaluationKindServices Indicates that the health evaluation is for services of an application. The
	// value is 6.
	HealthEvaluationKindServices HealthEvaluationKind = "Services"
	// HealthEvaluationKindSystemApplication Indicates that the health evaluation is for the system
	// application. The value is 9.
	HealthEvaluationKindSystemApplication HealthEvaluationKind = "SystemApplication"
	// HealthEvaluationKindUpgradeDomainDeltaNodesCheck Indicates that the health evaluation is for the delta
	// of unhealthy upgrade domain cluster nodes. The value is 20.
	HealthEvaluationKindUpgradeDomainDeltaNodesCheck HealthEvaluationKind = "UpgradeDomainDeltaNodesCheck"
	// HealthEvaluationKindUpgradeDomainDeployedApplications Indicates that the health evaluation is for the
	// deployed applications of an application in an upgrade domain. The value is 10.
	HealthEvaluationKindUpgradeDomainDeployedApplications HealthEvaluationKind = "UpgradeDomainDeployedApplications"
	// HealthEvaluationKindUpgradeDomainNodes Indicates that the health evaluation is for the cluster nodes in
	// an upgrade domain. The value is 11.
	HealthEvaluationKindUpgradeDomainNodes HealthEvaluationKind = "UpgradeDomainNodes"
)

// PossibleHealthEvaluationKindValues returns an array of possible values for the HealthEvaluationKind const type.
func PossibleHealthEvaluationKindValues() []HealthEvaluationKind {
	return []HealthEvaluationKind{HealthEvaluationKindApplication, HealthEvaluationKindApplications, HealthEvaluationKindApplicationTypeApplications, HealthEvaluationKindDeltaNodesCheck, HealthEvaluationKindDeployedApplication, HealthEvaluationKindDeployedApplications, HealthEvaluationKindDeployedServicePackage, HealthEvaluationKindDeployedServicePackages, HealthEvaluationKindEvent, HealthEvaluationKindInvalid, HealthEvaluationKindNode, HealthEvaluationKindNodes, HealthEvaluationKindPartition, HealthEvaluationKindPartitions, HealthEvaluationKindReplica, HealthEvaluationKindReplicas, HealthEvaluationKindService, HealthEvaluationKindServices, HealthEvaluationKindSystemApplication, HealthEvaluationKindUpgradeDomainDeltaNodesCheck, HealthEvaluationKindUpgradeDomainDeployedApplications, HealthEvaluationKindUpgradeDomainNodes}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// HostIsolationMode enumerates the values for host isolation mode.
type HostIsolationMode string

const (
	// HostIsolationModeHyperV Indicates the ContainerHost is a Hyper-V container. This applies to only Windows
	// containers. The value is 2.
	HostIsolationModeHyperV HostIsolationMode = "HyperV"
	// HostIsolationModeNone Indicates the isolation mode is not applicable for given HostType. The value is 0.
	HostIsolationModeNone HostIsolationMode = "None"
	// HostIsolationModeProcess This is the default isolation mode for a ContainerHost. The value is 1.
	HostIsolationModeProcess HostIsolationMode = "Process"
)

// PossibleHostIsolationModeValues returns an array of possible values for the HostIsolationMode const type.
func PossibleHostIsolationModeValues() []HostIsolationMode {
	return []HostIsolationMode{HostIsolationModeHyperV, HostIsolationModeNone, HostIsolationModeProcess}
}

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeContainerHost Indicates the host is a container. The value is 2.
	HostTypeContainerHost HostType = "ContainerHost"
	// HostTypeExeHost Indicates the host is an executable. The value is 1.
	HostTypeExeHost HostType = "ExeHost"
	// HostTypeInvalid Indicates the type of host is not known or invalid. The value is 0.
	HostTypeInvalid HostType = "Invalid"
)

// PossibleHostTypeValues returns an array of possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{HostTypeContainerHost, HostTypeExeHost, HostTypeInvalid}
}

// ImpactLevel enumerates the values for impact level.
type ImpactLevel string

const (
	// ImpactLevelInvalid ...
	ImpactLevelInvalid ImpactLevel = "Invalid"
	// ImpactLevelNone ...
	ImpactLevelNone ImpactLevel = "None"
	// ImpactLevelRemoveData ...
	ImpactLevelRemoveData ImpactLevel = "RemoveData"
	// ImpactLevelRemoveNode ...
	ImpactLevelRemoveNode ImpactLevel = "RemoveNode"
	// ImpactLevelRestart ...
	ImpactLevelRestart ImpactLevel = "Restart"
)

// PossibleImpactLevelValues returns an array of possible values for the ImpactLevel const type.
func PossibleImpactLevelValues() []ImpactLevel {
	return []ImpactLevel{ImpactLevelInvalid, ImpactLevelNone, ImpactLevelRemoveData, ImpactLevelRemoveNode, ImpactLevelRestart}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindApplication ...
	KindApplication Kind = "Application"
	// KindApplications ...
	KindApplications Kind = "Applications"
	// KindApplicationTypeApplications ...
	KindApplicationTypeApplications Kind = "ApplicationTypeApplications"
	// KindDeltaNodesCheck ...
	KindDeltaNodesCheck Kind = "DeltaNodesCheck"
	// KindDeployedApplication ...
	KindDeployedApplication Kind = "DeployedApplication"
	// KindDeployedApplications ...
	KindDeployedApplications Kind = "DeployedApplications"
	// KindDeployedServicePackage ...
	KindDeployedServicePackage Kind = "DeployedServicePackage"
	// KindDeployedServicePackages ...
	KindDeployedServicePackages Kind = "DeployedServicePackages"
	// KindEvent ...
	KindEvent Kind = "Event"
	// KindHealthEvaluation ...
	KindHealthEvaluation Kind = "HealthEvaluation"
	// KindNode ...
	KindNode Kind = "Node"
	// KindNodes ...
	KindNodes Kind = "Nodes"
	// KindPartition ...
	KindPartition Kind = "Partition"
	// KindPartitions ...
	KindPartitions Kind = "Partitions"
	// KindReplica ...
	KindReplica Kind = "Replica"
	// KindReplicas ...
	KindReplicas Kind = "Replicas"
	// KindService ...
	KindService Kind = "Service"
	// KindServices ...
	KindServices Kind = "Services"
	// KindSystemApplication ...
	KindSystemApplication Kind = "SystemApplication"
	// KindUpgradeDomainDeltaNodesCheck ...
	KindUpgradeDomainDeltaNodesCheck Kind = "UpgradeDomainDeltaNodesCheck"
	// KindUpgradeDomainNodes ...
	KindUpgradeDomainNodes Kind = "UpgradeDomainNodes"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindApplication, KindApplications, KindApplicationTypeApplications, KindDeltaNodesCheck, KindDeployedApplication, KindDeployedApplications, KindDeployedServicePackage, KindDeployedServicePackages, KindEvent, KindHealthEvaluation, KindNode, KindNodes, KindPartition, KindPartitions, KindReplica, KindReplicas, KindService, KindServices, KindSystemApplication, KindUpgradeDomainDeltaNodesCheck, KindUpgradeDomainNodes}
}

// KindBasicApplicationScopedVolumeCreationParameters enumerates the values for kind basic application scoped
// volume creation parameters.
type KindBasicApplicationScopedVolumeCreationParameters string

const (
	// KindApplicationScopedVolumeCreationParameters ...
	KindApplicationScopedVolumeCreationParameters KindBasicApplicationScopedVolumeCreationParameters = "ApplicationScopedVolumeCreationParameters"
	// KindServiceFabricVolumeDisk ...
	KindServiceFabricVolumeDisk KindBasicApplicationScopedVolumeCreationParameters = "ServiceFabricVolumeDisk"
)

// PossibleKindBasicApplicationScopedVolumeCreationParametersValues returns an array of possible values for the KindBasicApplicationScopedVolumeCreationParameters const type.
func PossibleKindBasicApplicationScopedVolumeCreationParametersValues() []KindBasicApplicationScopedVolumeCreationParameters {
	return []KindBasicApplicationScopedVolumeCreationParameters{KindApplicationScopedVolumeCreationParameters, KindServiceFabricVolumeDisk}
}

// KindBasicAutoScalingMechanism enumerates the values for kind basic auto scaling mechanism.
type KindBasicAutoScalingMechanism string

const (
	// KindAddRemoveReplica ...
	KindAddRemoveReplica KindBasicAutoScalingMechanism = "AddRemoveReplica"
	// KindAutoScalingMechanism ...
	KindAutoScalingMechanism KindBasicAutoScalingMechanism = "AutoScalingMechanism"
)

// PossibleKindBasicAutoScalingMechanismValues returns an array of possible values for the KindBasicAutoScalingMechanism const type.
func PossibleKindBasicAutoScalingMechanismValues() []KindBasicAutoScalingMechanism {
	return []KindBasicAutoScalingMechanism{KindAddRemoveReplica, KindAutoScalingMechanism}
}

// KindBasicAutoScalingMetric enumerates the values for kind basic auto scaling metric.
type KindBasicAutoScalingMetric string

const (
	// KindAutoScalingMetric ...
	KindAutoScalingMetric KindBasicAutoScalingMetric = "AutoScalingMetric"
	// KindResource ...
	KindResource KindBasicAutoScalingMetric = "Resource"
)

// PossibleKindBasicAutoScalingMetricValues returns an array of possible values for the KindBasicAutoScalingMetric const type.
func PossibleKindBasicAutoScalingMetricValues() []KindBasicAutoScalingMetric {
	return []KindBasicAutoScalingMetric{KindAutoScalingMetric, KindResource}
}

// KindBasicAutoScalingTrigger enumerates the values for kind basic auto scaling trigger.
type KindBasicAutoScalingTrigger string

const (
	// KindAutoScalingTrigger ...
	KindAutoScalingTrigger KindBasicAutoScalingTrigger = "AutoScalingTrigger"
	// KindAverageLoad ...
	KindAverageLoad KindBasicAutoScalingTrigger = "AverageLoad"
)

// PossibleKindBasicAutoScalingTriggerValues returns an array of possible values for the KindBasicAutoScalingTrigger const type.
func PossibleKindBasicAutoScalingTriggerValues() []KindBasicAutoScalingTrigger {
	return []KindBasicAutoScalingTrigger{KindAutoScalingTrigger, KindAverageLoad}
}

// KindBasicBackupConfigurationInfo enumerates the values for kind basic backup configuration info.
type KindBasicBackupConfigurationInfo string

const (
	// KindBasicBackupConfigurationInfoKindApplication ...
	KindBasicBackupConfigurationInfoKindApplication KindBasicBackupConfigurationInfo = "Application"
	// KindBasicBackupConfigurationInfoKindBackupConfigurationInfo ...
	KindBasicBackupConfigurationInfoKindBackupConfigurationInfo KindBasicBackupConfigurationInfo = "BackupConfigurationInfo"
	// KindBasicBackupConfigurationInfoKindPartition ...
	KindBasicBackupConfigurationInfoKindPartition KindBasicBackupConfigurationInfo = "Partition"
	// KindBasicBackupConfigurationInfoKindService ...
	KindBasicBackupConfigurationInfoKindService KindBasicBackupConfigurationInfo = "Service"
)

// PossibleKindBasicBackupConfigurationInfoValues returns an array of possible values for the KindBasicBackupConfigurationInfo const type.
func PossibleKindBasicBackupConfigurationInfoValues() []KindBasicBackupConfigurationInfo {
	return []KindBasicBackupConfigurationInfo{KindBasicBackupConfigurationInfoKindApplication, KindBasicBackupConfigurationInfoKindBackupConfigurationInfo, KindBasicBackupConfigurationInfoKindPartition, KindBasicBackupConfigurationInfoKindService}
}

// KindBasicChaosEvent enumerates the values for kind basic chaos event.
type KindBasicChaosEvent string

const (
	// KindChaosEvent ...
	KindChaosEvent KindBasicChaosEvent = "ChaosEvent"
	// KindExecutingFaults ...
	KindExecutingFaults KindBasicChaosEvent = "ExecutingFaults"
	// KindStarted ...
	KindStarted KindBasicChaosEvent = "Started"
	// KindStopped ...
	KindStopped KindBasicChaosEvent = "Stopped"
	// KindTestError ...
	KindTestError KindBasicChaosEvent = "TestError"
	// KindValidationFailed ...
	KindValidationFailed KindBasicChaosEvent = "ValidationFailed"
	// KindWaiting ...
	KindWaiting KindBasicChaosEvent = "Waiting"
)

// PossibleKindBasicChaosEventValues returns an array of possible values for the KindBasicChaosEvent const type.
func PossibleKindBasicChaosEventValues() []KindBasicChaosEvent {
	return []KindBasicChaosEvent{KindChaosEvent, KindExecutingFaults, KindStarted, KindStopped, KindTestError, KindValidationFailed, KindWaiting}
}

// KindBasicDiagnosticsSinkProperties enumerates the values for kind basic diagnostics sink properties.
type KindBasicDiagnosticsSinkProperties string

const (
	// KindAzureInternalMonitoringPipeline ...
	KindAzureInternalMonitoringPipeline KindBasicDiagnosticsSinkProperties = "AzureInternalMonitoringPipeline"
	// KindDiagnosticsSinkProperties ...
	KindDiagnosticsSinkProperties KindBasicDiagnosticsSinkProperties = "DiagnosticsSinkProperties"
)

// PossibleKindBasicDiagnosticsSinkPropertiesValues returns an array of possible values for the KindBasicDiagnosticsSinkProperties const type.
func PossibleKindBasicDiagnosticsSinkPropertiesValues() []KindBasicDiagnosticsSinkProperties {
	return []KindBasicDiagnosticsSinkProperties{KindAzureInternalMonitoringPipeline, KindDiagnosticsSinkProperties}
}

// KindBasicFabricEvent enumerates the values for kind basic fabric event.
type KindBasicFabricEvent string

const (
	// KindApplicationContainerInstanceExited ...
	KindApplicationContainerInstanceExited KindBasicFabricEvent = "ApplicationContainerInstanceExited"
	// KindApplicationCreated ...
	KindApplicationCreated KindBasicFabricEvent = "ApplicationCreated"
	// KindApplicationDeleted ...
	KindApplicationDeleted KindBasicFabricEvent = "ApplicationDeleted"
	// KindApplicationEvent ...
	KindApplicationEvent KindBasicFabricEvent = "ApplicationEvent"
	// KindApplicationHealthReportExpired ...
	KindApplicationHealthReportExpired KindBasicFabricEvent = "ApplicationHealthReportExpired"
	// KindApplicationNewHealthReport ...
	KindApplicationNewHealthReport KindBasicFabricEvent = "ApplicationNewHealthReport"
	// KindApplicationProcessExited ...
	KindApplicationProcessExited KindBasicFabricEvent = "ApplicationProcessExited"
	// KindApplicationUpgradeCompleted ...
	KindApplicationUpgradeCompleted KindBasicFabricEvent = "ApplicationUpgradeCompleted"
	// KindApplicationUpgradeDomainCompleted ...
	KindApplicationUpgradeDomainCompleted KindBasicFabricEvent = "ApplicationUpgradeDomainCompleted"
	// KindApplicationUpgradeRollbackCompleted ...
	KindApplicationUpgradeRollbackCompleted KindBasicFabricEvent = "ApplicationUpgradeRollbackCompleted"
	// KindApplicationUpgradeRollbackStarted ...
	KindApplicationUpgradeRollbackStarted KindBasicFabricEvent = "ApplicationUpgradeRollbackStarted"
	// KindApplicationUpgradeStarted ...
	KindApplicationUpgradeStarted KindBasicFabricEvent = "ApplicationUpgradeStarted"
	// KindChaosCodePackageRestartScheduled ...
	KindChaosCodePackageRestartScheduled KindBasicFabricEvent = "ChaosCodePackageRestartScheduled"
	// KindChaosNodeRestartScheduled ...
	KindChaosNodeRestartScheduled KindBasicFabricEvent = "ChaosNodeRestartScheduled"
	// KindChaosPartitionPrimaryMoveScheduled ...
	KindChaosPartitionPrimaryMoveScheduled KindBasicFabricEvent = "ChaosPartitionPrimaryMoveScheduled"
	// KindChaosPartitionSecondaryMoveScheduled ...
	KindChaosPartitionSecondaryMoveScheduled KindBasicFabricEvent = "ChaosPartitionSecondaryMoveScheduled"
	// KindChaosReplicaRemovalScheduled ...
	KindChaosReplicaRemovalScheduled KindBasicFabricEvent = "ChaosReplicaRemovalScheduled"
	// KindChaosReplicaRestartScheduled ...
	KindChaosReplicaRestartScheduled KindBasicFabricEvent = "ChaosReplicaRestartScheduled"
	// KindChaosStarted ...
	KindChaosStarted KindBasicFabricEvent = "ChaosStarted"
	// KindChaosStopped ...
	KindChaosStopped KindBasicFabricEvent = "ChaosStopped"
	// KindClusterEvent ...
	KindClusterEvent KindBasicFabricEvent = "ClusterEvent"
	// KindClusterHealthReportExpired ...
	KindClusterHealthReportExpired KindBasicFabricEvent = "ClusterHealthReportExpired"
	// KindClusterNewHealthReport ...
	KindClusterNewHealthReport KindBasicFabricEvent = "ClusterNewHealthReport"
	// KindClusterUpgradeCompleted ...
	KindClusterUpgradeCompleted KindBasicFabricEvent = "ClusterUpgradeCompleted"
	// KindClusterUpgradeDomainCompleted ...
	KindClusterUpgradeDomainCompleted KindBasicFabricEvent = "ClusterUpgradeDomainCompleted"
	// KindClusterUpgradeRollbackCompleted ...
	KindClusterUpgradeRollbackCompleted KindBasicFabricEvent = "ClusterUpgradeRollbackCompleted"
	// KindClusterUpgradeRollbackStarted ...
	KindClusterUpgradeRollbackStarted KindBasicFabricEvent = "ClusterUpgradeRollbackStarted"
	// KindClusterUpgradeStarted ...
	KindClusterUpgradeStarted KindBasicFabricEvent = "ClusterUpgradeStarted"
	// KindContainerInstanceEvent ...
	KindContainerInstanceEvent KindBasicFabricEvent = "ContainerInstanceEvent"
	// KindDeployedApplicationHealthReportExpired ...
	KindDeployedApplicationHealthReportExpired KindBasicFabricEvent = "DeployedApplicationHealthReportExpired"
	// KindDeployedApplicationNewHealthReport ...
	KindDeployedApplicationNewHealthReport KindBasicFabricEvent = "DeployedApplicationNewHealthReport"
	// KindDeployedServicePackageHealthReportExpired ...
	KindDeployedServicePackageHealthReportExpired KindBasicFabricEvent = "DeployedServicePackageHealthReportExpired"
	// KindDeployedServicePackageNewHealthReport ...
	KindDeployedServicePackageNewHealthReport KindBasicFabricEvent = "DeployedServicePackageNewHealthReport"
	// KindFabricEvent ...
	KindFabricEvent KindBasicFabricEvent = "FabricEvent"
	// KindNodeAborted ...
	KindNodeAborted KindBasicFabricEvent = "NodeAborted"
	// KindNodeAddedToCluster ...
	KindNodeAddedToCluster KindBasicFabricEvent = "NodeAddedToCluster"
	// KindNodeClosed ...
	KindNodeClosed KindBasicFabricEvent = "NodeClosed"
	// KindNodeDeactivateCompleted ...
	KindNodeDeactivateCompleted KindBasicFabricEvent = "NodeDeactivateCompleted"
	// KindNodeDeactivateStarted ...
	KindNodeDeactivateStarted KindBasicFabricEvent = "NodeDeactivateStarted"
	// KindNodeDown ...
	KindNodeDown KindBasicFabricEvent = "NodeDown"
	// KindNodeEvent ...
	KindNodeEvent KindBasicFabricEvent = "NodeEvent"
	// KindNodeHealthReportExpired ...
	KindNodeHealthReportExpired KindBasicFabricEvent = "NodeHealthReportExpired"
	// KindNodeNewHealthReport ...
	KindNodeNewHealthReport KindBasicFabricEvent = "NodeNewHealthReport"
	// KindNodeOpenFailed ...
	KindNodeOpenFailed KindBasicFabricEvent = "NodeOpenFailed"
	// KindNodeOpenSucceeded ...
	KindNodeOpenSucceeded KindBasicFabricEvent = "NodeOpenSucceeded"
	// KindNodeRemovedFromCluster ...
	KindNodeRemovedFromCluster KindBasicFabricEvent = "NodeRemovedFromCluster"
	// KindNodeUp ...
	KindNodeUp KindBasicFabricEvent = "NodeUp"
	// KindPartitionAnalysisEvent ...
	KindPartitionAnalysisEvent KindBasicFabricEvent = "PartitionAnalysisEvent"
	// KindPartitionEvent ...
	KindPartitionEvent KindBasicFabricEvent = "PartitionEvent"
	// KindPartitionHealthReportExpired ...
	KindPartitionHealthReportExpired KindBasicFabricEvent = "PartitionHealthReportExpired"
	// KindPartitionNewHealthReport ...
	KindPartitionNewHealthReport KindBasicFabricEvent = "PartitionNewHealthReport"
	// KindPartitionPrimaryMoveAnalysis ...
	KindPartitionPrimaryMoveAnalysis KindBasicFabricEvent = "PartitionPrimaryMoveAnalysis"
	// KindPartitionReconfigured ...
	KindPartitionReconfigured KindBasicFabricEvent = "PartitionReconfigured"
	// KindReplicaEvent ...
	KindReplicaEvent KindBasicFabricEvent = "ReplicaEvent"
	// KindServiceCreated ...
	KindServiceCreated KindBasicFabricEvent = "ServiceCreated"
	// KindServiceDeleted ...
	KindServiceDeleted KindBasicFabricEvent = "ServiceDeleted"
	// KindServiceEvent ...
	KindServiceEvent KindBasicFabricEvent = "ServiceEvent"
	// KindServiceHealthReportExpired ...
	KindServiceHealthReportExpired KindBasicFabricEvent = "ServiceHealthReportExpired"
	// KindServiceNewHealthReport ...
	KindServiceNewHealthReport KindBasicFabricEvent = "ServiceNewHealthReport"
	// KindStatefulReplicaHealthReportExpired ...
	KindStatefulReplicaHealthReportExpired KindBasicFabricEvent = "StatefulReplicaHealthReportExpired"
	// KindStatefulReplicaNewHealthReport ...
	KindStatefulReplicaNewHealthReport KindBasicFabricEvent = "StatefulReplicaNewHealthReport"
	// KindStatelessReplicaHealthReportExpired ...
	KindStatelessReplicaHealthReportExpired KindBasicFabricEvent = "StatelessReplicaHealthReportExpired"
	// KindStatelessReplicaNewHealthReport ...
	KindStatelessReplicaNewHealthReport KindBasicFabricEvent = "StatelessReplicaNewHealthReport"
)

// PossibleKindBasicFabricEventValues returns an array of possible values for the KindBasicFabricEvent const type.
func PossibleKindBasicFabricEventValues() []KindBasicFabricEvent {
	return []KindBasicFabricEvent{KindApplicationContainerInstanceExited, KindApplicationCreated, KindApplicationDeleted, KindApplicationEvent, KindApplicationHealthReportExpired, KindApplicationNewHealthReport, KindApplicationProcessExited, KindApplicationUpgradeCompleted, KindApplicationUpgradeDomainCompleted, KindApplicationUpgradeRollbackCompleted, KindApplicationUpgradeRollbackStarted, KindApplicationUpgradeStarted, KindChaosCodePackageRestartScheduled, KindChaosNodeRestartScheduled, KindChaosPartitionPrimaryMoveScheduled, KindChaosPartitionSecondaryMoveScheduled, KindChaosReplicaRemovalScheduled, KindChaosReplicaRestartScheduled, KindChaosStarted, KindChaosStopped, KindClusterEvent, KindClusterHealthReportExpired, KindClusterNewHealthReport, KindClusterUpgradeCompleted, KindClusterUpgradeDomainCompleted, KindClusterUpgradeRollbackCompleted, KindClusterUpgradeRollbackStarted, KindClusterUpgradeStarted, KindContainerInstanceEvent, KindDeployedApplicationHealthReportExpired, KindDeployedApplicationNewHealthReport, KindDeployedServicePackageHealthReportExpired, KindDeployedServicePackageNewHealthReport, KindFabricEvent, KindNodeAborted, KindNodeAddedToCluster, KindNodeClosed, KindNodeDeactivateCompleted, KindNodeDeactivateStarted, KindNodeDown, KindNodeEvent, KindNodeHealthReportExpired, KindNodeNewHealthReport, KindNodeOpenFailed, KindNodeOpenSucceeded, KindNodeRemovedFromCluster, KindNodeUp, KindPartitionAnalysisEvent, KindPartitionEvent, KindPartitionHealthReportExpired, KindPartitionNewHealthReport, KindPartitionPrimaryMoveAnalysis, KindPartitionReconfigured, KindReplicaEvent, KindServiceCreated, KindServiceDeleted, KindServiceEvent, KindServiceHealthReportExpired, KindServiceNewHealthReport, KindStatefulReplicaHealthReportExpired, KindStatefulReplicaNewHealthReport, KindStatelessReplicaHealthReportExpired, KindStatelessReplicaNewHealthReport}
}

// KindBasicNetworkResourcePropertiesBase enumerates the values for kind basic network resource properties
// base.
type KindBasicNetworkResourcePropertiesBase string

const (
	// KindLocal ...
	KindLocal KindBasicNetworkResourcePropertiesBase = "Local"
	// KindNetworkResourceProperties ...
	KindNetworkResourceProperties KindBasicNetworkResourcePropertiesBase = "NetworkResourceProperties"
	// KindNetworkResourcePropertiesBase ...
	KindNetworkResourcePropertiesBase KindBasicNetworkResourcePropertiesBase = "NetworkResourcePropertiesBase"
)

// PossibleKindBasicNetworkResourcePropertiesBaseValues returns an array of possible values for the KindBasicNetworkResourcePropertiesBase const type.
func PossibleKindBasicNetworkResourcePropertiesBaseValues() []KindBasicNetworkResourcePropertiesBase {
	return []KindBasicNetworkResourcePropertiesBase{KindLocal, KindNetworkResourceProperties, KindNetworkResourcePropertiesBase}
}

// KindBasicPropertyBatchInfo enumerates the values for kind basic property batch info.
type KindBasicPropertyBatchInfo string

const (
	// KindFailed ...
	KindFailed KindBasicPropertyBatchInfo = "Failed"
	// KindPropertyBatchInfo ...
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = "PropertyBatchInfo"
	// KindSuccessful ...
	KindSuccessful KindBasicPropertyBatchInfo = "Successful"
)

// PossibleKindBasicPropertyBatchInfoValues returns an array of possible values for the KindBasicPropertyBatchInfo const type.
func PossibleKindBasicPropertyBatchInfoValues() []KindBasicPropertyBatchInfo {
	return []KindBasicPropertyBatchInfo{KindFailed, KindPropertyBatchInfo, KindSuccessful}
}

// KindBasicPropertyBatchOperation enumerates the values for kind basic property batch operation.
type KindBasicPropertyBatchOperation string

const (
	// KindCheckExists ...
	KindCheckExists KindBasicPropertyBatchOperation = "CheckExists"
	// KindCheckSequence ...
	KindCheckSequence KindBasicPropertyBatchOperation = "CheckSequence"
	// KindCheckValue ...
	KindCheckValue KindBasicPropertyBatchOperation = "CheckValue"
	// KindDelete ...
	KindDelete KindBasicPropertyBatchOperation = "Delete"
	// KindGet ...
	KindGet KindBasicPropertyBatchOperation = "Get"
	// KindPropertyBatchOperation ...
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = "PropertyBatchOperation"
	// KindPut ...
	KindPut KindBasicPropertyBatchOperation = "Put"
)

// PossibleKindBasicPropertyBatchOperationValues returns an array of possible values for the KindBasicPropertyBatchOperation const type.
func PossibleKindBasicPropertyBatchOperationValues() []KindBasicPropertyBatchOperation {
	return []KindBasicPropertyBatchOperation{KindCheckExists, KindCheckSequence, KindCheckValue, KindDelete, KindGet, KindPropertyBatchOperation, KindPut}
}

// KindBasicPropertyValue enumerates the values for kind basic property value.
type KindBasicPropertyValue string

const (
	// KindBinary ...
	KindBinary KindBasicPropertyValue = "Binary"
	// KindDouble ...
	KindDouble KindBasicPropertyValue = "Double"
	// KindGUID ...
	KindGUID KindBasicPropertyValue = "Guid"
	// KindInt64 ...
	KindInt64 KindBasicPropertyValue = "Int64"
	// KindPropertyValue ...
	KindPropertyValue KindBasicPropertyValue = "PropertyValue"
	// KindString ...
	KindString KindBasicPropertyValue = "String"
)

// PossibleKindBasicPropertyValueValues returns an array of possible values for the KindBasicPropertyValue const type.
func PossibleKindBasicPropertyValueValues() []KindBasicPropertyValue {
	return []KindBasicPropertyValue{KindBinary, KindDouble, KindGUID, KindInt64, KindPropertyValue, KindString}
}

// KindBasicProvisionApplicationTypeDescriptionBase enumerates the values for kind basic provision application
// type description base.
type KindBasicProvisionApplicationTypeDescriptionBase string

const (
	// KindExternalStore ...
	KindExternalStore KindBasicProvisionApplicationTypeDescriptionBase = "ExternalStore"
	// KindImageStorePath ...
	KindImageStorePath KindBasicProvisionApplicationTypeDescriptionBase = "ImageStorePath"
	// KindProvisionApplicationTypeDescriptionBase ...
	KindProvisionApplicationTypeDescriptionBase KindBasicProvisionApplicationTypeDescriptionBase = "ProvisionApplicationTypeDescriptionBase"
)

// PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues returns an array of possible values for the KindBasicProvisionApplicationTypeDescriptionBase const type.
func PossibleKindBasicProvisionApplicationTypeDescriptionBaseValues() []KindBasicProvisionApplicationTypeDescriptionBase {
	return []KindBasicProvisionApplicationTypeDescriptionBase{KindExternalStore, KindImageStorePath, KindProvisionApplicationTypeDescriptionBase}
}

// KindBasicRepairImpactDescriptionBase enumerates the values for kind basic repair impact description base.
type KindBasicRepairImpactDescriptionBase string

const (
	// KindBasicRepairImpactDescriptionBaseKindNode ...
	KindBasicRepairImpactDescriptionBaseKindNode KindBasicRepairImpactDescriptionBase = "Node"
	// KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase ...
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = "RepairImpactDescriptionBase"
)

// PossibleKindBasicRepairImpactDescriptionBaseValues returns an array of possible values for the KindBasicRepairImpactDescriptionBase const type.
func PossibleKindBasicRepairImpactDescriptionBaseValues() []KindBasicRepairImpactDescriptionBase {
	return []KindBasicRepairImpactDescriptionBase{KindBasicRepairImpactDescriptionBaseKindNode, KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase}
}

// KindBasicRepairTargetDescriptionBase enumerates the values for kind basic repair target description base.
type KindBasicRepairTargetDescriptionBase string

const (
	// KindBasicRepairTargetDescriptionBaseKindNode ...
	KindBasicRepairTargetDescriptionBaseKindNode KindBasicRepairTargetDescriptionBase = "Node"
	// KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase ...
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = "RepairTargetDescriptionBase"
)

// PossibleKindBasicRepairTargetDescriptionBaseValues returns an array of possible values for the KindBasicRepairTargetDescriptionBase const type.
func PossibleKindBasicRepairTargetDescriptionBaseValues() []KindBasicRepairTargetDescriptionBase {
	return []KindBasicRepairTargetDescriptionBase{KindBasicRepairTargetDescriptionBaseKindNode, KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase}
}

// KindBasicReplicaStatusBase enumerates the values for kind basic replica status base.
type KindBasicReplicaStatusBase string

const (
	// KindKeyValueStore ...
	KindKeyValueStore KindBasicReplicaStatusBase = "KeyValueStore"
	// KindReplicaStatusBase ...
	KindReplicaStatusBase KindBasicReplicaStatusBase = "ReplicaStatusBase"
)

// PossibleKindBasicReplicaStatusBaseValues returns an array of possible values for the KindBasicReplicaStatusBase const type.
func PossibleKindBasicReplicaStatusBaseValues() []KindBasicReplicaStatusBase {
	return []KindBasicReplicaStatusBase{KindKeyValueStore, KindReplicaStatusBase}
}

// KindBasicReplicatorStatus enumerates the values for kind basic replicator status.
type KindBasicReplicatorStatus string

const (
	// KindActiveSecondary ...
	KindActiveSecondary KindBasicReplicatorStatus = "ActiveSecondary"
	// KindIdleSecondary ...
	KindIdleSecondary KindBasicReplicatorStatus = "IdleSecondary"
	// KindPrimary ...
	KindPrimary KindBasicReplicatorStatus = "Primary"
	// KindReplicatorStatus ...
	KindReplicatorStatus KindBasicReplicatorStatus = "ReplicatorStatus"
	// KindSecondaryReplicatorStatus ...
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = "SecondaryReplicatorStatus"
)

// PossibleKindBasicReplicatorStatusValues returns an array of possible values for the KindBasicReplicatorStatus const type.
func PossibleKindBasicReplicatorStatusValues() []KindBasicReplicatorStatus {
	return []KindBasicReplicatorStatus{KindActiveSecondary, KindIdleSecondary, KindPrimary, KindReplicatorStatus, KindSecondaryReplicatorStatus}
}

// KindBasicSafetyCheck enumerates the values for kind basic safety check.
type KindBasicSafetyCheck string

const (
	// KindEnsureAvailability ...
	KindEnsureAvailability KindBasicSafetyCheck = "EnsureAvailability"
	// KindEnsurePartitionQuorum ...
	KindEnsurePartitionQuorum KindBasicSafetyCheck = "EnsurePartitionQuorum"
	// KindEnsureSeedNodeQuorum ...
	KindEnsureSeedNodeQuorum KindBasicSafetyCheck = "EnsureSeedNodeQuorum"
	// KindPartitionSafetyCheck ...
	KindPartitionSafetyCheck KindBasicSafetyCheck = "PartitionSafetyCheck"
	// KindSafetyCheck ...
	KindSafetyCheck KindBasicSafetyCheck = "SafetyCheck"
	// KindWaitForInbuildReplica ...
	KindWaitForInbuildReplica KindBasicSafetyCheck = "WaitForInbuildReplica"
	// KindWaitForPrimaryPlacement ...
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = "WaitForPrimaryPlacement"
	// KindWaitForPrimarySwap ...
	KindWaitForPrimarySwap KindBasicSafetyCheck = "WaitForPrimarySwap"
	// KindWaitForReconfiguration ...
	KindWaitForReconfiguration KindBasicSafetyCheck = "WaitForReconfiguration"
)

// PossibleKindBasicSafetyCheckValues returns an array of possible values for the KindBasicSafetyCheck const type.
func PossibleKindBasicSafetyCheckValues() []KindBasicSafetyCheck {
	return []KindBasicSafetyCheck{KindEnsureAvailability, KindEnsurePartitionQuorum, KindEnsureSeedNodeQuorum, KindPartitionSafetyCheck, KindSafetyCheck, KindWaitForInbuildReplica, KindWaitForPrimaryPlacement, KindWaitForPrimarySwap, KindWaitForReconfiguration}
}

// KindBasicScalingMechanismDescription enumerates the values for kind basic scaling mechanism description.
type KindBasicScalingMechanismDescription string

const (
	// KindAddRemoveIncrementalNamedPartition ...
	KindAddRemoveIncrementalNamedPartition KindBasicScalingMechanismDescription = "AddRemoveIncrementalNamedPartition"
	// KindPartitionInstanceCount ...
	KindPartitionInstanceCount KindBasicScalingMechanismDescription = "PartitionInstanceCount"
	// KindScalingMechanismDescription ...
	KindScalingMechanismDescription KindBasicScalingMechanismDescription = "ScalingMechanismDescription"
)

// PossibleKindBasicScalingMechanismDescriptionValues returns an array of possible values for the KindBasicScalingMechanismDescription const type.
func PossibleKindBasicScalingMechanismDescriptionValues() []KindBasicScalingMechanismDescription {
	return []KindBasicScalingMechanismDescription{KindAddRemoveIncrementalNamedPartition, KindPartitionInstanceCount, KindScalingMechanismDescription}
}

// KindBasicScalingTriggerDescription enumerates the values for kind basic scaling trigger description.
type KindBasicScalingTriggerDescription string

const (
	// KindAveragePartitionLoad ...
	KindAveragePartitionLoad KindBasicScalingTriggerDescription = "AveragePartitionLoad"
	// KindAverageServiceLoad ...
	KindAverageServiceLoad KindBasicScalingTriggerDescription = "AverageServiceLoad"
	// KindScalingTriggerDescription ...
	KindScalingTriggerDescription KindBasicScalingTriggerDescription = "ScalingTriggerDescription"
)

// PossibleKindBasicScalingTriggerDescriptionValues returns an array of possible values for the KindBasicScalingTriggerDescription const type.
func PossibleKindBasicScalingTriggerDescriptionValues() []KindBasicScalingTriggerDescription {
	return []KindBasicScalingTriggerDescription{KindAveragePartitionLoad, KindAverageServiceLoad, KindScalingTriggerDescription}
}

// KindBasicSecretResourcePropertiesBase enumerates the values for kind basic secret resource properties base.
type KindBasicSecretResourcePropertiesBase string

const (
	// KindInlinedValue ...
	KindInlinedValue KindBasicSecretResourcePropertiesBase = "inlinedValue"
	// KindSecretResourceProperties ...
	KindSecretResourceProperties KindBasicSecretResourcePropertiesBase = "SecretResourceProperties"
	// KindSecretResourcePropertiesBase ...
	KindSecretResourcePropertiesBase KindBasicSecretResourcePropertiesBase = "SecretResourcePropertiesBase"
)

// PossibleKindBasicSecretResourcePropertiesBaseValues returns an array of possible values for the KindBasicSecretResourcePropertiesBase const type.
func PossibleKindBasicSecretResourcePropertiesBaseValues() []KindBasicSecretResourcePropertiesBase {
	return []KindBasicSecretResourcePropertiesBase{KindInlinedValue, KindSecretResourceProperties, KindSecretResourcePropertiesBase}
}

// KindBasicServiceTypeDescription enumerates the values for kind basic service type description.
type KindBasicServiceTypeDescription string

const (
	// KindServiceTypeDescription ...
	KindServiceTypeDescription KindBasicServiceTypeDescription = "ServiceTypeDescription"
	// KindStateful ...
	KindStateful KindBasicServiceTypeDescription = "Stateful"
	// KindStateless ...
	KindStateless KindBasicServiceTypeDescription = "Stateless"
)

// PossibleKindBasicServiceTypeDescriptionValues returns an array of possible values for the KindBasicServiceTypeDescription const type.
func PossibleKindBasicServiceTypeDescriptionValues() []KindBasicServiceTypeDescription {
	return []KindBasicServiceTypeDescription{KindServiceTypeDescription, KindStateful, KindStateless}
}

// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// High Specifies the move cost of the service as High. The value is 3.
	High MoveCost = "High"
	// Low Specifies the move cost of the service as Low. The value is 1.
	Low MoveCost = "Low"
	// Medium Specifies the move cost of the service as Medium. The value is 2.
	Medium MoveCost = "Medium"
	// Zero Zero move cost. This value is zero.
	Zero MoveCost = "Zero"
)

// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{High, Low, Medium, Zero}
}

// NetworkKind enumerates the values for network kind.
type NetworkKind string

const (
	// Local Indicates a container network local to a single Service Fabric cluster. The value is 1.
	Local NetworkKind = "Local"
)

// PossibleNetworkKindValues returns an array of possible values for the NetworkKind const type.
func PossibleNetworkKindValues() []NetworkKind {
	return []NetworkKind{Local}
}

// NodeDeactivationIntent enumerates the values for node deactivation intent.
type NodeDeactivationIntent string

const (
	// NodeDeactivationIntentInvalid Indicates the node deactivation intent is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationIntentInvalid NodeDeactivationIntent = "Invalid"
	// NodeDeactivationIntentPause Indicates that the node should be paused. The value is 1.
	NodeDeactivationIntentPause NodeDeactivationIntent = "Pause"
	// NodeDeactivationIntentRemoveData Indicates that the intent is to reimage the node. Service Fabric does
	// not reimage the node, this action is done outside of Service Fabric. The value is 3.
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = "RemoveData"
	// NodeDeactivationIntentRemoveNode Indicates that the node is being decommissioned and is not expected to
	// return. Service Fabric does not decommission the node, this action is done outside of Service Fabric.
	// The value is 4.
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = "RemoveNode"
	// NodeDeactivationIntentRestart Indicates that the intent is for the node to be restarted after a short
	// period of time. Service Fabric does not restart the node, this action is done outside of Service Fabric.
	// The value is 2.
	NodeDeactivationIntentRestart NodeDeactivationIntent = "Restart"
)

// PossibleNodeDeactivationIntentValues returns an array of possible values for the NodeDeactivationIntent const type.
func PossibleNodeDeactivationIntentValues() []NodeDeactivationIntent {
	return []NodeDeactivationIntent{NodeDeactivationIntentInvalid, NodeDeactivationIntentPause, NodeDeactivationIntentRemoveData, NodeDeactivationIntentRemoveNode, NodeDeactivationIntentRestart}
}

// NodeDeactivationStatus enumerates the values for node deactivation status.
type NodeDeactivationStatus string

const (
	// NodeDeactivationStatusCompleted The task is completed. The value is 3.
	NodeDeactivationStatusCompleted NodeDeactivationStatus = "Completed"
	// NodeDeactivationStatusNone No status is associated with the task. The value is zero.
	NodeDeactivationStatusNone NodeDeactivationStatus = "None"
	// NodeDeactivationStatusSafetyCheckComplete When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that all safety checks have been completed. The value is 2.
	NodeDeactivationStatusSafetyCheckComplete NodeDeactivationStatus = "SafetyCheckComplete"
	// NodeDeactivationStatusSafetyCheckInProgress When a node is deactivated Service Fabric performs checks to
	// ensure that the operation is safe to proceed to ensure availability of the service and reliability of
	// the state. This value indicates that one or more safety checks are in progress. The value is 1.
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = "SafetyCheckInProgress"
)

// PossibleNodeDeactivationStatusValues returns an array of possible values for the NodeDeactivationStatus const type.
func PossibleNodeDeactivationStatusValues() []NodeDeactivationStatus {
	return []NodeDeactivationStatus{NodeDeactivationStatusCompleted, NodeDeactivationStatusNone, NodeDeactivationStatusSafetyCheckComplete, NodeDeactivationStatusSafetyCheckInProgress}
}

// NodeDeactivationTaskType enumerates the values for node deactivation task type.
type NodeDeactivationTaskType string

const (
	// NodeDeactivationTaskTypeClient Specifies that the task was created by using the public API. The value is
	// 3.
	NodeDeactivationTaskTypeClient NodeDeactivationTaskType = "Client"
	// NodeDeactivationTaskTypeInfrastructure Specifies the task created by Infrastructure hosting the nodes.
	// The value is 1.
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = "Infrastructure"
	// NodeDeactivationTaskTypeInvalid Indicates the node deactivation task type is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero. This value is not used.
	NodeDeactivationTaskTypeInvalid NodeDeactivationTaskType = "Invalid"
	// NodeDeactivationTaskTypeRepair Specifies the task that was created by the Repair Manager service. The
	// value is 2.
	NodeDeactivationTaskTypeRepair NodeDeactivationTaskType = "Repair"
)

// PossibleNodeDeactivationTaskTypeValues returns an array of possible values for the NodeDeactivationTaskType const type.
func PossibleNodeDeactivationTaskTypeValues() []NodeDeactivationTaskType {
	return []NodeDeactivationTaskType{NodeDeactivationTaskTypeClient, NodeDeactivationTaskTypeInfrastructure, NodeDeactivationTaskTypeInvalid, NodeDeactivationTaskTypeRepair}
}

// NodeStatus enumerates the values for node status.
type NodeStatus string

const (
	// NodeStatusDisabled Indicates the node is disabled. The value is 5.
	NodeStatusDisabled NodeStatus = "Disabled"
	// NodeStatusDisabling Indicates the node is in the process of being disabled. The value is 4.
	NodeStatusDisabling NodeStatus = "Disabling"
	// NodeStatusDown Indicates the node is down. The value is 2.
	NodeStatusDown NodeStatus = "Down"
	// NodeStatusEnabling Indicates the node is in process of being enabled. The value is 3.
	NodeStatusEnabling NodeStatus = "Enabling"
	// NodeStatusInvalid Indicates the node status is invalid. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	NodeStatusInvalid NodeStatus = "Invalid"
	// NodeStatusRemoved Indicates the node is removed. A node would be in Removed state if NodeStateRemoved
	// API has been called for this node. In other words, Service Fabric has been informed that the persisted
	// state on the node has been permanently lost. The value is 7.
	NodeStatusRemoved NodeStatus = "Removed"
	// NodeStatusUnknown Indicates the node is unknown. A node would be in Unknown state if Service Fabric does
	// not have authoritative information about that node. This can happen if the system learns about a node at
	// runtime.The value is 6.
	NodeStatusUnknown NodeStatus = "Unknown"
	// NodeStatusUp Indicates the node is up. The value is 1.
	NodeStatusUp NodeStatus = "Up"
)

// PossibleNodeStatusValues returns an array of possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{NodeStatusDisabled, NodeStatusDisabling, NodeStatusDown, NodeStatusEnabling, NodeStatusInvalid, NodeStatusRemoved, NodeStatusUnknown, NodeStatusUp}
}

// NodeStatusFilter enumerates the values for node status filter.
type NodeStatusFilter string

const (
	// All This filter value will match all of the nodes.
	All NodeStatusFilter = "all"
	// Default This filter value will match all of the nodes excepts the ones with status as Unknown or
	// Removed.
	Default NodeStatusFilter = "default"
	// Disabled This filter value will match nodes that are Disabled.
	Disabled NodeStatusFilter = "disabled"
	// Disabling This filter value will match nodes that are in the process of being disabled with status as
	// Disabling.
	Disabling NodeStatusFilter = "disabling"
	// Down This filter value will match nodes that are Down.
	Down NodeStatusFilter = "down"
	// Enabling This filter value will match nodes that are in the process of being enabled with status as
	// Enabling.
	Enabling NodeStatusFilter = "enabling"
	// Removed This filter value will match nodes whose status is Removed. These are the nodes that are removed
	// from the cluster using the RemoveNodeState API.
	Removed NodeStatusFilter = "removed"
	// Unknown This filter value will match nodes whose status is Unknown. A node would be in Unknown state if
	// Service Fabric does not have authoritative information about that node. This can happen if the system
	// learns about a node at runtime.
	Unknown NodeStatusFilter = "unknown"
	// Up This filter value will match nodes that are Up.
	Up NodeStatusFilter = "up"
)

// PossibleNodeStatusFilterValues returns an array of possible values for the NodeStatusFilter const type.
func PossibleNodeStatusFilterValues() []NodeStatusFilter {
	return []NodeStatusFilter{All, Default, Disabled, Disabling, Down, Enabling, Removed, Unknown, Up}
}

// NodeTransitionType enumerates the values for node transition type.
type NodeTransitionType string

const (
	// NodeTransitionTypeInvalid Reserved.  Do not pass into API.
	NodeTransitionTypeInvalid NodeTransitionType = "Invalid"
	// NodeTransitionTypeStart Transition a stopped node to up.
	NodeTransitionTypeStart NodeTransitionType = "Start"
	// NodeTransitionTypeStop Transition an up node to stopped.
	NodeTransitionTypeStop NodeTransitionType = "Stop"
)

// PossibleNodeTransitionTypeValues returns an array of possible values for the NodeTransitionType const type.
func PossibleNodeTransitionTypeValues() []NodeTransitionType {
	return []NodeTransitionType{NodeTransitionTypeInvalid, NodeTransitionTypeStart, NodeTransitionTypeStop}
}

// NodeUpgradePhase enumerates the values for node upgrade phase.
type NodeUpgradePhase string

const (
	// NodeUpgradePhaseInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	NodeUpgradePhaseInvalid NodeUpgradePhase = "Invalid"
	// NodeUpgradePhasePostUpgradeSafetyCheck The upgrade has completed and post upgrade safety checks are
	// being performed. The value is 3
	NodeUpgradePhasePostUpgradeSafetyCheck NodeUpgradePhase = "PostUpgradeSafetyCheck"
	// NodeUpgradePhasePreUpgradeSafetyCheck The upgrade has not started yet due to pending safety checks. The
	// value is 1
	NodeUpgradePhasePreUpgradeSafetyCheck NodeUpgradePhase = "PreUpgradeSafetyCheck"
	// NodeUpgradePhaseUpgrading The upgrade is in progress. The value is 2
	NodeUpgradePhaseUpgrading NodeUpgradePhase = "Upgrading"
)

// PossibleNodeUpgradePhaseValues returns an array of possible values for the NodeUpgradePhase const type.
func PossibleNodeUpgradePhaseValues() []NodeUpgradePhase {
	return []NodeUpgradePhase{NodeUpgradePhaseInvalid, NodeUpgradePhasePostUpgradeSafetyCheck, NodeUpgradePhasePreUpgradeSafetyCheck, NodeUpgradePhaseUpgrading}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// Linux The required operating system is Linux.
	Linux OperatingSystemType = "Linux"
	// Windows The required operating system is Windows.
	Windows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{Linux, Windows}
}

// OperationState enumerates the values for operation state.
type OperationState string

const (
	// OperationStateCancelled The operation was cancelled by the user using CancelOperation, and is no longer
	// running.
	OperationStateCancelled OperationState = "Cancelled"
	// OperationStateCompleted The operation has completed successfully and is no longer running.
	OperationStateCompleted OperationState = "Completed"
	// OperationStateFaulted The operation has failed and is no longer running.
	OperationStateFaulted OperationState = "Faulted"
	// OperationStateForceCancelled The operation was cancelled by the user using CancelOperation, with the
	// force parameter set to true.  It is no longer running.  Refer to CancelOperation for more details.
	OperationStateForceCancelled OperationState = "ForceCancelled"
	// OperationStateInvalid The operation state is invalid.
	OperationStateInvalid OperationState = "Invalid"
	// OperationStateRollingBack The operation is rolling back internal system state because it encountered a
	// fatal error or was cancelled by the user.  "RollingBack"     does not refer to user state.  For example,
	// if CancelOperation is called on a command of type PartitionDataLoss, state of "RollingBack" does not
	// mean service data is being restored (assuming the command has progressed far enough to cause data loss).
	// It means the system is rolling back/cleaning up internal system state associated with the command.
	OperationStateRollingBack OperationState = "RollingBack"
	// OperationStateRunning The operation is in progress.
	OperationStateRunning OperationState = "Running"
)

// PossibleOperationStateValues returns an array of possible values for the OperationState const type.
func PossibleOperationStateValues() []OperationState {
	return []OperationState{OperationStateCancelled, OperationStateCompleted, OperationStateFaulted, OperationStateForceCancelled, OperationStateInvalid, OperationStateRollingBack, OperationStateRunning}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid The operation state is invalid.
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeNodeTransition An operation started using the StartNodeTransition API.
	OperationTypeNodeTransition OperationType = "NodeTransition"
	// OperationTypePartitionDataLoss An operation started using the StartDataLoss API.
	OperationTypePartitionDataLoss OperationType = "PartitionDataLoss"
	// OperationTypePartitionQuorumLoss An operation started using the StartQuorumLoss API.
	OperationTypePartitionQuorumLoss OperationType = "PartitionQuorumLoss"
	// OperationTypePartitionRestart An operation started using the StartPartitionRestart API.
	OperationTypePartitionRestart OperationType = "PartitionRestart"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeNodeTransition, OperationTypePartitionDataLoss, OperationTypePartitionQuorumLoss, OperationTypePartitionRestart}
}

// PackageSharingPolicyScope enumerates the values for package sharing policy scope.
type PackageSharingPolicyScope string

const (
	// PackageSharingPolicyScopeAll Share all code, config and data packages from corresponding service
	// manifest. The value is 1.
	PackageSharingPolicyScopeAll PackageSharingPolicyScope = "All"
	// PackageSharingPolicyScopeCode Share all code packages from corresponding service manifest. The value is
	// 2.
	PackageSharingPolicyScopeCode PackageSharingPolicyScope = "Code"
	// PackageSharingPolicyScopeConfig Share all config packages from corresponding service manifest. The value
	// is 3.
	PackageSharingPolicyScopeConfig PackageSharingPolicyScope = "Config"
	// PackageSharingPolicyScopeData Share all data packages from corresponding service manifest. The value is
	// 4.
	PackageSharingPolicyScopeData PackageSharingPolicyScope = "Data"
	// PackageSharingPolicyScopeNone No package sharing policy scope. The value is 0.
	PackageSharingPolicyScopeNone PackageSharingPolicyScope = "None"
)

// PossiblePackageSharingPolicyScopeValues returns an array of possible values for the PackageSharingPolicyScope const type.
func PossiblePackageSharingPolicyScopeValues() []PackageSharingPolicyScope {
	return []PackageSharingPolicyScope{PackageSharingPolicyScopeAll, PackageSharingPolicyScopeCode, PackageSharingPolicyScopeConfig, PackageSharingPolicyScopeData, PackageSharingPolicyScopeNone}
}

// PartitionAccessStatus enumerates the values for partition access status.
type PartitionAccessStatus string

const (
	// PartitionAccessStatusGranted Indicates that the read or write operation access is granted and the
	// operation is allowed.
	PartitionAccessStatusGranted PartitionAccessStatus = "Granted"
	// PartitionAccessStatusInvalid Indicates that the read or write operation access status is not valid. This
	// value is not returned to the caller.
	PartitionAccessStatusInvalid PartitionAccessStatus = "Invalid"
	// PartitionAccessStatusNotPrimary Indicates that this client request was received by a replica that is not
	// a Primary replica.
	PartitionAccessStatusNotPrimary PartitionAccessStatus = "NotPrimary"
	// PartitionAccessStatusNoWriteQuorum Indicates that no write quorum is available and, therefore, no write
	// operation can be accepted.
	PartitionAccessStatusNoWriteQuorum PartitionAccessStatus = "NoWriteQuorum"
	// PartitionAccessStatusReconfigurationPending Indicates that the client should try again later, because a
	// reconfiguration is in progress.
	PartitionAccessStatusReconfigurationPending PartitionAccessStatus = "ReconfigurationPending"
)

// PossiblePartitionAccessStatusValues returns an array of possible values for the PartitionAccessStatus const type.
func PossiblePartitionAccessStatusValues() []PartitionAccessStatus {
	return []PartitionAccessStatus{PartitionAccessStatusGranted, PartitionAccessStatusInvalid, PartitionAccessStatusNotPrimary, PartitionAccessStatusNoWriteQuorum, PartitionAccessStatusReconfigurationPending}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeInvalid Indicates the partition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PartitionSchemeInvalid PartitionScheme = "Invalid"
	// PartitionSchemeNamed Indicates that the partition is based on string names, and is a
	// NamedPartitionSchemeDescription object. The value is 3
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemeSingleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeInvalid, PartitionSchemeNamed, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeNamed1 ...
	PartitionSchemeNamed1 PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeSingleton1 ...
	PartitionSchemeSingleton1 PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeUniformInt64Range1 ...
	PartitionSchemeUniformInt64Range1 PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeNamed1, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton1, PartitionSchemeUniformInt64Range1}
}

// PropertyBatchInfoKind enumerates the values for property batch info kind.
type PropertyBatchInfoKind string

const (
	// PropertyBatchInfoKindFailed The property batch failed.
	PropertyBatchInfoKindFailed PropertyBatchInfoKind = "Failed"
	// PropertyBatchInfoKindInvalid Indicates the property batch info is invalid. All Service Fabric
	// enumerations have the invalid type.
	PropertyBatchInfoKindInvalid PropertyBatchInfoKind = "Invalid"
	// PropertyBatchInfoKindSuccessful The property batch succeeded.
	PropertyBatchInfoKindSuccessful PropertyBatchInfoKind = "Successful"
)

// PossiblePropertyBatchInfoKindValues returns an array of possible values for the PropertyBatchInfoKind const type.
func PossiblePropertyBatchInfoKindValues() []PropertyBatchInfoKind {
	return []PropertyBatchInfoKind{PropertyBatchInfoKindFailed, PropertyBatchInfoKindInvalid, PropertyBatchInfoKindSuccessful}
}

// PropertyBatchOperationKind enumerates the values for property batch operation kind.
type PropertyBatchOperationKind string

const (
	// PropertyBatchOperationKindCheckExists The operation will check that a property exists or doesn't exists,
	// depending on the provided value. The value is 3.
	PropertyBatchOperationKindCheckExists PropertyBatchOperationKind = "CheckExists"
	// PropertyBatchOperationKindCheckSequence The operation will ensure that the sequence number is equal to
	// the provided value. The value is 4.
	PropertyBatchOperationKindCheckSequence PropertyBatchOperationKind = "CheckSequence"
	// PropertyBatchOperationKindCheckValue The operation will ensure that the value of a property is equal to
	// the provided value. The value is 7.
	PropertyBatchOperationKindCheckValue PropertyBatchOperationKind = "CheckValue"
	// PropertyBatchOperationKindDelete The operation will delete a property. The value is 5.
	PropertyBatchOperationKindDelete PropertyBatchOperationKind = "Delete"
	// PropertyBatchOperationKindGet The operation will get a property. The value is 2.
	PropertyBatchOperationKindGet PropertyBatchOperationKind = "Get"
	// PropertyBatchOperationKindInvalid Indicates the property operation is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	PropertyBatchOperationKindInvalid PropertyBatchOperationKind = "Invalid"
	// PropertyBatchOperationKindPut The operation will create or edit a property. The value is 1.
	PropertyBatchOperationKindPut PropertyBatchOperationKind = "Put"
)

// PossiblePropertyBatchOperationKindValues returns an array of possible values for the PropertyBatchOperationKind const type.
func PossiblePropertyBatchOperationKindValues() []PropertyBatchOperationKind {
	return []PropertyBatchOperationKind{PropertyBatchOperationKindCheckExists, PropertyBatchOperationKindCheckSequence, PropertyBatchOperationKindCheckValue, PropertyBatchOperationKindDelete, PropertyBatchOperationKindGet, PropertyBatchOperationKindInvalid, PropertyBatchOperationKindPut}
}

// PropertyValueKind enumerates the values for property value kind.
type PropertyValueKind string

const (
	// PropertyValueKindBinary The data inside the property is a binary blob. The value is 1.
	PropertyValueKindBinary PropertyValueKind = "Binary"
	// PropertyValueKindDouble The data inside the property is a double. The value is 3.
	PropertyValueKindDouble PropertyValueKind = "Double"
	// PropertyValueKindGUID The data inside the property is a guid. The value is 5.
	PropertyValueKindGUID PropertyValueKind = "Guid"
	// PropertyValueKindInt64 The data inside the property is an int64. The value is 2.
	PropertyValueKindInt64 PropertyValueKind = "Int64"
	// PropertyValueKindInvalid Indicates the property is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PropertyValueKindInvalid PropertyValueKind = "Invalid"
	// PropertyValueKindString The data inside the property is a string. The value is 4.
	PropertyValueKindString PropertyValueKind = "String"
)

// PossiblePropertyValueKindValues returns an array of possible values for the PropertyValueKind const type.
func PossiblePropertyValueKindValues() []PropertyValueKind {
	return []PropertyValueKind{PropertyValueKindBinary, PropertyValueKindDouble, PropertyValueKindGUID, PropertyValueKindInt64, PropertyValueKindInvalid, PropertyValueKindString}
}

// ProvisionApplicationTypeKind enumerates the values for provision application type kind.
type ProvisionApplicationTypeKind string

const (
	// ProvisionApplicationTypeKindExternalStore Indicates that the provision is for an application package
	// that was previously uploaded to an external store. The application package ends with the extension
	// *.sfpkg. The value is 2.
	ProvisionApplicationTypeKindExternalStore ProvisionApplicationTypeKind = "ExternalStore"
	// ProvisionApplicationTypeKindImageStorePath Indicates that the provision is for a package that was
	// previously uploaded to the image store. The value is 1.
	ProvisionApplicationTypeKindImageStorePath ProvisionApplicationTypeKind = "ImageStorePath"
	// ProvisionApplicationTypeKindInvalid Indicates that the provision kind is invalid. This value is default
	// and should not be used. The value is zero.
	ProvisionApplicationTypeKindInvalid ProvisionApplicationTypeKind = "Invalid"
)

// PossibleProvisionApplicationTypeKindValues returns an array of possible values for the ProvisionApplicationTypeKind const type.
func PossibleProvisionApplicationTypeKindValues() []ProvisionApplicationTypeKind {
	return []ProvisionApplicationTypeKind{ProvisionApplicationTypeKindExternalStore, ProvisionApplicationTypeKindImageStorePath, ProvisionApplicationTypeKindInvalid}
}

// QuorumLossMode enumerates the values for quorum loss mode.
type QuorumLossMode string

const (
	// QuorumLossModeAllReplicas ...
	QuorumLossModeAllReplicas QuorumLossMode = "AllReplicas"
	// QuorumLossModeInvalid Reserved.  Do not pass into API.
	QuorumLossModeInvalid QuorumLossMode = "Invalid"
	// QuorumLossModeQuorumReplicas Partial Quorum loss mode : Minimum number of replicas for a partition will
	// be down that will cause a quorum loss.
	QuorumLossModeQuorumReplicas QuorumLossMode = "QuorumReplicas"
)

// PossibleQuorumLossModeValues returns an array of possible values for the QuorumLossMode const type.
func PossibleQuorumLossModeValues() []QuorumLossMode {
	return []QuorumLossMode{QuorumLossModeAllReplicas, QuorumLossModeInvalid, QuorumLossModeQuorumReplicas}
}

// ReconfigurationPhase enumerates the values for reconfiguration phase.
type ReconfigurationPhase string

const (
	// ReconfigurationPhaseAbortPhaseZero This phase is for internal use only.
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = "AbortPhaseZero"
	// ReconfigurationPhaseNone Specifies that there is no reconfiguration in progress.
	ReconfigurationPhaseNone ReconfigurationPhase = "None"
	// ReconfigurationPhasePhase0 Refers to the phase where the reconfiguration is transferring data from the
	// previous primary to the new primary.
	ReconfigurationPhasePhase0 ReconfigurationPhase = "Phase0"
	// ReconfigurationPhasePhase1 Refers to the phase where the reconfiguration is querying the replica set for
	// the progress.
	ReconfigurationPhasePhase1 ReconfigurationPhase = "Phase1"
	// ReconfigurationPhasePhase2 Refers to the phase where the reconfiguration is ensuring that data from the
	// current primary is present in a majority of the replica set.
	ReconfigurationPhasePhase2 ReconfigurationPhase = "Phase2"
	// ReconfigurationPhasePhase3 This phase is for internal use only.
	ReconfigurationPhasePhase3 ReconfigurationPhase = "Phase3"
	// ReconfigurationPhasePhase4 This phase is for internal use only.
	ReconfigurationPhasePhase4 ReconfigurationPhase = "Phase4"
	// ReconfigurationPhaseUnknown Indicates the invalid reconfiguration phase.
	ReconfigurationPhaseUnknown ReconfigurationPhase = "Unknown"
)

// PossibleReconfigurationPhaseValues returns an array of possible values for the ReconfigurationPhase const type.
func PossibleReconfigurationPhaseValues() []ReconfigurationPhase {
	return []ReconfigurationPhase{ReconfigurationPhaseAbortPhaseZero, ReconfigurationPhaseNone, ReconfigurationPhasePhase0, ReconfigurationPhasePhase1, ReconfigurationPhasePhase2, ReconfigurationPhasePhase3, ReconfigurationPhasePhase4, ReconfigurationPhaseUnknown}
}

// ReconfigurationType enumerates the values for reconfiguration type.
type ReconfigurationType string

const (
	// ReconfigurationTypeFailover Reconfiguration triggered in response to a primary going down. This could be
	// due to many reasons such as primary replica crashing etc.
	ReconfigurationTypeFailover ReconfigurationType = "Failover"
	// ReconfigurationTypeOther Reconfigurations where the primary replica is not changing.
	ReconfigurationTypeOther ReconfigurationType = "Other"
	// ReconfigurationTypeSwapPrimary Specifies that the primary replica is being swapped with a different
	// replica.
	ReconfigurationTypeSwapPrimary ReconfigurationType = "SwapPrimary"
	// ReconfigurationTypeUnknown Indicates the invalid reconfiguration type.
	ReconfigurationTypeUnknown ReconfigurationType = "Unknown"
)

// PossibleReconfigurationTypeValues returns an array of possible values for the ReconfigurationType const type.
func PossibleReconfigurationTypeValues() []ReconfigurationType {
	return []ReconfigurationType{ReconfigurationTypeFailover, ReconfigurationTypeOther, ReconfigurationTypeSwapPrimary, ReconfigurationTypeUnknown}
}

// RepairImpactKind enumerates the values for repair impact kind.
type RepairImpactKind string

const (
	// RepairImpactKindInvalid The repair impact is not valid or is of an unknown type.
	RepairImpactKindInvalid RepairImpactKind = "Invalid"
	// RepairImpactKindNode The repair impact affects a set of Service Fabric nodes.
	RepairImpactKindNode RepairImpactKind = "Node"
)

// PossibleRepairImpactKindValues returns an array of possible values for the RepairImpactKind const type.
func PossibleRepairImpactKindValues() []RepairImpactKind {
	return []RepairImpactKind{RepairImpactKindInvalid, RepairImpactKindNode}
}

// RepairTargetKind enumerates the values for repair target kind.
type RepairTargetKind string

const (
	// RepairTargetKindInvalid The repair target is not valid or is of an unknown type.
	RepairTargetKindInvalid RepairTargetKind = "Invalid"
	// RepairTargetKindNode The repair target is a set of Service Fabric nodes.
	RepairTargetKindNode RepairTargetKind = "Node"
)

// PossibleRepairTargetKindValues returns an array of possible values for the RepairTargetKind const type.
func PossibleRepairTargetKindValues() []RepairTargetKind {
	return []RepairTargetKind{RepairTargetKindInvalid, RepairTargetKindNode}
}

// RepairTaskHealthCheckState enumerates the values for repair task health check state.
type RepairTaskHealthCheckState string

const (
	// InProgress Indicates that the health check is in progress.
	InProgress RepairTaskHealthCheckState = "InProgress"
	// NotStarted Indicates that the health check has not started.
	NotStarted RepairTaskHealthCheckState = "NotStarted"
	// Skipped Indicates that the health check was skipped.
	Skipped RepairTaskHealthCheckState = "Skipped"
	// Succeeded Indicates that the health check succeeded.
	Succeeded RepairTaskHealthCheckState = "Succeeded"
	// TimedOut Indicates that the health check timed out.
	TimedOut RepairTaskHealthCheckState = "TimedOut"
)

// PossibleRepairTaskHealthCheckStateValues returns an array of possible values for the RepairTaskHealthCheckState const type.
func PossibleRepairTaskHealthCheckStateValues() []RepairTaskHealthCheckState {
	return []RepairTaskHealthCheckState{InProgress, NotStarted, Skipped, Succeeded, TimedOut}
}

// ReplicaHealthReportServiceKind enumerates the values for replica health report service kind.
type ReplicaHealthReportServiceKind string

const (
	// Stateful Uses Service Fabric to make its state or part of its state highly available and reliable. The
	// value is 2.
	Stateful ReplicaHealthReportServiceKind = "Stateful"
	// Stateless Does not use Service Fabric to make its state highly available or reliable. The value is 1
	Stateless ReplicaHealthReportServiceKind = "Stateless"
)

// PossibleReplicaHealthReportServiceKindValues returns an array of possible values for the ReplicaHealthReportServiceKind const type.
func PossibleReplicaHealthReportServiceKindValues() []ReplicaHealthReportServiceKind {
	return []ReplicaHealthReportServiceKind{Stateful, Stateless}
}

// ReplicaKind enumerates the values for replica kind.
type ReplicaKind string

const (
	// ReplicaKindInvalid Represents an invalid replica kind. The value is zero.
	ReplicaKindInvalid ReplicaKind = "Invalid"
	// ReplicaKindKeyValueStore Represents a key value store replica. The value is 1
	ReplicaKindKeyValueStore ReplicaKind = "KeyValueStore"
)

// PossibleReplicaKindValues returns an array of possible values for the ReplicaKind const type.
func PossibleReplicaKindValues() []ReplicaKind {
	return []ReplicaKind{ReplicaKindInvalid, ReplicaKindKeyValueStore}
}

// ReplicaRole enumerates the values for replica role.
type ReplicaRole string

const (
	// ReplicaRoleActiveSecondary Refers to a replica in the set that receives state updates from the Primary
	// replica, applies them, and sends acknowledgements back. Secondary replicas must participate in the write
	// quorum for a replica set. There can be multiple active Secondary replicas in a replica set at a time.
	// The number of active Secondary replicas is configurable that the reliability subsystem should maintain.
	// The value is 4.
	ReplicaRoleActiveSecondary ReplicaRole = "ActiveSecondary"
	// ReplicaRoleIdleSecondary Refers to a replica in the set that receives a state transfer from the Primary
	// replica to prepare for becoming an active Secondary replica. There can be multiple Idle Secondary
	// replicas in a replica set at a time. Idle Secondary replicas do not count as a part of a write quorum.
	// The value is 3.
	ReplicaRoleIdleSecondary ReplicaRole = "IdleSecondary"
	// ReplicaRoleNone Specifies that the replica has no responsibility in regard to the replica set. The value
	// is 1
	ReplicaRoleNone ReplicaRole = "None"
	// ReplicaRolePrimary Refers to the replica in the set on which all read and write operations are complete
	// in order to enforce strong consistency semantics. Read operations are handled directly by the Primary
	// replica, while write operations must be acknowledged by a quorum of the replicas in the replica set.
	// There can only be one Primary replica in a replica set at a time. The value is 2.
	ReplicaRolePrimary ReplicaRole = "Primary"
	// ReplicaRoleUnknown Indicates the initial role that a replica is created in. The value is zero.
	ReplicaRoleUnknown ReplicaRole = "Unknown"
)

// PossibleReplicaRoleValues returns an array of possible values for the ReplicaRole const type.
func PossibleReplicaRoleValues() []ReplicaRole {
	return []ReplicaRole{ReplicaRoleActiveSecondary, ReplicaRoleIdleSecondary, ReplicaRoleNone, ReplicaRolePrimary, ReplicaRoleUnknown}
}

// ReplicaStatus enumerates the values for replica status.
type ReplicaStatus string

const (
	// ReplicaStatusDown The replica is down. The value is 4.
	ReplicaStatusDown ReplicaStatus = "Down"
	// ReplicaStatusDropped Replica is dropped. This means that the replica has been removed from the replica
	// set. If it is persisted, its state has been deleted. The value is 5.
	ReplicaStatusDropped ReplicaStatus = "Dropped"
	// ReplicaStatusInBuild The replica is being built. This means that a primary replica is seeding this
	// replica. The value is 1.
	ReplicaStatusInBuild ReplicaStatus = "InBuild"
	// ReplicaStatusInvalid Indicates the replica status is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ReplicaStatusInvalid ReplicaStatus = "Invalid"
	// ReplicaStatusReady The replica is ready. The value is 3.
	ReplicaStatusReady ReplicaStatus = "Ready"
	// ReplicaStatusStandby The replica is in standby. The value is 2.
	ReplicaStatusStandby ReplicaStatus = "Standby"
)

// PossibleReplicaStatusValues returns an array of possible values for the ReplicaStatus const type.
func PossibleReplicaStatusValues() []ReplicaStatus {
	return []ReplicaStatus{ReplicaStatusDown, ReplicaStatusDropped, ReplicaStatusInBuild, ReplicaStatusInvalid, ReplicaStatusReady, ReplicaStatusStandby}
}

// ReplicatorOperationName enumerates the values for replicator operation name.
type ReplicatorOperationName string

const (
	// ReplicatorOperationNameAbort Replicator is being aborted.
	ReplicatorOperationNameAbort ReplicatorOperationName = "Abort"
	// ReplicatorOperationNameBuild Replicator is in the process of building one or more replicas.
	ReplicatorOperationNameBuild ReplicatorOperationName = "Build"
	// ReplicatorOperationNameChangeRole Replicator is in the process of changing its role.
	ReplicatorOperationNameChangeRole ReplicatorOperationName = "ChangeRole"
	// ReplicatorOperationNameClose Replicator is closing.
	ReplicatorOperationNameClose ReplicatorOperationName = "Close"
	// ReplicatorOperationNameInvalid Default value if the replicator is not yet ready.
	ReplicatorOperationNameInvalid ReplicatorOperationName = "Invalid"
	// ReplicatorOperationNameNone Replicator is not running any operation from Service Fabric perspective.
	ReplicatorOperationNameNone ReplicatorOperationName = "None"
	// ReplicatorOperationNameOnDataLoss Replicator is handling the data loss condition, where the user service
	// may potentially be recovering state from an external source.
	ReplicatorOperationNameOnDataLoss ReplicatorOperationName = "OnDataLoss"
	// ReplicatorOperationNameOpen Replicator is opening.
	ReplicatorOperationNameOpen ReplicatorOperationName = "Open"
	// ReplicatorOperationNameUpdateEpoch Due to a change in the replica set, replicator is being updated with
	// its Epoch.
	ReplicatorOperationNameUpdateEpoch ReplicatorOperationName = "UpdateEpoch"
	// ReplicatorOperationNameWaitForCatchup Replicator is waiting for a quorum of replicas to be caught up to
	// the latest state.
	ReplicatorOperationNameWaitForCatchup ReplicatorOperationName = "WaitForCatchup"
)

// PossibleReplicatorOperationNameValues returns an array of possible values for the ReplicatorOperationName const type.
func PossibleReplicatorOperationNameValues() []ReplicatorOperationName {
	return []ReplicatorOperationName{ReplicatorOperationNameAbort, ReplicatorOperationNameBuild, ReplicatorOperationNameChangeRole, ReplicatorOperationNameClose, ReplicatorOperationNameInvalid, ReplicatorOperationNameNone, ReplicatorOperationNameOnDataLoss, ReplicatorOperationNameOpen, ReplicatorOperationNameUpdateEpoch, ReplicatorOperationNameWaitForCatchup}
}

// ResourceStatus enumerates the values for resource status.
type ResourceStatus string

const (
	// ResourceStatusCreating Indicates the resource is being created. The value is 3.
	ResourceStatusCreating ResourceStatus = "Creating"
	// ResourceStatusDeleting Indicates the resource is being deletd. The value is 4.
	ResourceStatusDeleting ResourceStatus = "Deleting"
	// ResourceStatusFailed Indicates the resource is not functional due to persistent failures. See
	// statusDetails property for more details. The value is 5.
	ResourceStatusFailed ResourceStatus = "Failed"
	// ResourceStatusReady Indicates the resource is ready. The value is 1.
	ResourceStatusReady ResourceStatus = "Ready"
	// ResourceStatusUnknown Indicates the resource status is unknown. The value is zero.
	ResourceStatusUnknown ResourceStatus = "Unknown"
	// ResourceStatusUpgrading Indicates the resource is upgrading. The value is 2.
	ResourceStatusUpgrading ResourceStatus = "Upgrading"
)

// PossibleResourceStatusValues returns an array of possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{ResourceStatusCreating, ResourceStatusDeleting, ResourceStatusFailed, ResourceStatusReady, ResourceStatusUnknown, ResourceStatusUpgrading}
}

// RestartPartitionMode enumerates the values for restart partition mode.
type RestartPartitionMode string

const (
	// RestartPartitionModeAllReplicasOrInstances All replicas or instances in the partition are restarted at
	// once.
	RestartPartitionModeAllReplicasOrInstances RestartPartitionMode = "AllReplicasOrInstances"
	// RestartPartitionModeInvalid Reserved.  Do not pass into API.
	RestartPartitionModeInvalid RestartPartitionMode = "Invalid"
	// RestartPartitionModeOnlyActiveSecondaries Only the secondary replicas are restarted.
	RestartPartitionModeOnlyActiveSecondaries RestartPartitionMode = "OnlyActiveSecondaries"
)

// PossibleRestartPartitionModeValues returns an array of possible values for the RestartPartitionMode const type.
func PossibleRestartPartitionModeValues() []RestartPartitionMode {
	return []RestartPartitionMode{RestartPartitionModeAllReplicasOrInstances, RestartPartitionModeInvalid, RestartPartitionModeOnlyActiveSecondaries}
}

// RestoreState enumerates the values for restore state.
type RestoreState string

const (
	// RestoreStateAccepted Operation has been validated and accepted. Restore is yet to be triggered.
	RestoreStateAccepted RestoreState = "Accepted"
	// RestoreStateFailure Operation completed with failure.
	RestoreStateFailure RestoreState = "Failure"
	// RestoreStateInvalid Indicates an invalid restore state. All Service Fabric enumerations have the invalid
	// type.
	RestoreStateInvalid RestoreState = "Invalid"
	// RestoreStateRestoreInProgress Restore operation has been triggered and is under process.
	RestoreStateRestoreInProgress RestoreState = "RestoreInProgress"
	// RestoreStateSuccess Operation completed with success.
	RestoreStateSuccess RestoreState = "Success"
	// RestoreStateTimeout Operation timed out.
	RestoreStateTimeout RestoreState = "Timeout"
)

// PossibleRestoreStateValues returns an array of possible values for the RestoreState const type.
func PossibleRestoreStateValues() []RestoreState {
	return []RestoreState{RestoreStateAccepted, RestoreStateFailure, RestoreStateInvalid, RestoreStateRestoreInProgress, RestoreStateSuccess, RestoreStateTimeout}
}

// ResultStatus enumerates the values for result status.
type ResultStatus string

const (
	// ResultStatusCancelled Indicates that the repair task was cancelled prior to execution.
	ResultStatusCancelled ResultStatus = "Cancelled"
	// ResultStatusFailed Indicates that there was a failure during execution of the repair task. Some work may
	// have been performed.
	ResultStatusFailed ResultStatus = "Failed"
	// ResultStatusInterrupted Indicates that execution of the repair task was interrupted by a cancellation
	// request after some work had already been performed.
	ResultStatusInterrupted ResultStatus = "Interrupted"
	// ResultStatusInvalid Indicates that the repair task result is invalid. All Service Fabric enumerations
	// have the invalid value.
	ResultStatusInvalid ResultStatus = "Invalid"
	// ResultStatusPending Indicates that the repair task result is not yet available, because the repair task
	// has not finished executing.
	ResultStatusPending ResultStatus = "Pending"
	// ResultStatusSucceeded Indicates that the repair task completed execution successfully.
	ResultStatusSucceeded ResultStatus = "Succeeded"
)

// PossibleResultStatusValues returns an array of possible values for the ResultStatus const type.
func PossibleResultStatusValues() []ResultStatus {
	return []ResultStatus{ResultStatusCancelled, ResultStatusFailed, ResultStatusInterrupted, ResultStatusInvalid, ResultStatusPending, ResultStatusSucceeded}
}

// RetentionPolicyType enumerates the values for retention policy type.
type RetentionPolicyType string

const (
	// RetentionPolicyTypeBasic Indicates a basic retention policy type.
	RetentionPolicyTypeBasic RetentionPolicyType = "Basic"
	// RetentionPolicyTypeInvalid Indicates an invalid retention policy type.
	RetentionPolicyTypeInvalid RetentionPolicyType = "Invalid"
)

// PossibleRetentionPolicyTypeValues returns an array of possible values for the RetentionPolicyType const type.
func PossibleRetentionPolicyTypeValues() []RetentionPolicyType {
	return []RetentionPolicyType{RetentionPolicyTypeBasic, RetentionPolicyTypeInvalid}
}

// RetentionPolicyTypeBasicBasicRetentionPolicyDescription enumerates the values for retention policy type
// basic basic retention policy description.
type RetentionPolicyTypeBasicBasicRetentionPolicyDescription string

const (
	// RetentionPolicyTypeBasic1 ...
	RetentionPolicyTypeBasic1 RetentionPolicyTypeBasicBasicRetentionPolicyDescription = "Basic"
	// RetentionPolicyTypeRetentionPolicyDescription ...
	RetentionPolicyTypeRetentionPolicyDescription RetentionPolicyTypeBasicBasicRetentionPolicyDescription = "RetentionPolicyDescription"
)

// PossibleRetentionPolicyTypeBasicBasicRetentionPolicyDescriptionValues returns an array of possible values for the RetentionPolicyTypeBasicBasicRetentionPolicyDescription const type.
func PossibleRetentionPolicyTypeBasicBasicRetentionPolicyDescriptionValues() []RetentionPolicyTypeBasicBasicRetentionPolicyDescription {
	return []RetentionPolicyTypeBasicBasicRetentionPolicyDescription{RetentionPolicyTypeBasic1, RetentionPolicyTypeRetentionPolicyDescription}
}

// SafetyCheckKind enumerates the values for safety check kind.
type SafetyCheckKind string

const (
	// SafetyCheckKindEnsureAvailability Indicates that there is either a stateless service partition on the
	// node having exactly one instance, or there is a primary replica on the node for which the partition is
	// quorum loss. In both cases, bringing down the replicas due to upgrade will result in loss of
	// availability. The value is 7.
	SafetyCheckKindEnsureAvailability SafetyCheckKind = "EnsureAvailability"
	// SafetyCheckKindEnsurePartitionQuorum Indicates that there is some partition for which if we bring down
	// the replica on the node, it will result in quorum loss for that partition. The value is 2.
	SafetyCheckKindEnsurePartitionQuorum SafetyCheckKind = "EnsurePartitionQuorum"
	// SafetyCheckKindEnsureSeedNodeQuorum Indicates that if we bring down the node then this will result in
	// global seed node quorum loss. The value is 1.
	SafetyCheckKindEnsureSeedNodeQuorum SafetyCheckKind = "EnsureSeedNodeQuorum"
	// SafetyCheckKindInvalid Indicates that the upgrade safety check kind is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	SafetyCheckKindInvalid SafetyCheckKind = "Invalid"
	// SafetyCheckKindWaitForInbuildReplica Indicates that there is either a replica on the node that is going
	// through copy, or there is a primary replica on the node that is copying data to some other replica. In
	// both cases, bringing down the replica on the node due to upgrade will abort the copy. The value is 6.
	SafetyCheckKindWaitForInbuildReplica SafetyCheckKind = "WaitForInbuildReplica"
	// SafetyCheckKindWaitForPrimaryPlacement Indicates that there is some replica on the node that was moved
	// out of this node due to upgrade. Service Fabric is now waiting for the primary to be moved back to this
	// node. The value is 3.
	SafetyCheckKindWaitForPrimaryPlacement SafetyCheckKind = "WaitForPrimaryPlacement"
	// SafetyCheckKindWaitForPrimarySwap Indicates that Service Fabric is waiting for a primary replica to be
	// moved out of the node before starting upgrade on that node. The value is 4.
	SafetyCheckKindWaitForPrimarySwap SafetyCheckKind = "WaitForPrimarySwap"
	// SafetyCheckKindWaitForReconfiguration Indicates that there is some replica on the node that is involved
	// in a reconfiguration. Service Fabric is waiting for the reconfiguration to be complete before staring
	// upgrade on that node. The value is 5.
	SafetyCheckKindWaitForReconfiguration SafetyCheckKind = "WaitForReconfiguration"
)

// PossibleSafetyCheckKindValues returns an array of possible values for the SafetyCheckKind const type.
func PossibleSafetyCheckKindValues() []SafetyCheckKind {
	return []SafetyCheckKind{SafetyCheckKindEnsureAvailability, SafetyCheckKindEnsurePartitionQuorum, SafetyCheckKindEnsureSeedNodeQuorum, SafetyCheckKindInvalid, SafetyCheckKindWaitForInbuildReplica, SafetyCheckKindWaitForPrimaryPlacement, SafetyCheckKindWaitForPrimarySwap, SafetyCheckKindWaitForReconfiguration}
}

// ScalingMechanismKind enumerates the values for scaling mechanism kind.
type ScalingMechanismKind string

const (
	// ScalingMechanismKindAddRemoveIncrementalNamedPartition Indicates a mechanism for scaling where new named
	// partitions are added or removed from a service. The value is 2.
	ScalingMechanismKindAddRemoveIncrementalNamedPartition ScalingMechanismKind = "AddRemoveIncrementalNamedPartition"
	// ScalingMechanismKindInvalid Indicates the scaling mechanism is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ScalingMechanismKindInvalid ScalingMechanismKind = "Invalid"
	// ScalingMechanismKindPartitionInstanceCount Indicates a mechanism for scaling where new instances are
	// added or removed from a partition. The value is 1.
	ScalingMechanismKindPartitionInstanceCount ScalingMechanismKind = "PartitionInstanceCount"
)

// PossibleScalingMechanismKindValues returns an array of possible values for the ScalingMechanismKind const type.
func PossibleScalingMechanismKindValues() []ScalingMechanismKind {
	return []ScalingMechanismKind{ScalingMechanismKindAddRemoveIncrementalNamedPartition, ScalingMechanismKindInvalid, ScalingMechanismKindPartitionInstanceCount}
}

// ScalingTriggerKind enumerates the values for scaling trigger kind.
type ScalingTriggerKind string

const (
	// ScalingTriggerKindAveragePartitionLoad Indicates a trigger where scaling decisions are made based on
	// average load of a partition. The value is 1.
	ScalingTriggerKindAveragePartitionLoad ScalingTriggerKind = "AveragePartitionLoad"
	// ScalingTriggerKindAverageServiceLoad Indicates a trigger where scaling decisions are made based on
	// average load of a service. The value is 2.
	ScalingTriggerKindAverageServiceLoad ScalingTriggerKind = "AverageServiceLoad"
	// ScalingTriggerKindInvalid Indicates the scaling trigger is invalid. All Service Fabric enumerations have
	// the invalid type. The value is zero.
	ScalingTriggerKindInvalid ScalingTriggerKind = "Invalid"
)

// PossibleScalingTriggerKindValues returns an array of possible values for the ScalingTriggerKind const type.
func PossibleScalingTriggerKindValues() []ScalingTriggerKind {
	return []ScalingTriggerKind{ScalingTriggerKindAveragePartitionLoad, ScalingTriggerKindAverageServiceLoad, ScalingTriggerKindInvalid}
}

// ScheduleKind enumerates the values for schedule kind.
type ScheduleKind string

const (
	// ScheduleKindBackupScheduleDescription ...
	ScheduleKindBackupScheduleDescription ScheduleKind = "BackupScheduleDescription"
	// ScheduleKindFrequencyBased ...
	ScheduleKindFrequencyBased ScheduleKind = "FrequencyBased"
	// ScheduleKindTimeBased ...
	ScheduleKindTimeBased ScheduleKind = "TimeBased"
)

// PossibleScheduleKindValues returns an array of possible values for the ScheduleKind const type.
func PossibleScheduleKindValues() []ScheduleKind {
	return []ScheduleKind{ScheduleKindBackupScheduleDescription, ScheduleKindFrequencyBased, ScheduleKindTimeBased}
}

// SecretKind enumerates the values for secret kind.
type SecretKind string

const (
	// InlinedValue A simple secret resource whose plaintext value is provided by the user.
	InlinedValue SecretKind = "inlinedValue"
)

// PossibleSecretKindValues returns an array of possible values for the SecretKind const type.
func PossibleSecretKindValues() []SecretKind {
	return []SecretKind{InlinedValue}
}

// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// ServiceEndpointRole enumerates the values for service endpoint role.
type ServiceEndpointRole string

const (
	// ServiceEndpointRoleInvalid Indicates the service endpoint role is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceEndpointRoleInvalid ServiceEndpointRole = "Invalid"
	// ServiceEndpointRoleStatefulPrimary Indicates that the service endpoint is of a primary replica of a
	// stateful service. The value is 2.
	ServiceEndpointRoleStatefulPrimary ServiceEndpointRole = "StatefulPrimary"
	// ServiceEndpointRoleStatefulSecondary Indicates that the service endpoint is of a secondary replica of a
	// stateful service. The value is 3.
	ServiceEndpointRoleStatefulSecondary ServiceEndpointRole = "StatefulSecondary"
	// ServiceEndpointRoleStateless Indicates that the service endpoint is of a stateless service. The value is
	// 1.
	ServiceEndpointRoleStateless ServiceEndpointRole = "Stateless"
)

// PossibleServiceEndpointRoleValues returns an array of possible values for the ServiceEndpointRole const type.
func PossibleServiceEndpointRoleValues() []ServiceEndpointRole {
	return []ServiceEndpointRole{ServiceEndpointRoleInvalid, ServiceEndpointRoleStatefulPrimary, ServiceEndpointRoleStatefulSecondary, ServiceEndpointRoleStateless}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicDeployedServiceReplicaDetailInfo enumerates the values for service kind basic deployed
// service replica detail info.
type ServiceKindBasicDeployedServiceReplicaDetailInfo string

const (
	// ServiceKindDeployedServiceReplicaDetailInfo ...
	ServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = "DeployedServiceReplicaDetailInfo"
	// ServiceKindStateful1 ...
	ServiceKindStateful1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateful"
	// ServiceKindStateless1 ...
	ServiceKindStateless1 ServiceKindBasicDeployedServiceReplicaDetailInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaDetailInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaDetailInfoValues() []ServiceKindBasicDeployedServiceReplicaDetailInfo {
	return []ServiceKindBasicDeployedServiceReplicaDetailInfo{ServiceKindDeployedServiceReplicaDetailInfo, ServiceKindStateful1, ServiceKindStateless1}
}

// ServiceKindBasicDeployedServiceReplicaInfo enumerates the values for service kind basic deployed service
// replica info.
type ServiceKindBasicDeployedServiceReplicaInfo string

const (
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ServiceKindBasicDeployedServiceReplicaInfo = "DeployedServiceReplicaInfo"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful ServiceKindBasicDeployedServiceReplicaInfo = "Stateful"
	// ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ...
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless ServiceKindBasicDeployedServiceReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicDeployedServiceReplicaInfoValues returns an array of possible values for the ServiceKindBasicDeployedServiceReplicaInfo const type.
func PossibleServiceKindBasicDeployedServiceReplicaInfoValues() []ServiceKindBasicDeployedServiceReplicaInfo {
	return []ServiceKindBasicDeployedServiceReplicaInfo{ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful, ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless}
}

// ServiceKindBasicReplicaHealth enumerates the values for service kind basic replica health.
type ServiceKindBasicReplicaHealth string

const (
	// ServiceKindBasicReplicaHealthServiceKindReplicaHealth ...
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = "ReplicaHealth"
	// ServiceKindBasicReplicaHealthServiceKindStateful ...
	ServiceKindBasicReplicaHealthServiceKindStateful ServiceKindBasicReplicaHealth = "Stateful"
	// ServiceKindBasicReplicaHealthServiceKindStateless ...
	ServiceKindBasicReplicaHealthServiceKindStateless ServiceKindBasicReplicaHealth = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthValues returns an array of possible values for the ServiceKindBasicReplicaHealth const type.
func PossibleServiceKindBasicReplicaHealthValues() []ServiceKindBasicReplicaHealth {
	return []ServiceKindBasicReplicaHealth{ServiceKindBasicReplicaHealthServiceKindReplicaHealth, ServiceKindBasicReplicaHealthServiceKindStateful, ServiceKindBasicReplicaHealthServiceKindStateless}
}

// ServiceKindBasicReplicaHealthState enumerates the values for service kind basic replica health state.
type ServiceKindBasicReplicaHealthState string

const (
	// ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ...
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = "ReplicaHealthState"
	// ServiceKindBasicReplicaHealthStateServiceKindStateful ...
	ServiceKindBasicReplicaHealthStateServiceKindStateful ServiceKindBasicReplicaHealthState = "Stateful"
	// ServiceKindBasicReplicaHealthStateServiceKindStateless ...
	ServiceKindBasicReplicaHealthStateServiceKindStateless ServiceKindBasicReplicaHealthState = "Stateless"
)

// PossibleServiceKindBasicReplicaHealthStateValues returns an array of possible values for the ServiceKindBasicReplicaHealthState const type.
func PossibleServiceKindBasicReplicaHealthStateValues() []ServiceKindBasicReplicaHealthState {
	return []ServiceKindBasicReplicaHealthState{ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState, ServiceKindBasicReplicaHealthStateServiceKindStateful, ServiceKindBasicReplicaHealthStateServiceKindStateless}
}

// ServiceKindBasicReplicaInfo enumerates the values for service kind basic replica info.
type ServiceKindBasicReplicaInfo string

const (
	// ServiceKindBasicReplicaInfoServiceKindReplicaInfo ...
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = "ReplicaInfo"
	// ServiceKindBasicReplicaInfoServiceKindStateful ...
	ServiceKindBasicReplicaInfoServiceKindStateful ServiceKindBasicReplicaInfo = "Stateful"
	// ServiceKindBasicReplicaInfoServiceKindStateless ...
	ServiceKindBasicReplicaInfoServiceKindStateless ServiceKindBasicReplicaInfo = "Stateless"
)

// PossibleServiceKindBasicReplicaInfoValues returns an array of possible values for the ServiceKindBasicReplicaInfo const type.
func PossibleServiceKindBasicReplicaInfoValues() []ServiceKindBasicReplicaInfo {
	return []ServiceKindBasicReplicaInfo{ServiceKindBasicReplicaInfoServiceKindReplicaInfo, ServiceKindBasicReplicaInfoServiceKindStateful, ServiceKindBasicReplicaInfoServiceKindStateless}
}

// ServiceKindBasicServiceDescription enumerates the values for service kind basic service description.
type ServiceKindBasicServiceDescription string

const (
	// ServiceKindBasicServiceDescriptionServiceKindServiceDescription ...
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = "ServiceDescription"
	// ServiceKindBasicServiceDescriptionServiceKindStateful ...
	ServiceKindBasicServiceDescriptionServiceKindStateful ServiceKindBasicServiceDescription = "Stateful"
	// ServiceKindBasicServiceDescriptionServiceKindStateless ...
	ServiceKindBasicServiceDescriptionServiceKindStateless ServiceKindBasicServiceDescription = "Stateless"
)

// PossibleServiceKindBasicServiceDescriptionValues returns an array of possible values for the ServiceKindBasicServiceDescription const type.
func PossibleServiceKindBasicServiceDescriptionValues() []ServiceKindBasicServiceDescription {
	return []ServiceKindBasicServiceDescription{ServiceKindBasicServiceDescriptionServiceKindServiceDescription, ServiceKindBasicServiceDescriptionServiceKindStateful, ServiceKindBasicServiceDescriptionServiceKindStateless}
}

// ServiceKindBasicServiceInfo enumerates the values for service kind basic service info.
type ServiceKindBasicServiceInfo string

const (
	// ServiceKindBasicServiceInfoServiceKindServiceInfo ...
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = "ServiceInfo"
	// ServiceKindBasicServiceInfoServiceKindStateful ...
	ServiceKindBasicServiceInfoServiceKindStateful ServiceKindBasicServiceInfo = "Stateful"
	// ServiceKindBasicServiceInfoServiceKindStateless ...
	ServiceKindBasicServiceInfoServiceKindStateless ServiceKindBasicServiceInfo = "Stateless"
)

// PossibleServiceKindBasicServiceInfoValues returns an array of possible values for the ServiceKindBasicServiceInfo const type.
func PossibleServiceKindBasicServiceInfoValues() []ServiceKindBasicServiceInfo {
	return []ServiceKindBasicServiceInfo{ServiceKindBasicServiceInfoServiceKindServiceInfo, ServiceKindBasicServiceInfoServiceKindStateful, ServiceKindBasicServiceInfoServiceKindStateless}
}

// ServiceKindBasicServicePartitionInfo enumerates the values for service kind basic service partition info.
type ServiceKindBasicServicePartitionInfo string

const (
	// ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ...
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = "ServicePartitionInfo"
	// ServiceKindBasicServicePartitionInfoServiceKindStateful ...
	ServiceKindBasicServicePartitionInfoServiceKindStateful ServiceKindBasicServicePartitionInfo = "Stateful"
	// ServiceKindBasicServicePartitionInfoServiceKindStateless ...
	ServiceKindBasicServicePartitionInfoServiceKindStateless ServiceKindBasicServicePartitionInfo = "Stateless"
)

// PossibleServiceKindBasicServicePartitionInfoValues returns an array of possible values for the ServiceKindBasicServicePartitionInfo const type.
func PossibleServiceKindBasicServicePartitionInfoValues() []ServiceKindBasicServicePartitionInfo {
	return []ServiceKindBasicServicePartitionInfo{ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo, ServiceKindBasicServicePartitionInfoServiceKindStateful, ServiceKindBasicServicePartitionInfoServiceKindStateless}
}

// ServiceKindBasicServiceUpdateDescription enumerates the values for service kind basic service update
// description.
type ServiceKindBasicServiceUpdateDescription string

const (
	// ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = "ServiceUpdateDescription"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful ServiceKindBasicServiceUpdateDescription = "Stateful"
	// ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ...
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless ServiceKindBasicServiceUpdateDescription = "Stateless"
)

// PossibleServiceKindBasicServiceUpdateDescriptionValues returns an array of possible values for the ServiceKindBasicServiceUpdateDescription const type.
func PossibleServiceKindBasicServiceUpdateDescriptionValues() []ServiceKindBasicServiceUpdateDescription {
	return []ServiceKindBasicServiceUpdateDescription{ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription, ServiceKindBasicServiceUpdateDescriptionServiceKindStateful, ServiceKindBasicServiceUpdateDescriptionServiceKindStateless}
}

// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// ServiceOperationName enumerates the values for service operation name.
type ServiceOperationName string

const (
	// ServiceOperationNameAbort The service replica or instance is being aborted.
	ServiceOperationNameAbort ServiceOperationName = "Abort"
	// ServiceOperationNameChangeRole The service replica is changing roles.
	ServiceOperationNameChangeRole ServiceOperationName = "ChangeRole"
	// ServiceOperationNameClose The service replica or instance is being closed.
	ServiceOperationNameClose ServiceOperationName = "Close"
	// ServiceOperationNameNone The service replica or instance is not going through any life-cycle changes.
	ServiceOperationNameNone ServiceOperationName = "None"
	// ServiceOperationNameOpen The service replica or instance is being opened.
	ServiceOperationNameOpen ServiceOperationName = "Open"
	// ServiceOperationNameUnknown Reserved for future use.
	ServiceOperationNameUnknown ServiceOperationName = "Unknown"
)

// PossibleServiceOperationNameValues returns an array of possible values for the ServiceOperationName const type.
func PossibleServiceOperationNameValues() []ServiceOperationName {
	return []ServiceOperationName{ServiceOperationNameAbort, ServiceOperationNameChangeRole, ServiceOperationNameClose, ServiceOperationNameNone, ServiceOperationNameOpen, ServiceOperationNameUnknown}
}

// ServicePackageActivationMode enumerates the values for service package activation mode.
type ServicePackageActivationMode string

const (
	// ExclusiveProcess With this activation mode, each replica or instance of service, on a given node, will
	// have its own dedicated activation of service package on a node. The value is 1.
	ExclusiveProcess ServicePackageActivationMode = "ExclusiveProcess"
	// SharedProcess This is the default activation mode. With this activation mode, replicas or instances from
	// different partition(s) of service, on a given node, will share same activation of service package on a
	// node. The value is zero.
	SharedProcess ServicePackageActivationMode = "SharedProcess"
)

// PossibleServicePackageActivationModeValues returns an array of possible values for the ServicePackageActivationMode const type.
func PossibleServicePackageActivationModeValues() []ServicePackageActivationMode {
	return []ServicePackageActivationMode{ExclusiveProcess, SharedProcess}
}

// ServicePartitionKind enumerates the values for service partition kind.
type ServicePartitionKind string

const (
	// ServicePartitionKindInt64Range Indicates that the partition is based on Int64 key ranges, and
	// UniformInt64RangePartitionSchemeDescription was specified while creating the service. The value is 2.
	ServicePartitionKindInt64Range ServicePartitionKind = "Int64Range"
	// ServicePartitionKindInvalid Indicates the partition kind is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionKindInvalid ServicePartitionKind = "Invalid"
	// ServicePartitionKindNamed Indicates that the partition is based on string names, and
	// NamedPartitionInformation  was specified while creating the service. The value is 3.
	ServicePartitionKindNamed ServicePartitionKind = "Named"
	// ServicePartitionKindSingleton Indicates that there is only one partition, and
	// SingletonPartitionSchemeDescription was specified while creating the service. The value is 1.
	ServicePartitionKindSingleton ServicePartitionKind = "Singleton"
)

// PossibleServicePartitionKindValues returns an array of possible values for the ServicePartitionKind const type.
func PossibleServicePartitionKindValues() []ServicePartitionKind {
	return []ServicePartitionKind{ServicePartitionKindInt64Range, ServicePartitionKindInvalid, ServicePartitionKindNamed, ServicePartitionKindSingleton}
}

// ServicePartitionKindBasicPartitionInformation enumerates the values for service partition kind basic
// partition information.
type ServicePartitionKindBasicPartitionInformation string

const (
	// ServicePartitionKindInt64Range1 ...
	ServicePartitionKindInt64Range1 ServicePartitionKindBasicPartitionInformation = "Int64Range"
	// ServicePartitionKindNamed1 ...
	ServicePartitionKindNamed1 ServicePartitionKindBasicPartitionInformation = "Named"
	// ServicePartitionKindPartitionInformation ...
	ServicePartitionKindPartitionInformation ServicePartitionKindBasicPartitionInformation = "PartitionInformation"
	// ServicePartitionKindSingleton1 ...
	ServicePartitionKindSingleton1 ServicePartitionKindBasicPartitionInformation = "Singleton"
)

// PossibleServicePartitionKindBasicPartitionInformationValues returns an array of possible values for the ServicePartitionKindBasicPartitionInformation const type.
func PossibleServicePartitionKindBasicPartitionInformationValues() []ServicePartitionKindBasicPartitionInformation {
	return []ServicePartitionKindBasicPartitionInformation{ServicePartitionKindInt64Range1, ServicePartitionKindNamed1, ServicePartitionKindPartitionInformation, ServicePartitionKindSingleton1}
}

// ServicePartitionStatus enumerates the values for service partition status.
type ServicePartitionStatus string

const (
	// ServicePartitionStatusDeleting Indicates that the partition is being deleted. The value is 5.
	ServicePartitionStatusDeleting ServicePartitionStatus = "Deleting"
	// ServicePartitionStatusInQuorumLoss Indicates that the partition is in quorum loss. This means that
	// number of replicas that are up and participating in a replica set is less than MinReplicaSetSize for
	// this partition. The value is 3.
	ServicePartitionStatusInQuorumLoss ServicePartitionStatus = "InQuorumLoss"
	// ServicePartitionStatusInvalid Indicates the partition status is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	ServicePartitionStatusInvalid ServicePartitionStatus = "Invalid"
	// ServicePartitionStatusNotReady Indicates that the partition is not ready. This status is returned when
	// none of the other states apply. The value is 2.
	ServicePartitionStatusNotReady ServicePartitionStatus = "NotReady"
	// ServicePartitionStatusReady Indicates that the partition is ready. This means that for a stateless
	// service partition there is at least one instance that is up and for a stateful service partition the
	// number of ready replicas is greater than or equal to the MinReplicaSetSize. The value is 1.
	ServicePartitionStatusReady ServicePartitionStatus = "Ready"
	// ServicePartitionStatusReconfiguring Indicates that the partition is undergoing reconfiguration of its
	// replica sets. This can happen due to failover, upgrade, load balancing or addition or removal of
	// replicas from the replica set. The value is 4.
	ServicePartitionStatusReconfiguring ServicePartitionStatus = "Reconfiguring"
)

// PossibleServicePartitionStatusValues returns an array of possible values for the ServicePartitionStatus const type.
func PossibleServicePartitionStatusValues() []ServicePartitionStatus {
	return []ServicePartitionStatus{ServicePartitionStatusDeleting, ServicePartitionStatusInQuorumLoss, ServicePartitionStatusInvalid, ServicePartitionStatusNotReady, ServicePartitionStatusReady, ServicePartitionStatusReconfiguring}
}

// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferredPrimaryDomain Indicates that the ServicePlacementPolicyDescription is
	// of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
	// Primary replica for the partitions of the service should be located in a particular domain as an
	// optimization. The value is 3.
	ServicePlacementPolicyTypePreferredPrimaryDomain ServicePlacementPolicyType = "PreferredPrimaryDomain"
	// ServicePlacementPolicyTypeRequiredDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequiredDomain ServicePlacementPolicyType = "RequiredDomain"
	// ServicePlacementPolicyTypeRequiredDomainDistribution Indicates that the
	// ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription,
	// indicating that the system will disallow placement of any two replicas from the same partition in the
	// same domain at any time. The value is 4.
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = "RequiredDomainDistribution"
)

// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferredPrimaryDomain, ServicePlacementPolicyTypeRequiredDomain, ServicePlacementPolicyTypeRequiredDomainDistribution}
}

// ServiceStatus enumerates the values for service status.
type ServiceStatus string

const (
	// ServiceStatusActive Indicates the service status is active. The value is 1.
	ServiceStatusActive ServiceStatus = "Active"
	// ServiceStatusCreating Indicates the service is being created. The value is 4.
	ServiceStatusCreating ServiceStatus = "Creating"
	// ServiceStatusDeleting Indicates the service is being deleted. The value is 3.
	ServiceStatusDeleting ServiceStatus = "Deleting"
	// ServiceStatusFailed Indicates creation or deletion was terminated due to persistent failures. Another
	// create/delete request can be accepted. The value is 5.
	ServiceStatusFailed ServiceStatus = "Failed"
	// ServiceStatusUnknown Indicates the service status is unknown. The value is zero.
	ServiceStatusUnknown ServiceStatus = "Unknown"
	// ServiceStatusUpgrading Indicates the service is upgrading. The value is 2.
	ServiceStatusUpgrading ServiceStatus = "Upgrading"
)

// PossibleServiceStatusValues returns an array of possible values for the ServiceStatus const type.
func PossibleServiceStatusValues() []ServiceStatus {
	return []ServiceStatus{ServiceStatusActive, ServiceStatusCreating, ServiceStatusDeleting, ServiceStatusFailed, ServiceStatusUnknown, ServiceStatusUpgrading}
}

// ServiceTypeRegistrationStatus enumerates the values for service type registration status.
type ServiceTypeRegistrationStatus string

const (
	// ServiceTypeRegistrationStatusDisabled Indicates that the service type is disabled on this node. A type
	// gets disabled when there are too many failures of the code package hosting the service type. If the
	// service type is disabled, new replicas of that service type will not be placed on the node until it is
	// enabled again. The service type is enabled again after the process hosting it comes up and re-registers
	// the type or a preconfigured time interval has passed. The value is 1.
	ServiceTypeRegistrationStatusDisabled ServiceTypeRegistrationStatus = "Disabled"
	// ServiceTypeRegistrationStatusEnabled Indicates that the service type is enabled on this node. Replicas
	// of this service type can be placed on this node when the code package registers the service type. The
	// value is 2.
	ServiceTypeRegistrationStatusEnabled ServiceTypeRegistrationStatus = "Enabled"
	// ServiceTypeRegistrationStatusInvalid Indicates the registration status is invalid. All Service Fabric
	// enumerations have the invalid type. The value is zero.
	ServiceTypeRegistrationStatusInvalid ServiceTypeRegistrationStatus = "Invalid"
	// ServiceTypeRegistrationStatusRegistered Indicates that the service type is enabled and registered on the
	// node by a code package. Replicas of this service type can now be placed on this node. The value is 3.
	ServiceTypeRegistrationStatusRegistered ServiceTypeRegistrationStatus = "Registered"
)

// PossibleServiceTypeRegistrationStatusValues returns an array of possible values for the ServiceTypeRegistrationStatus const type.
func PossibleServiceTypeRegistrationStatusValues() []ServiceTypeRegistrationStatus {
	return []ServiceTypeRegistrationStatus{ServiceTypeRegistrationStatusDisabled, ServiceTypeRegistrationStatusEnabled, ServiceTypeRegistrationStatusInvalid, ServiceTypeRegistrationStatusRegistered}
}

// SizeTypes enumerates the values for size types.
type SizeTypes string

const (
	// SizeTypesLarge ...
	SizeTypesLarge SizeTypes = "Large"
	// SizeTypesMedium ...
	SizeTypesMedium SizeTypes = "Medium"
	// SizeTypesSmall ...
	SizeTypesSmall SizeTypes = "Small"
)

// PossibleSizeTypesValues returns an array of possible values for the SizeTypes const type.
func PossibleSizeTypesValues() []SizeTypes {
	return []SizeTypes{SizeTypesLarge, SizeTypesMedium, SizeTypesSmall}
}

// State enumerates the values for state.
type State string

const (
	// StateApproved Indicates that the repair task has been approved by the Repair Manager and is safe to
	// execute.
	StateApproved State = "Approved"
	// StateClaimed Indicates that the repair task has been claimed by a repair executor.
	StateClaimed State = "Claimed"
	// StateCompleted Indicates that the repair task has completed, and no further state changes will occur.
	StateCompleted State = "Completed"
	// StateCreated Indicates that the repair task has been created.
	StateCreated State = "Created"
	// StateExecuting Indicates that execution of the repair task is in progress.
	StateExecuting State = "Executing"
	// StateInvalid Indicates that the repair task state is invalid. All Service Fabric enumerations have the
	// invalid value.
	StateInvalid State = "Invalid"
	// StatePreparing Indicates that the Repair Manager is preparing the system to handle the impact of the
	// repair task, usually by taking resources offline gracefully.
	StatePreparing State = "Preparing"
	// StateRestoring Indicates that the Repair Manager is restoring the system to its pre-repair state,
	// usually by bringing resources back online.
	StateRestoring State = "Restoring"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateApproved, StateClaimed, StateCompleted, StateCreated, StateExecuting, StateInvalid, StatePreparing, StateRestoring}
}

// StorageKind enumerates the values for storage kind.
type StorageKind string

const (
	// StorageKindAzureBlobStore ...
	StorageKindAzureBlobStore StorageKind = "AzureBlobStore"
	// StorageKindBackupStorageDescription ...
	StorageKindBackupStorageDescription StorageKind = "BackupStorageDescription"
	// StorageKindFileShare ...
	StorageKindFileShare StorageKind = "FileShare"
)

// PossibleStorageKindValues returns an array of possible values for the StorageKind const type.
func PossibleStorageKindValues() []StorageKind {
	return []StorageKind{StorageKindAzureBlobStore, StorageKindBackupStorageDescription, StorageKindFileShare}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeInvalidDomain ...
	TypeInvalidDomain Type = "InvalidDomain"
	// TypeNonPartiallyPlaceService ...
	TypeNonPartiallyPlaceService Type = "NonPartiallyPlaceService"
	// TypePreferredPrimaryDomain ...
	TypePreferredPrimaryDomain Type = "PreferredPrimaryDomain"
	// TypeRequiredDomain ...
	TypeRequiredDomain Type = "RequiredDomain"
	// TypeRequiredDomainDistribution ...
	TypeRequiredDomainDistribution Type = "RequiredDomainDistribution"
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeInvalidDomain, TypeNonPartiallyPlaceService, TypePreferredPrimaryDomain, TypeRequiredDomain, TypeRequiredDomainDistribution, TypeServicePlacementPolicyDescription}
}

// UpgradeDomainState enumerates the values for upgrade domain state.
type UpgradeDomainState string

const (
	// UpgradeDomainStateCompleted The upgrade domain has completed upgrade. The value is 3
	UpgradeDomainStateCompleted UpgradeDomainState = "Completed"
	// UpgradeDomainStateInProgress The upgrade domain is being upgraded but not complete yet. The value is 2
	UpgradeDomainStateInProgress UpgradeDomainState = "InProgress"
	// UpgradeDomainStateInvalid Indicates the upgrade domain state is invalid. All Service Fabric enumerations
	// have the invalid type. The value is zero.
	UpgradeDomainStateInvalid UpgradeDomainState = "Invalid"
	// UpgradeDomainStatePending The upgrade domain has not started upgrading yet. The value is 1
	UpgradeDomainStatePending UpgradeDomainState = "Pending"
)

// PossibleUpgradeDomainStateValues returns an array of possible values for the UpgradeDomainState const type.
func PossibleUpgradeDomainStateValues() []UpgradeDomainState {
	return []UpgradeDomainState{UpgradeDomainStateCompleted, UpgradeDomainStateInProgress, UpgradeDomainStateInvalid, UpgradeDomainStatePending}
}

// UpgradeKind enumerates the values for upgrade kind.
type UpgradeKind string

const (
	// UpgradeKindInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeKindInvalid UpgradeKind = "Invalid"
	// UpgradeKindRolling The upgrade progresses one upgrade domain at a time. The value is 1
	UpgradeKindRolling UpgradeKind = "Rolling"
)

// PossibleUpgradeKindValues returns an array of possible values for the UpgradeKind const type.
func PossibleUpgradeKindValues() []UpgradeKind {
	return []UpgradeKind{UpgradeKindInvalid, UpgradeKindRolling}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeInvalid Indicates the upgrade mode is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeModeInvalid UpgradeMode = "Invalid"
	// UpgradeModeMonitored The upgrade will stop after completing each upgrade domain and automatically
	// monitor health before proceeding. The value is 3
	UpgradeModeMonitored UpgradeMode = "Monitored"
	// UpgradeModeUnmonitoredAuto The upgrade will proceed automatically without performing any health
	// monitoring. The value is 1
	UpgradeModeUnmonitoredAuto UpgradeMode = "UnmonitoredAuto"
	// UpgradeModeUnmonitoredManual The upgrade will stop after completing each upgrade domain, giving the
	// opportunity to manually monitor health before proceeding. The value is 2
	UpgradeModeUnmonitoredManual UpgradeMode = "UnmonitoredManual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeInvalid, UpgradeModeMonitored, UpgradeModeUnmonitoredAuto, UpgradeModeUnmonitoredManual}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateFailed The upgrade has failed and is unable to execute FailureAction. The value is 6
	UpgradeStateFailed UpgradeState = "Failed"
	// UpgradeStateInvalid Indicates the upgrade state is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeStateInvalid UpgradeState = "Invalid"
	// UpgradeStateRollingBackCompleted The upgrade has finished rolling back. The value is 2
	UpgradeStateRollingBackCompleted UpgradeState = "RollingBackCompleted"
	// UpgradeStateRollingBackInProgress The upgrade is rolling back to the previous version but is not
	// complete yet. The value is 1
	UpgradeStateRollingBackInProgress UpgradeState = "RollingBackInProgress"
	// UpgradeStateRollingForwardCompleted The upgrade has finished rolling forward. The value is 5
	UpgradeStateRollingForwardCompleted UpgradeState = "RollingForwardCompleted"
	// UpgradeStateRollingForwardInProgress The upgrade is rolling forward to the target version but is not
	// complete yet. The value is 4
	UpgradeStateRollingForwardInProgress UpgradeState = "RollingForwardInProgress"
	// UpgradeStateRollingForwardPending The current upgrade domain has finished upgrading. The overall upgrade
	// is waiting for an explicit move next request in UnmonitoredManual mode or performing health checks in
	// Monitored mode. The value is 3
	UpgradeStateRollingForwardPending UpgradeState = "RollingForwardPending"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateFailed, UpgradeStateInvalid, UpgradeStateRollingBackCompleted, UpgradeStateRollingBackInProgress, UpgradeStateRollingForwardCompleted, UpgradeStateRollingForwardInProgress, UpgradeStateRollingForwardPending}
}

// UpgradeType enumerates the values for upgrade type.
type UpgradeType string

const (
	// UpgradeTypeInvalid Indicates the upgrade kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	UpgradeTypeInvalid UpgradeType = "Invalid"
	// UpgradeTypeRolling The upgrade progresses one upgrade domain at a time. The value is 1.
	UpgradeTypeRolling UpgradeType = "Rolling"
	// UpgradeTypeRollingForceRestart The upgrade gets restarted by force. The value is 2.
	UpgradeTypeRollingForceRestart UpgradeType = "Rolling_ForceRestart"
)

// PossibleUpgradeTypeValues returns an array of possible values for the UpgradeType const type.
func PossibleUpgradeTypeValues() []UpgradeType {
	return []UpgradeType{UpgradeTypeInvalid, UpgradeTypeRolling, UpgradeTypeRollingForceRestart}
}

// VolumeProvider enumerates the values for volume provider.
type VolumeProvider string

const (
	// SFAzureFile Provides volumes that are backed by Azure Files.
	SFAzureFile VolumeProvider = "SFAzureFile"
)

// PossibleVolumeProviderValues returns an array of possible values for the VolumeProvider const type.
func PossibleVolumeProviderValues() []VolumeProvider {
	return []VolumeProvider{SFAzureFile}
}

// AadMetadata azure Active Directory metadata used for secured connection to cluster.
type AadMetadata struct {
	// Authority - The AAD authority url.
	Authority *string `json:"authority,omitempty"`
	// Client - The AAD client application Id.
	Client *string `json:"client,omitempty"`
	// Cluster - The AAD cluster application Id.
	Cluster *string `json:"cluster,omitempty"`
	// Login - The AAD login url.
	Login *string `json:"login,omitempty"`
	// Redirect - The client application redirect address.
	Redirect *string `json:"redirect,omitempty"`
	// Tenant - The AAD tenant Id.
	Tenant *string `json:"tenant,omitempty"`
}

// AadMetadataObject azure Active Directory metadata object used for secured connection to cluster.
type AadMetadataObject struct {
	autorest.Response `json:"-"`
	// Type - The client authentication method.
	Type *string `json:"type,omitempty"`
	// Metadata - Azure Active Directory metadata used for secured connection to cluster.
	Metadata *AadMetadata `json:"metadata,omitempty"`
}

// AddRemoveIncrementalNamedPartitionScalingMechanism represents a scaling mechanism for adding or removing
// named partitions of a stateless service. Partition names are in the format '0','1''N-1'
type AddRemoveIncrementalNamedPartitionScalingMechanism struct {
	// MinPartitionCount - Minimum number of named partitions of the service.
	MinPartitionCount *int32 `json:"MinPartitionCount,omitempty"`
	// MaxPartitionCount - Maximum number of named partitions of the service.
	MaxPartitionCount *int32 `json:"MaxPartitionCount,omitempty"`
	// ScaleIncrement - The number of instances to add or remove during a scaling operation.
	ScaleIncrement *int32 `json:"ScaleIncrement,omitempty"`
	// Kind - Possible values include: 'KindScalingMechanismDescription', 'KindPartitionInstanceCount', 'KindAddRemoveIncrementalNamedPartition'
	Kind KindBasicScalingMechanismDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) MarshalJSON() ([]byte, error) {
	arinpsm.Kind = KindAddRemoveIncrementalNamedPartition
	objectMap := make(map[string]interface{})
	if arinpsm.MinPartitionCount != nil {
		objectMap["MinPartitionCount"] = arinpsm.MinPartitionCount
	}
	if arinpsm.MaxPartitionCount != nil {
		objectMap["MaxPartitionCount"] = arinpsm.MaxPartitionCount
	}
	if arinpsm.ScaleIncrement != nil {
		objectMap["ScaleIncrement"] = arinpsm.ScaleIncrement
	}
	if arinpsm.Kind != "" {
		objectMap["Kind"] = arinpsm.Kind
	}
	return json.Marshal(objectMap)
}

// AsPartitionInstanceCountScaleMechanism is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsPartitionInstanceCountScaleMechanism() (*PartitionInstanceCountScaleMechanism, bool) {
	return nil, false
}

// AsAddRemoveIncrementalNamedPartitionScalingMechanism is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsAddRemoveIncrementalNamedPartitionScalingMechanism() (*AddRemoveIncrementalNamedPartitionScalingMechanism, bool) {
	return &arinpsm, true
}

// AsScalingMechanismDescription is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsScalingMechanismDescription() (*ScalingMechanismDescription, bool) {
	return nil, false
}

// AsBasicScalingMechanismDescription is the BasicScalingMechanismDescription implementation for AddRemoveIncrementalNamedPartitionScalingMechanism.
func (arinpsm AddRemoveIncrementalNamedPartitionScalingMechanism) AsBasicScalingMechanismDescription() (BasicScalingMechanismDescription, bool) {
	return &arinpsm, true
}

// AddRemoveReplicaScalingMechanism describes the horizontal auto scaling mechanism that adds or removes
// replicas (containers or container groups).
type AddRemoveReplicaScalingMechanism struct {
	// MinCount - Minimum number of containers (scale down won't be performed below this number).
	MinCount *int32 `json:"minCount,omitempty"`
	// MaxCount - Maximum number of containers (scale up won't be performed above this number).
	MaxCount *int32 `json:"maxCount,omitempty"`
	// ScaleIncrement - Each time auto scaling is performed, this number of containers will be added or removed.
	ScaleIncrement *int32 `json:"scaleIncrement,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingMechanism', 'KindAddRemoveReplica'
	Kind KindBasicAutoScalingMechanism `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) MarshalJSON() ([]byte, error) {
	arrsm.Kind = KindAddRemoveReplica
	objectMap := make(map[string]interface{})
	if arrsm.MinCount != nil {
		objectMap["minCount"] = arrsm.MinCount
	}
	if arrsm.MaxCount != nil {
		objectMap["maxCount"] = arrsm.MaxCount
	}
	if arrsm.ScaleIncrement != nil {
		objectMap["scaleIncrement"] = arrsm.ScaleIncrement
	}
	if arrsm.Kind != "" {
		objectMap["kind"] = arrsm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAddRemoveReplicaScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool) {
	return &arrsm, true
}

// AsAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsAutoScalingMechanism() (*AutoScalingMechanism, bool) {
	return nil, false
}

// AsBasicAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AddRemoveReplicaScalingMechanism.
func (arrsm AddRemoveReplicaScalingMechanism) AsBasicAutoScalingMechanism() (BasicAutoScalingMechanism, bool) {
	return &arrsm, true
}

// AnalysisEventMetadata metadata about an Analysis Event.
type AnalysisEventMetadata struct {
	// Delay - The analysis delay.
	Delay *string `json:"Delay,omitempty"`
	// Duration - The duration of analysis.
	Duration *string `json:"Duration,omitempty"`
}

// ApplicationBackupConfigurationInfo backup configuration information for a specific Service Fabric
// application specifying what backup policy is being applied and suspend description, if any.
type ApplicationBackupConfigurationInfo struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// PolicyName - The name of the backup policy which is applicable to this Service Fabric application or service or partition.
	PolicyName *string `json:"PolicyName,omitempty"`
	// PolicyInheritedFrom - Specifies the scope at which the backup policy is applied. Possible values include: 'BackupPolicyScopeInvalid', 'BackupPolicyScopePartition', 'BackupPolicyScopeService', 'BackupPolicyScopeApplication'
	PolicyInheritedFrom BackupPolicyScope `json:"PolicyInheritedFrom,omitempty"`
	// SuspensionInfo - Describes the backup suspension details.
	SuspensionInfo *BackupSuspensionInfo `json:"SuspensionInfo,omitempty"`
	// Kind - Possible values include: 'KindBasicBackupConfigurationInfoKindBackupConfigurationInfo', 'KindBasicBackupConfigurationInfoKindApplication', 'KindBasicBackupConfigurationInfoKindService', 'KindBasicBackupConfigurationInfoKindPartition'
	Kind KindBasicBackupConfigurationInfo `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) MarshalJSON() ([]byte, error) {
	abci.Kind = KindBasicBackupConfigurationInfoKindApplication
	objectMap := make(map[string]interface{})
	if abci.ApplicationName != nil {
		objectMap["ApplicationName"] = abci.ApplicationName
	}
	if abci.PolicyName != nil {
		objectMap["PolicyName"] = abci.PolicyName
	}
	if abci.PolicyInheritedFrom != "" {
		objectMap["PolicyInheritedFrom"] = abci.PolicyInheritedFrom
	}
	if abci.SuspensionInfo != nil {
		objectMap["SuspensionInfo"] = abci.SuspensionInfo
	}
	if abci.Kind != "" {
		objectMap["Kind"] = abci.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool) {
	return &abci, true
}

// AsServiceBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool) {
	return nil, false
}

// AsPartitionBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool) {
	return nil, false
}

// AsBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool) {
	return nil, false
}

// AsBasicBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for ApplicationBackupConfigurationInfo.
func (abci ApplicationBackupConfigurationInfo) AsBasicBackupConfigurationInfo() (BasicBackupConfigurationInfo, bool) {
	return &abci, true
}

// ApplicationBackupEntity identifies the Service Fabric application which is being backed up.
type ApplicationBackupEntity struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// EntityKind - Possible values include: 'EntityKindBackupEntity', 'EntityKindApplication1', 'EntityKindService1', 'EntityKindPartition1'
	EntityKind EntityKindBasicBackupEntity `json:"EntityKind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) MarshalJSON() ([]byte, error) {
	abe.EntityKind = EntityKindApplication1
	objectMap := make(map[string]interface{})
	if abe.ApplicationName != nil {
		objectMap["ApplicationName"] = abe.ApplicationName
	}
	if abe.EntityKind != "" {
		objectMap["EntityKind"] = abe.EntityKind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsApplicationBackupEntity() (*ApplicationBackupEntity, bool) {
	return &abe, true
}

// AsServiceBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsServiceBackupEntity() (*ServiceBackupEntity, bool) {
	return nil, false
}

// AsPartitionBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsPartitionBackupEntity() (*PartitionBackupEntity, bool) {
	return nil, false
}

// AsBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsBackupEntity() (*BackupEntity, bool) {
	return nil, false
}

// AsBasicBackupEntity is the BasicBackupEntity implementation for ApplicationBackupEntity.
func (abe ApplicationBackupEntity) AsBasicBackupEntity() (BasicBackupEntity, bool) {
	return &abe, true
}

// ApplicationCapacityDescription describes capacity information for services of this application. This
// description can be used for describing the following.
// - Reserving the capacity for the services on the nodes
// - Limiting the total number of nodes that services of this application can run on
// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of
// this application
type ApplicationCapacityDescription struct {
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// ApplicationMetrics - List of application capacity metric description.
	ApplicationMetrics *[]ApplicationMetricDescription `json:"ApplicationMetrics,omitempty"`
}

// ApplicationContainerInstanceExitedEvent container Exited event.
type ApplicationContainerInstanceExitedEvent struct {
	// ServiceName - Name of Service.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServicePackageName - Name of Service package.
	ServicePackageName *string `json:"ServicePackageName,omitempty"`
	// ServicePackageActivationID - Activation Id of Service package.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// IsExclusive - Indicates IsExclusive flag.
	IsExclusive *bool `json:"IsExclusive,omitempty"`
	// CodePackageName - Name of Code package.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// EntryPointType - Type of EntryPoint.
	EntryPointType *string `json:"EntryPointType,omitempty"`
	// ImageName - Name of Container image.
	ImageName *string `json:"ImageName,omitempty"`
	// ContainerName - Name of Container.
	ContainerName *string `json:"ContainerName,omitempty"`
	// HostID - Host Id.
	HostID *string `json:"HostId,omitempty"`
	// ExitCode - Exit code of process.
	ExitCode *int64 `json:"ExitCode,omitempty"`
	// UnexpectedTermination - Indicates if termination is unexpected.
	UnexpectedTermination *bool `json:"UnexpectedTermination,omitempty"`
	// StartTime - Start time of process.
	StartTime *date.Time `json:"StartTime,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) MarshalJSON() ([]byte, error) {
	aciee.Kind = KindApplicationContainerInstanceExited
	objectMap := make(map[string]interface{})
	if aciee.ServiceName != nil {
		objectMap["ServiceName"] = aciee.ServiceName
	}
	if aciee.ServicePackageName != nil {
		objectMap["ServicePackageName"] = aciee.ServicePackageName
	}
	if aciee.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = aciee.ServicePackageActivationID
	}
	if aciee.IsExclusive != nil {
		objectMap["IsExclusive"] = aciee.IsExclusive
	}
	if aciee.CodePackageName != nil {
		objectMap["CodePackageName"] = aciee.CodePackageName
	}
	if aciee.EntryPointType != nil {
		objectMap["EntryPointType"] = aciee.EntryPointType
	}
	if aciee.ImageName != nil {
		objectMap["ImageName"] = aciee.ImageName
	}
	if aciee.ContainerName != nil {
		objectMap["ContainerName"] = aciee.ContainerName
	}
	if aciee.HostID != nil {
		objectMap["HostId"] = aciee.HostID
	}
	if aciee.ExitCode != nil {
		objectMap["ExitCode"] = aciee.ExitCode
	}
	if aciee.UnexpectedTermination != nil {
		objectMap["UnexpectedTermination"] = aciee.UnexpectedTermination
	}
	if aciee.StartTime != nil {
		objectMap["StartTime"] = aciee.StartTime
	}
	if aciee.ApplicationID != nil {
		objectMap["ApplicationId"] = aciee.ApplicationID
	}
	if aciee.EventInstanceID != nil {
		objectMap["EventInstanceId"] = aciee.EventInstanceID
	}
	if aciee.Category != nil {
		objectMap["Category"] = aciee.Category
	}
	if aciee.TimeStamp != nil {
		objectMap["TimeStamp"] = aciee.TimeStamp
	}
	if aciee.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = aciee.HasCorrelatedEvents
	}
	if aciee.Kind != "" {
		objectMap["Kind"] = aciee.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &aciee, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return &aciee, true
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationContainerInstanceExitedEvent.
func (aciee ApplicationContainerInstanceExitedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &aciee, true
}

// ApplicationCreatedEvent application Created event.
type ApplicationCreatedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// ApplicationDefinitionKind - Application definition kind.
	ApplicationDefinitionKind *string `json:"ApplicationDefinitionKind,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) MarshalJSON() ([]byte, error) {
	ace.Kind = KindApplicationCreated
	objectMap := make(map[string]interface{})
	if ace.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ace.ApplicationTypeName
	}
	if ace.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ace.ApplicationTypeVersion
	}
	if ace.ApplicationDefinitionKind != nil {
		objectMap["ApplicationDefinitionKind"] = ace.ApplicationDefinitionKind
	}
	if ace.ApplicationID != nil {
		objectMap["ApplicationId"] = ace.ApplicationID
	}
	if ace.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ace.EventInstanceID
	}
	if ace.Category != nil {
		objectMap["Category"] = ace.Category
	}
	if ace.TimeStamp != nil {
		objectMap["TimeStamp"] = ace.TimeStamp
	}
	if ace.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ace.HasCorrelatedEvents
	}
	if ace.Kind != "" {
		objectMap["Kind"] = ace.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ace, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return &ace, true
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationCreatedEvent.
func (ace ApplicationCreatedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ace, true
}

// ApplicationDeletedEvent application Deleted event.
type ApplicationDeletedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) MarshalJSON() ([]byte, error) {
	ade.Kind = KindApplicationDeleted
	objectMap := make(map[string]interface{})
	if ade.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ade.ApplicationTypeName
	}
	if ade.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ade.ApplicationTypeVersion
	}
	if ade.ApplicationID != nil {
		objectMap["ApplicationId"] = ade.ApplicationID
	}
	if ade.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ade.EventInstanceID
	}
	if ade.Category != nil {
		objectMap["Category"] = ade.Category
	}
	if ade.TimeStamp != nil {
		objectMap["TimeStamp"] = ade.TimeStamp
	}
	if ade.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ade.HasCorrelatedEvents
	}
	if ade.Kind != "" {
		objectMap["Kind"] = ade.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ade, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return &ade, true
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationDeletedEvent.
func (ade ApplicationDeletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ade, true
}

// ApplicationDescription describes a Service Fabric application.
type ApplicationDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// ParameterList - List of application parameters with overridden values from their default values specified in the application manifest.
	ParameterList *[]ApplicationParameter `json:"ParameterList,omitempty"`
	// ApplicationCapacity - Describes capacity information for services of this application. This description can be used for describing the following.
	// - Reserving the capacity for the services on the nodes
	// - Limiting the total number of nodes that services of this application can run on
	// - Limiting the custom capacity metrics to limit the total consumption of this metric by the services of this application
	ApplicationCapacity *ApplicationCapacityDescription `json:"ApplicationCapacity,omitempty"`
}

// BasicApplicationEvent represents the base for all Application Events.
type BasicApplicationEvent interface {
	AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool)
	AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool)
	AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool)
	AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool)
	AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool)
	AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool)
	AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool)
	AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool)
	AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool)
	AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool)
	AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool)
	AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool)
	AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool)
	AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool)
	AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool)
	AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool)
	AsApplicationEvent() (*ApplicationEvent, bool)
}

// ApplicationEvent represents the base for all Application Events.
type ApplicationEvent struct {
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

func unmarshalBasicApplicationEvent(body []byte) (BasicApplicationEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindApplicationCreated):
		var ace ApplicationCreatedEvent
		err := json.Unmarshal(body, &ace)
		return ace, err
	case string(KindApplicationDeleted):
		var ade ApplicationDeletedEvent
		err := json.Unmarshal(body, &ade)
		return ade, err
	case string(KindApplicationNewHealthReport):
		var anhre ApplicationNewHealthReportEvent
		err := json.Unmarshal(body, &anhre)
		return anhre, err
	case string(KindApplicationHealthReportExpired):
		var ahree ApplicationHealthReportExpiredEvent
		err := json.Unmarshal(body, &ahree)
		return ahree, err
	case string(KindApplicationUpgradeCompleted):
		var auce ApplicationUpgradeCompletedEvent
		err := json.Unmarshal(body, &auce)
		return auce, err
	case string(KindApplicationUpgradeDomainCompleted):
		var audce ApplicationUpgradeDomainCompletedEvent
		err := json.Unmarshal(body, &audce)
		return audce, err
	case string(KindApplicationUpgradeRollbackCompleted):
		var aurce ApplicationUpgradeRollbackCompletedEvent
		err := json.Unmarshal(body, &aurce)
		return aurce, err
	case string(KindApplicationUpgradeRollbackStarted):
		var aurse ApplicationUpgradeRollbackStartedEvent
		err := json.Unmarshal(body, &aurse)
		return aurse, err
	case string(KindApplicationUpgradeStarted):
		var ause ApplicationUpgradeStartedEvent
		err := json.Unmarshal(body, &ause)
		return ause, err
	case string(KindDeployedApplicationNewHealthReport):
		var danhre DeployedApplicationNewHealthReportEvent
		err := json.Unmarshal(body, &danhre)
		return danhre, err
	case string(KindDeployedApplicationHealthReportExpired):
		var dahree DeployedApplicationHealthReportExpiredEvent
		err := json.Unmarshal(body, &dahree)
		return dahree, err
	case string(KindApplicationProcessExited):
		var apee ApplicationProcessExitedEvent
		err := json.Unmarshal(body, &apee)
		return apee, err
	case string(KindApplicationContainerInstanceExited):
		var aciee ApplicationContainerInstanceExitedEvent
		err := json.Unmarshal(body, &aciee)
		return aciee, err
	case string(KindDeployedServicePackageNewHealthReport):
		var dspnhre DeployedServicePackageNewHealthReportEvent
		err := json.Unmarshal(body, &dspnhre)
		return dspnhre, err
	case string(KindDeployedServicePackageHealthReportExpired):
		var dsphree DeployedServicePackageHealthReportExpiredEvent
		err := json.Unmarshal(body, &dsphree)
		return dsphree, err
	case string(KindChaosCodePackageRestartScheduled):
		var ccprse ChaosCodePackageRestartScheduledEvent
		err := json.Unmarshal(body, &ccprse)
		return ccprse, err
	default:
		var ae ApplicationEvent
		err := json.Unmarshal(body, &ae)
		return ae, err
	}
}
func unmarshalBasicApplicationEventArray(body []byte) ([]BasicApplicationEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aeArray := make([]BasicApplicationEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ae, err := unmarshalBasicApplicationEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		aeArray[index] = ae
	}
	return aeArray, nil
}

// MarshalJSON is the custom marshaler for ApplicationEvent.
func (ae ApplicationEvent) MarshalJSON() ([]byte, error) {
	ae.Kind = KindApplicationEvent
	objectMap := make(map[string]interface{})
	if ae.ApplicationID != nil {
		objectMap["ApplicationId"] = ae.ApplicationID
	}
	if ae.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ae.EventInstanceID
	}
	if ae.Category != nil {
		objectMap["Category"] = ae.Category
	}
	if ae.TimeStamp != nil {
		objectMap["TimeStamp"] = ae.TimeStamp
	}
	if ae.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ae.HasCorrelatedEvents
	}
	if ae.Kind != "" {
		objectMap["Kind"] = ae.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return &ae, true
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ae, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationEvent.
func (ae ApplicationEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ae, true
}

// ApplicationHealth represents the health of the application. Contains the application aggregated health
// state and the service and deployed application health states.
type ApplicationHealth struct {
	autorest.Response `json:"-"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// ServiceHealthStates - Service health states as found in the health store.
	ServiceHealthStates *[]ServiceHealthState `json:"ServiceHealthStates,omitempty"`
	// DeployedApplicationHealthStates - Deployed application health states as found in the health store.
	DeployedApplicationHealthStates *[]DeployedApplicationHealthState `json:"DeployedApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// ApplicationHealthEvaluation represents health evaluation for an application, containing information
// about the data and the algorithm used by the health store to evaluate health.
type ApplicationHealthEvaluation struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the current aggregated health state of the application. The types of the unhealthy evaluations can be DeployedApplicationsHealthEvaluation, ServicesHealthEvaluation or EventHealthEvaluation.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplication
	objectMap := make(map[string]interface{})
	if ahe.ApplicationName != nil {
		objectMap["ApplicationName"] = ahe.ApplicationName
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return &ahe, true
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationHealthEvaluation.
func (ahe ApplicationHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// ApplicationHealthPolicies defines the application health policy map used to evaluate the health of an
// application or one of its children entities.
type ApplicationHealthPolicies struct {
	// ApplicationHealthPolicyMap - The wrapper that contains the map with application health policies used to evaluate specific applications in the cluster.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// ApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one of
// its children entities.
type ApplicationHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyDeployedApplications - The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
	// This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32 `json:"MaxPercentUnhealthyDeployedApplications,omitempty"`
	// DefaultServiceTypeHealthPolicy - The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ServiceTypeHealthPolicy `json:"DefaultServiceTypeHealthPolicy,omitempty"`
	// ServiceTypeHealthPolicyMap - The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicyMap *[]ServiceTypeHealthPolicyMapItem `json:"ServiceTypeHealthPolicyMap,omitempty"`
}

// ApplicationHealthPolicyMapItem defines an item in ApplicationHealthPolicyMap.
type ApplicationHealthPolicyMapItem struct {
	// Key - The key of the application health policy map item. This is the name of the application.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application health policy map item. This is the ApplicationHealthPolicy for this application.
	Value *ApplicationHealthPolicy `json:"Value,omitempty"`
}

// ApplicationHealthReportExpiredEvent application Health Report Expired event.
type ApplicationHealthReportExpiredEvent struct {
	// ApplicationInstanceID - Id of Application instance.
	ApplicationInstanceID *int64 `json:"ApplicationInstanceId,omitempty"`
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) MarshalJSON() ([]byte, error) {
	ahree.Kind = KindApplicationHealthReportExpired
	objectMap := make(map[string]interface{})
	if ahree.ApplicationInstanceID != nil {
		objectMap["ApplicationInstanceId"] = ahree.ApplicationInstanceID
	}
	if ahree.SourceID != nil {
		objectMap["SourceId"] = ahree.SourceID
	}
	if ahree.Property != nil {
		objectMap["Property"] = ahree.Property
	}
	if ahree.HealthState != nil {
		objectMap["HealthState"] = ahree.HealthState
	}
	if ahree.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = ahree.TimeToLiveMs
	}
	if ahree.SequenceNumber != nil {
		objectMap["SequenceNumber"] = ahree.SequenceNumber
	}
	if ahree.Description != nil {
		objectMap["Description"] = ahree.Description
	}
	if ahree.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = ahree.RemoveWhenExpired
	}
	if ahree.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = ahree.SourceUtcTimestamp
	}
	if ahree.ApplicationID != nil {
		objectMap["ApplicationId"] = ahree.ApplicationID
	}
	if ahree.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ahree.EventInstanceID
	}
	if ahree.Category != nil {
		objectMap["Category"] = ahree.Category
	}
	if ahree.TimeStamp != nil {
		objectMap["TimeStamp"] = ahree.TimeStamp
	}
	if ahree.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ahree.HasCorrelatedEvents
	}
	if ahree.Kind != "" {
		objectMap["Kind"] = ahree.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ahree, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return &ahree, true
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationHealthReportExpiredEvent.
func (ahree ApplicationHealthReportExpiredEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ahree, true
}

// ApplicationHealthState represents the health state of an application, which contains the application
// identifier and the aggregated health state.
type ApplicationHealthState struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
}

// ApplicationHealthStateChunk represents the health state chunk of a application.
// The application health state chunk contains the application name, its aggregated health state and any
// children services and deployed applications that respect the filters in cluster health chunk query
// description.
type ApplicationHealthStateChunk struct {
	// ApplicationName - The name of the application, including the 'fabric:' URI scheme.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ServiceHealthStateChunks - The list of service health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ServiceHealthStateChunks *ServiceHealthStateChunkList `json:"ServiceHealthStateChunks,omitempty"`
	// DeployedApplicationHealthStateChunks - The list of deployed application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	DeployedApplicationHealthStateChunks *DeployedApplicationHealthStateChunkList `json:"DeployedApplicationHealthStateChunks,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
}

// ApplicationHealthStateChunkList the list of application health state chunks in the cluster that respect
// the input filters in the chunk query. Returned by get cluster health state chunks query.
type ApplicationHealthStateChunkList struct {
	// Items - The list of application health state chunks that respect the input filters in the chunk query.
	Items *[]ApplicationHealthStateChunk `json:"Items,omitempty"`
	// TotalCount - Total number of entity health state objects that match the specified filters from the cluster health chunk query description.
	TotalCount *int64 `json:"TotalCount,omitempty"`
}

// ApplicationHealthStateFilter defines matching criteria to determine whether a application should be
// included in the cluster health chunk.
// One filter can match zero, one or multiple applications, depending on its properties.
type ApplicationHealthStateFilter struct {
	// ApplicationNameFilter - The name of the application that matches the filter, as a fabric uri. The filter is applied only to the specified application, if it exists.
	// If the application doesn't exist, no application is returned in the cluster health chunk based on this filter.
	// If the application exists, it is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationNameFilter *string `json:"ApplicationNameFilter,omitempty"`
	// ApplicationTypeNameFilter - The name of the application type that matches the filter.
	// If specified, the filter is applied only to applications of the selected application type, if any exists.
	// If no applications of the specified application type exists, no application is returned in the cluster health chunk based on this filter.
	// Each application of the specified application type is included in the cluster health chunk if it respects the other filter properties.
	// If not specified, all applications are matched against the other filter members, like health state filter.
	ApplicationTypeNameFilter *string `json:"ApplicationTypeNameFilter,omitempty"`
	// HealthStateFilter - The filter for the health state of the applications. It allows selecting applications if they match the desired health states.
	// The possible values are integer value of one of the following health states. Only applications that match the filter are returned. All applications are used to evaluate the cluster aggregated health state.
	// If not specified, default value is None, unless the application name or the application type name are specified. If the filter has default value and application name is specified, the matching application is returned.
	// The state values are flag-based enumeration, so the value could be a combination of these values obtained using bitwise 'OR' operator.
	// For example, if the provided value is 6, it matches applications with HealthState value of OK (2) and Warning (4).
	// - Default - Default value. Matches any HealthState. The value is zero.
	// - None - Filter that doesn't match any HealthState value. Used in order to return no results on a given collection of states. The value is 1.
	// - Ok - Filter that matches input with HealthState value Ok. The value is 2.
	// - Warning - Filter that matches input with HealthState value Warning. The value is 4.
	// - Error - Filter that matches input with HealthState value Error. The value is 8.
	// - All - Filter that matches input with any HealthState value. The value is 65535.
	HealthStateFilter *int32 `json:"HealthStateFilter,omitempty"`
	// ServiceFilters - Defines a list of filters that specify which services to be included in the returned cluster health chunk as children of the application. The services are returned only if the parent application matches a filter.
	// If the list is empty, no services are returned. All the services are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple service filters.
	// For example, it can specify a filter to return all services with health state Error and another filter to always include a service identified by its service name.
	ServiceFilters *[]ServiceHealthStateFilter `json:"ServiceFilters,omitempty"`
	// DeployedApplicationFilters - Defines a list of filters that specify which deployed applications to be included in the returned cluster health chunk as children of the application. The deployed applications are returned only if the parent application matches a filter.
	// If the list is empty, no deployed applications are returned. All the deployed applications are used to evaluate the parent application aggregated health state, regardless of the input filters.
	// The application filter may specify multiple deployed application filters.
	// For example, it can specify a filter to return all deployed applications with health state Error and another filter to always include a deployed application on a specified node.
	DeployedApplicationFilters *[]DeployedApplicationHealthStateFilter `json:"DeployedApplicationFilters,omitempty"`
}

// ApplicationInfo information about a Service Fabric application.
type ApplicationInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TypeVersion - The version of the application type as defined in the application manifest.
	TypeVersion *string `json:"TypeVersion,omitempty"`
	// Status - The status of the application. Possible values include: 'ApplicationStatusInvalid', 'ApplicationStatusReady', 'ApplicationStatusUpgrading', 'ApplicationStatusCreating', 'ApplicationStatusDeleting', 'ApplicationStatusFailed'
	Status ApplicationStatus `json:"Status,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// HealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// ApplicationDefinitionKind - The mechanism used to define a Service Fabric application. Possible values include: 'Invalid', 'ServiceFabricApplicationDescription', 'Compose'
	ApplicationDefinitionKind ApplicationDefinitionKind `json:"ApplicationDefinitionKind,omitempty"`
}

// ApplicationLoadInfo load Information about a Service Fabric application.
type ApplicationLoadInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// MinimumNodes - The minimum number of nodes for this application.
	// It is the number of nodes where Service Fabric will reserve Capacity in the cluster which equals to ReservedLoad * MinimumNodes for this Application instance.
	// For applications that do not have application capacity defined this value will be zero.
	MinimumNodes *int64 `json:"MinimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where this application can be instantiated.
	// It is the number of nodes this application is allowed to span.
	// For applications that do not have application capacity defined this value will be zero.
	MaximumNodes *int64 `json:"MaximumNodes,omitempty"`
	// NodeCount - The number of nodes on which this application is instantiated.
	// For applications that do not have application capacity defined this value will be zero.
	NodeCount *int64 `json:"NodeCount,omitempty"`
	// ApplicationLoadMetricInformation - List of application capacity metric description.
	ApplicationLoadMetricInformation *[]ApplicationMetricDescription `json:"ApplicationLoadMetricInformation,omitempty"`
}

// ApplicationMetricDescription describes capacity information for a custom resource balancing metric. This
// can be used to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// Name - The name of the metric.
	Name *string `json:"Name,omitempty"`
	// MaximumCapacity - The maximum node capacity for Service Fabric application.
	// This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
	// If set to zero, capacity for this metric is unlimited on each node.
	// When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	// When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64 `json:"MaximumCapacity,omitempty"`
	// ReservationCapacity - The node reservation capacity for Service Fabric application.
	// This is the amount of load which is reserved on nodes which have instances of this application.
	// If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
	// If set to zero, no capacity is reserved for this metric.
	// When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64 `json:"ReservationCapacity,omitempty"`
	// TotalApplicationCapacity - The total metric capacity for Service Fabric application.
	// This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
	// When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64 `json:"TotalApplicationCapacity,omitempty"`
}

// ApplicationNameInfo information about the application name.
type ApplicationNameInfo struct {
	autorest.Response `json:"-"`
	// ID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ID *string `json:"Id,omitempty"`
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
}

// ApplicationNewHealthReportEvent application Health Report Created event.
type ApplicationNewHealthReportEvent struct {
	// ApplicationInstanceID - Id of Application instance.
	ApplicationInstanceID *int64 `json:"ApplicationInstanceId,omitempty"`
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) MarshalJSON() ([]byte, error) {
	anhre.Kind = KindApplicationNewHealthReport
	objectMap := make(map[string]interface{})
	if anhre.ApplicationInstanceID != nil {
		objectMap["ApplicationInstanceId"] = anhre.ApplicationInstanceID
	}
	if anhre.SourceID != nil {
		objectMap["SourceId"] = anhre.SourceID
	}
	if anhre.Property != nil {
		objectMap["Property"] = anhre.Property
	}
	if anhre.HealthState != nil {
		objectMap["HealthState"] = anhre.HealthState
	}
	if anhre.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = anhre.TimeToLiveMs
	}
	if anhre.SequenceNumber != nil {
		objectMap["SequenceNumber"] = anhre.SequenceNumber
	}
	if anhre.Description != nil {
		objectMap["Description"] = anhre.Description
	}
	if anhre.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = anhre.RemoveWhenExpired
	}
	if anhre.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = anhre.SourceUtcTimestamp
	}
	if anhre.ApplicationID != nil {
		objectMap["ApplicationId"] = anhre.ApplicationID
	}
	if anhre.EventInstanceID != nil {
		objectMap["EventInstanceId"] = anhre.EventInstanceID
	}
	if anhre.Category != nil {
		objectMap["Category"] = anhre.Category
	}
	if anhre.TimeStamp != nil {
		objectMap["TimeStamp"] = anhre.TimeStamp
	}
	if anhre.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = anhre.HasCorrelatedEvents
	}
	if anhre.Kind != "" {
		objectMap["Kind"] = anhre.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &anhre, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return &anhre, true
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationNewHealthReportEvent.
func (anhre ApplicationNewHealthReportEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &anhre, true
}

// ApplicationParameter describes an application parameter override to be applied when creating or
// upgrading an application.
type ApplicationParameter struct {
	// Key - The name of the parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the parameter.
	Value *string `json:"Value,omitempty"`
}

// ApplicationProcessExitedEvent process Exited event.
type ApplicationProcessExitedEvent struct {
	// ServiceName - Name of Service.
	ServiceName *string `json:"ServiceName,omitempty"`
	// ServicePackageName - Name of Service package.
	ServicePackageName *string `json:"ServicePackageName,omitempty"`
	// ServicePackageActivationID - Activation Id of Service package.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// IsExclusive - Indicates IsExclusive flag.
	IsExclusive *bool `json:"IsExclusive,omitempty"`
	// CodePackageName - Name of Code package.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// EntryPointType - Type of EntryPoint.
	EntryPointType *string `json:"EntryPointType,omitempty"`
	// ExeName - Name of executable.
	ExeName *string `json:"ExeName,omitempty"`
	// ProcessID - Process Id.
	ProcessID *int64 `json:"ProcessId,omitempty"`
	// HostID - Host Id.
	HostID *string `json:"HostId,omitempty"`
	// ExitCode - Exit code of process.
	ExitCode *int64 `json:"ExitCode,omitempty"`
	// UnexpectedTermination - Indicates if termination is unexpected.
	UnexpectedTermination *bool `json:"UnexpectedTermination,omitempty"`
	// StartTime - Start time of process.
	StartTime *date.Time `json:"StartTime,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) MarshalJSON() ([]byte, error) {
	apee.Kind = KindApplicationProcessExited
	objectMap := make(map[string]interface{})
	if apee.ServiceName != nil {
		objectMap["ServiceName"] = apee.ServiceName
	}
	if apee.ServicePackageName != nil {
		objectMap["ServicePackageName"] = apee.ServicePackageName
	}
	if apee.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = apee.ServicePackageActivationID
	}
	if apee.IsExclusive != nil {
		objectMap["IsExclusive"] = apee.IsExclusive
	}
	if apee.CodePackageName != nil {
		objectMap["CodePackageName"] = apee.CodePackageName
	}
	if apee.EntryPointType != nil {
		objectMap["EntryPointType"] = apee.EntryPointType
	}
	if apee.ExeName != nil {
		objectMap["ExeName"] = apee.ExeName
	}
	if apee.ProcessID != nil {
		objectMap["ProcessId"] = apee.ProcessID
	}
	if apee.HostID != nil {
		objectMap["HostId"] = apee.HostID
	}
	if apee.ExitCode != nil {
		objectMap["ExitCode"] = apee.ExitCode
	}
	if apee.UnexpectedTermination != nil {
		objectMap["UnexpectedTermination"] = apee.UnexpectedTermination
	}
	if apee.StartTime != nil {
		objectMap["StartTime"] = apee.StartTime
	}
	if apee.ApplicationID != nil {
		objectMap["ApplicationId"] = apee.ApplicationID
	}
	if apee.EventInstanceID != nil {
		objectMap["EventInstanceId"] = apee.EventInstanceID
	}
	if apee.Category != nil {
		objectMap["Category"] = apee.Category
	}
	if apee.TimeStamp != nil {
		objectMap["TimeStamp"] = apee.TimeStamp
	}
	if apee.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = apee.HasCorrelatedEvents
	}
	if apee.Kind != "" {
		objectMap["Kind"] = apee.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &apee, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return &apee, true
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationProcessExitedEvent.
func (apee ApplicationProcessExitedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &apee, true
}

// ApplicationProperties describes properties of a application resource.
type ApplicationProperties struct {
	// Description - User readable description of the application.
	Description *string `json:"description,omitempty"`
	// Services - Describes the services in the application. This property is used to create or modify services of the application. On get only the name of the service is returned. The service description can be obtained by querying for the service resource.
	Services *[]ServiceResourceDescription `json:"services,omitempty"`
	// Diagnostics - Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription `json:"diagnostics,omitempty"`
	// DebugParams - Internal - used by Visual Studio to setup the debugging session on the local development environment.
	DebugParams *string `json:"debugParams,omitempty"`
	// ServiceNames - Names of the services in the application.
	ServiceNames *[]string `json:"serviceNames,omitempty"`
	// Status - Status of the application. Possible values include: 'ResourceStatusUnknown', 'ResourceStatusReady', 'ResourceStatusUpgrading', 'ResourceStatusCreating', 'ResourceStatusDeleting', 'ResourceStatusFailed'
	Status ResourceStatus `json:"status,omitempty"`
	// StatusDetails - Gives additional information about the current status of the application.
	StatusDetails *string `json:"statusDetails,omitempty"`
	// HealthState - Describes the health state of an application resource. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"healthState,omitempty"`
	// UnhealthyEvaluation - When the application's health state is not 'Ok', this additional details from service fabric Health Manager for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string `json:"unhealthyEvaluation,omitempty"`
}

// ApplicationResourceDescription this type describes a application resource.
type ApplicationResourceDescription struct {
	autorest.Response `json:"-"`
	// Name - Name of the Application resource.
	Name *string `json:"name,omitempty"`
	// ApplicationProperties - Describes properties of a application resource.
	*ApplicationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceDescription.
func (ard ApplicationResourceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ard.Name != nil {
		objectMap["name"] = ard.Name
	}
	if ard.ApplicationProperties != nil {
		objectMap["properties"] = ard.ApplicationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceDescription struct.
func (ard *ApplicationResourceDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ard.Name = &name
			}
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				ard.ApplicationProperties = &applicationProperties
			}
		}
	}

	return nil
}

// ApplicationScopedVolume describes a volume whose lifetime is scoped to the application's lifetime.
type ApplicationScopedVolume struct {
	// CreationParameters - Describes parameters for creating application-scoped volumes.
	CreationParameters BasicApplicationScopedVolumeCreationParameters `json:"creationParameters,omitempty"`
	// Name - Name of the volume being referenced.
	Name *string `json:"name,omitempty"`
	// ReadOnly - The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool `json:"readOnly,omitempty"`
	// DestinationPath - The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string `json:"destinationPath,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApplicationScopedVolume struct.
func (asv *ApplicationScopedVolume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "creationParameters":
			if v != nil {
				creationParameters, err := unmarshalBasicApplicationScopedVolumeCreationParameters(*v)
				if err != nil {
					return err
				}
				asv.CreationParameters = creationParameters
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asv.Name = &name
			}
		case "readOnly":
			if v != nil {
				var readOnly bool
				err = json.Unmarshal(*v, &readOnly)
				if err != nil {
					return err
				}
				asv.ReadOnly = &readOnly
			}
		case "destinationPath":
			if v != nil {
				var destinationPath string
				err = json.Unmarshal(*v, &destinationPath)
				if err != nil {
					return err
				}
				asv.DestinationPath = &destinationPath
			}
		}
	}

	return nil
}

// BasicApplicationScopedVolumeCreationParameters describes parameters for creating application-scoped volumes.
type BasicApplicationScopedVolumeCreationParameters interface {
	AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool)
	AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool)
}

// ApplicationScopedVolumeCreationParameters describes parameters for creating application-scoped volumes.
type ApplicationScopedVolumeCreationParameters struct {
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindApplicationScopedVolumeCreationParameters', 'KindServiceFabricVolumeDisk'
	Kind KindBasicApplicationScopedVolumeCreationParameters `json:"kind,omitempty"`
}

func unmarshalBasicApplicationScopedVolumeCreationParameters(body []byte) (BasicApplicationScopedVolumeCreationParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindServiceFabricVolumeDisk):
		var asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk
		err := json.Unmarshal(body, &asvcpsfvd)
		return asvcpsfvd, err
	default:
		var asvcp ApplicationScopedVolumeCreationParameters
		err := json.Unmarshal(body, &asvcp)
		return asvcp, err
	}
}
func unmarshalBasicApplicationScopedVolumeCreationParametersArray(body []byte) ([]BasicApplicationScopedVolumeCreationParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asvcpArray := make([]BasicApplicationScopedVolumeCreationParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asvcp, err := unmarshalBasicApplicationScopedVolumeCreationParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		asvcpArray[index] = asvcp
	}
	return asvcpArray, nil
}

// MarshalJSON is the custom marshaler for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) MarshalJSON() ([]byte, error) {
	asvcp.Kind = KindApplicationScopedVolumeCreationParameters
	objectMap := make(map[string]interface{})
	if asvcp.Description != nil {
		objectMap["description"] = asvcp.Description
	}
	if asvcp.Kind != "" {
		objectMap["kind"] = asvcp.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool) {
	return nil, false
}

// AsApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool) {
	return &asvcp, true
}

// AsBasicApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParameters.
func (asvcp ApplicationScopedVolumeCreationParameters) AsBasicApplicationScopedVolumeCreationParameters() (BasicApplicationScopedVolumeCreationParameters, bool) {
	return &asvcp, true
}

// ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk describes parameters for creating
// application-scoped volumes provided by Service Fabric Volume Disks
type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk struct {
	// SizeDisk - Volume size. Possible values include: 'SizeTypesSmall', 'SizeTypesMedium', 'SizeTypesLarge'
	SizeDisk SizeTypes `json:"sizeDisk,omitempty"`
	// Description - User readable description of the volume.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindApplicationScopedVolumeCreationParameters', 'KindServiceFabricVolumeDisk'
	Kind KindBasicApplicationScopedVolumeCreationParameters `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) MarshalJSON() ([]byte, error) {
	asvcpsfvd.Kind = KindServiceFabricVolumeDisk
	objectMap := make(map[string]interface{})
	if asvcpsfvd.SizeDisk != "" {
		objectMap["sizeDisk"] = asvcpsfvd.SizeDisk
	}
	if asvcpsfvd.Description != nil {
		objectMap["description"] = asvcpsfvd.Description
	}
	if asvcpsfvd.Kind != "" {
		objectMap["kind"] = asvcpsfvd.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk() (*ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk, bool) {
	return &asvcpsfvd, true
}

// AsApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsApplicationScopedVolumeCreationParameters() (*ApplicationScopedVolumeCreationParameters, bool) {
	return nil, false
}

// AsBasicApplicationScopedVolumeCreationParameters is the BasicApplicationScopedVolumeCreationParameters implementation for ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (asvcpsfvd ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) AsBasicApplicationScopedVolumeCreationParameters() (BasicApplicationScopedVolumeCreationParameters, bool) {
	return &asvcpsfvd, true
}

// ApplicationsHealthEvaluation represents health evaluation for applications, containing health
// evaluations for each unhealthy application that impacted current aggregated health state.
type ApplicationsHealthEvaluation struct {
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications from the ClusterHealthPolicy.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications from the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	ahe.Kind = KindApplications
	objectMap := make(map[string]interface{})
	if ahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = ahe.MaxPercentUnhealthyApplications
	}
	if ahe.TotalCount != nil {
		objectMap["TotalCount"] = ahe.TotalCount
	}
	if ahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = ahe.UnhealthyEvaluations
	}
	if ahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = ahe.AggregatedHealthState
	}
	if ahe.Description != nil {
		objectMap["Description"] = ahe.Description
	}
	if ahe.Kind != "" {
		objectMap["Kind"] = ahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return &ahe, true
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationsHealthEvaluation.
func (ahe ApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &ahe, true
}

// ApplicationTypeApplicationsHealthEvaluation represents health evaluation for applications of a
// particular application type. The application type applications evaluation can be returned when cluster
// health evaluation returns unhealthy aggregated health state, either Error or Warning. It contains health
// evaluations for each unhealthy application of the included application type that impacted current
// aggregated health state.
type ApplicationTypeApplicationsHealthEvaluation struct {
	// ApplicationTypeName - The application type name as defined in the application manifest.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// MaxPercentUnhealthyApplications - Maximum allowed percentage of unhealthy applications for the application type, specified as an entry in ApplicationTypeHealthPolicyMap.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// TotalCount - Total number of applications of the application type found in the health store.
	TotalCount *int64 `json:"TotalCount,omitempty"`
	// UnhealthyEvaluations - List of unhealthy evaluations that led to the aggregated health state. Includes all the unhealthy ApplicationHealthEvaluation of this application type that impacted the aggregated health.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// AggregatedHealthState - The health state of a Service Fabric entity such as Cluster, Node, Application, Service, Partition, Replica etc. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// Description - Description of the health evaluation, which represents a summary of the evaluation process.
	Description *string `json:"Description,omitempty"`
	// Kind - Possible values include: 'KindHealthEvaluation', 'KindApplication', 'KindApplications', 'KindApplicationTypeApplications', 'KindDeltaNodesCheck', 'KindDeployedApplication', 'KindDeployedApplications', 'KindDeployedServicePackage', 'KindDeployedServicePackages', 'KindEvent', 'KindNode', 'KindNodes', 'KindPartition', 'KindPartitions', 'KindReplica', 'KindReplicas', 'KindService', 'KindServices', 'KindSystemApplication', 'KindUpgradeDomainDeltaNodesCheck', 'KindUpgradeDomainNodes'
	Kind Kind `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) MarshalJSON() ([]byte, error) {
	atahe.Kind = KindApplicationTypeApplications
	objectMap := make(map[string]interface{})
	if atahe.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = atahe.ApplicationTypeName
	}
	if atahe.MaxPercentUnhealthyApplications != nil {
		objectMap["MaxPercentUnhealthyApplications"] = atahe.MaxPercentUnhealthyApplications
	}
	if atahe.TotalCount != nil {
		objectMap["TotalCount"] = atahe.TotalCount
	}
	if atahe.UnhealthyEvaluations != nil {
		objectMap["UnhealthyEvaluations"] = atahe.UnhealthyEvaluations
	}
	if atahe.AggregatedHealthState != "" {
		objectMap["AggregatedHealthState"] = atahe.AggregatedHealthState
	}
	if atahe.Description != nil {
		objectMap["Description"] = atahe.Description
	}
	if atahe.Kind != "" {
		objectMap["Kind"] = atahe.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationHealthEvaluation() (*ApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationsHealthEvaluation() (*ApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsApplicationTypeApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsApplicationTypeApplicationsHealthEvaluation() (*ApplicationTypeApplicationsHealthEvaluation, bool) {
	return &atahe, true
}

// AsDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeltaNodesCheckHealthEvaluation() (*DeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationHealthEvaluation() (*DeployedApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedApplicationsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedApplicationsHealthEvaluation() (*DeployedApplicationsHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackageHealthEvaluation() (*DeployedServicePackageHealthEvaluation, bool) {
	return nil, false
}

// AsDeployedServicePackagesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsDeployedServicePackagesHealthEvaluation() (*DeployedServicePackagesHealthEvaluation, bool) {
	return nil, false
}

// AsEventHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsEventHealthEvaluation() (*EventHealthEvaluation, bool) {
	return nil, false
}

// AsNodeHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodeHealthEvaluation() (*NodeHealthEvaluation, bool) {
	return nil, false
}

// AsNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsNodesHealthEvaluation() (*NodesHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionHealthEvaluation() (*PartitionHealthEvaluation, bool) {
	return nil, false
}

// AsPartitionsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsPartitionsHealthEvaluation() (*PartitionsHealthEvaluation, bool) {
	return nil, false
}

// AsReplicaHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicaHealthEvaluation() (*ReplicaHealthEvaluation, bool) {
	return nil, false
}

// AsReplicasHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsReplicasHealthEvaluation() (*ReplicasHealthEvaluation, bool) {
	return nil, false
}

// AsServiceHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServiceHealthEvaluation() (*ServiceHealthEvaluation, bool) {
	return nil, false
}

// AsServicesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsServicesHealthEvaluation() (*ServicesHealthEvaluation, bool) {
	return nil, false
}

// AsSystemApplicationHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsSystemApplicationHealthEvaluation() (*SystemApplicationHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainDeltaNodesCheckHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainDeltaNodesCheckHealthEvaluation() (*UpgradeDomainDeltaNodesCheckHealthEvaluation, bool) {
	return nil, false
}

// AsUpgradeDomainNodesHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsUpgradeDomainNodesHealthEvaluation() (*UpgradeDomainNodesHealthEvaluation, bool) {
	return nil, false
}

// AsHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsHealthEvaluation() (*HealthEvaluation, bool) {
	return nil, false
}

// AsBasicHealthEvaluation is the BasicHealthEvaluation implementation for ApplicationTypeApplicationsHealthEvaluation.
func (atahe ApplicationTypeApplicationsHealthEvaluation) AsBasicHealthEvaluation() (BasicHealthEvaluation, bool) {
	return &atahe, true
}

// ApplicationTypeHealthPolicyMapItem defines an item in ApplicationTypeHealthPolicyMap.
type ApplicationTypeHealthPolicyMapItem struct {
	// Key - The key of the application type health policy map item. This is the name of the application type.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the application type health policy map item.
	// The max percent unhealthy applications allowed for the application type. Must be between zero and 100.
	Value *int32 `json:"Value,omitempty"`
}

// ApplicationTypeImageStorePath path description for the application package in the image store specified
// during the prior copy operation.
type ApplicationTypeImageStorePath struct {
	// ApplicationTypeBuildPath - The relative image store path to the application package.
	ApplicationTypeBuildPath *string `json:"ApplicationTypeBuildPath,omitempty"`
}

// ApplicationTypeInfo information about an application type.
type ApplicationTypeInfo struct {
	// Name - The application type name as defined in the application manifest.
	Name *string `json:"Name,omitempty"`
	// Version - The version of the application type as defined in the application manifest.
	Version *string `json:"Version,omitempty"`
	// DefaultParameterList - List of application type parameters that can be overridden when creating or updating the application.
	DefaultParameterList *[]ApplicationParameter `json:"DefaultParameterList,omitempty"`
	// Status - The status of the application type. Possible values include: 'ApplicationTypeStatusInvalid', 'ApplicationTypeStatusProvisioning', 'ApplicationTypeStatusAvailable', 'ApplicationTypeStatusUnprovisioning', 'ApplicationTypeStatusFailed'
	Status ApplicationTypeStatus `json:"Status,omitempty"`
	// StatusDetails - Additional detailed information about the status of the application type.
	StatusDetails *string `json:"StatusDetails,omitempty"`
	// ApplicationTypeDefinitionKind - The mechanism used to define a Service Fabric application type. Possible values include: 'ApplicationTypeDefinitionKindInvalid', 'ApplicationTypeDefinitionKindServiceFabricApplicationPackage', 'ApplicationTypeDefinitionKindCompose'
	ApplicationTypeDefinitionKind ApplicationTypeDefinitionKind `json:"ApplicationTypeDefinitionKind,omitempty"`
}

// ApplicationTypeManifest contains the manifest describing an application type registered in a Service
// Fabric cluster.
type ApplicationTypeManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The XML manifest as a string.
	Manifest *string `json:"Manifest,omitempty"`
}

// ApplicationUpgradeCompletedEvent application Upgrade Completed event.
type ApplicationUpgradeCompletedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) MarshalJSON() ([]byte, error) {
	auce.Kind = KindApplicationUpgradeCompleted
	objectMap := make(map[string]interface{})
	if auce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = auce.ApplicationTypeName
	}
	if auce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = auce.ApplicationTypeVersion
	}
	if auce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = auce.OverallUpgradeElapsedTimeInMs
	}
	if auce.ApplicationID != nil {
		objectMap["ApplicationId"] = auce.ApplicationID
	}
	if auce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = auce.EventInstanceID
	}
	if auce.Category != nil {
		objectMap["Category"] = auce.Category
	}
	if auce.TimeStamp != nil {
		objectMap["TimeStamp"] = auce.TimeStamp
	}
	if auce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = auce.HasCorrelatedEvents
	}
	if auce.Kind != "" {
		objectMap["Kind"] = auce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &auce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return &auce, true
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeCompletedEvent.
func (auce ApplicationUpgradeCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &auce, true
}

// ApplicationUpgradeDescription describes the parameters for an application upgrade. Note that upgrade
// description replaces the existing application description. This means that if the parameters are not
// specified, the existing parameters on the applications will be overwritten with the empty parameters
// list. This would result in the application using the default value of the parameters from the
// application manifest. If you do not want to change any existing parameter values, please get the
// application parameters first using the GetApplicationInfo query and then supply those values as
// Parameters in this ApplicationUpgradeDescription.
type ApplicationUpgradeDescription struct {
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// Parameters - List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters *[]ApplicationParameter `json:"Parameters,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
}

// ApplicationUpgradeDomainCompletedEvent application Upgrade Domain Completed event.
type ApplicationUpgradeDomainCompletedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// UpgradeState - State of upgrade.
	UpgradeState *string `json:"UpgradeState,omitempty"`
	// UpgradeDomains - Upgrade domains.
	UpgradeDomains *string `json:"UpgradeDomains,omitempty"`
	// UpgradeDomainElapsedTimeInMs - Upgrade time of domain in milli-seconds.
	UpgradeDomainElapsedTimeInMs *float64 `json:"UpgradeDomainElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) MarshalJSON() ([]byte, error) {
	audce.Kind = KindApplicationUpgradeDomainCompleted
	objectMap := make(map[string]interface{})
	if audce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = audce.ApplicationTypeName
	}
	if audce.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = audce.CurrentApplicationTypeVersion
	}
	if audce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = audce.ApplicationTypeVersion
	}
	if audce.UpgradeState != nil {
		objectMap["UpgradeState"] = audce.UpgradeState
	}
	if audce.UpgradeDomains != nil {
		objectMap["UpgradeDomains"] = audce.UpgradeDomains
	}
	if audce.UpgradeDomainElapsedTimeInMs != nil {
		objectMap["UpgradeDomainElapsedTimeInMs"] = audce.UpgradeDomainElapsedTimeInMs
	}
	if audce.ApplicationID != nil {
		objectMap["ApplicationId"] = audce.ApplicationID
	}
	if audce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = audce.EventInstanceID
	}
	if audce.Category != nil {
		objectMap["Category"] = audce.Category
	}
	if audce.TimeStamp != nil {
		objectMap["TimeStamp"] = audce.TimeStamp
	}
	if audce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = audce.HasCorrelatedEvents
	}
	if audce.Kind != "" {
		objectMap["Kind"] = audce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &audce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return &audce, true
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeDomainCompletedEvent.
func (audce ApplicationUpgradeDomainCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &audce, true
}

// ApplicationUpgradeProgressInfo describes the parameters for an application upgrade.
type ApplicationUpgradeProgressInfo struct {
	autorest.Response `json:"-"`
	// Name - The name of the target application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// TypeName - The application type name as defined in the application manifest.
	TypeName *string `json:"TypeName,omitempty"`
	// TargetApplicationTypeVersion - The target application type version (found in the application manifest) for the application upgrade.
	TargetApplicationTypeVersion *string `json:"TargetApplicationTypeVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Describes the parameters for an application upgrade. Note that upgrade description replaces the existing application description. This means that if the parameters are not specified, the existing parameters on the applications will be overwritten with the empty parameters list. This would result in the application using the default value of the parameters from the application manifest. If you do not want to change any existing parameter values, please get the application parameters first using the GetApplicationInfo query and then supply those values as Parameters in this ApplicationUpgradeDescription.
	UpgradeDescription *ApplicationUpgradeDescription `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated total amount of time spent processing the overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated total amount of time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The estimated UTC datetime when the upgrade started.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The estimated UTC datetime when the upgrade failed and FailureAction was executed.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - Information about the upgrade domain progress at the time of upgrade failure.
	UpgradeDomainProgressAtFailure *FailureUpgradeDomainProgressInfo `json:"UpgradeDomainProgressAtFailure,omitempty"`
	// UpgradeStatusDetails - Additional detailed information about the status of the pending upgrade.
	UpgradeStatusDetails *string `json:"UpgradeStatusDetails,omitempty"`
}

// ApplicationUpgradeRollbackCompletedEvent application Upgrade Rollback Completed event.
type ApplicationUpgradeRollbackCompletedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// ApplicationTypeVersion - Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// FailureReason - Describes reason of failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) MarshalJSON() ([]byte, error) {
	aurce.Kind = KindApplicationUpgradeRollbackCompleted
	objectMap := make(map[string]interface{})
	if aurce.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = aurce.ApplicationTypeName
	}
	if aurce.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = aurce.ApplicationTypeVersion
	}
	if aurce.FailureReason != nil {
		objectMap["FailureReason"] = aurce.FailureReason
	}
	if aurce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = aurce.OverallUpgradeElapsedTimeInMs
	}
	if aurce.ApplicationID != nil {
		objectMap["ApplicationId"] = aurce.ApplicationID
	}
	if aurce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = aurce.EventInstanceID
	}
	if aurce.Category != nil {
		objectMap["Category"] = aurce.Category
	}
	if aurce.TimeStamp != nil {
		objectMap["TimeStamp"] = aurce.TimeStamp
	}
	if aurce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = aurce.HasCorrelatedEvents
	}
	if aurce.Kind != "" {
		objectMap["Kind"] = aurce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &aurce, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return &aurce, true
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackCompletedEvent.
func (aurce ApplicationUpgradeRollbackCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &aurce, true
}

// ApplicationUpgradeRollbackStartedEvent application Upgrade Rollback Started event.
type ApplicationUpgradeRollbackStartedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// FailureReason - Describes reason of failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall upgrade time in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) MarshalJSON() ([]byte, error) {
	aurse.Kind = KindApplicationUpgradeRollbackStarted
	objectMap := make(map[string]interface{})
	if aurse.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = aurse.ApplicationTypeName
	}
	if aurse.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = aurse.CurrentApplicationTypeVersion
	}
	if aurse.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = aurse.ApplicationTypeVersion
	}
	if aurse.FailureReason != nil {
		objectMap["FailureReason"] = aurse.FailureReason
	}
	if aurse.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = aurse.OverallUpgradeElapsedTimeInMs
	}
	if aurse.ApplicationID != nil {
		objectMap["ApplicationId"] = aurse.ApplicationID
	}
	if aurse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = aurse.EventInstanceID
	}
	if aurse.Category != nil {
		objectMap["Category"] = aurse.Category
	}
	if aurse.TimeStamp != nil {
		objectMap["TimeStamp"] = aurse.TimeStamp
	}
	if aurse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = aurse.HasCorrelatedEvents
	}
	if aurse.Kind != "" {
		objectMap["Kind"] = aurse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &aurse, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return &aurse, true
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeRollbackStartedEvent.
func (aurse ApplicationUpgradeRollbackStartedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &aurse, true
}

// ApplicationUpgradeStartedEvent application Upgrade Started event.
type ApplicationUpgradeStartedEvent struct {
	// ApplicationTypeName - Application type name.
	ApplicationTypeName *string `json:"ApplicationTypeName,omitempty"`
	// CurrentApplicationTypeVersion - Current Application type version.
	CurrentApplicationTypeVersion *string `json:"CurrentApplicationTypeVersion,omitempty"`
	// ApplicationTypeVersion - Target Application type version.
	ApplicationTypeVersion *string `json:"ApplicationTypeVersion,omitempty"`
	// UpgradeType - Type of upgrade.
	UpgradeType *string `json:"UpgradeType,omitempty"`
	// RollingUpgradeMode - Mode of upgrade.
	RollingUpgradeMode *string `json:"RollingUpgradeMode,omitempty"`
	// FailureAction - Action if failed.
	FailureAction *string `json:"FailureAction,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) MarshalJSON() ([]byte, error) {
	ause.Kind = KindApplicationUpgradeStarted
	objectMap := make(map[string]interface{})
	if ause.ApplicationTypeName != nil {
		objectMap["ApplicationTypeName"] = ause.ApplicationTypeName
	}
	if ause.CurrentApplicationTypeVersion != nil {
		objectMap["CurrentApplicationTypeVersion"] = ause.CurrentApplicationTypeVersion
	}
	if ause.ApplicationTypeVersion != nil {
		objectMap["ApplicationTypeVersion"] = ause.ApplicationTypeVersion
	}
	if ause.UpgradeType != nil {
		objectMap["UpgradeType"] = ause.UpgradeType
	}
	if ause.RollingUpgradeMode != nil {
		objectMap["RollingUpgradeMode"] = ause.RollingUpgradeMode
	}
	if ause.FailureAction != nil {
		objectMap["FailureAction"] = ause.FailureAction
	}
	if ause.ApplicationID != nil {
		objectMap["ApplicationId"] = ause.ApplicationID
	}
	if ause.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ause.EventInstanceID
	}
	if ause.Category != nil {
		objectMap["Category"] = ause.Category
	}
	if ause.TimeStamp != nil {
		objectMap["TimeStamp"] = ause.TimeStamp
	}
	if ause.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ause.HasCorrelatedEvents
	}
	if ause.Kind != "" {
		objectMap["Kind"] = ause.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ause, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return &ause, true
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ApplicationUpgradeStartedEvent.
func (ause ApplicationUpgradeStartedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ause, true
}

// ApplicationUpgradeUpdateDescription describes the parameters for updating an ongoing application
// upgrade.
type ApplicationUpgradeUpdateDescription struct {
	// Name - The name of the application, including the 'fabric:' URI scheme.
	Name *string `json:"Name,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ApplicationHealthPolicy `json:"ApplicationHealthPolicy,omitempty"`
	// UpdateDescription - Describes the parameters for updating a rolling upgrade of application or cluster.
	UpdateDescription *RollingUpgradeUpdateDescription `json:"UpdateDescription,omitempty"`
}

// BasicAutoScalingMechanism describes the mechanism for performing auto scaling operation. Derived classes will
// describe the actual mechanism.
type BasicAutoScalingMechanism interface {
	AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool)
	AsAutoScalingMechanism() (*AutoScalingMechanism, bool)
}

// AutoScalingMechanism describes the mechanism for performing auto scaling operation. Derived classes will
// describe the actual mechanism.
type AutoScalingMechanism struct {
	// Kind - Possible values include: 'KindAutoScalingMechanism', 'KindAddRemoveReplica'
	Kind KindBasicAutoScalingMechanism `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingMechanism(body []byte) (BasicAutoScalingMechanism, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAddRemoveReplica):
		var arrsm AddRemoveReplicaScalingMechanism
		err := json.Unmarshal(body, &arrsm)
		return arrsm, err
	default:
		var asm AutoScalingMechanism
		err := json.Unmarshal(body, &asm)
		return asm, err
	}
}
func unmarshalBasicAutoScalingMechanismArray(body []byte) ([]BasicAutoScalingMechanism, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asmArray := make([]BasicAutoScalingMechanism, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asm, err := unmarshalBasicAutoScalingMechanism(*rawMessage)
		if err != nil {
			return nil, err
		}
		asmArray[index] = asm
	}
	return asmArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingMechanism.
func (asm AutoScalingMechanism) MarshalJSON() ([]byte, error) {
	asm.Kind = KindAutoScalingMechanism
	objectMap := make(map[string]interface{})
	if asm.Kind != "" {
		objectMap["kind"] = asm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAddRemoveReplicaScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsAddRemoveReplicaScalingMechanism() (*AddRemoveReplicaScalingMechanism, bool) {
	return nil, false
}

// AsAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsAutoScalingMechanism() (*AutoScalingMechanism, bool) {
	return &asm, true
}

// AsBasicAutoScalingMechanism is the BasicAutoScalingMechanism implementation for AutoScalingMechanism.
func (asm AutoScalingMechanism) AsBasicAutoScalingMechanism() (BasicAutoScalingMechanism, bool) {
	return &asm, true
}

// BasicAutoScalingMetric describes the metric that is used for triggering auto scaling operation. Derived classes will
// describe resources or metrics.
type BasicAutoScalingMetric interface {
	AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool)
	AsAutoScalingMetric() (*AutoScalingMetric, bool)
}

// AutoScalingMetric describes the metric that is used for triggering auto scaling operation. Derived classes
// will describe resources or metrics.
type AutoScalingMetric struct {
	// Kind - Possible values include: 'KindAutoScalingMetric', 'KindResource'
	Kind KindBasicAutoScalingMetric `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingMetric(body []byte) (BasicAutoScalingMetric, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindResource):
		var asrm AutoScalingResourceMetric
		err := json.Unmarshal(body, &asrm)
		return asrm, err
	default:
		var asm AutoScalingMetric
		err := json.Unmarshal(body, &asm)
		return asm, err
	}
}
func unmarshalBasicAutoScalingMetricArray(body []byte) ([]BasicAutoScalingMetric, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asmArray := make([]BasicAutoScalingMetric, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asm, err := unmarshalBasicAutoScalingMetric(*rawMessage)
		if err != nil {
			return nil, err
		}
		asmArray[index] = asm
	}
	return asmArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingMetric.
func (asm AutoScalingMetric) MarshalJSON() ([]byte, error) {
	asm.Kind = KindAutoScalingMetric
	objectMap := make(map[string]interface{})
	if asm.Kind != "" {
		objectMap["kind"] = asm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAutoScalingResourceMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool) {
	return nil, false
}

// AsAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsAutoScalingMetric() (*AutoScalingMetric, bool) {
	return &asm, true
}

// AsBasicAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingMetric.
func (asm AutoScalingMetric) AsBasicAutoScalingMetric() (BasicAutoScalingMetric, bool) {
	return &asm, true
}

// AutoScalingPolicy describes the auto scaling policy
type AutoScalingPolicy struct {
	// Name - The name of the auto scaling policy.
	Name *string `json:"name,omitempty"`
	// Trigger - Determines when auto scaling operation will be invoked.
	Trigger BasicAutoScalingTrigger `json:"trigger,omitempty"`
	// Mechanism - The mechanism that is used to scale when auto scaling operation is invoked.
	Mechanism BasicAutoScalingMechanism `json:"mechanism,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutoScalingPolicy struct.
func (asp *AutoScalingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asp.Name = &name
			}
		case "trigger":
			if v != nil {
				trigger, err := unmarshalBasicAutoScalingTrigger(*v)
				if err != nil {
					return err
				}
				asp.Trigger = trigger
			}
		case "mechanism":
			if v != nil {
				mechanism, err := unmarshalBasicAutoScalingMechanism(*v)
				if err != nil {
					return err
				}
				asp.Mechanism = mechanism
			}
		}
	}

	return nil
}

// AutoScalingResourceMetric describes the resource that is used for triggering auto scaling.
type AutoScalingResourceMetric struct {
	// Name - Name of the resource. Possible values include: 'CPU', 'MemoryInGB'
	Name AutoScalingResourceMetricName `json:"name,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingMetric', 'KindResource'
	Kind KindBasicAutoScalingMetric `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) MarshalJSON() ([]byte, error) {
	asrm.Kind = KindResource
	objectMap := make(map[string]interface{})
	if asrm.Name != "" {
		objectMap["name"] = asrm.Name
	}
	if asrm.Kind != "" {
		objectMap["kind"] = asrm.Kind
	}
	return json.Marshal(objectMap)
}

// AsAutoScalingResourceMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsAutoScalingResourceMetric() (*AutoScalingResourceMetric, bool) {
	return &asrm, true
}

// AsAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsAutoScalingMetric() (*AutoScalingMetric, bool) {
	return nil, false
}

// AsBasicAutoScalingMetric is the BasicAutoScalingMetric implementation for AutoScalingResourceMetric.
func (asrm AutoScalingResourceMetric) AsBasicAutoScalingMetric() (BasicAutoScalingMetric, bool) {
	return &asrm, true
}

// BasicAutoScalingTrigger describes the trigger for performing auto scaling operation.
type BasicAutoScalingTrigger interface {
	AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool)
	AsAutoScalingTrigger() (*AutoScalingTrigger, bool)
}

// AutoScalingTrigger describes the trigger for performing auto scaling operation.
type AutoScalingTrigger struct {
	// Kind - Possible values include: 'KindAutoScalingTrigger', 'KindAverageLoad'
	Kind KindBasicAutoScalingTrigger `json:"kind,omitempty"`
}

func unmarshalBasicAutoScalingTrigger(body []byte) (BasicAutoScalingTrigger, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAverageLoad):
		var alst AverageLoadScalingTrigger
		err := json.Unmarshal(body, &alst)
		return alst, err
	default:
		var astVar AutoScalingTrigger
		err := json.Unmarshal(body, &astVar)
		return astVar, err
	}
}
func unmarshalBasicAutoScalingTriggerArray(body []byte) ([]BasicAutoScalingTrigger, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	astVarArray := make([]BasicAutoScalingTrigger, len(rawMessages))

	for index, rawMessage := range rawMessages {
		astVar, err := unmarshalBasicAutoScalingTrigger(*rawMessage)
		if err != nil {
			return nil, err
		}
		astVarArray[index] = astVar
	}
	return astVarArray, nil
}

// MarshalJSON is the custom marshaler for AutoScalingTrigger.
func (astVar AutoScalingTrigger) MarshalJSON() ([]byte, error) {
	astVar.Kind = KindAutoScalingTrigger
	objectMap := make(map[string]interface{})
	if astVar.Kind != "" {
		objectMap["kind"] = astVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAverageLoadScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool) {
	return nil, false
}

// AsAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsAutoScalingTrigger() (*AutoScalingTrigger, bool) {
	return &astVar, true
}

// AsBasicAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AutoScalingTrigger.
func (astVar AutoScalingTrigger) AsBasicAutoScalingTrigger() (BasicAutoScalingTrigger, bool) {
	return &astVar, true
}

// AverageLoadScalingTrigger describes the average load trigger used for auto scaling.
type AverageLoadScalingTrigger struct {
	// Metric - Description of the metric that is used for scaling.
	Metric BasicAutoScalingMetric `json:"metric,omitempty"`
	// LowerLoadThreshold - Lower load threshold (if average load is below this threshold, service will scale down).
	LowerLoadThreshold *float64 `json:"lowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - Upper load threshold (if average load is above this threshold, service will scale up).
	UpperLoadThreshold *float64 `json:"upperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - Scale interval that indicates how often will this trigger be checked.
	ScaleIntervalInSeconds *int32 `json:"scaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindAutoScalingTrigger', 'KindAverageLoad'
	Kind KindBasicAutoScalingTrigger `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	alst.Kind = KindAverageLoad
	objectMap := make(map[string]interface{})
	objectMap["metric"] = alst.Metric
	if alst.LowerLoadThreshold != nil {
		objectMap["lowerLoadThreshold"] = alst.LowerLoadThreshold
	}
	if alst.UpperLoadThreshold != nil {
		objectMap["upperLoadThreshold"] = alst.UpperLoadThreshold
	}
	if alst.ScaleIntervalInSeconds != nil {
		objectMap["scaleIntervalInSeconds"] = alst.ScaleIntervalInSeconds
	}
	if alst.Kind != "" {
		objectMap["kind"] = alst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAverageLoadScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsAverageLoadScalingTrigger() (*AverageLoadScalingTrigger, bool) {
	return &alst, true
}

// AsAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsAutoScalingTrigger() (*AutoScalingTrigger, bool) {
	return nil, false
}

// AsBasicAutoScalingTrigger is the BasicAutoScalingTrigger implementation for AverageLoadScalingTrigger.
func (alst AverageLoadScalingTrigger) AsBasicAutoScalingTrigger() (BasicAutoScalingTrigger, bool) {
	return &alst, true
}

// UnmarshalJSON is the custom unmarshaler for AverageLoadScalingTrigger struct.
func (alst *AverageLoadScalingTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "metric":
			if v != nil {
				metric, err := unmarshalBasicAutoScalingMetric(*v)
				if err != nil {
					return err
				}
				alst.Metric = metric
			}
		case "lowerLoadThreshold":
			if v != nil {
				var lowerLoadThreshold float64
				err = json.Unmarshal(*v, &lowerLoadThreshold)
				if err != nil {
					return err
				}
				alst.LowerLoadThreshold = &lowerLoadThreshold
			}
		case "upperLoadThreshold":
			if v != nil {
				var upperLoadThreshold float64
				err = json.Unmarshal(*v, &upperLoadThreshold)
				if err != nil {
					return err
				}
				alst.UpperLoadThreshold = &upperLoadThreshold
			}
		case "scaleIntervalInSeconds":
			if v != nil {
				var scaleIntervalInSeconds int32
				err = json.Unmarshal(*v, &scaleIntervalInSeconds)
				if err != nil {
					return err
				}
				alst.ScaleIntervalInSeconds = &scaleIntervalInSeconds
			}
		case "kind":
			if v != nil {
				var kind KindBasicAutoScalingTrigger
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				alst.Kind = kind
			}
		}
	}

	return nil
}

// AveragePartitionLoadScalingTrigger represents a scaling trigger related to an average load of a
// metric/resource of a partition.
type AveragePartitionLoadScalingTrigger struct {
	// MetricName - The name of the metric for which usage should be tracked.
	MetricName *string `json:"MetricName,omitempty"`
	// LowerLoadThreshold - The lower limit of the load below which a scale in operation should be performed.
	LowerLoadThreshold *string `json:"LowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - The upper limit of the load beyond which a scale out operation should be performed.
	UpperLoadThreshold *string `json:"UpperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - The period in seconds on which a decision is made whether to scale or not.
	ScaleIntervalInSeconds *int64 `json:"ScaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindScalingTriggerDescription', 'KindAveragePartitionLoad', 'KindAverageServiceLoad'
	Kind KindBasicScalingTriggerDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	aplst.Kind = KindAveragePartitionLoad
	objectMap := make(map[string]interface{})
	if aplst.MetricName != nil {
		objectMap["MetricName"] = aplst.MetricName
	}
	if aplst.LowerLoadThreshold != nil {
		objectMap["LowerLoadThreshold"] = aplst.LowerLoadThreshold
	}
	if aplst.UpperLoadThreshold != nil {
		objectMap["UpperLoadThreshold"] = aplst.UpperLoadThreshold
	}
	if aplst.ScaleIntervalInSeconds != nil {
		objectMap["ScaleIntervalInSeconds"] = aplst.ScaleIntervalInSeconds
	}
	if aplst.Kind != "" {
		objectMap["Kind"] = aplst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAveragePartitionLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsAveragePartitionLoadScalingTrigger() (*AveragePartitionLoadScalingTrigger, bool) {
	return &aplst, true
}

// AsAverageServiceLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsAverageServiceLoadScalingTrigger() (*AverageServiceLoadScalingTrigger, bool) {
	return nil, false
}

// AsScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsScalingTriggerDescription() (*ScalingTriggerDescription, bool) {
	return nil, false
}

// AsBasicScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AveragePartitionLoadScalingTrigger.
func (aplst AveragePartitionLoadScalingTrigger) AsBasicScalingTriggerDescription() (BasicScalingTriggerDescription, bool) {
	return &aplst, true
}

// AverageServiceLoadScalingTrigger represents a scaling policy related to an average load of a
// metric/resource of a service.
type AverageServiceLoadScalingTrigger struct {
	// MetricName - The name of the metric for which usage should be tracked.
	MetricName *string `json:"MetricName,omitempty"`
	// LowerLoadThreshold - The lower limit of the load below which a scale in operation should be performed.
	LowerLoadThreshold *string `json:"LowerLoadThreshold,omitempty"`
	// UpperLoadThreshold - The upper limit of the load beyond which a scale out operation should be performed.
	UpperLoadThreshold *string `json:"UpperLoadThreshold,omitempty"`
	// ScaleIntervalInSeconds - The period in seconds on which a decision is made whether to scale or not.
	ScaleIntervalInSeconds *int64 `json:"ScaleIntervalInSeconds,omitempty"`
	// Kind - Possible values include: 'KindScalingTriggerDescription', 'KindAveragePartitionLoad', 'KindAverageServiceLoad'
	Kind KindBasicScalingTriggerDescription `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) MarshalJSON() ([]byte, error) {
	aslst.Kind = KindAverageServiceLoad
	objectMap := make(map[string]interface{})
	if aslst.MetricName != nil {
		objectMap["MetricName"] = aslst.MetricName
	}
	if aslst.LowerLoadThreshold != nil {
		objectMap["LowerLoadThreshold"] = aslst.LowerLoadThreshold
	}
	if aslst.UpperLoadThreshold != nil {
		objectMap["UpperLoadThreshold"] = aslst.UpperLoadThreshold
	}
	if aslst.ScaleIntervalInSeconds != nil {
		objectMap["ScaleIntervalInSeconds"] = aslst.ScaleIntervalInSeconds
	}
	if aslst.Kind != "" {
		objectMap["Kind"] = aslst.Kind
	}
	return json.Marshal(objectMap)
}

// AsAveragePartitionLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsAveragePartitionLoadScalingTrigger() (*AveragePartitionLoadScalingTrigger, bool) {
	return nil, false
}

// AsAverageServiceLoadScalingTrigger is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsAverageServiceLoadScalingTrigger() (*AverageServiceLoadScalingTrigger, bool) {
	return &aslst, true
}

// AsScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsScalingTriggerDescription() (*ScalingTriggerDescription, bool) {
	return nil, false
}

// AsBasicScalingTriggerDescription is the BasicScalingTriggerDescription implementation for AverageServiceLoadScalingTrigger.
func (aslst AverageServiceLoadScalingTrigger) AsBasicScalingTriggerDescription() (BasicScalingTriggerDescription, bool) {
	return &aslst, true
}

// AzureBlobBackupStorageDescription describes the parameters for Azure blob store used for storing and
// enumerating backups.
type AzureBlobBackupStorageDescription struct {
	// ConnectionString - The connection string to connect to the Azure blob store.
	ConnectionString *string `json:"ConnectionString,omitempty"`
	// ContainerName - The name of the container in the blob store to store and enumerate backups from.
	ContainerName *string `json:"ContainerName,omitempty"`
	// FriendlyName - Friendly name for this backup storage.
	FriendlyName *string `json:"FriendlyName,omitempty"`
	// StorageKind - Possible values include: 'StorageKindBackupStorageDescription', 'StorageKindAzureBlobStore', 'StorageKindFileShare'
	StorageKind StorageKind `json:"StorageKind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) MarshalJSON() ([]byte, error) {
	abbsd.StorageKind = StorageKindAzureBlobStore
	objectMap := make(map[string]interface{})
	if abbsd.ConnectionString != nil {
		objectMap["ConnectionString"] = abbsd.ConnectionString
	}
	if abbsd.ContainerName != nil {
		objectMap["ContainerName"] = abbsd.ContainerName
	}
	if abbsd.FriendlyName != nil {
		objectMap["FriendlyName"] = abbsd.FriendlyName
	}
	if abbsd.StorageKind != "" {
		objectMap["StorageKind"] = abbsd.StorageKind
	}
	return json.Marshal(objectMap)
}

// AsAzureBlobBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool) {
	return &abbsd, true
}

// AsFileShareBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool) {
	return nil, false
}

// AsBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsBackupStorageDescription() (*BackupStorageDescription, bool) {
	return nil, false
}

// AsBasicBackupStorageDescription is the BasicBackupStorageDescription implementation for AzureBlobBackupStorageDescription.
func (abbsd AzureBlobBackupStorageDescription) AsBasicBackupStorageDescription() (BasicBackupStorageDescription, bool) {
	return &abbsd, true
}

// AzureInternalMonitoringPipelineSinkDescription diagnostics settings for Geneva.
type AzureInternalMonitoringPipelineSinkDescription struct {
	// AccountName - Azure Internal monitoring pipeline account.
	AccountName *string `json:"accountName,omitempty"`
	// Namespace - Azure Internal monitoring pipeline account namespace.
	Namespace *string `json:"namespace,omitempty"`
	// MaConfigURL - Azure Internal monitoring agent configuration.
	MaConfigURL *string `json:"maConfigUrl,omitempty"`
	// FluentdConfigURL - Azure Internal monitoring agent fluentd configuration.
	FluentdConfigURL interface{} `json:"fluentdConfigUrl,omitempty"`
	// AutoKeyConfigURL - Azure Internal monitoring pipeline autokey associated with the certificate.
	AutoKeyConfigURL *string `json:"autoKeyConfigUrl,omitempty"`
	// Name - Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string `json:"name,omitempty"`
	// Description - A description of the sink.
	Description *string `json:"description,omitempty"`
	// Kind - Possible values include: 'KindDiagnosticsSinkProperties', 'KindAzureInternalMonitoringPipeline'
	Kind KindBasicDiagnosticsSinkProperties `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) MarshalJSON() ([]byte, error) {
	aimpsd.Kind = KindAzureInternalMonitoringPipeline
	objectMap := make(map[string]interface{})
	if aimpsd.AccountName != nil {
		objectMap["accountName"] = aimpsd.AccountName
	}
	if aimpsd.Namespace != nil {
		objectMap["namespace"] = aimpsd.Namespace
	}
	if aimpsd.MaConfigURL != nil {
		objectMap["maConfigUrl"] = aimpsd.MaConfigURL
	}
	if aimpsd.FluentdConfigURL != nil {
		objectMap["fluentdConfigUrl"] = aimpsd.FluentdConfigURL
	}
	if aimpsd.AutoKeyConfigURL != nil {
		objectMap["autoKeyConfigUrl"] = aimpsd.AutoKeyConfigURL
	}
	if aimpsd.Name != nil {
		objectMap["name"] = aimpsd.Name
	}
	if aimpsd.Description != nil {
		objectMap["description"] = aimpsd.Description
	}
	if aimpsd.Kind != "" {
		objectMap["kind"] = aimpsd.Kind
	}
	return json.Marshal(objectMap)
}

// AsAzureInternalMonitoringPipelineSinkDescription is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsAzureInternalMonitoringPipelineSinkDescription() (*AzureInternalMonitoringPipelineSinkDescription, bool) {
	return &aimpsd, true
}

// AsDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsDiagnosticsSinkProperties() (*DiagnosticsSinkProperties, bool) {
	return nil, false
}

// AsBasicDiagnosticsSinkProperties is the BasicDiagnosticsSinkProperties implementation for AzureInternalMonitoringPipelineSinkDescription.
func (aimpsd AzureInternalMonitoringPipelineSinkDescription) AsBasicDiagnosticsSinkProperties() (BasicDiagnosticsSinkProperties, bool) {
	return &aimpsd, true
}

// BasicBackupConfigurationInfo describes the backup configuration information.
type BasicBackupConfigurationInfo interface {
	AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool)
	AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool)
	AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool)
	AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool)
}

// BackupConfigurationInfo describes the backup configuration information.
type BackupConfigurationInfo struct {
	// PolicyName - The name of the backup policy which is applicable to this Service Fabric application or service or partition.
	PolicyName *string `json:"PolicyName,omitempty"`
	// PolicyInheritedFrom - Specifies the scope at which the backup policy is applied. Possible values include: 'BackupPolicyScopeInvalid', 'BackupPolicyScopePartition', 'BackupPolicyScopeService', 'BackupPolicyScopeApplication'
	PolicyInheritedFrom BackupPolicyScope `json:"PolicyInheritedFrom,omitempty"`
	// SuspensionInfo - Describes the backup suspension details.
	SuspensionInfo *BackupSuspensionInfo `json:"SuspensionInfo,omitempty"`
	// Kind - Possible values include: 'KindBasicBackupConfigurationInfoKindBackupConfigurationInfo', 'KindBasicBackupConfigurationInfoKindApplication', 'KindBasicBackupConfigurationInfoKindService', 'KindBasicBackupConfigurationInfoKindPartition'
	Kind KindBasicBackupConfigurationInfo `json:"Kind,omitempty"`
}

func unmarshalBasicBackupConfigurationInfo(body []byte) (BasicBackupConfigurationInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindBasicBackupConfigurationInfoKindApplication):
		var abci ApplicationBackupConfigurationInfo
		err := json.Unmarshal(body, &abci)
		return abci, err
	case string(KindBasicBackupConfigurationInfoKindService):
		var sbci ServiceBackupConfigurationInfo
		err := json.Unmarshal(body, &sbci)
		return sbci, err
	case string(KindBasicBackupConfigurationInfoKindPartition):
		var pbci PartitionBackupConfigurationInfo
		err := json.Unmarshal(body, &pbci)
		return pbci, err
	default:
		var bci BackupConfigurationInfo
		err := json.Unmarshal(body, &bci)
		return bci, err
	}
}
func unmarshalBasicBackupConfigurationInfoArray(body []byte) ([]BasicBackupConfigurationInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bciArray := make([]BasicBackupConfigurationInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bci, err := unmarshalBasicBackupConfigurationInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		bciArray[index] = bci
	}
	return bciArray, nil
}

// MarshalJSON is the custom marshaler for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) MarshalJSON() ([]byte, error) {
	bci.Kind = KindBasicBackupConfigurationInfoKindBackupConfigurationInfo
	objectMap := make(map[string]interface{})
	if bci.PolicyName != nil {
		objectMap["PolicyName"] = bci.PolicyName
	}
	if bci.PolicyInheritedFrom != "" {
		objectMap["PolicyInheritedFrom"] = bci.PolicyInheritedFrom
	}
	if bci.SuspensionInfo != nil {
		objectMap["SuspensionInfo"] = bci.SuspensionInfo
	}
	if bci.Kind != "" {
		objectMap["Kind"] = bci.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsApplicationBackupConfigurationInfo() (*ApplicationBackupConfigurationInfo, bool) {
	return nil, false
}

// AsServiceBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsServiceBackupConfigurationInfo() (*ServiceBackupConfigurationInfo, bool) {
	return nil, false
}

// AsPartitionBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsPartitionBackupConfigurationInfo() (*PartitionBackupConfigurationInfo, bool) {
	return nil, false
}

// AsBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsBackupConfigurationInfo() (*BackupConfigurationInfo, bool) {
	return &bci, true
}

// AsBasicBackupConfigurationInfo is the BasicBackupConfigurationInfo implementation for BackupConfigurationInfo.
func (bci BackupConfigurationInfo) AsBasicBackupConfigurationInfo() (BasicBackupConfigurationInfo, bool) {
	return &bci, true
}

// BasicBackupEntity describes the Service Fabric entity that is configured for backup.
type BasicBackupEntity interface {
	AsApplicationBackupEntity() (*ApplicationBackupEntity, bool)
	AsServiceBackupEntity() (*ServiceBackupEntity, bool)
	AsPartitionBackupEntity() (*PartitionBackupEntity, bool)
	AsBackupEntity() (*BackupEntity, bool)
}

// BackupEntity describes the Service Fabric entity that is configured for backup.
type BackupEntity struct {
	// EntityKind - Possible values include: 'EntityKindBackupEntity', 'EntityKindApplication1', 'EntityKindService1', 'EntityKindPartition1'
	EntityKind EntityKindBasicBackupEntity `json:"EntityKind,omitempty"`
}

func unmarshalBasicBackupEntity(body []byte) (BasicBackupEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["EntityKind"] {
	case string(EntityKindApplication1):
		var abe ApplicationBackupEntity
		err := json.Unmarshal(body, &abe)
		return abe, err
	case string(EntityKindService1):
		var sbe ServiceBackupEntity
		err := json.Unmarshal(body, &sbe)
		return sbe, err
	case string(EntityKindPartition1):
		var pbe PartitionBackupEntity
		err := json.Unmarshal(body, &pbe)
		return pbe, err
	default:
		var be BackupEntity
		err := json.Unmarshal(body, &be)
		return be, err
	}
}
func unmarshalBasicBackupEntityArray(body []byte) ([]BasicBackupEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	beArray := make([]BasicBackupEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		be, err := unmarshalBasicBackupEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		beArray[index] = be
	}
	return beArray, nil
}

// MarshalJSON is the custom marshaler for BackupEntity.
func (be BackupEntity) MarshalJSON() ([]byte, error) {
	be.EntityKind = EntityKindBackupEntity
	objectMap := make(map[string]interface{})
	if be.EntityKind != "" {
		objectMap["EntityKind"] = be.EntityKind
	}
	return json.Marshal(objectMap)
}

// AsApplicationBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsApplicationBackupEntity() (*ApplicationBackupEntity, bool) {
	return nil, false
}

// AsServiceBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsServiceBackupEntity() (*ServiceBackupEntity, bool) {
	return nil, false
}

// AsPartitionBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsPartitionBackupEntity() (*PartitionBackupEntity, bool) {
	return nil, false
}

// AsBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsBackupEntity() (*BackupEntity, bool) {
	return &be, true
}

// AsBasicBackupEntity is the BasicBackupEntity implementation for BackupEntity.
func (be BackupEntity) AsBasicBackupEntity() (BasicBackupEntity, bool) {
	return &be, true
}

// BackupInfo represents a backup point which can be used to trigger a restore.
type BackupInfo struct {
	// BackupID - Unique backup ID .
	BackupID *uuid.UUID `json:"BackupId,omitempty"`
	// BackupChainID - Unique backup chain ID. All backups part of the same chain has the same backup chain id. A backup chain is comprised of 1 full backup and multiple incremental backups.
	BackupChainID *uuid.UUID `json:"BackupChainId,omitempty"`
	// ApplicationName - Name of the Service Fabric application this partition backup belongs to.
	ApplicationName *string `json:"ApplicationName,omitempty"`
	// ServiceName - Name of the Service Fabric service this partition backup belongs to.
	ServiceName *string `json:"ServiceName,omitempty"`
	// PartitionInformation - Information about the partition to which this backup belongs to
	PartitionInformation BasicPartitionInformation `json:"PartitionInformation,omitempty"`
	// BackupLocation - Location of the backup, relative to the backup store.
	BackupLocation *string `json:"BackupLocation,omitempty"`
	// BackupType - Describes the type of backup, whether its full or incremental. Possible values include: 'BackupTypeInvalid', 'BackupTypeFull', 'BackupTypeIncremental'
	BackupType BackupType `json:"BackupType,omitempty"`
	// EpochOfLastBackupRecord - Epoch of the last record in this backup.
	EpochOfLastBackupRecord *Epoch `json:"EpochOfLastBackupRecord,omitempty"`
	// LsnOfLastBackupRecord - LSN of the last record in this backup.
	LsnOfLastBackupRecord *string `json:"LsnOfLastBackupRecord,omitempty"`
	// CreationTimeUtc - The date time when this backup was taken.
	CreationTimeUtc *date.Time `json:"CreationTimeUtc,omitempty"`
	// ServiceManifestVersion - Manifest Version of the service this partition backup belongs to.
	ServiceManifestVersion *string `json:"ServiceManifestVersion,omitempty"`
	// FailureError - Denotes the failure encountered in getting backup point information.
	FailureError *FabricErrorError `json:"FailureError,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupInfo struct.
func (bi *BackupInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "BackupId":
			if v != nil {
				var backupID uuid.UUID
				err = json.Unmarshal(*v, &backupID)
				if err != nil {
					return err
				}
				bi.BackupID = &backupID
			}
		case "BackupChainId":
			if v != nil {
				var backupChainID uuid.UUID
				err = json.Unmarshal(*v, &backupChainID)
				if err != nil {
					return err
				}
				bi.BackupChainID = &backupChainID
			}
		case "ApplicationName":
			if v != nil {
				var applicationName string
				err = json.Unmarshal(*v, &applicationName)
				if err != nil {
					return err
				}
				bi.ApplicationName = &applicationName
			}
		case "ServiceName":
			if v != nil {
				var serviceName string
				err = json.Unmarshal(*v, &serviceName)
				if err != nil {
					return err
				}
				bi.ServiceName = &serviceName
			}
		case "PartitionInformation":
			if v != nil {
				partitionInformation, err := unmarshalBasicPartitionInformation(*v)
				if err != nil {
					return err
				}
				bi.PartitionInformation = partitionInformation
			}
		case "BackupLocation":
			if v != nil {
				var backupLocation string
				err = json.Unmarshal(*v, &backupLocation)
				if err != nil {
					return err
				}
				bi.BackupLocation = &backupLocation
			}
		case "BackupType":
			if v != nil {
				var backupType BackupType
				err = json.Unmarshal(*v, &backupType)
				if err != nil {
					return err
				}
				bi.BackupType = backupType
			}
		case "EpochOfLastBackupRecord":
			if v != nil {
				var epochOfLastBackupRecord Epoch
				err = json.Unmarshal(*v, &epochOfLastBackupRecord)
				if err != nil {
					return err
				}
				bi.EpochOfLastBackupRecord = &epochOfLastBackupRecord
			}
		case "LsnOfLastBackupRecord":
			if v != nil {
				var lsnOfLastBackupRecord string
				err = json.Unmarshal(*v, &lsnOfLastBackupRecord)
				if err != nil {
					return err
				}
				bi.LsnOfLastBackupRecord = &lsnOfLastBackupRecord
			}
		case "CreationTimeUtc":
			if v != nil {
				var creationTimeUtc date.Time
				err = json.Unmarshal(*v, &creationTimeUtc)
				if err != nil {
					return err
				}
				bi.CreationTimeUtc = &creationTimeUtc
			}
		case "ServiceManifestVersion":
			if v != nil {
				var serviceManifestVersion string
				err = json.Unmarshal(*v, &serviceManifestVersion)
				if err != nil {
					return err
				}
				bi.ServiceManifestVersion = &serviceManifestVersion
			}
		case "FailureError":
			if v != nil {
				var failureError FabricErrorError
				err = json.Unmarshal(*v, &failureError)
				if err != nil {
					return err
				}
				bi.FailureError = &failureError
			}
		}
	}

	return nil
}

// BackupPartitionDescription describes the parameters for triggering partition's backup.
type BackupPartitionDescription struct {
	// BackupStorage - Specifies the details of the backup storage where to save the backup.
	BackupStorage BasicBackupStorageDescription `json:"BackupStorage,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupPartitionDescription struct.
func (bpd *BackupPartitionDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "BackupStorage":
			if v != nil {
				backupStorage, err := unmarshalBasicBackupStorageDescription(*v)
				if err != nil {
					return err
				}
				bpd.BackupStorage = backupStorage
			}
		}
	}

	return nil
}

// BackupPolicyDescription describes a backup policy for configuring periodic backup.
type BackupPolicyDescription struct {
	autorest.Response `json:"-"`
	// Name - The unique name identifying this backup policy.
	Name *string `json:"Name,omitempty"`
	// AutoRestoreOnDataLoss - Specifies whether to trigger restore automatically using the latest available backup in case the partition experiences a data loss event.
	AutoRestoreOnDataLoss *bool `json:"AutoRestoreOnDataLoss,omitempty"`
	// MaxIncrementalBackups - Defines the maximum number of incremental backups to be taken between two full backups. This is just the upper limit. A full backup may be taken before specified number of incremental backups are completed in one of the following conditions
	// - The replica has never taken a full backup since it has become primary,
	// - Some of the log records since the last backup has been truncated, or
	// - Replica passed the MaxAccumulatedBackupLogSizeInMB limit.
	MaxIncrementalBackups *int32 `json:"MaxIncrementalBackups,omitempty"`
	// Schedule - Describes the backup schedule parameters.
	Schedule BasicBackupScheduleDescription `json:"Schedule,omitempty"`
	// Storage - Describes the details of backup storage where to store the periodic backups.
	Storage BasicBackupStorageDescription `json:"Storage,omitempty"`
	// RetentionPolicy - Describes the policy to retain backups in storage.
	RetentionPolicy BasicBasicRetentionPolicyDescription `json:"RetentionPolicy,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BackupPolicyDescription struct.
func (bpd *BackupPolicyDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bpd.Name = &name
			}
		case "AutoRestoreOnDataLoss":
			if v != nil {
				var autoRestoreOnDataLoss bool
				err = json.Unmarshal(*v, &autoRestoreOnDataLoss)
				if err != nil {
					return err
				}
				bpd.AutoRestoreOnDataLoss = &autoRestoreOnDataLoss
			}
		case "MaxIncrementalBackups":
			if v != nil {
				var maxIncrementalBackups int32
				err = json.Unmarshal(*v, &maxIncrementalBackups)
				if err != nil {
					return err
				}
				bpd.MaxIncrementalBackups = &maxIncrementalBackups
			}
		case "Schedule":
			if v != nil {
				schedule, err := unmarshalBasicBackupScheduleDescription(*v)
				if err != nil {
					return err
				}
				bpd.Schedule = schedule
			}
		case "Storage":
			if v != nil {
				storage, err := unmarshalBasicBackupStorageDescription(*v)
				if err != nil {
					return err
				}
				bpd.Storage = storage
			}
		case "RetentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicBasicRetentionPolicyDescription(*v)
				if err != nil {
					return err
				}
				bpd.RetentionPolicy = retentionPolicy
			}
		}
	}

	return nil
}

// BackupProgressInfo describes the progress of a partition's backup.
type BackupProgressInfo struct {
	autorest.Response `json:"-"`
	// BackupState - Represents the current state of the partition backup operation. Possible values include: 'BackupStateInvalid', 'BackupStateAccepted', 'BackupStateBackupInProgress', 'BackupStateSuccess', 'BackupStateFailure', 'BackupStateTimeout'
	BackupState BackupState `json:"BackupState,omitempty"`
	// TimeStampUtc - TimeStamp in UTC when operation succeeded or failed.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// BackupID - Unique ID of the newly created backup.
	BackupID *uuid.UUID `json:"BackupId,omitempty"`
	// BackupLocation - Location, relative to the backup store, of the newly created backup.
	BackupLocation *string `json:"BackupLocation,omitempty"`
	// EpochOfLastBackupRecord - Specifies the epoch of the last record included in backup.
	EpochOfLastBackupRecord *Epoch `json:"EpochOfLastBackupRecord,omitempty"`
	// LsnOfLastBackupRecord - The LSN of last record included in backup.
	LsnOfLastBackupRecord *string `json:"LsnOfLastBackupRecord,omitempty"`
	// FailureError - Denotes the failure encountered in performing backup operation.
	FailureError *FabricErrorError `json:"FailureError,omitempty"`
}

// BasicBackupScheduleDescription describes the backup schedule parameters.
type BasicBackupScheduleDescription interface {
	AsFrequencyBasedBackupScheduleDescription() (*FrequencyBasedBackupScheduleDescription, bool)
	AsTimeBasedBackupScheduleDescription() (*TimeBasedBackupScheduleDescription, bool)
	AsBackupScheduleDescription() (*BackupScheduleDescription, bool)
}

// BackupScheduleDescription describes the backup schedule parameters.
type BackupScheduleDescription struct {
	// ScheduleKind - Possible values include: 'ScheduleKindBackupScheduleDescription', 'ScheduleKindFrequencyBased', 'ScheduleKindTimeBased'
	ScheduleKind ScheduleKind `json:"ScheduleKind,omitempty"`
}

func unmarshalBasicBackupScheduleDescription(body []byte) (BasicBackupScheduleDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ScheduleKind"] {
	case string(ScheduleKindFrequencyBased):
		var fbbsd FrequencyBasedBackupScheduleDescription
		err := json.Unmarshal(body, &fbbsd)
		return fbbsd, err
	case string(ScheduleKindTimeBased):
		var tbbsd TimeBasedBackupScheduleDescription
		err := json.Unmarshal(body, &tbbsd)
		return tbbsd, err
	default:
		var bsd BackupScheduleDescription
		err := json.Unmarshal(body, &bsd)
		return bsd, err
	}
}
func unmarshalBasicBackupScheduleDescriptionArray(body []byte) ([]BasicBackupScheduleDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bsdArray := make([]BasicBackupScheduleDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bsd, err := unmarshalBasicBackupScheduleDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		bsdArray[index] = bsd
	}
	return bsdArray, nil
}

// MarshalJSON is the custom marshaler for BackupScheduleDescription.
func (bsd BackupScheduleDescription) MarshalJSON() ([]byte, error) {
	bsd.ScheduleKind = ScheduleKindBackupScheduleDescription
	objectMap := make(map[string]interface{})
	if bsd.ScheduleKind != "" {
		objectMap["ScheduleKind"] = bsd.ScheduleKind
	}
	return json.Marshal(objectMap)
}

// AsFrequencyBasedBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsFrequencyBasedBackupScheduleDescription() (*FrequencyBasedBackupScheduleDescription, bool) {
	return nil, false
}

// AsTimeBasedBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsTimeBasedBackupScheduleDescription() (*TimeBasedBackupScheduleDescription, bool) {
	return nil, false
}

// AsBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsBackupScheduleDescription() (*BackupScheduleDescription, bool) {
	return &bsd, true
}

// AsBasicBackupScheduleDescription is the BasicBackupScheduleDescription implementation for BackupScheduleDescription.
func (bsd BackupScheduleDescription) AsBasicBackupScheduleDescription() (BasicBackupScheduleDescription, bool) {
	return &bsd, true
}

// BasicBackupStorageDescription describes the parameters for the backup storage.
type BasicBackupStorageDescription interface {
	AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool)
	AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool)
	AsBackupStorageDescription() (*BackupStorageDescription, bool)
}

// BackupStorageDescription describes the parameters for the backup storage.
type BackupStorageDescription struct {
	// FriendlyName - Friendly name for this backup storage.
	FriendlyName *string `json:"FriendlyName,omitempty"`
	// StorageKind - Possible values include: 'StorageKindBackupStorageDescription', 'StorageKindAzureBlobStore', 'StorageKindFileShare'
	StorageKind StorageKind `json:"StorageKind,omitempty"`
}

func unmarshalBasicBackupStorageDescription(body []byte) (BasicBackupStorageDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["StorageKind"] {
	case string(StorageKindAzureBlobStore):
		var abbsd AzureBlobBackupStorageDescription
		err := json.Unmarshal(body, &abbsd)
		return abbsd, err
	case string(StorageKindFileShare):
		var fsbsd FileShareBackupStorageDescription
		err := json.Unmarshal(body, &fsbsd)
		return fsbsd, err
	default:
		var bsd BackupStorageDescription
		err := json.Unmarshal(body, &bsd)
		return bsd, err
	}
}
func unmarshalBasicBackupStorageDescriptionArray(body []byte) ([]BasicBackupStorageDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	bsdArray := make([]BasicBackupStorageDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		bsd, err := unmarshalBasicBackupStorageDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		bsdArray[index] = bsd
	}
	return bsdArray, nil
}

// MarshalJSON is the custom marshaler for BackupStorageDescription.
func (bsd BackupStorageDescription) MarshalJSON() ([]byte, error) {
	bsd.StorageKind = StorageKindBackupStorageDescription
	objectMap := make(map[string]interface{})
	if bsd.FriendlyName != nil {
		objectMap["FriendlyName"] = bsd.FriendlyName
	}
	if bsd.StorageKind != "" {
		objectMap["StorageKind"] = bsd.StorageKind
	}
	return json.Marshal(objectMap)
}

// AsAzureBlobBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsAzureBlobBackupStorageDescription() (*AzureBlobBackupStorageDescription, bool) {
	return nil, false
}

// AsFileShareBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsFileShareBackupStorageDescription() (*FileShareBackupStorageDescription, bool) {
	return nil, false
}

// AsBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsBackupStorageDescription() (*BackupStorageDescription, bool) {
	return &bsd, true
}

// AsBasicBackupStorageDescription is the BasicBackupStorageDescription implementation for BackupStorageDescription.
func (bsd BackupStorageDescription) AsBasicBackupStorageDescription() (BasicBackupStorageDescription, bool) {
	return &bsd, true
}

// BackupSuspensionInfo describes the backup suspension details.
type BackupSuspensionInfo struct {
	// IsSuspended - Indicates whether periodic backup is suspended at this level or not.
	IsSuspended *bool `json:"IsSuspended,omitempty"`
	// SuspensionInheritedFrom - Specifies the scope at which the backup suspension was applied. Possible values include: 'BackupSuspensionScopeInvalid', 'BackupSuspensionScopePartition', 'BackupSuspensionScopeService', 'BackupSuspensionScopeApplication'
	SuspensionInheritedFrom BackupSuspensionScope `json:"SuspensionInheritedFrom,omitempty"`
}

// BasicRetentionPolicyDescription describes basic retention policy.
type BasicRetentionPolicyDescription struct {
	// RetentionDuration - It is the minimum duration for which a backup created, will remain stored in the storage and might get deleted after that span of time. It should be specified in ISO8601 format.
	RetentionDuration *string `json:"RetentionDuration,omitempty"`
	// MinimumNumberOfBackups - It is the minimum number of backups to be retained at any point of time. If specified with a non zero value, backups will not be deleted even if the backups have gone past retention duration and have number of backups less than or equal to it.
	MinimumNumberOfBackups *int32 `json:"MinimumNumberOfBackups,omitempty"`
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicyDescription', 'RetentionPolicyTypeBasic1'
	RetentionPolicyType RetentionPolicyTypeBasicBasicRetentionPolicyDescription `json:"RetentionPolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for BasicRetentionPolicyDescription.
func (brpd BasicRetentionPolicyDescription) MarshalJSON() ([]byte, error) {
	brpd.RetentionPolicyType = RetentionPolicyTypeBasic1
	objectMap := make(map[string]interface{})
	if brpd.RetentionDuration != nil {
		objectMap["RetentionDuration"] = brpd.RetentionDuration
	}
	if brpd.MinimumNumberOfBackups != nil {
		objectMap["MinimumNumberOfBackups"] = brpd.MinimumNumberOfBackups
	}
	if brpd.RetentionPolicyType != "" {
		objectMap["RetentionPolicyType"] = brpd.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsBasicRetentionPolicyDescription is the BasicBasicRetentionPolicyDescription implementation for BasicRetentionPolicyDescription.
func (brpd BasicRetentionPolicyDescription) AsBasicRetentionPolicyDescription() (*BasicRetentionPolicyDescription, bool) {
	return &brpd, true
}

// AsRetentionPolicyDescription is the BasicBasicRetentionPolicyDescription implementation for BasicRetentionPolicyDescription.
func (brpd BasicRetentionPolicyDescription) AsRetentionPolicyDescription() (*RetentionPolicyDescription, bool) {
	return nil, false
}

// AsBasicBasicRetentionPolicyDescription is the BasicBasicRetentionPolicyDescription implementation for BasicRetentionPolicyDescription.
func (brpd BasicRetentionPolicyDescription) AsBasicBasicRetentionPolicyDescription() (BasicBasicRetentionPolicyDescription, bool) {
	return &brpd, true
}

// BinaryPropertyValue describes a Service Fabric property value of type Binary.
type BinaryPropertyValue struct {
	// Data - Array of bytes to be sent as an integer array. Each element of array is a number between 0 and 255.
	Data *[]int32 `json:"Data,omitempty"`
	// Kind - Possible values include: 'KindPropertyValue', 'KindBinary', 'KindInt64', 'KindDouble', 'KindString', 'KindGUID'
	Kind KindBasicPropertyValue `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BinaryPropertyValue.
func (bpv BinaryPropertyValue) MarshalJSON() ([]byte, error) {
	bpv.Kind = KindBinary
	objectMap := make(map[string]interface{})
	if bpv.Data != nil {
		objectMap["Data"] = bpv.Data
	}
	if bpv.Kind != "" {
		objectMap["Kind"] = bpv.Kind
	}
	return json.Marshal(objectMap)
}

// AsBinaryPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBinaryPropertyValue() (*BinaryPropertyValue, bool) {
	return &bpv, true
}

// AsInt64PropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsInt64PropertyValue() (*Int64PropertyValue, bool) {
	return nil, false
}

// AsDoublePropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsDoublePropertyValue() (*DoublePropertyValue, bool) {
	return nil, false
}

// AsStringPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsStringPropertyValue() (*StringPropertyValue, bool) {
	return nil, false
}

// AsGUIDPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsGUIDPropertyValue() (*GUIDPropertyValue, bool) {
	return nil, false
}

// AsPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsPropertyValue() (*PropertyValue, bool) {
	return nil, false
}

// AsBasicPropertyValue is the BasicPropertyValue implementation for BinaryPropertyValue.
func (bpv BinaryPropertyValue) AsBasicPropertyValue() (BasicPropertyValue, bool) {
	return &bpv, true
}

// Chaos contains a description of Chaos.
type Chaos struct {
	autorest.Response `json:"-"`
	// ChaosParameters - If Chaos is running, these are the parameters Chaos is running with.
	ChaosParameters *ChaosParameters `json:"ChaosParameters,omitempty"`
	// Status - Current status of the Chaos run. Possible values include: 'ChaosStatusInvalid', 'ChaosStatusRunning', 'ChaosStatusStopped'
	Status ChaosStatus `json:"Status,omitempty"`
	// ScheduleStatus - Current status of the schedule. Possible values include: 'ChaosScheduleStatusInvalid', 'ChaosScheduleStatusStopped', 'ChaosScheduleStatusActive', 'ChaosScheduleStatusExpired', 'ChaosScheduleStatusPending'
	ScheduleStatus ChaosScheduleStatus `json:"ScheduleStatus,omitempty"`
}

// ChaosCodePackageRestartScheduledEvent chaos Restart Code Package Fault Scheduled event.
type ChaosCodePackageRestartScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// ServiceManifestName - Service manifest name.
	ServiceManifestName *string `json:"ServiceManifestName,omitempty"`
	// CodePackageName - Code package name.
	CodePackageName *string `json:"CodePackageName,omitempty"`
	// ServicePackageActivationID - Id of Service package activation.
	ServicePackageActivationID *string `json:"ServicePackageActivationId,omitempty"`
	// ApplicationID - The identity of the application. This is an encoded representation of the application name. This is used in the REST APIs to identify the application resource.
	// Starting in version 6.0, hierarchical names are delimited with the "\~" character. For example, if the application name is "fabric:/myapp/app1",
	// the application identity would be "myapp\~app1" in 6.0+ and "myapp/app1" in previous versions.
	ApplicationID *string `json:"ApplicationId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) MarshalJSON() ([]byte, error) {
	ccprse.Kind = KindChaosCodePackageRestartScheduled
	objectMap := make(map[string]interface{})
	if ccprse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = ccprse.FaultGroupID
	}
	if ccprse.FaultID != nil {
		objectMap["FaultId"] = ccprse.FaultID
	}
	if ccprse.NodeName != nil {
		objectMap["NodeName"] = ccprse.NodeName
	}
	if ccprse.ServiceManifestName != nil {
		objectMap["ServiceManifestName"] = ccprse.ServiceManifestName
	}
	if ccprse.CodePackageName != nil {
		objectMap["CodePackageName"] = ccprse.CodePackageName
	}
	if ccprse.ServicePackageActivationID != nil {
		objectMap["ServicePackageActivationId"] = ccprse.ServicePackageActivationID
	}
	if ccprse.ApplicationID != nil {
		objectMap["ApplicationId"] = ccprse.ApplicationID
	}
	if ccprse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ccprse.EventInstanceID
	}
	if ccprse.Category != nil {
		objectMap["Category"] = ccprse.Category
	}
	if ccprse.TimeStamp != nil {
		objectMap["TimeStamp"] = ccprse.TimeStamp
	}
	if ccprse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ccprse.HasCorrelatedEvents
	}
	if ccprse.Kind != "" {
		objectMap["Kind"] = ccprse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return &ccprse, true
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return &ccprse, true
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosCodePackageRestartScheduledEvent.
func (ccprse ChaosCodePackageRestartScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ccprse, true
}

// ChaosContext describes a map, which is a collection of (string, string) type key-value pairs. The map
// can be used to record information about
// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most
// 4095 characters long.
// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
type ChaosContext struct {
	// Map - Describes a map that contains a collection of ChaosContextMapItem's.
	Map map[string]*string `json:"Map"`
}

// MarshalJSON is the custom marshaler for ChaosContext.
func (cc ChaosContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Map != nil {
		objectMap["Map"] = cc.Map
	}
	return json.Marshal(objectMap)
}

// BasicChaosEvent represents an event generated during a Chaos run.
type BasicChaosEvent interface {
	AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool)
	AsStartedChaosEvent() (*StartedChaosEvent, bool)
	AsStoppedChaosEvent() (*StoppedChaosEvent, bool)
	AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool)
	AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool)
	AsWaitingChaosEvent() (*WaitingChaosEvent, bool)
	AsChaosEvent() (*ChaosEvent, bool)
}

// ChaosEvent represents an event generated during a Chaos run.
type ChaosEvent struct {
	// TimeStampUtc - The UTC timestamp when this Chaos event was generated.
	TimeStampUtc *date.Time `json:"TimeStampUtc,omitempty"`
	// Kind - Possible values include: 'KindChaosEvent', 'KindExecutingFaults', 'KindStarted', 'KindStopped', 'KindTestError', 'KindValidationFailed', 'KindWaiting'
	Kind KindBasicChaosEvent `json:"Kind,omitempty"`
}

func unmarshalBasicChaosEvent(body []byte) (BasicChaosEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindExecutingFaults):
		var efce ExecutingFaultsChaosEvent
		err := json.Unmarshal(body, &efce)
		return efce, err
	case string(KindStarted):
		var sce StartedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindStopped):
		var sce StoppedChaosEvent
		err := json.Unmarshal(body, &sce)
		return sce, err
	case string(KindTestError):
		var tece TestErrorChaosEvent
		err := json.Unmarshal(body, &tece)
		return tece, err
	case string(KindValidationFailed):
		var vfce ValidationFailedChaosEvent
		err := json.Unmarshal(body, &vfce)
		return vfce, err
	case string(KindWaiting):
		var wce WaitingChaosEvent
		err := json.Unmarshal(body, &wce)
		return wce, err
	default:
		var ce ChaosEvent
		err := json.Unmarshal(body, &ce)
		return ce, err
	}
}
func unmarshalBasicChaosEventArray(body []byte) ([]BasicChaosEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ceArray := make([]BasicChaosEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ce, err := unmarshalBasicChaosEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		ceArray[index] = ce
	}
	return ceArray, nil
}

// MarshalJSON is the custom marshaler for ChaosEvent.
func (ce ChaosEvent) MarshalJSON() ([]byte, error) {
	ce.Kind = KindChaosEvent
	objectMap := make(map[string]interface{})
	if ce.TimeStampUtc != nil {
		objectMap["TimeStampUtc"] = ce.TimeStampUtc
	}
	if ce.Kind != "" {
		objectMap["Kind"] = ce.Kind
	}
	return json.Marshal(objectMap)
}

// AsExecutingFaultsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsExecutingFaultsChaosEvent() (*ExecutingFaultsChaosEvent, bool) {
	return nil, false
}

// AsStartedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStartedChaosEvent() (*StartedChaosEvent, bool) {
	return nil, false
}

// AsStoppedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsStoppedChaosEvent() (*StoppedChaosEvent, bool) {
	return nil, false
}

// AsTestErrorChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsTestErrorChaosEvent() (*TestErrorChaosEvent, bool) {
	return nil, false
}

// AsValidationFailedChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsValidationFailedChaosEvent() (*ValidationFailedChaosEvent, bool) {
	return nil, false
}

// AsWaitingChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsWaitingChaosEvent() (*WaitingChaosEvent, bool) {
	return nil, false
}

// AsChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsChaosEvent() (*ChaosEvent, bool) {
	return &ce, true
}

// AsBasicChaosEvent is the BasicChaosEvent implementation for ChaosEvent.
func (ce ChaosEvent) AsBasicChaosEvent() (BasicChaosEvent, bool) {
	return &ce, true
}

// ChaosEventsSegment contains the list of Chaos events and the continuation token to get the next segment.
type ChaosEventsSegment struct {
	autorest.Response `json:"-"`
	// ContinuationToken - The continuation token parameter is used to obtain next set of results. The continuation token is included in the response of the API when the results from the system do not fit in a single response. When this value is passed to the next API call, the API returns next set of results. If there are no further results, then the continuation token is not included in the response.
	ContinuationToken *string `json:"ContinuationToken,omitempty"`
	// History - List of Chaos events that meet the user-supplied criteria.
	History *[]ChaosEventWrapper `json:"History,omitempty"`
}

// ChaosEventWrapper wrapper object for Chaos event.
type ChaosEventWrapper struct {
	// ChaosEvent - Represents an event generated during a Chaos run.
	ChaosEvent BasicChaosEvent `json:"ChaosEvent,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ChaosEventWrapper struct.
func (cew *ChaosEventWrapper) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "ChaosEvent":
			if v != nil {
				chaosEvent, err := unmarshalBasicChaosEvent(*v)
				if err != nil {
					return err
				}
				cew.ChaosEvent = chaosEvent
			}
		}
	}

	return nil
}

// ChaosNodeRestartScheduledEvent chaos Restart Node Fault Scheduled event.
type ChaosNodeRestartScheduledEvent struct {
	// NodeInstanceID - Id of Node instance.
	NodeInstanceID *int64 `json:"NodeInstanceId,omitempty"`
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// NodeName - The name of a Service Fabric node.
	NodeName *string `json:"NodeName,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) MarshalJSON() ([]byte, error) {
	cnrse.Kind = KindChaosNodeRestartScheduled
	objectMap := make(map[string]interface{})
	if cnrse.NodeInstanceID != nil {
		objectMap["NodeInstanceId"] = cnrse.NodeInstanceID
	}
	if cnrse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = cnrse.FaultGroupID
	}
	if cnrse.FaultID != nil {
		objectMap["FaultId"] = cnrse.FaultID
	}
	if cnrse.NodeName != nil {
		objectMap["NodeName"] = cnrse.NodeName
	}
	if cnrse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cnrse.EventInstanceID
	}
	if cnrse.Category != nil {
		objectMap["Category"] = cnrse.Category
	}
	if cnrse.TimeStamp != nil {
		objectMap["TimeStamp"] = cnrse.TimeStamp
	}
	if cnrse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cnrse.HasCorrelatedEvents
	}
	if cnrse.Kind != "" {
		objectMap["Kind"] = cnrse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return &cnrse, true
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return &cnrse, true
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosNodeRestartScheduledEvent.
func (cnrse ChaosNodeRestartScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cnrse, true
}

// ChaosParameters defines all the parameters to configure a Chaos run.
type ChaosParameters struct {
	// TimeToRunInSeconds - Total time (in seconds) for which Chaos will run before automatically stopping. The maximum allowed value is 4,294,967,295 (System.UInt32.MaxValue).
	TimeToRunInSeconds *string `json:"TimeToRunInSeconds,omitempty"`
	// MaxClusterStabilizationTimeoutInSeconds - The maximum amount of time to wait for all cluster entities to become stable and healthy. Chaos executes in iterations and at the start of each iteration it validates the health of cluster entities.
	// During validation if a cluster entity is not stable and healthy within MaxClusterStabilizationTimeoutInSeconds, Chaos generates a validation failed event.
	MaxClusterStabilizationTimeoutInSeconds *int64 `json:"MaxClusterStabilizationTimeoutInSeconds,omitempty"`
	// MaxConcurrentFaults - MaxConcurrentFaults is the maximum number of concurrent faults induced per iteration.
	// Chaos executes in iterations and two consecutive iterations are separated by a validation phase.
	// The higher the concurrency, the more aggressive the injection of faults, leading to inducing more complex series of states to uncover bugs.
	// The recommendation is to start with a value of 2 or 3 and to exercise caution while moving up.
	MaxConcurrentFaults *int64 `json:"MaxConcurrentFaults,omitempty"`
	// EnableMoveReplicaFaults - Enables or disables the move primary and move secondary faults.
	EnableMoveReplicaFaults *bool `json:"EnableMoveReplicaFaults,omitempty"`
	// WaitTimeBetweenFaultsInSeconds - Wait time (in seconds) between consecutive faults within a single iteration.
	// The larger the value, the lower the overlapping between faults and the simpler the sequence of state transitions that the cluster goes through.
	// The recommendation is to start with a value between 1 and 5 and exercise caution while moving up.
	WaitTimeBetweenFaultsInSeconds *int64 `json:"WaitTimeBetweenFaultsInSeconds,omitempty"`
	// WaitTimeBetweenIterationsInSeconds - Time-separation (in seconds) between two consecutive iterations of Chaos.
	// The larger the value, the lower the fault injection rate.
	WaitTimeBetweenIterationsInSeconds *int64 `json:"WaitTimeBetweenIterationsInSeconds,omitempty"`
	// ClusterHealthPolicy - Passed-in cluster health policy is used to validate health of the cluster in between Chaos iterations. If the cluster health is in error or if an unexpected exception happens during fault execution--to provide the cluster with some time to recuperate--Chaos will wait for 30 minutes before the next health-check.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// Context - Describes a map, which is a collection of (string, string) type key-value pairs. The map can be used to record information about
	// the Chaos run. There cannot be more than 100 such pairs and each string (key or value) can be at most 4095 characters long.
	// This map is set by the starter of the Chaos run to optionally store the context about the specific run.
	Context *ChaosContext `json:"Context,omitempty"`
	// ChaosTargetFilter - List of cluster entities to target for Chaos faults.
	// This filter can be used to target Chaos faults only to certain node types or only to certain application instances. If ChaosTargetFilter is not used, Chaos faults all cluster entities.
	// If ChaosTargetFilter is used, Chaos faults only the entities that meet the ChaosTargetFilter specification.
	ChaosTargetFilter *ChaosTargetFilter `json:"ChaosTargetFilter,omitempty"`
}

// ChaosParametersDictionaryItem defines an item in ChaosParametersDictionary of the Chaos Schedule.
type ChaosParametersDictionaryItem struct {
	// Key - The key identifying the Chaos Parameter in the dictionary. This key is referenced by Chaos Schedule Jobs.
	Key *string `json:"Key,omitempty"`
	// Value - Defines all the parameters to configure a Chaos run.
	Value *ChaosParameters `json:"Value,omitempty"`
}

// ChaosPartitionPrimaryMoveScheduledEvent chaos Move Primary Fault Scheduled event.
type ChaosPartitionPrimaryMoveScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceName - Service name.
	ServiceName *string `json:"ServiceName,omitempty"`
	// NodeTo - The name of a Service Fabric node.
	NodeTo *string `json:"NodeTo,omitempty"`
	// ForcedMove - Indicates a forced move.
	ForcedMove *bool `json:"ForcedMove,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) MarshalJSON() ([]byte, error) {
	cppmse.Kind = KindChaosPartitionPrimaryMoveScheduled
	objectMap := make(map[string]interface{})
	if cppmse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = cppmse.FaultGroupID
	}
	if cppmse.FaultID != nil {
		objectMap["FaultId"] = cppmse.FaultID
	}
	if cppmse.ServiceName != nil {
		objectMap["ServiceName"] = cppmse.ServiceName
	}
	if cppmse.NodeTo != nil {
		objectMap["NodeTo"] = cppmse.NodeTo
	}
	if cppmse.ForcedMove != nil {
		objectMap["ForcedMove"] = cppmse.ForcedMove
	}
	if cppmse.PartitionID != nil {
		objectMap["PartitionId"] = cppmse.PartitionID
	}
	if cppmse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cppmse.EventInstanceID
	}
	if cppmse.Category != nil {
		objectMap["Category"] = cppmse.Category
	}
	if cppmse.TimeStamp != nil {
		objectMap["TimeStamp"] = cppmse.TimeStamp
	}
	if cppmse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cppmse.HasCorrelatedEvents
	}
	if cppmse.Kind != "" {
		objectMap["Kind"] = cppmse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return &cppmse, true
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return &cppmse, true
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosPartitionPrimaryMoveScheduledEvent.
func (cppmse ChaosPartitionPrimaryMoveScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cppmse, true
}

// ChaosPartitionSecondaryMoveScheduledEvent chaos Move Secondary Fault Scheduled event.
type ChaosPartitionSecondaryMoveScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceName - Service name.
	ServiceName *string `json:"ServiceName,omitempty"`
	// SourceNode - The name of a Service Fabric node.
	SourceNode *string `json:"SourceNode,omitempty"`
	// DestinationNode - The name of a Service Fabric node.
	DestinationNode *string `json:"DestinationNode,omitempty"`
	// ForcedMove - Indicates a forced move.
	ForcedMove *bool `json:"ForcedMove,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) MarshalJSON() ([]byte, error) {
	cpsmse.Kind = KindChaosPartitionSecondaryMoveScheduled
	objectMap := make(map[string]interface{})
	if cpsmse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = cpsmse.FaultGroupID
	}
	if cpsmse.FaultID != nil {
		objectMap["FaultId"] = cpsmse.FaultID
	}
	if cpsmse.ServiceName != nil {
		objectMap["ServiceName"] = cpsmse.ServiceName
	}
	if cpsmse.SourceNode != nil {
		objectMap["SourceNode"] = cpsmse.SourceNode
	}
	if cpsmse.DestinationNode != nil {
		objectMap["DestinationNode"] = cpsmse.DestinationNode
	}
	if cpsmse.ForcedMove != nil {
		objectMap["ForcedMove"] = cpsmse.ForcedMove
	}
	if cpsmse.PartitionID != nil {
		objectMap["PartitionId"] = cpsmse.PartitionID
	}
	if cpsmse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cpsmse.EventInstanceID
	}
	if cpsmse.Category != nil {
		objectMap["Category"] = cpsmse.Category
	}
	if cpsmse.TimeStamp != nil {
		objectMap["TimeStamp"] = cpsmse.TimeStamp
	}
	if cpsmse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cpsmse.HasCorrelatedEvents
	}
	if cpsmse.Kind != "" {
		objectMap["Kind"] = cpsmse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return &cpsmse, true
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return &cpsmse, true
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosPartitionSecondaryMoveScheduledEvent.
func (cpsmse ChaosPartitionSecondaryMoveScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cpsmse, true
}

// ChaosReplicaRemovalScheduledEvent chaos Remove Replica Fault Scheduled event.
type ChaosReplicaRemovalScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceURI - Service name.
	ServiceURI *string `json:"ServiceUri,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *int64 `json:"ReplicaId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) MarshalJSON() ([]byte, error) {
	crrse.Kind = KindChaosReplicaRemovalScheduled
	objectMap := make(map[string]interface{})
	if crrse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crrse.FaultGroupID
	}
	if crrse.FaultID != nil {
		objectMap["FaultId"] = crrse.FaultID
	}
	if crrse.ServiceURI != nil {
		objectMap["ServiceUri"] = crrse.ServiceURI
	}
	if crrse.PartitionID != nil {
		objectMap["PartitionId"] = crrse.PartitionID
	}
	if crrse.ReplicaID != nil {
		objectMap["ReplicaId"] = crrse.ReplicaID
	}
	if crrse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crrse.EventInstanceID
	}
	if crrse.Category != nil {
		objectMap["Category"] = crrse.Category
	}
	if crrse.TimeStamp != nil {
		objectMap["TimeStamp"] = crrse.TimeStamp
	}
	if crrse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crrse.HasCorrelatedEvents
	}
	if crrse.Kind != "" {
		objectMap["Kind"] = crrse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return &crrse, true
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return &crrse, true
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosReplicaRemovalScheduledEvent.
func (crrse ChaosReplicaRemovalScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crrse, true
}

// ChaosReplicaRestartScheduledEvent chaos Restart Replica Fault Scheduled event.
type ChaosReplicaRestartScheduledEvent struct {
	// FaultGroupID - Id of fault group.
	FaultGroupID *uuid.UUID `json:"FaultGroupId,omitempty"`
	// FaultID - Id of fault.
	FaultID *uuid.UUID `json:"FaultId,omitempty"`
	// ServiceURI - Service name.
	ServiceURI *string `json:"ServiceUri,omitempty"`
	// PartitionID - An internal ID used by Service Fabric to uniquely identify a partition. This is a randomly generated GUID when the service was created. The partition ID is unique and does not change for the lifetime of the service. If the same service was deleted and recreated the IDs of its partitions would be different.
	PartitionID *uuid.UUID `json:"PartitionId,omitempty"`
	// ReplicaID - Id of a stateful service replica. ReplicaId is used by Service Fabric to uniquely identify a replica of a partition. It is unique within a partition and does not change for the lifetime of the replica. If a replica gets dropped and another replica gets created on the same node for the same partition, it will get a different value for the id. Sometimes the id of a stateless service instance is also referred as a replica id.
	ReplicaID *int64 `json:"ReplicaId,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) MarshalJSON() ([]byte, error) {
	crrse.Kind = KindChaosReplicaRestartScheduled
	objectMap := make(map[string]interface{})
	if crrse.FaultGroupID != nil {
		objectMap["FaultGroupId"] = crrse.FaultGroupID
	}
	if crrse.FaultID != nil {
		objectMap["FaultId"] = crrse.FaultID
	}
	if crrse.ServiceURI != nil {
		objectMap["ServiceUri"] = crrse.ServiceURI
	}
	if crrse.PartitionID != nil {
		objectMap["PartitionId"] = crrse.PartitionID
	}
	if crrse.ReplicaID != nil {
		objectMap["ReplicaId"] = crrse.ReplicaID
	}
	if crrse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = crrse.EventInstanceID
	}
	if crrse.Category != nil {
		objectMap["Category"] = crrse.Category
	}
	if crrse.TimeStamp != nil {
		objectMap["TimeStamp"] = crrse.TimeStamp
	}
	if crrse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = crrse.HasCorrelatedEvents
	}
	if crrse.Kind != "" {
		objectMap["Kind"] = crrse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return nil, false
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return &crrse, true
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return &crrse, true
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosReplicaRestartScheduledEvent.
func (crrse ChaosReplicaRestartScheduledEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &crrse, true
}

// ChaosSchedule defines the schedule used by Chaos.
type ChaosSchedule struct {
	// StartDate - The date and time Chaos will start using this schedule.
	StartDate *date.Time `json:"StartDate,omitempty"`
	// ExpiryDate - The date and time Chaos will continue to use this schedule until.
	ExpiryDate *date.Time `json:"ExpiryDate,omitempty"`
	// ChaosParametersDictionary - A mapping of string names to Chaos Parameters to be referenced by Chaos Schedule Jobs.
	ChaosParametersDictionary *[]ChaosParametersDictionaryItem `json:"ChaosParametersDictionary,omitempty"`
	// Jobs - A list of all Chaos Schedule Jobs that will be automated by the schedule.
	Jobs *[]ChaosScheduleJob `json:"Jobs,omitempty"`
}

// ChaosScheduleDescription defines the Chaos Schedule used by Chaos and the version of the Chaos Schedule.
// The version value wraps back to 0 after surpassing 2,147,483,647.
type ChaosScheduleDescription struct {
	autorest.Response `json:"-"`
	// Version - The version number of the Schedule.
	Version *int32 `json:"Version,omitempty"`
	// Schedule - Defines the schedule used by Chaos.
	Schedule *ChaosSchedule `json:"Schedule,omitempty"`
}

// ChaosScheduleJob defines a repetition rule and parameters of Chaos to be used with the Chaos Schedule.
type ChaosScheduleJob struct {
	// ChaosParameters - A reference to which Chaos Parameters of the Chaos Schedule to use.
	ChaosParameters *string `json:"ChaosParameters,omitempty"`
	// Days - Defines the days of the week that a Chaos Schedule Job will run for.
	Days *ChaosScheduleJobActiveDaysOfWeek `json:"Days,omitempty"`
	// Times - A list of Time Ranges that specify when during active days that this job will run. The times are interpreted as UTC.
	Times *[]TimeRange `json:"Times,omitempty"`
}

// ChaosScheduleJobActiveDaysOfWeek defines the days of the week that a Chaos Schedule Job will run for.
type ChaosScheduleJobActiveDaysOfWeek struct {
	// Sunday - Indicates if the Chaos Schedule Job will run on Sunday
	Sunday *bool `json:"Sunday,omitempty"`
	// Monday - Indicates if the Chaos Schedule Job will run on Monday
	Monday *bool `json:"Monday,omitempty"`
	// Tuesday - Indicates if the Chaos Schedule Job will run on Tuesday
	Tuesday *bool `json:"Tuesday,omitempty"`
	// Wednesday - Indicates if the Chaos Schedule Job will run on Wednesday
	Wednesday *bool `json:"Wednesday,omitempty"`
	// Thursday - Indicates if the Chaos Schedule Job will run on Thursday
	Thursday *bool `json:"Thursday,omitempty"`
	// Friday - Indicates if the Chaos Schedule Job will run on Friday
	Friday *bool `json:"Friday,omitempty"`
	// Saturday - Indicates if the Chaos Schedule Job will run on Saturday
	Saturday *bool `json:"Saturday,omitempty"`
}

// ChaosStartedEvent chaos Started event.
type ChaosStartedEvent struct {
	// MaxConcurrentFaults - Maximum number of concurrent faults.
	MaxConcurrentFaults *int64 `json:"MaxConcurrentFaults,omitempty"`
	// TimeToRunInSeconds - Time to run in seconds.
	TimeToRunInSeconds *float64 `json:"TimeToRunInSeconds,omitempty"`
	// MaxClusterStabilizationTimeoutInSeconds - Maximum timeout for cluster stabilization in seconds.
	MaxClusterStabilizationTimeoutInSeconds *float64 `json:"MaxClusterStabilizationTimeoutInSeconds,omitempty"`
	// WaitTimeBetweenIterationsInSeconds - Wait time between iterations in seconds.
	WaitTimeBetweenIterationsInSeconds *float64 `json:"WaitTimeBetweenIterationsInSeconds,omitempty"`
	// WaitTimeBetweenFautlsInSeconds - Wait time between faults in seconds.
	WaitTimeBetweenFautlsInSeconds *float64 `json:"WaitTimeBetweenFautlsInSeconds,omitempty"`
	// MoveReplicaFaultEnabled - Indicates MoveReplica fault is enabled.
	MoveReplicaFaultEnabled *bool `json:"MoveReplicaFaultEnabled,omitempty"`
	// IncludedNodeTypeList - List of included Node types.
	IncludedNodeTypeList *string `json:"IncludedNodeTypeList,omitempty"`
	// IncludedApplicationList - List of included Applications.
	IncludedApplicationList *string `json:"IncludedApplicationList,omitempty"`
	// ClusterHealthPolicy - Health policy.
	ClusterHealthPolicy *string `json:"ClusterHealthPolicy,omitempty"`
	// ChaosContext - Chaos Context.
	ChaosContext *string `json:"ChaosContext,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosStartedEvent.
func (cse ChaosStartedEvent) MarshalJSON() ([]byte, error) {
	cse.Kind = KindChaosStarted
	objectMap := make(map[string]interface{})
	if cse.MaxConcurrentFaults != nil {
		objectMap["MaxConcurrentFaults"] = cse.MaxConcurrentFaults
	}
	if cse.TimeToRunInSeconds != nil {
		objectMap["TimeToRunInSeconds"] = cse.TimeToRunInSeconds
	}
	if cse.MaxClusterStabilizationTimeoutInSeconds != nil {
		objectMap["MaxClusterStabilizationTimeoutInSeconds"] = cse.MaxClusterStabilizationTimeoutInSeconds
	}
	if cse.WaitTimeBetweenIterationsInSeconds != nil {
		objectMap["WaitTimeBetweenIterationsInSeconds"] = cse.WaitTimeBetweenIterationsInSeconds
	}
	if cse.WaitTimeBetweenFautlsInSeconds != nil {
		objectMap["WaitTimeBetweenFautlsInSeconds"] = cse.WaitTimeBetweenFautlsInSeconds
	}
	if cse.MoveReplicaFaultEnabled != nil {
		objectMap["MoveReplicaFaultEnabled"] = cse.MoveReplicaFaultEnabled
	}
	if cse.IncludedNodeTypeList != nil {
		objectMap["IncludedNodeTypeList"] = cse.IncludedNodeTypeList
	}
	if cse.IncludedApplicationList != nil {
		objectMap["IncludedApplicationList"] = cse.IncludedApplicationList
	}
	if cse.ClusterHealthPolicy != nil {
		objectMap["ClusterHealthPolicy"] = cse.ClusterHealthPolicy
	}
	if cse.ChaosContext != nil {
		objectMap["ChaosContext"] = cse.ChaosContext
	}
	if cse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cse.EventInstanceID
	}
	if cse.Category != nil {
		objectMap["Category"] = cse.Category
	}
	if cse.TimeStamp != nil {
		objectMap["TimeStamp"] = cse.TimeStamp
	}
	if cse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cse.HasCorrelatedEvents
	}
	if cse.Kind != "" {
		objectMap["Kind"] = cse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return &cse, true
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosStartedEvent.
func (cse ChaosStartedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cse, true
}

// ChaosStoppedEvent chaos Stopped event.
type ChaosStoppedEvent struct {
	// Reason - Describes reason.
	Reason *string `json:"Reason,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) MarshalJSON() ([]byte, error) {
	cse.Kind = KindChaosStopped
	objectMap := make(map[string]interface{})
	if cse.Reason != nil {
		objectMap["Reason"] = cse.Reason
	}
	if cse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cse.EventInstanceID
	}
	if cse.Category != nil {
		objectMap["Category"] = cse.Category
	}
	if cse.TimeStamp != nil {
		objectMap["TimeStamp"] = cse.TimeStamp
	}
	if cse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cse.HasCorrelatedEvents
	}
	if cse.Kind != "" {
		objectMap["Kind"] = cse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return &cse, true
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ChaosStoppedEvent.
func (cse ChaosStoppedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cse, true
}

// ChaosTargetFilter defines all filters for targeted Chaos faults, for example, faulting only certain node
// types or faulting only certain applications.
// If ChaosTargetFilter is not used, Chaos faults all cluster entities. If ChaosTargetFilter is used, Chaos
// faults only the entities that meet the ChaosTargetFilter
// specification. NodeTypeInclusionList and ApplicationInclusionList allow a union semantics only. It is
// not possible to specify an intersection
// of NodeTypeInclusionList and ApplicationInclusionList. For example, it is not possible to specify "fault
// this application only when it is on that node type."
// Once an entity is included in either NodeTypeInclusionList or ApplicationInclusionList, that entity
// cannot be excluded using ChaosTargetFilter. Even if
// applicationX does not appear in ApplicationInclusionList, in some Chaos iteration applicationX can be
// faulted because it happens to be on a node of nodeTypeY that is included
// in NodeTypeInclusionList. If both NodeTypeInclusionList and ApplicationInclusionList are null or empty,
// an ArgumentException is thrown.
type ChaosTargetFilter struct {
	// NodeTypeInclusionList - A list of node types to include in Chaos faults.
	// All types of faults (restart node, restart code package, remove replica, restart replica, move primary, and move secondary) are enabled for the nodes of these node types.
	// If a nodetype (say NodeTypeX) does not appear in the NodeTypeInclusionList, then node level faults (like NodeRestart) will never be enabled for the nodes of
	// NodeTypeX, but code package and replica faults can still be enabled for NodeTypeX if an application in the ApplicationInclusionList.
	// happens to reside on a node of NodeTypeX.
	// At most 100 node type names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfNodeTypesInChaosEntityFilter configuration.
	NodeTypeInclusionList *[]string `json:"NodeTypeInclusionList,omitempty"`
	// ApplicationInclusionList - A list of application URI's to include in Chaos faults.
	// All replicas belonging to services of these applications are amenable to replica faults (restart replica, remove replica, move primary, and move secondary) by Chaos.
	// Chaos may restart a code package only if the code package hosts replicas of these applications only.
	// If an application does not appear in this list, it can still be faulted in some Chaos iteration if the application ends up on a node of a node type that is included in NodeTypeInclusionList.
	// However, if applicationX is tied to nodeTypeY through placement constraints and applicationX is absent from ApplicationInclusionList and nodeTypeY is absent from NodeTypeInclusionList, then applicationX will never be faulted.
	// At most 1000 application names can be included in this list, to increase this number, a config upgrade is required for MaxNumberOfApplicationsInChaosEntityFilter configuration.
	ApplicationInclusionList *[]string `json:"ApplicationInclusionList,omitempty"`
}

// CheckExistsPropertyBatchOperation represents a PropertyBatchOperation that compares the Boolean
// existence of a property with the Exists argument.
// The PropertyBatchOperation operation fails if the property's existence is not equal to the Exists
// argument.
// The CheckExistsPropertyBatchOperation is generally used as a precondition for the write operations in
// the batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckExistsPropertyBatchOperation struct {
	// Exists - Whether or not the property should exist for the operation to pass.
	Exists *bool `json:"Exists,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cepbo.Kind = KindCheckExists
	objectMap := make(map[string]interface{})
	if cepbo.Exists != nil {
		objectMap["Exists"] = cepbo.Exists
	}
	if cepbo.PropertyName != nil {
		objectMap["PropertyName"] = cepbo.PropertyName
	}
	if cepbo.Kind != "" {
		objectMap["Kind"] = cepbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return &cepbo, true
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckExistsPropertyBatchOperation.
func (cepbo CheckExistsPropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cepbo, true
}

// CheckSequencePropertyBatchOperation compares the Sequence Number of a property with the SequenceNumber
// argument.
// A property's sequence number can be thought of as that property's version.
// Every time the property is modified, its sequence number is increased.
// The sequence number can be found in a property's metadata.
// The comparison fails if the sequence numbers are not equal.
// CheckSequencePropertyBatchOperation is generally used as a precondition for the write operations in the
// batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckSequencePropertyBatchOperation struct {
	// SequenceNumber - The expected sequence number.
	SequenceNumber *string `json:"SequenceNumber,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cspbo.Kind = KindCheckSequence
	objectMap := make(map[string]interface{})
	if cspbo.SequenceNumber != nil {
		objectMap["SequenceNumber"] = cspbo.SequenceNumber
	}
	if cspbo.PropertyName != nil {
		objectMap["PropertyName"] = cspbo.PropertyName
	}
	if cspbo.Kind != "" {
		objectMap["Kind"] = cspbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return &cspbo, true
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return nil, false
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckSequencePropertyBatchOperation.
func (cspbo CheckSequencePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cspbo, true
}

// CheckValuePropertyBatchOperation represents a PropertyBatchOperation that compares the value of the
// property with the expected value.
// The CheckValuePropertyBatchOperation is generally used as a precondition for the write operations in the
// batch.
// Note that if one PropertyBatchOperation in a PropertyBatch fails,
// the entire batch fails and cannot be committed in a transactional manner.
type CheckValuePropertyBatchOperation struct {
	// Value - The expected property value.
	Value BasicPropertyValue `json:"Value,omitempty"`
	// PropertyName - The name of the Service Fabric property.
	PropertyName *string `json:"PropertyName,omitempty"`
	// Kind - Possible values include: 'KindPropertyBatchOperation', 'KindCheckExists', 'KindCheckSequence', 'KindCheckValue', 'KindDelete', 'KindGet', 'KindPut'
	Kind KindBasicPropertyBatchOperation `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) MarshalJSON() ([]byte, error) {
	cvpbo.Kind = KindCheckValue
	objectMap := make(map[string]interface{})
	objectMap["Value"] = cvpbo.Value
	if cvpbo.PropertyName != nil {
		objectMap["PropertyName"] = cvpbo.PropertyName
	}
	if cvpbo.Kind != "" {
		objectMap["Kind"] = cvpbo.Kind
	}
	return json.Marshal(objectMap)
}

// AsCheckExistsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckExistsPropertyBatchOperation() (*CheckExistsPropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckSequencePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckSequencePropertyBatchOperation() (*CheckSequencePropertyBatchOperation, bool) {
	return nil, false
}

// AsCheckValuePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsCheckValuePropertyBatchOperation() (*CheckValuePropertyBatchOperation, bool) {
	return &cvpbo, true
}

// AsDeletePropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsDeletePropertyBatchOperation() (*DeletePropertyBatchOperation, bool) {
	return nil, false
}

// AsGetPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsGetPropertyBatchOperation() (*GetPropertyBatchOperation, bool) {
	return nil, false
}

// AsPutPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPutPropertyBatchOperation() (*PutPropertyBatchOperation, bool) {
	return nil, false
}

// AsPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsPropertyBatchOperation() (*PropertyBatchOperation, bool) {
	return nil, false
}

// AsBasicPropertyBatchOperation is the BasicPropertyBatchOperation implementation for CheckValuePropertyBatchOperation.
func (cvpbo CheckValuePropertyBatchOperation) AsBasicPropertyBatchOperation() (BasicPropertyBatchOperation, bool) {
	return &cvpbo, true
}

// UnmarshalJSON is the custom unmarshaler for CheckValuePropertyBatchOperation struct.
func (cvpbo *CheckValuePropertyBatchOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "Value":
			if v != nil {
				value, err := unmarshalBasicPropertyValue(*v)
				if err != nil {
					return err
				}
				cvpbo.Value = value
			}
		case "PropertyName":
			if v != nil {
				var propertyName string
				err = json.Unmarshal(*v, &propertyName)
				if err != nil {
					return err
				}
				cvpbo.PropertyName = &propertyName
			}
		case "Kind":
			if v != nil {
				var kind KindBasicPropertyBatchOperation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cvpbo.Kind = kind
			}
		}
	}

	return nil
}

// ClusterConfiguration information about the standalone cluster configuration.
type ClusterConfiguration struct {
	autorest.Response `json:"-"`
	// ClusterConfiguration - The contents of the cluster configuration file.
	ClusterConfiguration *string `json:"ClusterConfiguration,omitempty"`
}

// ClusterConfigurationUpgradeDescription describes the parameters for a standalone cluster configuration
// upgrade.
type ClusterConfigurationUpgradeDescription struct {
	// ClusterConfig - The cluster configuration as a JSON string. For example, [this file](https://github.com/Azure-Samples/service-fabric-dotnet-standalone-cluster-configuration/blob/master/Samples/ClusterConfig.Unsecure.DevCluster.json) contains JSON describing the [nodes and other properties of the cluster](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-manifest).
	ClusterConfig *string `json:"ClusterConfig,omitempty"`
	// HealthCheckRetryTimeout - The length of time between attempts to perform health checks if the application or cluster is not healthy.
	HealthCheckRetryTimeout *string `json:"HealthCheckRetryTimeout,omitempty"`
	// HealthCheckWaitDurationInSeconds - The length of time to wait after completing an upgrade domain before starting the health checks process.
	HealthCheckWaitDurationInSeconds *string `json:"HealthCheckWaitDurationInSeconds,omitempty"`
	// HealthCheckStableDurationInSeconds - The length of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain.
	HealthCheckStableDurationInSeconds *string `json:"HealthCheckStableDurationInSeconds,omitempty"`
	// UpgradeDomainTimeoutInSeconds - The timeout for the upgrade domain.
	UpgradeDomainTimeoutInSeconds *string `json:"UpgradeDomainTimeoutInSeconds,omitempty"`
	// UpgradeTimeoutInSeconds - The upgrade timeout.
	UpgradeTimeoutInSeconds *string `json:"UpgradeTimeoutInSeconds,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain delta health degradation during the upgrade. Allowed values are integer values from zero to 100.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies *ApplicationHealthPolicies `json:"ApplicationHealthPolicies,omitempty"`
}

// ClusterConfigurationUpgradeStatusInfo information about a standalone cluster configuration upgrade
// status.
type ClusterConfigurationUpgradeStatusInfo struct {
	autorest.Response `json:"-"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// ProgressStatus - The cluster manifest version.
	ProgressStatus *int32 `json:"ProgressStatus,omitempty"`
	// ConfigVersion - The cluster configuration version.
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// Details - The cluster upgrade status details.
	Details *string `json:"Details,omitempty"`
}

// BasicClusterEvent represents the base for all Cluster Events.
type BasicClusterEvent interface {
	AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool)
	AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool)
	AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool)
	AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool)
	AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool)
	AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool)
	AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool)
	AsChaosStoppedEvent() (*ChaosStoppedEvent, bool)
	AsChaosStartedEvent() (*ChaosStartedEvent, bool)
	AsClusterEvent() (*ClusterEvent, bool)
}

// ClusterEvent represents the base for all Cluster Events.
type ClusterEvent struct {
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

func unmarshalBasicClusterEvent(body []byte) (BasicClusterEvent, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Kind"] {
	case string(KindClusterNewHealthReport):
		var cnhre ClusterNewHealthReportEvent
		err := json.Unmarshal(body, &cnhre)
		return cnhre, err
	case string(KindClusterHealthReportExpired):
		var chree ClusterHealthReportExpiredEvent
		err := json.Unmarshal(body, &chree)
		return chree, err
	case string(KindClusterUpgradeCompleted):
		var cuce ClusterUpgradeCompletedEvent
		err := json.Unmarshal(body, &cuce)
		return cuce, err
	case string(KindClusterUpgradeDomainCompleted):
		var cudce ClusterUpgradeDomainCompletedEvent
		err := json.Unmarshal(body, &cudce)
		return cudce, err
	case string(KindClusterUpgradeRollbackCompleted):
		var curce ClusterUpgradeRollbackCompletedEvent
		err := json.Unmarshal(body, &curce)
		return curce, err
	case string(KindClusterUpgradeRollbackStarted):
		var curse ClusterUpgradeRollbackStartedEvent
		err := json.Unmarshal(body, &curse)
		return curse, err
	case string(KindClusterUpgradeStarted):
		var cuse ClusterUpgradeStartedEvent
		err := json.Unmarshal(body, &cuse)
		return cuse, err
	case string(KindChaosStopped):
		var cse ChaosStoppedEvent
		err := json.Unmarshal(body, &cse)
		return cse, err
	case string(KindChaosStarted):
		var cse ChaosStartedEvent
		err := json.Unmarshal(body, &cse)
		return cse, err
	default:
		var ce ClusterEvent
		err := json.Unmarshal(body, &ce)
		return ce, err
	}
}
func unmarshalBasicClusterEventArray(body []byte) ([]BasicClusterEvent, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ceArray := make([]BasicClusterEvent, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ce, err := unmarshalBasicClusterEvent(*rawMessage)
		if err != nil {
			return nil, err
		}
		ceArray[index] = ce
	}
	return ceArray, nil
}

// MarshalJSON is the custom marshaler for ClusterEvent.
func (ce ClusterEvent) MarshalJSON() ([]byte, error) {
	ce.Kind = KindClusterEvent
	objectMap := make(map[string]interface{})
	if ce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = ce.EventInstanceID
	}
	if ce.Category != nil {
		objectMap["Category"] = ce.Category
	}
	if ce.TimeStamp != nil {
		objectMap["TimeStamp"] = ce.TimeStamp
	}
	if ce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = ce.HasCorrelatedEvents
	}
	if ce.Kind != "" {
		objectMap["Kind"] = ce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return &ce, true
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &ce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterEvent.
func (ce ClusterEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &ce, true
}

// ClusterHealth represents the health of the cluster.
// Contains the cluster aggregated health state, the cluster application and node health states as well as
// the health events and the unhealthy evaluations.
type ClusterHealth struct {
	autorest.Response `json:"-"`
	// NodeHealthStates - Cluster node health states as found in the health store.
	NodeHealthStates *[]NodeHealthState `json:"NodeHealthStates,omitempty"`
	// ApplicationHealthStates - Cluster application health states as found in the health store.
	ApplicationHealthStates *[]ApplicationHealthState `json:"ApplicationHealthStates,omitempty"`
	// AggregatedHealthState - The HealthState representing the aggregated health state of the entity computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired health policy. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	AggregatedHealthState HealthState `json:"AggregatedHealthState,omitempty"`
	// HealthEvents - The list of health events reported on the entity.
	HealthEvents *[]HealthEvent `json:"HealthEvents,omitempty"`
	// UnhealthyEvaluations - The unhealthy evaluations that show why the current aggregated health state was returned by Health Manager.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// HealthStatistics - Shows the health statistics for all children types of the queried entity.
	HealthStatistics *HealthStatistics `json:"HealthStatistics,omitempty"`
}

// ClusterHealthChunk represents the health chunk of the cluster.
// Contains the cluster aggregated health state, and the cluster entities that respect the input filter.
type ClusterHealthChunk struct {
	autorest.Response `json:"-"`
	// HealthState - The HealthState representing the aggregated health state of the cluster computed by Health Manager.
	// The health evaluation of the entity reflects all events reported on the entity and its children (if any).
	// The aggregation is done by applying the desired cluster health policy and the application health policies. Possible values include: 'HealthStateInvalid', 'HealthStateOk', 'HealthStateWarning', 'HealthStateError', 'HealthStateUnknown'
	HealthState HealthState `json:"HealthState,omitempty"`
	// NodeHealthStateChunks - The list of node health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	NodeHealthStateChunks *NodeHealthStateChunkList `json:"NodeHealthStateChunks,omitempty"`
	// ApplicationHealthStateChunks - The list of application health state chunks in the cluster that respect the filters in the cluster health chunk query description.
	ApplicationHealthStateChunks *ApplicationHealthStateChunkList `json:"ApplicationHealthStateChunks,omitempty"`
}

// ClusterHealthChunkQueryDescription the cluster health chunk query description, which can specify the
// health policies to evaluate cluster health and very expressive filters to select which cluster entities
// to include in response.
type ClusterHealthChunkQueryDescription struct {
	// NodeFilters - Defines a list of filters that specify which nodes to be included in the returned cluster health chunk.
	// If no filters are specified, no nodes are returned. All the nodes are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple node filters.
	// For example, it can specify a filter to return all nodes with health state Error and another filter to always include a node identified by its NodeName.
	NodeFilters *[]NodeHealthStateFilter `json:"NodeFilters,omitempty"`
	// ApplicationFilters - Defines a list of filters that specify which applications to be included in the returned cluster health chunk.
	// If no filters are specified, no applications are returned. All the applications are used to evaluate the cluster's aggregated health state, regardless of the input filters.
	// The cluster health chunk query may specify multiple application filters.
	// For example, it can specify a filter to return all applications with health state Error and another filter to always include applications of a specified application type.
	ApplicationFilters *[]ApplicationHealthStateFilter `json:"ApplicationFilters,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ApplicationHealthPolicies - Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies *ApplicationHealthPolicies `json:"ApplicationHealthPolicies,omitempty"`
}

// ClusterHealthPolicies health policies to evaluate cluster health.
type ClusterHealthPolicies struct {
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
}

// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster
// node.
type ClusterHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	// In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
	MaxPercentUnhealthyNodes *int32 `json:"MaxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
	// If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
	// The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
	MaxPercentUnhealthyApplications *int32 `json:"MaxPercentUnhealthyApplications,omitempty"`
	// ApplicationTypeHealthPolicyMap - Defines a map with max percentage unhealthy applications for specific application types.
	// Each entry specifies as key the application type name and as value an integer that represents the MaxPercentUnhealthyApplications percentage used to evaluate the applications of the specified application type.
	// The application type health policy map can be used during cluster health evaluation to describe special application types.
	// The application types included in the map are evaluated against the percentage specified in the map, and not with the global MaxPercentUnhealthyApplications defined in the cluster health policy.
	// The applications of application types specified in the map are not counted against the global pool of applications.
	// For example, if some applications of a type are critical, the cluster administrator can add an entry to the map for that application type
	// and assign it a value of 0% (that is, do not tolerate any failures).
	// All other applications can be evaluated with MaxPercentUnhealthyApplications set to 20% to tolerate some failures out of the thousands of application instances.
	// The application type health policy map is used only if the cluster manifest enables application type health evaluation using the configuration entry for HealthManager/EnableApplicationTypeHealthEvaluation.
	ApplicationTypeHealthPolicyMap *[]ApplicationTypeHealthPolicyMapItem `json:"ApplicationTypeHealthPolicyMap,omitempty"`
}

// ClusterHealthReportExpiredEvent cluster Health Report Expired event.
type ClusterHealthReportExpiredEvent struct {
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) MarshalJSON() ([]byte, error) {
	chree.Kind = KindClusterHealthReportExpired
	objectMap := make(map[string]interface{})
	if chree.SourceID != nil {
		objectMap["SourceId"] = chree.SourceID
	}
	if chree.Property != nil {
		objectMap["Property"] = chree.Property
	}
	if chree.HealthState != nil {
		objectMap["HealthState"] = chree.HealthState
	}
	if chree.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = chree.TimeToLiveMs
	}
	if chree.SequenceNumber != nil {
		objectMap["SequenceNumber"] = chree.SequenceNumber
	}
	if chree.Description != nil {
		objectMap["Description"] = chree.Description
	}
	if chree.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = chree.RemoveWhenExpired
	}
	if chree.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = chree.SourceUtcTimestamp
	}
	if chree.EventInstanceID != nil {
		objectMap["EventInstanceId"] = chree.EventInstanceID
	}
	if chree.Category != nil {
		objectMap["Category"] = chree.Category
	}
	if chree.TimeStamp != nil {
		objectMap["TimeStamp"] = chree.TimeStamp
	}
	if chree.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = chree.HasCorrelatedEvents
	}
	if chree.Kind != "" {
		objectMap["Kind"] = chree.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &chree, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return &chree, true
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterHealthReportExpiredEvent.
func (chree ClusterHealthReportExpiredEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &chree, true
}

// ClusterManifest information about the cluster manifest.
type ClusterManifest struct {
	autorest.Response `json:"-"`
	// Manifest - The contents of the cluster manifest file.
	Manifest *string `json:"Manifest,omitempty"`
}

// ClusterNewHealthReportEvent cluster Health Report Created event.
type ClusterNewHealthReportEvent struct {
	// SourceID - Id of report source.
	SourceID *string `json:"SourceId,omitempty"`
	// Property - Describes the property.
	Property *string `json:"Property,omitempty"`
	// HealthState - Describes the property health state.
	HealthState *string `json:"HealthState,omitempty"`
	// TimeToLiveMs - Time to live in milli-seconds.
	TimeToLiveMs *int64 `json:"TimeToLiveMs,omitempty"`
	// SequenceNumber - Sequence number of report.
	SequenceNumber *int64 `json:"SequenceNumber,omitempty"`
	// Description - Description of report.
	Description *string `json:"Description,omitempty"`
	// RemoveWhenExpired - Indicates the removal when it expires.
	RemoveWhenExpired *bool `json:"RemoveWhenExpired,omitempty"`
	// SourceUtcTimestamp - Source time.
	SourceUtcTimestamp *date.Time `json:"SourceUtcTimestamp,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) MarshalJSON() ([]byte, error) {
	cnhre.Kind = KindClusterNewHealthReport
	objectMap := make(map[string]interface{})
	if cnhre.SourceID != nil {
		objectMap["SourceId"] = cnhre.SourceID
	}
	if cnhre.Property != nil {
		objectMap["Property"] = cnhre.Property
	}
	if cnhre.HealthState != nil {
		objectMap["HealthState"] = cnhre.HealthState
	}
	if cnhre.TimeToLiveMs != nil {
		objectMap["TimeToLiveMs"] = cnhre.TimeToLiveMs
	}
	if cnhre.SequenceNumber != nil {
		objectMap["SequenceNumber"] = cnhre.SequenceNumber
	}
	if cnhre.Description != nil {
		objectMap["Description"] = cnhre.Description
	}
	if cnhre.RemoveWhenExpired != nil {
		objectMap["RemoveWhenExpired"] = cnhre.RemoveWhenExpired
	}
	if cnhre.SourceUtcTimestamp != nil {
		objectMap["SourceUtcTimestamp"] = cnhre.SourceUtcTimestamp
	}
	if cnhre.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cnhre.EventInstanceID
	}
	if cnhre.Category != nil {
		objectMap["Category"] = cnhre.Category
	}
	if cnhre.TimeStamp != nil {
		objectMap["TimeStamp"] = cnhre.TimeStamp
	}
	if cnhre.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cnhre.HasCorrelatedEvents
	}
	if cnhre.Kind != "" {
		objectMap["Kind"] = cnhre.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cnhre, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return &cnhre, true
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterNewHealthReportEvent.
func (cnhre ClusterNewHealthReportEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cnhre, true
}

// ClusterUpgradeCompletedEvent cluster Upgrade Completed event.
type ClusterUpgradeCompletedEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) MarshalJSON() ([]byte, error) {
	cuce.Kind = KindClusterUpgradeCompleted
	objectMap := make(map[string]interface{})
	if cuce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = cuce.TargetClusterVersion
	}
	if cuce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = cuce.OverallUpgradeElapsedTimeInMs
	}
	if cuce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cuce.EventInstanceID
	}
	if cuce.Category != nil {
		objectMap["Category"] = cuce.Category
	}
	if cuce.TimeStamp != nil {
		objectMap["TimeStamp"] = cuce.TimeStamp
	}
	if cuce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cuce.HasCorrelatedEvents
	}
	if cuce.Kind != "" {
		objectMap["Kind"] = cuce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cuce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return &cuce, true
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeCompletedEvent.
func (cuce ClusterUpgradeCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cuce, true
}

// ClusterUpgradeDescriptionObject represents a ServiceFabric cluster upgrade
type ClusterUpgradeDescriptionObject struct {
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// UpgradeKind - The kind of upgrade out of the following possible values. Possible values include: 'UpgradeKindInvalid', 'UpgradeKindRolling'
	UpgradeKind UpgradeKind `json:"UpgradeKind,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeReplicaSetCheckTimeoutInSeconds - The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeoutInSeconds *int64 `json:"UpgradeReplicaSetCheckTimeoutInSeconds,omitempty"`
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"ForceRestart,omitempty"`
	// EnableDeltaHealthEvaluation - When true, enables delta health evaluation rather than absolute health evaluation after completion of each upgrade domain.
	EnableDeltaHealthEvaluation *bool `json:"EnableDeltaHealthEvaluation,omitempty"`
	// MonitoringPolicy - Describes the parameters for monitoring an upgrade in Monitored mode.
	MonitoringPolicy *MonitoringPolicyDescription `json:"MonitoringPolicy,omitempty"`
	// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
	ClusterHealthPolicy *ClusterHealthPolicy `json:"ClusterHealthPolicy,omitempty"`
	// ClusterUpgradeHealthPolicy - Defines a health policy used to evaluate the health of the cluster during a cluster upgrade.
	ClusterUpgradeHealthPolicy *ClusterUpgradeHealthPolicyObject `json:"ClusterUpgradeHealthPolicy,omitempty"`
	// ApplicationHealthPolicyMap - Defines a map that contains specific application health policies for different applications.
	// Each entry specifies as key the application name and as value an ApplicationHealthPolicy used to evaluate the application health.
	// If an application is not specified in the map, the application health evaluation uses the ApplicationHealthPolicy found in its application manifest or the default application health policy (if no health policy is defined in the manifest).
	// The map is empty by default.
	ApplicationHealthPolicyMap *[]ApplicationHealthPolicyMapItem `json:"ApplicationHealthPolicyMap,omitempty"`
}

// ClusterUpgradeDomainCompletedEvent cluster Upgrade Domain Completed event.
type ClusterUpgradeDomainCompletedEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// UpgradeState - State of upgrade.
	UpgradeState *string `json:"UpgradeState,omitempty"`
	// UpgradeDomains - Upgrade domains.
	UpgradeDomains *string `json:"UpgradeDomains,omitempty"`
	// UpgradeDomainElapsedTimeInMs - Duration of domain upgrade in milli-seconds.
	UpgradeDomainElapsedTimeInMs *float64 `json:"UpgradeDomainElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) MarshalJSON() ([]byte, error) {
	cudce.Kind = KindClusterUpgradeDomainCompleted
	objectMap := make(map[string]interface{})
	if cudce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = cudce.TargetClusterVersion
	}
	if cudce.UpgradeState != nil {
		objectMap["UpgradeState"] = cudce.UpgradeState
	}
	if cudce.UpgradeDomains != nil {
		objectMap["UpgradeDomains"] = cudce.UpgradeDomains
	}
	if cudce.UpgradeDomainElapsedTimeInMs != nil {
		objectMap["UpgradeDomainElapsedTimeInMs"] = cudce.UpgradeDomainElapsedTimeInMs
	}
	if cudce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cudce.EventInstanceID
	}
	if cudce.Category != nil {
		objectMap["Category"] = cudce.Category
	}
	if cudce.TimeStamp != nil {
		objectMap["TimeStamp"] = cudce.TimeStamp
	}
	if cudce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cudce.HasCorrelatedEvents
	}
	if cudce.Kind != "" {
		objectMap["Kind"] = cudce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cudce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return &cudce, true
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeDomainCompletedEvent.
func (cudce ClusterUpgradeDomainCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &cudce, true
}

// ClusterUpgradeHealthPolicyObject defines a health policy used to evaluate the health of the cluster
// during a cluster upgrade.
type ClusterUpgradeHealthPolicyObject struct {
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. The default value is 10%.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"MaxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits. The default value is 15%.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"MaxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
}

// ClusterUpgradeProgressObject information about a cluster upgrade.
type ClusterUpgradeProgressObject struct {
	autorest.Response `json:"-"`
	// CodeVersion - The ServiceFabric code version of the cluster.
	CodeVersion *string `json:"CodeVersion,omitempty"`
	// ConfigVersion - The cluster configuration version (specified in the cluster manifest).
	ConfigVersion *string `json:"ConfigVersion,omitempty"`
	// UpgradeDomains - List of upgrade domains and their statuses.
	UpgradeDomains *[]UpgradeDomainInfo `json:"UpgradeDomains,omitempty"`
	// UpgradeState - The state of the upgrade domain. Possible values include: 'UpgradeStateInvalid', 'UpgradeStateRollingBackInProgress', 'UpgradeStateRollingBackCompleted', 'UpgradeStateRollingForwardPending', 'UpgradeStateRollingForwardInProgress', 'UpgradeStateRollingForwardCompleted', 'UpgradeStateFailed'
	UpgradeState UpgradeState `json:"UpgradeState,omitempty"`
	// NextUpgradeDomain - The name of the next upgrade domain to be processed.
	NextUpgradeDomain *string `json:"NextUpgradeDomain,omitempty"`
	// RollingUpgradeMode - The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored. Possible values include: 'UpgradeModeInvalid', 'UpgradeModeUnmonitoredAuto', 'UpgradeModeUnmonitoredManual', 'UpgradeModeMonitored'
	RollingUpgradeMode UpgradeMode `json:"RollingUpgradeMode,omitempty"`
	// UpgradeDescription - Represents a ServiceFabric cluster upgrade
	UpgradeDescription *ClusterUpgradeDescriptionObject `json:"UpgradeDescription,omitempty"`
	// UpgradeDurationInMilliseconds - The estimated elapsed time spent processing the current overall upgrade.
	UpgradeDurationInMilliseconds *string `json:"UpgradeDurationInMilliseconds,omitempty"`
	// UpgradeDomainDurationInMilliseconds - The estimated elapsed time spent processing the current upgrade domain.
	UpgradeDomainDurationInMilliseconds *string `json:"UpgradeDomainDurationInMilliseconds,omitempty"`
	// UnhealthyEvaluations - List of health evaluations that resulted in the current aggregated health state.
	UnhealthyEvaluations *[]HealthEvaluationWrapper `json:"UnhealthyEvaluations,omitempty"`
	// CurrentUpgradeDomainProgress - Information about the current in-progress upgrade domain.
	CurrentUpgradeDomainProgress *CurrentUpgradeDomainProgressInfo `json:"CurrentUpgradeDomainProgress,omitempty"`
	// StartTimestampUtc - The start time of the upgrade in UTC.
	StartTimestampUtc *string `json:"StartTimestampUtc,omitempty"`
	// FailureTimestampUtc - The failure time of the upgrade in UTC.
	FailureTimestampUtc *string `json:"FailureTimestampUtc,omitempty"`
	// FailureReason - The cause of an upgrade failure that resulted in FailureAction being executed. Possible values include: 'None', 'Interrupted', 'HealthCheck', 'UpgradeDomainTimeout', 'OverallUpgradeTimeout'
	FailureReason FailureReason `json:"FailureReason,omitempty"`
	// UpgradeDomainProgressAtFailure - The detailed upgrade progress for nodes in the current upgrade domain at the point of failure.
	UpgradeDomainProgressAtFailure *FailedUpgradeDomainProgressObject `json:"UpgradeDomainProgressAtFailure,omitempty"`
}

// ClusterUpgradeRollbackCompletedEvent cluster Upgrade Rollback Completed event.
type ClusterUpgradeRollbackCompletedEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// FailureReason - Describes failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) MarshalJSON() ([]byte, error) {
	curce.Kind = KindClusterUpgradeRollbackCompleted
	objectMap := make(map[string]interface{})
	if curce.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = curce.TargetClusterVersion
	}
	if curce.FailureReason != nil {
		objectMap["FailureReason"] = curce.FailureReason
	}
	if curce.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = curce.OverallUpgradeElapsedTimeInMs
	}
	if curce.EventInstanceID != nil {
		objectMap["EventInstanceId"] = curce.EventInstanceID
	}
	if curce.Category != nil {
		objectMap["Category"] = curce.Category
	}
	if curce.TimeStamp != nil {
		objectMap["TimeStamp"] = curce.TimeStamp
	}
	if curce.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = curce.HasCorrelatedEvents
	}
	if curce.Kind != "" {
		objectMap["Kind"] = curce.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &curce, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return &curce, true
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackCompletedEvent.
func (curce ClusterUpgradeRollbackCompletedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &curce, true
}

// ClusterUpgradeRollbackStartedEvent cluster Upgrade Rollback Started event.
type ClusterUpgradeRollbackStartedEvent struct {
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// FailureReason - Describes failure.
	FailureReason *string `json:"FailureReason,omitempty"`
	// OverallUpgradeElapsedTimeInMs - Overall duration of upgrade in milli-seconds.
	OverallUpgradeElapsedTimeInMs *float64 `json:"OverallUpgradeElapsedTimeInMs,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) MarshalJSON() ([]byte, error) {
	curse.Kind = KindClusterUpgradeRollbackStarted
	objectMap := make(map[string]interface{})
	if curse.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = curse.TargetClusterVersion
	}
	if curse.FailureReason != nil {
		objectMap["FailureReason"] = curse.FailureReason
	}
	if curse.OverallUpgradeElapsedTimeInMs != nil {
		objectMap["OverallUpgradeElapsedTimeInMs"] = curse.OverallUpgradeElapsedTimeInMs
	}
	if curse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = curse.EventInstanceID
	}
	if curse.Category != nil {
		objectMap["Category"] = curse.Category
	}
	if curse.TimeStamp != nil {
		objectMap["TimeStamp"] = curse.TimeStamp
	}
	if curse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = curse.HasCorrelatedEvents
	}
	if curse.Kind != "" {
		objectMap["Kind"] = curse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &curse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsServiceCreatedEvent() (*ServiceCreatedEvent, bool) {
	return nil, false
}

// AsServiceDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsServiceDeletedEvent() (*ServiceDeletedEvent, bool) {
	return nil, false
}

// AsServiceNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsServiceNewHealthReportEvent() (*ServiceNewHealthReportEvent, bool) {
	return nil, false
}

// AsServiceHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsServiceHealthReportExpiredEvent() (*ServiceHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsDeployedServicePackageNewHealthReportEvent() (*DeployedServicePackageNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedServicePackageHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsDeployedServicePackageHealthReportExpiredEvent() (*DeployedServicePackageHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatefulReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsStatefulReplicaNewHealthReportEvent() (*StatefulReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatefulReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsStatefulReplicaHealthReportExpiredEvent() (*StatefulReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsStatelessReplicaNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsStatelessReplicaNewHealthReportEvent() (*StatelessReplicaNewHealthReportEvent, bool) {
	return nil, false
}

// AsStatelessReplicaHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsStatelessReplicaHealthReportExpiredEvent() (*StatelessReplicaHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterNewHealthReportEvent() (*ClusterNewHealthReportEvent, bool) {
	return nil, false
}

// AsClusterHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterHealthReportExpiredEvent() (*ClusterHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsClusterUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterUpgradeCompletedEvent() (*ClusterUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterUpgradeDomainCompletedEvent() (*ClusterUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterUpgradeRollbackCompletedEvent() (*ClusterUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsClusterUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterUpgradeRollbackStartedEvent() (*ClusterUpgradeRollbackStartedEvent, bool) {
	return &curse, true
}

// AsClusterUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsClusterUpgradeStartedEvent() (*ClusterUpgradeStartedEvent, bool) {
	return nil, false
}

// AsChaosStoppedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosStoppedEvent() (*ChaosStoppedEvent, bool) {
	return nil, false
}

// AsChaosStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosStartedEvent() (*ChaosStartedEvent, bool) {
	return nil, false
}

// AsChaosCodePackageRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosCodePackageRestartScheduledEvent() (*ChaosCodePackageRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRemovalScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosReplicaRemovalScheduledEvent() (*ChaosReplicaRemovalScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionSecondaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosPartitionSecondaryMoveScheduledEvent() (*ChaosPartitionSecondaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosPartitionPrimaryMoveScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosPartitionPrimaryMoveScheduledEvent() (*ChaosPartitionPrimaryMoveScheduledEvent, bool) {
	return nil, false
}

// AsChaosReplicaRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosReplicaRestartScheduledEvent() (*ChaosReplicaRestartScheduledEvent, bool) {
	return nil, false
}

// AsChaosNodeRestartScheduledEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsChaosNodeRestartScheduledEvent() (*ChaosNodeRestartScheduledEvent, bool) {
	return nil, false
}

// AsFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsFabricEvent() (*FabricEvent, bool) {
	return nil, false
}

// AsBasicFabricEvent is the BasicFabricEvent implementation for ClusterUpgradeRollbackStartedEvent.
func (curse ClusterUpgradeRollbackStartedEvent) AsBasicFabricEvent() (BasicFabricEvent, bool) {
	return &curse, true
}

// ClusterUpgradeStartedEvent cluster Upgrade Started event.
type ClusterUpgradeStartedEvent struct {
	// CurrentClusterVersion - Current Cluster version.
	CurrentClusterVersion *string `json:"CurrentClusterVersion,omitempty"`
	// TargetClusterVersion - Target Cluster version.
	TargetClusterVersion *string `json:"TargetClusterVersion,omitempty"`
	// UpgradeType - Type of upgrade.
	UpgradeType *string `json:"UpgradeType,omitempty"`
	// RollingUpgradeMode - Mode of upgrade.
	RollingUpgradeMode *string `json:"RollingUpgradeMode,omitempty"`
	// FailureAction - Action if failed.
	FailureAction *string `json:"FailureAction,omitempty"`
	// EventInstanceID - The identifier for the FabricEvent instance.
	EventInstanceID *uuid.UUID `json:"EventInstanceId,omitempty"`
	// Category - The category of event.
	Category *string `json:"Category,omitempty"`
	// TimeStamp - The time event was logged.
	TimeStamp *date.Time `json:"TimeStamp,omitempty"`
	// HasCorrelatedEvents - Shows there is existing related events available.
	HasCorrelatedEvents *bool `json:"HasCorrelatedEvents,omitempty"`
	// Kind - Possible values include: 'KindFabricEvent', 'KindApplicationEvent', 'KindClusterEvent', 'KindContainerInstanceEvent', 'KindNodeEvent', 'KindPartitionAnalysisEvent', 'KindPartitionEvent', 'KindReplicaEvent', 'KindServiceEvent', 'KindApplicationCreated', 'KindApplicationDeleted', 'KindApplicationNewHealthReport', 'KindApplicationHealthReportExpired', 'KindApplicationUpgradeCompleted', 'KindApplicationUpgradeDomainCompleted', 'KindApplicationUpgradeRollbackCompleted', 'KindApplicationUpgradeRollbackStarted', 'KindApplicationUpgradeStarted', 'KindDeployedApplicationNewHealthReport', 'KindDeployedApplicationHealthReportExpired', 'KindApplicationProcessExited', 'KindApplicationContainerInstanceExited', 'KindNodeAborted', 'KindNodeAddedToCluster', 'KindNodeClosed', 'KindNodeDeactivateCompleted', 'KindNodeDeactivateStarted', 'KindNodeDown', 'KindNodeNewHealthReport', 'KindNodeHealthReportExpired', 'KindNodeOpenSucceeded', 'KindNodeOpenFailed', 'KindNodeRemovedFromCluster', 'KindNodeUp', 'KindPartitionNewHealthReport', 'KindPartitionHealthReportExpired', 'KindPartitionReconfigured', 'KindPartitionPrimaryMoveAnalysis', 'KindServiceCreated', 'KindServiceDeleted', 'KindServiceNewHealthReport', 'KindServiceHealthReportExpired', 'KindDeployedServicePackageNewHealthReport', 'KindDeployedServicePackageHealthReportExpired', 'KindStatefulReplicaNewHealthReport', 'KindStatefulReplicaHealthReportExpired', 'KindStatelessReplicaNewHealthReport', 'KindStatelessReplicaHealthReportExpired', 'KindClusterNewHealthReport', 'KindClusterHealthReportExpired', 'KindClusterUpgradeCompleted', 'KindClusterUpgradeDomainCompleted', 'KindClusterUpgradeRollbackCompleted', 'KindClusterUpgradeRollbackStarted', 'KindClusterUpgradeStarted', 'KindChaosStopped', 'KindChaosStarted', 'KindChaosCodePackageRestartScheduled', 'KindChaosReplicaRemovalScheduled', 'KindChaosPartitionSecondaryMoveScheduled', 'KindChaosPartitionPrimaryMoveScheduled', 'KindChaosReplicaRestartScheduled', 'KindChaosNodeRestartScheduled'
	Kind KindBasicFabricEvent `json:"Kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) MarshalJSON() ([]byte, error) {
	cuse.Kind = KindClusterUpgradeStarted
	objectMap := make(map[string]interface{})
	if cuse.CurrentClusterVersion != nil {
		objectMap["CurrentClusterVersion"] = cuse.CurrentClusterVersion
	}
	if cuse.TargetClusterVersion != nil {
		objectMap["TargetClusterVersion"] = cuse.TargetClusterVersion
	}
	if cuse.UpgradeType != nil {
		objectMap["UpgradeType"] = cuse.UpgradeType
	}
	if cuse.RollingUpgradeMode != nil {
		objectMap["RollingUpgradeMode"] = cuse.RollingUpgradeMode
	}
	if cuse.FailureAction != nil {
		objectMap["FailureAction"] = cuse.FailureAction
	}
	if cuse.EventInstanceID != nil {
		objectMap["EventInstanceId"] = cuse.EventInstanceID
	}
	if cuse.Category != nil {
		objectMap["Category"] = cuse.Category
	}
	if cuse.TimeStamp != nil {
		objectMap["TimeStamp"] = cuse.TimeStamp
	}
	if cuse.HasCorrelatedEvents != nil {
		objectMap["HasCorrelatedEvents"] = cuse.HasCorrelatedEvents
	}
	if cuse.Kind != "" {
		objectMap["Kind"] = cuse.Kind
	}
	return json.Marshal(objectMap)
}

// AsApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationEvent() (*ApplicationEvent, bool) {
	return nil, false
}

// AsBasicApplicationEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicApplicationEvent() (BasicApplicationEvent, bool) {
	return nil, false
}

// AsClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsClusterEvent() (*ClusterEvent, bool) {
	return nil, false
}

// AsBasicClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicClusterEvent() (BasicClusterEvent, bool) {
	return &cuse, true
}

// AsContainerInstanceEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsContainerInstanceEvent() (*ContainerInstanceEvent, bool) {
	return nil, false
}

// AsNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeEvent() (*NodeEvent, bool) {
	return nil, false
}

// AsBasicNodeEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicNodeEvent() (BasicNodeEvent, bool) {
	return nil, false
}

// AsPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionAnalysisEvent() (*PartitionAnalysisEvent, bool) {
	return nil, false
}

// AsBasicPartitionAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicPartitionAnalysisEvent() (BasicPartitionAnalysisEvent, bool) {
	return nil, false
}

// AsPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionEvent() (*PartitionEvent, bool) {
	return nil, false
}

// AsBasicPartitionEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicPartitionEvent() (BasicPartitionEvent, bool) {
	return nil, false
}

// AsReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsReplicaEvent() (*ReplicaEvent, bool) {
	return nil, false
}

// AsBasicReplicaEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicReplicaEvent() (BasicReplicaEvent, bool) {
	return nil, false
}

// AsServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsServiceEvent() (*ServiceEvent, bool) {
	return nil, false
}

// AsBasicServiceEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsBasicServiceEvent() (BasicServiceEvent, bool) {
	return nil, false
}

// AsApplicationCreatedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationCreatedEvent() (*ApplicationCreatedEvent, bool) {
	return nil, false
}

// AsApplicationDeletedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationDeletedEvent() (*ApplicationDeletedEvent, bool) {
	return nil, false
}

// AsApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationNewHealthReportEvent() (*ApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationHealthReportExpiredEvent() (*ApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationUpgradeCompletedEvent() (*ApplicationUpgradeCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeDomainCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationUpgradeDomainCompletedEvent() (*ApplicationUpgradeDomainCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationUpgradeRollbackCompletedEvent() (*ApplicationUpgradeRollbackCompletedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeRollbackStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationUpgradeRollbackStartedEvent() (*ApplicationUpgradeRollbackStartedEvent, bool) {
	return nil, false
}

// AsApplicationUpgradeStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationUpgradeStartedEvent() (*ApplicationUpgradeStartedEvent, bool) {
	return nil, false
}

// AsDeployedApplicationNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsDeployedApplicationNewHealthReportEvent() (*DeployedApplicationNewHealthReportEvent, bool) {
	return nil, false
}

// AsDeployedApplicationHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsDeployedApplicationHealthReportExpiredEvent() (*DeployedApplicationHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsApplicationProcessExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationProcessExitedEvent() (*ApplicationProcessExitedEvent, bool) {
	return nil, false
}

// AsApplicationContainerInstanceExitedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsApplicationContainerInstanceExitedEvent() (*ApplicationContainerInstanceExitedEvent, bool) {
	return nil, false
}

// AsNodeAbortedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeAbortedEvent() (*NodeAbortedEvent, bool) {
	return nil, false
}

// AsNodeAddedToClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeAddedToClusterEvent() (*NodeAddedToClusterEvent, bool) {
	return nil, false
}

// AsNodeClosedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeClosedEvent() (*NodeClosedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateCompletedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeDeactivateCompletedEvent() (*NodeDeactivateCompletedEvent, bool) {
	return nil, false
}

// AsNodeDeactivateStartedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeDeactivateStartedEvent() (*NodeDeactivateStartedEvent, bool) {
	return nil, false
}

// AsNodeDownEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeDownEvent() (*NodeDownEvent, bool) {
	return nil, false
}

// AsNodeNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeNewHealthReportEvent() (*NodeNewHealthReportEvent, bool) {
	return nil, false
}

// AsNodeHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeHealthReportExpiredEvent() (*NodeHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsNodeOpenSucceededEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeOpenSucceededEvent() (*NodeOpenSucceededEvent, bool) {
	return nil, false
}

// AsNodeOpenFailedEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeOpenFailedEvent() (*NodeOpenFailedEvent, bool) {
	return nil, false
}

// AsNodeRemovedFromClusterEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeRemovedFromClusterEvent() (*NodeRemovedFromClusterEvent, bool) {
	return nil, false
}

// AsNodeUpEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsNodeUpEvent() (*NodeUpEvent, bool) {
	return nil, false
}

// AsPartitionNewHealthReportEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionNewHealthReportEvent() (*PartitionNewHealthReportEvent, bool) {
	return nil, false
}

// AsPartitionHealthReportExpiredEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionHealthReportExpiredEvent() (*PartitionHealthReportExpiredEvent, bool) {
	return nil, false
}

// AsPartitionReconfiguredEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionReconfiguredEvent() (*PartitionReconfiguredEvent, bool) {
	return nil, false
}

// AsPartitionPrimaryMoveAnalysisEvent is the BasicFabricEvent implementation for ClusterUpgradeStartedEvent.
func (cuse ClusterUpgradeStartedEvent) AsPartitionPrimaryMoveAnalysisEvent() (*PartitionPrimaryMoveAnalysisEvent, bool) {
	return nil, false
}

// AsServiceCreatedEvent is the BasicFabricEvent implementation for Cluste