// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to update. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// An array of ByteMatchSetUpdate objects that you want to insert into or delete
	// from a ByteMatchSet. For more information, see the applicable data types:
	//
	//    * ByteMatchSetUpdate: Contains Action and ByteMatchTuple
	//
	//    * ByteMatchTuple: Contains FieldToMatch, PositionalConstraint, TargetString,
	//    and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []ByteMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateByteMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateByteMatchSetInput"}

	if s.ByteMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ByteMatchSetId"))
	}
	if s.ByteMatchSetId != nil && len(*s.ByteMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ByteMatchSetId", 1))
	}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.Updates == nil {
		invalidParams.Add(aws.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateByteMatchSet = "UpdateByteMatchSet"

// UpdateByteMatchSetRequest returns a request value for making API operation for
// AWS WAF.
//
// Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For
// each ByteMatchTuple object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a ByteMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspect, such as
//    a query string or the value of the User-Agent header.
//
//    * The bytes (typically a string that corresponds with ASCII characters)
//    that you want AWS WAF to look for. For more information, including how
//    you specify the values for the AWS WAF API and the AWS CLI or SDKs, see
//    TargetString in the ByteMatchTuple data type.
//
//    * Where to look, such as at the beginning or the end of a query string.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can add a ByteMatchSetUpdate object that matches web requests
// in which User-Agent headers contain the string BadBot. You can then configure
// AWS WAF to block those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Create a ByteMatchSet. For more information, see CreateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using UpdateByteMatchSetRequest.
//    req := client.UpdateByteMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateByteMatchSet
func (c *Client) UpdateByteMatchSetRequest(input *UpdateByteMatchSetInput) UpdateByteMatchSetRequest {
	op := &aws.Operation{
		Name:       opUpdateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateByteMatchSetInput{}
	}

	req := c.newRequest(op, input, &UpdateByteMatchSetOutput{})
	return UpdateByteMatchSetRequest{Request: req, Input: input, Copy: c.UpdateByteMatchSetRequest}
}

// UpdateByteMatchSetRequest is the request type for the
// UpdateByteMatchSet API operation.
type UpdateByteMatchSetRequest struct {
	*aws.Request
	Input *UpdateByteMatchSetInput
	Copy  func(*UpdateByteMatchSetInput) UpdateByteMatchSetRequest
}

// Send marshals and sends the UpdateByteMatchSet API request.
func (r UpdateByteMatchSetRequest) Send(ctx context.Context) (*UpdateByteMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateByteMatchSetResponse{
		UpdateByteMatchSetOutput: r.Request.Data.(*UpdateByteMatchSetOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateByteMatchSetResponse is the response type for the
// UpdateByteMatchSet API operation.
type UpdateByteMatchSetResponse struct {
	*UpdateByteMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateByteMatchSet request.
func (r *UpdateByteMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
