// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input to the ListOutgoingCertificates operation.
type ListOutgoingCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the order for results. If True, the results are returned in ascending
	// order, based on the creation date.
	AscendingOrder *bool `location:"querystring" locationName:"isAscendingOrder" type:"boolean"`

	// The marker for the next set of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListOutgoingCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutgoingCertificatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListOutgoingCertificatesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOutgoingCertificatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AscendingOrder != nil {
		v := *s.AscendingOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "isAscendingOrder", protocol.BoolValue(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "pageSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The output from the ListOutgoingCertificates operation.
type ListOutgoingCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The marker for the next set of results.
	NextMarker *string `locationName:"nextMarker" type:"string"`

	// The certificates that are being transferred but not yet accepted.
	OutgoingCertificates []OutgoingCertificate `locationName:"outgoingCertificates" type:"list"`
}

// String returns the string representation
func (s ListOutgoingCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOutgoingCertificatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutgoingCertificates != nil {
		v := s.OutgoingCertificates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "outgoingCertificates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListOutgoingCertificates = "ListOutgoingCertificates"

// ListOutgoingCertificatesRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists certificates that are being transferred but not yet accepted.
//
//    // Example sending a request using ListOutgoingCertificatesRequest.
//    req := client.ListOutgoingCertificatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListOutgoingCertificatesRequest(input *ListOutgoingCertificatesInput) ListOutgoingCertificatesRequest {
	op := &aws.Operation{
		Name:       opListOutgoingCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/certificates-out-going",
	}

	if input == nil {
		input = &ListOutgoingCertificatesInput{}
	}

	req := c.newRequest(op, input, &ListOutgoingCertificatesOutput{})
	return ListOutgoingCertificatesRequest{Request: req, Input: input, Copy: c.ListOutgoingCertificatesRequest}
}

// ListOutgoingCertificatesRequest is the request type for the
// ListOutgoingCertificates API operation.
type ListOutgoingCertificatesRequest struct {
	*aws.Request
	Input *ListOutgoingCertificatesInput
	Copy  func(*ListOutgoingCertificatesInput) ListOutgoingCertificatesRequest
}

// Send marshals and sends the ListOutgoingCertificates API request.
func (r ListOutgoingCertificatesRequest) Send(ctx context.Context) (*ListOutgoingCertificatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOutgoingCertificatesResponse{
		ListOutgoingCertificatesOutput: r.Request.Data.(*ListOutgoingCertificatesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListOutgoingCertificatesResponse is the response type for the
// ListOutgoingCertificates API operation.
type ListOutgoingCertificatesResponse struct {
	*ListOutgoingCertificatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOutgoingCertificates request.
func (r *ListOutgoingCertificatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
