// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchDescribeMergeConflictsInput struct {
	_ struct{} `type:"structure"`

	// The level of conflict detail to use. If unspecified, the default FILE_LEVEL
	// is used, which returns a not-mergeable result if the same file has differences
	// in both branches. If LINE_LEVEL is specified, a conflict is considered not
	// mergeable if the same file in both branches has differences on the same line.
	ConflictDetailLevel ConflictDetailLevelTypeEnum `locationName:"conflictDetailLevel" type:"string" enum:"true"`

	// Specifies which branch to use when resolving conflicts, or whether to attempt
	// automatically merging two versions of a file. The default is NONE, which
	// requires any conflicts to be resolved manually before the merge operation
	// is successful.
	ConflictResolutionStrategy ConflictResolutionStrategyTypeEnum `locationName:"conflictResolutionStrategy" type:"string" enum:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// DestinationCommitSpecifier is a required field
	DestinationCommitSpecifier *string `locationName:"destinationCommitSpecifier" type:"string" required:"true"`

	// The path of the target files used to describe the conflicts. If not specified,
	// the default is all conflict files.
	FilePaths []string `locationName:"filePaths" type:"list"`

	// The maximum number of files to include in the output.
	MaxConflictFiles *int64 `locationName:"maxConflictFiles" type:"integer"`

	// The maximum number of merge hunks to include in the output.
	MaxMergeHunks *int64 `locationName:"maxMergeHunks" type:"integer"`

	// The merge option or strategy you want to use to merge the code.
	//
	// MergeOption is a required field
	MergeOption MergeOptionTypeEnum `locationName:"mergeOption" type:"string" required:"true" enum:"true"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository that contains the merge conflicts you want to
	// review.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// SourceCommitSpecifier is a required field
	SourceCommitSpecifier *string `locationName:"sourceCommitSpecifier" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDescribeMergeConflictsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDescribeMergeConflictsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDescribeMergeConflictsInput"}

	if s.DestinationCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCommitSpecifier"))
	}
	if len(s.MergeOption) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MergeOption"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if s.SourceCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceCommitSpecifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchDescribeMergeConflictsOutput struct {
	_ struct{} `type:"structure"`

	// The commit ID of the merge base.
	BaseCommitId *string `locationName:"baseCommitId" type:"string"`

	// A list of conflicts for each file, including the conflict metadata and the
	// hunks of the differences between the files.
	//
	// Conflicts is a required field
	Conflicts []Conflict `locationName:"conflicts" type:"list" required:"true"`

	// The commit ID of the destination commit specifier that was used in the merge
	// evaluation.
	//
	// DestinationCommitId is a required field
	DestinationCommitId *string `locationName:"destinationCommitId" type:"string" required:"true"`

	// A list of any errors returned while describing the merge conflicts for each
	// file.
	Errors []BatchDescribeMergeConflictsError `locationName:"errors" type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The commit ID of the source commit specifier that was used in the merge evaluation.
	//
	// SourceCommitId is a required field
	SourceCommitId *string `locationName:"sourceCommitId" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDescribeMergeConflictsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchDescribeMergeConflicts = "BatchDescribeMergeConflicts"

// BatchDescribeMergeConflictsRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Returns information about one or more merge conflicts in the attempted merge
// of two commit specifiers using the squash or three-way merge strategy.
//
//    // Example sending a request using BatchDescribeMergeConflictsRequest.
//    req := client.BatchDescribeMergeConflictsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts
func (c *Client) BatchDescribeMergeConflictsRequest(input *BatchDescribeMergeConflictsInput) BatchDescribeMergeConflictsRequest {
	op := &aws.Operation{
		Name:       opBatchDescribeMergeConflicts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDescribeMergeConflictsInput{}
	}

	req := c.newRequest(op, input, &BatchDescribeMergeConflictsOutput{})
	return BatchDescribeMergeConflictsRequest{Request: req, Input: input, Copy: c.BatchDescribeMergeConflictsRequest}
}

// BatchDescribeMergeConflictsRequest is the request type for the
// BatchDescribeMergeConflicts API operation.
type BatchDescribeMergeConflictsRequest struct {
	*aws.Request
	Input *BatchDescribeMergeConflictsInput
	Copy  func(*BatchDescribeMergeConflictsInput) BatchDescribeMergeConflictsRequest
}

// Send marshals and sends the BatchDescribeMergeConflicts API request.
func (r BatchDescribeMergeConflictsRequest) Send(ctx context.Context) (*BatchDescribeMergeConflictsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDescribeMergeConflictsResponse{
		BatchDescribeMergeConflictsOutput: r.Request.Data.(*BatchDescribeMergeConflictsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDescribeMergeConflictsResponse is the response type for the
// BatchDescribeMergeConflicts API operation.
type BatchDescribeMergeConflictsResponse struct {
	*BatchDescribeMergeConflictsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDescribeMergeConflicts request.
func (r *BatchDescribeMergeConflictsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
