"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Search = _interopRequireDefault(require("../Search"));

var _Search2 = _interopRequireDefault(require("../Search/Search.Skeleton"));

var _SearchFilterButton = _interopRequireDefault(require("../SearchFilterButton"));

var _SearchLayoutButton = _interopRequireDefault(require("../SearchLayoutButton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var props = function props() {
  return {
    className: 'some-class',
    small: (0, _addonKnobs.boolean)('Small UI (small)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    name: (0, _addonKnobs.text)('Form item name (name)', ''),
    value: (0, _addonKnobs.text)('Value (value)', ''),
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Search'),
    closeButtonLabelText: (0, _addonKnobs.text)('The label text for the close button (closeButtonLabelText)', ''),
    placeHolderText: (0, _addonKnobs.text)('Placeholder text (placeHolderText)', 'Search'),
    onChange: (0, _addonActions.action)('onChange')
  };
};

(0, _react2.storiesOf)('Search', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  return _react.default.createElement(_Search.default, _extends({}, props(), {
    id: "search-1"
  }));
}, {
  info: {
    text: "\n            Search enables users to specify a word or a phrase to find particular relevant pieces of content\n            without the use of navigation. Search can be used as the primary means of discovering content,\n            or as a filter to aid the user in finding content.\n          "
  }
}).add('custom buttons', function () {
  return _react.default.createElement("div", {
    style: {
      display: 'flex'
    }
  }, _react.default.createElement(_Search.default, _extends({}, props(), {
    id: "search-1"
  })), _react.default.createElement(_SearchFilterButton.default, {
    onClick: (0, _addonActions.action)('onClick')
  }), _react.default.createElement(_SearchLayoutButton.default, {
    onClick: (0, _addonActions.action)('onClick')
  }));
}, {
  info: {
    text: "\n            You can control what set of buttons you want.\n          "
  }
}).add('skeleton', function () {
  return _react.default.createElement("div", {
    style: {
      width: '200px'
    }
  }, _react.default.createElement(_Search2.default, null), "\xA0", _react.default.createElement(_Search2.default, {
    small: true
  }));
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});