## flatpickr - javascript datetime picker
[![Build Status](https://travis-ci.org/chmln/flatpickr.svg?branch=master)](https://travis-ci.org/chmln/flatpickr)

[![Coverage](https://coveralls.io/repos/github/chmln/flatpickr/badge.svg?branch=master)](https://coveralls.io/github/chmln/flatpickr)
[![npm version](https://badge.fury.io/js/flatpickr.svg)](https://www.npmjs.com/package/flatpickr)
![Bower version](https://badge.fury.io/bo/flatpickr-calendar.svg)
[![CDNJS](https://img.shields.io/cdnjs/v/flatpickr.svg)](https://cdnjs.com/libraries/flatpickr)
[![License](https://img.shields.io/badge/license-MIT-blue.svg?style=plastic)](https://raw.githubusercontent.com/chmln/flatpickr/master/LICENSE.md)


![blue](https://cloud.githubusercontent.com/assets/11352152/14549371/3cbb65da-028d-11e6-976d-a6f63f32061f.PNG)
![green](https://cloud.githubusercontent.com/assets/11352152/14549373/3cbe975a-028d-11e6-9192-43975f0146da.PNG)
![confetti](https://cloud.githubusercontent.com/assets/11352152/14549440/de9bf55e-028d-11e6-9271-46782a99efea.PNG)
![red](https://cloud.githubusercontent.com/assets/11352152/14549374/3cc01102-028d-11e6-9ff4-0cf208a310c4.PNG)
![default](https://cloud.githubusercontent.com/assets/11352152/14549370/3cadb750-028d-11e6-818d-c6a1bc6349fc.PNG)
![dark](https://cloud.githubusercontent.com/assets/11352152/14549372/3cbc8514-028d-11e6-8daf-ec1ba01c9d7e.PNG)


## Preamble
Almost every large SPA or project involves date and time input. There are limited options, however, if you also prefer to keep your projects lean and consequently stay away from heavy frameworks such as [jQuery](https://jsperf.com/jquery-vs-javascript-performance-comparison/22), or even Bootstrap.

Appalled at the fact that I have to load 300kb of jquery and jquery UI or hook up bootstrap just to use a calendar, I created this \[date\]\[time\]picker that's powerful, easy to use, and looks good out of the box.

Written in vanilla javascript, works with anything, anywhere.

![wew](https://cloud.githubusercontent.com/assets/11352152/14397836/d02d2f7c-fdad-11e5-9658-bedfb997ff52.png)

## Compatibility
IE9+, iOS Safari 6+, MS Edge, Chrome 8+, Firefox 6+

## Install & Use

Demos and documentation: https://chmln.github.io/flatpickr

See also:
* [React Component](https://github.com/coderhaoxin/react-flatpickr)
* [ember-flatpickr addon](https://www.npmjs.com/package/ember-flatpickr)
* [angular-flatpickr addon](https://www.npmjs.com/package/angular-flatpickr)
* [Vue-Blu/datepicker](https://chenz24.github.io/vue-blu/#/components/datepicker)

## Supporting flatpickr

Special thanks to support by:

- BrowserStack for providing indispensable testing utilities

  <a target="_blank" href="https://www.browserstack.com/">
    <img src="https://cloud.githubusercontent.com/assets/11352152/24872293/ec310d48-1dea-11e7-9d09-8120d5742fba.png">
  </a>

---

<a href="https://opencollective.com/flatpickr/backer/0/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/0/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/1/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/1/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/2/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/2/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/3/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/3/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/4/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/4/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/5/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/5/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/6/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/6/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/7/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/7/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/8/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/8/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/9/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/9/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/10/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/10/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/11/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/11/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/12/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/12/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/13/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/13/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/14/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/14/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/15/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/15/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/16/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/16/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/17/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/17/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/18/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/18/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/19/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/19/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/20/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/20/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/21/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/21/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/22/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/22/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/23/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/23/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/24/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/24/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/25/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/25/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/26/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/26/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/27/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/27/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/28/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/28/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/backer/29/website" target="_blank"><img src="https://opencollective.com/flatpickr/backer/29/avatar.svg"></a>

<a href="https://opencollective.com/flatpickr/sponsor/0/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/1/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/2/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/3/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/4/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/5/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/6/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/7/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/8/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/9/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/9/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/10/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/10/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/11/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/11/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/12/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/12/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/13/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/13/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/14/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/14/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/15/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/15/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/16/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/16/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/17/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/17/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/18/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/18/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/19/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/19/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/20/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/20/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/21/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/21/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/22/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/22/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/23/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/23/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/24/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/24/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/25/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/25/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/26/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/26/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/27/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/27/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/28/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/28/avatar.svg"></a>
<a href="https://opencollective.com/flatpickr/sponsor/29/website" target="_blank"><img src="https://opencollective.com/flatpickr/sponsor/29/avatar.svg"></a>

