(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', 'warning', '../../globals/js/settings', '../../globals/js/misc/mixin', '../../globals/js/mixins/create-component', '../../globals/js/mixins/init-component-by-search', '../../globals/js/mixins/handles', '../../globals/js/misc/event-matches', '../../globals/js/misc/on', '../../globals/js/misc/svg-toggle-class'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('warning'), require('../../globals/js/settings'), require('../../globals/js/misc/mixin'), require('../../globals/js/mixins/create-component'), require('../../globals/js/mixins/init-component-by-search'), require('../../globals/js/mixins/handles'), require('../../globals/js/misc/event-matches'), require('../../globals/js/misc/on'), require('../../globals/js/misc/svg-toggle-class'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.warning, global.settings, global.mixin, global.createComponent, global.initComponentBySearch, global.handles, global.eventMatches, global.on, global.svgToggleClass);
    global.interiorLeftNav = mod.exports;
  }
})(this, function (exports, _warning, _settings, _mixin2, _createComponent, _initComponentBySearch, _handles, _eventMatches, _on, _svgToggleClass) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _warning2 = _interopRequireDefault(_warning);

  var _settings2 = _interopRequireDefault(_settings);

  var _mixin3 = _interopRequireDefault(_mixin2);

  var _createComponent2 = _interopRequireDefault(_createComponent);

  var _initComponentBySearch2 = _interopRequireDefault(_initComponentBySearch);

  var _handles2 = _interopRequireDefault(_handles);

  var _eventMatches2 = _interopRequireDefault(_eventMatches);

  var _on2 = _interopRequireDefault(_on);

  var _svgToggleClass2 = _interopRequireDefault(_svgToggleClass);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _toConsumableArray(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }

      return arr2;
    } else {
      return Array.from(arr);
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  var didWarnAboutDeprecation = false;

  var InteriorLeftNav = function (_mixin) {
    _inherits(InteriorLeftNav, _mixin);

    /**
     * Interior left nav.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as an interior left nav.
     * @param {Object} options The component options.
     */
    function InteriorLeftNav(element, options) {
      _classCallCheck(this, InteriorLeftNav);

      var _this = _possibleConstructorReturn(this, (InteriorLeftNav.__proto__ || Object.getPrototypeOf(InteriorLeftNav)).call(this, element, options));

      _this.hookListItemsEvents = function () {
        _this.manage((0, _on2.default)(_this.element, 'click', function (evt) {
          var leftNavItem = (0, _eventMatches2.default)(evt, _this.options.selectorLeftNavListItem);
          var collapseEl = (0, _eventMatches2.default)(evt, _this.options.selectorLeftNavCollapse);
          var collapsedBar = (0, _eventMatches2.default)(evt, '.' + _this.options.classLeftNavCollapsed);

          if (leftNavItem) {
            var childItem = (0, _eventMatches2.default)(evt, _this.options.selectorLeftNavNestedListItem);
            var hasChildren = leftNavItem.classList.contains('left-nav-list__item--has-children');
            if (childItem) {
              _this.addActiveListItem(childItem);
            } else if (hasChildren) {
              _this.handleNestedListClick(leftNavItem, evt);
            } else {
              _this.addActiveListItem(leftNavItem);
            }
          }

          if (collapseEl || collapsedBar) {
            evt.preventDefault();
            _this.toggleLeftNav();
          }
        }));

        _this.manage((0, _on2.default)(_this.element, 'keydown', function (evt) {
          var leftNavItemWithChildren = (0, _eventMatches2.default)(evt, _this.options.selectorLeftNavListItemHasChildren);
          var leftNavItem = (0, _eventMatches2.default)(evt, _this.options.selectorLeftNavListItem);

          if (leftNavItemWithChildren && evt.which === 13) {
            _this.handleNestedListClick(leftNavItemWithChildren, evt);
          } else if (leftNavItem && evt.which === 13) {
            _this.addActiveListItem(leftNavItem);
          }
        }));
      };

      _this.toggleLeftNav = function () {
        var collapsed = _this.element.dataset.collapsed === 'true';
        var eventStart = new CustomEvent(_this.options.eventBeforeLeftNavToggled, {
          bubbles: true,
          cancelable: true,
          detail: { collapsed: !collapsed } // shows where the toggle is going, not where it is
        });

        if (_this.element.dispatchEvent(eventStart)) {
          var svgTitle = _this.element.querySelector(_this.options.selectorLeftNavArrowTitle);
          if (!collapsed) {
            _this.element.dataset.collapsed = true;
            _this.element.classList.add(_this.options.classLeftNavCollapsing);
            if (svgTitle) {
              svgTitle.textContent = _this.options.expandTitle;
            }
            window.setTimeout(function () {
              _this.element.classList.remove(_this.options.classLeftNavCollapsing);
              _this.element.classList.add(_this.options.classLeftNavCollapsed);
              _this.element.dispatchEvent(new CustomEvent(_this.options.eventAfterLeftNavToggled, {
                bubbles: true,
                cancelable: true,
                detail: { collapsed: true }
              }));
            }, 250);
          } else {
            _this.element.dataset.collapsed = false;
            _this.element.classList.remove(_this.options.classLeftNavCollapsed);
            _this.element.classList.add(_this.options.classLeftNavExpanding);
            if (svgTitle) {
              svgTitle.textContent = _this.options.collapsePane;
            }
            window.setTimeout(function () {
              _this.element.classList.remove(_this.options.classLeftNavExpanding);
              _this.element.dispatchEvent(new CustomEvent(_this.options.eventAfterLeftNavToggled, {
                bubbles: true,
                cancelable: true,
                detail: { collapsed: false }
              }));
            }, 250);
          }
        }
      };

      _this.constructor.components.set(_this.element, _this);

      _this.keepOpen = _this.element.dataset.keepOpen === undefined ? _this.options.keepOpen : Boolean(_this.element.dataset.keepOpen);

      _this.hookListItemsEvents();
      if (process.env.NODE_ENV !== 'production') {
        process.env.NODE_ENV !== 'production' ? (0, _warning2.default)(didWarnAboutDeprecation, 'Accessing the `interior-left-nav` component from the' + '`carbon-components` package is deprecated. Use the' + '`carbon-addons-cloud` package instead.') : void 0;
        didWarnAboutDeprecation = true;
      }
      return _this;
    }

    _createClass(InteriorLeftNav, [{
      key: 'addActiveListItem',
      value: function addActiveListItem(item) {
        var _this2 = this;

        [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavListItem))).forEach(function (currentItem) {
          if (!(item === currentItem)) {
            currentItem.classList.remove(_this2.options.classActiveLeftNavListItem);
          }
        });
        [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavNestedListItem))).forEach(function (currentItem) {
          if (!(item === currentItem)) {
            currentItem.classList.remove(_this2.options.classActiveLeftNavListItem);
          }
        });
        item.classList.add(this.options.classActiveLeftNavListItem);
      }
    }, {
      key: 'handleNestedListClick',
      value: function handleNestedListClick(listItem, evt) {
        var _this3 = this;

        var allNestedItems = [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavListItemHasChildren)));
        var isOpen = listItem.classList.contains(this.options.classExpandedLeftNavListItem);
        var list = listItem.querySelector(this.options.selectorLeftNavNestedList);
        var listItems = [].concat(_toConsumableArray(list.querySelectorAll(this.options.selectorLeftNavNestedListItem)));

        if (!this.keepOpen) {
          allNestedItems.forEach(function (currentItem) {
            if (currentItem !== listItem) {
              (0, _svgToggleClass2.default)(currentItem, _this3.options.classExpandedLeftNavListItem, false);
            }
          });
        }

        if (!('InteriorLeftNavItemLink' in evt.target.dataset)) {
          (0, _svgToggleClass2.default)(listItem, this.options.classExpandedLeftNavListItem, !isOpen);
        }

        // a11y
        listItems.forEach(function (item) {
          if (isOpen) {
            // eslint-disable-next-line no-param-reassign
            item.querySelector(_this3.options.selectorLeftNavListItemLink).tabIndex = -1;
          } else {
            // eslint-disable-next-line no-param-reassign
            item.querySelector(_this3.options.selectorLeftNavListItemLink).tabIndex = 0;
          }
        });
      }
    }], [{
      key: 'options',
      get: function get() {
        var prefix = _settings2.default.prefix;

        return {
          selectorInit: '[data-interior-left-nav]',
          // Data Attribute selectors
          selectorLeftNavList: '[data-interior-left-nav-list]',
          selectorLeftNavNestedList: '[data-interior-left-nav-nested-list]',
          selectorLeftNavListItem: '[data-interior-left-nav-item]',
          selectorLeftNavListItemLink: '[data-interior-left-nav-item-link]',
          selectorLeftNavNestedListItem: '[data-interior-left-nav-nested-item]',
          selectorLeftNavListItemHasChildren: '[data-interior-left-nav-with-children]',
          selectorLeftNavCollapse: '[data-interior-left-nav-collapse]',
          selectorLeftNavArrowTitle: '[data-interior-left-nav-arrow] title',
          // CSS Class Selectors
          classActiveLeftNavListItem: 'left-nav-list__item--active',
          classExpandedLeftNavListItem: 'left-nav-list__item--expanded',
          classLeftNavCollapsing: prefix + '--interior-left-nav--collapsing',
          classLeftNavCollapsed: prefix + '--interior-left-nav--collapsed',
          classLeftNavExpanding: prefix + '--interior-left-nav--expanding',
          // Event
          eventBeforeLeftNavToggled: 'left-nav-beingtoggled',
          eventAfterLeftNavToggled: 'left-nav-toggled',
          // Option
          expandTitle: 'Expand nav pane',
          collapseTitle: 'Collapse nav pane',
          keepOpen: false
        };
      }
    }]);

    return InteriorLeftNav;
  }((0, _mixin3.default)(_createComponent2.default, _initComponentBySearch2.default, _handles2.default));

  InteriorLeftNav.components = new WeakMap();
  exports.default = InteriorLeftNav;
});