(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(['exports', 'warning', 'lodash.debounce', '../../globals/js/settings', '../../globals/js/misc/mixin', '../../globals/js/mixins/create-component', '../../globals/js/mixins/init-component-by-search', '../../globals/js/mixins/handles', '../../globals/js/misc/on'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require('warning'), require('lodash.debounce'), require('../../globals/js/settings'), require('../../globals/js/misc/mixin'), require('../../globals/js/mixins/create-component'), require('../../globals/js/mixins/init-component-by-search'), require('../../globals/js/mixins/handles'), require('../../globals/js/misc/on'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.warning, global.lodash, global.settings, global.mixin, global.createComponent, global.initComponentBySearch, global.handles, global.on);
    global.detailPageHeader = mod.exports;
  }
})(this, function (exports, _warning, _lodash, _settings, _mixin2, _createComponent, _initComponentBySearch, _handles, _on) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });

  var _warning2 = _interopRequireDefault(_warning);

  var _lodash2 = _interopRequireDefault(_lodash);

  var _settings2 = _interopRequireDefault(_settings);

  var _mixin3 = _interopRequireDefault(_mixin2);

  var _createComponent2 = _interopRequireDefault(_createComponent);

  var _initComponentBySearch2 = _interopRequireDefault(_initComponentBySearch);

  var _handles2 = _interopRequireDefault(_handles);

  var _on2 = _interopRequireDefault(_on);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  var didWarnAboutDeprecation = false;

  var DetailPageHeader = function (_mixin) {
    _inherits(DetailPageHeader, _mixin);

    /**
     * The Detail Page Header.
     * @extends CreateComponent
     * @extends InitComponentBySearch
     * @extends Handles
     * @param {HTMLElement} element The element working as a page header.
     * @param {Object} [options] The component options.
     */
    function DetailPageHeader(element, options) {
      _classCallCheck(this, DetailPageHeader);

      var _this = _possibleConstructorReturn(this, (DetailPageHeader.__proto__ || Object.getPrototypeOf(DetailPageHeader)).call(this, element, options));

      _this.previousScrollY = 0;
      // Debounce scroll event calls to handleScroll (default: 50)
      var debouncedScroll = (0, _lodash2.default)(_this._handleScroll.bind(_this), 25);
      _this.manage((0, _on2.default)(_this.element.ownerDocument.defaultView, 'scroll', debouncedScroll));
      if (process.env.NODE_ENV !== 'production') {
        process.env.NODE_ENV !== 'production' ? (0, _warning2.default)(didWarnAboutDeprecation, 'Accessing the `detail-page-header` component from the ' + '`carbon-components` package is deprecated. Use the ' + '`carbon-addons-cloud` package instead.') : void 0;
        didWarnAboutDeprecation = true;
      }
      return _this;
    }

    /**
     * Adds class to header based on users position on the page
     */


    _createClass(DetailPageHeader, [{
      key: '_handleScroll',
      value: function _handleScroll() {
        var scrollPosition = void 0;
        if (this.element.ownerDocument.defaultView.pageYOffset) {
          scrollPosition = this.element.ownerDocument.defaultView.pageYOffset;
        } else {
          scrollPosition = this.element.ownerDocument.defaultView.pageYOffset;
        }

        if (scrollPosition > 86) {
          this.element.dataset.headerActive = true;
          if (scrollPosition < this.previousScrollY) {
            this.element.classList.remove(this.options.scroll);
          } else {
            this.element.classList.add(this.options.scroll);
          }
        } else {
          this.element.classList.remove(this.options.scroll);
          this.element.dataset.headerActive = false;
        }

        this.previousScrollY = scrollPosition;
      }
    }], [{
      key: 'options',
      get: function get() {
        var prefix = _settings2.default.prefix;

        return {
          selectorInit: '[data-detail-page-header]',
          scroll: prefix + '--detail-page-header--scroll'
        };
      }
    }]);

    return DetailPageHeader;
  }((0, _mixin3.default)(_createComponent2.default, _initComponentBySearch2.default, _handles2.default));

  DetailPageHeader.components = new WeakMap();
  exports.default = DetailPageHeader;
});