'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TimePicker = require('../TimePicker');

var _TimePicker2 = _interopRequireDefault(_TimePicker);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('TimePicker', function () {
  describe('renders as expected', function () {
    describe('input', function () {
      var wrapper = void 0;
      var timePicker = void 0;
      var textInput = void 0;

      beforeEach(function () {
        wrapper = (0, _enzyme.mount)(_react2.default.createElement(_TimePicker2.default, { id: 'test', className: 'extra-class' }));

        timePicker = function timePicker() {
          return wrapper.find('.bx--time-picker');
        };
        textInput = function textInput() {
          return wrapper.find('input');
        };
      });

      it('renders as expected', function () {
        expect(textInput().length).toBe(1);
      });

      it('should add extra classes that are passed via className', function () {
        expect(timePicker().hasClass('extra-class')).toEqual(true);
      });

      it('should set type as expected', function () {
        expect(textInput().props().type).toEqual('text');
      });

      it('should set value as expected', function () {
        expect(textInput().props().defaultValue).toEqual(undefined);
        wrapper.setProps({ defaultValue: 'test' });
        expect(textInput().props().defaultValue).toEqual('test');
      });

      it('should set disabled as expected', function () {
        expect(textInput().props().disabled).toEqual(false);
        wrapper.setProps({ disabled: true });
        expect(textInput().props().disabled).toEqual(true);
      });

      it('should set placeholder as expected', function () {
        wrapper.setProps({ placeholder: 'ss:mm' });
        expect(textInput().props().placeholder).toEqual('ss:mm');
      });
    });

    describe('label', function () {
      var wrapper = void 0;
      var label = void 0;

      beforeEach(function () {
        wrapper = (0, _enzyme.mount)(_react2.default.createElement(_TimePicker2.default, { id: 'test', className: 'extra-class' }));

        label = function label() {
          return wrapper.find('label');
        };
      });

      it('does not render a label by default', function () {
        expect(label().length).toBe(0);
      });

      it('renders a label', function () {
        wrapper.setProps({ labelText: 'Enter a time' });
        var renderedlabel = wrapper.find('label');
        expect(renderedlabel.length).toBe(1);
      });

      it('has the expected classes', function () {
        wrapper.setProps({ labelText: 'Enter a time' });
        var renderedlabel = wrapper.find('label');
        expect(renderedlabel.hasClass('bx--label')).toEqual(true);
      });

      it('should set label as expected', function () {
        wrapper.setProps({ labelText: 'Enter a time' });
        var renderedlabel = wrapper.find('label');
        expect(renderedlabel.text()).toEqual('Enter a time');
      });
    });
  });

  describe('events', function () {
    describe('disabled time picker', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();

      var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_TimePicker2.default, { id: 'test', onClick: onClick, onChange: onChange, disabled: true }));

      var input = wrapper.find('input');

      it('should not invoke onClick', function () {
        input.simulate('click');
        expect(onClick).not.toBeCalled();
      });

      it('should not invoke onChange', function () {
        input.simulate('change');
        expect(onChange).not.toBeCalled();
      });
    });

    describe('enabled textinput', function () {
      var onClick = jest.fn();
      var onChange = jest.fn();
      var onBlur = jest.fn();

      var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_TimePicker2.default, {
        id: 'test',
        onClick: onClick,
        onChange: onChange,
        onBlur: onBlur
      }));

      var input = wrapper.find('input');
      var eventObject = {
        target: {
          defaultValue: 'test'
        }
      };

      it('should invoke onBlur when input is clicked', function () {
        input.simulate('blur', eventObject);
        expect(onBlur).toBeCalledWith(eventObject);
      });

      it('should invoke onClick when input is clicked', function () {
        input.simulate('click', eventObject);
        expect(onClick).toBeCalledWith(eventObject);
      });

      it('should invoke onChange when input value is changed', function () {
        input.simulate('change', eventObject);
        expect(onChange).toBeCalledWith(eventObject);
      });
    });
  });
});