'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Tile = require('../Tile');

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Tile', function () {
  describe('Renders default tile as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _Tile.Tile,
      { className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--tile')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });

  describe('Renders clickable tile as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _Tile.ClickableTile,
      { className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    beforeEach(function () {
      wrapper.state().clicked = false;
    });

    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--tile--clickable')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('toggles the clickable class on click', function () {
      expect(wrapper.hasClass('bx--tile--is-clicked')).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.hasClass('bx--tile--is-clicked')).toEqual(true);
    });

    it('toggles the clickable state on click', function () {
      expect(wrapper.state().clicked).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.state().clicked).toEqual(true);
    });

    it('toggles the clicked state when using enter or space', function () {
      expect(wrapper.state().clicked).toEqual(false);
      wrapper.simulate('keydown', { which: 32 });
      expect(wrapper.state().clicked).toEqual(true);
      wrapper.simulate('keydown', { which: 13 });
      expect(wrapper.state().clicked).toEqual(false);
    });
  });

  describe('Renders selectable tile as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Tile.SelectableTile,
      { className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    beforeEach(function () {
      wrapper.state().selected = false;
    });

    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.children().hasClass('bx--tile--selectable')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('toggles the selectable class on click', function () {
      expect(wrapper.children().hasClass('bx--tile--is-selected')).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.children().hasClass('bx--tile--is-selected')).toEqual(true);
    });

    it('toggles the selectable state on click', function () {
      expect(wrapper.state().selected).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.state().selected).toEqual(true);
    });

    it('toggles the selectable state when using enter or space', function () {
      expect(wrapper.state().selected).toEqual(false);
      wrapper.simulate('keydown', { which: 32 });
      expect(wrapper.state().selected).toEqual(true);
      wrapper.simulate('keydown', { which: 13 });
      expect(wrapper.state().selected).toEqual(false);
    });

    it('the input should be checked when state is selected', function () {
      wrapper.setState({ selected: true });
      expect(wrapper.find('input').props().checked).toEqual(true);
    });
  });

  describe('Renders expandable tile as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Tile.ExpandableTile,
      { className: 'extra-class' },
      _react2.default.createElement(
        _Tile.TileAboveTheFoldContent,
        { className: 'child' },
        _react2.default.createElement(
          'div',
          { style: { height: '200px' } },
          'Test'
        )
      ),
      _react2.default.createElement(
        _Tile.TileBelowTheFoldContent,
        { className: 'child' },
        _react2.default.createElement(
          'div',
          { style: { height: '500px' } },
          'Test'
        )
      )
    ));

    beforeEach(function () {
      wrapper.state().expanded = false;
    });

    it('renders children as expected', function () {
      expect(wrapper.props().children.length).toBe(2);
    });

    it('has the expected classes', function () {
      expect(wrapper.children().hasClass('bx--tile--expandable')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('toggles the expandable class on click', function () {
      expect(wrapper.children().hasClass('bx--tile--is-expanded')).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.children().hasClass('bx--tile--is-expanded')).toEqual(true);
    });

    it('toggles the expandable state on click', function () {
      expect(wrapper.state().expanded).toEqual(false);
      wrapper.simulate('click');
      expect(wrapper.state().expanded).toEqual(true);
    });
  });
});