'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Tabs = require('../Tabs');

var _Tabs2 = _interopRequireDefault(_Tabs);

var _Tab = require('../Tab');

var _Tab2 = _interopRequireDefault(_Tab);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var props = {
  tabs: {
    className: 'some-class',
    triggerHref: '#anotherAnchor'
  },
  tab: {
    className: 'another-class',
    onClick: (0, _addonActions.action)('onClick'),
    onKeyDown: (0, _addonActions.action)('onKeyDown')
  }
};

(0, _react3.storiesOf)('Tabs', module).addWithInfo('Default', '\n      Tabs are used to quickly navigate between views within the same context. Create individual\n      Tab components for each item in the Tabs list.\n    ', function () {
  return _react2.default.createElement(
    _Tabs2.default,
    props.tabs,
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 1' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for first tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 2' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for second tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 3' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for third tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 4' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for fourth tab goes here.'
      )
    )
  );
}).addWithInfo('Selected Example', '\n      By using the selected prop on the Tabs component, you can switch which Tab gets\n      rendered by default\n    ', function () {
  return _react2.default.createElement(
    _Tabs2.default,
    _extends({}, props.tabs, { selected: 3 }),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 1' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for first tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 2' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for second tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 3' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'Content for third tab goes here.'
      )
    ),
    _react2.default.createElement(
      _Tab2.default,
      _extends({}, props.tab, { label: 'Tab label 4' }),
      _react2.default.createElement(
        'div',
        { className: 'some-content' },
        'ontent for fourth tab goes here.'
      )
    )
  );
});