'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SelectItemGroup = require('../SelectItemGroup');

var _SelectItemGroup2 = _interopRequireDefault(_SelectItemGroup);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('SelectItemGroup', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(_SelectItemGroup2.default, { className: 'extra-class', label: 'test' }));

    it('should have the expected classes', function () {
      expect(wrapper.hasClass('bx--select-optgroup')).toEqual(true);
    });

    it('Should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('Should add the label that is passed', function () {
      wrapper.setProps({ label: 'placeholder-item' });
      expect(wrapper.props().label).toEqual('placeholder-item');
    });

    it('Should not be disabled by default', function () {
      expect(wrapper.props().disabled).toEqual(false);
    });

    it('should set disabled as expected', function () {
      expect(wrapper.props().disabled).toEqual(false);
      wrapper.setProps({ disabled: true });
      expect(wrapper.props().disabled).toEqual(true);
    });
  });
});