'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _OrderSummary = require('../OrderSummary');

var _Link = require('../Link');

var _Link2 = _interopRequireDefault(_Link);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('OrderSummaryFooter', function () {
  describe('Renders as expected', function () {
    var orderSummaryFooter = (0, _enzyme.mount)(_react2.default.createElement(_OrderSummary.OrderSummaryFooter, {
      className: 'some-class',
      footerText: 'Need Help?',
      linkText: 'Contact Bluemix Sales',
      href: 'www.google.com'
    }));

    it('renders Order Summary Footer', function () {
      expect(orderSummaryFooter.length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(orderSummaryFooter.children().hasClass('bx--order-footer')).toEqual(true);
      expect(orderSummaryFooter.children().hasClass('some-class')).toEqual(true);
    });

    it('should render with the correct footer text', function () {
      expect(orderSummaryFooter.find('.bx--order-footer-text').text()).toEqual('Need Help?');
    });

    it('should pass down the correct link props', function () {
      expect(orderSummaryFooter.props().linkText).toEqual('Contact Bluemix Sales');
      expect(orderSummaryFooter.props().href).toEqual('www.google.com');
      expect(orderSummaryFooter.props().target).toEqual('_blank');
      expect(orderSummaryFooter.props().rel).toEqual('noreferrer noopener');
    });

    it('should render children as expected', function () {
      expect(orderSummaryFooter.find(_Link2.default).length).toEqual(1);
    });
  });
});