'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _NumberInput = require('../NumberInput');

var _NumberInput2 = _interopRequireDefault(_NumberInput);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var numberInputProps = {
  className: 'some-class',
  id: 'tj-input',
  label: 'Number Input label',
  onChange: (0, _addonActions.action)('onChange'),
  onClick: (0, _addonActions.action)('onClick'),
  min: 0,
  max: 100,
  value: 50,
  step: 10,
  invalidText: 'Number is not valid'
};

var introText = '\n  Number inputs are similar to text fields, but contain controls used to increase or decrease an incremental value. The Number Input component can be passed a starting value, a min, a max, and the step.\n';

(0, _react3.storiesOf)('NumberInput', module).addWithInfo('enabled', '\n      ' + introText + '\n      The example below shows an enabled Number Input component.\n    ', function () {
  return _react2.default.createElement(_NumberInput2.default, numberInputProps);
}).addWithInfo('disabled', '\n      ' + introText + '\n      The example below shows an disabled Number Input component.\n    ', function () {
  return _react2.default.createElement(_NumberInput2.default, _extends({ disabled: true }, numberInputProps));
}).addWithInfo('invalid', '\n      ' + introText + '\n      The example below shows an disabled Number Input component.\n    ', function () {
  return _react2.default.createElement(_NumberInput2.default, _extends({}, numberInputProps, { invalid: true }));
});