'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Loading = require('../Loading');

var _Loading2 = _interopRequireDefault(_Loading);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Loading', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Loading2.default, { className: 'extra-class' }));
    var overlay = wrapper.find('.bx--loading-overlay');
    var loader = wrapper.find('.bx--loading');
    var svg = loader.find('svg');

    it('should render with an overlay', function () {
      expect(overlay.length).toEqual(1);
    });

    it('should render with a loader', function () {
      expect(loader.length).toEqual(1);
    });

    it('shoud render an svg', function () {
      expect(svg.length).toEqual(1);
    });

    it('overlay has the expected class', function () {
      expect(overlay.hasClass('bx--loading-overlay')).toEqual(true);
    });

    it('loader has the expected classes', function () {
      expect(loader.hasClass('bx--loading')).toEqual(true);
    });

    it('svg has the correct class', function () {
      expect(svg.hasClass('bx--loading__svg')).toEqual(true);
    });

    it('should add extra classes that are passed via className', function () {
      expect(loader.hasClass('extra-class')).toEqual(true);
    });
  });

  describe('Sets props and state as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Loading2.default, { className: 'extra-class' }));

    it('should remove and add bx--loading--stop class', function () {
      wrapper.setProps({ active: false });
      expect(wrapper.find('.bx--loading').hasClass('bx--loading--stop')).toEqual(true);
      wrapper.setProps({ active: true });
      expect(wrapper.find('.bx--loading').hasClass('bx--loading--stop')).toEqual(false);
    });

    it('should not render overlay when withOverlay is set to false', function () {
      wrapper.setProps({ withOverlay: false });
      var overlay = wrapper.find('.bx--loading-overlay');
      expect(overlay.length).toEqual(0);
    });
  });
});