'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _InteriorLeftNav = require('../InteriorLeftNav');

var _InteriorLeftNav2 = _interopRequireDefault(_InteriorLeftNav);

var _InteriorLeftNavList = require('../InteriorLeftNavList');

var _InteriorLeftNavList2 = _interopRequireDefault(_InteriorLeftNavList);

var _InteriorLeftNavItem = require('../InteriorLeftNavItem');

var _InteriorLeftNavItem2 = _interopRequireDefault(_InteriorLeftNavItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('InteriorLeftNav', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_InteriorLeftNav2.default, { className: 'extra-class' }));

    it('renders a interior left nav', function () {
      expect(wrapper.length).toEqual(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.children().hasClass('bx--interior-left-nav')).toEqual(true);
    });

    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    it('should render children as expected', function () {
      var interiorLeftNav = (0, _enzyme.mount)(_react2.default.createElement(
        _InteriorLeftNav2.default,
        null,
        _react2.default.createElement(_InteriorLeftNavList2.default, { className: 'test-child' }),
        _react2.default.createElement(
          _InteriorLeftNavItem2.default,
          {
            href: '',
            title: 'test-title',
            className: 'test-child' },
          _react2.default.createElement(
            'a',
            { href: 'http://www.carbondesignsystem.com' },
            'test-title'
          )
        )
      ));
      expect(interiorLeftNav.find('.left-nav-list').length).toEqual(2);
      expect(interiorLeftNav.find('.test-child').length).toEqual(4);
      expect(interiorLeftNav.find('.bx--interior-left-nav-collapse').length).toEqual(1);
    });
  });

  describe('clicking on one list should close any currently opened lists', function () {
    var twoLists = (0, _enzyme.mount)(_react2.default.createElement(
      _InteriorLeftNav2.default,
      null,
      _react2.default.createElement(_InteriorLeftNavList2.default, { className: 'first' }),
      _react2.default.createElement(_InteriorLeftNavList2.default, { className: 'second', open: true })
    ));
    var first = function first() {
      return twoLists.find('li.first');
    };
    var second = function second() {
      return twoLists.find('li.second');
    };

    it('should close the second list when the first is clicked', function () {
      expect(second().hasClass('left-nav-list__item--expanded')).toBe(true);
      first().simulate('click');
      expect(second().hasClass('left-nav-list__item--expanded')).toBe(false);
    });
  });

  describe('actions', function () {
    var interiorLeftNav = (0, _enzyme.mount)(_react2.default.createElement(
      _InteriorLeftNav2.default,
      null,
      _react2.default.createElement(_InteriorLeftNavList2.default, null),
      _react2.default.createElement(
        _InteriorLeftNavItem2.default,
        null,
        _react2.default.createElement(
          'a',
          { href: '#first' },
          'test-title'
        )
      )
    ));

    var item = interiorLeftNav.find(_InteriorLeftNavItem2.default).first();
    var toggler = interiorLeftNav.find('.bx--interior-left-nav-collapse').first();

    it('handles item click as expected', function () {
      interiorLeftNav.setState({ activeHref: '#' });
      item.simulate('click');
      expect(interiorLeftNav.state().activeHref).toEqual('#first');
    });

    it('should set activeHref to items href on Enter', function () {
      interiorLeftNav.setState({ activeHref: '#' });
      item.simulate('keypress', { which: 13 });
      expect(interiorLeftNav.state().activeHref).toEqual('#first');
    });

    it('should set activeHref to items href on Space', function () {
      interiorLeftNav.setState({ activeHref: '#' });
      item.simulate('keypress', { which: 32 });
      expect(interiorLeftNav.state().activeHref).toEqual('#first');
    });

    it('should close the nav when the toggler is clicked', function () {
      toggler.simulate('click');
      expect(interiorLeftNav.children().hasClass('bx--interior-left-nav--collapsed')).toBe(true);
      expect(interiorLeftNav.state().open).toBe(false);
    });
  });

  describe('check accordion behaviour', function () {
    var twoLists = (0, _enzyme.mount)(_react2.default.createElement(
      _InteriorLeftNav2.default,
      null,
      _react2.default.createElement(_InteriorLeftNavList2.default, { className: 'first', isExpanded: true }),
      _react2.default.createElement(_InteriorLeftNavList2.default, { className: 'second', isExpanded: true, open: true })
    ));

    var first = function first() {
      return twoLists.find('li.first');
    };
    var second = function second() {
      return twoLists.find('li.second');
    };

    it('should keep the second list open when the first is clicked', function () {
      expect(first().hasClass('left-nav-list__item--expanded')).toBe(false);
      expect(second().hasClass('left-nav-list__item--expanded')).toBe(true);
      first().simulate('click');
      expect(first().hasClass('left-nav-list__item--expanded')).toBe(true);
      expect(second().hasClass('left-nav-list__item--expanded')).toBe(true);
    });
  });
});