'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _DataTableRow = require('../DataTableRow');

var _DataTableRow2 = _interopRequireDefault(_DataTableRow);

var _DataTableData = require('../DataTableData');

var _DataTableData2 = _interopRequireDefault(_DataTableData);

var _DataTable = require('../DataTable');

var _PaginationV = require('../PaginationV2');

var _PaginationV2 = _interopRequireDefault(_PaginationV);

var _Button = require('../Button');

var _Button2 = _interopRequireDefault(_Button);

var _OverflowMenu = require('../OverflowMenu');

var _OverflowMenu2 = _interopRequireDefault(_OverflowMenu);

var _OverflowMenuItem = require('../OverflowMenuItem');

var _OverflowMenuItem2 = _interopRequireDefault(_OverflowMenuItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var paginationProps = {
  pageSizes: [10, 20, 30, 40, 50]
};

var initialRows = [{
  name: 'Load Balancer 3',
  protocol: 'HTTP',
  something: '80',
  rule: 'Round Robin',
  attached_groups: 'Kevins VM Groups',
  status: 'Active'
}, {
  name: 'Load Balancer 1',
  protocol: 'HTTP',
  something: '80',
  rule: 'Round Robin',
  attached_groups: 'Maureens VM Groups',
  status: 'Active'
}, {
  name: 'Load Balancer 2',
  protocol: 'HTTP',
  something: '80',
  rule: 'Round Robin',
  attached_groups: 'Andrews VM Groups',
  status: 'Active'
}];

var initialExpandedRows = [{
  rowContent: {
    name: 'Load Balancer 3',
    protocol: 'HTTP',
    something: '80',
    rule: 'Round Robin',
    attached_groups: 'Kevins VM Groups',
    status: 'Active'
  },
  expandedRowContent: {
    html: '<div>\n      <h1>Expandable Row Content 1</h1>\n      <p>Description here.</p>\n    </div>'
  }
}, {
  rowContent: {
    name: 'Load Balancer 1',
    protocol: 'HTTP',
    something: '80',
    rule: 'Round Robin',
    attached_groups: 'Maureens VM Groups',
    status: 'Active'
  },
  expandedRowContent: {
    html: '<div>\n      <h1>Expandable Row Content 2</h1>\n      <p>Description here.</p>\n    </div>'
  }
}, {
  rowContent: {
    name: 'Load Balancer 2',
    protocol: 'HTTP',
    something: '80',
    rule: 'Round Robin',
    attached_groups: 'Andrews VM Groups',
    status: 'Active'
  },
  expandedRowContent: {
    html: '<div>\n      <h1>Expandable Row Content 3</h1>\n      <p>Description here.</p>\n    </div>'
  }
}];

var headers = Object.keys(initialRows[0]).map(function (key) {
  return {
    key: key,
    title: key.charAt(0).toUpperCase() + key.substring(1)
  };
});

var BasicDataTable = function (_Component) {
  _inherits(BasicDataTable, _Component);

  function BasicDataTable(props) {
    _classCallCheck(this, BasicDataTable);

    var _this = _possibleConstructorReturn(this, (BasicDataTable.__proto__ || Object.getPrototypeOf(BasicDataTable)).call(this, props));

    _this.selectAll = function () {
      var checked = _this.state.checked;
      _this.state.rows.forEach(function (row, index) {
        if (_this.state.selectAll) {
          checked[index] = false;
        } else {
          checked[index] = true;
        }
      });
      _this.setState({
        checked: checked,
        selectAll: !_this.state.selectAll
      });
    };

    _this.selectRow = function (index) {
      var checked = _this.state.checked;
      checked[index] = checked[index] ? !checked[index] : true;
      _this.setState({
        checked: checked,
        selectAll: checked[index] === false ? false : _this.state.selectAll
      });
    };

    _this.clearAll = function () {
      var checked = _this.state.checked;
      _this.state.rows.forEach(function (row, index) {
        checked[index] = checked[index] ? !checked[index] : false;
      });
      _this.setState({
        checked: checked,
        selectAll: false
      });
    };

    _this.getCheckedItems = function () {
      var checked = _this.state.checked;
      var checkedItems = 0;
      checked.forEach(function (entry) {
        if (entry) {
          checkedItems++;
        }
      });
      return checkedItems;
    };

    _this.searchTable = function (evt) {
      var newRows = [];
      _this.state.rows.map(function (obj) {
        Object.keys(obj).forEach(function (key) {
          if (obj[key].toUpperCase().includes(evt.currentTarget.value.toUpperCase()) && !newRows.includes(obj)) {
            newRows.push(obj);
          }
        });
      });
      _this.setState({
        filteredRows: newRows
      });
    };

    _this.state = {
      checked: [],
      selectAll: false,
      rows: _this.props.rows,
      filteredRows: _this.props.rows
    };
    return _this;
  }

  _createClass(BasicDataTable, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var checkedItems = this.getCheckedItems();
      var showBatchActions = checkedItems > 0;
      var tableClasses = (0, _classnames2.default)({
        'bx--data-table-v2': true,
        'bx--data-table-v2--zebra': this.props.zebra
      });
      var isSelectable = this.props.isSelectable;

      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          _DataTable.DataTableContainer,
          { title: 'Table title' },
          _react2.default.createElement(
            _DataTable.DataTableToolbar,
            null,
            _react2.default.createElement(
              _DataTable.DataTableBatchActions,
              {
                totalSelected: checkedItems,
                showBatchActions: showBatchActions,
                handleClick: this.clearAll },
              _react2.default.createElement(
                _DataTable.DataTableActionList,
                null,
                _react2.default.createElement(
                  _DataTable.DataTableBatchAction,
                  { onClick: (0, _addonActions.action)('Batch Action 1') },
                  'Ghost'
                ),
                _react2.default.createElement(
                  _DataTable.DataTableBatchAction,
                  { onClick: (0, _addonActions.action)('Batch Action 2') },
                  'Ghost'
                ),
                _react2.default.createElement(
                  _DataTable.DataTableBatchAction,
                  { onClick: (0, _addonActions.action)('Batch Action 3') },
                  'Ghost'
                )
              )
            ),
            _react2.default.createElement(_DataTable.DataTableSearch, {
              onInput: this.searchTable,
              onChange: this.searchTable
            }),
            _react2.default.createElement(
              _DataTable.DataTableToolbarContent,
              null,
              _react2.default.createElement(_DataTable.DataTableToolbarAction, {
                iconName: 'download',
                iconDescription: 'Download',
                onClick: (0, _addonActions.action)('Toolbar Action 1')
              }),
              _react2.default.createElement(_DataTable.DataTableToolbarAction, {
                iconName: 'edit',
                iconDescription: 'Edit',
                onClick: (0, _addonActions.action)('Toolbar Action 1')
              }),
              _react2.default.createElement(_DataTable.DataTableToolbarAction, {
                iconName: 'settings',
                iconDescription: 'Settings',
                onClick: (0, _addonActions.action)('Toolbar Action 1')
              }),
              _react2.default.createElement(
                _Button2.default,
                { onClick: (0, _addonActions.action)('Add new row'), kind: 'primary' },
                'Add new'
              )
            )
          ),
          _react2.default.createElement(_DataTable.DataTable, {
            initialRows: initialRows,
            headers: headers,
            render: function render(_ref) {
              var headers = _ref.headers,
                  getHeaderProps = _ref.getHeaderProps;
              return _react2.default.createElement(
                'table',
                { className: tableClasses },
                _react2.default.createElement(
                  _DataTable.DataTableHead,
                  null,
                  _react2.default.createElement(
                    _DataTableRow2.default,
                    null,
                    isSelectable && _react2.default.createElement(_DataTable.DataTableSelectAll, {
                      checked: _this2.state.selectAll,
                      onClick: _this2.selectAll
                    }),
                    headers.map(function (header) {
                      return _react2.default.createElement(
                        _DataTable.DataTableColumnHeader,
                        _extends({
                          key: header.key,
                          sortable: true
                        }, getHeaderProps(header)),
                        header.title
                      );
                    }),
                    _react2.default.createElement(_DataTable.DataTableColumnHeader, null)
                  )
                ),
                _react2.default.createElement(
                  _DataTable.DataTableBody,
                  null,
                  _this2.state.filteredRows.map(function (row, i) {
                    return _react2.default.createElement(
                      _DataTableRow2.default,
                      { key: 'row' + i },
                      _react2.default.createElement(_DataTableData2.default, {
                        onClick: function onClick() {
                          return _this2.selectRow(i);
                        },
                        key: 'a' + i,
                        isSelectable: true,
                        isSelected: _this2.state.checked[i] ? _this2.state.checked[i] : false
                      }),
                      Object.keys(row).map(function (rowData, j) {
                        return _react2.default.createElement(
                          _DataTableData2.default,
                          { key: 'rowdata' + j },
                          row[rowData]
                        );
                      }),
                      _react2.default.createElement(
                        _DataTableData2.default,
                        {
                          className: 'bx--table-overflow',
                          key: 'c' + i },
                        _react2.default.createElement(
                          _OverflowMenu2.default,
                          { flipped: true, floatingMenu: true },
                          _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 1' }),
                          _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 2' }),
                          _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 3' }),
                          _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 4' }),
                          _react2.default.createElement(_OverflowMenuItem2.default, {
                            itemText: 'Danger option',
                            hasDivider: true,
                            isDelete: true
                          })
                        )
                      )
                    );
                  })
                )
              );
            }
          })
        ),
        _react2.default.createElement(_PaginationV2.default, _extends({}, paginationProps, { totalItems: 50 }))
      );
    }
  }]);

  return BasicDataTable;
}(_react.Component);

BasicDataTable.propTypes = {
  zebra: _propTypes2.default.bool,
  rows: _propTypes2.default.array,
  isSelectable: _propTypes2.default.bool
};
BasicDataTable.defaultProps = {
  zebra: true,
  rows: initialRows,
  isSelectable: true
};

var ExpandableDataTable = function (_Component2) {
  _inherits(ExpandableDataTable, _Component2);

  function ExpandableDataTable() {
    var _ref2;

    var _temp, _this3, _ret;

    _classCallCheck(this, ExpandableDataTable);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this3 = _possibleConstructorReturn(this, (_ref2 = ExpandableDataTable.__proto__ || Object.getPrototypeOf(ExpandableDataTable)).call.apply(_ref2, [this].concat(args))), _this3), _this3.state = {
      expanded: [],
      selectAll: false,
      rows: _this3.props.rows
    }, _this3.createNewRow = function (content, parent) {
      var newRow = document.createElement('tr');
      var colspan = Object.keys(_this3.state.rows[0].rowContent).length + 2;
      parent.dataset.parentRow = '';
      newRow.classList.add('bx--expandable-row-v2');
      newRow.dataset.childRow = '';
      newRow.innerHTML = '\n      <td colspan=' + colspan + '>\n        ' + content + '\n      </td>\n    ';
      Object.keys(parent.parentElement.children).map(function (child) {
        if (parent.parentElement.children[child] === parent) {
          parent.parentElement.insertBefore(newRow, parent.parentElement.childNodes[+child + 1]);
          newRow.addEventListener('mouseover', function () {
            parent.classList.add('bx--expandable-row--hover-v2');
          });
          newRow.addEventListener('mouseout', function () {
            parent.classList.remove('bx--expandable-row--hover-v2');
          });
        }
      });
    }, _this3.removeRow = function (parent) {
      Object.keys(parent.parentElement.children).map(function (child) {
        if (parent.parentElement.children[child] === parent) {
          parent.parentElement.removeChild(parent.parentElement.children[+child + 1]);
        }
      });
    }, _this3.expandRow = function (index, evt) {
      var parent = evt.currentTarget.parentElement;
      var expanded = _this3.state.expanded;
      var rows = _this3.state.rows;
      if (expanded[index] === true) {
        expanded[index] = false;
      } else {
        expanded[index] = expanded[index] ? !expanded[index] : true;
      }
      _this3.setState({
        expanded: expanded
      });
      if (_this3.state.expanded[index]) {
        _this3.createNewRow(rows[index].expandedRowContent.html, parent);
      } else {
        _this3.removeRow(parent);
      }
    }, _this3.rowHover = function (evt) {
      evt.currentTarget.classList.add('bx--expandable-row--hover-v2');
    }, _this3.removeRowHover = function (evt) {
      evt.currentTarget.classList.remove('bx--expandable-row--hover-v2');
    }, _temp), _possibleConstructorReturn(_this3, _ret);
  }

  _createClass(ExpandableDataTable, [{
    key: 'render',
    value: function render() {
      var _this4 = this;

      var tableClasses = (0, _classnames2.default)({
        'bx--data-table-v2': true,
        'bx--data-table-v2--zebra': false
      });

      return _react2.default.createElement(
        _DataTable.DataTableContainer,
        { title: 'Table title' },
        _react2.default.createElement(_DataTable.DataTable, {
          initialRows: initialExpandedRows,
          headers: headers,
          render: function render(_ref3) {
            var rows = _ref3.rows,
                headers = _ref3.headers;
            return _react2.default.createElement(
              'table',
              { className: tableClasses },
              _react2.default.createElement(
                _DataTable.DataTableHead,
                null,
                _react2.default.createElement(
                  _DataTableRow2.default,
                  null,
                  _react2.default.createElement('th', null),
                  headers.map(function (header) {
                    return _react2.default.createElement(
                      'th',
                      { key: header.key },
                      header.title
                    );
                  }),
                  _react2.default.createElement('th', null)
                )
              ),
              _react2.default.createElement(
                _DataTable.DataTableBody,
                null,
                rows.map(function (row, i) {
                  return _react2.default.createElement(
                    _DataTableRow2.default,
                    {
                      className: (0, _classnames2.default)({
                        'bx--parent-row-v2': true,
                        'bx--expandable-row-v2': _this4.state.expanded[i]
                      }) },
                    _react2.default.createElement(_DataTableData2.default, {
                      onClick: function onClick(evt) {
                        _this4.expandRow(i, evt);
                      },
                      key: 'a' + i,
                      isExpandable: true,
                      isExpanded: _this4.state.expanded[i] ? _this4.state.expanded[i] : false
                    }),
                    Object.keys(row.rowContent).map(function (content, j) {
                      return _react2.default.createElement(
                        _DataTableData2.default,
                        { key: 'rowdata' + j },
                        row.rowContent[content]
                      );
                    }),
                    _react2.default.createElement(
                      _DataTableData2.default,
                      {
                        className: 'bx--table-overflow',
                        key: 'c' + i },
                      _react2.default.createElement(
                        _OverflowMenu2.default,
                        { flipped: true, floatingMenu: true },
                        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 1' }),
                        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 2' }),
                        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 3' }),
                        _react2.default.createElement(_OverflowMenuItem2.default, { itemText: 'Option 4' }),
                        _react2.default.createElement(_OverflowMenuItem2.default, {
                          itemText: 'Danger option',
                          hasDivider: true,
                          isDelete: true
                        })
                      )
                    )
                  );
                })
              )
            );
          }
        })
      );
    }
  }]);

  return ExpandableDataTable;
}(_react.Component);

ExpandableDataTable.propTypes = {
  zebra: _propTypes2.default.bool,
  rows: _propTypes2.default.array
};
ExpandableDataTable.defaultProps = {
  zebra: true,
  rows: initialExpandedRows
};


(0, _react3.storiesOf)('DataTable', module).addWithInfo('Data Table', '\n      Data table\n    ', function () {
  return _react2.default.createElement(BasicDataTable, null);
}).addWithInfo('Expandable table', '\n      Expandable table\n    ', function () {
  return _react2.default.createElement(ExpandableDataTable, null);
});