"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _downshift = _interopRequireDefault(require("downshift"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _ListBox = _interopRequireWildcard(require("../ListBox"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var defaultItemToString = function defaultItemToString(item) {
  if (typeof item === 'string') {
    return item;
  }

  return item && item.label;
};

var defaultShouldFilterItem = function defaultShouldFilterItem(_ref) {
  var inputValue = _ref.inputValue,
      item = _ref.item,
      itemToString = _ref.itemToString;
  return !inputValue || itemToString(item).toLowerCase().includes(inputValue.toLowerCase());
};

var getInputValue = function getInputValue(props, state) {
  if (props.initialSelectedItem) {
    return props.itemToString(props.initialSelectedItem);
  }

  return state.inputValue || '';
};

var ComboBox =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ComboBox, _React$Component);

  function ComboBox(props) {
    var _this;

    _classCallCheck(this, ComboBox);

    _this = _possibleConstructorReturn(this, (ComboBox.__proto__ || Object.getPrototypeOf(ComboBox)).call(this, props));
    Object.defineProperty(_assertThisInitialized(_this), "filterItems", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(items, itemToString, inputValue) {
        return items.filter(function (item) {
          return _this.props.shouldFilterItem({
            item: item,
            itemToString: itemToString,
            inputValue: inputValue
          });
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(selectedItem) {
        if (_this.props.onChange) {
          _this.props.onChange({
            selectedItem: selectedItem
          });
        }
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnInputKeyDown", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(event) {
        event.stopPropagation();
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnInputValueChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(inputValue) {
        var onInputChange = _this.props.onInputChange;

        _this.setState(function () {
          return {
            // Default to empty string if we have a false-y `inputValue`
            inputValue: inputValue || ''
          };
        }, function () {
          if (onInputChange) {
            onInputChange(inputValue);
          }
        });
      }
    });
    _this.state = {
      inputValue: getInputValue(props, {})
    };
    return _this;
  }

  _createClass(ComboBox, [{
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      this.setState(function (state) {
        return {
          inputValue: getInputValue(nextProps, state)
        };
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          containerClassName = _props.className,
          disabled = _props.disabled,
          id = _props.id,
          items = _props.items,
          itemToString = _props.itemToString,
          placeholder = _props.placeholder,
          initialSelectedItem = _props.initialSelectedItem,
          ariaLabel = _props.ariaLabel;
      var className = (0, _classnames.default)('bx--combo-box', containerClassName);
      return _react.default.createElement(_downshift.default, {
        onChange: this.handleOnChange,
        onInputValueChange: this.handleOnInputValueChange,
        inputValue: this.state.inputValue || '',
        itemToString: itemToString,
        defaultSelectedItem: initialSelectedItem
      }, function (_ref2) {
        var getButtonProps = _ref2.getButtonProps,
            getInputProps = _ref2.getInputProps,
            getItemProps = _ref2.getItemProps,
            getRootProps = _ref2.getRootProps,
            isOpen = _ref2.isOpen,
            inputValue = _ref2.inputValue,
            selectedItem = _ref2.selectedItem,
            highlightedIndex = _ref2.highlightedIndex,
            clearSelection = _ref2.clearSelection;
        return _react.default.createElement(_ListBox.default, _extends({
          className: className,
          disabled: disabled
        }, getRootProps({
          refKey: 'innerRef'
        })), _react.default.createElement(_ListBox.default.Field, getButtonProps({
          disabled: disabled
        }), _react.default.createElement("input", _extends({
          className: "bx--text-input",
          "aria-label": ariaLabel
        }, getInputProps({
          disabled: disabled,
          id: id,
          placeholder: placeholder,
          onKeyDown: _this2.handleOnInputKeyDown
        }))), inputValue && isOpen && _react.default.createElement(_ListBox.default.Selection, {
          clearSelection: clearSelection
        }), _react.default.createElement(_ListBox.default.MenuIcon, {
          isOpen: isOpen
        })), isOpen && _react.default.createElement(_ListBox.default.Menu, null, _this2.filterItems(items, itemToString, inputValue).map(function (item, index) {
          return _react.default.createElement(_ListBox.default.MenuItem, _extends({
            key: itemToString(item),
            isActive: selectedItem === item,
            isHighlighted: highlightedIndex === index
          }, getItemProps({
            item: item,
            index: index
          })), itemToString(item));
        })));
      });
    }
  }]);

  return ComboBox;
}(_react.default.Component);

exports.default = ComboBox;
Object.defineProperty(ComboBox, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    /**
     * An optional className to add to the container node
     */
    className: _propTypes.default.string,

    /**
     * Specify if the control should be disabled, or not
     */
    disabled: _propTypes.default.bool,

    /**
     * Specify a custom `id` for the input
     */
    id: _propTypes.default.string,

    /**
     * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
     * from their collection that are pre-selected
     */
    initialSelectedItem: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),

    /**
     * We try to stay as generic as possible here to allow individuals to pass
     * in a collection of whatever kind of data structure they prefer
     */
    items: _propTypes.default.array.isRequired,

    /**
     * Helper function passed to downshift that allows the library to render a
     * given item to a string label. By default, it extracts the `label` field
     * from a given item to serve as the item label in the list
     */
    itemToString: _propTypes.default.func,

    /**
     * `onChange` is a utility for this controlled component to communicate to a
     * consuming component when a specific dropdown item is selected.
     * @param {{ selectedItem }}
     */
    onChange: _propTypes.default.func.isRequired,

    /**
     * Used to provide a placeholder text node before a user enters any input.
     * This is only present if the control has no items selected
     */
    placeholder: _propTypes.default.string.isRequired,

    /**
     * Specify your own filtering logic by passing in a `shouldFilterItem`
     * function that takes in the current input and an item and passes back
     * whether or not the item should be filtered.
     */
    shouldFilterItem: _propTypes.default.func,

    /**
     * Currently supports either the default type, or an inline variant
     */
    type: _ListBox.PropTypes.ListBoxType,

    /**
     * Callback function to notify consumer when the text input changes.
     * This provides support to change available items based on the text.
     * @param {string} inputText
     */
    onInputChange: _propTypes.default.func
  }
});
Object.defineProperty(ComboBox, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    disabled: false,
    itemToString: defaultItemToString,
    shouldFilterItem: defaultShouldFilterItem,
    type: 'default',
    ariaLabel: 'ListBox input field'
  }
});