/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 ****************************************************************************** */
/* Copyright (c) 2020 Red Hat, Inc. */
import { gql } from 'apollo-server-express';

export const typeDef = gql`
type TopologyFilters {
  filters: [FilterItem]
}

type FilterItem {
  name: String
  namespace: String
  uid: String
  labels: JSON
  annotations: JSON
}


input TopologyFilter {
  application: [JSON]
  cluster: [JSON]
  policy: [JSON]
  namespace: [String]
  type: [String]
}

`;

export const resolver = {
  Query: {
    topologyFilters: async (root, { topologyResourceType },
      { clusterModel, applicationModel, complianceModel }) => {
      let filters = [];
      switch (topologyResourceType) {
        case 'HCMTopology': {
          const clusters = await clusterModel.getClusters();
          clusters.forEach((val) => {
            filters.push({
              name: val.metadata.name,
              namespace: val.metadata.namespace,
              uid: val.metadata.uid,
              labels: val.metadata.labels,
              annotations: val.metadata.annotations,
            });
          });
          break;
        }
        case 'HCMApplication': {
          const applications = await applicationModel.getApplications();
          filters = applications.map(({
            metadata: {
              name, namespace, uid, labels, annotations,
            },
          }) => ({
            name, namespace, uid, labels, annotations,
          }));
          break;
        }
        case 'HCMPolicy': {
          const policies = await complianceModel.getCompliances();
          filters = policies.map(({
            metadata: {
              name, namespace, uid, labels, annotations,
            },
          }) => ({
            name, namespace, uid, labels, annotations,
          }));
          break;
        }
        default:
          break;
      }
      return { filters };
    },

  },
};
