/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 ****************************************************************************** */
/* Copyright (c) 2020 Red Hat, Inc. */

export const mockPolicyListResponse = {
  apiVersion: 'policy.open-cluster-management.io/v1',
  items: [
    {
      apiVersion: 'policy.open-cluster-management.io/v1',
      kind: 'Policy',
      metadata: {
        annotations: {
          'policy.open-cluster-management.io/categories': 'PR.DS DataSecurity',
          'policy.open-cluster-management.io/controls': '',
          'policy.open-cluster-management.io/standards': '',
        },
        creationTimestamp: '2020-06-23T16:01:42Z',
        generation: 1,
        name: '1592928044213-namespace-policy-test',
        namespace: 'default',
        resourceVersion: '8355001',
        selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies/1592928044213-namespace-policy-test',
        uid: '11e16d21-6308-4a55-9b2c-2322297281f9',
      },
      spec: {
        disabled: false,
        'policy-templates': [
          {
            objectDefinition: {
              apiVersion: 'policy.open-cluster-management.io/v1',
              kind: 'CertificatePolicy',
              metadata: {
                name: '1592928044213-namespace-policy-test-example',
              },
              spec: {
                minimumDuration: '300h',
                namespaceSelector: {
                  exclude: [
                    'kube-*',
                  ],
                  include: [
                    'default',
                  ],
                },
                remediationAction: 'inform',
                severity: 'low',
              },
            },
          },
        ],
        remediationAction: 'inform',
      },
      status: {
        placement: [
          {
            placementBinding: 'binding-1592928044213-namespace-policy-test',
            placementRule: 'placement-1592928044213-namespace-policy-test',
          },
        ],
        status: [
          {
            clustername: 'ironman',
            clusternamespace: 'ironman',
            compliant: 'Compliant',
          },
        ],
      },
    },
    {
      apiVersion: 'policy.open-cluster-management.io/v1',
      kind: 'Policy',
      metadata: {
        annotations: {
          'policy.open-cluster-management.io/categories': '',
          'policy.open-cluster-management.io/controls': 'PR.DS-2 Data-at-rest',
          'policy.open-cluster-management.io/standards': '',
        },
        creationTimestamp: '2020-06-23T16:37:01Z',
        generation: 1,
        name: '1592930153049-control-policy-test',
        namespace: 'default',
        resourceVersion: '8375493',
        selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies/1592930153049-control-policy-test',
        uid: '43b46f9b-01bf-47a1-87de-19a57e978480',
      },
      spec: {
        disabled: false,
        'policy-templates': [
          {
            objectDefinition: {
              apiVersion: 'policy.open-cluster-management.io/v1',
              kind: 'CertificatePolicy',
              metadata: {
                name: '1592930153049-control-policy-test-example',
              },
              spec: {
                minimumDuration: '300h',
                namespaceSelector: {
                  exclude: [
                    'kube-*',
                  ],
                  include: [
                    'default',
                  ],
                },
                remediationAction: 'inform',
                severity: 'low',
              },
            },
          },
        ],
        remediationAction: 'inform',
      },
      status: {
        placement: [
          {
            placementBinding: 'binding-1592930153049-control-policy-test',
            placementRule: 'placement-1592930153049-control-policy-test',
          },
        ],
        status: [
          {
            clustername: 'ironman',
            clusternamespace: 'ironman',
            compliant: 'Compliant',
          },
        ],
      },
    },
    {
      apiVersion: 'policy.open-cluster-management.io/v1',
      kind: 'Policy',
      metadata: {
        annotations: {
          'policy.open-cluster-management.io/categories': 'DE.CM Security Continuous Monitoring',
          'policy.open-cluster-management.io/controls': 'DE.CM-8 Vulnerability scans',
          'policy.open-cluster-management.io/standards': 'NIST-CSF',
        },
        creationTimestamp: '2020-06-23T13:11:08Z',
        generation: 2,
        name: 'policy-imagemanifestvulnpolicy',
        namespace: 'default',
        resourceVersion: '8258016',
        selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies/policy-imagemanifestvulnpolicy',
        uid: '6d1e1d46-d2d8-4e22-977d-7899c226900b',
      },
      spec: {
        disabled: false,
        'policy-templates': [
          {
            objectDefinition: {
              apiVersion: 'policy.open-cluster-management.io/v1',
              kind: 'ConfigurationPolicy',
              metadata: {
                name: 'policy-imagemanifestvulnpolicy-example-csv',
              },
              spec: {
                namespaceSelector: {
                  exclude: [
                    'kube-*',
                  ],
                  include: [
                    '*',
                  ],
                },
                'object-templates': [
                  {
                    complianceType: 'musthave',
                    objectDefinition: {
                      apiVersion: 'operators.coreos.com/v1alpha1',
                      kind: 'ClusterServiceVersion',
                      metadata: {
                        annotations: {
                          capabilities: 'Full Lifecycle',
                          categories: 'Security',
                          containerImage: 'quay.io/quay/container-security-operator@sha256:15a4b50d847512b5f404ec1cf72c30c98e073a7f26f1588213bd2e8b6331f016',
                          createdAt: '2019-11-16T01:03:00.000Z',
                          description: 'Identify image vulnerabilities in Kubernetes pods',
                          repository: 'https://github.com/quay/container-security-operator',
                          'tectonic-visibility': 'ocs',
                        },
                        name: 'container-security-operator.v1.0.1',
                        namespace: 'openshift-operators',
                      },
                      spec: {
                        customresourcedefinitions: {
                          owned: [
                            {
                              description: 'Represents a set of vulnerabilities in an image manifest.',
                              displayName: 'Image Manifest Vulnerability',
                              kind: 'ImageManifestVuln',
                              name: 'imagemanifestvulns.secscan.quay.redhat.com',
                              version: 'v1alpha1',
                            },
                          ],
                        },
                        description: 'The Container Security Operator (CSO) brings Quay and Clair metadata to Kubernetes / OpenShift. Starting with vulnerability information the scope will get expanded over time. If it runs on OpenShift, the corresponding vulnerability information is shown inside the OCP Console. The Container Security Operator enables cluster administrators to monitor known container image vulnerabilities in pods running on their Kubernetes cluster. The controller sets up a watch on pods in the specified namespace(s) and queries the container registry for vulnerability information. If the container registry supports image scanning, such as [Quay](https://github.com/quay/quay) with [Clair](https://github.com/quay/clair), then the Operator will expose any vulnerabilities found via the Kubernetes API in an `ImageManifestVuln` object.  This Operator requires no additional configuration after deployment, and will begin watching pods and populating `ImageManifestVulns` immediately once installed.',
                        displayName: 'Container Security',
                        icon: [
                          {
                            base64data: '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',
                            mediatype: 'image/png',
                          },
                        ],
                        install: {
                          spec: {
                            deployments: [
                              {
                                name: 'container-security-operator',
                                spec: {
                                  replicas: 1,
                                  selector: {
                                    matchLabels: {
                                      name: 'container-security-operator-alm-owned',
                                    },
                                  },
                                  template: {
                                    metadata: {
                                      labels: {
                                        name: 'container-security-operator-alm-owned',
                                      },
                                      name: 'container-security-operator-alm-owned',
                                    },
                                    spec: {
                                      containers: [
                                        {
                                          command: [
                                            '/bin/security-labeller',
                                            '--namespaces=$(WATCH_NAMESPACE)',
                                          ],
                                          env: [
                                            {
                                              name: 'MY_POD_NAMESPACE',
                                              valueFrom: {
                                                fieldRef: {
                                                  fieldPath: 'metadata.namespace',
                                                },
                                              },
                                            },
                                            {
                                              name: 'MY_POD_NAME',
                                              valueFrom: {
                                                fieldRef: {
                                                  fieldPath: 'metadata.name',
                                                },
                                              },
                                            },
                                            {
                                              name: 'WATCH_NAMESPACE',
                                              valueFrom: {
                                                fieldRef: {
                                                  fieldPath: 'metadata.annotations["olm.targetNamespaces"]',
                                                },
                                              },
                                            },
                                          ],
                                          image: 'quay.io/quay/container-security-operator@sha256:15a4b50d847512b5f404ec1cf72c30c98e073a7f26f1588213bd2e8b6331f016',
                                          name: 'container-security-operator',
                                        },
                                      ],
                                      serviceAccountName: 'container-security-operator',
                                    },
                                  },
                                },
                              },
                            ],
                            permissions: [
                              {
                                rules: [
                                  {
                                    apiGroups: [
                                      'secscan.quay.redhat.com',
                                    ],
                                    resources: [
                                      'imagemanifestvulns',
                                      'imagemanifestvulns/status',
                                    ],
                                    verbs: [
                                      '*',
                                    ],
                                  },
                                  {
                                    apiGroups: [
                                      '',
                                    ],
                                    resources: [
                                      'pods',
                                      'events',
                                    ],
                                    verbs: [
                                      '*',
                                    ],
                                  },
                                  {
                                    apiGroups: [
                                      '',
                                    ],
                                    resources: [
                                      'secrets',
                                    ],
                                    verbs: [
                                      'get',
                                    ],
                                  },
                                ],
                                serviceAccountName: 'container-security-operator',
                              },
                            ],
                          },
                          strategy: 'deployment',
                        },
                        installModes: [
                          {
                            supported: true,
                            type: 'OwnNamespace',
                          },
                          {
                            supported: true,
                            type: 'SingleNamespace',
                          },
                          {
                            supported: true,
                            type: 'MultiNamespace',
                          },
                          {
                            supported: true,
                            type: 'AllNamespaces',
                          },
                        ],
                        keywords: [
                          'open source',
                          'containers',
                          'security',
                        ],
                        labels: {
                          'alm-owner-container-security-operator': 'container-security-operator',
                          'operated-by': 'container-security-operator',
                        },
                        links: [
                          {
                            name: 'Operator Source Code',
                            url: 'https://github.com/quay/container-security-operator',
                          },
                          {
                            name: 'Source Code',
                            url: 'https://github.com/quay/container-security-operator',
                          },
                        ],
                        maintainers: [
                          {
                            email: 'quay-devel@redhat.com',
                            name: 'Quay Engineering Team',
                          },
                        ],
                        maturity: 'alpha',
                        provider: {
                          name: 'Red Hat',
                        },
                        replaces: 'container-security-operator.v1.0.0',
                        selector: {
                          matchLabels: {
                            'alm-owner-container-security-operator': 'container-security-operator',
                            'operated-by': 'container-security-operator',
                          },
                        },
                        version: '1.0.1',
                      },
                    },
                  },
                ],
                remediationAction: 'inform',
                severity: 'high',
              },
            },
          },
          {
            objectDefinition: {
              apiVersion: 'policy.open-cluster-management.io/v1',
              kind: 'ConfigurationPolicy',
              metadata: {
                name: 'policy-imagemanifestvulnpolicy-example-sub',
              },
              spec: {
                namespaceSelector: {
                  exclude: [
                    'kube-*',
                  ],
                  include: [
                    '*',
                  ],
                },
                'object-templates': [
                  {
                    complianceType: 'musthave',
                    objectDefinition: {
                      apiVersion: 'operators.coreos.com/v1alpha1',
                      kind: 'Subscription',
                      metadata: {
                        name: 'container-security-operator',
                        namespace: 'openshift-operators',
                      },
                      spec: {
                        channel: 'alpha',
                        installPlanApproval: 'Automatic',
                        name: 'container-security-operator',
                        source: 'community-operators',
                        sourceNamespace: 'openshift-marketplace',
                        startingCSV: 'container-security-operator.v1.0.1',
                      },
                    },
                  },
                ],
                remediationAction: 'inform',
                severity: 'high',
              },
            },
          },
          {
            objectDefinition: {
              apiVersion: 'policy.open-cluster-management.io/v1',
              kind: 'ConfigurationPolicy',
              metadata: {
                name: 'policy-imagemanifestvulnpolicy-example-imv',
              },
              spec: {
                namespaceSelector: {
                  exclude: [
                    'kube-*',
                  ],
                  include: [
                    '*',
                  ],
                },
                'object-templates': [
                  {
                    complianceType: 'mustnothave',
                    objectDefinition: {
                      apiVersion: 'secscan.quay.redhat.com/v1alpha1',
                      kind: 'ImageManifestVuln',
                    },
                  },
                ],
                remediationAction: 'inform',
                severity: 'high',
              },
            },
          },
        ],
        remediationAction: 'enforce',
      },
      status: {
        placement: [
          {
            placementBinding: 'binding-policy-imagemanifestvulnpolicy',
            placementRule: 'placement-policy-imagemanifestvulnpolicy',
          },
        ],
        status: [
          {
            clustername: 'ironman',
            clusternamespace: 'ironman',
            compliant: 'Compliant',
          },
        ],
      },
    },
  ],
  kind: 'PolicyList',
  metadata: {
    continue: '',
    resourceVersion: '8387419',
    selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies',
  },
};

export const mockSinglePolicyResponse = {
  apiVersion: 'policy.open-cluster-management.io/v1',
  kind: 'Policy',
  metadata: {
    annotations: {
      'policy.open-cluster-management.io/categories': 'PR.PT Protective Technology',
      'policy.open-cluster-management.io/controls': 'PR.PT-3 Least Functionality',
      'policy.open-cluster-management.io/standards': 'NIST-CSF',
    },
    creationTimestamp: '2020-06-20T16:06:52Z',
    generation: 2,
    name: 'policy-pod-1592668711636',
    namespace: 'default',
    resourceVersion: '5917927',
    selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies/policy-pod-1592668711636',
    uid: '89d773e9-52d1-4b4d-9e51-2dad355f33fc',
  },
  spec: {
    disabled: true,
    'policy-templates': [
      {
        objectDefinition: {
          apiVersion: 'policy.open-cluster-management.io/v1',
          kind: 'ConfigurationPolicy',
          metadata: {
            name: 'policy-pod-1592668711636',
          },
          spec: {
            namespaceSelector: {
              exclude: [
                'kube-*',
              ],
              include: [
                'default',
              ],
            },
            'object-templates': [
              {
                complianceType: 'mustnothave',
                objectDefinition: {
                  apiVersion: 'v1',
                  kind: 'Pod',
                  metadata: {
                    name: 'pod-ed-1592668711636',
                  },
                  spec: {
                    containers: [
                      {
                        image: 'nginx:1.7.9',
                        name: 'nginx',
                        ports: [
                          {
                            containerPort: 80,
                          },
                        ],
                      },
                    ],
                  },
                },
              },
            ],
            remediationAction: 'enforce',
            severity: 'low',
          },
        },
      },
    ],
    remediationAction: 'enforce',
  },
  status: {
    placement: [
      {
        placementBinding: 'binding-policy-pod-1592668711636',
        placementRule: 'placement-policy-pod-1592668711636',
      },
    ],
  },
};

export const mockPlacementRuleResponse = {
  apiVersion: 'apps.open-cluster-management.io/v1',
  kind: 'PlacementRule',
  metadata: {
    annotations: {
      'mcm.ibm.com/user-group': 'c3lzdGVtOmNsdXN0ZXItYWRtaW5zLHN5c3RlbTphdXRoZW50aWNhdGVk',
      'mcm.ibm.com/user-identity': 'a3ViZTphZG1pbg==',
    },
    creationTimestamp: '2020-06-20T16:06:52Z',
    generation: 1,
    name: 'placement-policy-pod-1592668711636',
    namespace: 'default',
    resourceVersion: '5917243',
    selfLink: '/apis/apps.open-cluster-management.io/v1/namespaces/default/placementrules/placement-policy-pod-1592668711636',
    uid: '077d6d22-23ed-4c2a-8c19-bd8b171cdf4c',
  },
  spec: {
    clusterConditions: [
      {
        status: 'True',
        type: 'ManagedClusterConditionAvailable',
      },
    ],
    clusterSelector: {
      matchExpressions: [],
    },
  },
};

export const mockPlacementPolicyResponse = {
  kind: 'PlacementPolicyList',
  apiVersion: 'open-cluster-management.io/v1',
  metadata: {
    selfLink: '/apis/open-cluster-management.io/v1/namespaces/mcm/placementpolicies',
    resourceVersion: '51490',
  },
  items: [
    {
      metadata: {
        name: 'placement-xz',
        namespace: 'mcm',
        selfLink: '/apis/open-cluster-management.io/v1/namespaces/mcm/placementpolicies/placement-xz',
        uid: '3df1e8f5-1053-11e9-a535-e2d4c161f9ad',
        resourceVersion: '51486',
        creationTimestamp: '2019-01-04T19:02:11Z',
        annotations: {
          'open-cluster-management.io/user-group': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50cyxzeXN0ZW06c2VydmljZWFjY291bnRzOmt1YmUtc3lzdGVtLHN5c3RlbTphdXRoZW50aWNhdGVk',
          'open-cluster-management.io/user-identity': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50Omt1YmUtc3lzdGVtOmRlZmF1bHQ=',
        },
      },
      spec: {
        clusterLabels: {
          matchLabels: {
            cloud: 'IBM',
          },
        },
        resourceHint: {

        },
      },
      status: {
        decisions: [
          {
            clusterName: 'cluster3',
            clusterNamespace: 'cluster3',
          },
          {
            clusterName: 'cluster1',
            clusterNamespace: 'cluster1',
          },
        ],
      },
    },
  ],
};

export const mockPlacementBindingResponse = {
  kind: 'PlacementBindingList',
  apiVersion: 'open-cluster-management.io/v1',
  metadata: {
    selfLink: '/apis/open-cluster-management.io/v1/namespaces/mcm/placementbindings',
    resourceVersion: '48564',
  },
  items: [
    {
      metadata: {
        name: 'binding-xz',
        namespace: 'mcm',
        selfLink: '/apis/open-cluster-management.io/v1/namespaces/mcm/placementbindings/binding-xz',
        uid: '7fc24685-0ec6-11e9-a535-e2d4c161f9ad',
        resourceVersion: '249',
        creationTimestamp: '2019-01-02T19:42:12Z',
        annotations: {
          'open-cluster-management.io/user-group': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50cyxzeXN0ZW06c2VydmljZWFjY291bnRzOmt1YmUtc3lzdGVtLHN5c3RlbTphdXRoZW50aWNhdGVk',
          'open-cluster-management.io/user-identity': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50Omt1YmUtc3lzdGVtOmRlZmF1bHQ=',
          'seed-generation': '1',
        },
        finalizers: [
          'finalizer.open-cluster-management.io',
        ],
      },
      subjects: [
        {
          kind: 'Compliance',
          name: 'compliance-all',
        },
      ],
      placementRef: {
        name: 'placement-xz',
      },
    },
  ],
};

export const mockDeleteResponse = {
  apiVersion: 'policy.open-cluster-management.io/v1',
  kind: 'Policy',
  metadata: {
    creationTimestamp: '2018-09-06T15:06:23Z',
    deletionGracePeriodSeconds: 0,
    deletionTimestamp: '2018-09-06T15:09:33Z',
    finalizers: [
      'finalizer.open-cluster-management.io',
    ],
    generation: 2,
    name: 'test-policy',
    namespace: 'default',
    resourceVersion: '4348453',
    selfLink: '/apis/policy.open-cluster-management.io/v1/namespaces/default/policies/test-policy',
    uid: '6b4cc90c-b1e6-11e8-9a12-005056a0d11b',
  },
  spec: {
    complianceType: '',
    namespaces: {
      exclude: [
        'kube*',
      ],
      include: [
        'default',
      ],
    },
    remediationAction: 'enforce',
    'role-templates': [
      {
        apiVersion: 'roletemplate.open-cluster-management.io/v1',
        complianceType: 'musthave',
        kind: 'RoleTemplate',
        metadata: {
          creationTimestamp: null,
          name: 'test-role',
        },
        rules: [
          {
            complianceType: 'musthave',
            policyRule: {
              apiGroups: [
                'extensions',
                'apps',
              ],
              resources: [
                'deployments',
              ],
              verbs: [
                'get',
                'list',
                'watch',
                'delete',
              ],
            },
          },
          {
            complianceType: 'mustnothave',
            policyRule: {
              apiGroups: [
                'core',
              ],
              resources: [
                'pods',
              ],
              verbs: [
                'create',
                'update',
                'patch',
              ],
            },
          },
          {
            complianceType: 'musthave',
            policyRule: {
              apiGroups: [
                'core',
              ],
              resources: [
                'secrets',
              ],
              verbs: [
                'get',
                'watch',
                'list',
                'create',
                'delete',
                'update',
                'patch',
              ],
            },
          },
        ],
        selector: {
          matchLabels: {
            cloud: 'IBM',
          },
        },
        status: {
          Compliant: 'Compliant',
          Validity: {
            valid: true,
          },
          conditions: [
            {
              lastTransitionTime: '2018-09-06T15:06:24Z',
              message: 'k8s RBAC role "test-role" was missing ',
              reason: 'K8s RBAC role created',
              status: 'True',
              type: 'completed',
            },
          ],
        },
      },
    ],
  },
  status: {
    Compliant: 'Compliant',
    Valid: true,
  },
};
