import { Subject } from 'rxjs';
import { ListrRendererFactory, ListrGetRendererTaskOptions, ListrContext, ListrEvent, ListrOptions, ListrTask, ListrTaskObject, ListrTaskWrapper, PromptError, ListrGetRendererOptions, StateConstants } from '../interfaces/listr.interface';
import { Listr } from '../index';
export declare class Task<Ctx, Renderer extends ListrRendererFactory> extends Subject<ListrEvent> implements ListrTaskObject<ListrContext, Renderer> {
    listr: Listr<Ctx, any, any>;
    tasks: ListrTask<Ctx, any>;
    options: ListrOptions;
    rendererOptions: ListrGetRendererOptions<Renderer>;
    id: ListrTaskObject<Ctx, Renderer>['id'];
    title: ListrTaskObject<Ctx, Renderer>['title'];
    task: ListrTaskObject<Ctx, Renderer>['task'];
    skip: ListrTaskObject<Ctx, Renderer>['skip'];
    subtasks: ListrTaskObject<Ctx, any>['subtasks'];
    state: ListrTaskObject<Ctx, Renderer>['state'];
    output: ListrTaskObject<Ctx, Renderer>['output'];
    prompt: boolean | PromptError;
    exitOnError: boolean;
    rendererTaskOptions: ListrGetRendererTaskOptions<Renderer>;
    renderHook$: Subject<void>;
    private enabled;
    private enabledFn;
    constructor(listr: Listr<Ctx, any, any>, tasks: ListrTask<Ctx, any>, options: ListrOptions, rendererOptions: ListrGetRendererOptions<Renderer>);
    set state$(state: StateConstants);
    check(ctx: Ctx): Promise<void>;
    hasSubtasks(): boolean;
    isPending(): boolean;
    isSkipped(): boolean;
    isCompleted(): boolean;
    hasFailed(): boolean;
    isEnabled(): boolean;
    hasTitle(): boolean;
    isPrompt(): boolean;
    run(context: Ctx, wrapper: ListrTaskWrapper<Ctx, Renderer>): Promise<void>;
}
