import { GraphQLSchema, ExecutionResult } from 'graphql';
import { Transform, Request } from '@graphql-tools/utils';
import { EnumValueTransformer, LeafValueTransformer } from '../types';
import { MapLeafValuesTransformationContext } from './MapLeafValues';
export default class TransformEnumValues implements Transform<MapLeafValuesTransformationContext> {
    private readonly enumValueTransformer;
    private readonly transformer;
    private transformedSchema;
    private mapping;
    private reverseMapping;
    constructor(enumValueTransformer: EnumValueTransformer, inputValueTransformer?: LeafValueTransformer, outputValueTransformer?: LeafValueTransformer);
    transformSchema(originalSchema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: MapLeafValuesTransformationContext): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: MapLeafValuesTransformationContext): any;
    private transformEnumValue;
}
