/// <reference types="node" />
export declare const EMPTY_COMMANDS: [];
export interface SimpleGitTaskConfiguration<RESPONSE, FORMAT, INPUT> {
    commands: string[];
    format: FORMAT;
    parser(text: INPUT): RESPONSE;
    concatStdErr?: boolean;
    onError?: (exitCode: number, error: string, done: (result: INPUT) => void, fail: (error: string) => void) => void;
}
export declare type EmptyTask = SimpleGitTaskConfiguration<undefined, 'utf-8', string> & {
    commands: typeof EMPTY_COMMANDS;
};
export declare type StringTask<R> = SimpleGitTaskConfiguration<R, 'utf-8', string>;
export declare type BufferTask<R> = SimpleGitTaskConfiguration<R, 'buffer', Buffer>;
export declare type SimpleGitTask<R> = StringTask<R> | BufferTask<R> | EmptyTask;
export declare function configurationErrorTask(error: Error | string): EmptyTask;
export declare function straightThroughStringTask(commands: string[], trimmed?: boolean): StringTask<string>;
export declare function isBufferTask<R>(task: SimpleGitTask<R>): task is BufferTask<R>;
export declare function isEmptyTask<R>(task: SimpleGitTask<R>): task is EmptyTask;
