"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _getos = _interopRequireDefault(require("getos"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MongoBinaryDownloadUrl {
  constructor({
    platform,
    arch,
    version,
    os
  }) {
    _defineProperty(this, "platform", void 0);

    _defineProperty(this, "arch", void 0);

    _defineProperty(this, "version", void 0);

    _defineProperty(this, "os", void 0);

    this.platform = this.translatePlatform(platform);
    this.arch = this.translateArch(arch, this.platform);
    this.version = version;
    this.os = os;
  }

  getDownloadUrl() {
    var _this = this;

    return _asyncToGenerator(function* () {
      const archive = yield _this.getArchiveName();
      return `https://fastdl.mongodb.org/${_this.platform}/${archive}`;
    })();
  }

  getArchiveName() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      switch (_this2.platform) {
        case 'osx':
          return _this2.getArchiveNameOsx();

        case 'win32':
          return _this2.getArchiveNameWin();

        case 'linux':
        default:
          return _this2.getArchiveNameLinux();
      }
    })();
  } // https://www.mongodb.org/dl/win32


  getArchiveNameWin() {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      let name = `mongodb-${_this3.platform}`;
      name += `-${_this3.arch}`;
      name += '-2008plus-ssl';
      name += `-${_this3.version}.zip`;
      return name;
    })();
  } // https://www.mongodb.org/dl/osx


  getArchiveNameOsx() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      let name = `mongodb-osx`;

      if (!(_this4.version.indexOf('3.0') === 0 || _this4.version.indexOf('2.') === 0 || _this4.version.indexOf('1.') === 0)) {
        name += '-ssl';
      }

      name += `-${_this4.arch}`;
      name += `-${_this4.version}.tgz`;
      return name;
    })();
  } // https://www.mongodb.org/dl/linux


  getArchiveNameLinux() {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      let name = `mongodb-linux`;
      name += `-${_this5.arch}`;
      let osString;

      if (_this5.arch !== 'i686') {
        if (!_this5.os) _this5.os = yield _this5.getos();
        osString = _this5.getLinuxOSVersionString(_this5.os);
      }

      if (osString) {
        name += `-${osString}`;
      }

      name += `-${_this5.version}.tgz`;
      return name;
    })();
  }

  getos() {
    return _asyncToGenerator(function* () {
      return new Promise((resolve, reject) => {
        (0, _getos.default)((e, os) => {
          if (e) reject(e);
          resolve(os);
        });
      });
    })();
  }

  getLinuxOSVersionString(os) {
    if (/ubuntu/i.test(os.dist)) {
      return this.getUbuntuVersionString(os);
    } else if (/elementary OS/i.test(os.dist)) {
      return this.getElementaryOSVersionString(os);
    } else if (/suse/i.test(os.dist)) {
      return this.getSuseVersionString(os);
    } else if (/rhel/i.test(os.dist) || /centos/i.test(os.dist) || /scientific/i.test(os.dist)) {
      return this.getRhelVersionString(os);
    } else if (/fedora/i.test(os.dist)) {
      return this.getFedoraVersionString(os);
    } else if (/debian/i.test(os.dist)) {
      return this.getDebianVersionString(os);
    } else if (/mint/i.test(os.dist)) {
      return this.getMintVersionString(os);
    }

    console.warn(`Unknown linux distro ${os.dist}, falling back to legacy MongoDB build`);
    return this.getLegacyVersionString(os);
  }

  getDebianVersionString(os) {
    let name = 'debian';
    const release = parseFloat(os.release);

    if (release >= 9) {
      name += '92';
    } else if (release >= 8.1) {
      name += '81';
    } else if (release >= 7.1) {
      name += '71';
    }

    return name;
  }

  getFedoraVersionString(os) {
    let name = 'rhel';
    const fedoraVer = parseInt(os.release, 10);

    if (fedoraVer > 18) {
      name += '70';
    } else if (fedoraVer < 19 && fedoraVer >= 12) {
      name += '62';
    } else if (fedoraVer < 12 && fedoraVer >= 6) {
      name += '55';
    }

    return name;
  }

  getRhelVersionString(os) {
    let name = 'rhel';
    const release = os.release;

    if (release) {
      if (/^7/.test(release)) {
        name += '70';
      } else if (/^6/.test(release)) {
        name += '62';
      } else if (/^5/.test(release)) {
        name += '55';
      }
    }

    return name;
  } // eslint-disable-next-line no-unused-vars


  getElementaryOSVersionString(os) {
    return 'ubuntu1404';
  } // eslint-disable-next-line no-unused-vars


  getMintVersionString(os) {
    // unfortunately getos doesn't return version for Mint
    return 'ubuntu1404';
  } // eslint-disable-next-line no-unused-vars


  getLegacyVersionString(os) {
    return '';
  }

  getSuseVersionString(os) {
    const _ref = os.release.match(/(^11|^12)/) || [null],
          _ref2 = _slicedToArray(_ref, 1),
          release = _ref2[0];

    if (release) {
      return `suse${release}`;
    }

    return '';
  }

  getUbuntuVersionString(os) {
    let name = 'ubuntu';
    const ubuntuVer = os.release ? os.release.split('.') : [];
    const majorVer = parseInt(ubuntuVer[0], 10); // const minorVer: string = ubuntuVer[1];

    if (os.release === '12.04') {
      name += '1204';
    } else if (os.release === '14.04') {
      name += '1404';
    } else if (os.release === '14.10') {
      name += '1410-clang';
    } else if (majorVer === 14) {
      name += '1404';
    } else if (os.release === '16.04') {
      name += '1604';
    } else if (majorVer === 16) {
      name += '1604';
    } else {
      name += '1404';
    }

    return name;
  }

  translatePlatform(platform) {
    switch (platform) {
      case 'darwin':
        return 'osx';

      case 'win32':
        return 'win32';

      case 'linux':
        return 'linux';

      case 'elementary OS':
        return 'linux';

      case 'sunos':
        return 'sunos5';

      default:
        throw new Error(`unsupported OS ${platform}`);
    }
  }

  translateArch(arch, mongoPlatform) {
    if (arch === 'ia32') {
      if (mongoPlatform === 'linux') {
        return 'i686';
      } else if (mongoPlatform === 'win32') {
        return 'i386';
      }

      throw new Error('unsupported architecture');
    } else if (arch === 'x64') {
      return 'x86_64';
    } else {
      throw new Error('unsupported architecture, ia32 and x64 are the only valid options');
    }
  }

}

exports.default = MongoBinaryDownloadUrl;