"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _os = _interopRequireDefault(require("os"));

var _path = _interopRequireDefault(require("path"));

var _lockfile = _interopRequireDefault(require("lockfile"));

var _mkdirp = _interopRequireDefault(require("mkdirp"));

var _MongoBinaryDownload = _interopRequireDefault(require("./MongoBinaryDownload"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MongoBinary {
  static getPath(opts = {}) {
    var _this = this;

    return _asyncToGenerator(function* () {
      var _process$env, _process$env2, _process$env3, _process$env4;

      const defaultOptions = {
        downloadDir: ((_process$env = process.env) === null || _process$env === void 0 ? void 0 : _process$env.MONGOMS_DOWNLOAD_DIR) || _path.default.resolve(_os.default.homedir(), '.mongodb-binaries'),
        platform: ((_process$env2 = process.env) === null || _process$env2 === void 0 ? void 0 : _process$env2.MONGOMS_PLATFORM) || _os.default.platform(),
        arch: ((_process$env3 = process.env) === null || _process$env3 === void 0 ? void 0 : _process$env3.MONGOMS_ARCH) || _os.default.arch(),
        version: ((_process$env4 = process.env) === null || _process$env4 === void 0 ? void 0 : _process$env4.MONGOMS_VERSION) || 'latest',
        debug: typeof process.env.MONGOMS_DEBUG === 'string' ? ['1', 'on', 'yes', 'true'].indexOf(process.env.MONGOMS_DEBUG.toLowerCase()) !== -1 : false
      };

      const _Object$assign = Object.assign({}, defaultOptions, opts),
            downloadDir = _Object$assign.downloadDir,
            platform = _Object$assign.platform,
            arch = _Object$assign.arch,
            version = _Object$assign.version;

      let debug;

      if (opts.debug) {
        if (opts.debug.call && typeof opts.debug === 'function' && opts.debug.apply) {
          debug = opts.debug;
        } else {
          debug = console.log.bind(null);
        }
      } else {
        debug = msg => {}; // eslint-disable-line

      }

      if (_this.cache[version]) {
        debug(`MongoBinary: found cached binary path for ${version}`);
      } else {
        // create downloadDir if not exists
        yield new Promise((resolve, reject) => {
          (0, _mkdirp.default)(downloadDir, err => {
            if (err) reject(err);else resolve();
          });
        });

        const lockfile = _path.default.resolve(downloadDir, `${version}.lock`); // wait lock


        yield new Promise((resolve, reject) => {
          _lockfile.default.lock(lockfile, {
            wait: 120000,
            pollPeriod: 100,
            stale: 110000,
            retries: 3,
            retryWait: 100
          }, err => {
            if (err) reject(err);else resolve();
          });
        }); // again check cache, maybe other instance resolve it

        if (!_this.cache[version]) {
          const downloader = new _MongoBinaryDownload.default({
            downloadDir,
            platform,
            arch,
            version
          });
          downloader.debug = debug;
          _this.cache[version] = yield downloader.getMongodPath();
        } // remove lock


        _lockfile.default.unlock(lockfile, err => {
          debug(err ? `MongoBinary: Error when removing download lock ${err}` : `MongoBinary: Download lock removed`);
        });
      }

      debug(`MongoBinary: Mongod binary path: ${_this.cache[version]}`);
      return _this.cache[version];
    })();
  }

  static hasValidBinPath(files) {
    if (files.length === 1) {
      return true;
    } else if (files.length > 1) {
      return false;
    }

    return false;
  }

}

exports.default = MongoBinary;

_defineProperty(MongoBinary, "cache", {});