package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GatherAppEnvStats invokes the webplus.GatherAppEnvStats API synchronously
// api document: https://help.aliyun.com/api/webplus/gatherappenvstats.html
func (client *Client) GatherAppEnvStats(request *GatherAppEnvStatsRequest) (response *GatherAppEnvStatsResponse, err error) {
	response = CreateGatherAppEnvStatsResponse()
	err = client.DoAction(request, response)
	return
}

// GatherAppEnvStatsWithChan invokes the webplus.GatherAppEnvStats API asynchronously
// api document: https://help.aliyun.com/api/webplus/gatherappenvstats.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GatherAppEnvStatsWithChan(request *GatherAppEnvStatsRequest) (<-chan *GatherAppEnvStatsResponse, <-chan error) {
	responseChan := make(chan *GatherAppEnvStatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GatherAppEnvStats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GatherAppEnvStatsWithCallback invokes the webplus.GatherAppEnvStats API asynchronously
// api document: https://help.aliyun.com/api/webplus/gatherappenvstats.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GatherAppEnvStatsWithCallback(request *GatherAppEnvStatsRequest, callback func(response *GatherAppEnvStatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GatherAppEnvStatsResponse
		var err error
		defer close(result)
		response, err = client.GatherAppEnvStats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GatherAppEnvStatsRequest is the request struct for api GatherAppEnvStats
type GatherAppEnvStatsRequest struct {
	*requests.RoaRequest
	TargetInstances string `position:"Body" name:"TargetInstances"`
	EnvId           string `position:"Body" name:"EnvId"`
}

// GatherAppEnvStatsResponse is the response struct for api GatherAppEnvStats
type GatherAppEnvStatsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	EnvChange EnvChange `json:"EnvChange" xml:"EnvChange"`
}

// CreateGatherAppEnvStatsRequest creates a request to invoke GatherAppEnvStats API
func CreateGatherAppEnvStatsRequest() (request *GatherAppEnvStatsRequest) {
	request = &GatherAppEnvStatsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "GatherAppEnvStats", "/pop/v1/wam/appEnv/gatherStats", "webx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGatherAppEnvStatsResponse creates a response to parse from GatherAppEnvStats response
func CreateGatherAppEnvStatsResponse() (response *GatherAppEnvStatsResponse) {
	response = &GatherAppEnvStatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
