package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeChange invokes the webplus.DescribeChange API synchronously
// api document: https://help.aliyun.com/api/webplus/describechange.html
func (client *Client) DescribeChange(request *DescribeChangeRequest) (response *DescribeChangeResponse, err error) {
	response = CreateDescribeChangeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeChangeWithChan invokes the webplus.DescribeChange API asynchronously
// api document: https://help.aliyun.com/api/webplus/describechange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeWithChan(request *DescribeChangeRequest) (<-chan *DescribeChangeResponse, <-chan error) {
	responseChan := make(chan *DescribeChangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeChange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeChangeWithCallback invokes the webplus.DescribeChange API asynchronously
// api document: https://help.aliyun.com/api/webplus/describechange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeWithCallback(request *DescribeChangeRequest, callback func(response *DescribeChangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeChangeResponse
		var err error
		defer close(result)
		response, err = client.DescribeChange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeChangeRequest is the request struct for api DescribeChange
type DescribeChangeRequest struct {
	*requests.RoaRequest
	EnvId    string `position:"Query" name:"EnvId"`
	ChangeId string `position:"Query" name:"ChangeId"`
}

// DescribeChangeResponse is the response struct for api DescribeChange
type DescribeChangeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Change    Change `json:"Change" xml:"Change"`
}

// CreateDescribeChangeRequest creates a request to invoke DescribeChange API
func CreateDescribeChangeRequest() (request *DescribeChangeRequest) {
	request = &DescribeChangeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeChange", "/pop/v1/wam/changeInfo", "webx", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeChangeResponse creates a response to parse from DescribeChange response
func CreateDescribeChangeResponse() (response *DescribeChangeResponse) {
	response = &DescribeChangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
