package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveAppResource invokes the vod.MoveAppResource API synchronously
// api document: https://help.aliyun.com/api/vod/moveappresource.html
func (client *Client) MoveAppResource(request *MoveAppResourceRequest) (response *MoveAppResourceResponse, err error) {
	response = CreateMoveAppResourceResponse()
	err = client.DoAction(request, response)
	return
}

// MoveAppResourceWithChan invokes the vod.MoveAppResource API asynchronously
// api document: https://help.aliyun.com/api/vod/moveappresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoveAppResourceWithChan(request *MoveAppResourceRequest) (<-chan *MoveAppResourceResponse, <-chan error) {
	responseChan := make(chan *MoveAppResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveAppResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveAppResourceWithCallback invokes the vod.MoveAppResource API asynchronously
// api document: https://help.aliyun.com/api/vod/moveappresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoveAppResourceWithCallback(request *MoveAppResourceRequest, callback func(response *MoveAppResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveAppResourceResponse
		var err error
		defer close(result)
		response, err = client.MoveAppResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveAppResourceRequest is the request struct for api MoveAppResource
type MoveAppResourceRequest struct {
	*requests.RpcRequest
	TargetAppId          string           `position:"Query" name:"TargetAppId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceRealOwnerId  requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	ResourceIds          string           `position:"Query" name:"ResourceIds"`
}

// MoveAppResourceResponse is the response struct for api MoveAppResource
type MoveAppResourceResponse struct {
	*responses.BaseResponse
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	NonExistResourceIds []string `json:"NonExistResourceIds" xml:"NonExistResourceIds"`
	FailedResourceIds   []string `json:"FailedResourceIds" xml:"FailedResourceIds"`
}

// CreateMoveAppResourceRequest creates a request to invoke MoveAppResource API
func CreateMoveAppResourceRequest() (request *MoveAppResourceRequest) {
	request = &MoveAppResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "MoveAppResource", "vod", "openAPI")
	return
}

// CreateMoveAppResourceResponse creates a response to parse from MoveAppResource response
func CreateMoveAppResourceResponse() (response *MoveAppResourceResponse) {
	response = &MoveAppResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
