package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodCertificateList invokes the vod.DescribeVodCertificateList API synchronously
// api document: https://help.aliyun.com/api/vod/describevodcertificatelist.html
func (client *Client) DescribeVodCertificateList(request *DescribeVodCertificateListRequest) (response *DescribeVodCertificateListResponse, err error) {
	response = CreateDescribeVodCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodCertificateListWithChan invokes the vod.DescribeVodCertificateList API asynchronously
// api document: https://help.aliyun.com/api/vod/describevodcertificatelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVodCertificateListWithChan(request *DescribeVodCertificateListRequest) (<-chan *DescribeVodCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeVodCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodCertificateListWithCallback invokes the vod.DescribeVodCertificateList API asynchronously
// api document: https://help.aliyun.com/api/vod/describevodcertificatelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVodCertificateListWithCallback(request *DescribeVodCertificateListRequest, callback func(response *DescribeVodCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodCertificateListRequest is the request struct for api DescribeVodCertificateList
type DescribeVodCertificateListRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodCertificateListResponse is the response struct for api DescribeVodCertificateList
type DescribeVodCertificateListResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CertificateListModel CertificateListModel `json:"CertificateListModel" xml:"CertificateListModel"`
}

// CreateDescribeVodCertificateListRequest creates a request to invoke DescribeVodCertificateList API
func CreateDescribeVodCertificateListRequest() (request *DescribeVodCertificateListRequest) {
	request = &DescribeVodCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodCertificateList", "vod", "openAPI")
	return
}

// CreateDescribeVodCertificateListResponse creates a response to parse from DescribeVodCertificateList response
func CreateDescribeVodCertificateListResponse() (response *DescribeVodCertificateListResponse) {
	response = &DescribeVodCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
