package push

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindTag invokes the push.BindTag API synchronously
// api document: https://help.aliyun.com/api/push/bindtag.html
func (client *Client) BindTag(request *BindTagRequest) (response *BindTagResponse, err error) {
	response = CreateBindTagResponse()
	err = client.DoAction(request, response)
	return
}

// BindTagWithChan invokes the push.BindTag API asynchronously
// api document: https://help.aliyun.com/api/push/bindtag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindTagWithChan(request *BindTagRequest) (<-chan *BindTagResponse, <-chan error) {
	responseChan := make(chan *BindTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindTagWithCallback invokes the push.BindTag API asynchronously
// api document: https://help.aliyun.com/api/push/bindtag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindTagWithCallback(request *BindTagRequest, callback func(response *BindTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindTagResponse
		var err error
		defer close(result)
		response, err = client.BindTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindTagRequest is the request struct for api BindTag
type BindTagRequest struct {
	*requests.RpcRequest
	TagName   string           `position:"Query" name:"TagName"`
	ClientKey string           `position:"Query" name:"ClientKey"`
	AppKey    requests.Integer `position:"Query" name:"AppKey"`
	KeyType   string           `position:"Query" name:"KeyType"`
}

// BindTagResponse is the response struct for api BindTag
type BindTagResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindTagRequest creates a request to invoke BindTag API
func CreateBindTagRequest() (request *BindTagRequest) {
	request = &BindTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Push", "2016-08-01", "BindTag", "push", "openAPI")
	return
}

// CreateBindTagResponse creates a response to parse from BindTag response
func CreateBindTagResponse() (response *BindTagResponse) {
	response = &BindTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
