package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnlockDBClusterDeletion invokes the polardb.UnlockDBClusterDeletion API synchronously
// api document: https://help.aliyun.com/api/polardb/unlockdbclusterdeletion.html
func (client *Client) UnlockDBClusterDeletion(request *UnlockDBClusterDeletionRequest) (response *UnlockDBClusterDeletionResponse, err error) {
	response = CreateUnlockDBClusterDeletionResponse()
	err = client.DoAction(request, response)
	return
}

// UnlockDBClusterDeletionWithChan invokes the polardb.UnlockDBClusterDeletion API asynchronously
// api document: https://help.aliyun.com/api/polardb/unlockdbclusterdeletion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnlockDBClusterDeletionWithChan(request *UnlockDBClusterDeletionRequest) (<-chan *UnlockDBClusterDeletionResponse, <-chan error) {
	responseChan := make(chan *UnlockDBClusterDeletionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnlockDBClusterDeletion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnlockDBClusterDeletionWithCallback invokes the polardb.UnlockDBClusterDeletion API asynchronously
// api document: https://help.aliyun.com/api/polardb/unlockdbclusterdeletion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnlockDBClusterDeletionWithCallback(request *UnlockDBClusterDeletionRequest, callback func(response *UnlockDBClusterDeletionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnlockDBClusterDeletionResponse
		var err error
		defer close(result)
		response, err = client.UnlockDBClusterDeletion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnlockDBClusterDeletionRequest is the request struct for api UnlockDBClusterDeletion
type UnlockDBClusterDeletionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// UnlockDBClusterDeletionResponse is the response struct for api UnlockDBClusterDeletion
type UnlockDBClusterDeletionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnlockDBClusterDeletionRequest creates a request to invoke UnlockDBClusterDeletion API
func CreateUnlockDBClusterDeletionRequest() (request *UnlockDBClusterDeletionRequest) {
	request = &UnlockDBClusterDeletionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "UnlockDBClusterDeletion", "polardb", "openAPI")
	return
}

// CreateUnlockDBClusterDeletionResponse creates a response to parse from UnlockDBClusterDeletion response
func CreateUnlockDBClusterDeletionResponse() (response *UnlockDBClusterDeletionResponse) {
	response = &UnlockDBClusterDeletionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
