package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamsNotifyUrlConfig invokes the live.DescribeLiveStreamsNotifyUrlConfig API synchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsnotifyurlconfig.html
func (client *Client) DescribeLiveStreamsNotifyUrlConfig(request *DescribeLiveStreamsNotifyUrlConfigRequest) (response *DescribeLiveStreamsNotifyUrlConfigResponse, err error) {
	response = CreateDescribeLiveStreamsNotifyUrlConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamsNotifyUrlConfigWithChan invokes the live.DescribeLiveStreamsNotifyUrlConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsnotifyurlconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsNotifyUrlConfigWithChan(request *DescribeLiveStreamsNotifyUrlConfigRequest) (<-chan *DescribeLiveStreamsNotifyUrlConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamsNotifyUrlConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamsNotifyUrlConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamsNotifyUrlConfigWithCallback invokes the live.DescribeLiveStreamsNotifyUrlConfig API asynchronously
// api document: https://help.aliyun.com/api/live/describelivestreamsnotifyurlconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsNotifyUrlConfigWithCallback(request *DescribeLiveStreamsNotifyUrlConfigRequest, callback func(response *DescribeLiveStreamsNotifyUrlConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamsNotifyUrlConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamsNotifyUrlConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamsNotifyUrlConfigRequest is the request struct for api DescribeLiveStreamsNotifyUrlConfig
type DescribeLiveStreamsNotifyUrlConfigRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamsNotifyUrlConfigResponse is the response struct for api DescribeLiveStreamsNotifyUrlConfig
type DescribeLiveStreamsNotifyUrlConfigResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	LiveStreamsNotifyConfig LiveStreamsNotifyConfig `json:"LiveStreamsNotifyConfig" xml:"LiveStreamsNotifyConfig"`
}

// CreateDescribeLiveStreamsNotifyUrlConfigRequest creates a request to invoke DescribeLiveStreamsNotifyUrlConfig API
func CreateDescribeLiveStreamsNotifyUrlConfigRequest() (request *DescribeLiveStreamsNotifyUrlConfigRequest) {
	request = &DescribeLiveStreamsNotifyUrlConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamsNotifyUrlConfig", "live", "openAPI")
	return
}

// CreateDescribeLiveStreamsNotifyUrlConfigResponse creates a response to parse from DescribeLiveStreamsNotifyUrlConfig response
func CreateDescribeLiveStreamsNotifyUrlConfigResponse() (response *DescribeLiveStreamsNotifyUrlConfigResponse) {
	response = &DescribeLiveStreamsNotifyUrlConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
