package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAlertDingDingGroup invokes the emr.ModifyAlertDingDingGroup API synchronously
// api document: https://help.aliyun.com/api/emr/modifyalertdingdinggroup.html
func (client *Client) ModifyAlertDingDingGroup(request *ModifyAlertDingDingGroupRequest) (response *ModifyAlertDingDingGroupResponse, err error) {
	response = CreateModifyAlertDingDingGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAlertDingDingGroupWithChan invokes the emr.ModifyAlertDingDingGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertdingdinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertDingDingGroupWithChan(request *ModifyAlertDingDingGroupRequest) (<-chan *ModifyAlertDingDingGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyAlertDingDingGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAlertDingDingGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAlertDingDingGroupWithCallback invokes the emr.ModifyAlertDingDingGroup API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyalertdingdinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyAlertDingDingGroupWithCallback(request *ModifyAlertDingDingGroupRequest, callback func(response *ModifyAlertDingDingGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAlertDingDingGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyAlertDingDingGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAlertDingDingGroupRequest is the request struct for api ModifyAlertDingDingGroup
type ModifyAlertDingDingGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BizId           string           `position:"Query" name:"BizId"`
	Name            string           `position:"Query" name:"Name"`
	Description     string           `position:"Query" name:"Description"`
	WebHookUrl      string           `position:"Query" name:"WebHookUrl"`
}

// ModifyAlertDingDingGroupResponse is the response struct for api ModifyAlertDingDingGroup
type ModifyAlertDingDingGroupResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateModifyAlertDingDingGroupRequest creates a request to invoke ModifyAlertDingDingGroup API
func CreateModifyAlertDingDingGroupRequest() (request *ModifyAlertDingDingGroupRequest) {
	request = &ModifyAlertDingDingGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyAlertDingDingGroup", "emr", "openAPI")
	return
}

// CreateModifyAlertDingDingGroupResponse creates a response to parse from ModifyAlertDingDingGroup response
func CreateModifyAlertDingDingGroupResponse() (response *ModifyAlertDingDingGroupResponse) {
	response = &ModifyAlertDingDingGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
