package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBlackIps invokes the elasticsearch.UpdateBlackIps API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/updateblackips.html
func (client *Client) UpdateBlackIps(request *UpdateBlackIpsRequest) (response *UpdateBlackIpsResponse, err error) {
	response = CreateUpdateBlackIpsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBlackIpsWithChan invokes the elasticsearch.UpdateBlackIps API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updateblackips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateBlackIpsWithChan(request *UpdateBlackIpsRequest) (<-chan *UpdateBlackIpsResponse, <-chan error) {
	responseChan := make(chan *UpdateBlackIpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBlackIps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBlackIpsWithCallback invokes the elasticsearch.UpdateBlackIps API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/updateblackips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateBlackIpsWithCallback(request *UpdateBlackIpsRequest, callback func(response *UpdateBlackIpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBlackIpsResponse
		var err error
		defer close(result)
		response, err = client.UpdateBlackIps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBlackIpsRequest is the request struct for api UpdateBlackIps
type UpdateBlackIpsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// UpdateBlackIpsResponse is the response struct for api UpdateBlackIps
type UpdateBlackIpsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateUpdateBlackIpsRequest creates a request to invoke UpdateBlackIps API
func CreateUpdateBlackIpsRequest() (request *UpdateBlackIpsRequest) {
	request = &UpdateBlackIpsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateBlackIps", "/openapi/instances/[InstanceId]/black-ips", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBlackIpsResponse creates a response to parse from UpdateBlackIps response
func CreateUpdateBlackIpsResponse() (response *UpdateBlackIpsResponse) {
	response = &UpdateBlackIpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
