package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthority invokes the edas.ListAuthority API synchronously
// api document: https://help.aliyun.com/api/edas/listauthority.html
func (client *Client) ListAuthority(request *ListAuthorityRequest) (response *ListAuthorityResponse, err error) {
	response = CreateListAuthorityResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthorityWithChan invokes the edas.ListAuthority API asynchronously
// api document: https://help.aliyun.com/api/edas/listauthority.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAuthorityWithChan(request *ListAuthorityRequest) (<-chan *ListAuthorityResponse, <-chan error) {
	responseChan := make(chan *ListAuthorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthorityWithCallback invokes the edas.ListAuthority API asynchronously
// api document: https://help.aliyun.com/api/edas/listauthority.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAuthorityWithCallback(request *ListAuthorityRequest, callback func(response *ListAuthorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthorityResponse
		var err error
		defer close(result)
		response, err = client.ListAuthority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthorityRequest is the request struct for api ListAuthority
type ListAuthorityRequest struct {
	*requests.RoaRequest
}

// ListAuthorityResponse is the response struct for api ListAuthority
type ListAuthorityResponse struct {
	*responses.BaseResponse
	Code          int           `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	AuthorityList AuthorityList `json:"AuthorityList" xml:"AuthorityList"`
}

// CreateListAuthorityRequest creates a request to invoke ListAuthority API
func CreateListAuthorityRequest() (request *ListAuthorityRequest) {
	request = &ListAuthorityRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListAuthority", "/pop/v5/account/authority_list", "", "")
	request.Method = requests.POST
	return
}

// CreateListAuthorityResponse creates a response to parse from ListAuthority response
func CreateListAuthorityResponse() (response *ListAuthorityResponse) {
	response = &ListAuthorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
