//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeContainerGroupPrice invokes the eci.DescribeContainerGroupPrice API synchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupprice.html
func (client *Client) DescribeContainerGroupPrice(request *DescribeContainerGroupPriceRequest) (response *DescribeContainerGroupPriceResponse, err error) {
	response = CreateDescribeContainerGroupPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeContainerGroupPriceWithChan invokes the eci.DescribeContainerGroupPrice API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerGroupPriceWithChan(request *DescribeContainerGroupPriceRequest) (<-chan *DescribeContainerGroupPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeContainerGroupPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeContainerGroupPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeContainerGroupPriceWithCallback invokes the eci.DescribeContainerGroupPrice API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerGroupPriceWithCallback(request *DescribeContainerGroupPriceRequest, callback func(response *DescribeContainerGroupPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeContainerGroupPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeContainerGroupPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeContainerGroupPriceRequest is the request struct for api DescribeContainerGroupPrice
type DescribeContainerGroupPriceRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	Cpu                  requests.Float   `position:"Query" name:"Cpu"`
	Memory               requests.Float   `position:"Query" name:"Memory"`
}

// DescribeContainerGroupPriceResponse is the response struct for api DescribeContainerGroupPrice
type DescribeContainerGroupPriceResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	PriceInfo DescribeContainerGroupPricePriceInfo0 `json:"PriceInfo" xml:"PriceInfo"`
}

type DescribeContainerGroupPricePriceInfo0 struct {
	Rules []DescribeContainerGroupPriceRules1 `json:"Rules" xml:"Rules"`
	Price DescribeContainerGroupPricePrice1   `json:"Price" xml:"Price"`
}

type DescribeContainerGroupPriceRules1 struct {
	Rule []DescribeContainerGroupPriceRule2 `json:"Rule" xml:"Rule"`
}

type DescribeContainerGroupPriceRule2 struct {
	RuleId      int64  `json:"RuleId" xml:"RuleId"`
	Description string `json:"Description" xml:"Description"`
}

type DescribeContainerGroupPricePrice1 struct {
	OriginalPrice float32                                   `json:"OriginalPrice" xml:"OriginalPrice"`
	DiscountPrice float32                                   `json:"DiscountPrice" xml:"DiscountPrice"`
	TradePrice    float32                                   `json:"TradePrice" xml:"TradePrice"`
	Currency      string                                    `json:"Currency" xml:"Currency"`
	DetailInfos   []DescribeContainerGroupPriceDetailInfos2 `json:"DetailInfos" xml:"DetailInfos"`
}

type DescribeContainerGroupPriceDetailInfos2 struct {
	DetailInfo []DescribeContainerGroupPriceDetailInfo3 `json:"DetailInfo" xml:"DetailInfo"`
}

type DescribeContainerGroupPriceDetailInfo3 struct {
	Resource      string                              `json:"Resource" xml:"Resource"`
	OriginalPrice float32                             `json:"OriginalPrice" xml:"OriginalPrice"`
	DiscountPrice float32                             `json:"DiscountPrice" xml:"DiscountPrice"`
	TradePrice    float32                             `json:"TradePrice" xml:"TradePrice"`
	Rules         []DescribeContainerGroupPriceRules3 `json:"Rules" xml:"Rules"`
}

type DescribeContainerGroupPriceRules3 struct {
	Rule []DescribeContainerGroupPriceRule4 `json:"Rule" xml:"Rule"`
}

type DescribeContainerGroupPriceRule4 struct {
	RuleId      int64  `json:"RuleId" xml:"RuleId"`
	Description string `json:"Description" xml:"Description"`
}

// CreateDescribeContainerGroupPriceRequest creates a request to invoke DescribeContainerGroupPrice API
func CreateDescribeContainerGroupPriceRequest() (request *DescribeContainerGroupPriceRequest) {
	request = &DescribeContainerGroupPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "DescribeContainerGroupPrice", "eci", "openAPI")
	return
}

// CreateDescribeContainerGroupPriceResponse creates a response to parse from DescribeContainerGroupPrice response
func CreateDescribeContainerGroupPriceResponse() (response *DescribeContainerGroupPriceResponse) {
	response = &DescribeContainerGroupPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
