//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobStatus invokes the dts.DescribeMigrationJobStatus API synchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobstatus.html
func (client *Client) DescribeMigrationJobStatus(request *DescribeMigrationJobStatusRequest) (response *DescribeMigrationJobStatusResponse, err error) {
	response = CreateDescribeMigrationJobStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobStatusWithChan invokes the dts.DescribeMigrationJobStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobStatusWithChan(request *DescribeMigrationJobStatusRequest) (<-chan *DescribeMigrationJobStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobStatusWithCallback invokes the dts.DescribeMigrationJobStatus API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobStatusWithCallback(request *DescribeMigrationJobStatusRequest, callback func(response *DescribeMigrationJobStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobStatusRequest is the request struct for api DescribeMigrationJobStatus
type DescribeMigrationJobStatusRequest struct {
	*requests.RpcRequest
	MigrationJobId string `position:"Query" name:"MigrationJobId"`
	ClientToken    string `position:"Query" name:"ClientToken"`
	OwnerId        string `position:"Query" name:"OwnerId"`
}

// DescribeMigrationJobStatusResponse is the response struct for api DescribeMigrationJobStatus
type DescribeMigrationJobStatusResponse struct {
	*responses.BaseResponse
	MigrationJobId                string                                                   `json:"MigrationJobId" xml:"MigrationJobId"`
	MigrationJobName              string                                                   `json:"MigrationJobName" xml:"MigrationJobName"`
	PayType                       string                                                   `json:"PayType" xml:"PayType"`
	MigrationJobClass             string                                                   `json:"MigrationJobClass" xml:"MigrationJobClass"`
	MigrationObject               string                                                   `json:"MigrationObject" xml:"MigrationObject"`
	MigrationJobStatus            string                                                   `json:"MigrationJobStatus" xml:"MigrationJobStatus"`
	SourceEndpoint                DescribeMigrationJobStatusSourceEndpoint0                `json:"SourceEndpoint" xml:"SourceEndpoint"`
	DestinationEndpoint           DescribeMigrationJobStatusDestinationEndpoint0           `json:"DestinationEndpoint" xml:"DestinationEndpoint"`
	MigrationMode                 DescribeMigrationJobStatusMigrationMode0                 `json:"MigrationMode" xml:"MigrationMode"`
	PrecheckStatus                DescribeMigrationJobStatusPrecheckStatus0                `json:"PrecheckStatus" xml:"PrecheckStatus"`
	StructureInitializationStatus DescribeMigrationJobStatusStructureInitializationStatus0 `json:"StructureInitializationStatus" xml:"StructureInitializationStatus"`
	DataInitializationStatus      DescribeMigrationJobStatusDataInitializationStatus0      `json:"DataInitializationStatus" xml:"DataInitializationStatus"`
	DataSynchronizationStatus     DescribeMigrationJobStatusDataSynchronizationStatus0     `json:"DataSynchronizationStatus" xml:"DataSynchronizationStatus"`
}

type DescribeMigrationJobStatusSourceEndpoint0 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	DatabaseName string `json:"DatabaseName" xml:"DatabaseName"`
	OracleSID    string `json:"OracleSID" xml:"OracleSID"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeMigrationJobStatusDestinationEndpoint0 struct {
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	DatabaseName string `json:"DatabaseName" xml:"DatabaseName"`
	OracleSID    string `json:"OracleSID" xml:"OracleSID"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeMigrationJobStatusMigrationMode0 struct {
	StructureInitialization bool `json:"StructureInitialization" xml:"StructureInitialization"`
	DataInitialization      bool `json:"DataInitialization" xml:"DataInitialization"`
	DataSynchronization     bool `json:"DataSynchronization" xml:"DataSynchronization"`
}

type DescribeMigrationJobStatusPrecheckStatus0 struct {
	Status  string                              `json:"Status" xml:"Status"`
	Percent string                              `json:"Percent" xml:"Percent"`
	Detail  []DescribeMigrationJobStatusDetail1 `json:"Detail" xml:"Detail"`
}

type DescribeMigrationJobStatusStructureInitializationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeMigrationJobStatusDataInitializationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeMigrationJobStatusDataSynchronizationStatus0 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay        string `json:"Delay" xml:"Delay"`
	Checkpoint   string `json:"Checkpoint" xml:"Checkpoint"`
}

type DescribeMigrationJobStatusDetail1 struct {
	CheckItem []DescribeMigrationJobStatusCheckItem2 `json:"CheckItem" xml:"CheckItem"`
}

type DescribeMigrationJobStatusCheckItem2 struct {
	ItemName     string `json:"ItemName" xml:"ItemName"`
	CheckStatus  string `json:"CheckStatus" xml:"CheckStatus"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RepairMethod string `json:"RepairMethod" xml:"RepairMethod"`
}

// CreateDescribeMigrationJobStatusRequest creates a request to invoke DescribeMigrationJobStatus API
func CreateDescribeMigrationJobStatusRequest() (request *DescribeMigrationJobStatusRequest) {
	request = &DescribeMigrationJobStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeMigrationJobStatus", "dts", "openAPI")
	return
}

// CreateDescribeMigrationJobStatusResponse creates a response to parse from DescribeMigrationJobStatus response
func CreateDescribeMigrationJobStatusResponse() (response *DescribeMigrationJobStatusResponse) {
	response = &DescribeMigrationJobStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
