package domain_intl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForDeletingDnsHost invokes the domain_intl.SaveSingleTaskForDeletingDnsHost API synchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskfordeletingdnshost.html
func (client *Client) SaveSingleTaskForDeletingDnsHost(request *SaveSingleTaskForDeletingDnsHostRequest) (response *SaveSingleTaskForDeletingDnsHostResponse, err error) {
	response = CreateSaveSingleTaskForDeletingDnsHostResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForDeletingDnsHostWithChan invokes the domain_intl.SaveSingleTaskForDeletingDnsHost API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskfordeletingdnshost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSingleTaskForDeletingDnsHostWithChan(request *SaveSingleTaskForDeletingDnsHostRequest) (<-chan *SaveSingleTaskForDeletingDnsHostResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForDeletingDnsHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForDeletingDnsHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForDeletingDnsHostWithCallback invokes the domain_intl.SaveSingleTaskForDeletingDnsHost API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/savesingletaskfordeletingdnshost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSingleTaskForDeletingDnsHostWithCallback(request *SaveSingleTaskForDeletingDnsHostRequest, callback func(response *SaveSingleTaskForDeletingDnsHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForDeletingDnsHostResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForDeletingDnsHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForDeletingDnsHostRequest is the request struct for api SaveSingleTaskForDeletingDnsHost
type SaveSingleTaskForDeletingDnsHostRequest struct {
	*requests.RpcRequest
	InstanceId   string    `position:"Query" name:"InstanceId"`
	Ip           *[]string `position:"Query" name:"Ip"  type:"Repeated"`
	DnsName      string    `position:"Query" name:"DnsName"`
	UserClientIp string    `position:"Query" name:"UserClientIp"`
	Lang         string    `position:"Query" name:"Lang"`
}

// SaveSingleTaskForDeletingDnsHostResponse is the response struct for api SaveSingleTaskForDeletingDnsHost
type SaveSingleTaskForDeletingDnsHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForDeletingDnsHostRequest creates a request to invoke SaveSingleTaskForDeletingDnsHost API
func CreateSaveSingleTaskForDeletingDnsHostRequest() (request *SaveSingleTaskForDeletingDnsHostRequest) {
	request = &SaveSingleTaskForDeletingDnsHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain-intl", "2017-12-18", "SaveSingleTaskForDeletingDnsHost", "domain", "openAPI")
	return
}

// CreateSaveSingleTaskForDeletingDnsHostResponse creates a response to parse from SaveSingleTaskForDeletingDnsHost response
func CreateSaveSingleTaskForDeletingDnsHostResponse() (response *SaveSingleTaskForDeletingDnsHostResponse) {
	response = &SaveSingleTaskForDeletingDnsHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
