package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonitoringConfig invokes the cms.DescribeMonitoringConfig API synchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringconfig.html
func (client *Client) DescribeMonitoringConfig(request *DescribeMonitoringConfigRequest) (response *DescribeMonitoringConfigResponse, err error) {
	response = CreateDescribeMonitoringConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonitoringConfigWithChan invokes the cms.DescribeMonitoringConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonitoringConfigWithChan(request *DescribeMonitoringConfigRequest) (<-chan *DescribeMonitoringConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeMonitoringConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonitoringConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonitoringConfigWithCallback invokes the cms.DescribeMonitoringConfig API asynchronously
// api document: https://help.aliyun.com/api/cms/describemonitoringconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMonitoringConfigWithCallback(request *DescribeMonitoringConfigRequest, callback func(response *DescribeMonitoringConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonitoringConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonitoringConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonitoringConfigRequest is the request struct for api DescribeMonitoringConfig
type DescribeMonitoringConfigRequest struct {
	*requests.RpcRequest
}

// DescribeMonitoringConfigResponse is the response struct for api DescribeMonitoringConfig
type DescribeMonitoringConfigResponse struct {
	*responses.BaseResponse
	Code                     string `json:"Code" xml:"Code"`
	Message                  string `json:"Message" xml:"Message"`
	Success                  bool   `json:"Success" xml:"Success"`
	RequestId                string `json:"RequestId" xml:"RequestId"`
	AutoInstall              bool   `json:"AutoInstall" xml:"AutoInstall"`
	EnableInstallAgentNewECS bool   `json:"EnableInstallAgentNewECS" xml:"EnableInstallAgentNewECS"`
}

// CreateDescribeMonitoringConfigRequest creates a request to invoke DescribeMonitoringConfig API
func CreateDescribeMonitoringConfigRequest() (request *DescribeMonitoringConfigRequest) {
	request = &DescribeMonitoringConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMonitoringConfig", "cms", "openAPI")
	return
}

// CreateDescribeMonitoringConfigResponse creates a response to parse from DescribeMonitoringConfig response
func CreateDescribeMonitoringConfigResponse() (response *DescribeMonitoringConfigResponse) {
	response = &DescribeMonitoringConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
