package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBusinesses invokes the cloudwf.ListBusinesses API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinesses.html
func (client *Client) ListBusinesses(request *ListBusinessesRequest) (response *ListBusinessesResponse, err error) {
	response = CreateListBusinessesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBusinessesWithChan invokes the cloudwf.ListBusinesses API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinesses.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBusinessesWithChan(request *ListBusinessesRequest) (<-chan *ListBusinessesResponse, <-chan error) {
	responseChan := make(chan *ListBusinessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBusinesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBusinessesWithCallback invokes the cloudwf.ListBusinesses API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinesses.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBusinessesWithCallback(request *ListBusinessesRequest, callback func(response *ListBusinessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBusinessesResponse
		var err error
		defer close(result)
		response, err = client.ListBusinesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBusinessesRequest is the request struct for api ListBusinesses
type ListBusinessesRequest struct {
	*requests.RpcRequest
}

// ListBusinessesResponse is the response struct for api ListBusinesses
type ListBusinessesResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	Success   bool           `json:"Success" xml:"Success"`
	Message   string         `json:"Message" xml:"Message"`
	ErrorCode int            `json:"ErrorCode" xml:"ErrorCode"`
	Data      []BusinessInfo `json:"data" xml:"data"`
}

// CreateListBusinessesRequest creates a request to invoke ListBusinesses API
func CreateListBusinessesRequest() (request *ListBusinessesRequest) {
	request = &ListBusinessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListBusinesses", "cloudwf", "openAPI")
	return
}

// CreateListBusinessesResponse creates a response to parse from ListBusinesses response
func CreateListBusinessesResponse() (response *ListBusinessesResponse) {
	response = &ListBusinessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
